/*
 * Decompiled with CFR 0.152.
 */
package org.j4me.util;

public final class MathFunc {
    private static final double PIover2 = 1.5707963267948966;
    private static final double PIover4 = 0.7853981633974483;
    private static final double PIover6 = 0.5235987755982988;
    private static final double PIover12 = 0.2617993877991494;
    private static final double ATAN_CONSTANT = 1.732050807569;

    public static double acos(double a) {
        if (Double.isNaN(a) || Math.abs(a) > 1.0) {
            return Double.NaN;
        }
        double aSquared = a * a;
        double arcCosine = MathFunc.atan2(Math.sqrt(1.0 - aSquared), a);
        return arcCosine;
    }

    public static double asin(double a) {
        if (Double.isNaN(a) || Math.abs(a) > 1.0) {
            return Double.NaN;
        }
        if (a == 0.0) {
            return a;
        }
        double aSquared = a * a;
        double arcSine = MathFunc.atan2(a, Math.sqrt(1.0 - aSquared));
        return arcSine;
    }

    public static double atan(double a) {
        if (Double.isNaN(a)) {
            return Double.NaN;
        }
        if (a == 0.0) {
            return a;
        }
        boolean negative = false;
        boolean greaterThanOne = false;
        int i = 0;
        if (a < 0.0) {
            a = -a;
            negative = true;
        }
        if (a > 1.0) {
            a = 1.0 / a;
            greaterThanOne = true;
        }
        while (a > 0.2617993877991494) {
            ++i;
            double t = a + 1.732050807569;
            t = 1.0 / t;
            a *= 1.732050807569;
            a -= 1.0;
            a *= t;
        }
        double aSquared = a * a;
        double arcTangent = aSquared + 1.4087812;
        arcTangent = 0.55913709 / arcTangent;
        arcTangent += 0.60310579;
        arcTangent -= 0.05160454 * aSquared;
        arcTangent *= a;
        while (i > 0) {
            arcTangent += 0.5235987755982988;
            --i;
        }
        if (greaterThanOne) {
            arcTangent = 1.5707963267948966 - arcTangent;
        }
        if (negative) {
            arcTangent = -arcTangent;
        }
        return arcTangent;
    }

    public static double atan2(double y, double x) {
        double arcTangent;
        if (Double.isNaN(y) || Double.isNaN(x)) {
            return Double.NaN;
        }
        if (Double.isInfinite(y)) {
            if (y > 0.0) {
                if (Double.isInfinite(x)) {
                    if (x > 0.0) {
                        return 0.7853981633974483;
                    }
                    return 2.356194490192345;
                }
                if (x != 0.0) {
                    return 1.5707963267948966;
                }
            } else {
                if (Double.isInfinite(x)) {
                    if (x > 0.0) {
                        return -0.7853981633974483;
                    }
                    return -2.356194490192345;
                }
                if (x != 0.0) {
                    return -1.5707963267948966;
                }
            }
        } else if (y == 0.0) {
            if (x > 0.0) {
                return y;
            }
            if (x < 0.0) {
                return Math.PI;
            }
        } else if (Double.isInfinite(x)) {
            if (x > 0.0) {
                if (y > 0.0) {
                    return 0.0;
                }
                if (y < 0.0) {
                    return -0.0;
                }
            } else {
                if (y > 0.0) {
                    return Math.PI;
                }
                if (y < 0.0) {
                    return -Math.PI;
                }
            }
        } else if (x == 0.0) {
            if (y > 0.0) {
                return 1.5707963267948966;
            }
            if (y < 0.0) {
                return -1.5707963267948966;
            }
        }
        arcTangent = Math.abs(x) > Math.abs(y) ? MathFunc.atan(y / x) : ((arcTangent = MathFunc.atan(x / y)) < 0.0 ? -1.5707963267948966 - arcTangent : 1.5707963267948966 - arcTangent);
        if (x < 0.0) {
            arcTangent = y < 0.0 ? (arcTangent -= Math.PI) : (arcTangent += Math.PI);
        }
        return arcTangent;
    }

    public static int round(float a) {
        return (int)Math.floor(a + 0.5f);
    }

    public static long round(double a) {
        return (long)Math.floor(a + 0.5);
    }
}

