/*
 * Decompiled with CFR 0.152.
 */
package java.util;

import java.security.AccessController;
import java.security.SecureRandom;
import java.util.Spliterator;
import java.util.concurrent.atomic.AtomicLong;
import java.util.function.DoubleConsumer;
import java.util.function.IntConsumer;
import java.util.function.LongConsumer;
import java.util.stream.DoubleStream;
import java.util.stream.IntStream;
import java.util.stream.LongStream;
import java.util.stream.StreamSupport;
import sun.security.action.GetPropertyAction;

public final class SplittableRandom {
    private static final long GOLDEN_GAMMA = -7046029254386353131L;
    private static final double DOUBLE_UNIT = (double)1.110223E-16f;
    private long seed;
    private final long gamma;
    private static final AtomicLong defaultGen = new AtomicLong(SplittableRandom.initialSeed());
    static final String BadBound = "bound must be positive";
    static final String BadRange = "bound must be greater than origin";
    static final String BadSize = "size must be non-negative";

    private SplittableRandom(long l, long l2) {
        this.seed = l;
        this.gamma = l2;
    }

    private static long mix64(long l) {
        l = (l ^ l >>> 30) * -4658895280553007687L;
        l = (l ^ l >>> 27) * -7723592293110705685L;
        return l ^ l >>> 31;
    }

    private static int mix32(long l) {
        l = (l ^ l >>> 33) * 7109453100751455733L;
        return (int)((l ^ l >>> 28) * -3808689974395783757L >>> 32);
    }

    private static long mixGamma(long l) {
        l = (l ^ l >>> 33) * -49064778989728563L;
        l = (l ^ l >>> 33) * -4265267296055464877L;
        int n = Long.bitCount((l = l ^ l >>> 33 | 1L) ^ l >>> 1);
        return n < 24 ? l ^ 0xAAAAAAAAAAAAAAAAL : l;
    }

    private long nextSeed() {
        return this.seed += this.gamma;
    }

    private static long initialSeed() {
        String string = AccessController.doPrivileged(new GetPropertyAction("java.util.secureRandomSeed"));
        if (string != null && string.equalsIgnoreCase("true")) {
            byte[] byArray = SecureRandom.getSeed(8);
            long l = (long)byArray[0] & 0xFFL;
            for (int i = 1; i < 8; ++i) {
                l = l << 8 | (long)byArray[i] & 0xFFL;
            }
            return l;
        }
        return SplittableRandom.mix64(System.currentTimeMillis()) ^ SplittableRandom.mix64(System.nanoTime());
    }

    final long internalNextLong(long l, long l2) {
        long l3 = SplittableRandom.mix64(this.nextSeed());
        if (l < l2) {
            long l4 = l2 - l;
            long l5 = l4 - 1L;
            if ((l4 & l5) == 0L) {
                l3 = (l3 & l5) + l;
            } else if (l4 > 0L) {
                long l6 = l3 >>> 1;
                while (l6 + l5 - (l3 = l6 % l4) < 0L) {
                    l6 = SplittableRandom.mix64(this.nextSeed()) >>> 1;
                }
                l3 += l;
            } else {
                while (l3 < l || l3 >= l2) {
                    l3 = SplittableRandom.mix64(this.nextSeed());
                }
            }
        }
        return l3;
    }

    final int internalNextInt(int n, int n2) {
        int n3 = SplittableRandom.mix32(this.nextSeed());
        if (n < n2) {
            int n4 = n2 - n;
            int n5 = n4 - 1;
            if ((n4 & n5) == 0) {
                n3 = (n3 & n5) + n;
            } else if (n4 > 0) {
                int n6 = n3 >>> 1;
                while (n6 + n5 - (n3 = n6 % n4) < 0) {
                    n6 = SplittableRandom.mix32(this.nextSeed()) >>> 1;
                }
                n3 += n;
            } else {
                while (n3 < n || n3 >= n2) {
                    n3 = SplittableRandom.mix32(this.nextSeed());
                }
            }
        }
        return n3;
    }

    final double internalNextDouble(double d, double d2) {
        double d3 = (double)(this.nextLong() >>> 11) * (double)1.110223E-16f;
        if (d < d2 && (d3 = d3 * (d2 - d) + d) >= d2) {
            d3 = Double.longBitsToDouble(Double.doubleToLongBits(d2) - 1L);
        }
        return d3;
    }

    public SplittableRandom(long l) {
        this(l, -7046029254386353131L);
    }

    public SplittableRandom() {
        long l = defaultGen.getAndAdd(4354685564936845354L);
        this.seed = SplittableRandom.mix64(l);
        this.gamma = SplittableRandom.mixGamma(l + -7046029254386353131L);
    }

    public SplittableRandom split() {
        return new SplittableRandom(this.nextLong(), SplittableRandom.mixGamma(this.nextSeed()));
    }

    public int nextInt() {
        return SplittableRandom.mix32(this.nextSeed());
    }

    public int nextInt(int n) {
        if (n <= 0) {
            throw new IllegalArgumentException(BadBound);
        }
        int n2 = SplittableRandom.mix32(this.nextSeed());
        int n3 = n - 1;
        if ((n & n3) == 0) {
            n2 &= n3;
        } else {
            int n4 = n2 >>> 1;
            while (n4 + n3 - (n2 = n4 % n) < 0) {
                n4 = SplittableRandom.mix32(this.nextSeed()) >>> 1;
            }
        }
        return n2;
    }

    public int nextInt(int n, int n2) {
        if (n >= n2) {
            throw new IllegalArgumentException(BadRange);
        }
        return this.internalNextInt(n, n2);
    }

    public long nextLong() {
        return SplittableRandom.mix64(this.nextSeed());
    }

    public long nextLong(long l) {
        if (l <= 0L) {
            throw new IllegalArgumentException(BadBound);
        }
        long l2 = SplittableRandom.mix64(this.nextSeed());
        long l3 = l - 1L;
        if ((l & l3) == 0L) {
            l2 &= l3;
        } else {
            long l4 = l2 >>> 1;
            while (l4 + l3 - (l2 = l4 % l) < 0L) {
                l4 = SplittableRandom.mix64(this.nextSeed()) >>> 1;
            }
        }
        return l2;
    }

    public long nextLong(long l, long l2) {
        if (l >= l2) {
            throw new IllegalArgumentException(BadRange);
        }
        return this.internalNextLong(l, l2);
    }

    public double nextDouble() {
        return (double)(SplittableRandom.mix64(this.nextSeed()) >>> 11) * (double)1.110223E-16f;
    }

    public double nextDouble(double d) {
        if (!(d > 0.0)) {
            throw new IllegalArgumentException(BadBound);
        }
        double d2 = (double)(SplittableRandom.mix64(this.nextSeed()) >>> 11) * (double)1.110223E-16f * d;
        return d2 < d ? d2 : Double.longBitsToDouble(Double.doubleToLongBits(d) - 1L);
    }

    public double nextDouble(double d, double d2) {
        if (!(d < d2)) {
            throw new IllegalArgumentException(BadRange);
        }
        return this.internalNextDouble(d, d2);
    }

    public boolean nextBoolean() {
        return SplittableRandom.mix32(this.nextSeed()) < 0;
    }

    public IntStream ints(long l) {
        if (l < 0L) {
            throw new IllegalArgumentException(BadSize);
        }
        return StreamSupport.intStream(new RandomIntsSpliterator(this, 0L, l, Integer.MAX_VALUE, 0), false);
    }

    public IntStream ints() {
        return StreamSupport.intStream(new RandomIntsSpliterator(this, 0L, Long.MAX_VALUE, Integer.MAX_VALUE, 0), false);
    }

    public IntStream ints(long l, int n, int n2) {
        if (l < 0L) {
            throw new IllegalArgumentException(BadSize);
        }
        if (n >= n2) {
            throw new IllegalArgumentException(BadRange);
        }
        return StreamSupport.intStream(new RandomIntsSpliterator(this, 0L, l, n, n2), false);
    }

    public IntStream ints(int n, int n2) {
        if (n >= n2) {
            throw new IllegalArgumentException(BadRange);
        }
        return StreamSupport.intStream(new RandomIntsSpliterator(this, 0L, Long.MAX_VALUE, n, n2), false);
    }

    public LongStream longs(long l) {
        if (l < 0L) {
            throw new IllegalArgumentException(BadSize);
        }
        return StreamSupport.longStream(new RandomLongsSpliterator(this, 0L, l, Long.MAX_VALUE, 0L), false);
    }

    public LongStream longs() {
        return StreamSupport.longStream(new RandomLongsSpliterator(this, 0L, Long.MAX_VALUE, Long.MAX_VALUE, 0L), false);
    }

    public LongStream longs(long l, long l2, long l3) {
        if (l < 0L) {
            throw new IllegalArgumentException(BadSize);
        }
        if (l2 >= l3) {
            throw new IllegalArgumentException(BadRange);
        }
        return StreamSupport.longStream(new RandomLongsSpliterator(this, 0L, l, l2, l3), false);
    }

    public LongStream longs(long l, long l2) {
        if (l >= l2) {
            throw new IllegalArgumentException(BadRange);
        }
        return StreamSupport.longStream(new RandomLongsSpliterator(this, 0L, Long.MAX_VALUE, l, l2), false);
    }

    public DoubleStream doubles(long l) {
        if (l < 0L) {
            throw new IllegalArgumentException(BadSize);
        }
        return StreamSupport.doubleStream(new RandomDoublesSpliterator(this, 0L, l, Double.MAX_VALUE, 0.0), false);
    }

    public DoubleStream doubles() {
        return StreamSupport.doubleStream(new RandomDoublesSpliterator(this, 0L, Long.MAX_VALUE, Double.MAX_VALUE, 0.0), false);
    }

    public DoubleStream doubles(long l, double d, double d2) {
        if (l < 0L) {
            throw new IllegalArgumentException(BadSize);
        }
        if (!(d < d2)) {
            throw new IllegalArgumentException(BadRange);
        }
        return StreamSupport.doubleStream(new RandomDoublesSpliterator(this, 0L, l, d, d2), false);
    }

    public DoubleStream doubles(double d, double d2) {
        if (!(d < d2)) {
            throw new IllegalArgumentException(BadRange);
        }
        return StreamSupport.doubleStream(new RandomDoublesSpliterator(this, 0L, Long.MAX_VALUE, d, d2), false);
    }

    static final class RandomDoublesSpliterator
    implements Spliterator.OfDouble {
        final SplittableRandom rng;
        long index;
        final long fence;
        final double origin;
        final double bound;

        RandomDoublesSpliterator(SplittableRandom splittableRandom, long l, long l2, double d, double d2) {
            this.rng = splittableRandom;
            this.index = l;
            this.fence = l2;
            this.origin = d;
            this.bound = d2;
        }

        @Override
        public RandomDoublesSpliterator trySplit() {
            RandomDoublesSpliterator randomDoublesSpliterator;
            long l = this.index;
            long l2 = l + this.fence >>> 1;
            if (l2 <= l) {
                randomDoublesSpliterator = null;
            } else {
                this.index = l2;
                RandomDoublesSpliterator randomDoublesSpliterator2 = new RandomDoublesSpliterator(this.rng.split(), l, this.index, this.origin, this.bound);
                randomDoublesSpliterator = randomDoublesSpliterator2;
            }
            return randomDoublesSpliterator;
        }

        @Override
        public long estimateSize() {
            return this.fence - this.index;
        }

        @Override
        public int characteristics() {
            return 17728;
        }

        @Override
        public boolean tryAdvance(DoubleConsumer doubleConsumer) {
            if (doubleConsumer == null) {
                throw new NullPointerException();
            }
            long l = this.index;
            long l2 = this.fence;
            if (l < l2) {
                doubleConsumer.accept(this.rng.internalNextDouble(this.origin, this.bound));
                this.index = l + 1L;
                return true;
            }
            return false;
        }

        @Override
        public void forEachRemaining(DoubleConsumer doubleConsumer) {
            if (doubleConsumer == null) {
                throw new NullPointerException();
            }
            long l = this.index;
            long l2 = this.fence;
            if (l < l2) {
                this.index = l2;
                SplittableRandom splittableRandom = this.rng;
                double d = this.origin;
                double d2 = this.bound;
                do {
                    doubleConsumer.accept(splittableRandom.internalNextDouble(d, d2));
                } while (++l < l2);
            }
        }
    }

    static final class RandomIntsSpliterator
    implements Spliterator.OfInt {
        final SplittableRandom rng;
        long index;
        final long fence;
        final int origin;
        final int bound;

        RandomIntsSpliterator(SplittableRandom splittableRandom, long l, long l2, int n, int n2) {
            this.rng = splittableRandom;
            this.index = l;
            this.fence = l2;
            this.origin = n;
            this.bound = n2;
        }

        @Override
        public RandomIntsSpliterator trySplit() {
            RandomIntsSpliterator randomIntsSpliterator;
            long l = this.index;
            long l2 = l + this.fence >>> 1;
            if (l2 <= l) {
                randomIntsSpliterator = null;
            } else {
                this.index = l2;
                RandomIntsSpliterator randomIntsSpliterator2 = new RandomIntsSpliterator(this.rng.split(), l, this.index, this.origin, this.bound);
                randomIntsSpliterator = randomIntsSpliterator2;
            }
            return randomIntsSpliterator;
        }

        @Override
        public long estimateSize() {
            return this.fence - this.index;
        }

        @Override
        public int characteristics() {
            return 17728;
        }

        @Override
        public boolean tryAdvance(IntConsumer intConsumer) {
            if (intConsumer == null) {
                throw new NullPointerException();
            }
            long l = this.index;
            long l2 = this.fence;
            if (l < l2) {
                intConsumer.accept(this.rng.internalNextInt(this.origin, this.bound));
                this.index = l + 1L;
                return true;
            }
            return false;
        }

        @Override
        public void forEachRemaining(IntConsumer intConsumer) {
            if (intConsumer == null) {
                throw new NullPointerException();
            }
            long l = this.index;
            long l2 = this.fence;
            if (l < l2) {
                this.index = l2;
                SplittableRandom splittableRandom = this.rng;
                int n = this.origin;
                int n2 = this.bound;
                do {
                    intConsumer.accept(splittableRandom.internalNextInt(n, n2));
                } while (++l < l2);
            }
        }
    }

    static final class RandomLongsSpliterator
    implements Spliterator.OfLong {
        final SplittableRandom rng;
        long index;
        final long fence;
        final long origin;
        final long bound;

        RandomLongsSpliterator(SplittableRandom splittableRandom, long l, long l2, long l3, long l4) {
            this.rng = splittableRandom;
            this.index = l;
            this.fence = l2;
            this.origin = l3;
            this.bound = l4;
        }

        @Override
        public RandomLongsSpliterator trySplit() {
            RandomLongsSpliterator randomLongsSpliterator;
            long l = this.index;
            long l2 = l + this.fence >>> 1;
            if (l2 <= l) {
                randomLongsSpliterator = null;
            } else {
                this.index = l2;
                RandomLongsSpliterator randomLongsSpliterator2 = new RandomLongsSpliterator(this.rng.split(), l, this.index, this.origin, this.bound);
                randomLongsSpliterator = randomLongsSpliterator2;
            }
            return randomLongsSpliterator;
        }

        @Override
        public long estimateSize() {
            return this.fence - this.index;
        }

        @Override
        public int characteristics() {
            return 17728;
        }

        @Override
        public boolean tryAdvance(LongConsumer longConsumer) {
            if (longConsumer == null) {
                throw new NullPointerException();
            }
            long l = this.index;
            long l2 = this.fence;
            if (l < l2) {
                longConsumer.accept(this.rng.internalNextLong(this.origin, this.bound));
                this.index = l + 1L;
                return true;
            }
            return false;
        }

        @Override
        public void forEachRemaining(LongConsumer longConsumer) {
            if (longConsumer == null) {
                throw new NullPointerException();
            }
            long l = this.index;
            long l2 = this.fence;
            if (l < l2) {
                this.index = l2;
                SplittableRandom splittableRandom = this.rng;
                long l3 = this.origin;
                long l4 = this.bound;
                do {
                    longConsumer.accept(splittableRandom.internalNextLong(l3, l4));
                } while (++l < l2);
            }
        }
    }
}

