/*
 * Decompiled with CFR 0.152.
 */
package com.sun.image.codec.jpeg;

import com.sun.image.codec.jpeg.ImageFormatException;
import com.sun.image.codec.jpeg.JPEGDecodeParam;
import com.sun.image.codec.jpeg.JPEGEncodeParam;
import com.sun.image.codec.jpeg.JPEGImageDecoder;
import com.sun.image.codec.jpeg.JPEGImageEncoder;
import java.awt.image.BufferedImage;
import java.awt.image.Raster;
import java.io.InputStream;
import java.io.OutputStream;
import sun.awt.image.codec.JPEGImageDecoderImpl;
import sun.awt.image.codec.JPEGImageEncoderImpl;
import sun.awt.image.codec.JPEGParam;

public class JPEGCodec {
    private JPEGCodec() {
    }

    public static JPEGEncodeParam getDefaultJPEGEncodeParam(int n2, int n3) throws ImageFormatException {
        return new JPEGParam(n3, n2);
    }

    public static JPEGEncodeParam getDefaultJPEGEncodeParam(JPEGDecodeParam jPEGDecodeParam) throws ImageFormatException {
        return new JPEGParam(jPEGDecodeParam);
    }

    public static JPEGEncodeParam getDefaultJPEGEncodeParam(BufferedImage bufferedImage) {
        int n2 = JPEGParam.getDefaultColorId(bufferedImage.getColorModel());
        return JPEGCodec.getDefaultJPEGEncodeParam(bufferedImage.getRaster(), n2);
    }

    public static JPEGEncodeParam getDefaultJPEGEncodeParam(Raster raster, int n2) {
        JPEGParam jPEGParam = new JPEGParam(n2, raster.getNumBands());
        jPEGParam.setWidth(raster.getWidth());
        jPEGParam.setHeight(raster.getHeight());
        return jPEGParam;
    }

    public static JPEGImageDecoder createJPEGDecoder(InputStream inputStream) {
        return new JPEGImageDecoderImpl(inputStream);
    }

    public static JPEGImageEncoder createJPEGEncoder(OutputStream outputStream) {
        return new JPEGImageEncoderImpl(outputStream);
    }

    public static JPEGImageDecoder createJPEGDecoder(InputStream inputStream, JPEGDecodeParam jPEGDecodeParam) {
        return new JPEGImageDecoderImpl(inputStream, jPEGDecodeParam);
    }

    public static JPEGImageEncoder createJPEGEncoder(OutputStream outputStream, JPEGEncodeParam jPEGEncodeParam) {
        return new JPEGImageEncoderImpl(outputStream, jPEGEncodeParam);
    }
}

