/*
 * Decompiled with CFR 0.152.
 */
package com.sun.imageio.plugins.png;

import java.awt.image.ColorModel;
import java.awt.image.IndexColorModel;
import java.awt.image.SampleModel;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.StringTokenizer;
import javax.imageio.ImageTypeSpecifier;
import javax.imageio.metadata.IIOInvalidTreeException;
import javax.imageio.metadata.IIOMetadata;
import javax.imageio.metadata.IIOMetadataNode;
import org.w3c.dom.Node;

public class PNGMetadata
extends IIOMetadata
implements Cloneable {
    public static final String nativeMetadataFormatName = "javax_imageio_png_1.0";
    protected static final String nativeMetadataFormatClassName = "com.sun.imageio.plugins.png.PNGMetadataFormat";
    public static final String[] IHDR_colorTypeNames = new String[]{"Grayscale", null, "RGB", "Palette", "GrayAlpha", null, "RGBAlpha"};
    public static final int[] IHDR_numChannels = new int[]{1, 0, 3, 3, 2, 0, 4};
    public static final String[] IHDR_bitDepths = new String[]{"1", "2", "4", "8", "16"};
    public static final String[] IHDR_compressionMethodNames = new String[]{"deflate"};
    public static final String[] IHDR_filterMethodNames = new String[]{"adaptive"};
    public static final String[] IHDR_interlaceMethodNames = new String[]{"none", "adam7"};
    public static final String[] iCCP_compressionMethodNames = new String[]{"deflate"};
    public static final String[] zTXt_compressionMethodNames = new String[]{"deflate"};
    public static final int PHYS_UNIT_UNKNOWN = 0;
    public static final int PHYS_UNIT_METER = 1;
    public static final String[] unitSpecifierNames = new String[]{"unknown", "meter"};
    public static final String[] renderingIntentNames = new String[]{"Perceptual", "Relative colorimetric", "Saturation", "Absolute colorimetric"};
    public static final String[] colorSpaceTypeNames = new String[]{"GRAY", null, "RGB", "RGB", "GRAY", null, "RGB"};
    public boolean IHDR_present;
    public int IHDR_width;
    public int IHDR_height;
    public int IHDR_bitDepth;
    public int IHDR_colorType;
    public int IHDR_compressionMethod;
    public int IHDR_filterMethod;
    public int IHDR_interlaceMethod;
    public boolean PLTE_present;
    public byte[] PLTE_red;
    public byte[] PLTE_green;
    public byte[] PLTE_blue;
    public int[] PLTE_order = null;
    public boolean bKGD_present;
    public int bKGD_colorType;
    public int bKGD_index;
    public int bKGD_gray;
    public int bKGD_red;
    public int bKGD_green;
    public int bKGD_blue;
    public boolean cHRM_present;
    public int cHRM_whitePointX;
    public int cHRM_whitePointY;
    public int cHRM_redX;
    public int cHRM_redY;
    public int cHRM_greenX;
    public int cHRM_greenY;
    public int cHRM_blueX;
    public int cHRM_blueY;
    public boolean gAMA_present;
    public int gAMA_gamma;
    public boolean hIST_present;
    public char[] hIST_histogram;
    public boolean iCCP_present;
    public String iCCP_profileName;
    public int iCCP_compressionMethod;
    public byte[] iCCP_compressedProfile;
    public ArrayList iTXt_keyword = new ArrayList();
    public ArrayList iTXt_compressionFlag = new ArrayList();
    public ArrayList iTXt_compressionMethod = new ArrayList();
    public ArrayList iTXt_languageTag = new ArrayList();
    public ArrayList iTXt_translatedKeyword = new ArrayList();
    public ArrayList iTXt_text = new ArrayList();
    public boolean pHYs_present;
    public int pHYs_pixelsPerUnitXAxis;
    public int pHYs_pixelsPerUnitYAxis;
    public int pHYs_unitSpecifier;
    public boolean sBIT_present;
    public int sBIT_colorType;
    public int sBIT_grayBits;
    public int sBIT_redBits;
    public int sBIT_greenBits;
    public int sBIT_blueBits;
    public int sBIT_alphaBits;
    public boolean sPLT_present;
    public String sPLT_paletteName;
    public int sPLT_sampleDepth;
    public int[] sPLT_red;
    public int[] sPLT_green;
    public int[] sPLT_blue;
    public int[] sPLT_alpha;
    public int[] sPLT_frequency;
    public boolean sRGB_present;
    public int sRGB_renderingIntent;
    public ArrayList tEXt_keyword = new ArrayList();
    public ArrayList tEXt_text = new ArrayList();
    public boolean tIME_present;
    public int tIME_year;
    public int tIME_month;
    public int tIME_day;
    public int tIME_hour;
    public int tIME_minute;
    public int tIME_second;
    public boolean tRNS_present;
    public int tRNS_colorType;
    public byte[] tRNS_alpha;
    public int tRNS_gray;
    public int tRNS_red;
    public int tRNS_green;
    public int tRNS_blue;
    public ArrayList zTXt_keyword = new ArrayList();
    public ArrayList zTXt_compressionMethod = new ArrayList();
    public ArrayList zTXt_text = new ArrayList();
    public ArrayList unknownChunkType = new ArrayList();
    public ArrayList unknownChunkData = new ArrayList();

    private int getNumChannels() {
        int n2 = IHDR_numChannels[this.IHDR_colorType];
        if (this.IHDR_colorType == 3 && this.tRNS_present && this.tRNS_colorType == this.IHDR_colorType) {
            n2 = 4;
        }
        return n2;
    }

    public PNGMetadata() {
        super(true, nativeMetadataFormatName, nativeMetadataFormatClassName, null, null);
    }

    public void reset() {
        this.IHDR_present = false;
        this.PLTE_present = false;
        this.bKGD_present = false;
        this.cHRM_present = false;
        this.gAMA_present = false;
        this.hIST_present = false;
        this.iCCP_present = false;
        this.iTXt_keyword = new ArrayList();
        this.iTXt_compressionFlag = new ArrayList();
        this.iTXt_compressionMethod = new ArrayList();
        this.iTXt_languageTag = new ArrayList();
        this.iTXt_translatedKeyword = new ArrayList();
        this.iTXt_text = new ArrayList();
        this.pHYs_present = false;
        this.sBIT_present = false;
        this.sPLT_present = false;
        this.sRGB_present = false;
        this.tEXt_keyword = new ArrayList();
        this.tEXt_text = new ArrayList();
        this.tIME_present = false;
        this.tRNS_present = false;
        this.zTXt_keyword = new ArrayList();
        this.zTXt_compressionMethod = new ArrayList();
        this.zTXt_text = new ArrayList();
        this.unknownChunkType = new ArrayList();
        this.unknownChunkData = new ArrayList();
    }

    public boolean isReadOnly() {
        return false;
    }

    public Object clone() {
        PNGMetadata pNGMetadata;
        try {
            pNGMetadata = (PNGMetadata)super.clone();
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            return null;
        }
        pNGMetadata.unknownChunkData = this.cloneBytesArrayList(this.unknownChunkData);
        return pNGMetadata;
    }

    private boolean isISOLatin(String string) {
        int n2 = string.length();
        for (int i2 = 0; i2 < n2; ++i2) {
            if (string.charAt(i2) <= '\u00ff') continue;
            return false;
        }
        return true;
    }

    public void initialize(ImageTypeSpecifier imageTypeSpecifier, int n2) {
        ColorModel colorModel = imageTypeSpecifier.getColorModel();
        SampleModel sampleModel = imageTypeSpecifier.getSampleModel();
        int[] nArray = sampleModel.getSampleSize();
        int n3 = nArray[0];
        for (int i2 = 1; i2 < nArray.length; ++i2) {
            if (nArray[i2] <= n3) continue;
            n3 = nArray[i2];
        }
        if (nArray.length > 1 && n3 < 8) {
            n3 = 8;
        }
        if (n3 > 2 && n3 < 4) {
            n3 = 4;
        } else if (n3 > 4 && n3 < 8) {
            n3 = 8;
        } else if (n3 > 8 && n3 < 16) {
            n3 = 16;
        } else if (n3 > 16) {
            throw new RuntimeException("bitDepth > 16!");
        }
        this.IHDR_bitDepth = n3;
        if (colorModel instanceof IndexColorModel) {
            int n4;
            IndexColorModel indexColorModel = (IndexColorModel)colorModel;
            int n5 = indexColorModel.getMapSize();
            byte[] byArray = new byte[n5];
            indexColorModel.getReds(byArray);
            byte[] byArray2 = new byte[n5];
            indexColorModel.getGreens(byArray2);
            byte[] byArray3 = new byte[n5];
            indexColorModel.getBlues(byArray3);
            boolean bl2 = false;
            if (!this.IHDR_present || this.IHDR_colorType != 3) {
                bl2 = true;
                n4 = 255 / ((1 << this.IHDR_bitDepth) - 1);
                for (int i3 = 0; i3 < n5; ++i3) {
                    byte by = byArray[i3];
                    if (by == (byte)(i3 * n4) && by == byArray2[i3] && by == byArray3[i3]) continue;
                    bl2 = false;
                    break;
                }
            }
            n4 = colorModel.hasAlpha();
            byte[] byArray4 = null;
            if (n4 != 0) {
                byArray4 = new byte[n5];
                indexColorModel.getAlphas(byArray4);
            }
            if (bl2 && n4 != 0) {
                this.IHDR_colorType = 4;
            } else if (bl2) {
                this.IHDR_colorType = 0;
            } else {
                this.IHDR_colorType = 3;
                this.PLTE_present = true;
                this.PLTE_order = null;
                this.PLTE_red = (byte[])byArray.clone();
                this.PLTE_green = (byte[])byArray2.clone();
                this.PLTE_blue = (byte[])byArray3.clone();
                if (n4 != 0) {
                    int n6;
                    this.tRNS_present = true;
                    this.tRNS_colorType = 3;
                    this.PLTE_order = new int[byArray4.length];
                    byte[] byArray5 = new byte[byArray4.length];
                    int n7 = 0;
                    for (n6 = 0; n6 < byArray4.length; ++n6) {
                        if (byArray4[n6] == -1) continue;
                        this.PLTE_order[n6] = n7;
                        byArray5[n7] = byArray4[n6];
                        ++n7;
                    }
                    n6 = n7;
                    for (int i4 = 0; i4 < byArray4.length; ++i4) {
                        if (byArray4[i4] != -1) continue;
                        this.PLTE_order[i4] = n7++;
                    }
                    byte[] byArray6 = this.PLTE_red;
                    byte[] byArray7 = this.PLTE_green;
                    byte[] byArray8 = this.PLTE_blue;
                    int n8 = byArray6.length;
                    this.PLTE_red = new byte[n8];
                    this.PLTE_green = new byte[n8];
                    this.PLTE_blue = new byte[n8];
                    for (int i5 = 0; i5 < n8; ++i5) {
                        this.PLTE_red[this.PLTE_order[i5]] = byArray6[i5];
                        this.PLTE_green[this.PLTE_order[i5]] = byArray7[i5];
                        this.PLTE_blue[this.PLTE_order[i5]] = byArray8[i5];
                    }
                    this.tRNS_alpha = new byte[n6];
                    System.arraycopy(byArray5, 0, this.tRNS_alpha, 0, n6);
                }
            }
        } else if (n2 == 1) {
            this.IHDR_colorType = 0;
        } else if (n2 == 2) {
            this.IHDR_colorType = 4;
        } else if (n2 == 3) {
            this.IHDR_colorType = 2;
        } else if (n2 == 4) {
            this.IHDR_colorType = 6;
        } else {
            throw new RuntimeException("Number of bands not 1-4!");
        }
        this.IHDR_present = true;
    }

    public PNGMetadata(IIOMetadata iIOMetadata) {
    }

    public IIOMetadataNode getStandardChromaNode() {
        int n2;
        int n3;
        IIOMetadataNode iIOMetadataNode = new IIOMetadataNode("Chroma");
        IIOMetadataNode iIOMetadataNode2 = null;
        iIOMetadataNode2 = new IIOMetadataNode("ColorSpaceType");
        iIOMetadataNode2.setAttribute("name", colorSpaceTypeNames[this.IHDR_colorType]);
        iIOMetadataNode.appendChild(iIOMetadataNode2);
        iIOMetadataNode2 = new IIOMetadataNode("NumChannels");
        iIOMetadataNode2.setAttribute("value", Integer.toString(this.getNumChannels()));
        iIOMetadataNode.appendChild(iIOMetadataNode2);
        if (this.gAMA_present) {
            iIOMetadataNode2 = new IIOMetadataNode("Gamma");
            iIOMetadataNode2.setAttribute("value", Float.toString((float)this.gAMA_gamma * 1.0E-5f));
            iIOMetadataNode.appendChild(iIOMetadataNode2);
        }
        iIOMetadataNode2 = new IIOMetadataNode("BlackIsZero");
        iIOMetadataNode2.setAttribute("value", "true");
        iIOMetadataNode.appendChild(iIOMetadataNode2);
        if (this.PLTE_present) {
            n3 = this.tRNS_present && this.tRNS_colorType == 3 ? 1 : 0;
            iIOMetadataNode2 = new IIOMetadataNode("Palette");
            for (n2 = 0; n2 < this.PLTE_red.length; ++n2) {
                IIOMetadataNode iIOMetadataNode3 = new IIOMetadataNode("PaletteEntry");
                iIOMetadataNode3.setAttribute("index", Integer.toString(n2));
                iIOMetadataNode3.setAttribute("red", Integer.toString(this.PLTE_red[n2] & 0xFF));
                iIOMetadataNode3.setAttribute("green", Integer.toString(this.PLTE_green[n2] & 0xFF));
                iIOMetadataNode3.setAttribute("blue", Integer.toString(this.PLTE_blue[n2] & 0xFF));
                if (n3 != 0) {
                    int n4 = n2 < this.tRNS_alpha.length ? this.tRNS_alpha[n2] & 0xFF : 255;
                    iIOMetadataNode3.setAttribute("alpha", Integer.toString(n4));
                }
                iIOMetadataNode2.appendChild(iIOMetadataNode3);
            }
            iIOMetadataNode.appendChild(iIOMetadataNode2);
        }
        if (this.bKGD_present) {
            if (this.bKGD_colorType == 3) {
                iIOMetadataNode2 = new IIOMetadataNode("BackgroundIndex");
                iIOMetadataNode2.setAttribute("value", Integer.toString(this.bKGD_index));
            } else {
                int n5;
                iIOMetadataNode2 = new IIOMetadataNode("BackgroundColor");
                if (this.bKGD_colorType == 0) {
                    n2 = n5 = this.bKGD_gray;
                    n3 = n5;
                } else {
                    n3 = this.bKGD_red;
                    n2 = this.bKGD_green;
                    n5 = this.bKGD_blue;
                }
                iIOMetadataNode2.setAttribute("red", Integer.toString(n3));
                iIOMetadataNode2.setAttribute("green", Integer.toString(n2));
                iIOMetadataNode2.setAttribute("blue", Integer.toString(n5));
            }
            iIOMetadataNode.appendChild(iIOMetadataNode2);
        }
        return iIOMetadataNode;
    }

    public IIOMetadataNode getStandardCompressionNode() {
        IIOMetadataNode iIOMetadataNode = new IIOMetadataNode("Compression");
        IIOMetadataNode iIOMetadataNode2 = null;
        iIOMetadataNode2 = new IIOMetadataNode("CompressionTypeName");
        iIOMetadataNode2.setAttribute("value", "deflate");
        iIOMetadataNode.appendChild(iIOMetadataNode2);
        iIOMetadataNode2 = new IIOMetadataNode("Lossless");
        iIOMetadataNode2.setAttribute("value", "true");
        iIOMetadataNode.appendChild(iIOMetadataNode2);
        iIOMetadataNode2 = new IIOMetadataNode("NumProgressiveScans");
        iIOMetadataNode2.setAttribute("value", this.IHDR_interlaceMethod == 0 ? "1" : "7");
        iIOMetadataNode.appendChild(iIOMetadataNode2);
        return iIOMetadataNode;
    }

    public IIOMetadataNode getStandardDataNode() {
        IIOMetadataNode iIOMetadataNode = new IIOMetadataNode("Data");
        IIOMetadataNode iIOMetadataNode2 = null;
        iIOMetadataNode2 = new IIOMetadataNode("PlanarConfiguration");
        iIOMetadataNode2.setAttribute("value", "PixelInterleaved");
        iIOMetadataNode.appendChild(iIOMetadataNode2);
        iIOMetadataNode2 = new IIOMetadataNode("SampleFormat");
        iIOMetadataNode2.setAttribute("value", this.IHDR_colorType == 3 ? "Index" : "UnsignedIntegral");
        iIOMetadataNode.appendChild(iIOMetadataNode2);
        String string = Integer.toString(this.IHDR_bitDepth);
        iIOMetadataNode2 = new IIOMetadataNode("BitsPerSample");
        iIOMetadataNode2.setAttribute("value", this.repeat(string, this.getNumChannels()));
        iIOMetadataNode.appendChild(iIOMetadataNode2);
        if (this.sBIT_present) {
            iIOMetadataNode2 = new IIOMetadataNode("SignificantBitsPerSample");
            String string2 = this.sBIT_colorType == 0 || this.sBIT_colorType == 4 ? Integer.toString(this.sBIT_grayBits) : Integer.toString(this.sBIT_redBits) + " " + Integer.toString(this.sBIT_greenBits) + " " + Integer.toString(this.sBIT_blueBits);
            if (this.sBIT_colorType == 4 || this.sBIT_colorType == 6) {
                string2 = string2 + " " + Integer.toString(this.sBIT_alphaBits);
            }
            iIOMetadataNode2.setAttribute("value", string2);
            iIOMetadataNode.appendChild(iIOMetadataNode2);
        }
        return iIOMetadataNode;
    }

    public IIOMetadataNode getStandardDimensionNode() {
        IIOMetadataNode iIOMetadataNode = new IIOMetadataNode("Dimension");
        IIOMetadataNode iIOMetadataNode2 = null;
        iIOMetadataNode2 = new IIOMetadataNode("PixelAspectRatio");
        float f2 = this.pHYs_present ? (float)this.pHYs_pixelsPerUnitXAxis / (float)this.pHYs_pixelsPerUnitYAxis : 1.0f;
        iIOMetadataNode2.setAttribute("value", Float.toString(f2));
        iIOMetadataNode.appendChild(iIOMetadataNode2);
        iIOMetadataNode2 = new IIOMetadataNode("ImageOrientation");
        iIOMetadataNode2.setAttribute("value", "Normal");
        iIOMetadataNode.appendChild(iIOMetadataNode2);
        if (this.pHYs_present && this.pHYs_unitSpecifier == 1) {
            iIOMetadataNode2 = new IIOMetadataNode("HorizontalPixelSize");
            iIOMetadataNode2.setAttribute("value", Float.toString(1000.0f / (float)this.pHYs_pixelsPerUnitXAxis));
            iIOMetadataNode.appendChild(iIOMetadataNode2);
            iIOMetadataNode2 = new IIOMetadataNode("VerticalPixelSize");
            iIOMetadataNode2.setAttribute("value", Float.toString(1000.0f / (float)this.pHYs_pixelsPerUnitYAxis));
            iIOMetadataNode.appendChild(iIOMetadataNode2);
        }
        return iIOMetadataNode;
    }

    public IIOMetadataNode getStandardDocumentNode() {
        if (!this.tIME_present) {
            return null;
        }
        IIOMetadataNode iIOMetadataNode = new IIOMetadataNode("Document");
        IIOMetadataNode iIOMetadataNode2 = null;
        iIOMetadataNode2 = new IIOMetadataNode("ImageModificationTime");
        iIOMetadataNode2.setAttribute("year", Integer.toString(this.tIME_year));
        iIOMetadataNode2.setAttribute("month", Integer.toString(this.tIME_month));
        iIOMetadataNode2.setAttribute("day", Integer.toString(this.tIME_day));
        iIOMetadataNode2.setAttribute("hour", Integer.toString(this.tIME_hour));
        iIOMetadataNode2.setAttribute("minute", Integer.toString(this.tIME_minute));
        iIOMetadataNode2.setAttribute("second", Integer.toString(this.tIME_second));
        iIOMetadataNode.appendChild(iIOMetadataNode2);
        return iIOMetadataNode;
    }

    public IIOMetadataNode getStandardTextNode() {
        int n2;
        int n3 = this.tEXt_keyword.size() + this.iTXt_keyword.size() + this.zTXt_keyword.size();
        if (n3 == 0) {
            return null;
        }
        IIOMetadataNode iIOMetadataNode = new IIOMetadataNode("Text");
        IIOMetadataNode iIOMetadataNode2 = null;
        for (n2 = 0; n2 < this.tEXt_keyword.size(); ++n2) {
            iIOMetadataNode2 = new IIOMetadataNode("TextEntry");
            iIOMetadataNode2.setAttribute("keyword", (String)this.tEXt_keyword.get(n2));
            iIOMetadataNode2.setAttribute("value", (String)this.tEXt_text.get(n2));
            iIOMetadataNode2.setAttribute("encoding", "ISO-8859-1");
            iIOMetadataNode2.setAttribute("compression", "none");
            iIOMetadataNode.appendChild(iIOMetadataNode2);
        }
        for (n2 = 0; n2 < this.iTXt_keyword.size(); ++n2) {
            iIOMetadataNode2 = new IIOMetadataNode("TextEntry");
            iIOMetadataNode2.setAttribute("keyword", (String)this.iTXt_keyword.get(n2));
            iIOMetadataNode2.setAttribute("value", (String)this.iTXt_text.get(n2));
            iIOMetadataNode2.setAttribute("language", (String)this.iTXt_languageTag.get(n2));
            if ((Integer)this.iTXt_compressionFlag.get(n2) == 1) {
                iIOMetadataNode2.setAttribute("compression", "deflate");
            } else {
                iIOMetadataNode2.setAttribute("compression", "none");
            }
            iIOMetadataNode.appendChild(iIOMetadataNode2);
        }
        for (n2 = 0; n2 < this.zTXt_keyword.size(); ++n2) {
            iIOMetadataNode2 = new IIOMetadataNode("TextEntry");
            iIOMetadataNode2.setAttribute("keyword", (String)this.zTXt_keyword.get(n2));
            iIOMetadataNode2.setAttribute("value", (String)this.zTXt_text.get(n2));
            iIOMetadataNode2.setAttribute("compression", "deflate");
            iIOMetadataNode.appendChild(iIOMetadataNode2);
        }
        return iIOMetadataNode;
    }

    public IIOMetadataNode getStandardTransparencyNode() {
        IIOMetadataNode iIOMetadataNode = new IIOMetadataNode("Transparency");
        IIOMetadataNode iIOMetadataNode2 = null;
        iIOMetadataNode2 = new IIOMetadataNode("Alpha");
        boolean bl2 = this.IHDR_colorType == 6 || this.IHDR_colorType == 4 || this.IHDR_colorType == 3 && this.tRNS_present && this.tRNS_colorType == this.IHDR_colorType && this.tRNS_alpha != null;
        iIOMetadataNode2.setAttribute("value", bl2 ? "nonpremultipled" : "none");
        iIOMetadataNode.appendChild(iIOMetadataNode2);
        if (this.tRNS_present) {
            iIOMetadataNode2 = new IIOMetadataNode("TransparentColor");
            if (this.tRNS_colorType == 2) {
                iIOMetadataNode2.setAttribute("value", Integer.toString(this.tRNS_red) + " " + Integer.toString(this.tRNS_green) + " " + Integer.toString(this.tRNS_blue));
            } else if (this.tRNS_colorType == 0) {
                iIOMetadataNode2.setAttribute("value", Integer.toString(this.tRNS_gray));
            }
            iIOMetadataNode.appendChild(iIOMetadataNode2);
        }
        return iIOMetadataNode;
    }

    private Node getNativeTree() {
        IIOMetadataNode iIOMetadataNode;
        int n2;
        int n3;
        IIOMetadataNode iIOMetadataNode2;
        IIOMetadataNode iIOMetadataNode3 = null;
        IIOMetadataNode iIOMetadataNode4 = new IIOMetadataNode(nativeMetadataFormatName);
        if (this.IHDR_present) {
            iIOMetadataNode2 = new IIOMetadataNode("IHDR");
            iIOMetadataNode2.setAttribute("width", Integer.toString(this.IHDR_width));
            iIOMetadataNode2.setAttribute("height", Integer.toString(this.IHDR_height));
            iIOMetadataNode2.setAttribute("bitDepth", Integer.toString(this.IHDR_bitDepth));
            iIOMetadataNode2.setAttribute("colorType", IHDR_colorTypeNames[this.IHDR_colorType]);
            iIOMetadataNode2.setAttribute("compressionMethod", IHDR_compressionMethodNames[this.IHDR_compressionMethod]);
            iIOMetadataNode2.setAttribute("filterMethod", IHDR_filterMethodNames[this.IHDR_filterMethod]);
            iIOMetadataNode2.setAttribute("interlaceMethod", IHDR_interlaceMethodNames[this.IHDR_interlaceMethod]);
            iIOMetadataNode4.appendChild(iIOMetadataNode2);
        }
        if (this.PLTE_present) {
            iIOMetadataNode2 = new IIOMetadataNode("PLTE");
            n3 = this.PLTE_red.length;
            for (n2 = 0; n2 < n3; ++n2) {
                iIOMetadataNode = new IIOMetadataNode("PLTEEntry");
                iIOMetadataNode.setAttribute("index", Integer.toString(n2));
                iIOMetadataNode.setAttribute("red", Integer.toString(this.PLTE_red[n2] & 0xFF));
                iIOMetadataNode.setAttribute("green", Integer.toString(this.PLTE_green[n2] & 0xFF));
                iIOMetadataNode.setAttribute("blue", Integer.toString(this.PLTE_blue[n2] & 0xFF));
                iIOMetadataNode2.appendChild(iIOMetadataNode);
            }
            iIOMetadataNode4.appendChild(iIOMetadataNode2);
        }
        if (this.bKGD_present) {
            iIOMetadataNode2 = new IIOMetadataNode("bKGD");
            if (this.bKGD_colorType == 3) {
                iIOMetadataNode3 = new IIOMetadataNode("bKGD_Palette");
                iIOMetadataNode3.setAttribute("index", Integer.toString(this.bKGD_index));
            } else if (this.bKGD_colorType == 0) {
                iIOMetadataNode3 = new IIOMetadataNode("bKGD_Grayscale");
                iIOMetadataNode3.setAttribute("gray", Integer.toString(this.bKGD_gray));
            } else if (this.bKGD_colorType == 2) {
                iIOMetadataNode3 = new IIOMetadataNode("bKGD_RGB");
                iIOMetadataNode3.setAttribute("red", Integer.toString(this.bKGD_red));
                iIOMetadataNode3.setAttribute("green", Integer.toString(this.bKGD_green));
                iIOMetadataNode3.setAttribute("blue", Integer.toString(this.bKGD_blue));
            }
            iIOMetadataNode2.appendChild(iIOMetadataNode3);
            iIOMetadataNode4.appendChild(iIOMetadataNode2);
        }
        if (this.cHRM_present) {
            iIOMetadataNode2 = new IIOMetadataNode("cHRM");
            iIOMetadataNode2.setAttribute("whitePointX", Integer.toString(this.cHRM_whitePointX));
            iIOMetadataNode2.setAttribute("whitePointY", Integer.toString(this.cHRM_whitePointY));
            iIOMetadataNode2.setAttribute("redX", Integer.toString(this.cHRM_redX));
            iIOMetadataNode2.setAttribute("redY", Integer.toString(this.cHRM_redY));
            iIOMetadataNode2.setAttribute("greenX", Integer.toString(this.cHRM_greenX));
            iIOMetadataNode2.setAttribute("greenY", Integer.toString(this.cHRM_greenY));
            iIOMetadataNode2.setAttribute("blueX", Integer.toString(this.cHRM_blueX));
            iIOMetadataNode2.setAttribute("blueY", Integer.toString(this.cHRM_blueY));
            iIOMetadataNode4.appendChild(iIOMetadataNode2);
        }
        if (this.gAMA_present) {
            iIOMetadataNode2 = new IIOMetadataNode("gAMA");
            iIOMetadataNode2.setAttribute("value", Integer.toString(this.gAMA_gamma));
            iIOMetadataNode4.appendChild(iIOMetadataNode2);
        }
        if (this.hIST_present) {
            iIOMetadataNode2 = new IIOMetadataNode("hIST");
            for (n3 = 0; n3 < this.hIST_histogram.length; ++n3) {
                IIOMetadataNode iIOMetadataNode5 = new IIOMetadataNode("hISTEntry");
                iIOMetadataNode5.setAttribute("index", Integer.toString(n3));
                iIOMetadataNode5.setAttribute("value", Integer.toString(this.hIST_histogram[n3]));
                iIOMetadataNode2.appendChild(iIOMetadataNode5);
            }
            iIOMetadataNode4.appendChild(iIOMetadataNode2);
        }
        if (this.iCCP_present) {
            iIOMetadataNode2 = new IIOMetadataNode("iCCP");
            iIOMetadataNode2.setAttribute("profileName", this.iCCP_profileName);
            iIOMetadataNode2.setAttribute("compressionMethod", iCCP_compressionMethodNames[this.iCCP_compressionMethod]);
            Object object = this.iCCP_compressedProfile;
            if (object != null) {
                object = object.clone();
            }
            iIOMetadataNode2.setUserObject(object);
            iIOMetadataNode4.appendChild(iIOMetadataNode2);
        }
        if (this.iTXt_keyword.size() > 0) {
            iIOMetadataNode2 = new IIOMetadataNode("iTXt");
            for (int i2 = 0; i2 < this.iTXt_keyword.size(); ++i2) {
                iIOMetadataNode = new IIOMetadataNode("iTXtEntry");
                iIOMetadataNode.setAttribute("keyword", (String)this.iTXt_keyword.get(i2));
                Integer n4 = (Integer)this.iTXt_compressionFlag.get(i2);
                iIOMetadataNode.setAttribute("compressionFlag", n4.toString());
                n4 = (Integer)this.iTXt_compressionMethod.get(i2);
                iIOMetadataNode.setAttribute("compressionMethod", n4.toString());
                iIOMetadataNode.setAttribute("languageTag", (String)this.iTXt_languageTag.get(i2));
                iIOMetadataNode.setAttribute("translatedKeyword", (String)this.iTXt_translatedKeyword.get(i2));
                iIOMetadataNode.setAttribute("text", (String)this.iTXt_text.get(i2));
                iIOMetadataNode2.appendChild(iIOMetadataNode);
            }
            iIOMetadataNode4.appendChild(iIOMetadataNode2);
        }
        if (this.pHYs_present) {
            iIOMetadataNode2 = new IIOMetadataNode("pHYs");
            iIOMetadataNode2.setAttribute("pixelsPerUnitXAxis", Integer.toString(this.pHYs_pixelsPerUnitXAxis));
            iIOMetadataNode2.setAttribute("pixelsPerUnitYAxis", Integer.toString(this.pHYs_pixelsPerUnitYAxis));
            iIOMetadataNode2.setAttribute("unitSpecifier", unitSpecifierNames[this.pHYs_unitSpecifier]);
            iIOMetadataNode4.appendChild(iIOMetadataNode2);
        }
        if (this.sBIT_present) {
            iIOMetadataNode2 = new IIOMetadataNode("sBIT");
            if (this.sBIT_colorType == 0) {
                iIOMetadataNode3 = new IIOMetadataNode("sBIT_Grayscale");
                iIOMetadataNode3.setAttribute("gray", Integer.toString(this.sBIT_grayBits));
            } else if (this.sBIT_colorType == 4) {
                iIOMetadataNode3 = new IIOMetadataNode("sBIT_GrayAlpha");
                iIOMetadataNode3.setAttribute("gray", Integer.toString(this.sBIT_grayBits));
                iIOMetadataNode3.setAttribute("alpha", Integer.toString(this.sBIT_alphaBits));
            } else if (this.sBIT_colorType == 2) {
                iIOMetadataNode3 = new IIOMetadataNode("sBIT_RGB");
                iIOMetadataNode3.setAttribute("red", Integer.toString(this.sBIT_redBits));
                iIOMetadataNode3.setAttribute("green", Integer.toString(this.sBIT_greenBits));
                iIOMetadataNode3.setAttribute("blue", Integer.toString(this.sBIT_blueBits));
            } else if (this.sBIT_colorType == 6) {
                iIOMetadataNode3 = new IIOMetadataNode("sBIT_RGBAlpha");
                iIOMetadataNode3.setAttribute("red", Integer.toString(this.sBIT_redBits));
                iIOMetadataNode3.setAttribute("green", Integer.toString(this.sBIT_greenBits));
                iIOMetadataNode3.setAttribute("blue", Integer.toString(this.sBIT_blueBits));
                iIOMetadataNode3.setAttribute("alpha", Integer.toString(this.sBIT_alphaBits));
            } else if (this.sBIT_colorType == 3) {
                iIOMetadataNode3 = new IIOMetadataNode("sBIT_Palette");
                iIOMetadataNode3.setAttribute("red", Integer.toString(this.sBIT_redBits));
                iIOMetadataNode3.setAttribute("green", Integer.toString(this.sBIT_greenBits));
                iIOMetadataNode3.setAttribute("blue", Integer.toString(this.sBIT_blueBits));
            }
            iIOMetadataNode2.appendChild(iIOMetadataNode3);
            iIOMetadataNode4.appendChild(iIOMetadataNode2);
        }
        if (this.sPLT_present) {
            iIOMetadataNode2 = new IIOMetadataNode("sPLT");
            iIOMetadataNode2.setAttribute("name", this.sPLT_paletteName);
            iIOMetadataNode2.setAttribute("sampleDepth", Integer.toString(this.sPLT_sampleDepth));
            int n5 = this.sPLT_red.length;
            for (n2 = 0; n2 < n5; ++n2) {
                iIOMetadataNode = new IIOMetadataNode("sPLTEntry");
                iIOMetadataNode.setAttribute("index", Integer.toString(n2));
                iIOMetadataNode.setAttribute("red", Integer.toString(this.sPLT_red[n2]));
                iIOMetadataNode.setAttribute("green", Integer.toString(this.sPLT_green[n2]));
                iIOMetadataNode.setAttribute("blue", Integer.toString(this.sPLT_blue[n2]));
                iIOMetadataNode.setAttribute("alpha", Integer.toString(this.sPLT_alpha[n2]));
                iIOMetadataNode.setAttribute("frequency", Integer.toString(this.sPLT_frequency[n2]));
                iIOMetadataNode2.appendChild(iIOMetadataNode);
            }
            iIOMetadataNode4.appendChild(iIOMetadataNode2);
        }
        if (this.sRGB_present) {
            iIOMetadataNode2 = new IIOMetadataNode("sRGB");
            iIOMetadataNode2.setAttribute("renderingIntent", renderingIntentNames[this.sRGB_renderingIntent]);
            iIOMetadataNode4.appendChild(iIOMetadataNode2);
        }
        if (this.tEXt_keyword.size() > 0) {
            iIOMetadataNode2 = new IIOMetadataNode("tEXt");
            for (int i3 = 0; i3 < this.tEXt_keyword.size(); ++i3) {
                IIOMetadataNode iIOMetadataNode6 = new IIOMetadataNode("tEXtEntry");
                iIOMetadataNode6.setAttribute("keyword", (String)this.tEXt_keyword.get(i3));
                iIOMetadataNode6.setAttribute("value", (String)this.tEXt_text.get(i3));
                iIOMetadataNode2.appendChild(iIOMetadataNode6);
            }
            iIOMetadataNode4.appendChild(iIOMetadataNode2);
        }
        if (this.tIME_present) {
            iIOMetadataNode2 = new IIOMetadataNode("tIME");
            iIOMetadataNode2.setAttribute("year", Integer.toString(this.tIME_year));
            iIOMetadataNode2.setAttribute("month", Integer.toString(this.tIME_month));
            iIOMetadataNode2.setAttribute("day", Integer.toString(this.tIME_day));
            iIOMetadataNode2.setAttribute("hour", Integer.toString(this.tIME_hour));
            iIOMetadataNode2.setAttribute("minute", Integer.toString(this.tIME_minute));
            iIOMetadataNode2.setAttribute("second", Integer.toString(this.tIME_second));
            iIOMetadataNode4.appendChild(iIOMetadataNode2);
        }
        if (this.tRNS_present) {
            iIOMetadataNode2 = new IIOMetadataNode("tRNS");
            if (this.tRNS_colorType == 3) {
                iIOMetadataNode3 = new IIOMetadataNode("tRNS_Palette");
                for (int i4 = 0; i4 < this.tRNS_alpha.length; ++i4) {
                    IIOMetadataNode iIOMetadataNode7 = new IIOMetadataNode("tRNS_PaletteEntry");
                    iIOMetadataNode7.setAttribute("index", Integer.toString(i4));
                    iIOMetadataNode7.setAttribute("alpha", Integer.toString(this.tRNS_alpha[i4] & 0xFF));
                    iIOMetadataNode3.appendChild(iIOMetadataNode7);
                }
            } else if (this.tRNS_colorType == 0) {
                iIOMetadataNode3 = new IIOMetadataNode("tRNS_Grayscale");
                iIOMetadataNode3.setAttribute("gray", Integer.toString(this.tRNS_gray));
            } else if (this.tRNS_colorType == 2) {
                iIOMetadataNode3 = new IIOMetadataNode("tRNS_RGB");
                iIOMetadataNode3.setAttribute("red", Integer.toString(this.tRNS_red));
                iIOMetadataNode3.setAttribute("green", Integer.toString(this.tRNS_green));
                iIOMetadataNode3.setAttribute("blue", Integer.toString(this.tRNS_blue));
            }
            iIOMetadataNode2.appendChild(iIOMetadataNode3);
            iIOMetadataNode4.appendChild(iIOMetadataNode2);
        }
        if (this.zTXt_keyword.size() > 0) {
            iIOMetadataNode2 = new IIOMetadataNode("zTXt");
            for (int i5 = 0; i5 < this.zTXt_keyword.size(); ++i5) {
                IIOMetadataNode iIOMetadataNode8 = new IIOMetadataNode("zTXtEntry");
                iIOMetadataNode8.setAttribute("keyword", (String)this.zTXt_keyword.get(i5));
                int n6 = (Integer)this.zTXt_compressionMethod.get(i5);
                iIOMetadataNode8.setAttribute("compressionMethod", zTXt_compressionMethodNames[n6]);
                iIOMetadataNode8.setAttribute("text", (String)this.zTXt_text.get(i5));
                iIOMetadataNode2.appendChild(iIOMetadataNode8);
            }
            iIOMetadataNode4.appendChild(iIOMetadataNode2);
        }
        if (this.unknownChunkType.size() > 0) {
            iIOMetadataNode2 = new IIOMetadataNode("UnknownChunks");
            for (int i6 = 0; i6 < this.unknownChunkType.size(); ++i6) {
                IIOMetadataNode iIOMetadataNode9 = new IIOMetadataNode("UnknownChunk");
                iIOMetadataNode9.setAttribute("type", (String)this.unknownChunkType.get(i6));
                iIOMetadataNode9.setUserObject((byte[])this.unknownChunkData.get(i6));
                iIOMetadataNode2.appendChild(iIOMetadataNode9);
            }
            iIOMetadataNode4.appendChild(iIOMetadataNode2);
        }
        return iIOMetadataNode4;
    }

    private void mergeNativeTree(Node node) throws IIOInvalidTreeException {
        Node node2 = node;
        if (!node2.getNodeName().equals(nativeMetadataFormatName)) {
            this.fatal(node2, "Root must be javax_imageio_png_1.0");
        }
        for (node2 = node2.getFirstChild(); node2 != null; node2 = node2.getNextSibling()) {
            Object object;
            Object object2;
            Object object3;
            Object object4;
            String string = node2.getNodeName();
            if (string.equals("IHDR")) {
                this.IHDR_width = this.getIntAttribute(node2, "width");
                this.IHDR_height = this.getIntAttribute(node2, "height");
                this.IHDR_bitDepth = this.getEnumeratedAttribute(node2, "bitDepth", IHDR_bitDepths);
                this.IHDR_colorType = this.getEnumeratedAttribute(node2, "colorType", IHDR_colorTypeNames);
                this.IHDR_compressionMethod = this.getEnumeratedAttribute(node2, "compressionMethod", IHDR_compressionMethodNames);
                this.IHDR_filterMethod = this.getEnumeratedAttribute(node2, "filterMethod", IHDR_filterMethodNames);
                this.IHDR_interlaceMethod = this.getEnumeratedAttribute(node2, "interlaceMethod", IHDR_interlaceMethodNames);
                this.IHDR_present = true;
                continue;
            }
            if (string.equals("PLTE")) {
                int n2;
                object4 = new byte[256];
                byte[] byArray = new byte[256];
                object3 = new byte[256];
                int n3 = -1;
                object2 = node2.getFirstChild();
                if (object2 == null) {
                    this.fatal(node2, "Palette has no entries!");
                }
                while (object2 != null) {
                    if (!object2.getNodeName().equals("PLTEEntry")) {
                        this.fatal(node2, "Only a PLTEEntry may be a child of a PLTE!");
                    }
                    if ((n2 = this.getIntAttribute((Node)object2, "index")) < 0 || n2 > 255) {
                        this.fatal(node2, "Bad value for PLTEEntry attribute index!");
                    }
                    if (n2 > n3) {
                        n3 = n2;
                    }
                    object4[n2] = (byte)this.getIntAttribute((Node)object2, "red");
                    byArray[n2] = (byte)this.getIntAttribute((Node)object2, "green");
                    object3[n2] = (byte)this.getIntAttribute((Node)object2, "blue");
                    object2 = object2.getNextSibling();
                }
                n2 = n3 + 1;
                this.PLTE_red = new byte[n2];
                this.PLTE_green = new byte[n2];
                this.PLTE_blue = new byte[n2];
                System.arraycopy(object4, 0, this.PLTE_red, 0, n2);
                System.arraycopy(byArray, 0, this.PLTE_green, 0, n2);
                System.arraycopy(object3, 0, this.PLTE_blue, 0, n2);
                this.PLTE_present = true;
                continue;
            }
            if (string.equals("bKGD")) {
                String string2;
                this.bKGD_present = false;
                object4 = node2.getFirstChild();
                if (object4 == null) {
                    this.fatal(node2, "bKGD node has no children!");
                }
                if ((string2 = object4.getNodeName()).equals("bKGD_Palette")) {
                    this.bKGD_index = this.getIntAttribute((Node)object4, "index");
                    this.bKGD_colorType = 3;
                } else if (string2.equals("bKGD_Grayscale")) {
                    this.bKGD_gray = this.getIntAttribute((Node)object4, "gray");
                    this.bKGD_colorType = 0;
                } else if (string2.equals("bKGD_RGB")) {
                    this.bKGD_red = this.getIntAttribute((Node)object4, "red");
                    this.bKGD_green = this.getIntAttribute((Node)object4, "green");
                    this.bKGD_blue = this.getIntAttribute((Node)object4, "blue");
                    this.bKGD_colorType = 2;
                } else {
                    this.fatal(node2, "Bad child of a bKGD node!");
                }
                if (object4.getNextSibling() != null) {
                    this.fatal(node2, "bKGD node has more than one child!");
                }
                this.bKGD_present = true;
                continue;
            }
            if (string.equals("cHRM")) {
                this.cHRM_whitePointX = this.getIntAttribute(node2, "whitePointX");
                this.cHRM_whitePointY = this.getIntAttribute(node2, "whitePointY");
                this.cHRM_redX = this.getIntAttribute(node2, "redX");
                this.cHRM_redY = this.getIntAttribute(node2, "redY");
                this.cHRM_greenX = this.getIntAttribute(node2, "greenX");
                this.cHRM_greenY = this.getIntAttribute(node2, "greenY");
                this.cHRM_blueX = this.getIntAttribute(node2, "blueX");
                this.cHRM_blueY = this.getIntAttribute(node2, "blueY");
                this.cHRM_present = true;
                continue;
            }
            if (string.equals("gAMA")) {
                this.gAMA_gamma = this.getIntAttribute(node2, "value");
                this.gAMA_present = true;
                continue;
            }
            if (string.equals("hIST")) {
                object4 = new char[256];
                int n4 = -1;
                object3 = node2.getFirstChild();
                if (object3 == null) {
                    this.fatal(node2, "hIST node has no children!");
                }
                while (object3 != null) {
                    int n5;
                    if (!object3.getNodeName().equals("hISTEntry")) {
                        this.fatal(node2, "Only a hISTEntry may be a child of a hIST!");
                    }
                    if ((n5 = this.getIntAttribute((Node)object3, "index")) < 0 || n5 > 255) {
                        this.fatal(node2, "Bad value for histEntry attribute index!");
                    }
                    if (n5 > n4) {
                        n4 = n5;
                    }
                    object4[n5] = (char)this.getIntAttribute((Node)object3, "value");
                    object3 = object3.getNextSibling();
                }
                int n6 = n4 + 1;
                this.hIST_histogram = new char[n6];
                System.arraycopy(object4, 0, this.hIST_histogram, 0, n6);
                this.hIST_present = true;
                continue;
            }
            if (string.equals("iCCP")) {
                this.iCCP_profileName = this.getAttribute(node2, "profileName");
                this.iCCP_compressionMethod = this.getEnumeratedAttribute(node2, "compressionMethod", iCCP_compressionMethodNames);
                object4 = ((IIOMetadataNode)node2).getUserObject();
                if (object4 == null) {
                    this.fatal(node2, "No ICCP profile present in user object!");
                }
                if (!(object4 instanceof byte[])) {
                    this.fatal(node2, "User object not a byte array!");
                }
                this.iCCP_compressedProfile = (byte[])((byte[])object4).clone();
                this.iCCP_present = true;
                continue;
            }
            if (string.equals("iTXt")) {
                for (object4 = (Object)node2.getFirstChild(); object4 != null; object4 = object4.getNextSibling()) {
                    if (!object4.getNodeName().equals("iTXtEntry")) {
                        this.fatal(node2, "Only an iTXtEntry may be a child of an iTXt!");
                    }
                    String string3 = this.getAttribute((Node)object4, "keyword");
                    this.iTXt_keyword.add(string3);
                    boolean bl2 = this.getBooleanAttribute((Node)object4, "compressionFlag");
                    this.iTXt_compressionFlag.add(new Boolean(bl2));
                    String string4 = this.getAttribute((Node)object4, "compressionMethod");
                    this.iTXt_compressionMethod.add(string4);
                    object2 = this.getAttribute((Node)object4, "languageTag");
                    this.iTXt_languageTag.add(object2);
                    String string5 = this.getAttribute((Node)object4, "translatedKeyword");
                    this.iTXt_translatedKeyword.add(string5);
                    object = this.getAttribute((Node)object4, "text");
                    this.iTXt_text.add(object);
                }
                continue;
            }
            if (string.equals("pHYs")) {
                this.pHYs_pixelsPerUnitXAxis = this.getIntAttribute(node2, "pixelsPerUnitXAxis");
                this.pHYs_pixelsPerUnitYAxis = this.getIntAttribute(node2, "pixelsPerUnitYAxis");
                this.pHYs_unitSpecifier = this.getEnumeratedAttribute(node2, "unitSpecifier", unitSpecifierNames);
                this.pHYs_present = true;
                continue;
            }
            if (string.equals("sBIT")) {
                String string6;
                this.sBIT_present = false;
                object4 = node2.getFirstChild();
                if (object4 == null) {
                    this.fatal(node2, "sBIT node has no children!");
                }
                if ((string6 = object4.getNodeName()).equals("sBIT_Grayscale")) {
                    this.sBIT_grayBits = this.getIntAttribute((Node)object4, "gray");
                    this.sBIT_colorType = 0;
                } else if (string6.equals("sBIT_GrayAlpha")) {
                    this.sBIT_grayBits = this.getIntAttribute((Node)object4, "gray");
                    this.sBIT_alphaBits = this.getIntAttribute((Node)object4, "alpha");
                    this.sBIT_colorType = 4;
                } else if (string6.equals("sBIT_RGB")) {
                    this.sBIT_redBits = this.getIntAttribute((Node)object4, "red");
                    this.sBIT_greenBits = this.getIntAttribute((Node)object4, "green");
                    this.sBIT_blueBits = this.getIntAttribute((Node)object4, "blue");
                    this.sBIT_colorType = 2;
                } else if (string6.equals("sBIT_RGBAlpha")) {
                    this.sBIT_redBits = this.getIntAttribute((Node)object4, "red");
                    this.sBIT_greenBits = this.getIntAttribute((Node)object4, "green");
                    this.sBIT_blueBits = this.getIntAttribute((Node)object4, "blue");
                    this.sBIT_alphaBits = this.getIntAttribute((Node)object4, "alpha");
                    this.sBIT_colorType = 6;
                } else if (string6.equals("sBIT_Palette")) {
                    this.sBIT_redBits = this.getIntAttribute((Node)object4, "red");
                    this.sBIT_greenBits = this.getIntAttribute((Node)object4, "green");
                    this.sBIT_blueBits = this.getIntAttribute((Node)object4, "blue");
                    this.sBIT_colorType = 3;
                } else {
                    this.fatal(node2, "Bad child of an sBIT node!");
                }
                if (object4.getNextSibling() != null) {
                    this.fatal(node2, "sBIT node has more than one child!");
                }
                this.sBIT_present = true;
                continue;
            }
            if (string.equals("sPLT")) {
                int n7;
                this.sPLT_paletteName = this.getAttribute(node2, "name");
                this.sPLT_sampleDepth = this.getIntAttribute(node2, "sampleDepth");
                object4 = new int[256];
                int[] nArray = new int[256];
                object3 = new int[256];
                int[] nArray2 = new int[256];
                object2 = new int[256];
                int n8 = -1;
                object = node2.getFirstChild();
                if (object == null) {
                    this.fatal(node2, "sPLT node has no children!");
                }
                while (object != null) {
                    if (!object.getNodeName().equals("sPLTEntry")) {
                        this.fatal(node2, "Only an sPLTEntry may be a child of an sPLT!");
                    }
                    if ((n7 = this.getIntAttribute((Node)object, "index")) < 0 || n7 > 255) {
                        this.fatal(node2, "Bad value for PLTEEntry attribute index!");
                    }
                    if (n7 > n8) {
                        n8 = n7;
                    }
                    object4[n7] = this.getIntAttribute((Node)object, "red");
                    nArray[n7] = this.getIntAttribute((Node)object, "green");
                    object3[n7] = this.getIntAttribute((Node)object, "blue");
                    nArray2[n7] = this.getIntAttribute((Node)object, "alpha");
                    object2[n7] = this.getIntAttribute((Node)object, "frequency");
                    object = object.getNextSibling();
                }
                n7 = n8 + 1;
                this.sPLT_red = new int[n7];
                this.sPLT_green = new int[n7];
                this.sPLT_blue = new int[n7];
                this.sPLT_alpha = new int[n7];
                this.sPLT_frequency = new int[n7];
                System.arraycopy(object4, 0, this.sPLT_red, 0, n7);
                System.arraycopy(nArray, 0, this.sPLT_green, 0, n7);
                System.arraycopy(object3, 0, this.sPLT_blue, 0, n7);
                System.arraycopy(nArray2, 0, this.sPLT_alpha, 0, n7);
                System.arraycopy(object2, 0, this.sPLT_frequency, 0, n7);
                this.sPLT_present = true;
                continue;
            }
            if (string.equals("sRGB")) {
                this.sRGB_renderingIntent = this.getEnumeratedAttribute(node2, "renderingIntent", renderingIntentNames);
                this.sRGB_present = true;
                continue;
            }
            if (string.equals("tEXt")) {
                for (object4 = node2.getFirstChild(); object4 != null; object4 = object4.getNextSibling()) {
                    if (!object4.getNodeName().equals("tEXtEntry")) {
                        this.fatal(node2, "Only an tEXtEntry may be a child of an tEXt!");
                    }
                    String string7 = this.getAttribute((Node)object4, "keyword");
                    this.tEXt_keyword.add(string7);
                    object3 = this.getAttribute((Node)object4, "value");
                    this.tEXt_text.add(object3);
                }
                continue;
            }
            if (string.equals("tIME")) {
                this.tIME_year = this.getIntAttribute(node2, "year");
                this.tIME_month = this.getIntAttribute(node2, "month");
                this.tIME_day = this.getIntAttribute(node2, "day");
                this.tIME_hour = this.getIntAttribute(node2, "hour");
                this.tIME_minute = this.getIntAttribute(node2, "minute");
                this.tIME_second = this.getIntAttribute(node2, "second");
                this.tIME_present = true;
                continue;
            }
            if (string.equals("tRNS")) {
                String string8;
                this.tRNS_present = false;
                object4 = node2.getFirstChild();
                if (object4 == null) {
                    this.fatal(node2, "tRNS node has no children!");
                }
                if ((string8 = object4.getNodeName()).equals("tRNS_Palette")) {
                    int n9;
                    object3 = new byte[256];
                    int n10 = -1;
                    object2 = object4.getFirstChild();
                    if (object2 == null) {
                        this.fatal(node2, "tRNS_Palette node has no children!");
                    }
                    while (object2 != null) {
                        if (!object2.getNodeName().equals("tRNS_PaletteEntry")) {
                            this.fatal(node2, "Only a tRNS_PaletteEntry may be a child of a tRNS_Palette!");
                        }
                        if ((n9 = this.getIntAttribute((Node)object2, "index")) < 0 || n9 > 255) {
                            this.fatal(node2, "Bad value for tRNS_PaletteEntry attribute index!");
                        }
                        if (n9 > n10) {
                            n10 = n9;
                        }
                        object3[n9] = (byte)this.getIntAttribute((Node)object2, "alpha");
                        object2 = object2.getNextSibling();
                    }
                    n9 = n10 + 1;
                    this.tRNS_alpha = new byte[n9];
                    this.tRNS_colorType = 3;
                    System.arraycopy(object3, 0, this.tRNS_alpha, 0, n9);
                } else if (string8.equals("tRNS_Grayscale")) {
                    this.tRNS_gray = this.getIntAttribute((Node)object4, "gray");
                    this.tRNS_colorType = 0;
                } else if (string8.equals("tRNS_RGB")) {
                    this.tRNS_red = this.getIntAttribute((Node)object4, "red");
                    this.tRNS_green = this.getIntAttribute((Node)object4, "green");
                    this.tRNS_blue = this.getIntAttribute((Node)object4, "blue");
                    this.tRNS_colorType = 2;
                } else {
                    this.fatal(node2, "Bad child of a tRNS node!");
                }
                if (object4.getNextSibling() != null) {
                    this.fatal(node2, "tRNS node has more than one child!");
                }
                this.tRNS_present = true;
                continue;
            }
            if (string.equals("zTXt")) {
                for (object4 = (Object)node2.getFirstChild(); object4 != null; object4 = object4.getNextSibling()) {
                    if (!object4.getNodeName().equals("zTXtEntry")) {
                        this.fatal(node2, "Only an zTXtEntry may be a child of an zTXt!");
                    }
                    String string9 = this.getAttribute((Node)object4, "keyword");
                    this.zTXt_keyword.add(string9);
                    int n11 = this.getEnumeratedAttribute((Node)object4, "compressionMethod", zTXt_compressionMethodNames);
                    this.zTXt_compressionMethod.add(new Integer(n11));
                    String string10 = this.getAttribute((Node)object4, "text");
                    this.zTXt_text.add(string10);
                }
                continue;
            }
            if (string.equals("UnknownChunks")) {
                for (object4 = node2.getFirstChild(); object4 != null; object4 = object4.getNextSibling()) {
                    if (!object4.getNodeName().equals("UnknownChunk")) {
                        this.fatal(node2, "Only an UnknownChunk may be a child of an UnknownChunks!");
                    }
                    String string11 = this.getAttribute((Node)object4, "type");
                    object3 = ((IIOMetadataNode)object4).getUserObject();
                    if (string11.length() != 4) {
                        this.fatal((Node)object4, "Chunk type must be 4 characters!");
                    }
                    if (object3 == null) {
                        this.fatal((Node)object4, "No chunk data present in user object!");
                    }
                    if (!(object3 instanceof byte[])) {
                        this.fatal((Node)object4, "User object not a byte array!");
                    }
                    this.unknownChunkType.add(string11);
                    this.unknownChunkData.add(object3.clone());
                }
                continue;
            }
            this.fatal(node2, "Unknown child of root node!");
        }
    }

    private void mergeStandardTree(Node node) throws IIOInvalidTreeException {
        Node node2 = node;
        if (!node2.getNodeName().equals("javax_imageio_1.0")) {
            this.fatal(node2, "Root must be javax_imageio_1.0");
        }
        for (node2 = node2.getFirstChild(); node2 != null; node2 = node2.getNextSibling()) {
            Object object;
            String string = node2.getNodeName();
            if (string.equals("Chroma")) {
                for (Node node3 = node2.getFirstChild(); node3 != null; node3 = node3.getNextSibling()) {
                    String string2 = node3.getNodeName();
                    if (string2.equals("Gamma")) {
                        float f2 = this.getFloatAttribute(node3, "value");
                        this.gAMA_present = true;
                        this.gAMA_gamma = (int)((double)(f2 * 100000.0f) + 0.5);
                        continue;
                    }
                    if (string2.equals("Palette")) {
                        int n2;
                        byte[] byArray = new byte[256];
                        byte[] byArray2 = new byte[256];
                        byte[] byArray3 = new byte[256];
                        int n3 = -1;
                        for (object = node3.getFirstChild(); object != null; object = object.getNextSibling()) {
                            n2 = this.getIntAttribute((Node)object, "index");
                            if (n2 < 0 || n2 > 255) continue;
                            byArray[n2] = (byte)this.getIntAttribute((Node)object, "red");
                            byArray2[n2] = (byte)this.getIntAttribute((Node)object, "green");
                            byArray3[n2] = (byte)this.getIntAttribute((Node)object, "blue");
                            if (n2 <= n3) continue;
                            n3 = n2;
                        }
                        n2 = n3 + 1;
                        this.PLTE_red = new byte[n2];
                        this.PLTE_green = new byte[n2];
                        this.PLTE_blue = new byte[n2];
                        System.arraycopy(byArray, 0, this.PLTE_red, 0, n2);
                        System.arraycopy(byArray2, 0, this.PLTE_green, 0, n2);
                        System.arraycopy(byArray3, 0, this.PLTE_blue, 0, n2);
                        this.PLTE_present = true;
                        continue;
                    }
                    if (string2.equals("BackgroundIndex")) {
                        this.bKGD_present = true;
                        this.bKGD_colorType = 3;
                        this.bKGD_index = this.getIntAttribute(node3, "value");
                        continue;
                    }
                    if (!string2.equals("BackgroundColor")) continue;
                    int n4 = this.getIntAttribute(node3, "red");
                    int n5 = this.getIntAttribute(node3, "green");
                    int n6 = this.getIntAttribute(node3, "blue");
                    if (n4 == n5 && n4 == n6) {
                        this.bKGD_colorType = 0;
                        this.bKGD_gray = n4;
                    } else {
                        this.bKGD_red = n4;
                        this.bKGD_green = n5;
                        this.bKGD_blue = n6;
                    }
                    this.bKGD_present = true;
                }
                continue;
            }
            if (string.equals("Compression")) {
                for (Node node4 = node2.getFirstChild(); node4 != null; node4 = node4.getNextSibling()) {
                    String string3 = node4.getNodeName();
                    if (!string3.equals("NumProgressiveScans")) continue;
                    int n7 = this.getIntAttribute(node4, "value");
                    this.IHDR_interlaceMethod = n7 > 1 ? 1 : 0;
                }
                continue;
            }
            if (string.equals("Data")) {
                for (Node node5 = node2.getFirstChild(); node5 != null; node5 = node5.getNextSibling()) {
                    int n8;
                    StringTokenizer stringTokenizer;
                    String string4;
                    String string5 = node5.getNodeName();
                    if (string5.equals("BitsPerSample")) {
                        string4 = this.getAttribute(node5, "value");
                        stringTokenizer = new StringTokenizer(string4);
                        n8 = -1;
                        while (stringTokenizer.hasMoreTokens()) {
                            int n9 = Integer.parseInt(stringTokenizer.nextToken());
                            if (n9 <= n8) continue;
                            n8 = n9;
                        }
                        if (n8 < 1) {
                            n8 = 1;
                        }
                        if (n8 == 3) {
                            n8 = 4;
                        }
                        if (n8 > 4 || n8 < 8) {
                            n8 = 8;
                        }
                        if (n8 > 8) {
                            n8 = 16;
                        }
                        this.IHDR_bitDepth = n8;
                        continue;
                    }
                    if (!string5.equals("SignificantBitsPerSample")) continue;
                    string4 = this.getAttribute(node5, "value");
                    stringTokenizer = new StringTokenizer(string4);
                    n8 = stringTokenizer.countTokens();
                    if (n8 == 1) {
                        this.sBIT_colorType = 0;
                        this.sBIT_grayBits = Integer.parseInt(stringTokenizer.nextToken());
                    } else if (n8 == 2) {
                        this.sBIT_colorType = 4;
                        this.sBIT_grayBits = Integer.parseInt(stringTokenizer.nextToken());
                        this.sBIT_alphaBits = Integer.parseInt(stringTokenizer.nextToken());
                    } else if (n8 == 3) {
                        this.sBIT_colorType = 2;
                        this.sBIT_redBits = Integer.parseInt(stringTokenizer.nextToken());
                        this.sBIT_greenBits = Integer.parseInt(stringTokenizer.nextToken());
                        this.sBIT_blueBits = Integer.parseInt(stringTokenizer.nextToken());
                    } else if (n8 == 4) {
                        this.sBIT_colorType = 6;
                        this.sBIT_redBits = Integer.parseInt(stringTokenizer.nextToken());
                        this.sBIT_greenBits = Integer.parseInt(stringTokenizer.nextToken());
                        this.sBIT_blueBits = Integer.parseInt(stringTokenizer.nextToken());
                        this.sBIT_alphaBits = Integer.parseInt(stringTokenizer.nextToken());
                    }
                    if (n8 < 1 || n8 > 4) continue;
                    this.sBIT_present = true;
                }
                continue;
            }
            if (string.equals("Dimension")) {
                int n10;
                int n11;
                boolean bl2 = false;
                boolean bl3 = false;
                boolean bl4 = false;
                float f3 = -1.0f;
                float f4 = -1.0f;
                float f5 = -1.0f;
                for (object = node2.getFirstChild(); object != null; object = object.getNextSibling()) {
                    String string6 = object.getNodeName();
                    if (string6.equals("PixelAspectRatio")) {
                        f5 = this.getFloatAttribute((Node)object, "value");
                        bl4 = true;
                        continue;
                    }
                    if (string6.equals("HorizontalPixelSize")) {
                        f3 = this.getFloatAttribute((Node)object, "value");
                        bl2 = true;
                        continue;
                    }
                    if (!string6.equals("VerticalPixelSize")) continue;
                    f4 = this.getFloatAttribute((Node)object, "value");
                    bl3 = true;
                }
                if (bl2 && bl3) {
                    this.pHYs_present = true;
                    this.pHYs_unitSpecifier = 1;
                    this.pHYs_pixelsPerUnitXAxis = (int)(f3 * 1000.0f + 0.5f);
                    this.pHYs_pixelsPerUnitYAxis = (int)(f4 * 1000.0f + 0.5f);
                    continue;
                }
                if (!bl4) continue;
                this.pHYs_present = true;
                this.pHYs_unitSpecifier = 0;
                for (n11 = 1; n11 < 100 && !((double)Math.abs((float)((n10 = (int)(f5 * (float)n11)) / n11) - f5) < 0.001); ++n11) {
                }
                this.pHYs_pixelsPerUnitXAxis = (int)(f5 * (float)n11);
                this.pHYs_pixelsPerUnitYAxis = n11;
                continue;
            }
            if (string.equals("Document")) {
                for (Node node6 = node2.getFirstChild(); node6 != null; node6 = node6.getNextSibling()) {
                    String string7 = node6.getNodeName();
                    if (!string7.equals("ImageModificationTime")) continue;
                    this.tIME_present = true;
                    this.tIME_year = this.getIntAttribute(node6, "year");
                    this.tIME_month = this.getIntAttribute(node6, "month");
                    this.tIME_day = this.getIntAttribute(node6, "day");
                    this.tIME_hour = this.getIntAttribute(node6, "hour", 0, false);
                    this.tIME_minute = this.getIntAttribute(node6, "minute", 0, false);
                    this.tIME_second = this.getIntAttribute(node6, "second", 0, false);
                }
                continue;
            }
            if (!string.equals("Text")) continue;
            for (Node node7 = node2.getFirstChild(); node7 != null; node7 = node7.getNextSibling()) {
                String string8 = node7.getNodeName();
                if (!string8.equals("TextEntry")) continue;
                String string9 = this.getAttribute(node7, "keyword");
                String string10 = this.getAttribute(node7, "value");
                String string11 = this.getAttribute(node7, "encoding");
                String string12 = this.getAttribute(node7, "language");
                object = this.getAttribute(node7, "compression");
                if (this.isISOLatin(string10)) {
                    if (((String)object).equals("zip")) {
                        this.zTXt_keyword.add(string9);
                        this.zTXt_text.add(string10);
                        this.zTXt_compressionMethod.add(new Integer(0));
                        continue;
                    }
                    this.tEXt_keyword.add(string9);
                    this.tEXt_text.add(string10);
                    continue;
                }
                int n12 = ((String)object).equals("zip") ? 1 : 0;
                this.iTXt_keyword.add(string9);
                this.iTXt_compressionFlag.add(new Integer(n12));
                this.iTXt_compressionMethod.add(new Integer(0));
                this.iTXt_languageTag.add(string12);
                this.iTXt_translatedKeyword.add(string9);
                this.iTXt_text.add(string10);
            }
        }
    }

    private String repeat(String string, int n2) {
        if (n2 == 1) {
            return string;
        }
        StringBuffer stringBuffer = new StringBuffer((string.length() + 1) * n2 - 1);
        stringBuffer.append(string);
        for (int i2 = 1; i2 < n2; ++i2) {
            stringBuffer.append(" ");
            stringBuffer.append(string);
        }
        return stringBuffer.toString();
    }

    private float getFloatAttribute(Node node, String string) throws IIOInvalidTreeException {
        return this.getFloatAttribute(node, string, -1.0f, true);
    }

    private int getIntAttribute(Node node, String string) throws IIOInvalidTreeException {
        return this.getIntAttribute(node, string, -1, true);
    }

    private void fatal(Node node, String string) throws IIOInvalidTreeException {
        throw new IIOInvalidTreeException(string, node);
    }

    private boolean getBooleanAttribute(Node node, String string) throws IIOInvalidTreeException {
        return this.getBooleanAttribute(node, string, false, true);
    }

    private float getFloatAttribute(Node node, String string, float f2, boolean bl2) throws IIOInvalidTreeException {
        String string2 = this.getStringAttribute(node, string, null, bl2);
        if (string2 == null) {
            return f2;
        }
        return Float.parseFloat(string2);
    }

    private int getIntAttribute(Node node, String string, int n2, boolean bl2) throws IIOInvalidTreeException {
        String string2 = this.getStringAttribute(node, string, null, bl2);
        if (string2 == null) {
            return n2;
        }
        return Integer.parseInt(string2);
    }

    private boolean getBooleanAttribute(Node node, String string, boolean bl2, boolean bl3) throws IIOInvalidTreeException {
        String string2;
        Node node2 = node.getAttributes().getNamedItem(string);
        if (node2 == null) {
            if (!bl3) {
                return bl2;
            }
            this.fatal(node, "Required attribute " + string + " not present!");
        }
        if ((string2 = node2.getNodeValue()).equals("true")) {
            return true;
        }
        if (string2.equals("false")) {
            return false;
        }
        this.fatal(node, "Attribute " + string + " must be 'true' or 'false'!");
        return false;
    }

    private ArrayList cloneBytesArrayList(ArrayList arrayList) {
        if (arrayList == null) {
            return null;
        }
        ArrayList arrayList2 = new ArrayList(arrayList.size());
        Iterator iterator = arrayList.iterator();
        while (iterator.hasNext()) {
            Object object = iterator.next();
            if (object == null) {
                arrayList2.add(null);
                continue;
            }
            arrayList2.add(((byte[])object).clone());
        }
        return arrayList2;
    }

    public Node getAsTree(String string) {
        if (string.equals(nativeMetadataFormatName)) {
            return this.getNativeTree();
        }
        if (string.equals("javax_imageio_1.0")) {
            return this.getStandardTree();
        }
        throw new IllegalArgumentException("Not a recognized format!");
    }

    public void mergeTree(String string, Node node) throws IIOInvalidTreeException {
        if (string.equals(nativeMetadataFormatName)) {
            if (node == null) {
                throw new IllegalArgumentException("root == null!");
            }
            this.mergeNativeTree(node);
        } else if (string.equals("javax_imageio_1.0")) {
            if (node == null) {
                throw new IllegalArgumentException("root == null!");
            }
            this.mergeStandardTree(node);
        } else {
            throw new IllegalArgumentException("Not a recognized format!");
        }
    }

    private String getAttribute(Node node, String string) throws IIOInvalidTreeException {
        return this.getAttribute(node, string, null, true);
    }

    private int getEnumeratedAttribute(Node node, String string, String[] stringArray) throws IIOInvalidTreeException {
        return this.getEnumeratedAttribute(node, string, stringArray, -1, true);
    }

    private int getEnumeratedAttribute(Node node, String string, String[] stringArray, int n2, boolean bl2) throws IIOInvalidTreeException {
        Node node2 = node.getAttributes().getNamedItem(string);
        if (node2 == null) {
            if (!bl2) {
                return n2;
            }
            this.fatal(node, "Required attribute " + string + " not present!");
        }
        String string2 = node2.getNodeValue();
        for (int i2 = 0; i2 < stringArray.length; ++i2) {
            if (!string2.equals(stringArray[i2])) continue;
            return i2;
        }
        this.fatal(node, "Illegal value for attribute " + string + "!");
        return -1;
    }

    private String getAttribute(Node node, String string, String string2, boolean bl2) throws IIOInvalidTreeException {
        Node node2 = node.getAttributes().getNamedItem(string);
        if (node2 == null) {
            if (!bl2) {
                return string2;
            }
            this.fatal(node, "Required attribute " + string + " not present!");
        }
        return node2.getNodeValue();
    }

    private String getStringAttribute(Node node, String string, String string2, boolean bl2) throws IIOInvalidTreeException {
        Node node2 = node.getAttributes().getNamedItem(string);
        if (node2 == null) {
            if (!bl2) {
                return string2;
            }
            this.fatal(node, "Required attribute " + string + " not present!");
        }
        return node2.getNodeValue();
    }
}

