/*
 * Decompiled with CFR 0.152.
 */
package com.sun.java.swing.plaf.gtk;

import com.sun.java.swing.plaf.gtk.ColorType;
import com.sun.java.swing.plaf.gtk.LazyActionMap;
import com.sun.java.swing.plaf.gtk.Region;
import com.sun.java.swing.plaf.gtk.SynthContext;
import com.sun.java.swing.plaf.gtk.SynthDragGestureRecognizer;
import com.sun.java.swing.plaf.gtk.SynthDropTargetListener;
import com.sun.java.swing.plaf.gtk.SynthGraphics;
import com.sun.java.swing.plaf.gtk.SynthLookAndFeel;
import com.sun.java.swing.plaf.gtk.SynthStyle;
import com.sun.java.swing.plaf.gtk.SynthTransferable;
import com.sun.java.swing.plaf.gtk.SynthUI;
import java.awt.Color;
import java.awt.Component;
import java.awt.ComponentOrientation;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.datatransfer.Transferable;
import java.awt.dnd.DropTarget;
import java.awt.dnd.DropTargetListener;
import java.awt.event.ActionEvent;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.Enumeration;
import java.util.TooManyListenersException;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.ActionMap;
import javax.swing.CellRendererPane;
import javax.swing.InputMap;
import javax.swing.JComponent;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.KeyStroke;
import javax.swing.ListSelectionModel;
import javax.swing.SwingUtilities;
import javax.swing.TransferHandler;
import javax.swing.event.MouseInputListener;
import javax.swing.plaf.ComponentUI;
import javax.swing.plaf.TableUI;
import javax.swing.plaf.UIResource;
import javax.swing.table.JTableHeader;
import javax.swing.table.TableCellEditor;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableColumn;
import javax.swing.table.TableColumnModel;

class SynthTableUI
extends TableUI
implements SynthUI {
    private SynthStyle style;
    protected JTable table;
    protected CellRendererPane rendererPane;
    protected KeyListener keyListener;
    protected FocusListener focusListener;
    protected MouseInputListener mouseInputListener;
    private PropertyChangeListener propertyChangeListener;
    private static final TableDragGestureRecognizer defaultDragRecognizer = new TableDragGestureRecognizer();
    private static DropTargetListener defaultDropTargetListener = null;
    private static final TransferHandler defaultTransferHandler = new TableTransferHandler();

    SynthTableUI() {
    }

    protected void installDefaults() {
        DropTarget dropTarget;
        this.fetchStyle(this.table);
        TransferHandler transferHandler = this.table.getTransferHandler();
        if (transferHandler == null || transferHandler instanceof UIResource) {
            this.table.setTransferHandler(defaultTransferHandler);
        }
        if ((dropTarget = this.table.getDropTarget()) instanceof UIResource) {
            if (defaultDropTargetListener == null) {
                defaultDropTargetListener = new TableDropTargetListener();
            }
            try {
                dropTarget.addDropTargetListener(defaultDropTargetListener);
            }
            catch (TooManyListenersException tooManyListenersException) {
                // empty catch block
            }
        }
    }

    protected void installKeyboardActions() {
        LazyActionMap.installLazyActionMap(this.table, SynthTableUI.class, "Table.actionMap");
        InputMap inputMap = this.getInputMap(1);
        SwingUtilities.replaceUIInputMap(this.table, 1, inputMap);
    }

    protected void installListeners() {
        this.focusListener = this.createFocusListener();
        this.keyListener = this.createKeyListener();
        this.mouseInputListener = this.createMouseInputListener();
        this.propertyChangeListener = this.createPropertyChangeListener();
        this.table.addFocusListener(this.focusListener);
        this.table.addKeyListener(this.keyListener);
        this.table.addMouseListener(defaultDragRecognizer);
        this.table.addMouseMotionListener(defaultDragRecognizer);
        this.table.addMouseListener(this.mouseInputListener);
        this.table.addMouseMotionListener(this.mouseInputListener);
        this.table.addPropertyChangeListener(this.propertyChangeListener);
    }

    protected void uninstallDefaults() {
        if (this.table.getTransferHandler() instanceof UIResource) {
            this.table.setTransferHandler(null);
        }
        SynthContext synthContext = this.getContext(this.table, 1);
        this.style.uninstallDefaults(synthContext);
        synthContext.dispose();
        this.style = null;
    }

    protected void uninstallKeyboardActions() {
        SwingUtilities.replaceUIInputMap(this.table, 1, null);
        SwingUtilities.replaceUIActionMap(this.table, null);
    }

    protected void uninstallListeners() {
        this.table.removeFocusListener(this.focusListener);
        this.table.removeKeyListener(this.keyListener);
        this.table.removeMouseListener(defaultDragRecognizer);
        this.table.removeMouseMotionListener(defaultDragRecognizer);
        this.table.removeMouseListener(this.mouseInputListener);
        this.table.removeMouseMotionListener(this.mouseInputListener);
        this.table.removePropertyChangeListener(this.propertyChangeListener);
        this.focusListener = null;
        this.keyListener = null;
        this.mouseInputListener = null;
        this.propertyChangeListener = null;
    }

    private Dimension createTableSize(long l2) {
        long l3;
        int n2 = 0;
        int n3 = this.table.getRowCount();
        if (n3 > 0 && this.table.getColumnCount() > 0) {
            Rectangle rectangle = this.table.getCellRect(n3 - 1, 0, true);
            n2 = rectangle.y + rectangle.height;
        }
        if ((l3 = Math.abs(l2)) > Integer.MAX_VALUE) {
            l3 = Integer.MAX_VALUE;
        }
        return new Dimension((int)l3, n2);
    }

    protected FocusListener createFocusListener() {
        return new FocusHandler();
    }

    protected KeyListener createKeyListener() {
        return null;
    }

    private PropertyChangeListener createPropertyChangeListener() {
        return new PropertyChangeHandler();
    }

    public static void loadActionMap(ActionMap actionMap) {
        actionMap.put("selectNextColumn", new NavigationalAction(1, 0, false, false, false));
        actionMap.put("selectPreviousColumn", new NavigationalAction(-1, 0, false, false, false));
        actionMap.put("selectNextRow", new NavigationalAction(0, 1, false, false, false));
        actionMap.put("selectPreviousRow", new NavigationalAction(0, -1, false, false, false));
        actionMap.put("selectNextColumnExtendSelection", new NavigationalAction(1, 0, false, true, false));
        actionMap.put("selectPreviousColumnExtendSelection", new NavigationalAction(-1, 0, false, true, false));
        actionMap.put("selectNextRowExtendSelection", new NavigationalAction(0, 1, false, true, false));
        actionMap.put("selectPreviousRowExtendSelection", new NavigationalAction(0, -1, false, true, false));
        actionMap.put("scrollUpChangeSelection", new PagingAction(false, false, true, false));
        actionMap.put("scrollDownChangeSelection", new PagingAction(false, true, true, false));
        actionMap.put("selectFirstColumn", new PagingAction(false, false, false, true));
        actionMap.put("selectLastColumn", new PagingAction(false, true, false, true));
        actionMap.put("scrollUpExtendSelection", new PagingAction(true, false, true, false));
        actionMap.put("scrollDownExtendSelection", new PagingAction(true, true, true, false));
        actionMap.put("selectFirstColumnExtendSelection", new PagingAction(true, false, false, true));
        actionMap.put("selectLastColumnExtendSelection", new PagingAction(true, true, false, true));
        actionMap.put("selectFirstRow", new PagingAction(false, false, true, true));
        actionMap.put("selectLastRow", new PagingAction(false, true, true, true));
        actionMap.put("selectFirstRowExtendSelection", new PagingAction(true, false, true, true));
        actionMap.put("selectLastRowExtendSelection", new PagingAction(true, true, true, true));
        actionMap.put("selectNextColumnCell", new NavigationalAction(1, 0, true, false, true));
        actionMap.put("selectPreviousColumnCell", new NavigationalAction(-1, 0, true, false, true));
        actionMap.put("selectNextRowCell", new NavigationalAction(0, 1, true, false, true));
        actionMap.put("selectPreviousRowCell", new NavigationalAction(0, -1, true, false, true));
        actionMap.put("selectAll", new SelectAllAction());
        actionMap.put("cancel", new CancelEditingAction());
        actionMap.put("startEditing", new StartEditingAction());
        actionMap.put(TransferHandler.getCutAction().getValue("Name"), TransferHandler.getCutAction());
        actionMap.put(TransferHandler.getCopyAction().getValue("Name"), TransferHandler.getCopyAction());
        actionMap.put(TransferHandler.getPasteAction().getValue("Name"), TransferHandler.getPasteAction());
        actionMap.put("scrollLeftChangeSelection", new PagingAction(false, false, false, false));
        actionMap.put("scrollRightChangeSelection", new PagingAction(false, true, false, false));
        actionMap.put("scrollLeftExtendSelection", new PagingAction(true, false, false, false));
        actionMap.put("scrollRightExtendSelection", new PagingAction(true, true, false, false));
    }

    InputMap getInputMap(int n2) {
        if (n2 == 1) {
            InputMap inputMap;
            SynthContext synthContext = this.getContext(this.table, 1);
            InputMap inputMap2 = (InputMap)this.style.get(synthContext, "Table.ancestorInputMap");
            if (!this.table.getComponentOrientation().isLeftToRight() && (inputMap = (InputMap)this.style.get(synthContext, "Table.ancestorInputMap.RightToLeft")) == null) {
                inputMap.setParent(inputMap2);
                inputMap2 = inputMap;
            }
            synthContext.dispose();
            return inputMap2;
        }
        return null;
    }

    private int getComponentState(JComponent jComponent) {
        return SynthLookAndFeel.getComponentState(jComponent);
    }

    public void installUI(JComponent jComponent) {
        this.table = (JTable)jComponent;
        this.rendererPane = new CellRendererPane();
        this.table.add(this.rendererPane);
        this.installDefaults();
        this.installListeners();
        this.installKeyboardActions();
    }

    public void uninstallUI(JComponent jComponent) {
        this.uninstallDefaults();
        this.uninstallListeners();
        this.uninstallKeyboardActions();
        this.table.remove(this.rendererPane);
        this.rendererPane = null;
        this.table = null;
    }

    private void fetchStyle(JTable jTable) {
        SynthContext synthContext = this.getContext(jTable, 1);
        SynthStyle synthStyle = this.style;
        this.style = SynthLookAndFeel.updateStyle(synthContext, this);
        if (this.style != synthStyle) {
            Color color;
            synthContext.setComponentState(513);
            Color color2 = this.table.getSelectionBackground();
            if (color2 == null || color2 instanceof UIResource) {
                this.table.setSelectionBackground(this.style.getColor(synthContext, ColorType.TEXT_BACKGROUND));
            }
            if ((color = this.table.getSelectionForeground()) == null || color instanceof UIResource) {
                this.table.setSelectionForeground(this.style.getColor(synthContext, ColorType.TEXT_FOREGROUND));
            }
            synthContext.setComponentState(1);
            Color color3 = this.table.getGridColor();
            if (color3 == null || color3 instanceof UIResource) {
                color3 = (Color)this.style.get(synthContext, "Table.gridColor");
                if (color3 == null) {
                    color3 = this.style.getColor(synthContext, ColorType.FOREGROUND);
                }
                this.table.setGridColor(color3);
            }
        }
        synthContext.dispose();
    }

    protected MouseInputListener createMouseInputListener() {
        return new MouseInputHandler();
    }

    private int viewIndexForColumn(TableColumn tableColumn) {
        TableColumnModel tableColumnModel = this.table.getColumnModel();
        for (int i2 = 0; i2 < tableColumnModel.getColumnCount(); ++i2) {
            if (tableColumnModel.getColumn(i2) != tableColumn) continue;
            return i2;
        }
        return -1;
    }

    private Region getRegion(JComponent jComponent) {
        return SynthLookAndFeel.getRegion(jComponent);
    }

    public SynthContext getContext(JComponent jComponent) {
        return this.getContext(jComponent, this.getComponentState(jComponent));
    }

    private SynthContext getContext(JComponent jComponent, int n2) {
        return SynthContext.getContext(SynthContext.class, jComponent, SynthLookAndFeel.getRegion(jComponent), this.style, n2);
    }

    public Dimension getMaximumSize(JComponent jComponent) {
        long l2 = 0L;
        Enumeration enumeration = this.table.getColumnModel().getColumns();
        while (enumeration.hasMoreElements()) {
            TableColumn tableColumn = (TableColumn)enumeration.nextElement();
            l2 += (long)tableColumn.getMaxWidth();
        }
        return this.createTableSize(l2);
    }

    public Dimension getMinimumSize(JComponent jComponent) {
        long l2 = 0L;
        Enumeration enumeration = this.table.getColumnModel().getColumns();
        while (enumeration.hasMoreElements()) {
            TableColumn tableColumn = (TableColumn)enumeration.nextElement();
            l2 += (long)tableColumn.getMinWidth();
        }
        return this.createTableSize(l2);
    }

    public Dimension getPreferredSize(JComponent jComponent) {
        long l2 = 0L;
        Enumeration enumeration = this.table.getColumnModel().getColumns();
        while (enumeration.hasMoreElements()) {
            TableColumn tableColumn = (TableColumn)enumeration.nextElement();
            l2 += (long)tableColumn.getPreferredWidth();
        }
        return this.createTableSize(l2);
    }

    protected void paint(SynthContext synthContext, Graphics graphics) {
        boolean bl2;
        if (this.table.getRowCount() <= 0 || this.table.getColumnCount() <= 0) {
            return;
        }
        Rectangle rectangle = graphics.getClipBounds();
        Point point = rectangle.getLocation();
        Point point2 = new Point(rectangle.x + rectangle.width - 1, rectangle.y + rectangle.height - 1);
        int n2 = this.table.rowAtPoint(point);
        int n3 = this.table.rowAtPoint(point2);
        if (n2 == -1) {
            n2 = 0;
        }
        if (n3 == -1) {
            n3 = this.table.getRowCount() - 1;
        }
        int n4 = this.table.columnAtPoint((bl2 = this.table.getComponentOrientation().isLeftToRight()) ? point : point2);
        int n5 = this.table.columnAtPoint(bl2 ? point2 : point);
        if (n4 == -1) {
            n4 = 0;
        }
        if (n5 == -1) {
            n5 = this.table.getColumnCount() - 1;
        }
        this.paintGrid(synthContext, graphics, n2, n3, n4, n5);
        this.paintCells(synthContext, graphics, n2, n3, n4, n5);
    }

    private void paintCells(SynthContext synthContext, Graphics graphics, int n2, int n3, int n4, int n5) {
        JTableHeader jTableHeader = this.table.getTableHeader();
        TableColumn tableColumn = jTableHeader == null ? null : jTableHeader.getDraggedColumn();
        TableColumnModel tableColumnModel = this.table.getColumnModel();
        int n6 = tableColumnModel.getColumnMargin();
        if (this.table.getComponentOrientation().isLeftToRight()) {
            for (int i2 = n2; i2 <= n3; ++i2) {
                Rectangle rectangle = this.table.getCellRect(i2, n4, false);
                for (int i3 = n4; i3 <= n5; ++i3) {
                    TableColumn tableColumn2 = tableColumnModel.getColumn(i3);
                    int n7 = tableColumn2.getWidth();
                    rectangle.width = n7 - n6;
                    if (tableColumn2 != tableColumn) {
                        this.paintCell(graphics, rectangle, i2, i3);
                    }
                    rectangle.x += n7;
                }
            }
        } else {
            for (int i4 = n2; i4 <= n3; ++i4) {
                int n8;
                Rectangle rectangle = this.table.getCellRect(i4, n4, false);
                TableColumn tableColumn3 = tableColumnModel.getColumn(n4);
                if (tableColumn3 != tableColumn) {
                    n8 = tableColumn3.getWidth();
                    rectangle.width = n8 - n6;
                    this.paintCell(graphics, rectangle, i4, n4);
                }
                for (int i5 = n4 + 1; i5 <= n5; ++i5) {
                    tableColumn3 = tableColumnModel.getColumn(i5);
                    n8 = tableColumn3.getWidth();
                    rectangle.width = n8 - n6;
                    rectangle.x -= n8;
                    if (tableColumn3 == tableColumn) continue;
                    this.paintCell(graphics, rectangle, i4, i5);
                }
            }
        }
        if (tableColumn != null) {
            this.paintDraggedArea(synthContext, graphics, n2, n3, tableColumn, jTableHeader.getDraggedDistance());
        }
        this.rendererPane.removeAll();
    }

    private void paintGrid(SynthContext synthContext, Graphics graphics, int n2, int n3, int n4, int n5) {
        int n6;
        int n7;
        graphics.setColor(this.table.getGridColor());
        Rectangle rectangle = this.table.getCellRect(n2, n4, true);
        Rectangle rectangle2 = this.table.getCellRect(n3, n5, true);
        Rectangle rectangle3 = rectangle.union(rectangle2);
        SynthGraphics synthGraphics = synthContext.getStyle().getSynthGraphics(synthContext);
        if (this.table.getShowHorizontalLines()) {
            int n8 = rectangle3.x + rectangle3.width;
            n7 = rectangle3.y;
            for (n6 = n2; n6 <= n3; ++n6) {
                synthGraphics.drawLine(synthContext, "Table.grid", graphics, rectangle3.x, (n7 += this.table.getRowHeight(n6)) - 1, n8 - 1, n7 - 1);
            }
        }
        if (this.table.getShowVerticalLines()) {
            TableColumnModel tableColumnModel = this.table.getColumnModel();
            n7 = rectangle3.y + rectangle3.height;
            if (this.table.getComponentOrientation().isLeftToRight()) {
                n6 = rectangle3.x;
                for (int i2 = n4; i2 <= n5; ++i2) {
                    int n9 = tableColumnModel.getColumn(i2).getWidth();
                    synthGraphics.drawLine(synthContext, "Table.grid", graphics, (n6 += n9) - 1, 0, n6 - 1, n7 - 1);
                }
            } else {
                n6 = rectangle3.x + rectangle3.width;
                for (int i3 = n4; i3 < n5; ++i3) {
                    int n10 = tableColumnModel.getColumn(i3).getWidth();
                    synthGraphics.drawLine(synthContext, "Table.grid", graphics, (n6 -= n10) - 1, 0, n6 - 1, n7 - 1);
                }
                synthGraphics.drawLine(synthContext, "Table.grid", graphics, n6 -= tableColumnModel.getColumn(n5).getWidth(), 0, n6, n7 - 1);
            }
        }
    }

    private void paintCell(Graphics graphics, Rectangle rectangle, int n2, int n3) {
        if (this.table.isEditing() && this.table.getEditingRow() == n2 && this.table.getEditingColumn() == n3) {
            Component component = this.table.getEditorComponent();
            component.setBounds(rectangle);
            component.validate();
        } else {
            TableCellRenderer tableCellRenderer = this.table.getCellRenderer(n2, n3);
            Component component = this.table.prepareRenderer(tableCellRenderer, n2, n3);
            this.rendererPane.paintComponent(graphics, component, this.table, rectangle.x, rectangle.y, rectangle.width, rectangle.height, true);
        }
    }

    public void paint(Graphics graphics, JComponent jComponent) {
        SynthContext synthContext = this.getContext(jComponent);
        this.paint(synthContext, graphics);
        synthContext.dispose();
    }

    public void update(Graphics graphics, JComponent jComponent) {
        SynthContext synthContext = this.getContext(jComponent);
        SynthLookAndFeel.update(synthContext, graphics);
        this.paint(synthContext, graphics);
        synthContext.dispose();
    }

    public static ComponentUI createUI(JComponent jComponent) {
        return new SynthTableUI();
    }

    private void paintDraggedArea(SynthContext synthContext, Graphics graphics, int n2, int n3, TableColumn tableColumn, int n4) {
        int n5;
        int n6;
        int n7 = this.viewIndexForColumn(tableColumn);
        Rectangle rectangle = this.table.getCellRect(n2, n7, true);
        Rectangle rectangle2 = this.table.getCellRect(n3, n7, true);
        Rectangle rectangle3 = rectangle.union(rectangle2);
        graphics.setColor(this.table.getParent().getBackground());
        graphics.fillRect(rectangle3.x, rectangle3.y, rectangle3.width, rectangle3.height);
        rectangle3.x += n4;
        graphics.setColor(synthContext.getStyle().getColor(synthContext, ColorType.BACKGROUND));
        graphics.fillRect(rectangle3.x, rectangle3.y, rectangle3.width, rectangle3.height);
        SynthGraphics synthGraphics = synthContext.getStyle().getSynthGraphics(synthContext);
        if (this.table.getShowVerticalLines()) {
            graphics.setColor(this.table.getGridColor());
            n6 = rectangle3.x;
            int n8 = rectangle3.y;
            int n9 = n6 + rectangle3.width - 1;
            n5 = n8 + rectangle3.height - 1;
            synthGraphics.drawLine(synthContext, "Table.grid", graphics, n6 - 1, n8, n6 - 1, n5);
            synthGraphics.drawLine(synthContext, "Table.grid", graphics, n9, n8, n9, n5);
        }
        for (n6 = n2; n6 <= n3; ++n6) {
            Rectangle rectangle4 = this.table.getCellRect(n6, n7, false);
            rectangle4.x += n4;
            this.paintCell(graphics, rectangle4, n6, n7);
            if (!this.table.getShowHorizontalLines()) continue;
            graphics.setColor(this.table.getGridColor());
            Rectangle rectangle5 = this.table.getCellRect(n6, n7, true);
            rectangle5.x += n4;
            n5 = rectangle5.x;
            int n10 = rectangle5.y;
            int n11 = n5 + rectangle5.width - 1;
            int n12 = n10 + rectangle5.height - 1;
            synthGraphics.drawLine(synthContext, "Table.grid", graphics, n5, n12, n11, n12);
        }
    }

    private static class CancelEditingAction
    extends AbstractAction {
        private CancelEditingAction() {
        }

        public void actionPerformed(ActionEvent actionEvent) {
            JTable jTable = (JTable)actionEvent.getSource();
            jTable.removeEditor();
        }
    }

    class FocusHandler
    implements FocusListener {
        private void repaintAnchorCell() {
            int n2 = SynthTableUI.this.table.getRowCount();
            int n3 = SynthTableUI.this.table.getColumnCount();
            int n4 = SynthTableUI.this.table.getSelectionModel().getAnchorSelectionIndex();
            int n5 = SynthTableUI.this.table.getColumnModel().getSelectionModel().getAnchorSelectionIndex();
            if (n4 < 0 || n4 >= n2 || n5 < 0 || n5 >= n3) {
                return;
            }
            Rectangle rectangle = SynthTableUI.this.table.getCellRect(n4, n5, false);
            SynthTableUI.this.table.repaint(rectangle);
        }

        FocusHandler() {
        }

        public void focusGained(FocusEvent focusEvent) {
            this.repaintAnchorCell();
        }

        public void focusLost(FocusEvent focusEvent) {
            this.repaintAnchorCell();
        }
    }

    class KeyHandler
    implements KeyListener {
        KeyHandler() {
        }

        public void keyPressed(KeyEvent keyEvent) {
        }

        public void keyReleased(KeyEvent keyEvent) {
        }

        public void keyTyped(KeyEvent keyEvent) {
            KeyStroke keyStroke = KeyStroke.getKeyStroke((int)keyEvent.getKeyChar(), keyEvent.getModifiers());
            InputMap inputMap = SynthTableUI.this.table.getInputMap(0);
            if (inputMap != null && inputMap.get(keyStroke) != null) {
                return;
            }
            inputMap = SynthTableUI.this.table.getInputMap(1);
            if (inputMap != null && inputMap.get(keyStroke) != null) {
                return;
            }
            keyStroke = KeyStroke.getKeyStrokeForEvent(keyEvent);
            if (keyEvent.getKeyChar() == '\r') {
                return;
            }
            int n2 = SynthTableUI.this.table.getSelectionModel().getAnchorSelectionIndex();
            int n3 = SynthTableUI.this.table.getColumnModel().getSelectionModel().getAnchorSelectionIndex();
            if (n2 != -1 && n3 != -1 && !SynthTableUI.this.table.isEditing() && !SynthTableUI.this.table.editCellAt(n2, n3)) {
                return;
            }
            Component component = SynthTableUI.this.table.getEditorComponent();
            if (SynthTableUI.this.table.isEditing() && component != null && component instanceof JComponent) {
                Object object;
                JComponent jComponent = (JComponent)component;
                inputMap = jComponent.getInputMap(0);
                Object object2 = object = inputMap != null ? inputMap.get(keyStroke) : null;
                if (object == null) {
                    inputMap = jComponent.getInputMap(1);
                    Object object3 = object = inputMap != null ? inputMap.get(keyStroke) : null;
                }
                if (object != null) {
                    Action action;
                    ActionMap actionMap = jComponent.getActionMap();
                    Action action2 = action = actionMap != null ? actionMap.get(object) : null;
                    if (action != null && SwingUtilities.notifyAction(action, keyStroke, keyEvent, jComponent, keyEvent.getModifiers())) {
                        keyEvent.consume();
                    }
                }
            }
        }
    }

    class MouseInputHandler
    implements MouseInputListener {
        private Component dispatchComponent;
        private boolean selectedOnPress;

        private void setValueIsAdjusting(boolean bl2) {
            SynthTableUI.this.table.getSelectionModel().setValueIsAdjusting(bl2);
            SynthTableUI.this.table.getColumnModel().getSelectionModel().setValueIsAdjusting(bl2);
        }

        MouseInputHandler() {
        }

        void adjustFocusAndSelection(MouseEvent mouseEvent) {
            if (this.shouldIgnore(mouseEvent)) {
                return;
            }
            Point point = mouseEvent.getPoint();
            int n2 = SynthTableUI.this.table.rowAtPoint(point);
            int n3 = SynthTableUI.this.table.columnAtPoint(point);
            if (n3 == -1 || n2 == -1) {
                return;
            }
            if (SynthTableUI.this.table.editCellAt(n2, n3, mouseEvent)) {
                this.setDispatchComponent(mouseEvent);
                this.repostEvent(mouseEvent);
            } else if (SynthTableUI.this.table.isRequestFocusEnabled()) {
                SynthTableUI.this.table.requestFocus();
            }
            TableCellEditor tableCellEditor = SynthTableUI.this.table.getCellEditor();
            if (tableCellEditor == null || tableCellEditor.shouldSelectCell(mouseEvent)) {
                boolean bl2 = mouseEvent.getID() == 501;
                this.setValueIsAdjusting(bl2);
                SynthTableUI.this.table.changeSelection(n2, n3, mouseEvent.isControlDown(), mouseEvent.isShiftDown());
            }
        }

        public void mouseClicked(MouseEvent mouseEvent) {
        }

        public void mouseDragged(MouseEvent mouseEvent) {
            if (this.shouldIgnore(mouseEvent)) {
                return;
            }
            this.repostEvent(mouseEvent);
            TableCellEditor tableCellEditor = SynthTableUI.this.table.getCellEditor();
            if (tableCellEditor == null || tableCellEditor.shouldSelectCell(mouseEvent)) {
                Point point = mouseEvent.getPoint();
                int n2 = SynthTableUI.this.table.rowAtPoint(point);
                int n3 = SynthTableUI.this.table.columnAtPoint(point);
                if (n3 == -1 || n2 == -1) {
                    return;
                }
                SynthTableUI.this.table.changeSelection(n2, n3, false, true);
            }
        }

        public void mouseEntered(MouseEvent mouseEvent) {
        }

        public void mouseExited(MouseEvent mouseEvent) {
        }

        public void mouseMoved(MouseEvent mouseEvent) {
        }

        public void mousePressed(MouseEvent mouseEvent) {
            if (mouseEvent.isConsumed()) {
                this.selectedOnPress = false;
                return;
            }
            this.selectedOnPress = true;
            this.adjustFocusAndSelection(mouseEvent);
        }

        public void mouseReleased(MouseEvent mouseEvent) {
            if (this.selectedOnPress) {
                if (this.shouldIgnore(mouseEvent)) {
                    return;
                }
                this.repostEvent(mouseEvent);
                this.dispatchComponent = null;
                this.setValueIsAdjusting(false);
            } else {
                this.adjustFocusAndSelection(mouseEvent);
            }
        }

        private void setDispatchComponent(MouseEvent mouseEvent) {
            Component component = SynthTableUI.this.table.getEditorComponent();
            Point point = mouseEvent.getPoint();
            Point point2 = SwingUtilities.convertPoint(SynthTableUI.this.table, point, component);
            this.dispatchComponent = SwingUtilities.getDeepestComponentAt(component, point2.x, point2.y);
        }

        private boolean repostEvent(MouseEvent mouseEvent) {
            if (this.dispatchComponent == null || !SynthTableUI.this.table.isEditing()) {
                return false;
            }
            MouseEvent mouseEvent2 = SwingUtilities.convertMouseEvent(SynthTableUI.this.table, mouseEvent, this.dispatchComponent);
            this.dispatchComponent.dispatchEvent(mouseEvent2);
            return true;
        }

        private boolean shouldIgnore(MouseEvent mouseEvent) {
            return mouseEvent.isConsumed() || !SwingUtilities.isLeftMouseButton(mouseEvent) || !SynthTableUI.this.table.isEnabled();
        }
    }

    private static class NavigationalAction
    extends AbstractAction {
        protected int dx;
        protected int dy;
        protected boolean toggle;
        protected boolean extend;
        protected boolean inSelection;
        protected int anchorRow;
        protected int anchorColumn;
        protected int leadRow;
        protected int leadColumn;

        private int clipToRange(int n2, int n3, int n4) {
            return Math.min(Math.max(n2, n3), n4 - 1);
        }

        private int compare(int n2, int n3, int n4) {
            return n2 < n3 ? -1 : (n2 >= n4 ? 1 : 0);
        }

        protected NavigationalAction(int n2, int n3, boolean bl2, boolean bl3, boolean bl4) {
            this.dx = n2;
            this.dy = n3;
            this.toggle = bl2;
            this.extend = bl3;
            this.inSelection = bl4;
        }

        public void actionPerformed(ActionEvent actionEvent) {
            JTable jTable = (JTable)actionEvent.getSource();
            ListSelectionModel listSelectionModel = jTable.getSelectionModel();
            this.anchorRow = listSelectionModel.getAnchorSelectionIndex();
            this.leadRow = listSelectionModel.getLeadSelectionIndex();
            ListSelectionModel listSelectionModel2 = jTable.getColumnModel().getSelectionModel();
            this.anchorColumn = listSelectionModel2.getAnchorSelectionIndex();
            this.leadColumn = listSelectionModel2.getLeadSelectionIndex();
            int n2 = this.anchorRow;
            int n3 = this.anchorColumn;
            if (jTable.isEditing() && !jTable.getCellEditor().stopCellEditing()) {
                return;
            }
            if (!this.inSelection) {
                this.moveWithinTableRange(jTable, this.dx, this.dy, this.extend);
                if (!this.extend) {
                    jTable.changeSelection(this.anchorRow, this.anchorColumn, false, this.extend);
                } else {
                    jTable.changeSelection(this.leadRow, this.leadColumn, false, this.extend);
                }
            } else if (this.moveWithinSelectedRange(jTable, this.dx, this.dy, false)) {
                jTable.changeSelection(this.anchorRow, this.anchorColumn, true, true);
            } else {
                jTable.changeSelection(this.anchorRow, this.anchorColumn, false, false);
            }
        }

        private void moveWithinTableRange(JTable jTable, int n2, int n3, boolean bl2) {
            if (bl2) {
                this.leadRow = this.clipToRange(this.leadRow + n3, 0, jTable.getRowCount());
                this.leadColumn = this.clipToRange(this.leadColumn + n2, 0, jTable.getColumnCount());
            } else {
                this.anchorRow = this.clipToRange(this.anchorRow + n3, 0, jTable.getRowCount());
                this.anchorColumn = this.clipToRange(this.anchorColumn + n2, 0, jTable.getColumnCount());
            }
        }

        private boolean moveWithinSelectedRange(JTable jTable, int n2, int n3, boolean bl2) {
            int n4;
            int n5;
            int n6;
            boolean bl3;
            ListSelectionModel listSelectionModel = jTable.getSelectionModel();
            ListSelectionModel listSelectionModel2 = jTable.getColumnModel().getSelectionModel();
            int n7 = this.anchorRow + n3;
            int n8 = this.anchorColumn + n2;
            int n9 = this.selectionSpan(listSelectionModel);
            boolean bl4 = bl3 = n9 * (n6 = this.selectionSpan(listSelectionModel2)) > 1;
            if (bl3) {
                n5 = this.compare(n7, listSelectionModel);
                n4 = this.compare(n8, listSelectionModel2);
            } else {
                n9 = jTable.getRowCount();
                n6 = jTable.getColumnCount();
                n5 = this.compare(n7, 0, n9);
                n4 = this.compare(n8, 0, n6);
            }
            this.anchorRow = n7 - n9 * n5;
            this.anchorColumn = n8 - n6 * n4;
            if (!bl2) {
                return this.moveWithinSelectedRange(jTable, n5, n4, true);
            }
            return bl3;
        }

        private int compare(int n2, ListSelectionModel listSelectionModel) {
            return this.compare(n2, listSelectionModel.getMinSelectionIndex(), listSelectionModel.getMaxSelectionIndex() + 1);
        }

        private int selectionSpan(ListSelectionModel listSelectionModel) {
            return listSelectionModel.getMaxSelectionIndex() - listSelectionModel.getMinSelectionIndex() + 1;
        }
    }

    private static class PagingAction
    extends NavigationalAction {
        private boolean forwards;
        private boolean vertically;
        private boolean toLimit;

        private PagingAction(boolean bl2, boolean bl3, boolean bl4, boolean bl5) {
            super(0, 0, false, bl2, false);
            this.forwards = bl3;
            this.vertically = bl4;
            this.toLimit = bl5;
        }

        public void actionPerformed(ActionEvent actionEvent) {
            JTable jTable = (JTable)actionEvent.getSource();
            if (this.toLimit) {
                if (this.vertically) {
                    int n2 = jTable.getRowCount();
                    this.dx = 0;
                    this.dy = this.forwards ? n2 : -n2;
                } else {
                    int n3 = jTable.getColumnCount();
                    this.dx = this.forwards ? n3 : -n3;
                    this.dy = 0;
                }
            } else {
                int n4;
                if (!(jTable.getParent().getParent() instanceof JScrollPane)) {
                    return;
                }
                Dimension dimension = jTable.getParent().getSize();
                ListSelectionModel listSelectionModel = this.vertically ? jTable.getSelectionModel() : jTable.getColumnModel().getSelectionModel();
                int n5 = n4 = this.extend ? listSelectionModel.getLeadSelectionIndex() : listSelectionModel.getAnchorSelectionIndex();
                if (this.vertically) {
                    Rectangle rectangle = jTable.getCellRect(n4, 0, true);
                    rectangle.y = rectangle.y + (this.forwards ? dimension.height : -dimension.height);
                    this.dx = 0;
                    int n6 = jTable.rowAtPoint(rectangle.getLocation());
                    if (n6 == -1 && this.forwards) {
                        n6 = jTable.getRowCount();
                    }
                    this.dy = n6 - n4;
                } else {
                    Rectangle rectangle = jTable.getCellRect(0, n4, true);
                    rectangle.x = rectangle.x + (this.forwards ? dimension.width : -dimension.width);
                    int n7 = jTable.columnAtPoint(rectangle.getLocation());
                    if (n7 == -1 && this.forwards) {
                        n7 = jTable.getColumnCount();
                    }
                    this.dx = n7 - n4;
                    this.dy = 0;
                }
            }
            super.actionPerformed(actionEvent);
        }
    }

    private class PropertyChangeHandler
    implements PropertyChangeListener {
        private PropertyChangeHandler() {
        }

        public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
            DropTarget dropTarget;
            String string = propertyChangeEvent.getPropertyName();
            if (SynthLookAndFeel.shouldUpdateStyle(propertyChangeEvent)) {
                SynthTableUI.this.fetchStyle((JTable)propertyChangeEvent.getSource());
            }
            if (string.equals("componentOrientation")) {
                InputMap inputMap = SynthTableUI.this.getInputMap(1);
                SwingUtilities.replaceUIInputMap(SynthTableUI.this.table, 1, inputMap);
                JTableHeader jTableHeader = SynthTableUI.this.table.getTableHeader();
                if (jTableHeader != null) {
                    jTableHeader.setComponentOrientation((ComponentOrientation)propertyChangeEvent.getNewValue());
                }
            } else if ("transferHandler".equals(string) && (dropTarget = SynthTableUI.this.table.getDropTarget()) instanceof UIResource) {
                if (defaultDropTargetListener == null) {
                    defaultDropTargetListener = new TableDropTargetListener();
                }
                try {
                    dropTarget.addDropTargetListener(defaultDropTargetListener);
                }
                catch (TooManyListenersException tooManyListenersException) {
                    // empty catch block
                }
            }
        }
    }

    private static class SelectAllAction
    extends AbstractAction {
        private SelectAllAction() {
        }

        public void actionPerformed(ActionEvent actionEvent) {
            JTable jTable = (JTable)actionEvent.getSource();
            jTable.selectAll();
        }
    }

    private static class StartEditingAction
    extends AbstractAction {
        private StartEditingAction() {
        }

        public void actionPerformed(ActionEvent actionEvent) {
            JTable jTable = (JTable)actionEvent.getSource();
            if (!jTable.hasFocus()) {
                TableCellEditor tableCellEditor = jTable.getCellEditor();
                if (tableCellEditor != null && !tableCellEditor.stopCellEditing()) {
                    return;
                }
                jTable.requestFocus();
                return;
            }
            ListSelectionModel listSelectionModel = jTable.getSelectionModel();
            int n2 = listSelectionModel.getAnchorSelectionIndex();
            ListSelectionModel listSelectionModel2 = jTable.getColumnModel().getSelectionModel();
            int n3 = listSelectionModel2.getAnchorSelectionIndex();
            jTable.editCellAt(n2, n3);
            Component component = jTable.getEditorComponent();
            if (component != null) {
                component.requestFocus();
            }
        }
    }

    static class TableDragGestureRecognizer
    extends SynthDragGestureRecognizer {
        TableDragGestureRecognizer() {
        }

        protected boolean isDragPossible(MouseEvent mouseEvent) {
            JTable jTable;
            if (super.isDragPossible(mouseEvent) && (jTable = (JTable)this.getComponent(mouseEvent)).getDragEnabled()) {
                Point point = mouseEvent.getPoint();
                int n2 = jTable.rowAtPoint(point);
                int n3 = jTable.columnAtPoint(point);
                if (n3 != -1 && n2 != -1 && jTable.isCellSelected(n2, n3)) {
                    return true;
                }
            }
            return false;
        }
    }

    static class TableDropTargetListener
    extends SynthDropTargetListener {
        private int[] rows;
        private int[] cols;

        TableDropTargetListener() {
        }

        protected void restoreComponentState(JComponent jComponent) {
            int n2;
            JTable jTable = (JTable)jComponent;
            jTable.clearSelection();
            for (n2 = 0; n2 < this.rows.length; ++n2) {
                jTable.addRowSelectionInterval(this.rows[n2], this.rows[n2]);
            }
            for (n2 = 0; n2 < this.cols.length; ++n2) {
                jTable.addColumnSelectionInterval(this.cols[n2], this.cols[n2]);
            }
        }

        protected void saveComponentState(JComponent jComponent) {
            JTable jTable = (JTable)jComponent;
            this.rows = jTable.getSelectedRows();
            this.cols = jTable.getSelectedColumns();
        }

        protected void updateInsertionLocation(JComponent jComponent, Point point) {
            JTable jTable = (JTable)jComponent;
            int n2 = jTable.rowAtPoint(point);
            int n3 = jTable.columnAtPoint(point);
            if (n2 != -1) {
                jTable.setRowSelectionInterval(n2, n2);
            }
            if (n3 != -1) {
                jTable.setColumnSelectionInterval(n3, n3);
            }
        }
    }

    static class TableTransferHandler
    extends TransferHandler
    implements UIResource {
        TableTransferHandler() {
        }

        public int getSourceActions(JComponent jComponent) {
            return 1;
        }

        protected Transferable createTransferable(JComponent jComponent) {
            if (jComponent instanceof JTable) {
                int[] nArray;
                int n2;
                int[] nArray2;
                int n3;
                JTable jTable = (JTable)jComponent;
                if (!jTable.getRowSelectionAllowed() && !jTable.getColumnSelectionAllowed()) {
                    return null;
                }
                if (!jTable.getRowSelectionAllowed()) {
                    n3 = jTable.getRowCount();
                    nArray2 = new int[n3];
                    for (n2 = 0; n2 < n3; ++n2) {
                        nArray2[n2] = n2;
                    }
                } else {
                    nArray2 = jTable.getSelectedRows();
                }
                if (!jTable.getColumnSelectionAllowed()) {
                    n3 = jTable.getColumnCount();
                    nArray = new int[n3];
                    for (n2 = 0; n2 < n3; ++n2) {
                        nArray[n2] = n2;
                    }
                } else {
                    nArray = jTable.getSelectedColumns();
                }
                if (nArray2 == null || nArray == null || nArray2.length == 0 || nArray.length == 0) {
                    return null;
                }
                StringBuffer stringBuffer = new StringBuffer();
                StringBuffer stringBuffer2 = new StringBuffer();
                stringBuffer2.append("<html>\n<body>\n<table>\n");
                for (int i2 = 0; i2 < nArray2.length; ++i2) {
                    stringBuffer2.append("<tr>\n");
                    for (int i3 = 0; i3 < nArray.length; ++i3) {
                        Object object = jTable.getValueAt(nArray2[i2], nArray[i3]);
                        String string = object == null ? "" : object.toString();
                        stringBuffer.append(string + "\t");
                        stringBuffer2.append("  <td>" + string + "</td>\n");
                    }
                    stringBuffer.deleteCharAt(stringBuffer.length() - 1).append("\n");
                    stringBuffer2.append("</tr>\n");
                }
                stringBuffer.deleteCharAt(stringBuffer.length() - 1);
                stringBuffer2.append("</table>\n</body>\n</html>");
                return new SynthTransferable(stringBuffer.toString(), stringBuffer2.toString());
            }
            return null;
        }
    }
}

