/*
 * Decompiled with CFR 0.152.
 */
package com.sun.java.swing.plaf.windows;

import com.sun.java.swing.plaf.windows.XPStyle;
import java.awt.Color;
import java.awt.Component;
import java.awt.Graphics;
import java.awt.Insets;
import java.awt.Rectangle;
import java.io.Serializable;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.JTree;
import javax.swing.plaf.ComponentUI;
import javax.swing.plaf.basic.BasicTreeUI;
import javax.swing.tree.DefaultTreeCellRenderer;
import javax.swing.tree.TreeCellRenderer;
import javax.swing.tree.TreePath;

public class WindowsTreeUI
extends BasicTreeUI {
    protected static final int HALF_SIZE = 4;
    protected static final int SIZE = 9;

    protected void ensureRowsAreVisible(int n2, int n3) {
        if (this.tree != null && n2 >= 0 && n3 < this.getRowCount(this.tree)) {
            Rectangle rectangle = this.tree.getVisibleRect();
            if (n2 == n3) {
                Rectangle rectangle2 = this.getPathBounds(this.tree, this.getPathForRow(this.tree, n2));
                if (rectangle2 != null) {
                    rectangle2.x = rectangle.x;
                    rectangle2.width = rectangle.width;
                    this.tree.scrollRectToVisible(rectangle2);
                }
            } else {
                Rectangle rectangle3;
                Rectangle rectangle4 = rectangle3 = this.getPathBounds(this.tree, this.getPathForRow(this.tree, n2));
                int n4 = rectangle3.y;
                int n5 = n4 + rectangle.height;
                for (int i2 = n2 + 1; i2 <= n3; ++i2) {
                    rectangle4 = this.getPathBounds(this.tree, this.getPathForRow(this.tree, i2));
                    if (rectangle4.y + rectangle4.height <= n5) continue;
                    i2 = n3;
                }
                this.tree.scrollRectToVisible(new Rectangle(rectangle.x, n4, 1, rectangle4.y + rectangle4.height - n4));
            }
        }
    }

    protected TreeCellRenderer createDefaultCellRenderer() {
        return new WindowsTreeCellRenderer();
    }

    public static ComponentUI createUI(JComponent jComponent) {
        return new WindowsTreeUI();
    }

    protected void paintVerticalPartOfLeg(Graphics graphics, Rectangle rectangle, Insets insets, TreePath treePath) {
        if (XPStyle.getXP() == null) {
            super.paintVerticalPartOfLeg(graphics, rectangle, insets, treePath);
        }
    }

    protected void paintHorizontalPartOfLeg(Graphics graphics, Rectangle rectangle, Insets insets, Rectangle rectangle2, TreePath treePath, int n2, boolean bl2, boolean bl3, boolean bl4) {
        if (XPStyle.getXP() == null) {
            super.paintHorizontalPartOfLeg(graphics, rectangle, insets, rectangle2, treePath, n2, bl2, bl3, bl4);
        }
    }

    public static class CollapsedIcon
    extends ExpandedIcon {
        public static Icon createCollapsedIcon() {
            return new CollapsedIcon();
        }

        public void paintIcon(Component component, Graphics graphics, int n2, int n3) {
            if (this.skin != null) {
                this.skin.paintSkin(graphics, n2, n3, 0);
            } else {
                super.paintIcon(component, graphics, n2, n3);
                graphics.drawLine(n2 + 4, n3 + 2, n2 + 4, n3 + 6);
            }
        }
    }

    public static class ExpandedIcon
    implements Icon,
    Serializable {
        XPStyle xp = XPStyle.getXP();
        XPStyle.Skin skin = this.xp != null ? this.xp.getSkin("treeview.glyph") : null;

        public int getIconHeight() {
            return this.skin != null ? this.skin.getHeight() : 9;
        }

        public int getIconWidth() {
            return this.skin != null ? this.skin.getWidth() : 9;
        }

        public static Icon createExpandedIcon() {
            return new ExpandedIcon();
        }

        public void paintIcon(Component component, Graphics graphics, int n2, int n3) {
            if (this.skin != null) {
                this.skin.paintSkin(graphics, n2, n3, 1);
                return;
            }
            Color color = component.getBackground();
            if (color != null) {
                graphics.setColor(color);
            } else {
                graphics.setColor(Color.white);
            }
            graphics.fillRect(n2, n3, 8, 8);
            graphics.setColor(Color.gray);
            graphics.drawRect(n2, n3, 8, 8);
            graphics.setColor(Color.black);
            graphics.drawLine(n2 + 2, n3 + 4, n2 + 6, n3 + 4);
        }
    }

    public class WindowsTreeCellRenderer
    extends DefaultTreeCellRenderer {
        public Component getTreeCellRendererComponent(JTree jTree, Object object, boolean bl2, boolean bl3, boolean bl4, int n2, boolean bl5) {
            super.getTreeCellRendererComponent(jTree, object, bl2, bl3, bl4, n2, bl5);
            if (!jTree.isEnabled()) {
                this.setEnabled(false);
                if (bl4) {
                    this.setDisabledIcon(this.getLeafIcon());
                } else if (bl2) {
                    this.setDisabledIcon(this.getOpenIcon());
                } else {
                    this.setDisabledIcon(this.getClosedIcon());
                }
            } else {
                this.setEnabled(true);
                if (bl4) {
                    this.setIcon(this.getLeafIcon());
                } else if (bl2) {
                    this.setIcon(this.getOpenIcon());
                } else {
                    this.setIcon(this.getClosedIcon());
                }
            }
            return this;
        }
    }
}

