/*
 * Decompiled with CFR 0.152.
 */
package java.awt.font;

import java.awt.Graphics2D;
import java.awt.font.GlyphJustificationInfo;
import java.awt.geom.Rectangle2D;

public abstract class GraphicAttribute {
    private int fAlignment;
    public static final int TOP_ALIGNMENT = -1;
    public static final int BOTTOM_ALIGNMENT = -2;
    public static final int ROMAN_BASELINE = 0;
    public static final int CENTER_BASELINE = 1;
    public static final int HANGING_BASELINE = 2;

    public abstract float getAdvance();

    public abstract float getAscent();

    public abstract float getDescent();

    public final int getAlignment() {
        return this.fAlignment;
    }

    protected GraphicAttribute(int n2) {
        if (n2 < -2 || n2 > 2) {
            throw new IllegalArgumentException("bad alignment");
        }
        this.fAlignment = n2;
    }

    public abstract void draw(Graphics2D var1, float var2, float var3);

    public GlyphJustificationInfo getJustificationInfo() {
        float f2 = this.getAdvance();
        return new GlyphJustificationInfo(f2, false, 2, f2 / 3.0f, f2 / 3.0f, false, 1, 0.0f, 0.0f);
    }

    public Rectangle2D getBounds() {
        float f2 = this.getAscent();
        return new Rectangle2D.Float(0.0f, -f2, this.getAdvance(), f2 + this.getDescent());
    }
}

