/*
 * Decompiled with CFR 0.152.
 */
package java.math;

import java.math.BigInteger;
import java.math.MutableBigInteger;

class BitSieve {
    private long[] bits;
    private int length;
    private static BitSieve smallSieve = new BitSieve();

    private BitSieve() {
        this.length = 9600;
        this.bits = new long[BitSieve.unitIndex(this.length - 1) + 1];
        this.set(0);
        int n2 = 1;
        int n3 = 3;
        do {
            this.sieveSingle(this.length, n2 + n3, n3);
            n2 = this.sieveSearch(this.length, n2 + 1);
            n3 = 2 * n2 + 1;
        } while (n2 > 0 && n3 < this.length);
    }

    private static int unitIndex(int n2) {
        return n2 >>> 6;
    }

    private static long bit(int n2) {
        return 1L << (n2 & 0x3F);
    }

    private void set(int n2) {
        int n3;
        int n4 = n3 = BitSieve.unitIndex(n2);
        this.bits[n4] = this.bits[n4] | BitSieve.bit(n2);
    }

    private boolean get(int n2) {
        int n3 = BitSieve.unitIndex(n2);
        return (this.bits[n3] & BitSieve.bit(n2)) != 0L;
    }

    private int sieveSearch(int n2, int n3) {
        if (n3 >= n2) {
            return -1;
        }
        int n4 = n3;
        do {
            if (this.get(n4)) continue;
            return n4;
        } while (++n4 < n2 - 1);
        return -1;
    }

    private void sieveSingle(int n2, int n3, int n4) {
        while (n3 < n2) {
            this.set(n3);
            n3 += n4;
        }
    }

    BitSieve(BigInteger bigInteger, int n2) {
        this.bits = new long[BitSieve.unitIndex(n2 - 1) + 1];
        this.length = n2;
        int n3 = 0;
        int n4 = smallSieve.sieveSearch(BitSieve.smallSieve.length, n3);
        int n5 = n4 * 2 + 1;
        MutableBigInteger mutableBigInteger = new MutableBigInteger();
        MutableBigInteger mutableBigInteger2 = new MutableBigInteger();
        do {
            mutableBigInteger.copyValue(bigInteger.mag);
            mutableBigInteger.divideOneWord(n5, mutableBigInteger2);
            n3 = mutableBigInteger.value[mutableBigInteger.offset];
            n3 = n5 - n3;
            if (n3 % 2 == 0) {
                n3 += n5;
            }
            this.sieveSingle(n2, (n3 - 1) / 2, n5);
            n4 = smallSieve.sieveSearch(BitSieve.smallSieve.length, n4 + 1);
            n5 = n4 * 2 + 1;
        } while (n4 > 0);
    }

    BigInteger retrieve(BigInteger bigInteger, int n2) {
        int n3 = 1;
        for (int i2 = 0; i2 < this.bits.length; ++i2) {
            long l2 = this.bits[i2] ^ 0xFFFFFFFFFFFFFFFFL;
            for (int i3 = 0; i3 < 64; ++i3) {
                BigInteger bigInteger2;
                if ((l2 & 1L) == 1L && (bigInteger2 = bigInteger.add(BigInteger.valueOf(n3))).primeToCertainty(n2)) {
                    return bigInteger2;
                }
                l2 >>>= 1;
                n3 += 2;
            }
        }
        return null;
    }
}

