/*
 * Decompiled with CFR 0.152.
 */
package javax.imageio;

import java.awt.Point;
import java.awt.color.ColorSpace;
import java.awt.image.BandedSampleModel;
import java.awt.image.BufferedImage;
import java.awt.image.ColorModel;
import java.awt.image.ComponentColorModel;
import java.awt.image.DataBuffer;
import java.awt.image.DirectColorModel;
import java.awt.image.IndexColorModel;
import java.awt.image.MultiPixelPackedSampleModel;
import java.awt.image.PixelInterleavedSampleModel;
import java.awt.image.Raster;
import java.awt.image.RenderedImage;
import java.awt.image.SampleModel;
import java.awt.image.WritableRaster;
import java.util.Hashtable;

public class ImageTypeSpecifier {
    protected ColorModel colorModel;
    protected SampleModel sampleModel;
    private static ImageTypeSpecifier[] BISpecifier;

    public int getBufferedImageType() {
        BufferedImage bufferedImage = this.createBufferedImage(1, 1);
        return bufferedImage.getType();
    }

    public int getNumBands() {
        return this.sampleModel.getNumBands();
    }

    public int getNumComponents() {
        return this.colorModel.getNumComponents();
    }

    static {
        ColorSpace colorSpace = ColorSpace.getInstance(1000);
        BISpecifier = new ImageTypeSpecifier[14];
        ImageTypeSpecifier.BISpecifier[0] = null;
        ImageTypeSpecifier.BISpecifier[1] = ImageTypeSpecifier.createPacked(colorSpace, 0xFF0000, 65280, 255, 0, 3, false);
        ImageTypeSpecifier.BISpecifier[2] = ImageTypeSpecifier.createPacked(colorSpace, 0xFF0000, 65280, 255, -16777216, 3, false);
        ImageTypeSpecifier.BISpecifier[3] = ImageTypeSpecifier.createPacked(colorSpace, 0xFF0000, 65280, 255, -16777216, 3, true);
        ImageTypeSpecifier.BISpecifier[4] = ImageTypeSpecifier.createPacked(colorSpace, 255, 65280, 0xFF0000, 0, 3, false);
        int[] nArray = new int[]{2, 1, 0};
        ImageTypeSpecifier.BISpecifier[5] = ImageTypeSpecifier.createInterleaved(colorSpace, nArray, 0, false, false);
        int[] nArray2 = new int[]{3, 2, 1, 0};
        ImageTypeSpecifier.BISpecifier[6] = ImageTypeSpecifier.createInterleaved(colorSpace, nArray2, 0, true, false);
        ImageTypeSpecifier.BISpecifier[7] = ImageTypeSpecifier.createInterleaved(colorSpace, nArray2, 0, true, true);
        ImageTypeSpecifier.BISpecifier[8] = ImageTypeSpecifier.createPacked(colorSpace, 63488, 2016, 31, 0, 1, false);
        ImageTypeSpecifier.BISpecifier[9] = ImageTypeSpecifier.createPacked(colorSpace, 31744, 992, 31, 0, 1, false);
        ImageTypeSpecifier.BISpecifier[10] = ImageTypeSpecifier.createGrayscale(8, 0, false);
        ImageTypeSpecifier.BISpecifier[11] = ImageTypeSpecifier.createGrayscale(16, 1, false);
        ImageTypeSpecifier.BISpecifier[12] = ImageTypeSpecifier.createGrayscale(1, 0, false);
        BufferedImage bufferedImage = new BufferedImage(1, 1, 13);
        IndexColorModel indexColorModel = (IndexColorModel)bufferedImage.getColorModel();
        int n2 = indexColorModel.getMapSize();
        byte[] byArray = new byte[n2];
        byte[] byArray2 = new byte[n2];
        byte[] byArray3 = new byte[n2];
        byte[] byArray4 = new byte[n2];
        indexColorModel.getReds(byArray);
        indexColorModel.getGreens(byArray2);
        indexColorModel.getBlues(byArray3);
        indexColorModel.getAlphas(byArray4);
        ImageTypeSpecifier.BISpecifier[13] = ImageTypeSpecifier.createIndexed(byArray, byArray2, byArray3, byArray4, 8, 0);
    }

    private ImageTypeSpecifier() {
    }

    public int getBitsPerBand(int n2) {
        if (n2 < 0 | n2 >= this.getNumBands()) {
            throw new IllegalArgumentException("band out of range!");
        }
        return this.sampleModel.getSampleSize(n2);
    }

    public BufferedImage createBufferedImage(int n2, int n3) {
        try {
            SampleModel sampleModel = this.getSampleModel(n2, n3);
            WritableRaster writableRaster = Raster.createWritableRaster(sampleModel, new Point(0, 0));
            return new BufferedImage(this.colorModel, writableRaster, this.colorModel.isAlphaPremultiplied(), new Hashtable());
        }
        catch (NegativeArraySizeException negativeArraySizeException) {
            throw new IllegalArgumentException("Array size > Integer.MAX_VALUE!");
        }
    }

    public ColorModel getColorModel() {
        return this.colorModel;
    }

    public ImageTypeSpecifier(RenderedImage renderedImage) {
        if (renderedImage == null) {
            throw new IllegalArgumentException("image == null!");
        }
        this.colorModel = renderedImage.getColorModel();
        this.sampleModel = renderedImage.getSampleModel();
    }

    public SampleModel getSampleModel() {
        return this.sampleModel;
    }

    public SampleModel getSampleModel(int n2, int n3) {
        if ((long)n2 * (long)n3 > Integer.MAX_VALUE) {
            throw new IllegalArgumentException("width*height > Integer.MAX_VALUE!");
        }
        return this.sampleModel.createCompatibleSampleModel(n2, n3);
    }

    public boolean equals(Object object) {
        if (object == null || !(object instanceof ImageTypeSpecifier)) {
            return false;
        }
        ImageTypeSpecifier imageTypeSpecifier = (ImageTypeSpecifier)object;
        return this.colorModel.equals(imageTypeSpecifier.colorModel) && this.sampleModel.equals(imageTypeSpecifier.sampleModel);
    }

    public static ImageTypeSpecifier createFromBufferedImageType(int n2) {
        if (n2 >= 1 && n2 <= 13) {
            return BISpecifier[n2];
        }
        if (n2 == 0) {
            throw new IllegalArgumentException("Cannot create from TYPE_CUSTOM!");
        }
        throw new IllegalArgumentException("Invalid BufferedImage type!");
    }

    public static ImageTypeSpecifier createGrayscale(int n2, int n3, boolean bl2) {
        return new Grayscale(n2, n3, bl2, false, false);
    }

    public static ImageTypeSpecifier createGrayscale(int n2, int n3, boolean bl2, boolean bl3) {
        return new Grayscale(n2, n3, bl2, true, bl3);
    }

    public static ImageTypeSpecifier createIndexed(byte[] byArray, byte[] byArray2, byte[] byArray3, byte[] byArray4, int n2, int n3) {
        return new Indexed(byArray, byArray2, byArray3, byArray4, n2, n3);
    }

    static ColorModel createComponentCM(ColorSpace colorSpace, int n2, int n3, boolean bl2, boolean bl3) {
        int n4 = bl2 ? 3 : 1;
        int[] nArray = new int[n2];
        int n5 = DataBuffer.getDataTypeSize(n3);
        for (int i2 = 0; i2 < n2; ++i2) {
            nArray[i2] = n5;
        }
        return new ComponentColorModel(colorSpace, nArray, bl2, bl3, n4, n3);
    }

    public ImageTypeSpecifier(ColorModel colorModel, SampleModel sampleModel) {
        if (colorModel == null) {
            throw new IllegalArgumentException("colorModel == null!");
        }
        if (sampleModel == null) {
            throw new IllegalArgumentException("sampleModel == null!");
        }
        if (!colorModel.isCompatibleSampleModel(sampleModel)) {
            throw new IllegalArgumentException("sampleModel is incompatible with colorModel!");
        }
        this.colorModel = colorModel;
        this.sampleModel = sampleModel;
    }

    public static ImageTypeSpecifier createPacked(ColorSpace colorSpace, int n2, int n3, int n4, int n5, int n6, boolean bl2) {
        return new Packed(colorSpace, n2, n3, n4, n5, n6, bl2);
    }

    public static ImageTypeSpecifier createInterleaved(ColorSpace colorSpace, int[] nArray, int n2, boolean bl2, boolean bl3) {
        return new Interleaved(colorSpace, nArray, n2, bl2, bl3);
    }

    public static ImageTypeSpecifier createBanded(ColorSpace colorSpace, int[] nArray, int[] nArray2, int n2, boolean bl2, boolean bl3) {
        return new Banded(colorSpace, nArray, nArray2, n2, bl2, bl3);
    }

    public static ImageTypeSpecifier createFromRenderedImage(RenderedImage renderedImage) {
        int n2;
        if (renderedImage == null) {
            throw new IllegalArgumentException("image == null!");
        }
        if (renderedImage instanceof BufferedImage && (n2 = ((BufferedImage)renderedImage).getType()) != 0) {
            return BISpecifier[n2];
        }
        return new ImageTypeSpecifier(renderedImage);
    }

    static class Banded
    extends ImageTypeSpecifier {
        ColorSpace colorSpace;
        int[] bankIndices;
        int[] bandOffsets;
        int dataType;
        boolean hasAlpha;
        boolean isAlphaPremultiplied;

        public Banded(ColorSpace colorSpace, int[] nArray, int[] nArray2, int n2, boolean bl2, boolean bl3) {
            if (colorSpace == null) {
                throw new IllegalArgumentException("colorSpace == null!");
            }
            if (nArray == null) {
                throw new IllegalArgumentException("bankIndices == null!");
            }
            if (nArray2 == null) {
                throw new IllegalArgumentException("bandOffsets == null!");
            }
            if (nArray.length != nArray2.length) {
                throw new IllegalArgumentException("bankIndices.length != bandOffsets.length!");
            }
            if (n2 != 0 && n2 != 2 && n2 != 1 && n2 != 3 && n2 != 4 && n2 != 5) {
                throw new IllegalArgumentException("Bad value for dataType!");
            }
            int n3 = colorSpace.getNumComponents() + (bl2 ? 1 : 0);
            if (nArray2.length != n3) {
                throw new IllegalArgumentException("bandOffsets.length is wrong!");
            }
            this.colorSpace = colorSpace;
            this.bankIndices = (int[])nArray.clone();
            this.bandOffsets = (int[])nArray2.clone();
            this.dataType = n2;
            this.hasAlpha = bl2;
            this.isAlphaPremultiplied = bl3;
            this.colorModel = ImageTypeSpecifier.createComponentCM(colorSpace, nArray.length, n2, bl2, bl3);
            int n4 = 1;
            int n5 = 1;
            this.sampleModel = new BandedSampleModel(n2, n4, n5, n4, nArray, nArray2);
        }

        public boolean equals(Object object) {
            int n2;
            if (object == null || !(object instanceof Banded)) {
                return false;
            }
            Banded banded = (Banded)object;
            if (!this.colorSpace.equals(banded.colorSpace) || this.dataType != banded.dataType || this.hasAlpha != banded.hasAlpha || this.isAlphaPremultiplied != banded.isAlphaPremultiplied || this.bankIndices.length != banded.bankIndices.length || this.bandOffsets.length != banded.bandOffsets.length) {
                return false;
            }
            for (n2 = 0; n2 < this.bankIndices.length; ++n2) {
                if (this.bankIndices[n2] == banded.bankIndices[n2]) continue;
                return false;
            }
            for (n2 = 0; n2 < this.bandOffsets.length; ++n2) {
                if (this.bandOffsets[n2] == banded.bandOffsets[n2]) continue;
                return false;
            }
            return true;
        }
    }

    static class Grayscale
    extends ImageTypeSpecifier {
        int bits;
        int dataType;
        boolean isSigned;
        boolean hasAlpha;
        boolean isAlphaPremultiplied;

        public Grayscale(int n2, int n3, boolean bl2, boolean bl3, boolean bl4) {
            this.bits = n2;
            this.dataType = n3;
            this.isSigned = bl2;
            this.hasAlpha = bl3;
            this.isAlphaPremultiplied = bl4;
            ColorSpace colorSpace = ColorSpace.getInstance(1003);
            if (n2 == 8 && n3 == 0 || n2 == 16 && (n3 == 2 || n3 == 1)) {
                int n4 = bl3 ? 2 : 1;
                int n5 = bl3 ? 3 : 1;
                int[] nArray = new int[n4];
                nArray[0] = n2;
                if (n4 == 2) {
                    nArray[1] = n2;
                }
                this.colorModel = new ComponentColorModel(colorSpace, nArray, bl3, bl4, n5, n3);
                int[] nArray2 = new int[n4];
                nArray2[0] = 0;
                if (n4 == 2) {
                    nArray2[1] = 1;
                }
                int n6 = 1;
                int n7 = 1;
                this.sampleModel = new PixelInterleavedSampleModel(n3, n6, n7, n4, n6 * n4, nArray2);
            } else {
                int n8 = 1 << n2;
                byte[] byArray = new byte[n8];
                for (int i2 = 0; i2 < n8; ++i2) {
                    byArray[i2] = (byte)(i2 * 255 / (n8 - 1));
                }
                this.colorModel = new IndexColorModel(n2, n8, byArray, byArray, byArray);
                this.sampleModel = new MultiPixelPackedSampleModel(n3, 1, 1, n2);
            }
        }
    }

    static class Indexed
    extends ImageTypeSpecifier {
        byte[] redLUT;
        byte[] greenLUT;
        byte[] blueLUT;
        byte[] alphaLUT = null;
        int bits;
        int dataType;

        public Indexed(byte[] byArray, byte[] byArray2, byte[] byArray3, byte[] byArray4, int n2, int n3) {
            if (byArray == null || byArray2 == null || byArray3 == null) {
                throw new IllegalArgumentException("LUT is null!");
            }
            if (n2 != 1 && n2 != 2 && n2 != 4 && n2 != 8 && n2 != 16) {
                throw new IllegalArgumentException("Bad value for bits!");
            }
            if (n3 != 0 && n3 != 2 && n3 != 1 && n3 != 3) {
                throw new IllegalArgumentException("Bad value for dataType!");
            }
            if (n2 > 8 && n3 == 0 || n2 > 16 && n3 != 3) {
                throw new IllegalArgumentException("Too many bits for dataType!");
            }
            int n4 = 1 << n2;
            if (byArray.length != n4 || byArray2.length != n4 || byArray3.length != n4 || byArray4 != null && byArray4.length != n4) {
                throw new IllegalArgumentException("LUT has improper length!");
            }
            this.redLUT = (byte[])byArray.clone();
            this.greenLUT = (byte[])byArray2.clone();
            this.blueLUT = (byte[])byArray3.clone();
            if (byArray4 != null) {
                this.alphaLUT = (byte[])byArray4.clone();
            }
            this.bits = n2;
            this.dataType = n3;
            this.colorModel = byArray4 == null ? new IndexColorModel(n2, byArray.length, byArray, byArray2, byArray3) : new IndexColorModel(n2, byArray.length, byArray, byArray2, byArray3, byArray4);
            if (n2 == 8 && n3 == 0 || n2 == 16 && (n3 == 2 || n3 == 1)) {
                int[] nArray = new int[]{0};
                this.sampleModel = new PixelInterleavedSampleModel(n3, 1, 1, 1, 1, nArray);
            } else {
                this.sampleModel = new MultiPixelPackedSampleModel(n3, 1, 1, n2);
            }
        }
    }

    static class Interleaved
    extends ImageTypeSpecifier {
        ColorSpace colorSpace;
        int[] bandOffsets;
        int dataType;
        boolean hasAlpha;
        boolean isAlphaPremultiplied;

        public Interleaved(ColorSpace colorSpace, int[] nArray, int n2, boolean bl2, boolean bl3) {
            int n3;
            int n4;
            int n5;
            if (colorSpace == null) {
                throw new IllegalArgumentException("colorSpace == null!");
            }
            if (nArray == null) {
                throw new IllegalArgumentException("bandOffsets == null!");
            }
            int n6 = colorSpace.getNumComponents() + (bl2 ? 1 : 0);
            if (nArray.length != n6) {
                throw new IllegalArgumentException("bandOffsets.length is wrong!");
            }
            if (n2 != 0 && n2 != 2 && n2 != 1 && n2 != 3 && n2 != 4 && n2 != 5) {
                throw new IllegalArgumentException("Bad value for dataType!");
            }
            this.colorSpace = colorSpace;
            this.bandOffsets = (int[])nArray.clone();
            this.dataType = n2;
            this.hasAlpha = bl2;
            this.isAlphaPremultiplied = bl3;
            this.colorModel = ImageTypeSpecifier.createComponentCM(colorSpace, nArray.length, n2, bl2, bl3);
            int n7 = n5 = nArray[0];
            for (n4 = 0; n4 < nArray.length; ++n4) {
                n3 = nArray[n4];
                n5 = Math.min(n3, n5);
                n7 = Math.max(n3, n7);
            }
            n4 = n7 - n5 + 1;
            n3 = 1;
            int n8 = 1;
            this.sampleModel = new PixelInterleavedSampleModel(n2, n3, n8, n4, n3 * n4, nArray);
        }

        public boolean equals(Object object) {
            if (object == null || !(object instanceof Interleaved)) {
                return false;
            }
            Interleaved interleaved = (Interleaved)object;
            if (!this.colorSpace.equals(interleaved.colorSpace) || this.dataType != interleaved.dataType || this.hasAlpha != interleaved.hasAlpha || this.isAlphaPremultiplied != interleaved.isAlphaPremultiplied || this.bandOffsets.length != interleaved.bandOffsets.length) {
                return false;
            }
            for (int i2 = 0; i2 < this.bandOffsets.length; ++i2) {
                if (this.bandOffsets[i2] == interleaved.bandOffsets[i2]) continue;
                return false;
            }
            return true;
        }
    }

    static class Packed
    extends ImageTypeSpecifier {
        ColorSpace colorSpace;
        int redMask;
        int greenMask;
        int blueMask;
        int alphaMask;
        int transferType;
        boolean isAlphaPremultiplied;

        public Packed(ColorSpace colorSpace, int n2, int n3, int n4, int n5, int n6, boolean bl2) {
            if (colorSpace == null) {
                throw new IllegalArgumentException("colorSpace == null!");
            }
            if (colorSpace.getType() != 5) {
                throw new IllegalArgumentException("colorSpace is not of type TYPE_RGB!");
            }
            if (n6 != 0 && n6 != 1 && n6 != 3) {
                throw new IllegalArgumentException("Bad value for transferType!");
            }
            if (n2 == 0 && n3 == 0 && n4 == 0 && n5 == 0) {
                throw new IllegalArgumentException("No mask has at least 1 bit set!");
            }
            this.colorSpace = colorSpace;
            this.redMask = n2;
            this.greenMask = n3;
            this.blueMask = n4;
            this.alphaMask = n5;
            this.transferType = n6;
            this.isAlphaPremultiplied = bl2;
            int n7 = 32;
            this.colorModel = new DirectColorModel(colorSpace, n7, n2, n3, n4, n5, bl2, n6);
            this.sampleModel = this.colorModel.createCompatibleSampleModel(1, 1);
        }
    }
}

