/*
 * Decompiled with CFR 0.152.
 */
package sun.misc;

import java.io.File;
import java.io.FileWriter;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.Vector;
import sun.security.action.GetPropertyAction;

public class PerformanceLogger {
    private static final int START_INDEX = 0;
    private static final int LAST_RESERVED = 0;
    private static boolean perfLoggingOn = false;
    private static Vector times;
    private static String logFileName;
    private static Writer logWriter;

    public static long getStartTime() {
        if (PerformanceLogger.loggingEnabled()) {
            return ((TimeData)times.get(0)).getTime();
        }
        return 0L;
    }

    static {
        logFileName = null;
        logWriter = null;
        String string = (String)AccessController.doPrivileged(new GetPropertyAction("sun.perflog"));
        if (string != null) {
            perfLoggingOn = true;
            if (string.regionMatches(true, 0, "file:", 0, 5)) {
                logFileName = string.substring(5);
            }
            if (logFileName != null && logWriter == null) {
                AccessController.doPrivileged(new PrivilegedAction(){

                    public Object run() {
                        try {
                            File file = new File(logFileName);
                            file.createNewFile();
                            logWriter = new FileWriter(file);
                        }
                        catch (Exception exception) {
                            System.out.println(exception + ": Creating logfile " + logFileName + ".  Log to console");
                        }
                        return null;
                    }
                });
            }
            if (logWriter == null) {
                logWriter = new OutputStreamWriter(System.out);
            }
        }
        times = new Vector(10);
        for (int i2 = 0; i2 <= 0; ++i2) {
            times.add(new TimeData("Time " + i2 + " not set", 0L));
        }
    }

    public static void outputLog() {
        PerformanceLogger.outputLog(logWriter);
    }

    public static boolean loggingEnabled() {
        return perfLoggingOn;
    }

    public static long getTimeAtIndex(int n2) {
        if (PerformanceLogger.loggingEnabled()) {
            return ((TimeData)times.get(n2)).getTime();
        }
        return 0L;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void outputLog(Writer writer) {
        if (PerformanceLogger.loggingEnabled()) {
            try {
                Vector vector = times;
                synchronized (vector) {
                    for (int i2 = 0; i2 < times.size(); ++i2) {
                        TimeData timeData = (TimeData)times.get(i2);
                        if (timeData == null) continue;
                        writer.write(i2 + " " + timeData.getMessage() + ": " + timeData.getTime() + "\n");
                    }
                }
                writer.flush();
            }
            catch (Exception exception) {
                System.out.println(exception + ": Writing performance log to " + writer);
            }
        }
    }

    public static String getMessageAtIndex(int n2) {
        if (PerformanceLogger.loggingEnabled()) {
            return ((TimeData)times.get(n2)).getMessage();
        }
        return null;
    }

    public static int setTime(String string) {
        if (PerformanceLogger.loggingEnabled()) {
            long l2 = System.currentTimeMillis();
            return PerformanceLogger.setTime(string, l2);
        }
        return 0;
    }

    public static void setStartTime(String string) {
        if (PerformanceLogger.loggingEnabled()) {
            long l2 = System.currentTimeMillis();
            PerformanceLogger.setStartTime(string, l2);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static int setTime(String string, long l2) {
        if (PerformanceLogger.loggingEnabled()) {
            Vector vector = times;
            synchronized (vector) {
                times.add(new TimeData(string, l2));
                return times.size() - 1;
            }
        }
        return 0;
    }

    public static void setStartTime(String string, long l2) {
        if (PerformanceLogger.loggingEnabled()) {
            times.set(0, new TimeData(string, l2));
        }
    }

    static class TimeData {
        String message;
        long time;

        long getTime() {
            return this.time;
        }

        String getMessage() {
            return this.message;
        }

        TimeData(String string, long l2) {
            this.message = string;
            this.time = l2;
        }
    }
}

