/*
 * Decompiled with CFR 0.152.
 */
package net.java.games.input;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import net.java.games.input.ControllerEnvironment;
import net.java.games.input.DummyWindow;
import net.java.games.input.IDirectInputDevice;

final class IDirectInput {
    private final List devices = new ArrayList();
    private final long idirectinput_address;
    private final DummyWindow window;

    public IDirectInput(DummyWindow dummyWindow) throws IOException {
        this.window = dummyWindow;
        this.idirectinput_address = IDirectInput.createIDirectInput();
        try {
            this.enumDevices();
            return;
        }
        catch (IOException iOException) {
            this.releaseDevices();
            this.release();
            throw iOException;
        }
    }

    private static final native long createIDirectInput() throws IOException;

    public final List getDevices() {
        return this.devices;
    }

    private final void enumDevices() throws IOException {
        this.nEnumDevices(this.idirectinput_address);
    }

    private final native void nEnumDevices(long var1) throws IOException;

    final void addDevice(long l2, byte[] byArray, byte[] byArray2, int n2, int n3, String string, String string2) throws IOException {
        try {
            IDirectInputDevice iDirectInputDevice = new IDirectInputDevice(this.window, l2, byArray, byArray2, n2, n3, string, string2);
            this.devices.add(iDirectInputDevice);
            return;
        }
        catch (IOException iOException) {
            ControllerEnvironment.logln("Failed to initialize device " + string2 + " because of: " + iOException);
            return;
        }
    }

    public final void releaseDevices() {
        for (int i2 = 0; i2 < this.devices.size(); ++i2) {
            IDirectInputDevice iDirectInputDevice = (IDirectInputDevice)this.devices.get(i2);
            iDirectInputDevice.release();
        }
    }

    public final void release() {
        IDirectInput.nRelease(this.idirectinput_address);
    }

    private static final native void nRelease(long var0);
}

