/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.swt.internal.theme;

import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.internal.theme.DrawData;
import org.eclipse.swt.internal.theme.Theme;
import org.eclipse.swt.internal.win32.OS;
import org.eclipse.swt.internal.win32.RECT;

public class GroupDrawData
extends DrawData {
    public int headerWidth;
    public int headerHeight;
    public Rectangle headerArea;
    static final int GROUP_HEADER_X = 9;
    static final int GROUP_HEADER_PAD = 2;

    public GroupDrawData() {
        this.state = new int[1];
    }

    void draw(Theme theme, GC gC, Rectangle rectangle) {
        if (OS.COMCTL32_MAJOR >= 6 && OS.IsAppThemed()) {
            Rectangle rectangle2;
            int n2 = OS.OpenThemeData(0, this.getClassId());
            RECT rECT = new RECT();
            rECT.left = rectangle.x;
            rECT.right = rectangle.x + rectangle.width;
            rECT.top = rectangle.y + this.headerHeight / 2;
            rECT.bottom = rectangle.y + rectangle.height;
            int n3 = rectangle.x + 9;
            int n4 = rectangle.y;
            int n5 = OS.SaveDC(gC.handle);
            OS.ExcludeClipRect(gC.handle, n3 - 2, n4, n3 + this.headerWidth + 2, n4 + this.headerHeight);
            int[] nArray = this.getPartId(0);
            OS.DrawThemeBackground(n2, gC.handle, nArray[0], nArray[1], rECT, null);
            OS.RestoreDC(gC.handle, n5);
            Rectangle rectangle3 = this.headerArea;
            if (rectangle3 != null) {
                rectangle3.x = n3;
                rectangle3.y = n4;
                rectangle3.width = this.headerWidth;
                rectangle3.height = this.headerHeight;
            }
            if ((rectangle2 = this.clientArea) != null) {
                RECT rECT2 = new RECT();
                OS.GetThemeBackgroundContentRect(n2, gC.handle, nArray[0], nArray[1], rECT, rECT2);
                rectangle2.x = rECT2.left;
                rectangle2.y = rECT2.top;
                rectangle2.width = rECT2.right - rECT2.left;
                rectangle2.height = rECT2.bottom - rECT2.top;
            }
            OS.CloseThemeData(n2);
        }
    }

    int[] getPartId(int n2) {
        int n3 = this.state[n2];
        int n4 = 4;
        int n5 = 1;
        if ((n3 & 0x20) != 0) {
            n5 = 2;
        }
        return new int[]{n4, n5};
    }

    int hit(Theme theme, Point point, Rectangle rectangle) {
        return rectangle.contains(point) ? 0 : -1;
    }
}

