/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.swt.widgets;

import org.eclipse.swt.SWT;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.GCData;
import org.eclipse.swt.internal.SWTEventListener;
import org.eclipse.swt.internal.win32.LRESULT;
import org.eclipse.swt.internal.win32.MSG;
import org.eclipse.swt.internal.win32.OS;
import org.eclipse.swt.internal.win32.PAINTSTRUCT;
import org.eclipse.swt.internal.win32.POINT;
import org.eclipse.swt.internal.win32.RECT;
import org.eclipse.swt.internal.win32.SHRGINFO;
import org.eclipse.swt.internal.win32.TRACKMOUSEEVENT;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.EventTable;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.TypedListener;

public abstract class Widget {
    int style;
    int state;
    Display display;
    EventTable eventTable;
    Object data;
    static final int DISPOSED = 1;
    static final int CANVAS = 2;
    static final int KEYED_DATA = 4;
    static final int DISABLED = 8;
    static final int HIDDEN = 16;
    static final int LAYOUT_NEEDED = 32;
    static final int LAYOUT_CHANGED = 64;
    static final int LAYOUT_CHILD = 128;
    static final int THEME_BACKGROUND = 256;
    static final int DRAW_BACKGROUND = 512;
    static final int PARENT_BACKGROUND = 1024;
    static final int RELEASED = 2048;
    static final int DISPOSE_SENT = 4096;
    static final int TRACK_MOUSE = 8192;
    static final int FOREIGN_HANDLE = 16384;
    static final int DRAG_DETECT = 32768;
    static final int DEFAULT_WIDTH = 64;
    static final int DEFAULT_HEIGHT = 64;
    static final int MAJOR = 5;
    static final int MINOR = 80;

    static {
        if (!OS.IsWinCE && OS.COMCTL32_VERSION < OS.VERSION(5, 80)) {
            System.out.println("***WARNING: SWT requires comctl32.dll version 5.80 or greater");
            System.out.println("***WARNING: Detected: " + OS.COMCTL32_MAJOR + "." + OS.COMCTL32_MINOR);
        }
        OS.InitCommonControls();
    }

    Widget() {
    }

    public Widget(Widget widget, int n2) {
        this.checkSubclass();
        this.checkParent(widget);
        this.style = n2;
        this.display = widget.display;
    }

    void _addListener(int n2, Listener listener) {
        if (this.eventTable == null) {
            this.eventTable = new EventTable();
        }
        this.eventTable.hook(n2, listener);
    }

    public void addListener(int n2, Listener listener) {
        this.checkWidget();
        if (listener == null) {
            this.error(4);
        }
        this._addListener(n2, listener);
    }

    public void addDisposeListener(DisposeListener disposeListener) {
        this.checkWidget();
        if (disposeListener == null) {
            this.error(4);
        }
        TypedListener typedListener = new TypedListener(disposeListener);
        this.addListener(12, typedListener);
    }

    int callWindowProc(int n2, int n3, int n4, int n5) {
        return 0;
    }

    static int checkBits(int n2, int n3, int n4, int n5, int n6, int n7, int n8) {
        int n9 = n3 | n4 | n5 | n6 | n7 | n8;
        if ((n2 & n9) == 0) {
            n2 |= n3;
        }
        if ((n2 & n3) != 0) {
            n2 = n2 & ~n9 | n3;
        }
        if ((n2 & n4) != 0) {
            n2 = n2 & ~n9 | n4;
        }
        if ((n2 & n5) != 0) {
            n2 = n2 & ~n9 | n5;
        }
        if ((n2 & n6) != 0) {
            n2 = n2 & ~n9 | n6;
        }
        if ((n2 & n7) != 0) {
            n2 = n2 & ~n9 | n7;
        }
        if ((n2 & n8) != 0) {
            n2 = n2 & ~n9 | n8;
        }
        return n2;
    }

    void checkOrientation(Widget widget) {
        this.style &= 0xF7FFFFFF;
        if ((this.style & 0x6000000) == 0 && widget != null) {
            if ((widget.style & 0x2000000) != 0) {
                this.style |= 0x2000000;
            }
            if ((widget.style & 0x4000000) != 0) {
                this.style |= 0x4000000;
            }
        }
        this.style = Widget.checkBits(this.style, 0x2000000, 0x4000000, 0, 0, 0, 0);
    }

    void checkOpened() {
    }

    void checkParent(Widget widget) {
        if (widget == null) {
            this.error(4);
        }
        if (widget.isDisposed()) {
            this.error(5);
        }
        widget.checkWidget();
        widget.checkOpened();
    }

    protected void checkSubclass() {
        if (!this.isValidSubclass()) {
            this.error(43);
        }
    }

    protected void checkWidget() {
        Display display = this.display;
        if (display == null) {
            this.error(24);
        }
        if (display.thread != Thread.currentThread()) {
            this.error(22);
        }
        if ((this.state & 1) != 0) {
            this.error(24);
        }
    }

    void destroyWidget() {
        this.releaseHandle();
    }

    int DeferWindowPos(int n2, int n3, int n4, int n5, int n6, int n7, int n8, int n9) {
        if (OS.IsWinCE && (n9 & 1) == 0) {
            RECT rECT = new RECT();
            OS.GetWindowRect(n3, rECT);
            if (n8 == rECT.bottom - rECT.top && n7 == rECT.right - rECT.left) {
                n9 &= 0xFFFFFFDF;
                n9 |= 1;
            }
        }
        return OS.DeferWindowPos(n2, n3, n4, n5, n6, n7, n8, n9);
    }

    public void dispose() {
        if (this.isDisposed()) {
            return;
        }
        if (!this.isValidThread()) {
            this.error(22);
        }
        this.release(true);
    }

    boolean dragDetect(int n2, int n3, int n4, boolean bl2, boolean[] blArray, boolean[] blArray2) {
        if (blArray2 != null) {
            blArray2[0] = false;
        }
        if (blArray != null) {
            blArray[0] = true;
        }
        POINT pOINT = new POINT();
        pOINT.x = n3;
        pOINT.y = n4;
        OS.ClientToScreen(n2, pOINT);
        return OS.DragDetect(n2, pOINT);
    }

    void error(int n2) {
        SWT.error(n2);
    }

    boolean filters(int n2) {
        return this.display.filters(n2);
    }

    Widget findItem(int n2) {
        return null;
    }

    char[] fixMnemonic(String string) {
        char[] cArray = new char[string.length()];
        string.getChars(0, string.length(), cArray, 0);
        int n2 = 0;
        int n3 = 0;
        while (n2 < cArray.length) {
            if (cArray[n2] == '&') {
                if (n2 + 1 < cArray.length && cArray[n2 + 1] == '&') {
                    cArray[n3++] = 32;
                    ++n2;
                }
                ++n2;
                continue;
            }
            cArray[n3++] = cArray[n2++];
        }
        while (n3 < cArray.length) {
            cArray[n3++] = '\u0000';
        }
        return cArray;
    }

    public Object getData() {
        this.checkWidget();
        return (this.state & 4) != 0 ? ((Object[])this.data)[0] : this.data;
    }

    public Object getData(String string) {
        this.checkWidget();
        if (string == null) {
            this.error(4);
        }
        if ((this.state & 4) != 0) {
            Object[] objectArray = (Object[])this.data;
            int n2 = 1;
            while (n2 < objectArray.length) {
                if (string.equals(objectArray[n2])) {
                    return objectArray[n2 + 1];
                }
                n2 += 2;
            }
        }
        return null;
    }

    public Display getDisplay() {
        Display display = this.display;
        if (display == null) {
            this.error(24);
        }
        return display;
    }

    Menu getMenu() {
        return null;
    }

    String getName() {
        String string = this.getClass().getName();
        int n2 = string.lastIndexOf(46);
        if (n2 == -1) {
            return string;
        }
        return string.substring(n2 + 1, string.length());
    }

    String getNameText() {
        return "";
    }

    public int getStyle() {
        this.checkWidget();
        return this.style;
    }

    boolean hooks(int n2) {
        if (this.eventTable == null) {
            return false;
        }
        return this.eventTable.hooks(n2);
    }

    public boolean isDisposed() {
        return (this.state & 1) != 0;
    }

    public boolean isListening(int n2) {
        this.checkWidget();
        return this.hooks(n2);
    }

    boolean isValidSubclass() {
        return Display.isValidClass(this.getClass());
    }

    boolean isValidThread() {
        return this.getDisplay().isValidThread();
    }

    void mapEvent(int n2, Event event) {
    }

    GC new_GC(GCData gCData) {
        return null;
    }

    public void notifyListeners(int n2, Event event) {
        this.checkWidget();
        if (event == null) {
            event = new Event();
        }
        this.sendEvent(n2, event);
    }

    void postEvent(int n2) {
        this.sendEvent(n2, null, false);
    }

    void postEvent(int n2, Event event) {
        this.sendEvent(n2, event, false);
    }

    void release(boolean bl2) {
        if ((this.state & 0x1000) == 0) {
            this.state |= 0x1000;
            this.sendEvent(12);
        }
        if ((this.state & 1) == 0) {
            this.releaseChildren(bl2);
        }
        if ((this.state & 0x800) == 0) {
            this.state |= 0x800;
            if (bl2) {
                this.releaseParent();
                this.releaseWidget();
                this.destroyWidget();
            } else {
                this.releaseWidget();
                this.releaseHandle();
            }
        }
    }

    void releaseChildren(boolean bl2) {
    }

    void releaseHandle() {
        this.state |= 1;
        this.display = null;
    }

    void releaseParent() {
    }

    void releaseWidget() {
        this.eventTable = null;
        this.data = null;
    }

    public void removeListener(int n2, Listener listener) {
        this.checkWidget();
        if (listener == null) {
            this.error(4);
        }
        if (this.eventTable == null) {
            return;
        }
        this.eventTable.unhook(n2, listener);
    }

    protected void removeListener(int n2, SWTEventListener sWTEventListener) {
        this.checkWidget();
        if (sWTEventListener == null) {
            this.error(4);
        }
        if (this.eventTable == null) {
            return;
        }
        this.eventTable.unhook(n2, sWTEventListener);
    }

    public void removeDisposeListener(DisposeListener disposeListener) {
        this.checkWidget();
        if (disposeListener == null) {
            this.error(4);
        }
        if (this.eventTable == null) {
            return;
        }
        this.eventTable.unhook(12, disposeListener);
    }

    boolean sendDragEvent(int n2, int n3, int n4) {
        Event event = new Event();
        event.button = n2;
        event.x = n3;
        event.y = n4;
        this.setInputState(event, 29);
        this.postEvent(29, event);
        if (this.isDisposed()) {
            return false;
        }
        return event.doit;
    }

    boolean sendDragEvent(int n2, int n3, int n4, int n5) {
        Event event = new Event();
        event.button = n2;
        event.x = n4;
        event.y = n5;
        event.stateMask = n3;
        this.postEvent(29, event);
        if (this.isDisposed()) {
            return false;
        }
        return event.doit;
    }

    void sendEvent(Event event) {
        Display display = event.display;
        if (!display.filterEvent(event) && this.eventTable != null) {
            this.eventTable.sendEvent(event);
        }
    }

    void sendEvent(int n2) {
        this.sendEvent(n2, null, true);
    }

    void sendEvent(int n2, Event event) {
        this.sendEvent(n2, event, true);
    }

    void sendEvent(int n2, Event event, boolean bl2) {
        if (this.eventTable == null && !this.display.filters(n2)) {
            return;
        }
        if (event == null) {
            event = new Event();
        }
        event.type = n2;
        event.display = this.display;
        event.widget = this;
        if (event.time == 0) {
            event.time = this.display.getLastEventTime();
        }
        if (bl2) {
            this.sendEvent(event);
        } else {
            this.display.postEvent(event);
        }
    }

    boolean sendKeyEvent(int n2, int n3, int n4, int n5) {
        Event event = new Event();
        if (!this.setKeyState(event, n2, n4, n5)) {
            return true;
        }
        return this.sendKeyEvent(n2, n3, n4, n5, event);
    }

    boolean sendKeyEvent(int n2, int n3, int n4, int n5, Event event) {
        this.sendEvent(n2, event);
        if (this.isDisposed()) {
            return false;
        }
        return event.doit;
    }

    boolean sendMouseEvent(int n2, int n3, int n4, int n5, int n6, int n7) {
        return this.sendMouseEvent(n2, n3, this.display.getClickCount(n2, n3, n4, n7), 0, false, n4, n5, n6, n7);
    }

    boolean sendMouseEvent(int n2, int n3, int n4, int n5, boolean bl2, int n6, int n7, int n8, int n9) {
        if (!this.hooks(n2) && !this.filters(n2)) {
            return true;
        }
        Event event = new Event();
        event.button = n3;
        event.detail = n5;
        event.count = n4;
        event.x = (short)(n9 & 0xFFFF);
        event.y = (short)(n9 >> 16);
        this.setInputState(event, n2);
        this.mapEvent(n6, event);
        if (bl2) {
            this.sendEvent(n2, event);
            if (this.isDisposed()) {
                return false;
            }
        } else {
            this.postEvent(n2, event);
        }
        return event.doit;
    }

    public void setData(Object object) {
        this.checkWidget();
        if ((this.state & 4) != 0) {
            ((Object[])this.data)[0] = object;
        } else {
            this.data = object;
        }
    }

    public void setData(String string, Object object) {
        this.checkWidget();
        if (string == null) {
            this.error(4);
        }
        int n2 = 1;
        Object[] objectArray = null;
        if ((this.state & 4) != 0) {
            objectArray = (Object[])this.data;
            while (n2 < objectArray.length) {
                if (string.equals(objectArray[n2])) break;
                n2 += 2;
            }
        }
        if (object != null) {
            if ((this.state & 4) != 0) {
                if (n2 == objectArray.length) {
                    Object[] objectArray2 = new Object[objectArray.length + 2];
                    System.arraycopy(objectArray, 0, objectArray2, 0, objectArray.length);
                    objectArray = objectArray2;
                    this.data = objectArray2;
                }
            } else {
                objectArray = new Object[3];
                objectArray[0] = this.data;
                this.data = objectArray;
                this.state |= 4;
            }
            objectArray[n2] = string;
            objectArray[n2 + 1] = object;
        } else if ((this.state & 4) != 0 && n2 != objectArray.length) {
            int n3 = objectArray.length - 2;
            if (n3 == 1) {
                this.data = objectArray[0];
                this.state &= 0xFFFFFFFB;
            } else {
                Object[] objectArray3 = new Object[n3];
                System.arraycopy(objectArray, 0, objectArray3, 0, n2);
                System.arraycopy(objectArray, n2 + 2, objectArray3, n2, n3 - n2);
                this.data = objectArray3;
            }
        }
    }

    boolean sendFocusEvent(int n2) {
        this.sendEvent(n2);
        return true;
    }

    boolean setInputState(Event event, int n2) {
        if (OS.GetKeyState(18) < 0) {
            event.stateMask |= 0x10000;
        }
        if (OS.GetKeyState(16) < 0) {
            event.stateMask |= 0x20000;
        }
        if (OS.GetKeyState(17) < 0) {
            event.stateMask |= 0x40000;
        }
        if (OS.GetKeyState(1) < 0) {
            event.stateMask |= 0x80000;
        }
        if (OS.GetKeyState(4) < 0) {
            event.stateMask |= 0x100000;
        }
        if (OS.GetKeyState(2) < 0) {
            event.stateMask |= 0x200000;
        }
        if (OS.GetKeyState(5) < 0) {
            event.stateMask |= 0x800000;
        }
        if (OS.GetKeyState(6) < 0) {
            event.stateMask |= 0x2000000;
        }
        switch (n2) {
            case 3: 
            case 8: {
                if (event.button == 1) {
                    event.stateMask &= 0xFFF7FFFF;
                }
                if (event.button == 2) {
                    event.stateMask &= 0xFFEFFFFF;
                }
                if (event.button == 3) {
                    event.stateMask &= 0xFFDFFFFF;
                }
                if (event.button == 4) {
                    event.stateMask &= 0xFF7FFFFF;
                }
                if (event.button != 5) break;
                event.stateMask &= 0xFDFFFFFF;
                break;
            }
            case 4: {
                if (event.button == 1) {
                    event.stateMask |= 0x80000;
                }
                if (event.button == 2) {
                    event.stateMask |= 0x100000;
                }
                if (event.button == 3) {
                    event.stateMask |= 0x200000;
                }
                if (event.button == 4) {
                    event.stateMask |= 0x800000;
                }
                if (event.button != 5) break;
                event.stateMask |= 0x2000000;
                break;
            }
            case 1: 
            case 31: {
                if (event.keyCode == 65536) {
                    event.stateMask &= 0xFFFEFFFF;
                }
                if (event.keyCode == 131072) {
                    event.stateMask &= 0xFFFDFFFF;
                }
                if (event.keyCode != 262144) break;
                event.stateMask &= 0xFFFBFFFF;
                break;
            }
            case 2: {
                if (event.keyCode == 65536) {
                    event.stateMask |= 0x10000;
                }
                if (event.keyCode == 131072) {
                    event.stateMask |= 0x20000;
                }
                if (event.keyCode != 262144) break;
                event.stateMask |= 0x40000;
            }
        }
        return true;
    }

    boolean setKeyState(Event event, int n2, int n3, int n4) {
        switch (this.display.lastAscii) {
            case 127: {
                if (this.display.lastKey != 8) break;
                this.display.lastAscii = 8;
                break;
            }
            case 10: {
                if (this.display.lastKey != 13) break;
                this.display.lastAscii = 13;
            }
        }
        if (this.display.lastKey == 13 && this.display.lastAscii == 13 && (n4 & 0x1000000) != 0) {
            this.display.lastKey = 0x1000050;
        }
        if (this.display.lastVirtual) {
            if (this.display.lastKey == 46) {
                this.display.lastAscii = 127;
            }
            if (this.display.lastKey == 3) {
                this.display.lastAscii = 0;
            }
            event.keyCode = Display.translateKey(this.display.lastKey);
        } else {
            event.keyCode = this.display.lastKey;
        }
        if (this.display.lastAscii != 0 || this.display.lastNull) {
            event.character = Display.mbcsToWcs((char)this.display.lastAscii);
        }
        if (event.keyCode == 0 && event.character == '\u0000' && !this.display.lastNull) {
            return false;
        }
        return this.setInputState(event, n2);
    }

    boolean SetWindowPos(int n2, int n3, int n4, int n5, int n6, int n7, int n8) {
        if (OS.IsWinCE && (n8 & 1) == 0) {
            RECT rECT = new RECT();
            OS.GetWindowRect(n2, rECT);
            if (n7 == rECT.bottom - rECT.top && n6 == rECT.right - rECT.left) {
                n8 &= 0xFFFFFFDF;
                n8 |= 1;
            }
        }
        return OS.SetWindowPos(n2, n3, n4, n5, n6, n7, n8);
    }

    boolean showMenu(int n2, int n3) {
        Event event = new Event();
        event.x = n2;
        event.y = n3;
        this.sendEvent(35, event);
        if (!event.doit) {
            return true;
        }
        Menu menu = this.getMenu();
        if (menu != null && !menu.isDisposed()) {
            if (n2 != event.x || n3 != event.y) {
                menu.setLocation(event.x, event.y);
            }
            menu.setVisible(true);
            return true;
        }
        return false;
    }

    public String toString() {
        String string = "*Disposed*";
        if (!this.isDisposed()) {
            string = "*Wrong Thread*";
            if (this.isValidThread()) {
                string = this.getNameText();
            }
        }
        return String.valueOf(this.getName()) + " {" + string + "}";
    }

    LRESULT wmCaptureChanged(int n2, int n3, int n4) {
        this.display.captureChanged = true;
        return null;
    }

    LRESULT wmChar(int n2, int n3, int n4) {
        byte by2;
        if (!OS.IsUnicode && OS.IsDBLocale && OS.IsDBCSLeadByte(by2 = (byte)(n3 & 0xFF))) {
            return null;
        }
        this.display.lastAscii = n3;
        boolean bl2 = this.display.lastNull = n3 == 0;
        if (!this.sendKeyEvent(1, 258, n3, n4)) {
            return LRESULT.ONE;
        }
        return null;
    }

    LRESULT wmContextMenu(int n2, int n3, int n4) {
        if (n3 != n2) {
            return null;
        }
        if (OS.IsWinCE) {
            return null;
        }
        short s2 = 0;
        short s3 = 0;
        if (n4 != -1) {
            POINT pOINT = new POINT();
            short s4 = (short)(n4 & 0xFFFF);
            pOINT.x = s4;
            s2 = s4;
            short s5 = (short)(n4 >> 16);
            pOINT.y = s5;
            s3 = s5;
            OS.ScreenToClient(n2, pOINT);
            RECT rECT = new RECT();
            OS.GetClientRect(n2, rECT);
            if (!OS.PtInRect(rECT, pOINT)) {
                return null;
            }
        } else {
            int n5 = OS.GetMessagePos();
            s2 = (short)(n5 & 0xFFFF);
            s3 = (short)(n5 >> 16);
        }
        return this.showMenu(s2, s3) ? LRESULT.ZERO : null;
    }

    LRESULT wmIMEChar(int n2, int n3, int n4) {
        Display display = this.display;
        display.lastKey = 0;
        display.lastAscii = n3;
        display.lastDead = false;
        display.lastNull = false;
        display.lastVirtual = false;
        if (!this.sendKeyEvent(1, 646, n3, n4)) {
            return LRESULT.ONE;
        }
        this.sendKeyEvent(2, 646, n3, n4);
        display.lastAscii = 0;
        display.lastKey = 0;
        return LRESULT.ONE;
    }

    LRESULT wmKeyDown(int n2, int n3, int n4) {
        byte by2;
        switch (n3) {
            case 16: 
            case 17: 
            case 18: 
            case 20: 
            case 144: 
            case 145: {
                if ((n4 & 0x40000000) == 0) break;
                return null;
            }
        }
        this.display.lastKey = 0;
        this.display.lastAscii = 0;
        this.display.lastDead = false;
        this.display.lastNull = false;
        this.display.lastVirtual = false;
        if (!OS.IsUnicode && OS.IsDBLocale && OS.IsDBCSLeadByte(by2 = (byte)(n3 & 0xFF))) {
            return null;
        }
        by2 = 0;
        if (OS.IsWinCE) {
            switch (n3) {
                case 8: {
                    by2 = (byte)8;
                    break;
                }
                case 13: {
                    by2 = (byte)13;
                    break;
                }
                case 46: {
                    by2 = (byte)127;
                    break;
                }
                case 27: {
                    by2 = (byte)27;
                    break;
                }
                case 9: {
                    by2 = (byte)9;
                }
            }
        } else {
            by2 = (byte)OS.MapVirtualKey(n3, 2);
        }
        if (OS.IsWinNT ? (by2 & Integer.MIN_VALUE) != 0 : (by2 & 0x8000) != 0) {
            return null;
        }
        MSG mSG = new MSG();
        int n5 = 10420226;
        if (OS.PeekMessage(mSG, n2, 259, 259, n5)) {
            this.display.lastDead = true;
            this.display.lastVirtual = by2 == 0;
            this.display.lastKey = this.display.lastVirtual ? n3 : (int)by2;
            return null;
        }
        if (this.isDisposed()) {
            return LRESULT.ONE;
        }
        boolean bl2 = this.display.lastVirtual = by2 == 0 || this.display.numpadKey(n3) != 0;
        if (this.display.lastVirtual) {
            this.display.lastKey = n3;
            if (this.display.lastKey == 46) {
                this.display.lastAscii = 127;
            }
            if (96 <= this.display.lastKey && this.display.lastKey <= 111) {
                if (this.display.asciiKey(this.display.lastKey) != 0) {
                    return null;
                }
                this.display.lastAscii = this.display.numpadKey(this.display.lastKey);
            }
        } else {
            int n6;
            this.display.lastKey = OS.CharLower(by2);
            if (n3 == 3) {
                this.display.lastVirtual = true;
            }
            if ((n6 = this.display.asciiKey(n3)) != 0) {
                if (n6 == 32) {
                    return null;
                }
                if (n6 != n3) {
                    return null;
                }
                if (n3 == 3) {
                    return null;
                }
            }
            if (OS.GetKeyState(17) >= 0) {
                return null;
            }
            if (OS.GetKeyState(16) < 0) {
                this.display.lastAscii = this.display.shiftedKey(n3);
                if (this.display.lastAscii == 0) {
                    this.display.lastAscii = by2;
                }
            } else {
                this.display.lastAscii = OS.CharLower(by2);
            }
            if (this.display.lastAscii == 64) {
                return null;
            }
            this.display.lastAscii = this.display.controlKey(this.display.lastAscii);
        }
        if (!this.sendKeyEvent(1, 256, n3, n4)) {
            return LRESULT.ONE;
        }
        return null;
    }

    LRESULT wmKeyUp(int n2, int n3, int n4) {
        Display display = this.display;
        if (OS.IsWinCE && 193 <= n3 && n3 <= 198) {
            int n5;
            display.lastAscii = 0;
            display.lastKey = 0;
            display.lastDead = false;
            display.lastNull = false;
            display.lastVirtual = false;
            Event event = new Event();
            event.detail = n3 - 193 + 1;
            int n6 = n5 = (n4 & 0x40000000) != 0 ? 34 : 33;
            if (this.setInputState(event, n5)) {
                this.sendEvent(n5, event);
            }
            return null;
        }
        if (!this.hooks(2) && !display.filters(2)) {
            display.lastAscii = 0;
            display.lastKey = 0;
            display.lastDead = false;
            display.lastNull = false;
            display.lastVirtual = false;
            return null;
        }
        int n7 = 0;
        if (OS.IsWinCE) {
            switch (n3) {
                case 8: {
                    n7 = 8;
                    break;
                }
                case 13: {
                    n7 = 13;
                    break;
                }
                case 46: {
                    n7 = 127;
                    break;
                }
                case 27: {
                    n7 = 27;
                    break;
                }
                case 9: {
                    n7 = 9;
                }
            }
        } else {
            n7 = OS.MapVirtualKey(n3, 2);
        }
        if (OS.IsWinNT ? (n7 & Integer.MIN_VALUE) != 0 : (n7 & 0x8000) != 0) {
            return null;
        }
        if (display.lastDead) {
            return null;
        }
        boolean bl2 = display.lastVirtual = n7 == 0 || display.numpadKey(n3) != 0;
        if (display.lastVirtual) {
            display.lastKey = n3;
        } else {
            if (n3 == 3) {
                display.lastVirtual = true;
            }
            if (display.lastKey == 0) {
                display.lastAscii = 0;
                display.lastDead = false;
                display.lastNull = false;
                return null;
            }
        }
        LRESULT lRESULT = null;
        if (!this.sendKeyEvent(2, 257, n3, n4)) {
            lRESULT = LRESULT.ONE;
        }
        display.lastAscii = 0;
        display.lastKey = 0;
        display.lastDead = false;
        display.lastNull = false;
        display.lastVirtual = false;
        return lRESULT;
    }

    LRESULT wmKillFocus(int n2, int n3, int n4) {
        int n5 = this.callWindowProc(n2, 8, n3, n4);
        this.sendFocusEvent(16);
        if (this.isDisposed()) {
            return LRESULT.ZERO;
        }
        if (n5 == 0) {
            return LRESULT.ZERO;
        }
        return new LRESULT(n5);
    }

    LRESULT wmLButtonDblClk(int n2, int n3, int n4) {
        LRESULT lRESULT = null;
        Display display = this.display;
        display.captureChanged = false;
        this.sendMouseEvent(3, 1, n2, 513, n3, n4);
        lRESULT = this.sendMouseEvent(8, 1, n2, 515, n3, n4) ? new LRESULT(this.callWindowProc(n2, 515, n3, n4)) : LRESULT.ZERO;
        if (!display.captureChanged && !this.isDisposed() && OS.GetCapture() != n2) {
            OS.SetCapture(n2);
        }
        return lRESULT;
    }

    LRESULT wmLButtonDown(int n2, int n3, int n4) {
        Display display = this.display;
        LRESULT lRESULT = null;
        short s2 = (short)(n4 & 0xFFFF);
        short s3 = (short)(n4 >> 16);
        boolean[] blArray = null;
        boolean[] blArray2 = null;
        boolean bl2 = false;
        boolean bl3 = true;
        int n5 = display.getClickCount(3, 1, n2, n4);
        if (n5 == 1 && (this.state & 0x8000) != 0 && this.hooks(29) && !OS.IsWinCE) {
            blArray2 = new boolean[1];
            blArray = new boolean[1];
            bl2 = this.dragDetect(n2, s2, s3, true, blArray2, blArray);
            if (this.isDisposed()) {
                return LRESULT.ZERO;
            }
            bl3 = OS.GetKeyState(1) < 0;
        }
        display.captureChanged = false;
        boolean bl4 = this.sendMouseEvent(3, 1, n5, 0, false, n2, 513, n3, n4);
        lRESULT = bl4 && (blArray == null || !blArray[0]) ? new LRESULT(this.callWindowProc(n2, 513, n3, n4)) : LRESULT.ZERO;
        if (OS.IsPPC) {
            boolean bl5;
            Menu menu = this.getMenu();
            boolean bl6 = bl5 = menu != null && !menu.isDisposed();
            if (bl5 || this.hooks(35)) {
                SHRGINFO sHRGINFO = new SHRGINFO();
                sHRGINFO.cbSize = SHRGINFO.sizeof;
                sHRGINFO.hwndClient = n2;
                sHRGINFO.ptDown_x = s2;
                sHRGINFO.ptDown_y = s3;
                sHRGINFO.dwFlags = 1;
                int n6 = OS.SHRecognizeGesture(sHRGINFO);
                if (n6 == 1000) {
                    this.showMenu(s2, s3);
                }
            }
        }
        if (bl3 && !display.captureChanged && !this.isDisposed() && OS.GetCapture() != n2) {
            OS.SetCapture(n2);
        }
        if (bl2) {
            this.sendDragEvent(1, s2, s3);
        } else if (blArray2 != null && blArray2[0] && OS.GetKeyState(27) >= 0) {
            OS.SendMessage(n2, 514, n3, n4);
        }
        return lRESULT;
    }

    LRESULT wmLButtonUp(int n2, int n3, int n4) {
        Display display = this.display;
        LRESULT lRESULT = null;
        lRESULT = this.sendMouseEvent(4, 1, n2, 514, n3, n4) ? new LRESULT(this.callWindowProc(n2, 514, n3, n4)) : LRESULT.ZERO;
        int n5 = 19;
        if (display.xMouse) {
            n5 |= 0x60;
        }
        if ((n3 & 0xFFFF & n5) == 0 && OS.GetCapture() == n2) {
            OS.ReleaseCapture();
        }
        return lRESULT;
    }

    LRESULT wmMButtonDblClk(int n2, int n3, int n4) {
        LRESULT lRESULT = null;
        Display display = this.display;
        display.captureChanged = false;
        this.sendMouseEvent(3, 2, n2, 519, n3, n4);
        lRESULT = this.sendMouseEvent(8, 2, n2, 521, n3, n4) ? new LRESULT(this.callWindowProc(n2, 521, n3, n4)) : LRESULT.ZERO;
        if (!display.captureChanged && !this.isDisposed() && OS.GetCapture() != n2) {
            OS.SetCapture(n2);
        }
        return lRESULT;
    }

    LRESULT wmMButtonDown(int n2, int n3, int n4) {
        LRESULT lRESULT = null;
        Display display = this.display;
        display.captureChanged = false;
        lRESULT = this.sendMouseEvent(3, 2, n2, 519, n3, n4) ? new LRESULT(this.callWindowProc(n2, 519, n3, n4)) : LRESULT.ZERO;
        if (!display.captureChanged && !this.isDisposed() && OS.GetCapture() != n2) {
            OS.SetCapture(n2);
        }
        return lRESULT;
    }

    LRESULT wmMButtonUp(int n2, int n3, int n4) {
        Display display = this.display;
        LRESULT lRESULT = null;
        lRESULT = this.sendMouseEvent(4, 2, n2, 520, n3, n4) ? new LRESULT(this.callWindowProc(n2, 520, n3, n4)) : LRESULT.ZERO;
        int n5 = 19;
        if (display.xMouse) {
            n5 |= 0x60;
        }
        if ((n3 & 0xFFFF & n5) == 0 && OS.GetCapture() == n2) {
            OS.ReleaseCapture();
        }
        return lRESULT;
    }

    LRESULT wmMouseHover(int n2, int n3, int n4) {
        if (!this.sendMouseEvent(32, 0, n2, 673, n3, n4)) {
            return LRESULT.ZERO;
        }
        return null;
    }

    LRESULT wmMouseLeave(int n2, int n3, int n4) {
        if (!this.hooks(7) && !this.filters(7)) {
            return null;
        }
        int n5 = OS.GetMessagePos();
        POINT pOINT = new POINT();
        pOINT.x = (short)(n5 & 0xFFFF);
        pOINT.y = (short)(n5 >> 16);
        OS.ScreenToClient(n2, pOINT);
        n4 = pOINT.x & 0xFFFF | pOINT.y << 16 & 0xFFFF0000;
        if (!this.sendMouseEvent(7, 0, n2, 675, n3, n4)) {
            return LRESULT.ZERO;
        }
        return null;
    }

    LRESULT wmMouseMove(int n2, int n3, int n4) {
        LRESULT lRESULT = null;
        Display display = this.display;
        int n5 = OS.GetMessagePos();
        if (n5 != display.lastMouse || display.captureChanged) {
            if (!OS.IsWinCE) {
                boolean bl2;
                boolean bl3 = (this.state & 0x2000) != 0;
                boolean bl4 = this.hooks(6) || display.filters(6);
                boolean bl5 = this.hooks(7) || display.filters(7);
                boolean bl6 = bl2 = this.hooks(32) || display.filters(32);
                if (bl3 || bl4 || bl5 || bl2) {
                    TRACKMOUSEEVENT tRACKMOUSEEVENT = new TRACKMOUSEEVENT();
                    tRACKMOUSEEVENT.cbSize = TRACKMOUSEEVENT.sizeof;
                    tRACKMOUSEEVENT.dwFlags = 0x40000000;
                    tRACKMOUSEEVENT.hwndTrack = n2;
                    OS.TrackMouseEvent(tRACKMOUSEEVENT);
                    if (tRACKMOUSEEVENT.dwFlags == 0) {
                        tRACKMOUSEEVENT.dwFlags = 3;
                        tRACKMOUSEEVENT.hwndTrack = n2;
                        OS.TrackMouseEvent(tRACKMOUSEEVENT);
                        if (bl4) {
                            MSG mSG = new MSG();
                            int n6 = 10420227;
                            while (OS.PeekMessage(mSG, 0, 675, 675, n6)) {
                                OS.TranslateMessage(mSG);
                                OS.DispatchMessage(mSG);
                            }
                            this.sendMouseEvent(6, 0, n2, 512, n3, n4);
                        }
                    } else {
                        tRACKMOUSEEVENT.dwFlags = 1;
                        OS.TrackMouseEvent(tRACKMOUSEEVENT);
                    }
                }
            }
            if (n5 != display.lastMouse) {
                display.lastMouse = n5;
                if (!this.sendMouseEvent(5, 0, n2, 512, n3, n4)) {
                    lRESULT = LRESULT.ZERO;
                }
            }
        }
        display.captureChanged = false;
        return lRESULT;
    }

    LRESULT wmMouseWheel(int n2, int n3, int n4) {
        int n5;
        int n6;
        if (!this.hooks(37) && !this.filters(37)) {
            return null;
        }
        int n7 = n3 >> 16;
        int[] nArray = new int[1];
        OS.SystemParametersInfo(104, 0, nArray, 0);
        if (nArray[0] == -1) {
            n6 = 2;
            n5 = n7 / 120;
        } else {
            n6 = 1;
            n5 = nArray[0] * n7 / 120;
        }
        POINT pOINT = new POINT();
        pOINT.x = (short)(n4 & 0xFFFF);
        pOINT.y = (short)(n4 >> 16);
        OS.ScreenToClient(n2, pOINT);
        n4 = pOINT.x & 0xFFFF | pOINT.y << 16 & 0xFFFF0000;
        if (!this.sendMouseEvent(37, 0, n5, n6, true, n2, 522, n3, n4)) {
            return LRESULT.ZERO;
        }
        return null;
    }

    LRESULT wmPaint(int n2, int n3, int n4) {
        if (!this.hooks(9) && !this.filters(9)) {
            return null;
        }
        int n5 = 0;
        if (OS.IsWinCE) {
            RECT rECT = new RECT();
            OS.GetUpdateRect(n2, rECT, false);
            n5 = this.callWindowProc(n2, 15, n3, n4);
            OS.HideCaret(n2);
            OS.InvalidateRect(n2, rECT, false);
            OS.ShowCaret(n2);
            PAINTSTRUCT pAINTSTRUCT = new PAINTSTRUCT();
            GCData gCData = new GCData();
            gCData.ps = pAINTSTRUCT;
            gCData.hwnd = n2;
            GC gC = this.new_GC(gCData);
            if (gC != null) {
                int n6 = pAINTSTRUCT.right - pAINTSTRUCT.left;
                int n7 = pAINTSTRUCT.bottom - pAINTSTRUCT.top;
                if (n6 != 0 && n7 != 0) {
                    Event event = new Event();
                    event.gc = gC;
                    event.x = pAINTSTRUCT.left;
                    event.y = pAINTSTRUCT.top;
                    event.width = n6;
                    event.height = n7;
                    this.sendEvent(9, event);
                    event.gc = null;
                }
                gC.dispose();
            }
        } else {
            int n8 = OS.CreateRectRgn(0, 0, 0, 0);
            OS.GetUpdateRgn(n2, n8, false);
            n5 = this.callWindowProc(n2, 15, n3, n4);
            GCData gCData = new GCData();
            gCData.hwnd = n2;
            GC gC = this.new_GC(gCData);
            if (gC != null) {
                OS.HideCaret(n2);
                RECT rECT = new RECT();
                OS.GetRgnBox(n8, rECT);
                int n9 = rECT.right - rECT.left;
                int n10 = rECT.bottom - rECT.top;
                if (n9 != 0 && n10 != 0) {
                    int n11 = gC.handle;
                    OS.SelectClipRgn(n11, n8);
                    OS.SetMetaRgn(n11);
                    Event event = new Event();
                    event.gc = gC;
                    event.x = rECT.left;
                    event.y = rECT.top;
                    event.width = n9;
                    event.height = n10;
                    this.sendEvent(9, event);
                    event.gc = null;
                }
                gC.dispose();
                OS.ShowCaret(n2);
            }
            OS.DeleteObject(n8);
        }
        if (n5 == 0) {
            return LRESULT.ZERO;
        }
        return new LRESULT(n5);
    }

    LRESULT wmPrint(int n2, int n3, int n4) {
        int n5;
        if ((n4 & 2) != 0 && OS.COMCTL32_MAJOR >= 6 && OS.IsAppThemed() && ((n5 = OS.GetWindowLong(n2, -20)) & 0x200) != 0) {
            int n6 = this.callWindowProc(n2, 791, n3, n4);
            RECT rECT = new RECT();
            OS.GetWindowRect(n2, rECT);
            rECT.right -= rECT.left;
            rECT.bottom -= rECT.top;
            rECT.top = 0;
            rECT.left = 0;
            int n7 = OS.GetSystemMetrics(45);
            OS.ExcludeClipRect(n3, n7, n7, rECT.right - n7, rECT.bottom - n7);
            OS.DrawThemeBackground(this.display.hEditTheme(), n3, 1, 1, rECT, null);
            return new LRESULT(n6);
        }
        return null;
    }

    LRESULT wmRButtonDblClk(int n2, int n3, int n4) {
        LRESULT lRESULT = null;
        Display display = this.display;
        display.captureChanged = false;
        this.sendMouseEvent(3, 3, n2, 516, n3, n4);
        lRESULT = this.sendMouseEvent(8, 3, n2, 518, n3, n4) ? new LRESULT(this.callWindowProc(n2, 518, n3, n4)) : LRESULT.ZERO;
        if (!display.captureChanged && !this.isDisposed() && OS.GetCapture() != n2) {
            OS.SetCapture(n2);
        }
        return lRESULT;
    }

    LRESULT wmRButtonDown(int n2, int n3, int n4) {
        LRESULT lRESULT = null;
        Display display = this.display;
        display.captureChanged = false;
        lRESULT = this.sendMouseEvent(3, 3, n2, 516, n3, n4) ? new LRESULT(this.callWindowProc(n2, 516, n3, n4)) : LRESULT.ZERO;
        if (!display.captureChanged && !this.isDisposed() && OS.GetCapture() != n2) {
            OS.SetCapture(n2);
        }
        return lRESULT;
    }

    LRESULT wmRButtonUp(int n2, int n3, int n4) {
        Display display = this.display;
        LRESULT lRESULT = null;
        if (this.sendMouseEvent(4, 3, n2, 517, n3, n4)) {
            lRESULT = new LRESULT(this.callWindowProc(n2, 517, n3, n4));
        } else {
            OS.DefWindowProc(n2, 517, n3, n4);
            lRESULT = LRESULT.ZERO;
        }
        int n5 = 19;
        if (display.xMouse) {
            n5 |= 0x60;
        }
        if ((n3 & 0xFFFF & n5) == 0 && OS.GetCapture() == n2) {
            OS.ReleaseCapture();
        }
        return lRESULT;
    }

    LRESULT wmSetFocus(int n2, int n3, int n4) {
        int n5 = this.callWindowProc(n2, 7, n3, n4);
        this.sendFocusEvent(15);
        if (this.isDisposed()) {
            return LRESULT.ZERO;
        }
        if (n5 == 0) {
            return LRESULT.ZERO;
        }
        return new LRESULT(n5);
    }

    LRESULT wmSysChar(int n2, int n3, int n4) {
        Display display = this.display;
        display.lastAscii = n3;
        boolean bl2 = display.lastNull = n3 == 0;
        if (!this.hooks(1) && !display.filters(1)) {
            return null;
        }
        boolean bl3 = display.mnemonicKeyHit;
        display.mnemonicKeyHit = true;
        int n5 = this.callWindowProc(n2, 262, n3, n4);
        boolean bl4 = false;
        if (!display.mnemonicKeyHit) {
            bl4 = !this.sendKeyEvent(1, 262, n3, n4);
        }
        display.mnemonicKeyHit = bl3;
        return (bl4 |= display.mnemonicKeyHit) ? LRESULT.ONE : new LRESULT(n5);
    }

    LRESULT wmSysKeyDown(int n2, int n3, int n4) {
        int n5;
        if (n3 != 121 && (n4 & 0x20000000) == 0) {
            return null;
        }
        switch (n3) {
            case 115: {
                n5 = n2;
                while (OS.GetParent(n5) != 0) {
                    if (OS.GetWindow(n5, 4) != 0) break;
                    n5 = OS.GetParent(n5);
                }
                int n6 = OS.GetWindowLong(n5, -16);
                if ((n6 & 0x80000) == 0) break;
                return null;
            }
        }
        switch (n3) {
            case 16: 
            case 17: 
            case 18: 
            case 20: 
            case 144: 
            case 145: {
                if ((n4 & 0x40000000) == 0) break;
                return null;
            }
        }
        this.display.lastKey = 0;
        this.display.lastAscii = 0;
        this.display.lastDead = false;
        this.display.lastNull = false;
        this.display.lastVirtual = false;
        n5 = 0;
        if (OS.IsWinCE) {
            switch (n3) {
                case 8: {
                    n5 = 8;
                    break;
                }
                case 13: {
                    n5 = 13;
                    break;
                }
                case 46: {
                    n5 = 127;
                    break;
                }
                case 27: {
                    n5 = 27;
                    break;
                }
                case 9: {
                    n5 = 9;
                }
            }
        } else {
            n5 = OS.MapVirtualKey(n3, 2);
        }
        boolean bl2 = this.display.lastVirtual = n5 == 0 || this.display.numpadKey(n3) != 0;
        if (this.display.lastVirtual) {
            this.display.lastKey = n3;
            if (this.display.lastKey == 46) {
                this.display.lastAscii = 127;
            }
            if (96 <= this.display.lastKey && this.display.lastKey <= 111) {
                switch (this.display.lastKey) {
                    case 106: 
                    case 107: 
                    case 109: 
                    case 110: 
                    case 111: {
                        return null;
                    }
                }
                this.display.lastAscii = this.display.numpadKey(this.display.lastKey);
            }
        } else {
            this.display.lastKey = OS.CharLower((short)n5);
            if (OS.IsWinNT) {
                return null;
            }
            if (n3 != 13) {
                return null;
            }
            this.display.lastAscii = 13;
        }
        if (!this.sendKeyEvent(1, 260, n3, n4)) {
            return LRESULT.ONE;
        }
        return null;
    }

    LRESULT wmSysKeyUp(int n2, int n3, int n4) {
        return this.wmKeyUp(n2, n3, n4);
    }

    LRESULT wmXButtonDblClk(int n2, int n3, int n4) {
        LRESULT lRESULT = null;
        Display display = this.display;
        display.captureChanged = false;
        int n5 = n3 >> 16 == 1 ? 4 : 5;
        this.sendMouseEvent(3, n5, n2, 523, n3, n4);
        lRESULT = this.sendMouseEvent(8, n5, n2, 525, n3, n4) ? new LRESULT(this.callWindowProc(n2, 525, n3, n4)) : LRESULT.ZERO;
        if (!display.captureChanged && !this.isDisposed() && OS.GetCapture() != n2) {
            OS.SetCapture(n2);
        }
        return lRESULT;
    }

    LRESULT wmXButtonDown(int n2, int n3, int n4) {
        LRESULT lRESULT = null;
        Display display = this.display;
        display.captureChanged = false;
        display.xMouse = true;
        int n5 = n3 >> 16 == 1 ? 4 : 5;
        lRESULT = this.sendMouseEvent(3, n5, n2, 523, n3, n4) ? new LRESULT(this.callWindowProc(n2, 523, n3, n4)) : LRESULT.ZERO;
        if (!display.captureChanged && !this.isDisposed() && OS.GetCapture() != n2) {
            OS.SetCapture(n2);
        }
        return lRESULT;
    }

    LRESULT wmXButtonUp(int n2, int n3, int n4) {
        Display display = this.display;
        LRESULT lRESULT = null;
        int n5 = n3 >> 16 == 1 ? 4 : 5;
        lRESULT = this.sendMouseEvent(4, n5, n2, 524, n3, n4) ? new LRESULT(this.callWindowProc(n2, 524, n3, n4)) : LRESULT.ZERO;
        int n6 = 19;
        if (display.xMouse) {
            n6 |= 0x60;
        }
        if ((n3 & 0xFFFF & n6) == 0 && OS.GetCapture() == n2) {
            OS.ReleaseCapture();
        }
        return lRESULT;
    }
}

