/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.opengl;

import java.nio.ByteBuffer;
import java.nio.FloatBuffer;
import java.nio.IntBuffer;
import org.lwjgl.BufferChecks;
import org.lwjgl.NondirectBufferWrapper;
import org.lwjgl.opengl.ContextCapabilities;
import org.lwjgl.opengl.GLContext;

public final class ARBShaderObjects {
    public static final int GL_PROGRAM_OBJECT_ARB = 35648;
    public static final int GL_OBJECT_TYPE_ARB = 35662;
    public static final int GL_OBJECT_SUBTYPE_ARB = 35663;
    public static final int GL_OBJECT_DELETE_STATUS_ARB = 35712;
    public static final int GL_OBJECT_COMPILE_STATUS_ARB = 35713;
    public static final int GL_OBJECT_LINK_STATUS_ARB = 35714;
    public static final int GL_OBJECT_VALIDATE_STATUS_ARB = 35715;
    public static final int GL_OBJECT_INFO_LOG_LENGTH_ARB = 35716;
    public static final int GL_OBJECT_ATTACHED_OBJECTS_ARB = 35717;
    public static final int GL_OBJECT_ACTIVE_UNIFORMS_ARB = 35718;
    public static final int GL_OBJECT_ACTIVE_UNIFORM_MAX_LENGTH_ARB = 35719;
    public static final int GL_OBJECT_SHADER_SOURCE_LENGTH_ARB = 35720;
    public static final int GL_SHADER_OBJECT_ARB = 35656;
    public static final int GL_FLOAT = 5126;
    public static final int GL_FLOAT_VEC2_ARB = 35664;
    public static final int GL_FLOAT_VEC3_ARB = 35665;
    public static final int GL_FLOAT_VEC4_ARB = 35666;
    public static final int GL_INT = 5124;
    public static final int GL_INT_VEC2_ARB = 35667;
    public static final int GL_INT_VEC3_ARB = 35668;
    public static final int GL_INT_VEC4_ARB = 35669;
    public static final int GL_BOOL_ARB = 35670;
    public static final int GL_BOOL_VEC2_ARB = 35671;
    public static final int GL_BOOL_VEC3_ARB = 35672;
    public static final int GL_BOOL_VEC4_ARB = 35673;
    public static final int GL_FLOAT_MAT2_ARB = 35674;
    public static final int GL_FLOAT_MAT3_ARB = 35675;
    public static final int GL_FLOAT_MAT4_ARB = 35676;
    public static final int GL_SAMPLER_1D_ARB = 35677;
    public static final int GL_SAMPLER_2D_ARB = 35678;
    public static final int GL_SAMPLER_3D_ARB = 35679;
    public static final int GL_SAMPLER_CUBE_ARB = 35680;
    public static final int GL_SAMPLER_1D_SHADOW_ARB = 35681;
    public static final int GL_SAMPLER_2D_SHADOW_ARB = 35682;
    public static final int GL_SAMPLER_2D_RECT_ARB = 35683;
    public static final int GL_SAMPLER_2D_RECT_SHADOW_ARB = 35684;

    private ARBShaderObjects() {
    }

    public static void glDeleteObjectARB(int n2) {
        ContextCapabilities contextCapabilities = GLContext.getCapabilities();
        long l2 = contextCapabilities.ARB_shader_objects_glDeleteObjectARB_pointer;
        BufferChecks.checkFunctionAddress(l2);
        ARBShaderObjects.nglDeleteObjectARB(n2, l2);
    }

    private static native void nglDeleteObjectARB(int var0, long var1);

    public static int glGetHandleARB(int n2) {
        ContextCapabilities contextCapabilities = GLContext.getCapabilities();
        long l2 = contextCapabilities.ARB_shader_objects_glGetHandleARB_pointer;
        BufferChecks.checkFunctionAddress(l2);
        int n3 = ARBShaderObjects.nglGetHandleARB(n2, l2);
        return n3;
    }

    private static native int nglGetHandleARB(int var0, long var1);

    public static void glDetachObjectARB(int n2, int n3) {
        ContextCapabilities contextCapabilities = GLContext.getCapabilities();
        long l2 = contextCapabilities.ARB_shader_objects_glDetachObjectARB_pointer;
        BufferChecks.checkFunctionAddress(l2);
        ARBShaderObjects.nglDetachObjectARB(n2, n3, l2);
    }

    private static native void nglDetachObjectARB(int var0, int var1, long var2);

    public static int glCreateShaderObjectARB(int n2) {
        ContextCapabilities contextCapabilities = GLContext.getCapabilities();
        long l2 = contextCapabilities.ARB_shader_objects_glCreateShaderObjectARB_pointer;
        BufferChecks.checkFunctionAddress(l2);
        int n3 = ARBShaderObjects.nglCreateShaderObjectARB(n2, l2);
        return n3;
    }

    private static native int nglCreateShaderObjectARB(int var0, long var1);

    public static void glShaderSourceARB(int n2, ByteBuffer byteBuffer) {
        ContextCapabilities contextCapabilities = GLContext.getCapabilities();
        long l2 = contextCapabilities.ARB_shader_objects_glShaderSourceARB_pointer;
        BufferChecks.checkFunctionAddress(l2);
        byteBuffer = NondirectBufferWrapper.wrapDirect(byteBuffer);
        ARBShaderObjects.nglShaderSourceARB(n2, 1, byteBuffer, byteBuffer.position(), byteBuffer.remaining(), l2);
    }

    private static native void nglShaderSourceARB(int var0, int var1, ByteBuffer var2, int var3, int var4, long var5);

    public static void glCompileShaderARB(int n2) {
        ContextCapabilities contextCapabilities = GLContext.getCapabilities();
        long l2 = contextCapabilities.ARB_shader_objects_glCompileShaderARB_pointer;
        BufferChecks.checkFunctionAddress(l2);
        ARBShaderObjects.nglCompileShaderARB(n2, l2);
    }

    private static native void nglCompileShaderARB(int var0, long var1);

    public static int glCreateProgramObjectARB() {
        ContextCapabilities contextCapabilities = GLContext.getCapabilities();
        long l2 = contextCapabilities.ARB_shader_objects_glCreateProgramObjectARB_pointer;
        BufferChecks.checkFunctionAddress(l2);
        int n2 = ARBShaderObjects.nglCreateProgramObjectARB(l2);
        return n2;
    }

    private static native int nglCreateProgramObjectARB(long var0);

    public static void glAttachObjectARB(int n2, int n3) {
        ContextCapabilities contextCapabilities = GLContext.getCapabilities();
        long l2 = contextCapabilities.ARB_shader_objects_glAttachObjectARB_pointer;
        BufferChecks.checkFunctionAddress(l2);
        ARBShaderObjects.nglAttachObjectARB(n2, n3, l2);
    }

    private static native void nglAttachObjectARB(int var0, int var1, long var2);

    public static void glLinkProgramARB(int n2) {
        ContextCapabilities contextCapabilities = GLContext.getCapabilities();
        long l2 = contextCapabilities.ARB_shader_objects_glLinkProgramARB_pointer;
        BufferChecks.checkFunctionAddress(l2);
        ARBShaderObjects.nglLinkProgramARB(n2, l2);
    }

    private static native void nglLinkProgramARB(int var0, long var1);

    public static void glUseProgramObjectARB(int n2) {
        ContextCapabilities contextCapabilities = GLContext.getCapabilities();
        long l2 = contextCapabilities.ARB_shader_objects_glUseProgramObjectARB_pointer;
        BufferChecks.checkFunctionAddress(l2);
        ARBShaderObjects.nglUseProgramObjectARB(n2, l2);
    }

    private static native void nglUseProgramObjectARB(int var0, long var1);

    public static void glValidateProgramARB(int n2) {
        ContextCapabilities contextCapabilities = GLContext.getCapabilities();
        long l2 = contextCapabilities.ARB_shader_objects_glValidateProgramARB_pointer;
        BufferChecks.checkFunctionAddress(l2);
        ARBShaderObjects.nglValidateProgramARB(n2, l2);
    }

    private static native void nglValidateProgramARB(int var0, long var1);

    public static void glUniform1fARB(int n2, float f2) {
        ContextCapabilities contextCapabilities = GLContext.getCapabilities();
        long l2 = contextCapabilities.ARB_shader_objects_glUniform1fARB_pointer;
        BufferChecks.checkFunctionAddress(l2);
        ARBShaderObjects.nglUniform1fARB(n2, f2, l2);
    }

    private static native void nglUniform1fARB(int var0, float var1, long var2);

    public static void glUniform2fARB(int n2, float f2, float f3) {
        ContextCapabilities contextCapabilities = GLContext.getCapabilities();
        long l2 = contextCapabilities.ARB_shader_objects_glUniform2fARB_pointer;
        BufferChecks.checkFunctionAddress(l2);
        ARBShaderObjects.nglUniform2fARB(n2, f2, f3, l2);
    }

    private static native void nglUniform2fARB(int var0, float var1, float var2, long var3);

    public static void glUniform3fARB(int n2, float f2, float f3, float f4) {
        ContextCapabilities contextCapabilities = GLContext.getCapabilities();
        long l2 = contextCapabilities.ARB_shader_objects_glUniform3fARB_pointer;
        BufferChecks.checkFunctionAddress(l2);
        ARBShaderObjects.nglUniform3fARB(n2, f2, f3, f4, l2);
    }

    private static native void nglUniform3fARB(int var0, float var1, float var2, float var3, long var4);

    public static void glUniform4fARB(int n2, float f2, float f3, float f4, float f5) {
        ContextCapabilities contextCapabilities = GLContext.getCapabilities();
        long l2 = contextCapabilities.ARB_shader_objects_glUniform4fARB_pointer;
        BufferChecks.checkFunctionAddress(l2);
        ARBShaderObjects.nglUniform4fARB(n2, f2, f3, f4, f5, l2);
    }

    private static native void nglUniform4fARB(int var0, float var1, float var2, float var3, float var4, long var5);

    public static void glUniform1iARB(int n2, int n3) {
        ContextCapabilities contextCapabilities = GLContext.getCapabilities();
        long l2 = contextCapabilities.ARB_shader_objects_glUniform1iARB_pointer;
        BufferChecks.checkFunctionAddress(l2);
        ARBShaderObjects.nglUniform1iARB(n2, n3, l2);
    }

    private static native void nglUniform1iARB(int var0, int var1, long var2);

    public static void glUniform2iARB(int n2, int n3, int n4) {
        ContextCapabilities contextCapabilities = GLContext.getCapabilities();
        long l2 = contextCapabilities.ARB_shader_objects_glUniform2iARB_pointer;
        BufferChecks.checkFunctionAddress(l2);
        ARBShaderObjects.nglUniform2iARB(n2, n3, n4, l2);
    }

    private static native void nglUniform2iARB(int var0, int var1, int var2, long var3);

    public static void glUniform3iARB(int n2, int n3, int n4, int n5) {
        ContextCapabilities contextCapabilities = GLContext.getCapabilities();
        long l2 = contextCapabilities.ARB_shader_objects_glUniform3iARB_pointer;
        BufferChecks.checkFunctionAddress(l2);
        ARBShaderObjects.nglUniform3iARB(n2, n3, n4, n5, l2);
    }

    private static native void nglUniform3iARB(int var0, int var1, int var2, int var3, long var4);

    public static void glUniform4iARB(int n2, int n3, int n4, int n5, int n6) {
        ContextCapabilities contextCapabilities = GLContext.getCapabilities();
        long l2 = contextCapabilities.ARB_shader_objects_glUniform4iARB_pointer;
        BufferChecks.checkFunctionAddress(l2);
        ARBShaderObjects.nglUniform4iARB(n2, n3, n4, n5, n6, l2);
    }

    private static native void nglUniform4iARB(int var0, int var1, int var2, int var3, int var4, long var5);

    public static void glUniform1ARB(int n2, FloatBuffer floatBuffer) {
        ContextCapabilities contextCapabilities = GLContext.getCapabilities();
        long l2 = contextCapabilities.ARB_shader_objects_glUniform1fvARB_pointer;
        BufferChecks.checkFunctionAddress(l2);
        floatBuffer = NondirectBufferWrapper.wrapDirect(floatBuffer);
        ARBShaderObjects.nglUniform1fvARB(n2, floatBuffer.remaining(), floatBuffer, floatBuffer.position(), l2);
    }

    private static native void nglUniform1fvARB(int var0, int var1, FloatBuffer var2, int var3, long var4);

    public static void glUniform2ARB(int n2, FloatBuffer floatBuffer) {
        ContextCapabilities contextCapabilities = GLContext.getCapabilities();
        long l2 = contextCapabilities.ARB_shader_objects_glUniform2fvARB_pointer;
        BufferChecks.checkFunctionAddress(l2);
        floatBuffer = NondirectBufferWrapper.wrapDirect(floatBuffer);
        ARBShaderObjects.nglUniform2fvARB(n2, floatBuffer.remaining() >> 1, floatBuffer, floatBuffer.position(), l2);
    }

    private static native void nglUniform2fvARB(int var0, int var1, FloatBuffer var2, int var3, long var4);

    public static void glUniform3ARB(int n2, FloatBuffer floatBuffer) {
        ContextCapabilities contextCapabilities = GLContext.getCapabilities();
        long l2 = contextCapabilities.ARB_shader_objects_glUniform3fvARB_pointer;
        BufferChecks.checkFunctionAddress(l2);
        floatBuffer = NondirectBufferWrapper.wrapDirect(floatBuffer);
        ARBShaderObjects.nglUniform3fvARB(n2, floatBuffer.remaining() / 3, floatBuffer, floatBuffer.position(), l2);
    }

    private static native void nglUniform3fvARB(int var0, int var1, FloatBuffer var2, int var3, long var4);

    public static void glUniform4ARB(int n2, FloatBuffer floatBuffer) {
        ContextCapabilities contextCapabilities = GLContext.getCapabilities();
        long l2 = contextCapabilities.ARB_shader_objects_glUniform4fvARB_pointer;
        BufferChecks.checkFunctionAddress(l2);
        floatBuffer = NondirectBufferWrapper.wrapDirect(floatBuffer);
        ARBShaderObjects.nglUniform4fvARB(n2, floatBuffer.remaining() >> 2, floatBuffer, floatBuffer.position(), l2);
    }

    private static native void nglUniform4fvARB(int var0, int var1, FloatBuffer var2, int var3, long var4);

    public static void glUniform1ARB(int n2, IntBuffer intBuffer) {
        ContextCapabilities contextCapabilities = GLContext.getCapabilities();
        long l2 = contextCapabilities.ARB_shader_objects_glUniform1ivARB_pointer;
        BufferChecks.checkFunctionAddress(l2);
        intBuffer = NondirectBufferWrapper.wrapDirect(intBuffer);
        ARBShaderObjects.nglUniform1ivARB(n2, intBuffer.remaining(), intBuffer, intBuffer.position(), l2);
    }

    private static native void nglUniform1ivARB(int var0, int var1, IntBuffer var2, int var3, long var4);

    public static void glUniform2ARB(int n2, IntBuffer intBuffer) {
        ContextCapabilities contextCapabilities = GLContext.getCapabilities();
        long l2 = contextCapabilities.ARB_shader_objects_glUniform2ivARB_pointer;
        BufferChecks.checkFunctionAddress(l2);
        intBuffer = NondirectBufferWrapper.wrapDirect(intBuffer);
        ARBShaderObjects.nglUniform2ivARB(n2, intBuffer.remaining() >> 1, intBuffer, intBuffer.position(), l2);
    }

    private static native void nglUniform2ivARB(int var0, int var1, IntBuffer var2, int var3, long var4);

    public static void glUniform3ARB(int n2, IntBuffer intBuffer) {
        ContextCapabilities contextCapabilities = GLContext.getCapabilities();
        long l2 = contextCapabilities.ARB_shader_objects_glUniform3ivARB_pointer;
        BufferChecks.checkFunctionAddress(l2);
        intBuffer = NondirectBufferWrapper.wrapDirect(intBuffer);
        ARBShaderObjects.nglUniform3ivARB(n2, intBuffer.remaining() / 3, intBuffer, intBuffer.position(), l2);
    }

    private static native void nglUniform3ivARB(int var0, int var1, IntBuffer var2, int var3, long var4);

    public static void glUniform4ARB(int n2, IntBuffer intBuffer) {
        ContextCapabilities contextCapabilities = GLContext.getCapabilities();
        long l2 = contextCapabilities.ARB_shader_objects_glUniform4ivARB_pointer;
        BufferChecks.checkFunctionAddress(l2);
        intBuffer = NondirectBufferWrapper.wrapDirect(intBuffer);
        ARBShaderObjects.nglUniform4ivARB(n2, intBuffer.remaining() >> 2, intBuffer, intBuffer.position(), l2);
    }

    private static native void nglUniform4ivARB(int var0, int var1, IntBuffer var2, int var3, long var4);

    public static void glUniformMatrix2ARB(int n2, boolean bl2, FloatBuffer floatBuffer) {
        ContextCapabilities contextCapabilities = GLContext.getCapabilities();
        long l2 = contextCapabilities.ARB_shader_objects_glUniformMatrix2fvARB_pointer;
        BufferChecks.checkFunctionAddress(l2);
        floatBuffer = NondirectBufferWrapper.wrapDirect(floatBuffer);
        ARBShaderObjects.nglUniformMatrix2fvARB(n2, floatBuffer.remaining() >> 2, bl2, floatBuffer, floatBuffer.position(), l2);
    }

    private static native void nglUniformMatrix2fvARB(int var0, int var1, boolean var2, FloatBuffer var3, int var4, long var5);

    public static void glUniformMatrix3ARB(int n2, boolean bl2, FloatBuffer floatBuffer) {
        ContextCapabilities contextCapabilities = GLContext.getCapabilities();
        long l2 = contextCapabilities.ARB_shader_objects_glUniformMatrix3fvARB_pointer;
        BufferChecks.checkFunctionAddress(l2);
        floatBuffer = NondirectBufferWrapper.wrapDirect(floatBuffer);
        ARBShaderObjects.nglUniformMatrix3fvARB(n2, floatBuffer.remaining() / 9, bl2, floatBuffer, floatBuffer.position(), l2);
    }

    private static native void nglUniformMatrix3fvARB(int var0, int var1, boolean var2, FloatBuffer var3, int var4, long var5);

    public static void glUniformMatrix4ARB(int n2, boolean bl2, FloatBuffer floatBuffer) {
        ContextCapabilities contextCapabilities = GLContext.getCapabilities();
        long l2 = contextCapabilities.ARB_shader_objects_glUniformMatrix4fvARB_pointer;
        BufferChecks.checkFunctionAddress(l2);
        floatBuffer = NondirectBufferWrapper.wrapDirect(floatBuffer);
        ARBShaderObjects.nglUniformMatrix4fvARB(n2, floatBuffer.remaining() >> 4, bl2, floatBuffer, floatBuffer.position(), l2);
    }

    private static native void nglUniformMatrix4fvARB(int var0, int var1, boolean var2, FloatBuffer var3, int var4, long var5);

    public static void glGetObjectParameterARB(int n2, int n3, FloatBuffer floatBuffer) {
        ContextCapabilities contextCapabilities = GLContext.getCapabilities();
        long l2 = contextCapabilities.ARB_shader_objects_glGetObjectParameterfvARB_pointer;
        BufferChecks.checkFunctionAddress(l2);
        FloatBuffer floatBuffer2 = floatBuffer;
        floatBuffer = NondirectBufferWrapper.wrapNoCopyDirect(floatBuffer);
        ARBShaderObjects.nglGetObjectParameterfvARB(n2, n3, floatBuffer, floatBuffer.position(), l2);
        NondirectBufferWrapper.copy(floatBuffer, floatBuffer2);
    }

    private static native void nglGetObjectParameterfvARB(int var0, int var1, FloatBuffer var2, int var3, long var4);

    public static void glGetObjectParameterARB(int n2, int n3, IntBuffer intBuffer) {
        ContextCapabilities contextCapabilities = GLContext.getCapabilities();
        long l2 = contextCapabilities.ARB_shader_objects_glGetObjectParameterivARB_pointer;
        BufferChecks.checkFunctionAddress(l2);
        IntBuffer intBuffer2 = intBuffer;
        intBuffer = NondirectBufferWrapper.wrapNoCopyDirect(intBuffer);
        ARBShaderObjects.nglGetObjectParameterivARB(n2, n3, intBuffer, intBuffer.position(), l2);
        NondirectBufferWrapper.copy(intBuffer, intBuffer2);
    }

    private static native void nglGetObjectParameterivARB(int var0, int var1, IntBuffer var2, int var3, long var4);

    public static void glGetInfoLogARB(int n2, IntBuffer intBuffer, ByteBuffer byteBuffer) {
        ContextCapabilities contextCapabilities = GLContext.getCapabilities();
        long l2 = contextCapabilities.ARB_shader_objects_glGetInfoLogARB_pointer;
        BufferChecks.checkFunctionAddress(l2);
        IntBuffer intBuffer2 = intBuffer;
        if (intBuffer != null) {
            intBuffer = NondirectBufferWrapper.wrapNoCopyBuffer(intBuffer, 1);
        }
        byteBuffer = NondirectBufferWrapper.wrapDirect(byteBuffer);
        ARBShaderObjects.nglGetInfoLogARB(n2, byteBuffer.remaining(), intBuffer, intBuffer != null ? intBuffer.position() : 0, byteBuffer, byteBuffer.position(), l2);
        NondirectBufferWrapper.copy(intBuffer, intBuffer2);
    }

    private static native void nglGetInfoLogARB(int var0, int var1, IntBuffer var2, int var3, ByteBuffer var4, int var5, long var6);

    public static void glGetAttachedObjectsARB(int n2, IntBuffer intBuffer, IntBuffer intBuffer2) {
        ContextCapabilities contextCapabilities = GLContext.getCapabilities();
        long l2 = contextCapabilities.ARB_shader_objects_glGetAttachedObjectsARB_pointer;
        BufferChecks.checkFunctionAddress(l2);
        IntBuffer intBuffer3 = intBuffer;
        if (intBuffer != null) {
            intBuffer = NondirectBufferWrapper.wrapNoCopyBuffer(intBuffer, 1);
        }
        intBuffer2 = NondirectBufferWrapper.wrapDirect(intBuffer2);
        ARBShaderObjects.nglGetAttachedObjectsARB(n2, intBuffer2.remaining(), intBuffer, intBuffer != null ? intBuffer.position() : 0, intBuffer2, intBuffer2.position(), l2);
        NondirectBufferWrapper.copy(intBuffer, intBuffer3);
    }

    private static native void nglGetAttachedObjectsARB(int var0, int var1, IntBuffer var2, int var3, IntBuffer var4, int var5, long var6);

    public static int glGetUniformLocationARB(int n2, ByteBuffer byteBuffer) {
        ContextCapabilities contextCapabilities = GLContext.getCapabilities();
        long l2 = contextCapabilities.ARB_shader_objects_glGetUniformLocationARB_pointer;
        BufferChecks.checkFunctionAddress(l2);
        byteBuffer = NondirectBufferWrapper.wrapDirect(byteBuffer);
        BufferChecks.checkNullTerminated(byteBuffer);
        int n3 = ARBShaderObjects.nglGetUniformLocationARB(n2, byteBuffer, byteBuffer.position(), l2);
        return n3;
    }

    private static native int nglGetUniformLocationARB(int var0, ByteBuffer var1, int var2, long var3);

    public static void glGetActiveUniformARB(int n2, int n3, IntBuffer intBuffer, IntBuffer intBuffer2, IntBuffer intBuffer3, ByteBuffer byteBuffer) {
        ContextCapabilities contextCapabilities = GLContext.getCapabilities();
        long l2 = contextCapabilities.ARB_shader_objects_glGetActiveUniformARB_pointer;
        BufferChecks.checkFunctionAddress(l2);
        IntBuffer intBuffer4 = intBuffer;
        if (intBuffer != null) {
            intBuffer = NondirectBufferWrapper.wrapNoCopyBuffer(intBuffer, 1);
        }
        intBuffer2 = NondirectBufferWrapper.wrapBuffer(intBuffer2, 1);
        intBuffer3 = NondirectBufferWrapper.wrapBuffer(intBuffer3, 1);
        byteBuffer = NondirectBufferWrapper.wrapDirect(byteBuffer);
        ARBShaderObjects.nglGetActiveUniformARB(n2, n3, byteBuffer.remaining(), intBuffer, intBuffer != null ? intBuffer.position() : 0, intBuffer2, intBuffer2.position(), intBuffer3, intBuffer3.position(), byteBuffer, byteBuffer.position(), l2);
        NondirectBufferWrapper.copy(intBuffer, intBuffer4);
    }

    private static native void nglGetActiveUniformARB(int var0, int var1, int var2, IntBuffer var3, int var4, IntBuffer var5, int var6, IntBuffer var7, int var8, ByteBuffer var9, int var10, long var11);

    public static void glGetUniformARB(int n2, int n3, FloatBuffer floatBuffer) {
        ContextCapabilities contextCapabilities = GLContext.getCapabilities();
        long l2 = contextCapabilities.ARB_shader_objects_glGetUniformfvARB_pointer;
        BufferChecks.checkFunctionAddress(l2);
        FloatBuffer floatBuffer2 = floatBuffer;
        floatBuffer = NondirectBufferWrapper.wrapNoCopyDirect(floatBuffer);
        ARBShaderObjects.nglGetUniformfvARB(n2, n3, floatBuffer, floatBuffer.position(), l2);
        NondirectBufferWrapper.copy(floatBuffer, floatBuffer2);
    }

    private static native void nglGetUniformfvARB(int var0, int var1, FloatBuffer var2, int var3, long var4);

    public static void glGetUniformARB(int n2, int n3, IntBuffer intBuffer) {
        ContextCapabilities contextCapabilities = GLContext.getCapabilities();
        long l2 = contextCapabilities.ARB_shader_objects_glGetUniformivARB_pointer;
        BufferChecks.checkFunctionAddress(l2);
        IntBuffer intBuffer2 = intBuffer;
        intBuffer = NondirectBufferWrapper.wrapNoCopyDirect(intBuffer);
        ARBShaderObjects.nglGetUniformivARB(n2, n3, intBuffer, intBuffer.position(), l2);
        NondirectBufferWrapper.copy(intBuffer, intBuffer2);
    }

    private static native void nglGetUniformivARB(int var0, int var1, IntBuffer var2, int var3, long var4);

    public static void glGetShaderSourceARB(int n2, IntBuffer intBuffer, ByteBuffer byteBuffer) {
        ContextCapabilities contextCapabilities = GLContext.getCapabilities();
        long l2 = contextCapabilities.ARB_shader_objects_glGetShaderSourceARB_pointer;
        BufferChecks.checkFunctionAddress(l2);
        IntBuffer intBuffer2 = intBuffer;
        if (intBuffer != null) {
            intBuffer = NondirectBufferWrapper.wrapNoCopyBuffer(intBuffer, 1);
        }
        byteBuffer = NondirectBufferWrapper.wrapDirect(byteBuffer);
        ARBShaderObjects.nglGetShaderSourceARB(n2, byteBuffer.remaining(), intBuffer, intBuffer != null ? intBuffer.position() : 0, byteBuffer, byteBuffer.position(), l2);
        NondirectBufferWrapper.copy(intBuffer, intBuffer2);
    }

    private static native void nglGetShaderSourceARB(int var0, int var1, IntBuffer var2, int var3, ByteBuffer var4, int var5, long var6);
}

