/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.opengl;

import java.nio.ByteBuffer;
import java.nio.FloatBuffer;
import java.nio.IntBuffer;
import java.security.AccessController;
import java.util.ArrayList;
import org.lwjgl.BufferUtils;
import org.lwjgl.LWJGLException;
import org.lwjgl.LWJGLUtil;
import org.lwjgl.opengl.Display;
import org.lwjgl.opengl.DisplayMode;
import org.lwjgl.opengl.GL11;
import org.lwjgl.opengl.MacOSXContextImplementation;
import org.lwjgl.opengl.MacOSXPbufferPeerInfo;
import org.lwjgl.opengl.PixelFormat;
import org.lwjgl.opengl.d;
import org.lwjgl.opengl.j;
import org.lwjgl.opengl.m;
import org.lwjgl.opengl.o;
import org.lwjgl.opengl.p;
import org.lwjgl.opengl.y;

final class MacOSXDisplay
implements y {
    private static final int GAMMA_LENGTH = 256;
    private d frame;
    private java.awt.DisplayMode requested_mode;
    private boolean close_requested;
    private static final IntBuffer current_viewport = BufferUtils.createIntBuffer(16);

    MacOSXDisplay() {
        new j(this);
    }

    public final void createWindow(DisplayMode displayMode, boolean bl2, int n2, int n3) throws LWJGLException {
        this.hideUI(bl2);
        this.close_requested = false;
        try {
            this.frame = new d(displayMode, this.requested_mode, bl2, n2, n3);
            return;
        }
        catch (LWJGLException lWJGLException) {
            this.destroyWindow();
            throw lWJGLException;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void handleQuit() {
        MacOSXDisplay macOSXDisplay = this;
        synchronized (macOSXDisplay) {
            this.close_requested = true;
            return;
        }
    }

    public final void destroyWindow() {
        if (this.frame != null) {
            AccessController.doPrivileged(new o(this));
            if (this.frame.isDisplayable()) {
                this.frame.dispose();
            }
            this.frame = null;
        }
        this.hideUI(false);
    }

    public final int getGammaRampLength() {
        return 256;
    }

    public final native void setGammaRamp(FloatBuffer var1) throws LWJGLException;

    public final String getAdapter() {
        return null;
    }

    public final String getVersion() {
        return null;
    }

    private boolean equals(java.awt.DisplayMode displayMode, DisplayMode displayMode2) {
        return displayMode.getWidth() == displayMode2.getWidth() && displayMode.getHeight() == displayMode2.getHeight() && displayMode.getBitDepth() == displayMode2.getBitsPerPixel() && displayMode.getRefreshRate() == displayMode2.getFrequency();
    }

    public final void switchDisplayMode(DisplayMode displayMode) throws LWJGLException {
        java.awt.DisplayMode[] displayModeArray = d.a().getDisplayModes();
        for (int i2 = 0; i2 < displayModeArray.length; ++i2) {
            if (!this.equals(displayModeArray[i2], displayMode)) continue;
            this.requested_mode = displayModeArray[i2];
            return;
        }
        throw new LWJGLException(displayMode + " is not supported");
    }

    public final void resetDisplayMode() {
        if (d.a().getFullScreenWindow() != null) {
            d.a().setFullScreenWindow(null);
        }
        this.requested_mode = null;
        this.restoreGamma();
    }

    private native void restoreGamma();

    private DisplayMode createLWJGLDisplayMode(java.awt.DisplayMode displayMode) {
        int n2 = displayMode.getBitDepth();
        int n3 = displayMode.getRefreshRate();
        int n4 = n2 != -1 ? n2 : 32;
        int n5 = n3 != 0 ? n3 : 0;
        return new DisplayMode(displayMode.getWidth(), displayMode.getHeight(), n4, n5);
    }

    public final DisplayMode init() throws LWJGLException {
        return this.createLWJGLDisplayMode(d.a().getDisplayMode());
    }

    public final DisplayMode[] getAvailableDisplayModes() throws LWJGLException {
        java.awt.DisplayMode[] displayModeArray = d.a().getDisplayModes();
        ArrayList<DisplayMode> arrayList = new ArrayList<DisplayMode>();
        for (int i2 = 0; i2 < displayModeArray.length; ++i2) {
            if (displayModeArray[i2].getBitDepth() < 16) continue;
            arrayList.add(this.createLWJGLDisplayMode(displayModeArray[i2]));
        }
        DisplayMode[] displayModeArray2 = new DisplayMode[arrayList.size()];
        arrayList.toArray(displayModeArray2);
        return displayModeArray2;
    }

    public final void setTitle(String string) {
        this.frame.setTitle(string);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final boolean isCloseRequested() {
        boolean bl2;
        MacOSXDisplay macOSXDisplay = this;
        synchronized (macOSXDisplay) {
            bl2 = this.close_requested || this.frame != null && this.frame.a();
            this.close_requested = false;
        }
        return bl2;
    }

    public final boolean isVisible() {
        return this.frame.b();
    }

    public final boolean isActive() {
        return this.frame.c();
    }

    public final d getFrame() {
        return this.frame;
    }

    public final boolean isDirty() {
        return this.frame.a().b();
    }

    public final m createPeerInfo(PixelFormat pixelFormat) throws LWJGLException {
        try {
            return new p(pixelFormat, true);
        }
        catch (LWJGLException lWJGLException) {
            return new p(pixelFormat, false);
        }
    }

    public final void update() {
        boolean bl2 = this.frame.a().c();
        if (Display.isFullscreen() && (this.frame.a().a() || bl2)) {
            try {
                MacOSXContextImplementation.resetView(Display.getDrawable().getContext().a(), Display.getDrawable().getContext());
            }
            catch (LWJGLException lWJGLException) {
                LWJGLUtil.log("Failed to reset context: " + lWJGLException);
            }
        }
        if (bl2) {
            Display.getDrawable().getContext().c();
            GL11.glGetInteger(2978, current_viewport);
            GL11.glViewport(current_viewport.get(0), current_viewport.get(1), current_viewport.get(2), current_viewport.get(3));
        }
    }

    private void hideUI(boolean bl2) {
        this.nHideUI(bl2);
    }

    private native void nHideUI(boolean var1);

    public final void reshape(int n2, int n3, int n4, int n5) {
        this.frame.a(n2, n3, n4, n5);
    }

    public final void createMouse() throws LWJGLException {
    }

    public final void destroyMouse() {
    }

    public final void pollMouse(IntBuffer intBuffer, ByteBuffer byteBuffer) {
    }

    public final void readMouse(ByteBuffer byteBuffer) {
    }

    public final void grabMouse(boolean bl2) {
    }

    public final void createKeyboard() throws LWJGLException {
    }

    public final void destroyKeyboard() {
    }

    public final void pollKeyboard(ByteBuffer byteBuffer) {
    }

    public final void readKeyboard(ByteBuffer byteBuffer) {
    }

    public final void destroyCursor(Object object) {
    }

    public final int getPbufferCapabilities() {
        return 1;
    }

    public final boolean isBufferLost(m m2) {
        return false;
    }

    public final m createPbuffer(int n2, int n3, PixelFormat pixelFormat, IntBuffer intBuffer, IntBuffer intBuffer2) throws LWJGLException {
        return new MacOSXPbufferPeerInfo(n2, n3, pixelFormat);
    }

    public final void setPbufferAttrib(m m2, int n2, int n3) {
        throw new UnsupportedOperationException();
    }

    public final void bindTexImageToPbuffer(m m2, int n2) {
        throw new UnsupportedOperationException();
    }

    public final void releaseTexImageFromPbuffer(m m2, int n2) {
        throw new UnsupportedOperationException();
    }

    public final int setIcon(ByteBuffer[] byteBufferArray) {
        return 0;
    }

    public final int getWidth() {
        return Display.getDisplayMode().getWidth();
    }

    public final int getHeight() {
        return Display.getDisplayMode().getHeight();
    }

    public final Object createCursor(int n2, int n3, int n4, int n5, int n6, IntBuffer intBuffer, IntBuffer intBuffer2) throws LWJGLException {
        return null;
    }

    public final int getButtonCount() {
        return 0;
    }

    public final int getMaxCursorSize() {
        return 0;
    }

    public final int getMinCursorSize() {
        return 0;
    }

    public final int getNativeCursorCapabilities() {
        return 0;
    }

    public final boolean hasWheel() {
        return false;
    }

    public final void setCursorPosition(int n2, int n3) {
    }

    public final void setNativeCursor(Object object) throws LWJGLException {
    }

    static d access$000(MacOSXDisplay macOSXDisplay) {
        return macOSXDisplay.frame;
    }

    static void access$100(MacOSXDisplay macOSXDisplay) {
        macOSXDisplay.handleQuit();
    }
}

