/*
 * Decompiled with CFR 0.152.
 */
package com.sun.corba.se.internal.io;

import com.sun.corba.se.internal.io.ObjectStreamClass;
import com.sun.corba.se.internal.io.ObjectStreamClassCorbaExt;
import com.sun.corba.se.internal.io.ObjectStreamField;
import com.sun.corba.se.internal.io.OutputStreamHook;
import com.sun.corba.se.internal.util.RepositoryId;
import com.sun.corba.se.internal.util.Utility;
import java.io.Externalizable;
import java.io.IOException;
import java.io.InvalidClassException;
import java.io.NotActiveException;
import java.io.NotSerializableException;
import java.io.Serializable;
import java.lang.reflect.InvocationTargetException;
import java.rmi.Remote;
import java.util.Stack;
import javax.rmi.CORBA.Util;
import org.omg.CORBA.Object;
import org.omg.CORBA_2_3.portable.OutputStream;

public class IIOPOutputStream
extends OutputStreamHook {
    private static final byte kFormatVersionOne = 1;
    private OutputStream orbStream;
    private java.lang.Object currentObject = null;
    private ObjectStreamClass currentClassDesc = null;
    private int recursionDepth = 0;
    private int simpleWriteDepth = 0;
    private IOException abortIOException = null;
    private Stack classDescStack = new Stack();
    private java.lang.Object[] writeObjectArglist = new java.lang.Object[]{this};
    boolean UDOWI_Pending = false;
    boolean UDOW = true;

    public final int decreaseRecursionDepth() {
        return --this.recursionDepth;
    }

    public final void close() throws IOException {
    }

    public final void defaultWriteObjectDelegate() {
        this.UDOW = true;
        try {
            if (this.currentObject == null || this.currentClassDesc == null) {
                throw new NotActiveException("defaultWriteObjectDelegate");
            }
            ObjectStreamField[] objectStreamFieldArray = this.currentClassDesc.getFieldsNoCopy();
            if (objectStreamFieldArray.length > 0) {
                this.outputClassFields(this.currentObject, this.currentClassDesc.forClass(), objectStreamFieldArray);
            }
        }
        catch (IOException iOException) {
            IIOPOutputStream.throwExceptionType(IOException.class, iOException.getMessage());
        }
    }

    protected final void drain() throws IOException {
    }

    public final void flush() throws IOException {
        try {
            this.orbStream.flush();
        }
        catch (Error error) {
            throw new IOException(error.getMessage());
        }
    }

    public final void increaseRecursionDepth() {
        ++this.recursionDepth;
    }

    public final void reset() throws IOException {
        try {
            if (this.currentObject != null || this.currentClassDesc != null) {
                throw new IOException("Illegal call to reset");
            }
            this.abortIOException = null;
            if (this.classDescStack == null) {
                this.classDescStack = new Stack();
            } else {
                this.classDescStack.setSize(0);
            }
        }
        catch (Error error) {
            throw new IOException(error.getMessage());
        }
    }

    protected final void writeStreamHeader() throws IOException {
    }

    private void writeUDOWI() throws IOException {
        if (this.UDOWI_Pending) {
            this.UDOWI_Pending = false;
            try {
                this.writeBoolean(this.UDOW);
            }
            catch (Error error) {
                throw new IOException(error.getMessage());
            }
        }
    }

    public final void writeDouble(double d2) throws IOException {
        this.writeUDOWI();
        try {
            this.orbStream.write_double(d2);
        }
        catch (Error error) {
            throw new IOException(error.getMessage());
        }
    }

    public final void writeFloat(float f2) throws IOException {
        this.writeUDOWI();
        try {
            this.orbStream.write_float(f2);
        }
        catch (Error error) {
            throw new IOException(error.getMessage());
        }
    }

    public final void write(int n2) throws IOException {
        this.writeUDOWI();
        try {
            this.orbStream.write_octet((byte)(n2 & 0xFF));
        }
        catch (Error error) {
            throw new IOException(error.getMessage());
        }
    }

    public final void writeByte(int n2) throws IOException {
        this.writeUDOWI();
        try {
            this.orbStream.write_octet((byte)n2);
        }
        catch (Error error) {
            throw new IOException(error.getMessage());
        }
    }

    public final void writeChar(int n2) throws IOException {
        this.writeUDOWI();
        try {
            this.orbStream.write_wchar((char)n2);
        }
        catch (Error error) {
            throw new IOException(error.getMessage());
        }
    }

    public final void writeInt(int n2) throws IOException {
        this.writeUDOWI();
        try {
            this.orbStream.write_long(n2);
        }
        catch (Error error) {
            throw new IOException(error.getMessage());
        }
    }

    public final void writeShort(int n2) throws IOException {
        this.writeUDOWI();
        try {
            this.orbStream.write_short((short)n2);
        }
        catch (Error error) {
            throw new IOException(error.getMessage());
        }
    }

    public final void writeLong(long l2) throws IOException {
        this.writeUDOWI();
        try {
            this.orbStream.write_longlong(l2);
        }
        catch (Error error) {
            throw new IOException(error.getMessage());
        }
    }

    public final void writeBoolean(boolean bl2) throws IOException {
        this.writeUDOWI();
        try {
            this.orbStream.write_boolean(bl2);
        }
        catch (Error error) {
            throw new IOException(error.getMessage());
        }
    }

    public final boolean enableReplaceObjectDelegate(boolean bl2) {
        return false;
    }

    public final void write(byte[] byArray) throws IOException {
        this.writeUDOWI();
        try {
            this.orbStream.write_octet_array(byArray, 0, byArray.length);
        }
        catch (Error error) {
            throw new IOException(error.getMessage());
        }
    }

    public final void write(byte[] byArray, int n2, int n3) throws IOException {
        this.writeUDOWI();
        try {
            this.orbStream.write_octet_array(byArray, n2, n3);
        }
        catch (Error error) {
            throw new IOException(error.getMessage());
        }
    }

    ObjectStreamField[] getFieldsNoCopy() {
        return this.currentClassDesc.getFieldsNoCopy();
    }

    protected final void annotateClass(Class clazz) throws IOException {
        throw new IOException("Method annotateClass not supported");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void outputObject(java.lang.Object object) throws IOException {
        this.currentObject = object;
        Class clazz = object.getClass();
        this.currentClassDesc = ObjectStreamClass.lookup(clazz);
        if (this.currentClassDesc == null) {
            throw new NotSerializableException(clazz.getName());
        }
        if (this.currentClassDesc.isExternalizable()) {
            this.writeByte(1);
            Externalizable externalizable = (Externalizable)object;
            externalizable.writeExternal(this);
        } else {
            int n2 = this.classDescStack.size();
            try {
                ObjectStreamClass objectStreamClass;
                while ((objectStreamClass = this.currentClassDesc.getSuperclass()) != null) {
                    this.classDescStack.push(this.currentClassDesc);
                    this.currentClassDesc = objectStreamClass;
                }
                do {
                    if (this.currentClassDesc.hasWriteObject()) {
                        this.invokeObjectWriter(object, this.currentClassDesc.forClass());
                        continue;
                    }
                    this.defaultWriteObjectDelegate();
                } while (this.classDescStack.size() > n2 && (this.currentClassDesc = (ObjectStreamClass)this.classDescStack.pop()) != null);
            }
            finally {
                this.classDescStack.setSize(n2);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void simpleWriteObject(java.lang.Object object) {
        java.lang.Object object2 = this.currentObject;
        ObjectStreamClass objectStreamClass = this.currentClassDesc;
        ++this.simpleWriteDepth;
        try {
            try {
                this.outputObject(object);
            }
            catch (IOException iOException) {
                if (this.abortIOException == null) {
                    this.abortIOException = iOException;
                }
                java.lang.Object var6_5 = null;
                --this.simpleWriteDepth;
                this.currentObject = object2;
                this.currentClassDesc = objectStreamClass;
            }
            java.lang.Object var6_4 = null;
            --this.simpleWriteDepth;
            this.currentObject = object2;
            this.currentClassDesc = objectStreamClass;
        }
        catch (Throwable throwable) {
            java.lang.Object var6_6 = null;
            --this.simpleWriteDepth;
            this.currentObject = object2;
            this.currentClassDesc = objectStreamClass;
            throw throwable;
        }
        IOException iOException = this.abortIOException;
        if (this.simpleWriteDepth == 0) {
            this.abortIOException = null;
        }
        if (iOException != null) {
            IIOPOutputStream.throwExceptionType(IOException.class, iOException.getMessage());
        }
    }

    public final void writeObjectDelegate(java.lang.Object object) throws IOException {
        this.writeUDOWI();
        Util.writeAbstractObject(this.orbStream, object);
    }

    public final void writeObjectOverride(java.lang.Object object) throws IOException {
        this.writeObjectDelegate(object);
    }

    private boolean checkSpecialClasses(java.lang.Object object) throws IOException {
        if (object instanceof ObjectStreamClass) {
            throw new IOException("Serialization of ObjectStreamClass not supported");
        }
        return false;
    }

    private boolean checkSubstitutableSpecialClasses(java.lang.Object object) throws IOException {
        if (object instanceof String) {
            this.orbStream.write_value((Serializable)object);
            return true;
        }
        return false;
    }

    private static native byte getByteFieldOpt(java.lang.Object var0, long var1);

    private static native char getCharFieldOpt(java.lang.Object var0, long var1);

    private static native double getDoubleFieldOpt(java.lang.Object var0, long var1);

    private static native float getFloatFieldOpt(java.lang.Object var0, long var1);

    private static native int getIntFieldOpt(java.lang.Object var0, long var1);

    private static native long getLongFieldOpt(java.lang.Object var0, long var1);

    private static native short getShortFieldOpt(java.lang.Object var0, long var1);

    private static native boolean getBooleanFieldOpt(java.lang.Object var0, long var1);

    public final void writeBytes(String string) throws IOException {
        this.writeUDOWI();
        try {
            byte[] byArray = string.getBytes();
            this.orbStream.write_octet_array(byArray, 0, byArray.length);
        }
        catch (Error error) {
            throw new IOException(error.getMessage());
        }
    }

    public final void writeChars(String string) throws IOException {
        this.writeUDOWI();
        try {
            char[] cArray = string.toCharArray();
            this.orbStream.write_wchar_array(cArray, 0, cArray.length);
        }
        catch (Error error) {
            throw new IOException(error.getMessage());
        }
    }

    public final void writeUTF(String string) throws IOException {
        this.writeUDOWI();
        try {
            this.internalWriteUTF(this.orbStream, string);
        }
        catch (Error error) {
            throw new IOException(error.getMessage());
        }
    }

    public final OutputStream getOrbStream() {
        return this.orbStream;
    }

    public final void setOrbStream(OutputStream outputStream) {
        this.orbStream = outputStream;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void invokeObjectWriter(java.lang.Object object, Class clazz) throws IOException {
        try {
            this.writeByte(1);
            this.UDOWI_Pending = true;
            this.UDOW = false;
            IIOPOutputStream.writeObject(object, clazz, this);
            if (this.UDOWI_Pending) {
                this.writeUDOWI();
            }
        }
        catch (InvocationTargetException invocationTargetException) {
            Throwable throwable = invocationTargetException.getTargetException();
            if (throwable instanceof IOException) {
                throw (IOException)throwable;
            }
            if (throwable instanceof RuntimeException) {
                throw (RuntimeException)throwable;
            }
            if (throwable instanceof Error) {
                throw (Error)throwable;
            }
            throw new Error("invokeObjectWriter interal error");
        }
        catch (IllegalAccessException illegalAccessException) {
        }
    }

    void writeField(ObjectStreamField objectStreamField, java.lang.Object object) throws IOException {
        this.writeUDOWI();
        switch (objectStreamField.getTypeCode()) {
            case 'B': {
                if (object == null) {
                    this.orbStream.write_octet((byte)0);
                    break;
                }
                this.orbStream.write_octet((Byte)object);
                break;
            }
            case 'C': {
                if (object == null) {
                    this.orbStream.write_wchar('\u0000');
                    break;
                }
                this.orbStream.write_wchar(((Character)object).charValue());
                break;
            }
            case 'F': {
                if (object == null) {
                    this.orbStream.write_float(0.0f);
                    break;
                }
                this.orbStream.write_float(((Float)object).floatValue());
                break;
            }
            case 'D': {
                if (object == null) {
                    this.orbStream.write_double(0.0);
                    break;
                }
                this.orbStream.write_double((Double)object);
                break;
            }
            case 'I': {
                if (object == null) {
                    this.orbStream.write_long(0);
                    break;
                }
                this.orbStream.write_long((Integer)object);
                break;
            }
            case 'J': {
                if (object == null) {
                    this.orbStream.write_longlong(0L);
                    break;
                }
                this.orbStream.write_longlong((Long)object);
                break;
            }
            case 'S': {
                if (object == null) {
                    this.orbStream.write_short((short)0);
                    break;
                }
                this.orbStream.write_short((Short)object);
                break;
            }
            case 'Z': {
                if (object == null) {
                    this.orbStream.write_boolean(false);
                    break;
                }
                this.orbStream.write_boolean((Boolean)object);
                break;
            }
            case 'L': 
            case '[': {
                this.writeObjectField(objectStreamField, object);
                break;
            }
            default: {
                throw new InvalidClassException(this.currentClassDesc.getName());
            }
        }
    }

    private void writeObjectField(ObjectStreamField objectStreamField, java.lang.Object object) throws IOException {
        if (ObjectStreamClassCorbaExt.isAny(objectStreamField.getTypeString())) {
            Util.writeAny(this.orbStream, object);
        } else {
            Class clazz = objectStreamField.getType();
            int n2 = 2;
            if (clazz.isInterface()) {
                String string = clazz.getName();
                if (Remote.class.isAssignableFrom(clazz)) {
                    n2 = 0;
                } else if (Object.class.isAssignableFrom(clazz)) {
                    n2 = 0;
                } else if (RepositoryId.isAbstractBase(clazz)) {
                    n2 = 1;
                } else if (ObjectStreamClassCorbaExt.isAbstractInterface(clazz)) {
                    n2 = 1;
                }
            }
            switch (n2) {
                case 0: {
                    Util.writeRemoteObject(this.orbStream, object);
                    break;
                }
                case 1: {
                    Util.writeAbstractObject(this.orbStream, object);
                    break;
                }
                case 2: {
                    try {
                        this.orbStream.write_value((Serializable)object, clazz);
                        break;
                    }
                    catch (ClassCastException classCastException) {
                        if (object instanceof Serializable) {
                            throw classCastException;
                        }
                        Utility.throwNotSerializableForCorba(object.getClass().getName());
                    }
                }
            }
        }
    }

    protected final java.lang.Object replaceObject(java.lang.Object object) throws IOException {
        throw new IOException("Method replaceObject not supported");
    }

    private static native java.lang.Object getObjectFieldOpt(java.lang.Object var0, long var1);

    private static native void throwExceptionType(Class var0, String var1);

    protected void internalWriteUTF(org.omg.CORBA.portable.OutputStream outputStream, String string) {
        outputStream.write_wstring(string);
    }

    private void outputClassFields(java.lang.Object object, Class clazz, ObjectStreamField[] objectStreamFieldArray) throws IOException, InvalidClassException {
        this.writeUDOWI();
        block11: for (int i2 = 0; i2 < objectStreamFieldArray.length; ++i2) {
            if (objectStreamFieldArray[i2].getField() == null) {
                throw new InvalidClassException(clazz.getName(), "Nonexistent field " + objectStreamFieldArray[i2].getName());
            }
            switch (objectStreamFieldArray[i2].getTypeCode()) {
                case 'B': {
                    byte by = IIOPOutputStream.getByteFieldOpt(object, objectStreamFieldArray[i2].getFieldID(clazz));
                    this.orbStream.write_octet(by);
                    continue block11;
                }
                case 'C': {
                    char c2 = IIOPOutputStream.getCharFieldOpt(object, objectStreamFieldArray[i2].getFieldID(clazz));
                    this.orbStream.write_wchar(c2);
                    continue block11;
                }
                case 'F': {
                    float f2 = IIOPOutputStream.getFloatFieldOpt(object, objectStreamFieldArray[i2].getFieldID(clazz));
                    this.orbStream.write_float(f2);
                    continue block11;
                }
                case 'D': {
                    double d2 = IIOPOutputStream.getDoubleFieldOpt(object, objectStreamFieldArray[i2].getFieldID(clazz));
                    this.orbStream.write_double(d2);
                    continue block11;
                }
                case 'I': {
                    int n2 = IIOPOutputStream.getIntFieldOpt(object, objectStreamFieldArray[i2].getFieldID(clazz));
                    this.orbStream.write_long(n2);
                    continue block11;
                }
                case 'J': {
                    long l2 = IIOPOutputStream.getLongFieldOpt(object, objectStreamFieldArray[i2].getFieldID(clazz));
                    this.orbStream.write_longlong(l2);
                    continue block11;
                }
                case 'S': {
                    short s2 = IIOPOutputStream.getShortFieldOpt(object, objectStreamFieldArray[i2].getFieldID(clazz));
                    this.orbStream.write_short(s2);
                    continue block11;
                }
                case 'Z': {
                    boolean bl2 = IIOPOutputStream.getBooleanFieldOpt(object, objectStreamFieldArray[i2].getFieldID(clazz));
                    this.orbStream.write_boolean(bl2);
                    continue block11;
                }
                case 'L': 
                case '[': {
                    java.lang.Object object2 = IIOPOutputStream.getObjectFieldOpt(object, objectStreamFieldArray[i2].getFieldID(clazz));
                    this.writeObjectField(objectStreamFieldArray[i2], object2);
                    continue block11;
                }
                default: {
                    throw new InvalidClassException(clazz.getName());
                }
            }
        }
    }

    private static native void writeObject(java.lang.Object var0, Class var1, java.lang.Object var2) throws InvocationTargetException, IllegalAccessException;
}

