/*
 * Decompiled with CFR 0.152.
 */
package javax.swing.text.html;

import java.awt.Color;
import java.awt.Font;
import java.awt.GraphicsEnvironment;
import java.awt.Toolkit;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;
import javax.swing.ImageIcon;
import javax.swing.SizeRequirements;
import javax.swing.text.AttributeSet;
import javax.swing.text.Element;
import javax.swing.text.MutableAttributeSet;
import javax.swing.text.SimpleAttributeSet;
import javax.swing.text.StyleConstants;
import javax.swing.text.StyleContext;
import javax.swing.text.View;
import javax.swing.text.html.HTML;

public class CSS
implements Serializable {
    private static final Hashtable attributeMap;
    private static final Hashtable valueMap;
    static int[] sizeMap;
    private static final Hashtable htmlAttrToCssAttrMap;
    private static final Hashtable styleConstantToCssMap;
    private static final Hashtable htmlValueToCssValueMap;
    private static final Hashtable cssValueToInternalValueMap;
    private static Hashtable fontMapping;
    private static final Object fontMappingLock;
    private transient Hashtable valueConvertor = new Hashtable();
    private int baseFontSize = 4;

    int getBaseFontSize() {
        return this.baseFontSize;
    }

    static {
        int n2;
        int n3;
        attributeMap = new Hashtable();
        valueMap = new Hashtable();
        sizeMap = new int[]{8, 10, 12, 14, 18, 24, 36};
        htmlAttrToCssAttrMap = new Hashtable(20);
        styleConstantToCssMap = new Hashtable(17);
        htmlValueToCssValueMap = new Hashtable(8);
        cssValueToInternalValueMap = new Hashtable(13);
        fontMappingLock = new Object();
        for (n3 = 0; n3 < Attribute.allAttributes.length; ++n3) {
            attributeMap.put(Attribute.allAttributes[n3].toString(), Attribute.allAttributes[n3]);
        }
        for (n3 = 0; n3 < Value.allValues.length; ++n3) {
            valueMap.put(Value.allValues[n3].toString(), Value.allValues[n3]);
        }
        htmlAttrToCssAttrMap.put(HTML.Attribute.COLOR, new Attribute[]{Attribute.COLOR});
        htmlAttrToCssAttrMap.put(HTML.Attribute.TEXT, new Attribute[]{Attribute.COLOR});
        htmlAttrToCssAttrMap.put(HTML.Attribute.CLEAR, new Attribute[]{Attribute.CLEAR});
        htmlAttrToCssAttrMap.put(HTML.Attribute.BACKGROUND, new Attribute[]{Attribute.BACKGROUND_IMAGE});
        htmlAttrToCssAttrMap.put(HTML.Attribute.BGCOLOR, new Attribute[]{Attribute.BACKGROUND_COLOR});
        htmlAttrToCssAttrMap.put(HTML.Attribute.WIDTH, new Attribute[]{Attribute.WIDTH});
        htmlAttrToCssAttrMap.put(HTML.Attribute.HEIGHT, new Attribute[]{Attribute.HEIGHT});
        htmlAttrToCssAttrMap.put(HTML.Attribute.BORDER, new Attribute[]{Attribute.BORDER_TOP_WIDTH, Attribute.BORDER_RIGHT_WIDTH, Attribute.BORDER_BOTTOM_WIDTH, Attribute.BORDER_LEFT_WIDTH});
        htmlAttrToCssAttrMap.put(HTML.Attribute.CELLPADDING, new Attribute[]{Attribute.PADDING});
        htmlAttrToCssAttrMap.put(HTML.Attribute.CELLSPACING, new Attribute[]{Attribute.BORDER_SPACING});
        htmlAttrToCssAttrMap.put(HTML.Attribute.MARGINWIDTH, new Attribute[]{Attribute.MARGIN_LEFT, Attribute.MARGIN_RIGHT});
        htmlAttrToCssAttrMap.put(HTML.Attribute.MARGINHEIGHT, new Attribute[]{Attribute.MARGIN_TOP, Attribute.MARGIN_BOTTOM});
        htmlAttrToCssAttrMap.put(HTML.Attribute.HSPACE, new Attribute[]{Attribute.PADDING_LEFT, Attribute.PADDING_RIGHT});
        htmlAttrToCssAttrMap.put(HTML.Attribute.VSPACE, new Attribute[]{Attribute.PADDING_BOTTOM, Attribute.PADDING_TOP});
        htmlAttrToCssAttrMap.put(HTML.Attribute.FACE, new Attribute[]{Attribute.FONT_FAMILY});
        htmlAttrToCssAttrMap.put(HTML.Attribute.SIZE, new Attribute[]{Attribute.FONT_SIZE});
        htmlAttrToCssAttrMap.put(HTML.Attribute.VALIGN, new Attribute[]{Attribute.VERTICAL_ALIGN});
        htmlAttrToCssAttrMap.put(HTML.Attribute.ALIGN, new Attribute[]{Attribute.VERTICAL_ALIGN, Attribute.TEXT_ALIGN, Attribute.FLOAT});
        htmlAttrToCssAttrMap.put(HTML.Attribute.TYPE, new Attribute[]{Attribute.LIST_STYLE_TYPE});
        htmlAttrToCssAttrMap.put(HTML.Attribute.NOWRAP, new Attribute[]{Attribute.WHITE_SPACE});
        styleConstantToCssMap.put(StyleConstants.FontFamily, Attribute.FONT_FAMILY);
        styleConstantToCssMap.put(StyleConstants.FontSize, Attribute.FONT_SIZE);
        styleConstantToCssMap.put(StyleConstants.Bold, Attribute.FONT_WEIGHT);
        styleConstantToCssMap.put(StyleConstants.Italic, Attribute.FONT_STYLE);
        styleConstantToCssMap.put(StyleConstants.Underline, Attribute.TEXT_DECORATION);
        styleConstantToCssMap.put(StyleConstants.StrikeThrough, Attribute.TEXT_DECORATION);
        styleConstantToCssMap.put(StyleConstants.Superscript, Attribute.VERTICAL_ALIGN);
        styleConstantToCssMap.put(StyleConstants.Subscript, Attribute.VERTICAL_ALIGN);
        styleConstantToCssMap.put(StyleConstants.Foreground, Attribute.COLOR);
        styleConstantToCssMap.put(StyleConstants.Background, Attribute.BACKGROUND_COLOR);
        styleConstantToCssMap.put(StyleConstants.FirstLineIndent, Attribute.TEXT_INDENT);
        styleConstantToCssMap.put(StyleConstants.LeftIndent, Attribute.MARGIN_LEFT);
        styleConstantToCssMap.put(StyleConstants.RightIndent, Attribute.MARGIN_RIGHT);
        styleConstantToCssMap.put(StyleConstants.SpaceAbove, Attribute.MARGIN_TOP);
        styleConstantToCssMap.put(StyleConstants.SpaceBelow, Attribute.MARGIN_BOTTOM);
        styleConstantToCssMap.put(StyleConstants.Alignment, Attribute.TEXT_ALIGN);
        htmlValueToCssValueMap.put("disc", Value.DISC);
        htmlValueToCssValueMap.put("square", Value.SQUARE);
        htmlValueToCssValueMap.put("circle", Value.CIRCLE);
        htmlValueToCssValueMap.put("1", Value.DECIMAL);
        htmlValueToCssValueMap.put("a", Value.LOWER_ALPHA);
        htmlValueToCssValueMap.put("A", Value.UPPER_ALPHA);
        htmlValueToCssValueMap.put("i", Value.LOWER_ROMAN);
        htmlValueToCssValueMap.put("I", Value.UPPER_ROMAN);
        cssValueToInternalValueMap.put("disc", Value.DISC);
        cssValueToInternalValueMap.put("square", Value.SQUARE);
        cssValueToInternalValueMap.put("circle", Value.CIRCLE);
        cssValueToInternalValueMap.put("decimal", Value.DECIMAL);
        cssValueToInternalValueMap.put("lower-roman", Value.LOWER_ROMAN);
        cssValueToInternalValueMap.put("upper-roman", Value.UPPER_ROMAN);
        cssValueToInternalValueMap.put("lower-alpha", Value.LOWER_ALPHA);
        cssValueToInternalValueMap.put("upper-alpha", Value.UPPER_ALPHA);
        cssValueToInternalValueMap.put("repeat", Value.BACKGROUND_REPEAT);
        cssValueToInternalValueMap.put("no-repeat", Value.BACKGROUND_NO_REPEAT);
        cssValueToInternalValueMap.put("repeat-x", Value.BACKGROUND_REPEAT_X);
        cssValueToInternalValueMap.put("repeat-y", Value.BACKGROUND_REPEAT_Y);
        cssValueToInternalValueMap.put("scroll", Value.BACKGROUND_SCROLL);
        cssValueToInternalValueMap.put("fixed", Value.BACKGROUND_FIXED);
        Object[] objectArray = Attribute.allAttributes;
        try {
            for (n2 = 0; n2 < objectArray.length; ++n2) {
                StyleContext.registerStaticAttributeKey(objectArray[n2]);
            }
        }
        catch (Throwable throwable) {
            throwable.printStackTrace();
        }
        objectArray = Value.allValues;
        try {
            for (n2 = 0; n2 < objectArray.length; ++n2) {
                StyleContext.registerStaticAttributeKey(objectArray[n2]);
            }
        }
        catch (Throwable throwable) {
            throwable.printStackTrace();
        }
    }

    public CSS() {
        this.valueConvertor.put(Attribute.FONT_SIZE, new FontSize());
        this.valueConvertor.put(Attribute.FONT_FAMILY, new FontFamily());
        this.valueConvertor.put(Attribute.FONT_WEIGHT, new FontWeight());
        this.valueConvertor.put(Attribute.BORDER_STYLE, new BorderStyle());
        ColorValue colorValue = new ColorValue();
        this.valueConvertor.put(Attribute.COLOR, colorValue);
        this.valueConvertor.put(Attribute.BACKGROUND_COLOR, colorValue);
        this.valueConvertor.put(Attribute.BORDER_COLOR, colorValue);
        LengthValue lengthValue = new LengthValue();
        this.valueConvertor.put(Attribute.MARGIN_TOP, lengthValue);
        this.valueConvertor.put(Attribute.MARGIN_BOTTOM, lengthValue);
        this.valueConvertor.put(Attribute.MARGIN_LEFT, lengthValue);
        this.valueConvertor.put(Attribute.MARGIN_RIGHT, lengthValue);
        this.valueConvertor.put(Attribute.PADDING_TOP, lengthValue);
        this.valueConvertor.put(Attribute.PADDING_BOTTOM, lengthValue);
        this.valueConvertor.put(Attribute.PADDING_LEFT, lengthValue);
        this.valueConvertor.put(Attribute.PADDING_RIGHT, lengthValue);
        BorderWidthValue borderWidthValue = new BorderWidthValue(null, 0);
        this.valueConvertor.put(Attribute.BORDER_WIDTH, lengthValue);
        this.valueConvertor.put(Attribute.BORDER_TOP_WIDTH, borderWidthValue);
        this.valueConvertor.put(Attribute.BORDER_BOTTOM_WIDTH, borderWidthValue);
        this.valueConvertor.put(Attribute.BORDER_LEFT_WIDTH, borderWidthValue);
        this.valueConvertor.put(Attribute.BORDER_RIGHT_WIDTH, borderWidthValue);
        this.valueConvertor.put(Attribute.TEXT_INDENT, lengthValue);
        this.valueConvertor.put(Attribute.WIDTH, lengthValue);
        this.valueConvertor.put(Attribute.HEIGHT, lengthValue);
        this.valueConvertor.put(Attribute.BORDER_SPACING, lengthValue);
        StringValue stringValue = new StringValue();
        this.valueConvertor.put(Attribute.FONT_STYLE, stringValue);
        this.valueConvertor.put(Attribute.TEXT_DECORATION, stringValue);
        this.valueConvertor.put(Attribute.TEXT_ALIGN, stringValue);
        this.valueConvertor.put(Attribute.VERTICAL_ALIGN, stringValue);
        CssValueMapper cssValueMapper = new CssValueMapper();
        this.valueConvertor.put(Attribute.LIST_STYLE_TYPE, cssValueMapper);
        this.valueConvertor.put(Attribute.BACKGROUND_IMAGE, new BackgroundImage());
        this.valueConvertor.put(Attribute.BACKGROUND_POSITION, new BackgroundPosition());
        this.valueConvertor.put(Attribute.BACKGROUND_REPEAT, cssValueMapper);
        this.valueConvertor.put(Attribute.BACKGROUND_ATTACHMENT, cssValueMapper);
        CssValue cssValue = new CssValue();
        int n2 = Attribute.allAttributes.length;
        for (int i2 = 0; i2 < n2; ++i2) {
            Attribute attribute = Attribute.allAttributes[i2];
            if (this.valueConvertor.get(attribute) != null) continue;
            this.valueConvertor.put(attribute, cssValue);
        }
    }

    static int getIndexOfSize(float f2) {
        for (int i2 = 0; i2 < sizeMap.length; ++i2) {
            if (!(f2 <= (float)sizeMap[i2])) continue;
            return i2 + 1;
        }
        return sizeMap.length;
    }

    float getPointSize(int n2) {
        if (--n2 < 0) {
            return sizeMap[0];
        }
        if (n2 > sizeMap.length - 1) {
            return sizeMap[sizeMap.length - 1];
        }
        return sizeMap[n2];
    }

    void setBaseFontSize(int n2) {
        this.baseFontSize = n2 < 1 ? 0 : (n2 > 7 ? 7 : n2);
    }

    private void readObject(ObjectInputStream objectInputStream) throws ClassNotFoundException, IOException {
        objectInputStream.defaultReadObject();
        int n2 = objectInputStream.readInt();
        this.valueConvertor = new Hashtable(Math.max(1, n2));
        while (n2-- > 0) {
            Object object;
            Object object2 = objectInputStream.readObject();
            Object object3 = objectInputStream.readObject();
            Object object4 = StyleContext.getStaticAttribute(object2);
            if (object4 != null) {
                object2 = object4;
            }
            if ((object = StyleContext.getStaticAttribute(object3)) != null) {
                object3 = object;
            }
            if (object2 == null || object3 == null) continue;
            this.valueConvertor.put(object2, object3);
        }
    }

    private void writeObject(ObjectOutputStream objectOutputStream) throws IOException {
        objectOutputStream.defaultWriteObject();
        Enumeration enumeration = this.valueConvertor.keys();
        objectOutputStream.writeInt(this.valueConvertor.size());
        if (enumeration != null) {
            while (enumeration.hasMoreElements()) {
                Object object = enumeration.nextElement();
                Object object2 = this.valueConvertor.get(object);
                if (!(object instanceof Serializable) && (object = StyleContext.getStaticAttributeKey(object)) == null) {
                    object = null;
                    object2 = null;
                } else if (!(object2 instanceof Serializable) && (object2 = StyleContext.getStaticAttributeKey(object2)) == null) {
                    object = null;
                    object2 = null;
                }
                objectOutputStream.writeObject(object);
                objectOutputStream.writeObject(object2);
            }
        }
    }

    float getPointSize(String string) {
        if (string != null) {
            if (string.startsWith("+")) {
                int n2 = Integer.valueOf(string.substring(1));
                return this.getPointSize(this.baseFontSize + n2);
            }
            if (string.startsWith("-")) {
                int n3 = -Integer.valueOf(string.substring(1)).intValue();
                return this.getPointSize(this.baseFontSize + n3);
            }
            int n4 = Integer.valueOf(string);
            return this.getPointSize(n4);
        }
        return 0.0f;
    }

    void setBaseFontSize(String string) {
        if (string != null) {
            if (string.startsWith("+")) {
                int n2 = Integer.valueOf(string.substring(1));
                this.setBaseFontSize(this.baseFontSize + n2);
            } else if (string.startsWith("-")) {
                int n3 = -Integer.valueOf(string.substring(1)).intValue();
                this.setBaseFontSize(this.baseFontSize + n3);
            } else {
                this.setBaseFontSize(Integer.valueOf(string));
            }
        }
    }

    private boolean isFloater(String string) {
        return string.equals("left") || string.equals("right");
    }

    private boolean validTextAlignValue(String string) {
        return this.isFloater(string) || string.equals("center");
    }

    private static int getColorComponent(String string, int[] nArray) {
        char c2;
        int n2 = string.length();
        while (nArray[0] < n2 && (c2 = string.charAt(nArray[0])) != '-' && !Character.isDigit(c2) && c2 != '.') {
            nArray[0] = nArray[0] + 1;
        }
        int n3 = nArray[0];
        if (n3 < n2 && string.charAt(nArray[0]) == '-') {
            nArray[0] = nArray[0] + 1;
        }
        while (nArray[0] < n2 && Character.isDigit(string.charAt(nArray[0]))) {
            nArray[0] = nArray[0] + 1;
        }
        if (nArray[0] < n2 && string.charAt(nArray[0]) == '.') {
            nArray[0] = nArray[0] + 1;
            while (nArray[0] < n2 && Character.isDigit(string.charAt(nArray[0]))) {
                nArray[0] = nArray[0] + 1;
            }
        }
        if (n3 != nArray[0]) {
            try {
                float f2 = Float.parseFloat(string.substring(n3, nArray[0]));
                if (nArray[0] < n2 && string.charAt(nArray[0]) == '%') {
                    nArray[0] = nArray[0] + 1;
                    f2 = f2 * 255.0f / 100.0f;
                }
                return Math.min(255, Math.max(0, (int)f2));
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        return 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static Hashtable getValidFontNameMapping() {
        if (fontMapping == null) {
            Object object = fontMappingLock;
            synchronized (object) {
                if (fontMapping == null) {
                    String[] stringArray = null;
                    GraphicsEnvironment graphicsEnvironment = GraphicsEnvironment.getLocalGraphicsEnvironment();
                    if (graphicsEnvironment != null) {
                        stringArray = graphicsEnvironment.getAvailableFontFamilyNames();
                    }
                    if (stringArray == null) {
                        stringArray = Toolkit.getDefaultToolkit().getFontList();
                    }
                    if (stringArray != null) {
                        fontMapping = new Hashtable(stringArray.length * 2);
                        for (int i2 = stringArray.length - 1; i2 >= 0; --i2) {
                            fontMapping.put(stringArray[i2].toLowerCase(), stringArray[i2]);
                            fontMapping.put(stringArray[i2], stringArray[i2]);
                        }
                    } else {
                        fontMapping = new Hashtable(1);
                    }
                }
            }
        }
        return fontMapping;
    }

    static int getFontSize(AttributeSet attributeSet, int n2) {
        FontSize fontSize = (FontSize)attributeSet.getAttribute(Attribute.FONT_SIZE);
        return fontSize != null ? (int)fontSize.getValue(attributeSet) : n2;
    }

    public static Attribute[] getAllAttributeKeys() {
        Attribute[] attributeArray = new Attribute[Attribute.allAttributes.length];
        System.arraycopy(Attribute.allAttributes, 0, attributeArray, 0, Attribute.allAttributes.length);
        return attributeArray;
    }

    static void calculateTiledLayout(LayoutIterator layoutIterator, int n2) {
        int n3;
        int n4;
        long l2 = 0L;
        long l3 = 0L;
        int n5 = 0;
        int n6 = 0;
        int n7 = layoutIterator.getCount();
        int n8 = 2;
        long[] lArray = new long[n8];
        long[] lArray2 = new long[n8];
        for (n4 = 0; n4 < n8; ++n4) {
            lArray2[n4] = 0L;
            lArray[n4] = 0L;
        }
        for (n4 = 0; n4 < n7; ++n4) {
            layoutIterator.setIndex(n4);
            int n9 = n5;
            int n10 = (int)layoutIterator.getLeadingCollapseSpan();
            layoutIterator.setOffset(Math.max(n9, n10));
            if (layoutIterator.getOffset() != 0) {
                layoutIterator.setOffset(layoutIterator.getOffset() - n9);
                n6 += layoutIterator.getOffset();
            }
            l3 = (long)layoutIterator.getPreferredSpan(n2);
            layoutIterator.setSpan((int)l3);
            l2 += l3;
            int n11 = layoutIterator.getAdjustmentWeight();
            lArray[n11] = lArray[n11] + ((long)layoutIterator.getMaximumSpan(n2) - l3);
            int n12 = layoutIterator.getAdjustmentWeight();
            lArray2[n12] = lArray2[n12] + (l3 - (long)layoutIterator.getMinimumSpan(n2));
            n5 = (int)layoutIterator.getTrailingCollapseSpan();
        }
        for (n4 = 1; n4 < n8; ++n4) {
            int n13 = n4;
            lArray[n13] = lArray[n13] + lArray[n4 - 1];
            int n14 = n4;
            lArray2[n14] = lArray2[n14] + lArray2[n4 - 1];
        }
        n4 = n2 - n6;
        long l4 = (long)n4 - l2;
        long[] lArray3 = l4 > 0L ? lArray : lArray2;
        l4 = Math.abs(l4);
        for (n3 = 0; n3 <= 1 && lArray3[n3] < l4; ++n3) {
        }
        float f2 = 0.0f;
        if (n3 <= 1 && (l4 -= n3 > 0 ? lArray3[n3 - 1] : 0L) != 0L) {
            float f3 = lArray3[n3] - (n3 > 0 ? lArray3[n3 - 1] : 0L);
            f2 = (float)l4 / f3;
        }
        int n15 = 0;
        for (int i2 = 0; i2 < n7; ++i2) {
            layoutIterator.setIndex(i2);
            layoutIterator.setOffset(layoutIterator.getOffset() + n15);
            if (layoutIterator.getAdjustmentWeight() < n3) {
                layoutIterator.setSpan((int)((long)n4 > l2 ? Math.floor(layoutIterator.getMaximumSpan(n2)) : Math.ceil(layoutIterator.getMinimumSpan(n2))));
            } else if (layoutIterator.getAdjustmentWeight() == n3) {
                int n16 = (long)n4 > l2 ? (int)layoutIterator.getMaximumSpan(n2) - layoutIterator.getSpan() : layoutIterator.getSpan() - (int)layoutIterator.getMinimumSpan(n2);
                int n17 = (int)Math.floor(f2 * (float)n16);
                layoutIterator.setSpan(layoutIterator.getSpan() + ((long)n4 > l2 ? n17 : -n17));
            }
            n15 = (int)Math.min((long)n15 + (long)layoutIterator.getSpan(), Integer.MAX_VALUE);
        }
    }

    private boolean isHTMLFontTag(HTML.Tag tag) {
        return tag != null && (tag == HTML.Tag.FONT || tag == HTML.Tag.BASEFONT);
    }

    static final Color hexToColor(String string) {
        Color color;
        int n2 = string.length();
        String string2 = string.startsWith("#") ? string.substring(1, Math.min(string.length(), 7)) : string;
        String string3 = "0x" + string2;
        try {
            color = Color.decode(string3);
        }
        catch (NumberFormatException numberFormatException) {
            color = null;
        }
        return color;
    }

    private static Color parseRGB(String string) {
        int[] nArray = new int[]{4};
        int n2 = CSS.getColorComponent(string, nArray);
        int n3 = CSS.getColorComponent(string, nArray);
        int n4 = CSS.getColorComponent(string, nArray);
        return new Color(n2, n3, n4);
    }

    static Color stringToColor(String string) {
        Color color = null;
        color = string.length() == 0 ? Color.black : (string.startsWith("rgb(") ? CSS.parseRGB(string) : (string.charAt(0) == '#' ? CSS.hexToColor(string) : (string.equalsIgnoreCase("Black") ? CSS.hexToColor("#000000") : (string.equalsIgnoreCase("Silver") ? CSS.hexToColor("#C0C0C0") : (string.equalsIgnoreCase("Gray") ? CSS.hexToColor("#808080") : (string.equalsIgnoreCase("White") ? CSS.hexToColor("#FFFFFF") : (string.equalsIgnoreCase("Maroon") ? CSS.hexToColor("#800000") : (string.equalsIgnoreCase("Red") ? CSS.hexToColor("#FF0000") : (string.equalsIgnoreCase("Purple") ? CSS.hexToColor("#800080") : (string.equalsIgnoreCase("Fuchsia") ? CSS.hexToColor("#FF00FF") : (string.equalsIgnoreCase("Green") ? CSS.hexToColor("#008000") : (string.equalsIgnoreCase("Lime") ? CSS.hexToColor("#00FF00") : (string.equalsIgnoreCase("Olive") ? CSS.hexToColor("#808000") : (string.equalsIgnoreCase("Yellow") ? CSS.hexToColor("#FFFF00") : (string.equalsIgnoreCase("Navy") ? CSS.hexToColor("#000080") : (string.equalsIgnoreCase("Blue") ? CSS.hexToColor("#0000FF") : (string.equalsIgnoreCase("Teal") ? CSS.hexToColor("#008080") : (string.equalsIgnoreCase("Aqua") ? CSS.hexToColor("#00FFFF") : CSS.hexToColor(string)))))))))))))))))));
        return color;
    }

    static String colorToHex(Color color) {
        String string = new String("#");
        String string2 = Integer.toHexString(color.getRed());
        if (string2.length() > 2) {
            string2 = string2.substring(0, 2);
        } else {
            string = string2.length() < 2 ? string + "0" + string2 : string + string2;
        }
        string2 = Integer.toHexString(color.getGreen());
        if (string2.length() > 2) {
            string2 = string2.substring(0, 2);
        } else {
            string = string2.length() < 2 ? string + "0" + string2 : string + string2;
        }
        string2 = Integer.toHexString(color.getBlue());
        if (string2.length() > 2) {
            string2 = string2.substring(0, 2);
        } else {
            string = string2.length() < 2 ? string + "0" + string2 : string + string2;
        }
        return string;
    }

    static String[] parseStrings(String string) {
        int n2 = string == null ? 0 : string.length();
        Vector vector = new Vector(4);
        for (int i2 = 0; i2 < n2; ++i2) {
            while (i2 < n2 && Character.isWhitespace(string.charAt(i2))) {
                ++i2;
            }
            int n3 = i2;
            while (i2 < n2 && !Character.isWhitespace(string.charAt(i2))) {
                ++i2;
            }
            if (n3 == i2) continue;
            vector.addElement(string.substring(n3, i2));
        }
        Object[] objectArray = new String[vector.size()];
        vector.copyInto(objectArray);
        return objectArray;
    }

    AttributeSet translateHTMLToCSS(AttributeSet attributeSet) {
        Object object;
        SimpleAttributeSet simpleAttributeSet = new SimpleAttributeSet();
        Element element = (Element)((Object)attributeSet);
        HTML.Tag tag = this.getHTMLTag(attributeSet);
        if (tag == HTML.Tag.TD || tag == HTML.Tag.TH) {
            object = element.getParentElement().getParentElement().getAttributes();
            this.translateAttribute(HTML.Attribute.BORDER, (AttributeSet)object, simpleAttributeSet);
            String string = (String)object.getAttribute(HTML.Attribute.CELLPADDING);
            if (string != null) {
                Object object2 = this.getInternalCSSValue(Attribute.PADDING_TOP, string);
                simpleAttributeSet.addAttribute(Attribute.PADDING_TOP, object2);
                simpleAttributeSet.addAttribute(Attribute.PADDING_BOTTOM, object2);
                simpleAttributeSet.addAttribute(Attribute.PADDING_LEFT, object2);
                simpleAttributeSet.addAttribute(Attribute.PADDING_RIGHT, object2);
            }
        }
        if (element.isLeaf()) {
            this.translateEmbeddedAttributes(attributeSet, simpleAttributeSet);
        } else {
            this.translateAttributes(tag, attributeSet, simpleAttributeSet);
        }
        if (tag == HTML.Tag.CAPTION) {
            object = attributeSet.getAttribute(HTML.Attribute.ALIGN);
            if (object != null && (object.equals("top") || object.equals("bottom"))) {
                simpleAttributeSet.addAttribute(Attribute.CAPTION_SIDE, object);
                simpleAttributeSet.removeAttribute(Attribute.TEXT_ALIGN);
            } else {
                object = attributeSet.getAttribute(HTML.Attribute.VALIGN);
                if (object != null) {
                    simpleAttributeSet.addAttribute(Attribute.CAPTION_SIDE, object);
                }
            }
        }
        return simpleAttributeSet;
    }

    private void translateEmbeddedAttributes(AttributeSet attributeSet, MutableAttributeSet mutableAttributeSet) {
        Enumeration enumeration = attributeSet.getAttributeNames();
        if (attributeSet.getAttribute(StyleConstants.NameAttribute) == HTML.Tag.HR) {
            this.translateAttributes(HTML.Tag.HR, attributeSet, mutableAttributeSet);
        }
        while (enumeration.hasMoreElements()) {
            Object object = enumeration.nextElement();
            if (object instanceof HTML.Tag) {
                HTML.Tag tag = (HTML.Tag)object;
                Object object2 = attributeSet.getAttribute(tag);
                if (object2 == null || !(object2 instanceof AttributeSet)) continue;
                this.translateAttributes(tag, (AttributeSet)object2, mutableAttributeSet);
                continue;
            }
            if (!(object instanceof Attribute)) continue;
            mutableAttributeSet.addAttribute(object, attributeSet.getAttribute(object));
        }
    }

    public static final Attribute getAttribute(String string) {
        return (Attribute)attributeMap.get(string);
    }

    float getLength(AttributeSet attributeSet, Attribute attribute) {
        LengthValue lengthValue = (LengthValue)attributeSet.getAttribute(attribute);
        float f2 = lengthValue != null ? lengthValue.getValue() : 0.0f;
        return f2;
    }

    Attribute styleConstantsKeyToCSSKey(StyleConstants styleConstants) {
        return (Attribute)styleConstantToCssMap.get(styleConstants);
    }

    private Attribute[] getCssAttribute(HTML.Attribute attribute) {
        return (Attribute[])htmlAttrToCssAttrMap.get(attribute);
    }

    static final Value getValue(String string) {
        return (Value)valueMap.get(string);
    }

    private HTML.Tag getHTMLTag(AttributeSet attributeSet) {
        Object object = attributeSet.getAttribute(StyleConstants.NameAttribute);
        if (object instanceof HTML.Tag) {
            HTML.Tag tag = (HTML.Tag)object;
            return tag;
        }
        return null;
    }

    Color getColor(AttributeSet attributeSet, Attribute attribute) {
        ColorValue colorValue = (ColorValue)attributeSet.getAttribute(attribute);
        if (colorValue != null) {
            return colorValue.getValue();
        }
        return null;
    }

    Font getFont(StyleContext styleContext, AttributeSet attributeSet, int n2) {
        Object object;
        Object object2;
        int n3 = CSS.getFontSize(attributeSet, n2);
        StringValue stringValue = (StringValue)attributeSet.getAttribute(Attribute.VERTICAL_ALIGN);
        if (stringValue != null && (((String)(object2 = stringValue.toString())).indexOf("sup") >= 0 || ((String)object2).indexOf("sub") >= 0)) {
            n3 -= 2;
        }
        String string = (object2 = (FontFamily)attributeSet.getAttribute(Attribute.FONT_FAMILY)) != null ? ((FontFamily)object2).getValue() : "SansSerif";
        int n4 = 0;
        FontWeight fontWeight = (FontWeight)attributeSet.getAttribute(Attribute.FONT_WEIGHT);
        if (fontWeight != null && fontWeight.getValue() > 400) {
            n4 |= 1;
        }
        if ((object = attributeSet.getAttribute(Attribute.FONT_STYLE)) != null && object.toString().indexOf("italic") >= 0) {
            n4 |= 2;
        }
        Font font = styleContext.getFont(string, n4, n3);
        return font;
    }

    Object cssValueToStyleConstantsValue(StyleConstants styleConstants, Object object) {
        if (object instanceof CssValue) {
            return ((CssValue)object).toStyleConstants(styleConstants, null);
        }
        return null;
    }

    Object styleConstantsValueToCSSValue(StyleConstants styleConstants, Object object) {
        Attribute attribute = this.styleConstantsKeyToCSSKey(styleConstants);
        if (attribute != null) {
            CssValue cssValue = (CssValue)this.valueConvertor.get(attribute);
            return cssValue.fromStyleConstants(styleConstants, object);
        }
        return null;
    }

    Object getCssValue(Attribute attribute, String string) {
        CssValue cssValue = (CssValue)this.valueConvertor.get(attribute);
        Object object = cssValue.parseHtmlValue(string);
        return object;
    }

    Object getInternalCSSValue(Attribute attribute, String string) {
        CssValue cssValue = (CssValue)this.valueConvertor.get(attribute);
        return cssValue.parseCssValue(string);
    }

    void addInternalCSSValue(MutableAttributeSet mutableAttributeSet, Attribute attribute, String string) {
        if (attribute == Attribute.FONT) {
            ShorthandFontParser.parseShorthandFont(this, string, mutableAttributeSet);
        } else if (attribute == Attribute.BACKGROUND) {
            ShorthandBackgroundParser.parseShorthandBackground(this, string, mutableAttributeSet);
        } else if (attribute == Attribute.MARGIN) {
            ShorthandMarginParser.parseShorthandMargin(this, string, mutableAttributeSet, Attribute.ALL_MARGINS);
        } else if (attribute == Attribute.PADDING) {
            ShorthandMarginParser.parseShorthandMargin(this, string, mutableAttributeSet, Attribute.ALL_PADDING);
        } else if (attribute == Attribute.BORDER_WIDTH) {
            ShorthandMarginParser.parseShorthandMargin(this, string, mutableAttributeSet, Attribute.ALL_BORDER_WIDTHS);
        } else {
            Object object = this.getInternalCSSValue(attribute, string);
            if (object != null) {
                mutableAttributeSet.addAttribute(attribute, object);
            }
        }
    }

    static URL getURL(URL uRL, String string) {
        URL uRL2;
        if (string == null) {
            return null;
        }
        if (string.startsWith("url(") && string.endsWith(")")) {
            string = string.substring(4, string.length() - 1);
        }
        try {
            uRL2 = new URL(string);
            if (uRL2 != null) {
                return uRL2;
            }
        }
        catch (MalformedURLException malformedURLException) {
            // empty catch block
        }
        if (uRL != null) {
            try {
                uRL2 = new URL(uRL, string);
                return uRL2;
            }
            catch (MalformedURLException malformedURLException) {
                // empty catch block
            }
        }
        return null;
    }

    static SizeRequirements calculateTiledRequirements(LayoutIterator layoutIterator, SizeRequirements sizeRequirements) {
        long l2 = 0L;
        long l3 = 0L;
        long l4 = 0L;
        int n2 = 0;
        int n3 = 0;
        int n4 = layoutIterator.getCount();
        for (int i2 = 0; i2 < n4; ++i2) {
            layoutIterator.setIndex(i2);
            int n5 = n2;
            int n6 = (int)layoutIterator.getLeadingCollapseSpan();
            int n7 = Math.max(n5, n6);
            if (n7 != 0) {
                n3 += n7 - n5;
            }
            l4 += (long)((int)layoutIterator.getPreferredSpan(0.0f));
            l2 = (long)((float)l2 + layoutIterator.getMinimumSpan(0.0f));
            l3 = (long)((float)l3 + layoutIterator.getMaximumSpan(0.0f));
            n2 = (int)layoutIterator.getTrailingCollapseSpan();
        }
        l2 -= (long)n3;
        l4 -= (long)n3;
        l3 -= (long)n3;
        if (sizeRequirements == null) {
            sizeRequirements = new SizeRequirements();
        }
        sizeRequirements.minimum = l2 > Integer.MAX_VALUE ? Integer.MAX_VALUE : (int)l2;
        sizeRequirements.preferred = l4 > Integer.MAX_VALUE ? Integer.MAX_VALUE : (int)l4;
        sizeRequirements.maximum = l3 > Integer.MAX_VALUE ? Integer.MAX_VALUE : (int)l3;
        return sizeRequirements;
    }

    private void translateAttribute(HTML.Attribute attribute, AttributeSet attributeSet, MutableAttributeSet mutableAttributeSet) {
        Attribute[] attributeArray = this.getCssAttribute(attribute);
        String string = (String)attributeSet.getAttribute(attribute);
        if (attributeArray == null || string == null) {
            return;
        }
        for (int i2 = 0; i2 < attributeArray.length; ++i2) {
            Object object = this.getCssValue(attributeArray[i2], string);
            if (object == null) continue;
            mutableAttributeSet.addAttribute(attributeArray[i2], object);
        }
    }

    private void translateAttributes(HTML.Tag tag, AttributeSet attributeSet, MutableAttributeSet mutableAttributeSet) {
        Enumeration enumeration = attributeSet.getAttributeNames();
        while (enumeration.hasMoreElements()) {
            Object object = enumeration.nextElement();
            if (object instanceof HTML.Attribute) {
                HTML.Attribute attribute = (HTML.Attribute)object;
                if (attribute == HTML.Attribute.ALIGN) {
                    Object object2;
                    Attribute attribute2;
                    String string = (String)attributeSet.getAttribute(HTML.Attribute.ALIGN);
                    if (string == null || (attribute2 = this.getCssAlignAttribute(tag, attributeSet)) == null || (object2 = this.getCssValue(attribute2, string)) == null) continue;
                    mutableAttributeSet.addAttribute(attribute2, object2);
                    continue;
                }
                if (attribute == HTML.Attribute.SIZE && !this.isHTMLFontTag(tag)) continue;
                this.translateAttribute(attribute, attributeSet, mutableAttributeSet);
                continue;
            }
            if (!(object instanceof Attribute)) continue;
            mutableAttributeSet.addAttribute(object, attributeSet.getAttribute(object));
        }
    }

    private Attribute getCssAlignAttribute(HTML.Tag tag, AttributeSet attributeSet) {
        return Attribute.TEXT_ALIGN;
    }

    public static final class Attribute {
        private String name;
        private String defaultValue;
        private boolean inherited;
        public static final Attribute BACKGROUND = new Attribute("background", null, false);
        public static final Attribute BACKGROUND_ATTACHMENT = new Attribute("background-attachment", "scroll", false);
        public static final Attribute BACKGROUND_COLOR = new Attribute("background-color", "transparent", false);
        public static final Attribute BACKGROUND_IMAGE = new Attribute("background-image", "none", false);
        public static final Attribute BACKGROUND_POSITION = new Attribute("background-position", null, false);
        public static final Attribute BACKGROUND_REPEAT = new Attribute("background-repeat", "repeat", false);
        public static final Attribute BORDER = new Attribute("border", null, false);
        public static final Attribute BORDER_BOTTOM = new Attribute("border-bottom", null, false);
        public static final Attribute BORDER_BOTTOM_WIDTH = new Attribute("border-bottom-width", "medium", false);
        public static final Attribute BORDER_COLOR = new Attribute("border-color", null, false);
        public static final Attribute BORDER_LEFT = new Attribute("border-left", null, false);
        public static final Attribute BORDER_LEFT_WIDTH = new Attribute("border-left-width", "medium", false);
        public static final Attribute BORDER_RIGHT = new Attribute("border-right", null, false);
        public static final Attribute BORDER_RIGHT_WIDTH = new Attribute("border-right-width", "medium", false);
        public static final Attribute BORDER_STYLE = new Attribute("border-style", "none", false);
        public static final Attribute BORDER_TOP = new Attribute("border-top", null, false);
        public static final Attribute BORDER_TOP_WIDTH = new Attribute("border-top-width", "medium", false);
        public static final Attribute BORDER_WIDTH = new Attribute("border-width", "medium", false);
        public static final Attribute CLEAR = new Attribute("clear", "none", false);
        public static final Attribute COLOR = new Attribute("color", null, true);
        public static final Attribute DISPLAY = new Attribute("display", "block", false);
        public static final Attribute FLOAT = new Attribute("float", "none", false);
        public static final Attribute FONT = new Attribute("font", null, true);
        public static final Attribute FONT_FAMILY = new Attribute("font-family", null, true);
        public static final Attribute FONT_SIZE = new Attribute("font-size", "medium", true);
        public static final Attribute FONT_STYLE = new Attribute("font-style", "normal", true);
        public static final Attribute FONT_VARIANT = new Attribute("font-variant", "normal", true);
        public static final Attribute FONT_WEIGHT = new Attribute("font-weight", "normal", true);
        public static final Attribute HEIGHT = new Attribute("height", "auto", false);
        public static final Attribute LETTER_SPACING = new Attribute("letter-spacing", "normal", true);
        public static final Attribute LINE_HEIGHT = new Attribute("line-height", "normal", true);
        public static final Attribute LIST_STYLE = new Attribute("list-style", null, true);
        public static final Attribute LIST_STYLE_IMAGE = new Attribute("list-style-image", "none", true);
        public static final Attribute LIST_STYLE_POSITION = new Attribute("list-style-position", "outside", true);
        public static final Attribute LIST_STYLE_TYPE = new Attribute("list-style-type", "disc", true);
        public static final Attribute MARGIN = new Attribute("margin", null, false);
        public static final Attribute MARGIN_BOTTOM = new Attribute("margin-bottom", "0", false);
        public static final Attribute MARGIN_LEFT = new Attribute("margin-left", "0", false);
        public static final Attribute MARGIN_RIGHT = new Attribute("margin-right", "0", false);
        public static final Attribute MARGIN_TOP = new Attribute("margin-top", "0", false);
        public static final Attribute PADDING = new Attribute("padding", null, false);
        public static final Attribute PADDING_BOTTOM = new Attribute("padding-bottom", "0", false);
        public static final Attribute PADDING_LEFT = new Attribute("padding-left", "0", false);
        public static final Attribute PADDING_RIGHT = new Attribute("padding-right", "0", false);
        public static final Attribute PADDING_TOP = new Attribute("padding-top", "0", false);
        public static final Attribute TEXT_ALIGN = new Attribute("text-align", null, true);
        public static final Attribute TEXT_DECORATION = new Attribute("text-decoration", "none", true);
        public static final Attribute TEXT_INDENT = new Attribute("text-indent", "0", true);
        public static final Attribute TEXT_TRANSFORM = new Attribute("text-transform", "none", true);
        public static final Attribute VERTICAL_ALIGN = new Attribute("vertical-align", "baseline", false);
        public static final Attribute WORD_SPACING = new Attribute("word-spacing", "normal", true);
        public static final Attribute WHITE_SPACE = new Attribute("white-space", "normal", true);
        public static final Attribute WIDTH = new Attribute("width", "auto", false);
        static final Attribute BORDER_SPACING = new Attribute("border-spacing", "0", true);
        static final Attribute CAPTION_SIDE = new Attribute("caption-side", "left", true);
        static final Attribute[] allAttributes = new Attribute[]{BACKGROUND, BACKGROUND_ATTACHMENT, BACKGROUND_COLOR, BACKGROUND_IMAGE, BACKGROUND_POSITION, BACKGROUND_REPEAT, BORDER, BORDER_BOTTOM, BORDER_BOTTOM_WIDTH, BORDER_COLOR, BORDER_LEFT, BORDER_LEFT_WIDTH, BORDER_RIGHT, BORDER_RIGHT_WIDTH, BORDER_STYLE, BORDER_TOP, BORDER_TOP_WIDTH, BORDER_WIDTH, CLEAR, COLOR, DISPLAY, FLOAT, FONT, FONT_FAMILY, FONT_SIZE, FONT_STYLE, FONT_VARIANT, FONT_WEIGHT, HEIGHT, LETTER_SPACING, LINE_HEIGHT, LIST_STYLE, LIST_STYLE_IMAGE, LIST_STYLE_POSITION, LIST_STYLE_TYPE, MARGIN, MARGIN_BOTTOM, MARGIN_LEFT, MARGIN_RIGHT, MARGIN_TOP, PADDING, PADDING_BOTTOM, PADDING_LEFT, PADDING_RIGHT, PADDING_TOP, TEXT_ALIGN, TEXT_DECORATION, TEXT_INDENT, TEXT_TRANSFORM, VERTICAL_ALIGN, WORD_SPACING, WHITE_SPACE, WIDTH, BORDER_SPACING, CAPTION_SIDE};
        private static final Attribute[] ALL_MARGINS = new Attribute[]{MARGIN_TOP, MARGIN_RIGHT, MARGIN_BOTTOM, MARGIN_LEFT};
        private static final Attribute[] ALL_PADDING = new Attribute[]{PADDING_TOP, PADDING_RIGHT, PADDING_BOTTOM, PADDING_LEFT};
        private static final Attribute[] ALL_BORDER_WIDTHS = new Attribute[]{BORDER_TOP_WIDTH, BORDER_RIGHT_WIDTH, BORDER_BOTTOM_WIDTH, BORDER_LEFT_WIDTH};

        public boolean isInherited() {
            return this.inherited;
        }

        public String getDefaultValue() {
            return this.defaultValue;
        }

        public String toString() {
            return this.name;
        }

        private Attribute(String string, String string2, boolean bl2) {
            this.name = string;
            this.defaultValue = string2;
            this.inherited = bl2;
        }
    }

    static class BackgroundImage
    extends CssValue {
        private boolean loadedImage;
        private ImageIcon image;

        BackgroundImage() {
        }

        Object parseCssValue(String string) {
            BackgroundImage backgroundImage = new BackgroundImage();
            backgroundImage.svalue = string;
            return backgroundImage;
        }

        Object parseHtmlValue(String string) {
            return this.parseCssValue(string);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        ImageIcon getImage(URL uRL) {
            if (!this.loadedImage) {
                BackgroundImage backgroundImage = this;
                synchronized (backgroundImage) {
                    if (!this.loadedImage) {
                        URL uRL2 = CSS.getURL(uRL, this.svalue);
                        this.loadedImage = true;
                        if (uRL2 != null) {
                            this.image = new ImageIcon(uRL2);
                        }
                    }
                }
            }
            return this.image;
        }
    }

    static class BackgroundPosition
    extends CssValue {
        float horizontalPosition;
        float verticalPosition;
        short relative;

        float getHorizontalPosition() {
            return this.horizontalPosition;
        }

        float getVerticalPosition() {
            return this.verticalPosition;
        }

        BackgroundPosition() {
        }

        boolean isHorizontalPositionRelativeToFontSize() {
            return (this.relative & 2) == 2;
        }

        boolean isHorizontalPositionRelativeToSize() {
            return (this.relative & 1) == 1;
        }

        boolean isVerticalPositionRelativeToFontSize() {
            return (this.relative & 8) == 8;
        }

        boolean isVerticalPositionRelativeToSize() {
            return (this.relative & 4) == 4;
        }

        Object parseCssValue(String string) {
            String[] stringArray = CSS.parseStrings(string);
            int n2 = stringArray.length;
            BackgroundPosition backgroundPosition = new BackgroundPosition();
            backgroundPosition.relative = (short)5;
            backgroundPosition.svalue = string;
            if (n2 > 0) {
                Object object;
                int n3 = 0;
                int n4 = 0;
                while (n4 < n2) {
                    if (((String)(object = stringArray[n4++])).equals("center")) {
                        n3 = (short)(n3 | 4);
                        continue;
                    }
                    if ((n3 & 1) == 0) {
                        if (((String)object).equals("top")) {
                            n3 = (short)(n3 | 1);
                        } else if (((String)object).equals("bottom")) {
                            n3 = (short)(n3 | 1);
                            backgroundPosition.verticalPosition = 1.0f;
                            continue;
                        }
                    }
                    if ((n3 & 2) != 0) continue;
                    if (((String)object).equals("left")) {
                        n3 = (short)(n3 | 2);
                        backgroundPosition.horizontalPosition = 0.0f;
                        continue;
                    }
                    if (!((String)object).equals("right")) continue;
                    n3 = (short)(n3 | 2);
                    backgroundPosition.horizontalPosition = 1.0f;
                }
                if (n3 != 0) {
                    if (n3 & true) {
                        if ((n3 & 2) == 0) {
                            backgroundPosition.horizontalPosition = 0.5f;
                        }
                    } else if ((n3 & 2) == 2) {
                        backgroundPosition.verticalPosition = 0.5f;
                    } else {
                        backgroundPosition.verticalPosition = 0.5f;
                        backgroundPosition.horizontalPosition = 0.5f;
                    }
                } else {
                    object = new LengthUnit(stringArray[0], 0, 0.0f);
                    if (((LengthUnit)object).type == 0) {
                        backgroundPosition.horizontalPosition = ((LengthUnit)object).value;
                        backgroundPosition.relative = (short)(1 ^ backgroundPosition.relative);
                    } else if (((LengthUnit)object).type == 1) {
                        backgroundPosition.horizontalPosition = ((LengthUnit)object).value;
                    } else if (((LengthUnit)object).type == 3) {
                        backgroundPosition.horizontalPosition = ((LengthUnit)object).value;
                        backgroundPosition.relative = (short)(1 ^ backgroundPosition.relative | 2);
                    }
                    if (n2 > 1) {
                        object = new LengthUnit(stringArray[1], 0, 0.0f);
                        if (((LengthUnit)object).type == 0) {
                            backgroundPosition.verticalPosition = ((LengthUnit)object).value;
                            backgroundPosition.relative = (short)(4 ^ backgroundPosition.relative);
                        } else if (((LengthUnit)object).type == 1) {
                            backgroundPosition.verticalPosition = ((LengthUnit)object).value;
                        } else if (((LengthUnit)object).type == 3) {
                            backgroundPosition.verticalPosition = ((LengthUnit)object).value;
                            backgroundPosition.relative = (short)(4 ^ backgroundPosition.relative | 8);
                        }
                    } else {
                        backgroundPosition.verticalPosition = 0.5f;
                    }
                }
            }
            return backgroundPosition;
        }
    }

    static class BorderStyle
    extends CssValue {
        private transient Value style;

        BorderStyle() {
        }

        private void readObject(ObjectInputStream objectInputStream) throws ClassNotFoundException, IOException {
            objectInputStream.defaultReadObject();
            Object object = objectInputStream.readObject();
            if (object != null) {
                this.style = CSS.getValue((String)object);
            }
        }

        private void writeObject(ObjectOutputStream objectOutputStream) throws IOException {
            objectOutputStream.defaultWriteObject();
            if (this.style == null) {
                objectOutputStream.writeObject(null);
            } else {
                objectOutputStream.writeObject(this.style.toString());
            }
        }

        Value getValue() {
            return this.style;
        }

        Object parseCssValue(String string) {
            Value value = CSS.getValue(string);
            if (value != null && (value == Value.INSET || value == Value.OUTSET || value == Value.NONE || value == Value.DOTTED || value == Value.DASHED || value == Value.SOLID || value == Value.DOUBLE || value == Value.GROOVE || value == Value.RIDGE)) {
                BorderStyle borderStyle = new BorderStyle();
                borderStyle.svalue = string;
                borderStyle.style = value;
                return borderStyle;
            }
            return null;
        }
    }

    static class BorderWidthValue
    extends LengthValue {
        private int index;
        private static final float[] values = new float[]{1.0f, 2.0f, 4.0f};

        float getValue() {
            return values[this.index];
        }

        float getValue(float f2) {
            return values[this.index];
        }

        BorderWidthValue(String string, int n2) {
            this.svalue = string;
            this.index = n2;
        }

        Object parseCssValue(String string) {
            if (string != null) {
                if (string.equals("thick")) {
                    return new BorderWidthValue(string, 2);
                }
                if (string.equals("medium")) {
                    return new BorderWidthValue(string, 1);
                }
                if (string.equals("thin")) {
                    return new BorderWidthValue(string, 0);
                }
            }
            return super.parseCssValue(string);
        }

        Object parseHtmlValue(String string) {
            if (string == "#DEFAULT") {
                return this.parseCssValue("medium");
            }
            return this.parseCssValue(string);
        }
    }

    static class ColorValue
    extends CssValue {
        Color c;

        ColorValue() {
        }

        Color getValue() {
            return this.c;
        }

        Object parseCssValue(String string) {
            Color color = CSS.stringToColor(string);
            if (color != null) {
                ColorValue colorValue = new ColorValue();
                colorValue.svalue = string;
                colorValue.c = color;
                return colorValue;
            }
            return null;
        }

        Object parseHtmlValue(String string) {
            return this.parseCssValue(string);
        }

        Object fromStyleConstants(StyleConstants styleConstants, Object object) {
            ColorValue colorValue = new ColorValue();
            colorValue.c = (Color)object;
            colorValue.svalue = CSS.colorToHex(colorValue.c);
            return colorValue;
        }

        Object toStyleConstants(StyleConstants styleConstants, View view) {
            return this.c;
        }
    }

    static class CssValue
    implements Serializable {
        String svalue;

        CssValue() {
        }

        public String toString() {
            return this.svalue;
        }

        Object parseCssValue(String string) {
            return string;
        }

        Object parseHtmlValue(String string) {
            return this.parseCssValue(string);
        }

        Object fromStyleConstants(StyleConstants styleConstants, Object object) {
            return null;
        }

        Object toStyleConstants(StyleConstants styleConstants, View view) {
            return null;
        }
    }

    static class CssValueMapper
    extends CssValue {
        CssValueMapper() {
        }

        Object parseCssValue(String string) {
            Object object = cssValueToInternalValueMap.get(string);
            if (object == null) {
                object = cssValueToInternalValueMap.get(string.toLowerCase());
            }
            return object;
        }

        Object parseHtmlValue(String string) {
            Object object = htmlValueToCssValueMap.get(string);
            if (object == null) {
                object = htmlValueToCssValueMap.get(string.toLowerCase());
            }
            return object;
        }
    }

    static class FontFamily
    extends CssValue {
        String family;

        FontFamily() {
        }

        String getValue() {
            return this.family;
        }

        Object parseCssValue(String string) {
            int n2 = string.indexOf(44);
            Hashtable hashtable = CSS.getValidFontNameMapping();
            FontFamily fontFamily = new FontFamily();
            fontFamily.svalue = string;
            fontFamily.family = null;
            if (n2 == -1) {
                this.setFontName(hashtable, fontFamily, string);
            } else {
                boolean bl2 = false;
                int n3 = string.length();
                n2 = 0;
                while (!bl2) {
                    while (n2 < n3 && Character.isWhitespace(string.charAt(n2))) {
                        ++n2;
                    }
                    int n4 = n2;
                    if ((n2 = string.indexOf(44, n2)) == -1) {
                        n2 = n3;
                    }
                    if (n4 < n3) {
                        if (n4 != n2) {
                            int n5 = n2;
                            if (n2 > 0 && string.charAt(n2 - 1) == ' ') {
                                --n5;
                            }
                            this.setFontName(hashtable, fontFamily, string.substring(n4, n5));
                            bl2 = fontFamily.family != null;
                        }
                        ++n2;
                        continue;
                    }
                    bl2 = true;
                }
            }
            if (fontFamily.family == null) {
                fontFamily.family = "SansSerif";
            }
            return fontFamily;
        }

        Object parseHtmlValue(String string) {
            return this.parseCssValue(string);
        }

        private String mapFontName(String string) {
            if (string.equals("monospace")) {
                return "monospaced";
            }
            return string;
        }

        Object fromStyleConstants(StyleConstants styleConstants, Object object) {
            return this.parseCssValue(object.toString());
        }

        Object toStyleConstants(StyleConstants styleConstants, View view) {
            return this.family;
        }

        private void setFontName(Hashtable hashtable, FontFamily fontFamily, String string) {
            fontFamily.family = (String)hashtable.get(this.mapFontName(string));
            if (fontFamily.family == null) {
                fontFamily.family = (String)hashtable.get(string.toLowerCase());
            }
        }
    }

    class FontSize
    extends CssValue {
        float value;
        boolean index;
        LengthUnit lu;

        float getValue(AttributeSet attributeSet) {
            AttributeSet attributeSet2;
            if (this.index) {
                return CSS.this.getPointSize((int)this.value);
            }
            if (this.lu == null) {
                return this.value;
            }
            if (this.lu.type == 0) {
                return this.lu.value;
            }
            if (attributeSet != null && (attributeSet2 = attributeSet.getResolveParent()) != null) {
                int n2 = StyleConstants.getFontSize(attributeSet2);
                float f2 = this.lu.type == 1 || this.lu.type == 3 ? this.lu.value * (float)n2 : this.lu.value + (float)n2;
                return f2;
            }
            return 12.0f;
        }

        FontSize() {
        }

        Object parseCssValue(String string) {
            FontSize fontSize = new FontSize();
            fontSize.svalue = string;
            try {
                if (string.equals("xx-small")) {
                    fontSize.value = 1.0f;
                    fontSize.index = true;
                } else if (string.equals("x-small")) {
                    fontSize.value = 2.0f;
                    fontSize.index = true;
                } else if (string.equals("small")) {
                    fontSize.value = 3.0f;
                    fontSize.index = true;
                } else if (string.equals("medium")) {
                    fontSize.value = 4.0f;
                    fontSize.index = true;
                } else if (string.equals("large")) {
                    fontSize.value = 5.0f;
                    fontSize.index = true;
                } else if (string.equals("x-large")) {
                    fontSize.value = 6.0f;
                    fontSize.index = true;
                } else if (string.equals("xx-large")) {
                    fontSize.value = 7.0f;
                    fontSize.index = true;
                } else {
                    fontSize.lu = new LengthUnit(string, 1, 1.0f);
                }
            }
            catch (NumberFormatException numberFormatException) {
                fontSize = null;
            }
            return fontSize;
        }

        Object parseHtmlValue(String string) {
            FontSize fontSize = new FontSize();
            fontSize.svalue = string;
            try {
                int n2 = CSS.this.getBaseFontSize();
                if (string != null && string.charAt(0) == '+') {
                    int n3 = Integer.valueOf(string.substring(1));
                    fontSize.value = n2 + n3;
                    fontSize.index = true;
                } else if (string != null && string.charAt(0) == '-') {
                    int n4 = -Integer.valueOf(string.substring(1)).intValue();
                    fontSize.value = n2 + n4;
                    fontSize.index = true;
                } else {
                    fontSize.value = Integer.parseInt(string);
                    if (fontSize.value > 7.0f) {
                        fontSize.value = 7.0f;
                    } else if (fontSize.value < 0.0f) {
                        fontSize.value = 0.0f;
                    }
                    fontSize.index = true;
                }
            }
            catch (NumberFormatException numberFormatException) {
                fontSize = null;
            }
            return fontSize;
        }

        Object fromStyleConstants(StyleConstants styleConstants, Object object) {
            if (object instanceof Number) {
                FontSize fontSize = new FontSize();
                fontSize.value = CSS.getIndexOfSize(((Number)object).floatValue());
                fontSize.svalue = Integer.toString((int)fontSize.value);
                fontSize.index = true;
                return fontSize;
            }
            return this.parseCssValue(object.toString());
        }

        Object toStyleConstants(StyleConstants styleConstants, View view) {
            if (view != null) {
                return new Integer((int)this.getValue(view.getAttributes()));
            }
            return new Integer((int)this.getValue(null));
        }
    }

    static class FontWeight
    extends CssValue {
        int weight;

        int getValue() {
            return this.weight;
        }

        FontWeight() {
        }

        boolean isBold() {
            return this.weight > 500;
        }

        Object parseCssValue(String string) {
            FontWeight fontWeight = new FontWeight();
            fontWeight.svalue = string;
            if (string.equals("bold")) {
                fontWeight.weight = 700;
            } else if (string.equals("normal")) {
                fontWeight.weight = 400;
            } else {
                try {
                    fontWeight.weight = Integer.parseInt(string);
                }
                catch (NumberFormatException numberFormatException) {
                    fontWeight = null;
                }
            }
            return fontWeight;
        }

        Object fromStyleConstants(StyleConstants styleConstants, Object object) {
            if (object.equals(Boolean.TRUE)) {
                return this.parseCssValue("bold");
            }
            return this.parseCssValue("normal");
        }

        Object toStyleConstants(StyleConstants styleConstants, View view) {
            return this.weight > 500 ? Boolean.TRUE : Boolean.FALSE;
        }
    }

    static interface LayoutIterator {
        public static final int WorstAdjustmentWeight = 1;

        public float getLeadingCollapseSpan();

        public float getTrailingCollapseSpan();

        public int getAdjustmentWeight();

        public int getCount();

        public int getOffset();

        public int getSpan();

        public float getMaximumSpan(float var1);

        public float getMinimumSpan(float var1);

        public float getPreferredSpan(float var1);

        public void setIndex(int var1);

        public void setOffset(int var1);

        public void setSpan(int var1);
    }

    static class LengthUnit
    implements Serializable {
        static Hashtable lengthMapping = new Hashtable(6);
        short type;
        float value;
        static final short UNINITALIZED_LENGTH = 10;

        static {
            lengthMapping.put("pt", new Float(1.0f));
            lengthMapping.put("px", new Float(1.3f));
            lengthMapping.put("mm", new Float(2.83464f));
            lengthMapping.put("cm", new Float(28.3464f));
            lengthMapping.put("pc", new Float(12.0f));
            lengthMapping.put("in", new Float(72.0f));
        }

        public String toString() {
            return this.type + " " + this.value;
        }

        LengthUnit(String string, short s2, float f2) {
            this.parse(string, s2, f2);
        }

        void parse(String string, short s2, float f2) {
            this.type = s2;
            this.value = f2;
            int n2 = string.length();
            if (n2 > 0 && string.charAt(n2 - 1) == '%') {
                try {
                    this.value = Float.valueOf(string.substring(0, n2 - 1)).floatValue() / 100.0f;
                    this.type = 1;
                }
                catch (NumberFormatException numberFormatException) {
                    // empty catch block
                }
            }
            if (n2 >= 2) {
                String string2 = string.substring(n2 - 2, n2);
                Float f3 = (Float)lengthMapping.get(string2);
                if (f3 != null) {
                    try {
                        this.value = Float.valueOf(string.substring(0, n2 - 2)).floatValue() * f3.floatValue();
                        this.type = 0;
                    }
                    catch (NumberFormatException numberFormatException) {}
                } else if (string2.equals("em") || string2.equals("ex")) {
                    try {
                        this.value = Float.valueOf(string.substring(0, n2 - 2)).floatValue();
                        this.type = (short)3;
                    }
                    catch (NumberFormatException numberFormatException) {}
                } else if (string.equals("larger")) {
                    this.value = 2.0f;
                    this.type = (short)2;
                } else if (string.equals("smaller")) {
                    this.value = -2.0f;
                    this.type = (short)2;
                } else {
                    try {
                        this.value = Float.valueOf(string).floatValue();
                        this.type = 0;
                    }
                    catch (NumberFormatException numberFormatException) {}
                }
            } else if (n2 > 0) {
                try {
                    this.value = Float.valueOf(string).floatValue();
                    this.type = 0;
                }
                catch (NumberFormatException numberFormatException) {
                    // empty catch block
                }
            }
        }
    }

    static class LengthValue
    extends CssValue {
        boolean percentage;
        float span;

        float getValue() {
            return this.getValue(0.0f);
        }

        LengthValue() {
        }

        boolean isPercentage() {
            return this.percentage;
        }

        float getValue(float f2) {
            if (this.percentage) {
                return this.span * f2;
            }
            return this.span;
        }

        Object parseCssValue(String string) {
            LengthValue lengthValue;
            try {
                float f2 = Float.valueOf(string).floatValue();
                lengthValue = new LengthValue();
                lengthValue.span = f2;
            }
            catch (NumberFormatException numberFormatException) {
                LengthUnit lengthUnit = new LengthUnit(string, 10, 0.0f);
                switch (lengthUnit.type) {
                    case 0: {
                        lengthValue = new LengthValue();
                        lengthValue.span = Math.max(0.0f, lengthUnit.value);
                        break;
                    }
                    case 1: {
                        lengthValue = new LengthValue();
                        lengthValue.span = Math.max(0.0f, Math.min(1.0f, lengthUnit.value));
                        lengthValue.percentage = true;
                        break;
                    }
                    default: {
                        return null;
                    }
                }
            }
            lengthValue.svalue = string;
            return lengthValue;
        }

        Object parseHtmlValue(String string) {
            if (string.equals("#DEFAULT")) {
                string = "1";
            }
            return this.parseCssValue(string);
        }

        Object fromStyleConstants(StyleConstants styleConstants, Object object) {
            LengthValue lengthValue = new LengthValue();
            lengthValue.svalue = object.toString();
            lengthValue.span = ((Float)object).floatValue();
            return lengthValue;
        }

        Object toStyleConstants(StyleConstants styleConstants, View view) {
            return new Float(this.getValue());
        }
    }

    static class ShorthandBackgroundParser {
        ShorthandBackgroundParser() {
        }

        static boolean isAttachment(String string) {
            return string.equals("fixed") || string.equals("scroll");
        }

        static boolean isColor(String string) {
            return CSS.stringToColor(string) != null;
        }

        static boolean isImage(String string) {
            return string.startsWith("url(") && string.endsWith(")");
        }

        static boolean isPosition(String string) {
            return string.equals("top") || string.equals("bottom") || string.equals("left") || string.equals("right") || string.equals("center") || string.length() > 0 && Character.isDigit(string.charAt(0));
        }

        static boolean isRepeat(String string) {
            return string.equals("repeat-x") || string.equals("repeat-y") || string.equals("repeat") || string.equals("no-repeat");
        }

        static void parseShorthandBackground(CSS cSS, String string, MutableAttributeSet mutableAttributeSet) {
            String[] stringArray = CSS.parseStrings(string);
            int n2 = stringArray.length;
            int n3 = 0;
            int n4 = 0;
            while (n3 < n2) {
                String string2 = stringArray[n3++];
                if ((n4 & 1) == 0 && ShorthandBackgroundParser.isImage(string2)) {
                    cSS.addInternalCSSValue(mutableAttributeSet, Attribute.BACKGROUND_IMAGE, string2);
                    n4 = (short)(n4 | 1);
                    continue;
                }
                if ((n4 & 2) == 0 && ShorthandBackgroundParser.isRepeat(string2)) {
                    cSS.addInternalCSSValue(mutableAttributeSet, Attribute.BACKGROUND_REPEAT, string2);
                    n4 = (short)(n4 | 2);
                    continue;
                }
                if ((n4 & 4) == 0 && ShorthandBackgroundParser.isAttachment(string2)) {
                    cSS.addInternalCSSValue(mutableAttributeSet, Attribute.BACKGROUND_ATTACHMENT, string2);
                    n4 = (short)(n4 | 4);
                    continue;
                }
                if ((n4 & 8) == 0 && ShorthandBackgroundParser.isPosition(string2)) {
                    if (n3 < n2 && ShorthandBackgroundParser.isPosition(stringArray[n3])) {
                        cSS.addInternalCSSValue(mutableAttributeSet, Attribute.BACKGROUND_POSITION, string2 + " " + stringArray[n3++]);
                    } else {
                        cSS.addInternalCSSValue(mutableAttributeSet, Attribute.BACKGROUND_POSITION, string2);
                    }
                    n4 = (short)(n4 | 8);
                    continue;
                }
                if ((n4 & 0x10) != 0 || !ShorthandBackgroundParser.isColor(string2)) continue;
                cSS.addInternalCSSValue(mutableAttributeSet, Attribute.BACKGROUND_COLOR, string2);
                n4 = (short)(n4 | 0x10);
            }
            if (!(n4 & true)) {
                cSS.addInternalCSSValue(mutableAttributeSet, Attribute.BACKGROUND_IMAGE, null);
            }
            if ((n4 & 2) == 0) {
                cSS.addInternalCSSValue(mutableAttributeSet, Attribute.BACKGROUND_REPEAT, "repeat");
            }
            if ((n4 & 4) == 0) {
                cSS.addInternalCSSValue(mutableAttributeSet, Attribute.BACKGROUND_ATTACHMENT, "scroll");
            }
            if ((n4 & 8) == 0) {
                cSS.addInternalCSSValue(mutableAttributeSet, Attribute.BACKGROUND_POSITION, null);
            }
        }
    }

    static class ShorthandFontParser {
        ShorthandFontParser() {
        }

        private static boolean isFontStyle(String string) {
            return string.equals("italic") || string.equals("oblique");
        }

        private static boolean isFontVariant(String string) {
            return string.equals("small-caps");
        }

        private static boolean isFontWeight(String string) {
            if (string.equals("bold") || string.equals("bolder") || string.equals("italic") || string.equals("lighter")) {
                return true;
            }
            return string.length() == 3 && string.charAt(0) >= '1' && string.charAt(0) <= '9' && string.charAt(1) == '0' && string.charAt(2) == '0';
        }

        static void parseShorthandFont(CSS cSS, String string, MutableAttributeSet mutableAttributeSet) {
            String string2;
            String[] stringArray = CSS.parseStrings(string);
            int n2 = stringArray.length;
            int n3 = 0;
            int n4 = 0;
            int n5 = Math.min(3, n2);
            while (n3 < n5) {
                if (!(n4 & true) && ShorthandFontParser.isFontStyle(stringArray[n3])) {
                    cSS.addInternalCSSValue(mutableAttributeSet, Attribute.FONT_STYLE, stringArray[n3++]);
                    n4 = (short)(n4 | 1);
                    continue;
                }
                if ((n4 & 2) == 0 && ShorthandFontParser.isFontVariant(stringArray[n3])) {
                    cSS.addInternalCSSValue(mutableAttributeSet, Attribute.FONT_VARIANT, stringArray[n3++]);
                    n4 = (short)(n4 | 2);
                    continue;
                }
                if ((n4 & 4) == 0 && ShorthandFontParser.isFontWeight(stringArray[n3])) {
                    cSS.addInternalCSSValue(mutableAttributeSet, Attribute.FONT_WEIGHT, stringArray[n3++]);
                    n4 = (short)(n4 | 4);
                    continue;
                }
                if (!stringArray[n3].equals("normal")) break;
                ++n3;
            }
            if (!(n4 & true)) {
                cSS.addInternalCSSValue(mutableAttributeSet, Attribute.FONT_STYLE, "normal");
            }
            if ((n4 & 2) == 0) {
                cSS.addInternalCSSValue(mutableAttributeSet, Attribute.FONT_VARIANT, "normal");
            }
            if ((n4 & 4) == 0) {
                cSS.addInternalCSSValue(mutableAttributeSet, Attribute.FONT_WEIGHT, "normal");
            }
            if (n3 < n2) {
                string2 = stringArray[n3];
                int n6 = string2.indexOf(47);
                if (n6 != -1) {
                    string2 = string2.substring(0, n6);
                    stringArray[n3] = stringArray[n3].substring(n6);
                } else {
                    ++n3;
                }
                cSS.addInternalCSSValue(mutableAttributeSet, Attribute.FONT_SIZE, string2);
            } else {
                cSS.addInternalCSSValue(mutableAttributeSet, Attribute.FONT_SIZE, "medium");
            }
            if (n3 < n2 && stringArray[n3].startsWith("/")) {
                string2 = null;
                if (stringArray[n3].equals("/")) {
                    if (++n3 < n2) {
                        string2 = stringArray[n3++];
                    }
                } else {
                    string2 = stringArray[n3++].substring(1);
                }
                if (string2 != null) {
                    cSS.addInternalCSSValue(mutableAttributeSet, Attribute.LINE_HEIGHT, string2);
                } else {
                    cSS.addInternalCSSValue(mutableAttributeSet, Attribute.LINE_HEIGHT, "normal");
                }
            } else {
                cSS.addInternalCSSValue(mutableAttributeSet, Attribute.LINE_HEIGHT, "normal");
            }
            if (n3 < n2) {
                string2 = stringArray[n3++];
                while (n3 < n2) {
                    string2 = string2 + " " + stringArray[n3++];
                }
                cSS.addInternalCSSValue(mutableAttributeSet, Attribute.FONT_FAMILY, string2);
            } else {
                cSS.addInternalCSSValue(mutableAttributeSet, Attribute.FONT_FAMILY, "SansSerif");
            }
        }
    }

    static class ShorthandMarginParser {
        ShorthandMarginParser() {
        }

        static void parseShorthandMargin(CSS cSS, String string, MutableAttributeSet mutableAttributeSet, Attribute[] attributeArray) {
            String[] stringArray = CSS.parseStrings(string);
            int n2 = stringArray.length;
            boolean bl2 = false;
            switch (n2) {
                case 0: {
                    return;
                }
                case 1: {
                    for (int i2 = 0; i2 < 4; ++i2) {
                        cSS.addInternalCSSValue(mutableAttributeSet, attributeArray[i2], stringArray[0]);
                    }
                    break;
                }
                case 2: {
                    cSS.addInternalCSSValue(mutableAttributeSet, attributeArray[0], stringArray[0]);
                    cSS.addInternalCSSValue(mutableAttributeSet, attributeArray[2], stringArray[0]);
                    cSS.addInternalCSSValue(mutableAttributeSet, attributeArray[1], stringArray[1]);
                    cSS.addInternalCSSValue(mutableAttributeSet, attributeArray[3], stringArray[1]);
                    break;
                }
                case 3: {
                    cSS.addInternalCSSValue(mutableAttributeSet, attributeArray[0], stringArray[0]);
                    cSS.addInternalCSSValue(mutableAttributeSet, attributeArray[1], stringArray[1]);
                    cSS.addInternalCSSValue(mutableAttributeSet, attributeArray[2], stringArray[2]);
                    cSS.addInternalCSSValue(mutableAttributeSet, attributeArray[3], stringArray[1]);
                    break;
                }
                default: {
                    for (int i3 = 0; i3 < 4; ++i3) {
                        cSS.addInternalCSSValue(mutableAttributeSet, attributeArray[i3], stringArray[i3]);
                    }
                }
            }
        }
    }

    static class StringValue
    extends CssValue {
        StringValue() {
        }

        boolean isItalic() {
            return this.svalue.indexOf("italic") != -1;
        }

        boolean isStrike() {
            return this.svalue.indexOf("line-through") != -1;
        }

        boolean isSub() {
            return this.svalue.indexOf("sub") != -1;
        }

        boolean isSup() {
            return this.svalue.indexOf("sup") != -1;
        }

        boolean isUnderline() {
            return this.svalue.indexOf("underline") != -1;
        }

        Object parseCssValue(String string) {
            StringValue stringValue = new StringValue();
            stringValue.svalue = string;
            return stringValue;
        }

        Object fromStyleConstants(StyleConstants styleConstants, Object object) {
            if (styleConstants == StyleConstants.Italic) {
                if (object.equals(Boolean.TRUE)) {
                    return this.parseCssValue("italic");
                }
                return this.parseCssValue("");
            }
            if (styleConstants == StyleConstants.Underline) {
                if (object.equals(Boolean.TRUE)) {
                    return this.parseCssValue("underline");
                }
                return this.parseCssValue("");
            }
            if (styleConstants == StyleConstants.Alignment) {
                String string;
                int n2 = (Integer)object;
                switch (n2) {
                    case 0: {
                        string = "left";
                        break;
                    }
                    case 2: {
                        string = "right";
                        break;
                    }
                    case 1: {
                        string = "center";
                        break;
                    }
                    case 3: {
                        string = "justify";
                        break;
                    }
                    default: {
                        string = "left";
                    }
                }
                return this.parseCssValue(string);
            }
            if (styleConstants == StyleConstants.StrikeThrough) {
                if (object.equals(Boolean.TRUE)) {
                    return this.parseCssValue("line-through");
                }
                return this.parseCssValue("");
            }
            if (styleConstants == StyleConstants.Superscript) {
                if (object.equals(Boolean.TRUE)) {
                    return this.parseCssValue("super");
                }
                return this.parseCssValue("");
            }
            if (styleConstants == StyleConstants.Subscript) {
                if (object.equals(Boolean.TRUE)) {
                    return this.parseCssValue("sub");
                }
                return this.parseCssValue("");
            }
            return null;
        }

        Object toStyleConstants(StyleConstants styleConstants, View view) {
            if (styleConstants == StyleConstants.Italic) {
                if (this.svalue.indexOf("italic") >= 0) {
                    return Boolean.TRUE;
                }
                return Boolean.FALSE;
            }
            if (styleConstants == StyleConstants.Underline) {
                if (this.svalue.indexOf("underline") >= 0) {
                    return Boolean.TRUE;
                }
                return Boolean.FALSE;
            }
            if (styleConstants == StyleConstants.Alignment) {
                if (this.svalue.equals("right")) {
                    return new Integer(2);
                }
                if (this.svalue.equals("center")) {
                    return new Integer(1);
                }
                if (this.svalue.equals("justify")) {
                    return new Integer(3);
                }
                return new Integer(0);
            }
            if (styleConstants == StyleConstants.StrikeThrough) {
                if (this.svalue.indexOf("line-through") >= 0) {
                    return Boolean.TRUE;
                }
                return Boolean.FALSE;
            }
            if (styleConstants == StyleConstants.Superscript) {
                if (this.svalue.indexOf("super") >= 0) {
                    return Boolean.TRUE;
                }
                return Boolean.FALSE;
            }
            if (styleConstants == StyleConstants.Subscript) {
                if (this.svalue.indexOf("sub") >= 0) {
                    return Boolean.TRUE;
                }
                return Boolean.FALSE;
            }
            return null;
        }
    }

    static final class Value {
        static final Value INHERITED = new Value("inherited");
        static final Value NONE = new Value("none");
        static final Value DOTTED = new Value("dotted");
        static final Value DASHED = new Value("dashed");
        static final Value SOLID = new Value("solid");
        static final Value DOUBLE = new Value("double");
        static final Value GROOVE = new Value("groove");
        static final Value RIDGE = new Value("ridge");
        static final Value INSET = new Value("inset");
        static final Value OUTSET = new Value("outset");
        static final Value BLANK_LIST_ITEM = new Value("none");
        static final Value DISC = new Value("disc");
        static final Value CIRCLE = new Value("circle");
        static final Value SQUARE = new Value("square");
        static final Value DECIMAL = new Value("decimal");
        static final Value LOWER_ROMAN = new Value("lower-roman");
        static final Value UPPER_ROMAN = new Value("upper-roman");
        static final Value LOWER_ALPHA = new Value("lower-alpha");
        static final Value UPPER_ALPHA = new Value("upper-alpha");
        static final Value BACKGROUND_NO_REPEAT = new Value("no-repeat");
        static final Value BACKGROUND_REPEAT = new Value("repeat");
        static final Value BACKGROUND_REPEAT_X = new Value("repeat-x");
        static final Value BACKGROUND_REPEAT_Y = new Value("repeat-y");
        static final Value BACKGROUND_SCROLL = new Value("scroll");
        static final Value BACKGROUND_FIXED = new Value("fixed");
        private String name;
        static final Value[] allValues = new Value[]{INHERITED, NONE, DOTTED, DASHED, SOLID, DOUBLE, GROOVE, RIDGE, INSET, OUTSET, DISC, CIRCLE, SQUARE, DECIMAL, LOWER_ROMAN, UPPER_ROMAN, LOWER_ALPHA, UPPER_ALPHA, BLANK_LIST_ITEM, BACKGROUND_NO_REPEAT, BACKGROUND_REPEAT, BACKGROUND_REPEAT_X, BACKGROUND_REPEAT_Y, BACKGROUND_FIXED, BACKGROUND_FIXED};

        public String toString() {
            return this.name;
        }

        private Value(String string) {
            this.name = string;
        }
    }
}

