/*
 * Decompiled with CFR 0.152.
 */
package sun.awt.image;

import java.awt.Point;
import java.awt.Rectangle;
import java.awt.image.ComponentSampleModel;
import java.awt.image.DataBuffer;
import java.awt.image.DataBufferUShort;
import java.awt.image.PixelInterleavedSampleModel;
import java.awt.image.Raster;
import java.awt.image.RasterFormatException;
import java.awt.image.SampleModel;
import java.awt.image.SinglePixelPackedSampleModel;
import java.awt.image.WritableRaster;
import sun.awt.image.ShortComponentRaster;

public class ShortInterleavedRaster
extends ShortComponentRaster {
    private int maxX;
    private int maxY;

    public int getPixelStride() {
        return this.pixelStride;
    }

    public int getScanlineStride() {
        return this.scanlineStride;
    }

    public int[] getDataOffsets() {
        return (int[])this.dataOffsets.clone();
    }

    public short[] getDataStorage() {
        return this.data;
    }

    public int getDataOffset(int n2) {
        return this.dataOffsets[n2];
    }

    public void putShortData(int n2, int n3, int n4, int n5, int n6, short[] sArray) {
        if (n2 < this.minX || n3 < this.minY || n2 + n4 > this.maxX || n3 + n5 > this.maxY) {
            throw new ArrayIndexOutOfBoundsException("Coordinate out of bounds!");
        }
        int n7 = (n3 - this.minY) * this.scanlineStride + (n2 - this.minX) * this.pixelStride + this.dataOffsets[n6];
        int n8 = 0;
        if (this.pixelStride == 1) {
            if (this.scanlineStride == n4) {
                System.arraycopy(sArray, 0, this.data, n7, n4 * n5);
            } else {
                int n9 = 0;
                while (n9 < n5) {
                    System.arraycopy(sArray, n8, this.data, n7, n4);
                    n8 += n4;
                    ++n9;
                    n7 += this.scanlineStride;
                }
            }
        } else {
            int n10 = 0;
            while (n10 < n5) {
                int n11 = n7;
                int n12 = 0;
                while (n12 < n4) {
                    this.data[n11] = sArray[n8++];
                    ++n12;
                    n11 += this.pixelStride;
                }
                ++n10;
                n7 += this.scanlineStride;
            }
        }
        this.notifyChanged();
    }

    public short[] getShortData(int n2, int n3, int n4, int n5, int n6, short[] sArray) {
        if (n2 < this.minX || n3 < this.minY || n2 + n4 > this.maxX || n3 + n5 > this.maxY) {
            throw new ArrayIndexOutOfBoundsException("Coordinate out of bounds!");
        }
        if (sArray == null) {
            sArray = new short[this.numDataElements * n4 * n5];
        }
        int n7 = (n3 - this.minY) * this.scanlineStride + (n2 - this.minX) * this.pixelStride + this.dataOffsets[n6];
        int n8 = 0;
        if (this.pixelStride == 1) {
            if (this.scanlineStride == n4) {
                System.arraycopy(this.data, n7, sArray, 0, n4 * n5);
            } else {
                int n9 = 0;
                while (n9 < n5) {
                    System.arraycopy(this.data, n7, sArray, n8, n4);
                    n8 += n4;
                    ++n9;
                    n7 += this.scanlineStride;
                }
            }
        } else {
            int n10 = 0;
            while (n10 < n5) {
                int n11 = n7;
                int n12 = 0;
                while (n12 < n4) {
                    sArray[n8++] = this.data[n11];
                    ++n12;
                    n11 += this.pixelStride;
                }
                ++n10;
                n7 += this.scanlineStride;
            }
        }
        return sArray;
    }

    public void putShortData(int n2, int n3, int n4, int n5, short[] sArray) {
        if (n2 < this.minX || n3 < this.minY || n2 + n4 > this.maxX || n3 + n5 > this.maxY) {
            throw new ArrayIndexOutOfBoundsException("Coordinate out of bounds!");
        }
        int n6 = (n3 - this.minY) * this.scanlineStride + (n2 - this.minX) * this.pixelStride;
        int n7 = 0;
        int n8 = 0;
        while (n8 < n5) {
            int n9 = n6;
            int n10 = 0;
            while (n10 < n4) {
                for (int i2 = 0; i2 < this.numDataElements; ++i2) {
                    this.data[this.dataOffsets[i2] + n9] = sArray[n7++];
                }
                ++n10;
                n9 += this.pixelStride;
            }
            ++n8;
            n6 += this.scanlineStride;
        }
        this.notifyChanged();
    }

    public short[] getShortData(int n2, int n3, int n4, int n5, short[] sArray) {
        if (n2 < this.minX || n3 < this.minY || n2 + n4 > this.maxX || n3 + n5 > this.maxY) {
            throw new ArrayIndexOutOfBoundsException("Coordinate out of bounds!");
        }
        if (sArray == null) {
            sArray = new short[this.numDataElements * n4 * n5];
        }
        int n6 = (n3 - this.minY) * this.scanlineStride + (n2 - this.minX) * this.pixelStride;
        int n7 = 0;
        int n8 = 0;
        while (n8 < n5) {
            int n9 = n6;
            int n10 = 0;
            while (n10 < n4) {
                for (int i2 = 0; i2 < this.numDataElements; ++i2) {
                    sArray[n7++] = this.data[this.dataOffsets[i2] + n9];
                }
                ++n10;
                n9 += this.pixelStride;
            }
            ++n8;
            n6 += this.scanlineStride;
        }
        return sArray;
    }

    private void verify(boolean bl2) {
        int n2 = 0;
        for (int i2 = 0; i2 < this.numDataElements; ++i2) {
            int n3 = (this.height - 1) * this.scanlineStride + (this.width - 1) * this.pixelStride + this.dataOffsets[i2];
            if (n3 <= n2) continue;
            n2 = n3;
        }
        if (this.data.length < n2) {
            throw new RasterFormatException("Data array too small (should be " + n2 + " )");
        }
    }

    public Raster createChild(int n2, int n3, int n4, int n5, int n6, int n7, int[] nArray) {
        WritableRaster writableRaster = this.createWritableChild(n2, n3, n4, n5, n6, n7, nArray);
        return writableRaster;
    }

    private void setDataElements(int n2, int n3, int n4, int n5, Raster raster) {
        if (n4 <= 0 || n5 <= 0) {
            return;
        }
        int n6 = raster.getMinX();
        int n7 = raster.getMinY();
        Object object = null;
        for (int i2 = 0; i2 < n5; ++i2) {
            object = raster.getDataElements(n6, n7 + i2, n4, 1, object);
            this.setDataElements(n2, n3 + i2, n4, 1, object);
        }
    }

    public void setDataElements(int n2, int n3, Raster raster) {
        int n4 = n2 + raster.getMinX();
        int n5 = n3 + raster.getMinY();
        int n6 = raster.getWidth();
        int n7 = raster.getHeight();
        if (n4 < this.minX || n5 < this.minY || n4 + n6 > this.maxX || n5 + n7 > this.maxY) {
            throw new ArrayIndexOutOfBoundsException("Coordinate out of bounds!");
        }
        this.setDataElements(n4, n5, n6, n7, raster);
    }

    public WritableRaster createCompatibleWritableRaster() {
        return this.createCompatibleWritableRaster(this.width, this.height);
    }

    public WritableRaster createCompatibleWritableRaster(int n2, int n3) {
        if (n2 <= 0 || n3 <= 0) {
            throw new RasterFormatException("negative " + (n2 <= 0 ? "width" : "height"));
        }
        SampleModel sampleModel = this.sampleModel.createCompatibleSampleModel(n2, n3);
        return new ShortInterleavedRaster(sampleModel, new Point(0, 0));
    }

    public WritableRaster createWritableChild(int n2, int n3, int n4, int n5, int n6, int n7, int[] nArray) {
        if (n2 < this.minX) {
            throw new RasterFormatException("x lies outside the raster");
        }
        if (n3 < this.minY) {
            throw new RasterFormatException("y lies outside the raster");
        }
        if (n2 + n4 < n2 || n2 + n4 > this.minX + this.width) {
            throw new RasterFormatException("(x + width) is outside of Raster");
        }
        if (n3 + n5 < n3 || n3 + n5 > this.minY + this.height) {
            throw new RasterFormatException("(y + height) is outside of Raster");
        }
        SampleModel sampleModel = nArray != null ? this.sampleModel.createSubsetSampleModel(nArray) : this.sampleModel;
        int n8 = n6 - n2;
        int n9 = n7 - n3;
        this.notifyStolen();
        return new ShortInterleavedRaster(sampleModel, this.dataBuffer, new Rectangle(n6, n7, n4, n5), new Point(this.sampleModelTranslateX + n8, this.sampleModelTranslateY + n9), this);
    }

    public void setDataElements(int n2, int n3, int n4, int n5, Object object) {
        if (n2 < this.minX || n3 < this.minY || n2 + n4 > this.maxX || n3 + n5 > this.maxY) {
            throw new ArrayIndexOutOfBoundsException("Coordinate out of bounds!");
        }
        short[] sArray = (short[])object;
        int n6 = (n3 - this.minY) * this.scanlineStride + (n2 - this.minX) * this.pixelStride;
        int n7 = 0;
        int n8 = 0;
        while (n8 < n5) {
            int n9 = n6;
            int n10 = 0;
            while (n10 < n4) {
                for (int i2 = 0; i2 < this.numDataElements; ++i2) {
                    this.data[this.dataOffsets[i2] + n9] = sArray[n7++];
                }
                ++n10;
                n9 += this.pixelStride;
            }
            ++n8;
            n6 += this.scanlineStride;
        }
        this.notifyChanged();
    }

    public void setDataElements(int n2, int n3, Object object) {
        if (n2 < this.minX || n3 < this.minY || n2 >= this.maxX || n3 >= this.maxY) {
            throw new ArrayIndexOutOfBoundsException("Coordinate out of bounds!");
        }
        short[] sArray = (short[])object;
        int n4 = (n3 - this.minY) * this.scanlineStride + (n2 - this.minX) * this.pixelStride;
        for (int i2 = 0; i2 < this.numDataElements; ++i2) {
            this.data[this.dataOffsets[i2] + n4] = sArray[i2];
        }
        this.notifyChanged();
    }

    public String toString() {
        return new String("ShortInterleavedRaster: width = " + this.width + " height = " + this.height + " #numDataElements " + this.numDataElements);
    }

    public ShortInterleavedRaster(SampleModel sampleModel, Point point) {
        this(sampleModel, sampleModel.createDataBuffer(), new Rectangle(point.x, point.y, sampleModel.getWidth(), sampleModel.getHeight()), point, null);
    }

    public Object getDataElements(int n2, int n3, int n4, int n5, Object object) {
        if (n2 < this.minX || n3 < this.minY || n2 + n4 > this.maxX || n3 + n5 > this.maxY) {
            throw new ArrayIndexOutOfBoundsException("Coordinate out of bounds!");
        }
        short[] sArray = object == null ? new short[n4 * n5 * this.numDataElements] : (short[])object;
        int n6 = (n3 - this.minY) * this.scanlineStride + (n2 - this.minX) * this.pixelStride;
        int n7 = 0;
        int n8 = 0;
        while (n8 < n5) {
            int n9 = n6;
            int n10 = 0;
            while (n10 < n4) {
                for (int i2 = 0; i2 < this.numDataElements; ++i2) {
                    sArray[n7++] = this.data[this.dataOffsets[i2] + n9];
                }
                ++n10;
                n9 += this.pixelStride;
            }
            ++n8;
            n6 += this.scanlineStride;
        }
        return sArray;
    }

    public Object getDataElements(int n2, int n3, Object object) {
        if (n2 < this.minX || n3 < this.minY || n2 >= this.maxX || n3 >= this.maxY) {
            throw new ArrayIndexOutOfBoundsException("Coordinate out of bounds!");
        }
        short[] sArray = object == null ? new short[this.numDataElements] : (short[])object;
        int n4 = (n3 - this.minY) * this.scanlineStride + (n2 - this.minX) * this.pixelStride;
        for (int i2 = 0; i2 < this.numDataElements; ++i2) {
            sArray[i2] = this.data[this.dataOffsets[i2] + n4];
        }
        return sArray;
    }

    public ShortInterleavedRaster(SampleModel sampleModel, DataBuffer dataBuffer, Point point) {
        this(sampleModel, dataBuffer, new Rectangle(point.x, point.y, sampleModel.getWidth(), sampleModel.getHeight()), point, null);
    }

    public ShortInterleavedRaster(SampleModel sampleModel, DataBuffer dataBuffer, Rectangle rectangle, Point point, ShortInterleavedRaster shortInterleavedRaster) {
        super(sampleModel, dataBuffer, rectangle, point, shortInterleavedRaster);
        this.maxX = this.minX + this.width;
        this.maxY = this.minY + this.height;
        if (!(dataBuffer instanceof DataBufferUShort)) {
            throw new RasterFormatException("ShortInterleavedRasters must have ushort DataBuffers");
        }
        DataBufferUShort dataBufferUShort = (DataBufferUShort)dataBuffer;
        this.data = dataBufferUShort.getData();
        if (sampleModel instanceof PixelInterleavedSampleModel || sampleModel instanceof ComponentSampleModel && sampleModel.getNumBands() == 1) {
            ComponentSampleModel componentSampleModel = (ComponentSampleModel)sampleModel;
            this.scanlineStride = componentSampleModel.getScanlineStride();
            this.pixelStride = componentSampleModel.getPixelStride();
            this.dataOffsets = componentSampleModel.getBandOffsets();
            int n2 = rectangle.x - point.x;
            int n3 = rectangle.y - point.y;
            int n4 = 0;
            while (n4 < this.getNumDataElements()) {
                int n5 = n4++;
                this.dataOffsets[n5] = this.dataOffsets[n5] + (n2 * this.pixelStride + n3 * this.scanlineStride);
            }
        } else if (sampleModel instanceof SinglePixelPackedSampleModel) {
            SinglePixelPackedSampleModel singlePixelPackedSampleModel = (SinglePixelPackedSampleModel)sampleModel;
            this.scanlineStride = singlePixelPackedSampleModel.getScanlineStride();
            this.pixelStride = 1;
            this.dataOffsets = new int[1];
            this.dataOffsets[0] = dataBufferUShort.getOffset();
            int n6 = rectangle.x - point.x;
            int n7 = rectangle.y - point.y;
            this.dataOffsets[0] = this.dataOffsets[0] + (n6 + n7 * this.scanlineStride);
        } else {
            throw new RasterFormatException("ShortInterleavedRasters must have PixelInterleavedSampleModel, SinglePixelPackedSampleModel or 1 band ComponentSampleModel.  Sample model is " + sampleModel);
        }
        this.bandOffset = this.dataOffsets[0];
        this.verify(false);
    }
}

