/*
 * Decompiled with CFR 0.152.
 */
package net.java.games.input;

import java.io.IOException;
import net.java.games.input.Component;
import net.java.games.input.ControllerEnvironment;
import net.java.games.input.DIEffectInfo;
import net.java.games.input.Rumbler;

final class IDirectInputEffect
implements Rumbler {
    final DIEffectInfo info;
    private final long address;
    private boolean released;

    public IDirectInputEffect(long l2, DIEffectInfo dIEffectInfo) {
        this.address = l2;
        this.info = dIEffectInfo;
    }

    public final synchronized void rumble(float f2) {
        try {
            this.checkReleased();
            if (!(f2 > 0.0f)) {
                this.stop();
                return;
            }
            int n2 = Math.round(f2 * 10000.0f);
            this.setGain(n2);
            this.start(1, 0);
        }
        catch (IOException iOException) {
            ControllerEnvironment.logln("Failed to set rumbler gain: " + iOException.getMessage());
        }
    }

    public final Component.Identifier getAxisIdentifier() {
        return null;
    }

    public final String getAxisName() {
        return null;
    }

    public final synchronized void release() {
        if (!this.released) {
            this.released = true;
            IDirectInputEffect.nRelease(this.address);
        }
    }

    private static final native void nRelease(long var0);

    private final void checkReleased() throws IOException {
        if (this.released) {
            throw new IOException();
        }
    }

    private final void setGain(int n2) throws IOException {
        int n3 = IDirectInputEffect.nSetGain(this.address, n2);
        if (n3 != 3 && n3 != 4 && n3 != 0 && n3 != 8 && n3 != 12) {
            throw new IOException("Failed to set effect gain (0x" + Integer.toHexString(n3) + ")");
        }
    }

    private static final native int nSetGain(long var0, int var2);

    private final void start(int n2, int n3) throws IOException {
        int n4 = IDirectInputEffect.nStart(this.address, n2, n3);
        if (n4 != 0) {
            throw new IOException("Failed to start effect (0x" + Integer.toHexString(n4) + ")");
        }
    }

    private static final native int nStart(long var0, int var2, int var3);

    private final void stop() throws IOException {
        int n2 = IDirectInputEffect.nStop(this.address);
        if (n2 != 0) {
            throw new IOException("Failed to stop effect (0x" + Integer.toHexString(n2) + ")");
        }
    }

    private static final native int nStop(long var0);

    protected final void finalize() {
        this.release();
    }
}

