/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tools.zip;

import java.util.NoSuchElementException;
import java.util.Vector;
import java.util.zip.ZipException;
import org.apache.tools.zip.ExtraFieldUtils;
import org.apache.tools.zip.ZipExtraField;
import org.apache.tools.zip.ZipShort;

public class ZipEntry
extends java.util.zip.ZipEntry
implements Cloneable {
    private static final int PLATFORM_UNIX = 3;
    private static final int PLATFORM_FAT = 0;
    private static final int SHORT_MASK = 65535;
    private static final int SHORT_SHIFT = 16;
    private int internalAttributes = 0;
    private int platform = 0;
    private long externalAttributes = 0L;
    private Vector extraFields = null;
    private String name = null;

    public ZipEntry(String string) {
        super(string);
    }

    public ZipEntry(java.util.zip.ZipEntry zipEntry) throws ZipException {
        super(zipEntry);
        byte[] byArray = zipEntry.getExtra();
        if (byArray != null) {
            this.setExtraFields(ExtraFieldUtils.parse(byArray));
            return;
        }
        this.setExtra();
    }

    public ZipEntry(ZipEntry zipEntry) throws ZipException {
        this((java.util.zip.ZipEntry)zipEntry);
        this.setInternalAttributes(zipEntry.getInternalAttributes());
        this.setExternalAttributes(zipEntry.getExternalAttributes());
        this.setExtraFields(zipEntry.getExtraFields());
    }

    protected ZipEntry() {
        super("");
    }

    public Object clone() {
        ZipEntry zipEntry = (ZipEntry)super.clone();
        ((ZipEntry)super.clone()).extraFields = this.extraFields != null ? (Vector)this.extraFields.clone() : null;
        zipEntry.setInternalAttributes(this.getInternalAttributes());
        zipEntry.setExternalAttributes(this.getExternalAttributes());
        zipEntry.setExtraFields(this.getExtraFields());
        return zipEntry;
    }

    public int getInternalAttributes() {
        return this.internalAttributes;
    }

    public void setInternalAttributes(int n2) {
        this.internalAttributes = n2;
    }

    public long getExternalAttributes() {
        return this.externalAttributes;
    }

    public void setExternalAttributes(long l2) {
        this.externalAttributes = l2;
    }

    public void setUnixMode(int n2) {
        this.setExternalAttributes(n2 << 16 | ((n2 & 0x80) == 0 ? 1 : 0) | (this.isDirectory() ? 16 : 0));
        this.platform = 3;
    }

    public int getUnixMode() {
        return (int)(this.getExternalAttributes() >> 16 & 0xFFFFL);
    }

    public int getPlatform() {
        return this.platform;
    }

    protected void setPlatform(int n2) {
        this.platform = n2;
    }

    public void setExtraFields(ZipExtraField[] zipExtraFieldArray) {
        this.extraFields = new Vector();
        for (int i2 = 0; i2 < zipExtraFieldArray.length; ++i2) {
            this.extraFields.addElement(zipExtraFieldArray[i2]);
        }
        this.setExtra();
    }

    public ZipExtraField[] getExtraFields() {
        if (this.extraFields == null) {
            return new ZipExtraField[0];
        }
        Object[] objectArray = new ZipExtraField[this.extraFields.size()];
        this.extraFields.copyInto(objectArray);
        return objectArray;
    }

    public void addExtraField(ZipExtraField zipExtraField) {
        if (this.extraFields == null) {
            this.extraFields = new Vector();
        }
        ZipShort zipShort = zipExtraField.getHeaderId();
        boolean bl2 = false;
        int n2 = this.extraFields.size();
        for (int i2 = 0; !bl2 && i2 < n2; ++i2) {
            if (!((ZipExtraField)this.extraFields.elementAt(i2)).getHeaderId().equals(zipShort)) continue;
            this.extraFields.setElementAt(zipExtraField, i2);
            bl2 = true;
        }
        if (!bl2) {
            this.extraFields.addElement(zipExtraField);
        }
        this.setExtra();
    }

    public void removeExtraField(ZipShort zipShort) {
        if (this.extraFields == null) {
            this.extraFields = new Vector();
        }
        boolean bl2 = false;
        int n2 = this.extraFields.size();
        for (int i2 = 0; !bl2 && i2 < n2; ++i2) {
            if (!((ZipExtraField)this.extraFields.elementAt(i2)).getHeaderId().equals(zipShort)) continue;
            this.extraFields.removeElementAt(i2);
            bl2 = true;
        }
        if (!bl2) {
            throw new NoSuchElementException();
        }
        this.setExtra();
    }

    public void setExtra(byte[] byArray) throws RuntimeException {
        try {
            this.setExtraFields(ExtraFieldUtils.parse(byArray));
            return;
        }
        catch (Exception exception) {
            throw new RuntimeException(exception.getMessage());
        }
    }

    protected void setExtra() {
        super.setExtra(ExtraFieldUtils.mergeLocalFileDataData(this.getExtraFields()));
    }

    public byte[] getLocalFileDataExtra() {
        byte[] byArray = this.getExtra();
        if (byArray != null) {
            return byArray;
        }
        return new byte[0];
    }

    public byte[] getCentralDirectoryExtra() {
        return ExtraFieldUtils.mergeCentralDirectoryData(this.getExtraFields());
    }

    public void setComprSize(long l2) {
        this.setCompressedSize(l2);
    }

    public String getName() {
        if (this.name == null) {
            return super.getName();
        }
        return this.name;
    }

    public boolean isDirectory() {
        return this.getName().endsWith("/");
    }

    protected void setName(String string) {
        this.name = string;
    }

    public int hashCode() {
        return this.getName().hashCode();
    }

    public boolean equals(Object object) {
        return this == object;
    }
}

