/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.swt.printing;

import org.eclipse.swt.SWT;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.DeviceData;
import org.eclipse.swt.graphics.GCData;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.internal.win32.DOCINFO;
import org.eclipse.swt.internal.win32.OS;
import org.eclipse.swt.internal.win32.TCHAR;
import org.eclipse.swt.printing.PrinterData;

public final class Printer
extends Device {
    public int handle;
    PrinterData data;
    boolean isGCCreated = false;
    static TCHAR profile = new TCHAR(0, "PrinterPorts", true);
    static TCHAR appName = new TCHAR(0, "windows", true);
    static TCHAR keyName = new TCHAR(0, "device", true);

    public static PrinterData[] getPrinterList() {
        TCHAR tCHAR = new TCHAR(0, 1);
        int n2 = 1024;
        TCHAR tCHAR2 = new TCHAR(0, n2);
        int n3 = OS.GetProfileString(profile, null, tCHAR, tCHAR2, n2);
        if (n3 == 0) {
            return new PrinterData[0];
        }
        String[] stringArray = new String[5];
        int n4 = 0;
        int n5 = 0;
        int n6 = 0;
        while (n6 < n3) {
            if (tCHAR2.tcharAt(n6) == 0) {
                if (n4 == stringArray.length) {
                    String[] stringArray2 = new String[stringArray.length + 5];
                    System.arraycopy(stringArray, 0, stringArray2, 0, stringArray.length);
                    stringArray = stringArray2;
                }
                stringArray[n4] = tCHAR2.toString(n5, n6 - n5);
                ++n4;
                n5 = n6 + 1;
            }
            ++n6;
        }
        PrinterData[] printerDataArray = new PrinterData[n4];
        int n7 = 0;
        while (n7 < n4) {
            String string = stringArray[n7];
            String string2 = "";
            if (OS.GetProfileString(profile, new TCHAR(0, string, true), tCHAR, tCHAR2, n2) > 0) {
                int n8 = 0;
                while (tCHAR2.tcharAt(n8) != 44 && n8 < n2) {
                    ++n8;
                }
                if (n8 < n2) {
                    string2 = tCHAR2.toString(0, n8);
                }
            }
            printerDataArray[n7] = new PrinterData(string2, string);
            ++n7;
        }
        return printerDataArray;
    }

    public static PrinterData getDefaultPrinterData() {
        String string = null;
        TCHAR tCHAR = new TCHAR(0, 1);
        int n2 = 1024;
        TCHAR tCHAR2 = new TCHAR(0, n2);
        int n3 = OS.GetProfileString(appName, keyName, tCHAR, tCHAR2, n2);
        if (n3 == 0) {
            return null;
        }
        int n4 = 0;
        while (tCHAR2.tcharAt(n4) != 44 && n4 < n2) {
            ++n4;
        }
        if (n4 < n2) {
            string = tCHAR2.toString(0, n4);
        }
        String string2 = "";
        if (OS.GetProfileString(profile, new TCHAR(0, string, true), tCHAR, tCHAR2, n2) > 0) {
            n4 = 0;
            while (tCHAR2.tcharAt(n4) != 44 && n4 < n2) {
                ++n4;
            }
            if (n4 < n2) {
                string2 = tCHAR2.toString(0, n4);
            }
        }
        return new PrinterData(string2, string);
    }

    static DeviceData checkNull(PrinterData printerData) {
        if (printerData == null) {
            printerData = new PrinterData();
        }
        if (printerData.driver == null || printerData.name == null) {
            PrinterData printerData2 = Printer.getDefaultPrinterData();
            if (printerData2 == null) {
                SWT.error(2);
            }
            printerData.driver = printerData2.driver;
            printerData.name = printerData2.name;
        }
        return printerData;
    }

    public Printer() {
        this(null);
    }

    public Printer(PrinterData printerData) {
        super(Printer.checkNull(printerData));
    }

    protected void create(DeviceData deviceData) {
        this.data = (PrinterData)deviceData;
        TCHAR tCHAR = new TCHAR(0, this.data.driver, true);
        TCHAR tCHAR2 = new TCHAR(0, this.data.name, true);
        int n2 = 0;
        byte[] byArray = this.data.otherData;
        int n3 = OS.GetProcessHeap();
        if (byArray != null && byArray.length != 0) {
            n2 = OS.HeapAlloc(n3, 8, byArray.length);
            OS.MoveMemory(n2, byArray, byArray.length);
        }
        this.handle = OS.CreateDC(tCHAR, tCHAR2, 0, n2);
        if (n2 != 0) {
            OS.HeapFree(n3, 0, n2);
        }
        if (this.handle == 0) {
            SWT.error(2);
        }
    }

    public int internal_new_GC(GCData gCData) {
        if (this.handle == 0) {
            SWT.error(2);
        }
        if (gCData != null) {
            int n2;
            if (this.isGCCreated) {
                SWT.error(5);
            }
            if ((gCData.style & (n2 = 0x6000000)) != 0) {
                gCData.layout = (gCData.style & 0x4000000) != 0 ? 1 : 0;
            } else {
                gCData.style |= 0x2000000;
            }
            gCData.device = this;
            gCData.hFont = OS.GetCurrentObject(this.handle, 6);
            this.isGCCreated = true;
        }
        return this.handle;
    }

    public void internal_dispose_GC(int n2, GCData gCData) {
        if (gCData != null) {
            this.isGCCreated = false;
        }
    }

    public boolean startJob(String string) {
        int n2;
        this.checkDevice();
        DOCINFO dOCINFO = new DOCINFO();
        dOCINFO.cbSize = DOCINFO.sizeof;
        int n3 = OS.GetProcessHeap();
        int n4 = 0;
        if (string != null && string.length() != 0) {
            TCHAR tCHAR = new TCHAR(0, string, true);
            n2 = tCHAR.length() * TCHAR.sizeof;
            n4 = OS.HeapAlloc(n3, 8, n2);
            OS.MoveMemory(n4, tCHAR, n2);
            dOCINFO.lpszDocName = n4;
        }
        int n5 = 0;
        if (this.data.printToFile && this.data.fileName != null) {
            TCHAR tCHAR = new TCHAR(0, this.data.fileName, true);
            int n6 = tCHAR.length() * TCHAR.sizeof;
            n5 = OS.HeapAlloc(n3, 8, n6);
            OS.MoveMemory(n5, tCHAR, n6);
            dOCINFO.lpszOutput = n5;
        }
        n2 = OS.StartDoc(this.handle, dOCINFO);
        if (n4 != 0) {
            OS.HeapFree(n3, 0, n4);
        }
        if (n5 != 0) {
            OS.HeapFree(n3, 0, n5);
        }
        return n2 > 0;
    }

    public void endJob() {
        this.checkDevice();
        OS.EndDoc(this.handle);
    }

    public void cancelJob() {
        this.checkDevice();
        OS.AbortDoc(this.handle);
    }

    public boolean startPage() {
        this.checkDevice();
        int n2 = OS.StartPage(this.handle);
        if (n2 <= 0) {
            OS.AbortDoc(this.handle);
        }
        return n2 > 0;
    }

    public void endPage() {
        this.checkDevice();
        OS.EndPage(this.handle);
    }

    public Point getDPI() {
        this.checkDevice();
        int n2 = OS.GetDeviceCaps(this.handle, 88);
        int n3 = OS.GetDeviceCaps(this.handle, 90);
        return new Point(n2, n3);
    }

    public Rectangle getBounds() {
        this.checkDevice();
        int n2 = OS.GetDeviceCaps(this.handle, 110);
        int n3 = OS.GetDeviceCaps(this.handle, 111);
        return new Rectangle(0, 0, n2, n3);
    }

    public Rectangle getClientArea() {
        this.checkDevice();
        int n2 = OS.GetDeviceCaps(this.handle, 8);
        int n3 = OS.GetDeviceCaps(this.handle, 10);
        return new Rectangle(0, 0, n2, n3);
    }

    public Rectangle computeTrim(int n2, int n3, int n4, int n5) {
        this.checkDevice();
        int n6 = -OS.GetDeviceCaps(this.handle, 112);
        int n7 = -OS.GetDeviceCaps(this.handle, 113);
        int n8 = OS.GetDeviceCaps(this.handle, 8);
        int n9 = OS.GetDeviceCaps(this.handle, 10);
        int n10 = OS.GetDeviceCaps(this.handle, 110);
        int n11 = OS.GetDeviceCaps(this.handle, 111);
        int n12 = n10 - n8;
        int n13 = n11 - n9;
        return new Rectangle(n2 + n6, n3 + n7, n4 + n12, n5 + n13);
    }

    public PrinterData getPrinterData() {
        return this.data;
    }

    protected void checkDevice() {
        if (this.handle == 0) {
            SWT.error(45);
        }
    }

    protected void release() {
        super.release();
        this.data = null;
    }

    protected void destroy() {
        if (this.handle != 0) {
            OS.DeleteDC(this.handle);
        }
        this.handle = 0;
    }
}

