/*
 * Decompiled with CFR 0.152.
 */
package org.objectweb.asm;

import org.objectweb.asm.ByteVector;
import org.objectweb.asm.e;
import org.objectweb.asm.f;
import org.objectweb.asm.g;

public class Label {
    static final int DEBUG = 1;
    static final int RESOLVED = 2;
    static final int RESIZED = 4;
    static final int PUSHED = 8;
    static final int TARGET = 16;
    static final int STORE = 32;
    static final int REACHABLE = 64;
    static final int JSR = 128;
    static final int RET = 256;
    public Object info;
    int status;
    int line;
    int position;
    private int referenceCount;
    private int[] srcAndRefPositions;
    int inputStackTop;
    int outputStackMax;
    g frame;
    Label successor;
    e successors;
    Label next;

    public Label() {
    }

    Label(boolean bl2) {
        this.status = bl2 ? 1 : 0;
    }

    public int getOffset() {
        if ((this.status & 2) == 0) {
            throw new IllegalStateException("Label offset position has not been resolved yet");
        }
        return this.position;
    }

    void put(f f2, ByteVector byteVector, int n2, boolean bl2) {
        if ((this.status & 2) != 0) {
            if (bl2) {
                byteVector.putInt(this.position - n2);
                return;
            }
            byteVector.putShort(this.position - n2);
            return;
        }
        if (bl2) {
            this.addReference(-1 - n2, byteVector.length);
            byteVector.putInt(-1);
            return;
        }
        this.addReference(n2, byteVector.length);
        byteVector.putShort(-1);
    }

    private void addReference(int n2, int n3) {
        if (this.srcAndRefPositions == null) {
            this.srcAndRefPositions = new int[6];
        }
        if (this.referenceCount >= this.srcAndRefPositions.length) {
            int[] nArray = new int[this.srcAndRefPositions.length + 6];
            System.arraycopy(this.srcAndRefPositions, 0, nArray, 0, this.srcAndRefPositions.length);
            this.srcAndRefPositions = nArray;
        }
        this.srcAndRefPositions[this.referenceCount++] = n2;
        this.srcAndRefPositions[this.referenceCount++] = n3;
    }

    boolean resolve(f f2, int n2, byte[] byArray) {
        boolean bl2 = false;
        this.status |= 2;
        this.position = n2;
        int n3 = 0;
        while (n3 < this.referenceCount) {
            int n4;
            int n5 = this.srcAndRefPositions[n3++];
            int n6 = this.srcAndRefPositions[n3++];
            if (n5 >= 0) {
                n4 = n2 - n5;
                if (n4 < Short.MIN_VALUE || n4 > Short.MAX_VALUE) {
                    int n7;
                    int n8;
                    int n9;
                    byte[] byArray2;
                    int n10 = byArray[n6 - 1] & 0xFF;
                    if (n10 <= 168) {
                        byArray2 = byArray;
                        n9 = n6 - 1;
                        n8 = n10;
                        n7 = 49;
                    } else {
                        byArray2 = byArray;
                        n9 = n6 - 1;
                        n8 = n10;
                        n7 = 20;
                    }
                    byArray2[n9] = (byte)(n8 + n7);
                    bl2 = true;
                }
                byArray[n6++] = (byte)(n4 >>> 8);
                byArray[n6] = (byte)n4;
                continue;
            }
            n4 = n2 + n5 + 1;
            byArray[n6++] = (byte)(n4 >>> 24);
            byArray[n6++] = (byte)(n4 >>> 16);
            byArray[n6++] = (byte)(n4 >>> 8);
            byArray[n6] = (byte)n4;
        }
        return bl2;
    }

    Label getFirst() {
        if (this.frame == null) {
            return this;
        }
        return this.frame.a;
    }

    public String toString() {
        return "L" + System.identityHashCode(this);
    }
}

