/*
 * Decompiled with CFR 0.152.
 */
package org.openintents.tools.sensorsimulator;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.ItemSelectable;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.WindowEvent;
import java.awt.event.WindowListener;
import java.net.InetAddress;
import java.net.NetworkInterface;
import java.net.SocketException;
import java.text.DecimalFormat;
import java.util.Collections;
import java.util.Enumeration;
import javax.swing.BorderFactory;
import javax.swing.BoxLayout;
import javax.swing.ButtonGroup;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JMenuBar;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JScrollBar;
import javax.swing.JScrollPane;
import javax.swing.JSeparator;
import javax.swing.JSlider;
import javax.swing.JSplitPane;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.SwingUtilities;
import javax.swing.Timer;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import org.openintents.tools.sensorsimulator.MobilePanel;
import org.openintents.tools.sensorsimulator.SensorServer;
import org.openintents.tools.sensorsimulator.WiiMoteData;

public class SensorSimulator
extends JPanel
implements ActionListener,
WindowListener,
ChangeListener,
ItemListener {
    static final String ORIENTATION = "orientation";
    static final String ACCELEROMETER = "accelerometer";
    static final String TEMPERATURE = "temperature";
    static final String MAGNETIC_FIELD = "magnetic field";
    static final String LIGHT = "light";
    static final String PROXIMITY = "proximity";
    static final String TRICORDER = "tricorder";
    static final String SHOW_ACCELERATION = "show acceleration";
    static final String AVERAGE_ORIENTATION = "average orientation";
    static final String AVERAGE_ACCELEROMETER = "average accelerometer";
    static final String AVERAGE_TEMPERATURE = "average temperature";
    static final String AVERAGE_MAGNETIC_FIELD = "average magnetic field";
    static final String AVERAGE_LIGHT = "average light";
    static final String AVERAGE_PROXIMITY = "average proximity";
    static final String AVERAGE_TRICORDER = "average tricorder";
    static final String DISABLED = "DISABLED";
    public static final String DEGREES = "\u00b0";
    public static final String MICRO = "\u00b5";
    public static final String PLUSMINUS = "\u00b1";
    public static final String SQUARED = "\u00b2";
    int delay;
    Timer timer;
    int updateSensorCount;
    long updateSensorTime;
    int updateEmulatorAccelerometerCount;
    long updateEmulatorAccelerometerTime;
    int updateEmulatorCompassCount;
    long updateEmulatorCompassTime;
    int updateEmulatorOrientationCount;
    long updateEmulatorOrientationTime;
    int updateEmulatorThermometerCount;
    long updateEmulatorThermometerTime;
    int mouseMode;
    static int mouseYawPitch = 1;
    static int mouseRollPitch = 2;
    static int mouseMove = 3;
    MobilePanel mobile;
    JSlider yawSlider;
    JSlider pitchSlider;
    JSlider rollSlider;
    JTextField socketText;
    JButton socketButton;
    JScrollPane areaScrollPane;
    JTextArea ipselectionText;
    JScrollPane scrollPaneSensorData;
    JTextArea textAreaSensorData;
    JCheckBox mSupportedOrientation;
    JCheckBox mSupportedAccelerometer;
    JCheckBox mSupportedTemperature;
    JCheckBox mSupportedMagneticField;
    JCheckBox mSupportedLight;
    JCheckBox mSupportedProximity;
    JCheckBox mSupportedTricorder;
    JCheckBox mEnabledOrientation;
    JCheckBox mEnabledAccelerometer;
    JCheckBox mEnabledTemperature;
    JCheckBox mEnabledMagneticField;
    JCheckBox mEnabledLight;
    JCheckBox mEnabledProximity;
    JCheckBox mEnabledTricorder;
    JTextField mUpdateRatesAccelerometerText;
    JTextField mDefaultUpdateRateAccelerometerText;
    JTextField mCurrentUpdateRateAccelerometerText;
    JCheckBox mUpdateAverageAccelerometer;
    JTextField mUpdateRatesCompassText;
    JTextField mDefaultUpdateRateCompassText;
    JTextField mCurrentUpdateRateCompassText;
    JCheckBox mUpdateAverageCompass;
    JTextField mUpdateRatesOrientationText;
    JTextField mDefaultUpdateRateOrientationText;
    JTextField mCurrentUpdateRateOrientationText;
    JCheckBox mUpdateAverageOrientation;
    JTextField mUpdateRatesThermometerText;
    JTextField mDefaultUpdateRateThermometerText;
    JTextField mCurrentUpdateRateThermometerText;
    JCheckBox mUpdateAverageThermometer;
    JTextField mUpdateText;
    JTextField mRefreshCountText;
    JLabel mRefreshSensorsLabel;
    JLabel mRefreshEmulatorAccelerometerLabel;
    JLabel mRefreshEmulatorCompassLabel;
    JLabel mRefreshEmulatorOrientationLabel;
    JLabel mRefreshEmulatorThermometerLabel;
    JTextField mGravityConstantText;
    JTextField mAccelerometerLimitText;
    JTextField mPixelPerMeterText;
    JTextField mSpringConstantText;
    JTextField mDampingConstantText;
    JCheckBox mShowAcceleration;
    JTextField mGravityXText;
    JTextField mGravityYText;
    JTextField mGravityZText;
    JTextField mMagneticFieldNorthText;
    JTextField mMagneticFieldEastText;
    JTextField mMagneticFieldVerticalText;
    JTextField mTemperatureText;
    JTextField mRandomOrientationText;
    JTextField mRandomAccelerometerText;
    JTextField mRandomTemperatureText;
    JTextField mRandomMagneticFieldText;
    JTextField mRandomLightText;
    JTextField mRandomProximityText;
    JTextField mRandomTricorderText;
    JCheckBox mRealDeviceThinkpad;
    JCheckBox mRealDeviceWiimote;
    JTextField mRealDevicePath;
    JLabel mRealDeviceOutputLabel;
    static String yawPitch = "yaw & pitch";
    static String rollPitch = "roll & pitch";
    static String move = "move";
    static String timerAction = "timer";
    static String setPortString = "set port";
    SensorServer mSensorServer;
    int mIncomingConnections = 0;
    WiiMoteData wiiMoteData = new WiiMoteData();

    public SensorSimulator() {
        this.setLayout(new BorderLayout());
        GridBagLayout myGridBagLayout = new GridBagLayout();
        GridBagConstraints c = new GridBagConstraints();
        JPanel leftPane = new JPanel(myGridBagLayout);
        JPanel mobilePane = new JPanel(new BorderLayout());
        c.fill = 2;
        c.anchor = 18;
        c.gridx = 0;
        c.gridy = 0;
        c.gridwidth = 3;
        this.mobile = new MobilePanel(this);
        mobilePane.add(this.mobile);
        leftPane.add((Component)mobilePane, c);
        JRadioButton yawPitchButton = new JRadioButton(yawPitch);
        yawPitchButton.setActionCommand(yawPitch);
        yawPitchButton.setSelected(true);
        this.mouseMode = mouseYawPitch;
        JRadioButton rollPitchButton = new JRadioButton(rollPitch);
        rollPitchButton.setActionCommand(rollPitch);
        JRadioButton moveButton = new JRadioButton(move);
        moveButton.setActionCommand(move);
        ButtonGroup group = new ButtonGroup();
        group.add(yawPitchButton);
        group.add(rollPitchButton);
        group.add(moveButton);
        yawPitchButton.addActionListener(this);
        rollPitchButton.addActionListener(this);
        moveButton.addActionListener(this);
        c.gridx = 0;
        ++c.gridy;
        c.gridwidth = 1;
        leftPane.add((Component)yawPitchButton, c);
        ++c.gridx;
        leftPane.add((Component)rollPitchButton, c);
        ++c.gridx;
        leftPane.add((Component)moveButton, c);
        c.gridx = 0;
        ++c.gridy;
        c.gridwidth = 1;
        JLabel socketLabel = new JLabel("Socket", 2);
        leftPane.add((Component)socketLabel, c);
        c.gridx = 1;
        this.socketText = new JTextField(5);
        leftPane.add((Component)this.socketText, c);
        c.gridx = 2;
        this.socketButton = new JButton("Set");
        leftPane.add((Component)this.socketButton, c);
        this.socketButton.setActionCommand(setPortString);
        this.socketButton.addActionListener(this);
        c.gridx = 0;
        ++c.gridy;
        c.gridwidth = 3;
        this.ipselectionText = new JTextArea(3, 10);
        this.areaScrollPane = new JScrollPane(this.ipselectionText);
        this.areaScrollPane.setVerticalScrollBarPolicy(22);
        this.areaScrollPane.setPreferredSize(new Dimension(250, 80));
        leftPane.add((Component)this.areaScrollPane, c);
        c.gridx = 0;
        ++c.gridy;
        c.gridwidth = 3;
        this.textAreaSensorData = new JTextArea(3, 10);
        this.scrollPaneSensorData = new JScrollPane(this.textAreaSensorData);
        this.scrollPaneSensorData.setVerticalScrollBarPolicy(22);
        this.scrollPaneSensorData.setPreferredSize(new Dimension(250, 80));
        leftPane.add((Component)this.scrollPaneSensorData, c);
        leftPane.setBorder(BorderFactory.createEmptyBorder(10, 10, 10, 10));
        JLabel simulatorLabel = new JLabel("OpenIntents Sensor Simulator", 0);
        simulatorLabel.setAlignmentX(0.5f);
        Font font = new Font("SansSerif", 0, 22);
        simulatorLabel.setFont(font);
        simulatorLabel.setBorder(BorderFactory.createEmptyBorder(5, 5, 20, 5));
        JLabel yawLabel = new JLabel("Yaw", 0);
        yawLabel.setAlignmentX(0.5f);
        JLabel pitchLabel = new JLabel("Pitch", 0);
        pitchLabel.setAlignmentX(0.5f);
        JLabel rollLabel = new JLabel("Roll", 0);
        rollLabel.setAlignmentX(0.5f);
        this.yawSlider = new JSlider(0, -180, 180, -20);
        this.pitchSlider = new JSlider(0, -180, 180, -60);
        this.rollSlider = new JSlider(0, -180, 180, 0);
        this.yawSlider.addChangeListener(this);
        this.pitchSlider.addChangeListener(this);
        this.rollSlider.addChangeListener(this);
        this.mobile.yawDegree = this.yawSlider.getValue();
        this.mobile.pitchDegree = this.pitchSlider.getValue();
        this.mobile.rollDegree = this.rollSlider.getValue();
        this.mobile.yawSlider = this.yawSlider;
        this.mobile.pitchSlider = this.pitchSlider;
        this.mobile.rollSlider = this.rollSlider;
        this.yawSlider.setBorder(BorderFactory.createEmptyBorder(0, 0, 10, 0));
        this.pitchSlider.setBorder(BorderFactory.createEmptyBorder(0, 0, 10, 0));
        this.rollSlider.setMajorTickSpacing(90);
        this.rollSlider.setMinorTickSpacing(10);
        this.rollSlider.setPaintTicks(true);
        this.rollSlider.setPaintLabels(true);
        this.rollSlider.setBorder(BorderFactory.createEmptyBorder(0, 0, 10, 0));
        myGridBagLayout = new GridBagLayout();
        c = new GridBagConstraints();
        JPanel rightPane = new JPanel(myGridBagLayout);
        c.fill = 2;
        c.anchor = 18;
        c.gridwidth = 2;
        c.gridx = 0;
        c.gridy = 0;
        rightPane.add((Component)simulatorLabel, c);
        c.gridwidth = 1;
        c.gridx = 0;
        ++c.gridy;
        rightPane.add((Component)yawLabel, c);
        c.gridx = 1;
        rightPane.add((Component)this.yawSlider, c);
        c.gridx = 0;
        ++c.gridy;
        rightPane.add((Component)pitchLabel, c);
        c.gridx = 1;
        rightPane.add((Component)this.pitchSlider, c);
        c.gridx = 0;
        ++c.gridy;
        rightPane.add((Component)rollLabel, c);
        c.gridx = 1;
        rightPane.add((Component)this.rollSlider, c);
        rightPane.setBorder(BorderFactory.createEmptyBorder(10, 10, 10, 10));
        JPanel settingsPane = new JPanel(new GridBagLayout());
        GridBagConstraints c2 = new GridBagConstraints();
        JScrollPane settingsScrollPane = new JScrollPane(settingsPane);
        settingsScrollPane.setVerticalScrollBarPolicy(22);
        settingsScrollPane.setPreferredSize(new Dimension(250, 250));
        JLabel settingsLabel = new JLabel("Settings", 0);
        c2.fill = 2;
        c2.anchor = 18;
        c2.gridwidth = 1;
        c2.gridx = 0;
        c2.gridy = 0;
        settingsPane.add((Component)settingsLabel, c2);
        JSeparator separator = new JSeparator(0);
        ++c2.gridy;
        settingsPane.add((Component)separator, c2);
        JPanel supportedSensorsPane = new JPanel();
        supportedSensorsPane.setLayout(new BoxLayout(supportedSensorsPane, 3));
        supportedSensorsPane.setBorder(BorderFactory.createCompoundBorder(BorderFactory.createTitledBorder("Supported sensors"), BorderFactory.createEmptyBorder(5, 5, 5, 5)));
        this.mSupportedAccelerometer = new JCheckBox(ACCELEROMETER);
        this.mSupportedAccelerometer.setSelected(true);
        this.mSupportedAccelerometer.addItemListener(this);
        supportedSensorsPane.add(this.mSupportedAccelerometer);
        this.mSupportedMagneticField = new JCheckBox(MAGNETIC_FIELD);
        this.mSupportedMagneticField.setSelected(true);
        this.mSupportedMagneticField.addItemListener(this);
        supportedSensorsPane.add(this.mSupportedMagneticField);
        this.mSupportedOrientation = new JCheckBox(ORIENTATION);
        this.mSupportedOrientation.setSelected(true);
        this.mSupportedOrientation.addItemListener(this);
        supportedSensorsPane.add(this.mSupportedOrientation);
        this.mSupportedTemperature = new JCheckBox(TEMPERATURE);
        this.mSupportedTemperature.setSelected(false);
        this.mSupportedTemperature.addItemListener(this);
        supportedSensorsPane.add(this.mSupportedTemperature);
        ++c2.gridy;
        settingsPane.add((Component)supportedSensorsPane, c2);
        JPanel enabledSensorsPane = new JPanel();
        enabledSensorsPane.setLayout(new BoxLayout(enabledSensorsPane, 3));
        enabledSensorsPane.setBorder(BorderFactory.createCompoundBorder(BorderFactory.createTitledBorder("Enabled sensors"), BorderFactory.createEmptyBorder(5, 5, 5, 5)));
        this.mEnabledAccelerometer = new JCheckBox(ACCELEROMETER);
        this.mEnabledAccelerometer.setSelected(true);
        this.mEnabledAccelerometer.addItemListener(this);
        enabledSensorsPane.add(this.mEnabledAccelerometer);
        this.mEnabledMagneticField = new JCheckBox(MAGNETIC_FIELD);
        this.mEnabledMagneticField.setSelected(true);
        this.mEnabledMagneticField.addItemListener(this);
        enabledSensorsPane.add(this.mEnabledMagneticField);
        this.mEnabledOrientation = new JCheckBox(ORIENTATION);
        this.mEnabledOrientation.setSelected(true);
        this.mEnabledOrientation.addItemListener(this);
        enabledSensorsPane.add(this.mEnabledOrientation);
        this.mEnabledTemperature = new JCheckBox(TEMPERATURE);
        this.mEnabledTemperature.setSelected(false);
        this.mEnabledTemperature.addItemListener(this);
        enabledSensorsPane.add(this.mEnabledTemperature);
        ++c2.gridy;
        settingsPane.add((Component)enabledSensorsPane, c2);
        JPanel updateFieldPane = new JPanel(new GridBagLayout());
        GridBagConstraints c3 = new GridBagConstraints();
        c3.fill = 2;
        c3.anchor = 18;
        c3.gridwidth = 3;
        c3.gridx = 0;
        c3.gridy = 0;
        updateFieldPane.setBorder(BorderFactory.createCompoundBorder(BorderFactory.createTitledBorder("Sensor update rate"), BorderFactory.createEmptyBorder(5, 5, 5, 5)));
        JLabel label = new JLabel("Accelerometer", 2);
        c3.gridwidth = 1;
        c3.gridx = 0;
        ++c3.gridy;
        updateFieldPane.add((Component)label, c3);
        label = new JLabel("Update rates: ", 2);
        c3.gridwidth = 1;
        c3.gridx = 0;
        ++c3.gridy;
        updateFieldPane.add((Component)label, c3);
        this.mUpdateRatesAccelerometerText = new JTextField(5);
        this.mUpdateRatesAccelerometerText.setText("1, 10, 50");
        c3.gridx = 1;
        updateFieldPane.add((Component)this.mUpdateRatesAccelerometerText, c3);
        label = new JLabel("1/s", 2);
        c3.gridx = 2;
        updateFieldPane.add((Component)label, c3);
        label = new JLabel("Default rate: ", 2);
        c3.gridwidth = 1;
        c3.gridx = 0;
        ++c3.gridy;
        updateFieldPane.add((Component)label, c3);
        this.mDefaultUpdateRateAccelerometerText = new JTextField(5);
        this.mDefaultUpdateRateAccelerometerText.setText("50");
        c3.gridx = 1;
        updateFieldPane.add((Component)this.mDefaultUpdateRateAccelerometerText, c3);
        label = new JLabel("1/s", 2);
        c3.gridx = 2;
        updateFieldPane.add((Component)label, c3);
        label = new JLabel("Current rate: ", 2);
        c3.gridwidth = 1;
        c3.gridx = 0;
        ++c3.gridy;
        updateFieldPane.add((Component)label, c3);
        this.mCurrentUpdateRateAccelerometerText = new JTextField(5);
        this.mCurrentUpdateRateAccelerometerText.setText("50");
        c3.gridx = 1;
        updateFieldPane.add((Component)this.mCurrentUpdateRateAccelerometerText, c3);
        label = new JLabel("1/s", 2);
        c3.gridx = 2;
        updateFieldPane.add((Component)label, c3);
        c3.gridwidth = 3;
        c3.gridx = 0;
        ++c3.gridy;
        this.mUpdateAverageAccelerometer = new JCheckBox(AVERAGE_ACCELEROMETER);
        this.mUpdateAverageAccelerometer.setSelected(true);
        this.mUpdateAverageAccelerometer.addItemListener(this);
        updateFieldPane.add((Component)this.mUpdateAverageAccelerometer, c3);
        ++c3.gridy;
        updateFieldPane.add((Component)new JSeparator(0), c3);
        label = new JLabel("Compass", 2);
        c3.gridwidth = 1;
        c3.gridx = 0;
        ++c3.gridy;
        updateFieldPane.add((Component)label, c3);
        label = new JLabel("Update rates: ", 2);
        c3.gridwidth = 1;
        c3.gridx = 0;
        ++c3.gridy;
        updateFieldPane.add((Component)label, c3);
        this.mUpdateRatesCompassText = new JTextField(5);
        this.mUpdateRatesCompassText.setText("1, 10");
        c3.gridx = 1;
        updateFieldPane.add((Component)this.mUpdateRatesCompassText, c3);
        label = new JLabel("1/s", 2);
        c3.gridx = 2;
        updateFieldPane.add((Component)label, c3);
        label = new JLabel("Default rate: ", 2);
        c3.gridwidth = 1;
        c3.gridx = 0;
        ++c3.gridy;
        updateFieldPane.add((Component)label, c3);
        this.mDefaultUpdateRateCompassText = new JTextField(5);
        this.mDefaultUpdateRateCompassText.setText("10");
        c3.gridx = 1;
        updateFieldPane.add((Component)this.mDefaultUpdateRateCompassText, c3);
        label = new JLabel("1/s", 2);
        c3.gridx = 2;
        updateFieldPane.add((Component)label, c3);
        label = new JLabel("Current rate: ", 2);
        c3.gridwidth = 1;
        c3.gridx = 0;
        ++c3.gridy;
        updateFieldPane.add((Component)label, c3);
        this.mCurrentUpdateRateCompassText = new JTextField(5);
        this.mCurrentUpdateRateCompassText.setText("10");
        c3.gridx = 1;
        updateFieldPane.add((Component)this.mCurrentUpdateRateCompassText, c3);
        label = new JLabel("1/s", 2);
        c3.gridx = 2;
        updateFieldPane.add((Component)label, c3);
        c3.gridwidth = 3;
        c3.gridx = 0;
        ++c3.gridy;
        this.mUpdateAverageCompass = new JCheckBox(AVERAGE_MAGNETIC_FIELD);
        this.mUpdateAverageCompass.setSelected(true);
        this.mUpdateAverageCompass.addItemListener(this);
        updateFieldPane.add((Component)this.mUpdateAverageCompass, c3);
        ++c3.gridy;
        updateFieldPane.add((Component)new JSeparator(0), c3);
        label = new JLabel("Orientation", 2);
        c3.gridwidth = 1;
        c3.gridx = 0;
        ++c3.gridy;
        updateFieldPane.add((Component)label, c3);
        label = new JLabel("Update rates: ", 2);
        c3.gridwidth = 1;
        c3.gridx = 0;
        ++c3.gridy;
        updateFieldPane.add((Component)label, c3);
        this.mUpdateRatesOrientationText = new JTextField(5);
        this.mUpdateRatesOrientationText.setText("1, 10, 50");
        c3.gridx = 1;
        updateFieldPane.add((Component)this.mUpdateRatesOrientationText, c3);
        label = new JLabel("1/s", 2);
        c3.gridx = 2;
        updateFieldPane.add((Component)label, c3);
        label = new JLabel("Default rate: ", 2);
        c3.gridwidth = 1;
        c3.gridx = 0;
        ++c3.gridy;
        updateFieldPane.add((Component)label, c3);
        this.mDefaultUpdateRateOrientationText = new JTextField(5);
        this.mDefaultUpdateRateOrientationText.setText("50");
        c3.gridx = 1;
        updateFieldPane.add((Component)this.mDefaultUpdateRateOrientationText, c3);
        label = new JLabel("1/s", 2);
        c3.gridx = 2;
        updateFieldPane.add((Component)label, c3);
        label = new JLabel("Current rate: ", 2);
        c3.gridwidth = 1;
        c3.gridx = 0;
        ++c3.gridy;
        updateFieldPane.add((Component)label, c3);
        this.mCurrentUpdateRateOrientationText = new JTextField(5);
        this.mCurrentUpdateRateOrientationText.setText("50");
        c3.gridx = 1;
        updateFieldPane.add((Component)this.mCurrentUpdateRateOrientationText, c3);
        label = new JLabel("1/s", 2);
        c3.gridx = 2;
        updateFieldPane.add((Component)label, c3);
        c3.gridwidth = 3;
        c3.gridx = 0;
        ++c3.gridy;
        this.mUpdateAverageOrientation = new JCheckBox(AVERAGE_ORIENTATION);
        this.mUpdateAverageOrientation.setSelected(true);
        this.mUpdateAverageOrientation.addItemListener(this);
        updateFieldPane.add((Component)this.mUpdateAverageOrientation, c3);
        ++c3.gridy;
        updateFieldPane.add((Component)new JSeparator(0), c3);
        label = new JLabel("Thermometer", 2);
        c3.gridwidth = 1;
        c3.gridx = 0;
        ++c3.gridy;
        updateFieldPane.add((Component)label, c3);
        label = new JLabel("Update rates: ", 2);
        c3.gridwidth = 1;
        c3.gridx = 0;
        ++c3.gridy;
        updateFieldPane.add((Component)label, c3);
        this.mUpdateRatesThermometerText = new JTextField(5);
        this.mUpdateRatesThermometerText.setText("0.1, 1");
        c3.gridx = 1;
        updateFieldPane.add((Component)this.mUpdateRatesThermometerText, c3);
        label = new JLabel("1/s", 2);
        c3.gridx = 2;
        updateFieldPane.add((Component)label, c3);
        label = new JLabel("Default rate: ", 2);
        c3.gridwidth = 1;
        c3.gridx = 0;
        ++c3.gridy;
        updateFieldPane.add((Component)label, c3);
        this.mDefaultUpdateRateThermometerText = new JTextField(5);
        this.mDefaultUpdateRateThermometerText.setText("1");
        c3.gridx = 1;
        updateFieldPane.add((Component)this.mDefaultUpdateRateThermometerText, c3);
        label = new JLabel("1/s", 2);
        c3.gridx = 2;
        updateFieldPane.add((Component)label, c3);
        label = new JLabel("Current rate: ", 2);
        c3.gridwidth = 1;
        c3.gridx = 0;
        ++c3.gridy;
        updateFieldPane.add((Component)label, c3);
        this.mCurrentUpdateRateThermometerText = new JTextField(5);
        this.mCurrentUpdateRateThermometerText.setText("1");
        c3.gridx = 1;
        updateFieldPane.add((Component)this.mCurrentUpdateRateThermometerText, c3);
        label = new JLabel("1/s", 2);
        c3.gridx = 2;
        updateFieldPane.add((Component)label, c3);
        c3.gridwidth = 3;
        c3.gridx = 0;
        ++c3.gridy;
        this.mUpdateAverageThermometer = new JCheckBox(AVERAGE_TEMPERATURE);
        this.mUpdateAverageThermometer.setSelected(true);
        this.mUpdateAverageThermometer.addItemListener(this);
        updateFieldPane.add((Component)this.mUpdateAverageThermometer, c3);
        c2.gridx = 0;
        c2.gridwidth = 1;
        ++c2.gridy;
        settingsPane.add((Component)updateFieldPane, c2);
        JPanel updateSimulationFieldPane = new JPanel(new GridBagLayout());
        c3 = new GridBagConstraints();
        c3.fill = 2;
        c3.anchor = 18;
        c3.gridwidth = 3;
        c3.gridx = 0;
        c3.gridy = 0;
        updateSimulationFieldPane.setBorder(BorderFactory.createCompoundBorder(BorderFactory.createTitledBorder("Simulation update"), BorderFactory.createEmptyBorder(5, 5, 5, 5)));
        label = new JLabel("Update sensors: ", 2);
        c3.gridwidth = 1;
        c3.gridx = 0;
        ++c3.gridy;
        updateSimulationFieldPane.add((Component)label, c3);
        this.mUpdateText = new JTextField(5);
        this.mUpdateText.setText("10");
        c3.gridx = 1;
        updateSimulationFieldPane.add((Component)this.mUpdateText, c3);
        label = new JLabel(" ms", 2);
        c3.gridx = 2;
        updateSimulationFieldPane.add((Component)label, c3);
        label = new JLabel("Refresh after: ", 2);
        c3.gridwidth = 1;
        c3.gridx = 0;
        ++c3.gridy;
        updateSimulationFieldPane.add((Component)label, c3);
        this.mRefreshCountText = new JTextField(5);
        this.mRefreshCountText.setText("10");
        c3.gridx = 1;
        updateSimulationFieldPane.add((Component)this.mRefreshCountText, c3);
        label = new JLabel(" times", 2);
        c3.gridx = 2;
        updateSimulationFieldPane.add((Component)label, c3);
        label = new JLabel("Sensor update: ", 2);
        c3.gridwidth = 1;
        c3.gridx = 0;
        ++c3.gridy;
        updateSimulationFieldPane.add((Component)label, c3);
        this.mRefreshSensorsLabel = new JLabel("0", 2);
        c3.gridx = 1;
        updateSimulationFieldPane.add((Component)this.mRefreshSensorsLabel, c3);
        label = new JLabel("Emulator update: ", 2);
        c3.gridwidth = 1;
        c3.gridx = 0;
        ++c3.gridy;
        updateSimulationFieldPane.add((Component)label, c3);
        label = new JLabel(" * Accelerometer: ", 2);
        c3.gridwidth = 1;
        c3.gridx = 0;
        ++c3.gridy;
        updateSimulationFieldPane.add((Component)label, c3);
        this.mRefreshEmulatorAccelerometerLabel = new JLabel("-", 2);
        c3.gridx = 1;
        updateSimulationFieldPane.add((Component)this.mRefreshEmulatorAccelerometerLabel, c3);
        label = new JLabel(" * Compass: ", 2);
        c3.gridwidth = 1;
        c3.gridx = 0;
        ++c3.gridy;
        updateSimulationFieldPane.add((Component)label, c3);
        this.mRefreshEmulatorCompassLabel = new JLabel("-", 2);
        c3.gridx = 1;
        updateSimulationFieldPane.add((Component)this.mRefreshEmulatorCompassLabel, c3);
        label = new JLabel(" * Orientation: ", 2);
        c3.gridwidth = 1;
        c3.gridx = 0;
        ++c3.gridy;
        updateSimulationFieldPane.add((Component)label, c3);
        this.mRefreshEmulatorOrientationLabel = new JLabel("-", 2);
        c3.gridx = 1;
        updateSimulationFieldPane.add((Component)this.mRefreshEmulatorOrientationLabel, c3);
        label = new JLabel(" * Thermometer: ", 2);
        c3.gridwidth = 1;
        c3.gridx = 0;
        ++c3.gridy;
        updateSimulationFieldPane.add((Component)label, c3);
        this.mRefreshEmulatorThermometerLabel = new JLabel("-", 2);
        c3.gridx = 1;
        updateSimulationFieldPane.add((Component)this.mRefreshEmulatorThermometerLabel, c3);
        c2.gridx = 0;
        c2.gridwidth = 1;
        ++c2.gridy;
        settingsPane.add((Component)updateSimulationFieldPane, c2);
        JPanel accelerometerFieldPane = new JPanel(new GridBagLayout());
        c3 = new GridBagConstraints();
        c3.fill = 2;
        c3.anchor = 18;
        c3.gridwidth = 3;
        c3.gridx = 0;
        c3.gridy = 0;
        accelerometerFieldPane.setBorder(BorderFactory.createCompoundBorder(BorderFactory.createTitledBorder("Accelerometer"), BorderFactory.createEmptyBorder(5, 5, 5, 5)));
        label = new JLabel("Gravity constant g: ", 2);
        c3.gridwidth = 1;
        c3.gridx = 0;
        ++c3.gridy;
        accelerometerFieldPane.add((Component)label, c3);
        this.mGravityConstantText = new JTextField(5);
        this.mGravityConstantText.setText("9.80665");
        c3.gridx = 1;
        accelerometerFieldPane.add((Component)this.mGravityConstantText, c3);
        label = new JLabel(" m/s\u00b2", 2);
        c3.gridx = 2;
        accelerometerFieldPane.add((Component)label, c3);
        label = new JLabel("Accelerometer limit: ", 2);
        c3.gridwidth = 1;
        c3.gridx = 0;
        ++c3.gridy;
        accelerometerFieldPane.add((Component)label, c3);
        this.mAccelerometerLimitText = new JTextField(5);
        this.mAccelerometerLimitText.setText("10");
        c3.gridx = 1;
        accelerometerFieldPane.add((Component)this.mAccelerometerLimitText, c3);
        label = new JLabel(" g", 2);
        c3.gridx = 2;
        accelerometerFieldPane.add((Component)label, c3);
        label = new JLabel("Pixels per meter: ", 2);
        c3.gridwidth = 1;
        c3.gridx = 0;
        ++c3.gridy;
        accelerometerFieldPane.add((Component)label, c3);
        this.mPixelPerMeterText = new JTextField(5);
        this.mPixelPerMeterText.setText("3000");
        c3.gridx = 1;
        accelerometerFieldPane.add((Component)this.mPixelPerMeterText, c3);
        label = new JLabel(" p/m", 2);
        c3.gridx = 2;
        accelerometerFieldPane.add((Component)label, c3);
        label = new JLabel("Spring constant (k/m) ", 2);
        c3.gridwidth = 1;
        c3.gridx = 0;
        ++c3.gridy;
        accelerometerFieldPane.add((Component)label, c3);
        this.mSpringConstantText = new JTextField(5);
        this.mSpringConstantText.setText("500");
        c3.gridx = 1;
        accelerometerFieldPane.add((Component)this.mSpringConstantText, c3);
        label = new JLabel(" p/s\u00b2", 2);
        c3.gridx = 2;
        accelerometerFieldPane.add((Component)label, c3);
        label = new JLabel("Damping constant: ", 2);
        c3.gridwidth = 1;
        c3.gridx = 0;
        ++c3.gridy;
        accelerometerFieldPane.add((Component)label, c3);
        this.mDampingConstantText = new JTextField(5);
        this.mDampingConstantText.setText("50");
        c3.gridx = 1;
        accelerometerFieldPane.add((Component)this.mDampingConstantText, c3);
        label = new JLabel(" p/s", 2);
        c3.gridx = 2;
        accelerometerFieldPane.add((Component)label, c3);
        c3.gridwidth = 3;
        c3.gridx = 0;
        ++c3.gridy;
        this.mShowAcceleration = new JCheckBox(SHOW_ACCELERATION);
        this.mShowAcceleration.setSelected(false);
        this.mShowAcceleration.addItemListener(this);
        accelerometerFieldPane.add((Component)this.mShowAcceleration, c3);
        c2.gridx = 0;
        c2.gridwidth = 1;
        ++c2.gridy;
        settingsPane.add((Component)accelerometerFieldPane, c2);
        JPanel gravityFieldPane = new JPanel(new GridBagLayout());
        c3 = new GridBagConstraints();
        c3.fill = 2;
        c3.anchor = 18;
        c3.gridwidth = 3;
        c3.gridx = 0;
        c3.gridy = 0;
        gravityFieldPane.setBorder(BorderFactory.createCompoundBorder(BorderFactory.createTitledBorder("Gravity"), BorderFactory.createEmptyBorder(5, 5, 5, 5)));
        label = new JLabel("x: ", 2);
        c3.gridwidth = 1;
        c3.gridx = 0;
        ++c3.gridy;
        gravityFieldPane.add((Component)label, c3);
        this.mGravityXText = new JTextField(5);
        this.mGravityXText.setText("0");
        c3.gridx = 1;
        gravityFieldPane.add((Component)this.mGravityXText, c3);
        label = new JLabel(" m/s\u00b2", 2);
        c3.gridx = 2;
        gravityFieldPane.add((Component)label, c3);
        label = new JLabel("y: ", 2);
        c3.gridwidth = 1;
        c3.gridx = 0;
        ++c3.gridy;
        gravityFieldPane.add((Component)label, c3);
        this.mGravityYText = new JTextField(5);
        this.mGravityYText.setText("0");
        c3.gridx = 1;
        gravityFieldPane.add((Component)this.mGravityYText, c3);
        label = new JLabel(" m/s\u00b2", 2);
        c3.gridx = 2;
        gravityFieldPane.add((Component)label, c3);
        label = new JLabel("z: ", 2);
        c3.gridwidth = 1;
        c3.gridx = 0;
        ++c3.gridy;
        gravityFieldPane.add((Component)label, c3);
        this.mGravityZText = new JTextField(5);
        this.mGravityZText.setText("-9.80665");
        c3.gridx = 1;
        gravityFieldPane.add((Component)this.mGravityZText, c3);
        label = new JLabel(" m/s\u00b2", 2);
        c3.gridx = 2;
        gravityFieldPane.add((Component)label, c3);
        c2.gridx = 0;
        c2.gridwidth = 1;
        ++c2.gridy;
        settingsPane.add((Component)gravityFieldPane, c2);
        JPanel magneticFieldPane = new JPanel(new GridBagLayout());
        c3 = new GridBagConstraints();
        c3.fill = 2;
        c3.anchor = 18;
        c3.gridwidth = 3;
        c3.gridx = 0;
        c3.gridy = 0;
        magneticFieldPane.setBorder(BorderFactory.createCompoundBorder(BorderFactory.createTitledBorder("Magnetic field"), BorderFactory.createEmptyBorder(5, 5, 5, 5)));
        JLabel magneticFieldNorthLabel = new JLabel("North component: ", 2);
        c3.gridwidth = 1;
        c3.gridx = 0;
        ++c3.gridy;
        magneticFieldPane.add((Component)magneticFieldNorthLabel, c3);
        this.mMagneticFieldNorthText = new JTextField(5);
        this.mMagneticFieldNorthText.setText("22874.1");
        c3.gridx = 1;
        magneticFieldPane.add((Component)this.mMagneticFieldNorthText, c3);
        JLabel nanoTeslaLabel = new JLabel(" nT", 2);
        c3.gridx = 2;
        magneticFieldPane.add((Component)nanoTeslaLabel, c3);
        JLabel magneticFieldEastLabel = new JLabel("East component: ", 2);
        c3.gridwidth = 1;
        c3.gridx = 0;
        ++c3.gridy;
        magneticFieldPane.add((Component)magneticFieldEastLabel, c3);
        this.mMagneticFieldEastText = new JTextField(5);
        this.mMagneticFieldEastText.setText("5939.5");
        c3.gridx = 1;
        magneticFieldPane.add((Component)this.mMagneticFieldEastText, c3);
        nanoTeslaLabel = new JLabel(" nT", 2);
        c3.gridx = 2;
        magneticFieldPane.add((Component)nanoTeslaLabel, c3);
        JLabel magneticFieldVerticalLabel = new JLabel("Vertical component: ", 2);
        c3.gridwidth = 1;
        c3.gridx = 0;
        ++c3.gridy;
        magneticFieldPane.add((Component)magneticFieldVerticalLabel, c3);
        this.mMagneticFieldVerticalText = new JTextField(5);
        this.mMagneticFieldVerticalText.setText("43180.5");
        c3.gridx = 1;
        magneticFieldPane.add((Component)this.mMagneticFieldVerticalText, c3);
        label = new JLabel(" nT", 2);
        c3.gridx = 2;
        magneticFieldPane.add((Component)label, c3);
        c2.gridx = 0;
        c2.gridwidth = 1;
        ++c2.gridy;
        settingsPane.add((Component)magneticFieldPane, c2);
        JPanel temperatureFieldPane = new JPanel(new GridBagLayout());
        c3 = new GridBagConstraints();
        c3.fill = 2;
        c3.anchor = 18;
        c3.gridwidth = 3;
        c3.gridx = 0;
        c3.gridy = 0;
        temperatureFieldPane.setBorder(BorderFactory.createCompoundBorder(BorderFactory.createTitledBorder("Temperature"), BorderFactory.createEmptyBorder(5, 5, 5, 5)));
        label = new JLabel("Temperature: ", 2);
        c3.gridwidth = 1;
        c3.gridx = 0;
        ++c3.gridy;
        temperatureFieldPane.add((Component)label, c3);
        this.mTemperatureText = new JTextField(5);
        this.mTemperatureText.setText("17.7");
        c3.gridx = 1;
        temperatureFieldPane.add((Component)this.mTemperatureText, c3);
        label = new JLabel(" \u00b0C", 2);
        c3.gridx = 2;
        temperatureFieldPane.add((Component)label, c3);
        c2.gridx = 0;
        c2.gridwidth = 1;
        ++c2.gridy;
        settingsPane.add((Component)temperatureFieldPane, c2);
        JPanel randomFieldPane = new JPanel(new GridBagLayout());
        c3 = new GridBagConstraints();
        c3.fill = 2;
        c3.anchor = 18;
        c3.gridwidth = 3;
        c3.gridx = 0;
        c3.gridy = 0;
        randomFieldPane.setBorder(BorderFactory.createCompoundBorder(BorderFactory.createTitledBorder("Random component"), BorderFactory.createEmptyBorder(5, 5, 5, 5)));
        label = new JLabel("Accelerometer: ", 2);
        c3.gridwidth = 1;
        c3.gridx = 0;
        ++c3.gridy;
        randomFieldPane.add((Component)label, c3);
        this.mRandomAccelerometerText = new JTextField(5);
        this.mRandomAccelerometerText.setText("0");
        c3.gridx = 1;
        randomFieldPane.add((Component)this.mRandomAccelerometerText, c3);
        label = new JLabel(" m/s\u00b2", 2);
        c3.gridx = 2;
        randomFieldPane.add((Component)label, c3);
        label = new JLabel("Compass: ", 2);
        c3.gridwidth = 1;
        c3.gridx = 0;
        ++c3.gridy;
        randomFieldPane.add((Component)label, c3);
        this.mRandomMagneticFieldText = new JTextField(5);
        this.mRandomMagneticFieldText.setText("0");
        c3.gridx = 1;
        randomFieldPane.add((Component)this.mRandomMagneticFieldText, c3);
        label = new JLabel(" nT", 2);
        c3.gridx = 2;
        randomFieldPane.add((Component)label, c3);
        label = new JLabel("Orientation: ", 2);
        c3.gridwidth = 1;
        c3.gridx = 0;
        ++c3.gridy;
        randomFieldPane.add((Component)label, c3);
        this.mRandomOrientationText = new JTextField(5);
        this.mRandomOrientationText.setText("0");
        c3.gridx = 1;
        randomFieldPane.add((Component)this.mRandomOrientationText, c3);
        label = new JLabel(" \u00b0", 2);
        c3.gridx = 2;
        randomFieldPane.add((Component)label, c3);
        label = new JLabel("Temperature: ", 2);
        c3.gridwidth = 1;
        c3.gridx = 0;
        ++c3.gridy;
        randomFieldPane.add((Component)label, c3);
        this.mRandomTemperatureText = new JTextField(5);
        this.mRandomTemperatureText.setText("0");
        c3.gridx = 1;
        randomFieldPane.add((Component)this.mRandomTemperatureText, c3);
        label = new JLabel(" \u00b0C", 2);
        c3.gridx = 2;
        randomFieldPane.add((Component)label, c3);
        c2.gridx = 0;
        c2.gridwidth = 1;
        ++c2.gridy;
        settingsPane.add((Component)randomFieldPane, c2);
        JPanel realSensorBridgeFieldPane = new JPanel(new GridBagLayout());
        c3 = new GridBagConstraints();
        c3.fill = 2;
        c3.anchor = 18;
        c3.gridwidth = 3;
        c3.gridx = 0;
        c3.gridy = 0;
        realSensorBridgeFieldPane.setBorder(BorderFactory.createCompoundBorder(BorderFactory.createTitledBorder("Real sensor bridge"), BorderFactory.createEmptyBorder(5, 5, 5, 5)));
        this.mRealDeviceThinkpad = new JCheckBox("Use Thinkpad accelerometer");
        this.mRealDeviceThinkpad.setSelected(false);
        this.mRealDeviceThinkpad.addItemListener(this);
        c3.gridwidth = 1;
        c3.gridx = 0;
        realSensorBridgeFieldPane.add((Component)this.mRealDeviceThinkpad, c3);
        this.mRealDeviceWiimote = new JCheckBox("Use Wii-mote accelerometer");
        this.mRealDeviceWiimote.setSelected(false);
        this.mRealDeviceWiimote.addItemListener(this);
        ++c3.gridy;
        realSensorBridgeFieldPane.add((Component)this.mRealDeviceWiimote, c3);
        this.mRealDevicePath = new JTextField(20);
        this.mRealDevicePath.setText("/sys/devices/platform/hdaps/position");
        c3.gridx = 0;
        ++c3.gridy;
        realSensorBridgeFieldPane.add((Component)this.mRealDevicePath, c3);
        this.mRealDeviceOutputLabel = new JLabel("-", 2);
        c3.gridx = 0;
        ++c3.gridy;
        realSensorBridgeFieldPane.add((Component)this.mRealDeviceOutputLabel, c3);
        c2.gridx = 0;
        c2.gridwidth = 1;
        ++c2.gridy;
        settingsPane.add((Component)realSensorBridgeFieldPane, c2);
        c.gridx = 0;
        c.gridwidth = 2;
        ++c.gridy;
        rightPane.add((Component)settingsScrollPane, c);
        JSplitPane splitPane = new JSplitPane(1, leftPane, rightPane);
        splitPane.setDividerLocation(271);
        this.add((Component)splitPane, "Center");
        this.socketText.setText("8010");
        this.ipselectionText.append("Possible IP addresses:\n");
        try {
            Enumeration<NetworkInterface> nets = NetworkInterface.getNetworkInterfaces();
            for (NetworkInterface netint : Collections.list(nets)) {
                Enumeration<InetAddress> inetAddresses = netint.getInetAddresses();
                for (InetAddress inetAddress : Collections.list(inetAddresses)) {
                    if (("" + inetAddress).compareTo("/127.0.0.1") == 0) continue;
                    this.ipselectionText.append("" + inetAddress + "\n");
                }
            }
        }
        catch (SocketException e) {
            this.ipselectionText.append("Socket exception. Could not obtain IP addresses.");
        }
        this.mSensorServer = new SensorServer(this);
        this.updateSensorCount = 0;
        this.updateSensorTime = System.currentTimeMillis();
        this.updateEmulatorAccelerometerCount = 0;
        this.updateEmulatorAccelerometerTime = System.currentTimeMillis();
        this.delay = 500;
        this.timer = new Timer(this.delay, new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                SensorSimulator.this.actionPerformed(new ActionEvent(evt.getSource(), evt.getID(), timerAction));
            }
        });
        this.timer.setCoalesce(true);
        this.timer.start();
    }

    void addWindowListener(Window w) {
        w.addWindowListener(this);
    }

    public void windowIconified(WindowEvent e) {
        this.timer.stop();
    }

    public void windowDeiconified(WindowEvent e) {
        this.timer.start();
    }

    public void windowOpened(WindowEvent e) {
    }

    public void windowClosing(WindowEvent e) {
    }

    public void windowClosed(WindowEvent e) {
    }

    public void windowActivated(WindowEvent e) {
    }

    public void windowDeactivated(WindowEvent e) {
    }

    public void stateChanged(ChangeEvent e) {
        JSlider source = (JSlider)e.getSource();
        if (source == this.yawSlider) {
            this.mobile.yawDegree = source.getValue();
            this.mobile.repaint();
        } else if (source == this.pitchSlider) {
            this.mobile.pitchDegree = source.getValue();
            this.mobile.repaint();
        } else if (source == this.rollSlider) {
            this.mobile.rollDegree = source.getValue();
            this.mobile.repaint();
        }
    }

    public void itemStateChanged(ItemEvent e) {
        ItemSelectable source = e.getItemSelectable();
        if (source == this.mRealDeviceThinkpad && e.getStateChange() == 1) {
            this.mRealDeviceWiimote.setSelected(false);
        } else if (source == this.mRealDeviceWiimote && e.getStateChange() == 1) {
            this.mRealDeviceThinkpad.setSelected(false);
        }
        if (source == this.mShowAcceleration) {
            this.mobile.repaint();
        }
    }

    public void actionPerformed(ActionEvent e) {
        String action = e.getActionCommand();
        if (action.equals(yawPitch)) {
            this.mouseMode = mouseYawPitch;
        } else if (action.equals(rollPitch)) {
            this.mouseMode = mouseRollPitch;
        } else if (action.equals(move)) {
            this.mouseMode = mouseMove;
        } else if (action.equals(timerAction)) {
            this.doTimer();
        } else if (action.equals(setPortString)) {
            this.setPort();
        }
    }

    public void doTimer() {
        if (this.mRealDeviceWiimote.isSelected()) {
            this.updateFromWiimote();
        }
        this.mobile.updateSensorPhysics();
        this.mobile.updateSensorReadoutValues();
        this.mobile.updateUserSettings();
        this.updateSensorRefresh();
        this.showSensorData();
    }

    public void updateSensorRefresh() {
        ++this.updateSensorCount;
        long maxcount = (long)this.getSafeDouble(this.mRefreshCountText);
        if (maxcount >= 0L && (long)this.updateSensorCount >= maxcount) {
            long newtime = System.currentTimeMillis();
            double ms = (double)(newtime - this.updateSensorTime) / (double)maxcount;
            DecimalFormat mf = new DecimalFormat("#0.0");
            this.mRefreshSensorsLabel.setText(mf.format(ms) + " ms");
            this.updateSensorCount = 0;
            this.updateSensorTime = newtime;
        }
    }

    public void updateEmulatorAccelerometerRefresh() {
        ++this.updateEmulatorAccelerometerCount;
        long maxcount = (long)this.getSafeDouble(this.mRefreshCountText);
        if (maxcount >= 0L && (long)this.updateEmulatorAccelerometerCount >= maxcount) {
            long newtime = System.currentTimeMillis();
            double ms = (double)(newtime - this.updateEmulatorAccelerometerTime) / (double)maxcount;
            DecimalFormat mf = new DecimalFormat("#0.0");
            this.mRefreshEmulatorAccelerometerLabel.setText(mf.format(ms) + " ms");
            this.updateEmulatorAccelerometerCount = 0;
            this.updateEmulatorAccelerometerTime = newtime;
        }
    }

    public void updateEmulatorCompassRefresh() {
        ++this.updateEmulatorCompassCount;
        long maxcount = (long)this.getSafeDouble(this.mRefreshCountText);
        if (maxcount >= 0L && (long)this.updateEmulatorCompassCount >= maxcount) {
            long newtime = System.currentTimeMillis();
            double ms = (double)(newtime - this.updateEmulatorCompassTime) / (double)maxcount;
            DecimalFormat mf = new DecimalFormat("#0.0");
            this.mRefreshEmulatorCompassLabel.setText(mf.format(ms) + " ms");
            this.updateEmulatorCompassCount = 0;
            this.updateEmulatorCompassTime = newtime;
        }
    }

    public void updateEmulatorOrientationRefresh() {
        ++this.updateEmulatorOrientationCount;
        long maxcount = (long)this.getSafeDouble(this.mRefreshCountText);
        if (maxcount >= 0L && (long)this.updateEmulatorOrientationCount >= maxcount) {
            long newtime = System.currentTimeMillis();
            double ms = (double)(newtime - this.updateEmulatorOrientationTime) / (double)maxcount;
            DecimalFormat mf = new DecimalFormat("#0.0");
            this.mRefreshEmulatorOrientationLabel.setText(mf.format(ms) + " ms");
            this.updateEmulatorOrientationCount = 0;
            this.updateEmulatorOrientationTime = newtime;
        }
    }

    public void updateEmulatorThermometerRefresh() {
        ++this.updateEmulatorAccelerometerCount;
        long maxcount = (long)this.getSafeDouble(this.mRefreshCountText);
        if (maxcount >= 0L && (long)this.updateEmulatorThermometerCount >= maxcount) {
            long newtime = System.currentTimeMillis();
            double ms = (double)(newtime - this.updateEmulatorThermometerTime) / (double)maxcount;
            DecimalFormat mf = new DecimalFormat("#0.0");
            this.mRefreshEmulatorThermometerLabel.setText(mf.format(ms) + " ms");
            this.updateEmulatorThermometerCount = 0;
            this.updateEmulatorThermometerTime = newtime;
        }
    }

    public void showSensorData() {
        DecimalFormat mf = new DecimalFormat("#0.00");
        String data = "";
        if (this.mSupportedAccelerometer.isSelected()) {
            data = data + "accelerometer: ";
            data = this.mEnabledAccelerometer.isSelected() ? data + mf.format(this.mobile.read_accelx) + ", " + mf.format(this.mobile.read_accely) + ", " + mf.format(this.mobile.read_accelz) : data + DISABLED;
            data = data + "\n";
        }
        if (this.mSupportedMagneticField.isSelected()) {
            data = data + "magnetic field: ";
            data = this.mEnabledMagneticField.isSelected() ? data + mf.format(this.mobile.read_compassx) + ", " + mf.format(this.mobile.read_compassy) + ", " + mf.format(this.mobile.read_compassz) : data + DISABLED;
            data = data + "\n";
        }
        if (this.mSupportedOrientation.isSelected()) {
            data = data + "orientation: ";
            data = this.mEnabledOrientation.isSelected() ? data + mf.format(this.mobile.read_yaw) + ", " + mf.format(this.mobile.read_pitch) + ", " + mf.format(this.mobile.read_roll) : data + DISABLED;
            data = data + "\n";
        }
        if (this.mSupportedTemperature.isSelected()) {
            data = data + "temperature: ";
            data = this.mEnabledTemperature.isSelected() ? data + mf.format(this.mobile.read_temperature) : data + DISABLED;
            data = data + "\n";
        }
        this.textAreaSensorData.setText(data);
    }

    public void setPort() {
        this.addMessage("Closing port " + this.mSensorServer.port);
        this.mSensorServer.stop();
        this.mSensorServer = new SensorServer(this);
    }

    public void addMessage(String msg) {
        JScrollBar vbar = this.areaScrollPane.getVerticalScrollBar();
        int tolerance = 10;
        boolean autoScroll = vbar.getValue() + vbar.getVisibleAmount() + 10 >= vbar.getMaximum();
        this.ipselectionText.append(msg + "\n");
        if (autoScroll) {
            this.ipselectionText.setCaretPosition(this.ipselectionText.getDocument().getLength());
        }
    }

    public int getPort() {
        String s = this.socketText.getText();
        int port = 0;
        try {
            port = Integer.parseInt(s);
        }
        catch (NumberFormatException e) {
            this.addMessage("Invalid port number: " + s);
        }
        return port;
    }

    public void newClient() {
        ++this.mIncomingConnections;
        if (this.mIncomingConnections <= 1) {
            this.mEnabledAccelerometer.setSelected(false);
            this.mEnabledMagneticField.setSelected(false);
            this.mEnabledOrientation.setSelected(false);
            this.mEnabledTemperature.setSelected(false);
            this.addMessage("First incoming connection:");
            this.addMessage("ALL SENSORS DISABLED!");
        }
    }

    public double getSafeDouble(JTextField textfield, double defaultValue) {
        double value;
        try {
            value = Double.parseDouble(textfield.getText());
            textfield.setBackground(Color.WHITE);
        }
        catch (NumberFormatException e) {
            value = defaultValue;
            textfield.setBackground(Color.RED);
        }
        return value;
    }

    public double getSafeDouble(JTextField textfield) {
        return this.getSafeDouble(textfield, 0.0);
    }

    public double[] getSafeDoubleList(JTextField textfield) {
        double[] valuelist;
        try {
            String t = textfield.getText();
            String[] tlist = t.split(",");
            int len = tlist.length;
            if (len > 0) {
                valuelist = new double[len];
                for (int i = 0; i < len; ++i) {
                    valuelist[i] = Double.parseDouble(tlist[i]);
                }
            } else {
                valuelist = null;
            }
            textfield.setBackground(Color.WHITE);
        }
        catch (NumberFormatException e) {
            valuelist = null;
            textfield.setBackground(Color.RED);
        }
        return valuelist;
    }

    private static void createAndShowGUI() {
        JFrame frame = new JFrame("SensorSimulator");
        frame.setDefaultCloseOperation(3);
        JMenuBar myMenuBar = new JMenuBar();
        myMenuBar.setPreferredSize(new Dimension(200, 20));
        JLabel yellowLabel = new JLabel();
        yellowLabel.setPreferredSize(new Dimension(400, 180));
        JCheckBox changeButton = new JCheckBox("Glass pane \"visible\"");
        changeButton.setSelected(false);
        SensorSimulator simulator = new SensorSimulator();
        frame.setJMenuBar(myMenuBar);
        frame.add((Component)simulator, "Center");
        frame.pack();
        frame.setVisible(true);
    }

    private void updateFromWiimote() {
        this.wiiMoteData.setDataFilePath(this.mRealDevicePath.getText());
        boolean success = this.wiiMoteData.updateData();
        this.mRealDeviceOutputLabel.setText(this.wiiMoteData.getStatus());
        if (success) {
            this.yawSlider.setValue(0);
            this.rollSlider.setValue(this.wiiMoteData.getRoll());
            this.pitchSlider.setValue(this.wiiMoteData.getPitch());
        }
    }

    public static void main(String[] args) {
        SwingUtilities.invokeLater(new Runnable(){

            public void run() {
                SensorSimulator.createAndShowGUI();
            }
        });
    }
}

