/*
 * Decompiled with CFR 0.152.
 */
package com.sun.xml.internal.ws.model.wsdl;

import com.sun.istack.internal.NotNull;
import com.sun.istack.internal.Nullable;
import com.sun.xml.internal.ws.api.model.ParameterBinding;
import com.sun.xml.internal.ws.api.model.wsdl.WSDLBoundOperation;
import com.sun.xml.internal.ws.api.model.wsdl.editable.EditableWSDLBoundFault;
import com.sun.xml.internal.ws.api.model.wsdl.editable.EditableWSDLBoundOperation;
import com.sun.xml.internal.ws.api.model.wsdl.editable.EditableWSDLBoundPortType;
import com.sun.xml.internal.ws.api.model.wsdl.editable.EditableWSDLMessage;
import com.sun.xml.internal.ws.api.model.wsdl.editable.EditableWSDLModel;
import com.sun.xml.internal.ws.api.model.wsdl.editable.EditableWSDLOperation;
import com.sun.xml.internal.ws.api.model.wsdl.editable.EditableWSDLPart;
import com.sun.xml.internal.ws.model.wsdl.AbstractExtensibleImpl;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.jws.WebParam;
import javax.jws.soap.SOAPBinding;
import javax.xml.namespace.QName;
import javax.xml.stream.XMLStreamReader;

public final class WSDLBoundOperationImpl
extends AbstractExtensibleImpl
implements EditableWSDLBoundOperation {
    private final QName name;
    private final Map<String, ParameterBinding> inputParts;
    private final Map<String, ParameterBinding> outputParts;
    private final Map<String, ParameterBinding> faultParts;
    private final Map<String, String> inputMimeTypes;
    private final Map<String, String> outputMimeTypes;
    private final Map<String, String> faultMimeTypes;
    private boolean explicitInputSOAPBodyParts = false;
    private boolean explicitOutputSOAPBodyParts = false;
    private boolean explicitFaultSOAPBodyParts = false;
    private Boolean emptyInputBody;
    private Boolean emptyOutputBody;
    private Boolean emptyFaultBody;
    private final Map<String, EditableWSDLPart> inParts;
    private final Map<String, EditableWSDLPart> outParts;
    private final List<EditableWSDLBoundFault> wsdlBoundFaults;
    private EditableWSDLOperation operation;
    private String soapAction;
    private WSDLBoundOperation.ANONYMOUS anonymous;
    private final EditableWSDLBoundPortType owner;
    private SOAPBinding.Style style = SOAPBinding.Style.DOCUMENT;
    private String reqNamespace;
    private String respNamespace;
    private QName requestPayloadName;
    private QName responsePayloadName;
    private boolean emptyRequestPayload;
    private boolean emptyResponsePayload;
    private Map<QName, ? extends EditableWSDLMessage> messages;

    public WSDLBoundOperationImpl(XMLStreamReader xMLStreamReader, EditableWSDLBoundPortType editableWSDLBoundPortType, QName qName) {
        super(xMLStreamReader);
        this.name = qName;
        this.inputParts = new HashMap<String, ParameterBinding>();
        this.outputParts = new HashMap<String, ParameterBinding>();
        this.faultParts = new HashMap<String, ParameterBinding>();
        this.inputMimeTypes = new HashMap<String, String>();
        this.outputMimeTypes = new HashMap<String, String>();
        this.faultMimeTypes = new HashMap<String, String>();
        this.inParts = new HashMap<String, EditableWSDLPart>();
        this.outParts = new HashMap<String, EditableWSDLPart>();
        this.wsdlBoundFaults = new ArrayList<EditableWSDLBoundFault>();
        this.owner = editableWSDLBoundPortType;
    }

    @Override
    public QName getName() {
        return this.name;
    }

    @Override
    public String getSOAPAction() {
        return this.soapAction;
    }

    @Override
    public void setSoapAction(String string) {
        this.soapAction = string != null ? string : "";
    }

    @Override
    public EditableWSDLPart getPart(String string, WebParam.Mode mode) {
        if (mode == WebParam.Mode.IN) {
            return this.inParts.get(string);
        }
        if (mode == WebParam.Mode.OUT) {
            return this.outParts.get(string);
        }
        return null;
    }

    @Override
    public void addPart(EditableWSDLPart editableWSDLPart, WebParam.Mode mode) {
        if (mode == WebParam.Mode.IN) {
            this.inParts.put(editableWSDLPart.getName(), editableWSDLPart);
        } else if (mode == WebParam.Mode.OUT) {
            this.outParts.put(editableWSDLPart.getName(), editableWSDLPart);
        }
    }

    @Override
    public Map<String, ParameterBinding> getInputParts() {
        return this.inputParts;
    }

    @Override
    public Map<String, ParameterBinding> getOutputParts() {
        return this.outputParts;
    }

    @Override
    public Map<String, ParameterBinding> getFaultParts() {
        return this.faultParts;
    }

    @Override
    public Map<String, ? extends EditableWSDLPart> getInParts() {
        return Collections.unmodifiableMap(this.inParts);
    }

    @Override
    public Map<String, ? extends EditableWSDLPart> getOutParts() {
        return Collections.unmodifiableMap(this.outParts);
    }

    @NotNull
    public List<? extends EditableWSDLBoundFault> getFaults() {
        return this.wsdlBoundFaults;
    }

    @Override
    public void addFault(@NotNull EditableWSDLBoundFault editableWSDLBoundFault) {
        this.wsdlBoundFaults.add(editableWSDLBoundFault);
    }

    @Override
    public ParameterBinding getInputBinding(String string) {
        ParameterBinding parameterBinding;
        if (this.emptyInputBody == null) {
            this.emptyInputBody = this.inputParts.get(" ") != null ? Boolean.valueOf(true) : Boolean.valueOf(false);
        }
        if ((parameterBinding = this.inputParts.get(string)) == null) {
            if (this.explicitInputSOAPBodyParts || this.emptyInputBody.booleanValue()) {
                return ParameterBinding.UNBOUND;
            }
            return ParameterBinding.BODY;
        }
        return parameterBinding;
    }

    @Override
    public ParameterBinding getOutputBinding(String string) {
        ParameterBinding parameterBinding;
        if (this.emptyOutputBody == null) {
            this.emptyOutputBody = this.outputParts.get(" ") != null ? Boolean.valueOf(true) : Boolean.valueOf(false);
        }
        if ((parameterBinding = this.outputParts.get(string)) == null) {
            if (this.explicitOutputSOAPBodyParts || this.emptyOutputBody.booleanValue()) {
                return ParameterBinding.UNBOUND;
            }
            return ParameterBinding.BODY;
        }
        return parameterBinding;
    }

    @Override
    public ParameterBinding getFaultBinding(String string) {
        ParameterBinding parameterBinding;
        if (this.emptyFaultBody == null) {
            this.emptyFaultBody = this.faultParts.get(" ") != null ? Boolean.valueOf(true) : Boolean.valueOf(false);
        }
        if ((parameterBinding = this.faultParts.get(string)) == null) {
            if (this.explicitFaultSOAPBodyParts || this.emptyFaultBody.booleanValue()) {
                return ParameterBinding.UNBOUND;
            }
            return ParameterBinding.BODY;
        }
        return parameterBinding;
    }

    @Override
    public String getMimeTypeForInputPart(String string) {
        return this.inputMimeTypes.get(string);
    }

    @Override
    public String getMimeTypeForOutputPart(String string) {
        return this.outputMimeTypes.get(string);
    }

    @Override
    public String getMimeTypeForFaultPart(String string) {
        return this.faultMimeTypes.get(string);
    }

    @Override
    public EditableWSDLOperation getOperation() {
        return this.operation;
    }

    @Override
    public EditableWSDLBoundPortType getBoundPortType() {
        return this.owner;
    }

    @Override
    public void setInputExplicitBodyParts(boolean bl) {
        this.explicitInputSOAPBodyParts = bl;
    }

    @Override
    public void setOutputExplicitBodyParts(boolean bl) {
        this.explicitOutputSOAPBodyParts = bl;
    }

    @Override
    public void setFaultExplicitBodyParts(boolean bl) {
        this.explicitFaultSOAPBodyParts = bl;
    }

    @Override
    public void setStyle(SOAPBinding.Style style) {
        this.style = style;
    }

    @Override
    @Nullable
    public QName getRequestPayloadName() {
        if (this.emptyRequestPayload) {
            return null;
        }
        if (this.requestPayloadName != null) {
            return this.requestPayloadName;
        }
        if (this.style.equals((Object)SOAPBinding.Style.RPC)) {
            String string = this.getRequestNamespace() != null ? this.getRequestNamespace() : this.name.getNamespaceURI();
            this.requestPayloadName = new QName(string, this.name.getLocalPart());
            return this.requestPayloadName;
        }
        QName qName = this.operation.getInput().getMessage().getName();
        EditableWSDLMessage editableWSDLMessage = this.messages.get(qName);
        for (EditableWSDLPart editableWSDLPart : editableWSDLMessage.parts()) {
            ParameterBinding parameterBinding = this.getInputBinding(editableWSDLPart.getName());
            if (!parameterBinding.isBody()) continue;
            this.requestPayloadName = editableWSDLPart.getDescriptor().name();
            return this.requestPayloadName;
        }
        this.emptyRequestPayload = true;
        return null;
    }

    @Override
    @Nullable
    public QName getResponsePayloadName() {
        if (this.emptyResponsePayload) {
            return null;
        }
        if (this.responsePayloadName != null) {
            return this.responsePayloadName;
        }
        if (this.style.equals((Object)SOAPBinding.Style.RPC)) {
            String string = this.getResponseNamespace() != null ? this.getResponseNamespace() : this.name.getNamespaceURI();
            this.responsePayloadName = new QName(string, this.name.getLocalPart() + "Response");
            return this.responsePayloadName;
        }
        QName qName = this.operation.getOutput().getMessage().getName();
        EditableWSDLMessage editableWSDLMessage = this.messages.get(qName);
        for (EditableWSDLPart editableWSDLPart : editableWSDLMessage.parts()) {
            ParameterBinding parameterBinding = this.getOutputBinding(editableWSDLPart.getName());
            if (!parameterBinding.isBody()) continue;
            this.responsePayloadName = editableWSDLPart.getDescriptor().name();
            return this.responsePayloadName;
        }
        this.emptyResponsePayload = true;
        return null;
    }

    @Override
    public String getRequestNamespace() {
        return this.reqNamespace != null ? this.reqNamespace : this.name.getNamespaceURI();
    }

    @Override
    public void setRequestNamespace(String string) {
        this.reqNamespace = string;
    }

    @Override
    public String getResponseNamespace() {
        return this.respNamespace != null ? this.respNamespace : this.name.getNamespaceURI();
    }

    @Override
    public void setResponseNamespace(String string) {
        this.respNamespace = string;
    }

    EditableWSDLBoundPortType getOwner() {
        return this.owner;
    }

    @Override
    public void freeze(EditableWSDLModel editableWSDLModel) {
        this.messages = editableWSDLModel.getMessages();
        this.operation = this.owner.getPortType().get(this.name.getLocalPart());
        for (EditableWSDLBoundFault editableWSDLBoundFault : this.wsdlBoundFaults) {
            editableWSDLBoundFault.freeze(this);
        }
    }

    @Override
    public void setAnonymous(WSDLBoundOperation.ANONYMOUS aNONYMOUS) {
        this.anonymous = aNONYMOUS;
    }

    @Override
    public WSDLBoundOperation.ANONYMOUS getAnonymous() {
        return this.anonymous;
    }
}

