/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.swt.widgets;

import org.eclipse.swt.SWT;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.internal.win32.OS;
import org.eclipse.swt.internal.win32.RECT;
import org.eclipse.swt.internal.win32.SCROLLINFO;
import org.eclipse.swt.internal.win32.TCHAR;
import org.eclipse.swt.internal.win32.TVITEM;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Item;
import org.eclipse.swt.widgets.Tree;

public class TreeItem
extends Item {
    public int handle;
    Tree parent;
    String[] strings;
    Image[] images;
    boolean cached;
    int background = -1;
    int foreground = -1;
    int font = -1;
    int[] cellBackground;
    int[] cellForeground;
    int[] cellFont;

    public TreeItem(Tree tree, int n2) {
        this(tree, n2, 0, -65534, 0);
    }

    public TreeItem(Tree tree, int n2, int n3) {
        this(tree, n2, 0, TreeItem.findPrevious(tree, n3), 0);
    }

    public TreeItem(TreeItem treeItem, int n2) {
        this(TreeItem.checkNull((TreeItem)treeItem).parent, n2, treeItem.handle, -65534, 0);
    }

    public TreeItem(TreeItem treeItem, int n2, int n3) {
        this(TreeItem.checkNull((TreeItem)treeItem).parent, n2, treeItem.handle, TreeItem.findPrevious(treeItem, n3), 0);
    }

    TreeItem(Tree tree, int n2, int n3, int n4, int n5) {
        super(tree, n2);
        this.parent = tree;
        tree.createItem(this, n3, n4, n5);
    }

    static TreeItem checkNull(TreeItem treeItem) {
        if (treeItem == null) {
            SWT.error(4);
        }
        return treeItem;
    }

    static int findPrevious(Tree tree, int n2) {
        if (tree == null) {
            return 0;
        }
        if (n2 < 0) {
            SWT.error(6);
        }
        if (n2 == 0) {
            return -65535;
        }
        int n3 = tree.handle;
        int n4 = OS.SendMessage(n3, 4362, 0, 0);
        int n5 = tree.findItem(n4, n2 - 1);
        if (n5 == 0) {
            SWT.error(6);
        }
        return n5;
    }

    static int findPrevious(TreeItem treeItem, int n2) {
        if (treeItem == null) {
            return 0;
        }
        if (n2 < 0) {
            SWT.error(6);
        }
        if (n2 == 0) {
            return -65535;
        }
        Tree tree = treeItem.parent;
        int n3 = tree.handle;
        int n4 = treeItem.handle;
        int n5 = OS.SendMessage(n3, 4362, 4, n4);
        int n6 = tree.findItem(n5, n2 - 1);
        if (n6 == 0) {
            SWT.error(6);
        }
        return n6;
    }

    protected void checkSubclass() {
        if (!this.isValidSubclass()) {
            this.error(43);
        }
    }

    void clear() {
        this.text = "";
        this.image = null;
        this.strings = null;
        this.images = null;
        if ((this.parent.style & 0x20) != 0) {
            int n2 = this.parent.handle;
            TVITEM tVITEM = new TVITEM();
            tVITEM.mask = 24;
            tVITEM.stateMask = 61440;
            tVITEM.state = 4096;
            tVITEM.hItem = this.handle;
            OS.SendMessage(n2, OS.TVM_SETITEM, 0, tVITEM);
        }
        this.font = -1;
        this.foreground = -1;
        this.background = -1;
        this.cellFont = null;
        this.cellForeground = null;
        this.cellBackground = null;
        if ((this.parent.style & 0x10000000) != 0) {
            this.cached = false;
        }
    }

    public void clear(int n2, boolean bl2) {
        this.checkWidget();
        int n3 = this.parent.handle;
        int n4 = OS.SendMessage(n3, 4362, 4, this.handle);
        if (n4 == 0) {
            this.error(6);
        }
        if ((n4 = this.parent.findItem(n4, n2)) == 0) {
            this.error(6);
        }
        TVITEM tVITEM = new TVITEM();
        tVITEM.mask = 20;
        this.parent.clear(n4, tVITEM);
        if (bl2) {
            n4 = OS.SendMessage(n3, 4362, 4, n4);
            this.parent.clearAll(n4, tVITEM, bl2);
        }
    }

    public void clearAll(boolean bl2) {
        this.checkWidget();
        int n2 = this.parent.handle;
        int n3 = OS.SendMessage(n2, 4362, 4, this.handle);
        if (n3 == 0) {
            return;
        }
        TVITEM tVITEM = new TVITEM();
        tVITEM.mask = 20;
        this.parent.clearAll(n3, tVITEM, bl2);
    }

    void destroyWidget() {
        TVITEM tVITEM = new TVITEM();
        tVITEM.mask = 20;
        this.parent.releaseItem(this.handle, tVITEM, false);
        this.parent.destroyItem(this, this.handle);
        this.releaseHandle();
    }

    public Color getBackground() {
        this.checkWidget();
        if (!this.parent.checkData(this, true)) {
            this.error(24);
        }
        if (this.background == -1) {
            return this.parent.getBackground();
        }
        return Color.win32_new(this.display, this.background);
    }

    public Color getBackground(int n2) {
        this.checkWidget();
        if (!this.parent.checkData(this, true)) {
            this.error(24);
        }
        int n3 = Math.max(1, this.parent.getColumnCount());
        if (n2 < 0 || n2 > n3 - 1) {
            return this.getBackground();
        }
        int n4 = this.cellBackground != null ? this.cellBackground[n2] : -1;
        return n4 == -1 ? this.getBackground() : Color.win32_new(this.display, n4);
    }

    public Rectangle getBounds() {
        this.checkWidget();
        if (!this.parent.checkData(this, true)) {
            this.error(24);
        }
        RECT rECT = this.getBounds(0, true, false, false);
        int n2 = rECT.right - rECT.left;
        int n3 = rECT.bottom - rECT.top;
        return new Rectangle(rECT.left, rECT.top, n2, n3);
    }

    public Rectangle getBounds(int n2) {
        this.checkWidget();
        if (!this.parent.checkData(this, true)) {
            this.error(24);
        }
        RECT rECT = this.getBounds(n2, true, true, true);
        int n3 = rECT.right - rECT.left;
        int n4 = rECT.bottom - rECT.top;
        return new Rectangle(rECT.left, rECT.top, n3, n4);
    }

    RECT getBounds(int n2, boolean bl2, boolean bl3, boolean bl4) {
        return this.getBounds(n2, bl2, bl3, bl4, false, true, 0);
    }

    RECT getBounds(int n2, boolean bl2, boolean bl3, boolean bl4, boolean bl5, boolean bl6, int n3) {
        int n4;
        if (!bl2 && !bl3) {
            return new RECT();
        }
        int n5 = this.parent.handle;
        if ((this.parent.style & 0x10000000) == 0 && !this.cached && !this.parent.painted) {
            TVITEM tVITEM = new TVITEM();
            tVITEM.mask = 17;
            tVITEM.hItem = this.handle;
            tVITEM.pszText = -1;
            this.parent.ignoreCustomDraw = true;
            OS.SendMessage(n5, OS.TVM_SETITEM, 0, tVITEM);
            this.parent.ignoreCustomDraw = false;
        }
        boolean bl7 = n2 == 0;
        int n6 = 0;
        int n7 = this.parent.hwndHeader;
        if (n7 != 0) {
            n6 = OS.SendMessage(n7, 4608, 0, 0);
            bl7 = n2 == OS.SendMessage(n7, 4623, 0, 0);
        }
        RECT rECT = new RECT();
        if (bl7) {
            Object object;
            rECT.left = this.handle;
            n4 = n6 == 0 && bl2 && bl3 && bl4 && bl5 ? 1 : 0;
            if (OS.SendMessage(n5, 4356, n4 != 0 ? 0 : 1, rECT) == 0) {
                return new RECT();
            }
            if (bl3 && !bl5) {
                if (OS.SendMessage(n5, 4360, 0, 0) != 0) {
                    object = this.parent.getImageSize();
                    rECT.left -= ((Point)object).x + 3;
                    if (!bl2) {
                        rECT.right = rECT.left + ((Point)object).x;
                    }
                } else if (!bl2) {
                    rECT.right = rECT.left;
                }
            }
            if ((bl4 || bl5 || bl6) && n7 != 0) {
                object = new RECT();
                if (n6 != 0) {
                    if (OS.SendMessage(n7, 4615, n2, (RECT)object) == 0) {
                        return new RECT();
                    }
                } else {
                    ((RECT)object).right = this.parent.scrollWidth;
                    if (((RECT)object).right == 0) {
                        object = rECT;
                    }
                }
                if (bl4) {
                    rECT.right = ((RECT)object).right;
                }
                if (bl5) {
                    rECT.left = ((RECT)object).left;
                }
                if (bl6 && ((RECT)object).right < rECT.right) {
                    rECT.right = ((RECT)object).right;
                }
            }
        } else {
            if (n2 < 0 || n2 >= n6) {
                return new RECT();
            }
            RECT rECT2 = new RECT();
            if (OS.SendMessage(n7, 4615, n2, rECT2) == 0) {
                return new RECT();
            }
            rECT.left = this.handle;
            if (OS.SendMessage(n5, 4356, 0, rECT) == 0) {
                return new RECT();
            }
            rECT.left = rECT2.left;
            if (bl4 && bl3) {
                rECT.right = rECT2.right;
            } else {
                Object object;
                rECT.right = rECT2.left;
                Image image = null;
                if (n2 == 0) {
                    image = this.image;
                } else if (this.images != null) {
                    image = this.images[n2];
                }
                if (image != null) {
                    object = this.parent.getImageSize();
                    rECT.right += ((Point)object).x;
                }
                if (bl2) {
                    if (bl4) {
                        rECT.left = rECT.right + 3;
                        rECT.right = rECT2.right;
                    } else {
                        Object object2 = n2 == 0 ? this.text : (object = this.strings != null ? this.strings[n2] : null);
                        if (object != null) {
                            RECT rECT3 = new RECT();
                            TCHAR tCHAR = new TCHAR(this.parent.getCodePage(), (String)object, false);
                            int n8 = 3104;
                            int n9 = n3;
                            int n10 = 0;
                            if (n3 == 0) {
                                n9 = OS.GetDC(n5);
                                int n11 = n10 = this.cellFont != null ? this.cellFont[n2] : -1;
                                if (n10 == -1) {
                                    n10 = this.font;
                                }
                                if (n10 == -1) {
                                    n10 = OS.SendMessage(n5, 49, 0, 0);
                                }
                                n10 = OS.SelectObject(n9, n10);
                            }
                            OS.DrawText(n9, tCHAR, tCHAR.length(), rECT3, n8);
                            if (n3 == 0) {
                                OS.SelectObject(n9, n10);
                                OS.ReleaseDC(n5, n9);
                            }
                            if (bl3) {
                                rECT.right += rECT3.right - rECT3.left + 9;
                            } else {
                                rECT.left = rECT.right + 3;
                                rECT.right = rECT.left + (rECT3.right - rECT3.left) + 3;
                            }
                        }
                    }
                }
                if (bl6 && rECT2.right < rECT.right) {
                    rECT.right = rECT2.right;
                }
            }
        }
        int n12 = n4 = this.parent.linesVisible && n6 != 0 ? 1 : 0;
        if (bl2 || !bl3) {
            rECT.right = Math.max(rECT.left, rECT.right - n4);
        }
        rECT.bottom = Math.max(rECT.top, rECT.bottom - n4);
        return rECT;
    }

    public boolean getChecked() {
        this.checkWidget();
        if (!this.parent.checkData(this, true)) {
            this.error(24);
        }
        if ((this.parent.style & 0x20) == 0) {
            return false;
        }
        int n2 = this.parent.handle;
        TVITEM tVITEM = new TVITEM();
        tVITEM.mask = 24;
        tVITEM.stateMask = 61440;
        tVITEM.hItem = this.handle;
        int n3 = OS.SendMessage(n2, OS.TVM_GETITEM, 0, tVITEM);
        return n3 != 0 && (tVITEM.state >> 12 & 1) == 0;
    }

    public boolean getExpanded() {
        this.checkWidget();
        int n2 = this.parent.handle;
        int n3 = 0;
        if (OS.IsWinCE) {
            TVITEM tVITEM = new TVITEM();
            tVITEM.hItem = this.handle;
            tVITEM.mask = 8;
            OS.SendMessage(n2, OS.TVM_GETITEM, 0, tVITEM);
            n3 = tVITEM.state;
        } else {
            n3 = OS.SendMessage(n2, 4391, this.handle, 32);
        }
        return (n3 & 0x20) != 0;
    }

    public Font getFont() {
        this.checkWidget();
        if (!this.parent.checkData(this, true)) {
            this.error(24);
        }
        return this.font == -1 ? this.parent.getFont() : Font.win32_new(this.display, this.font);
    }

    public Font getFont(int n2) {
        this.checkWidget();
        if (!this.parent.checkData(this, true)) {
            this.error(24);
        }
        int n3 = Math.max(1, this.parent.getColumnCount());
        if (n2 < 0 || n2 > n3 - 1) {
            return this.getFont();
        }
        int n4 = this.cellFont != null ? this.cellFont[n2] : this.font;
        return n4 == -1 ? this.getFont() : Font.win32_new(this.display, n4);
    }

    public Color getForeground() {
        this.checkWidget();
        if (!this.parent.checkData(this, true)) {
            this.error(24);
        }
        if (this.foreground == -1) {
            return this.parent.getForeground();
        }
        return Color.win32_new(this.display, this.foreground);
    }

    public Color getForeground(int n2) {
        this.checkWidget();
        if (!this.parent.checkData(this, true)) {
            this.error(24);
        }
        int n3 = Math.max(1, this.parent.getColumnCount());
        if (n2 < 0 || n2 > n3 - 1) {
            return this.getForeground();
        }
        int n4 = this.cellForeground != null ? this.cellForeground[n2] : -1;
        return n4 == -1 ? this.getForeground() : Color.win32_new(this.display, n4);
    }

    public boolean getGrayed() {
        this.checkWidget();
        if (!this.parent.checkData(this, true)) {
            this.error(24);
        }
        if ((this.parent.style & 0x20) == 0) {
            return false;
        }
        int n2 = this.parent.handle;
        TVITEM tVITEM = new TVITEM();
        tVITEM.mask = 24;
        tVITEM.stateMask = 61440;
        tVITEM.hItem = this.handle;
        int n3 = OS.SendMessage(n2, OS.TVM_GETITEM, 0, tVITEM);
        return n3 != 0 && tVITEM.state >> 12 > 2;
    }

    public TreeItem getItem(int n2) {
        int n3;
        int n4;
        int n5;
        this.checkWidget();
        if (n2 < 0) {
            this.error(6);
        }
        if (!this.parent.checkData(this, true)) {
            this.error(24);
        }
        if ((n5 = OS.SendMessage(n4 = this.parent.handle, 4362, 4, this.handle)) == 0) {
            this.error(6);
        }
        if ((n3 = this.parent.findItem(n5, n2)) == 0) {
            this.error(6);
        }
        return this.parent._getItem(n3);
    }

    public int getItemCount() {
        int n2;
        int n3;
        this.checkWidget();
        if (!this.parent.checkData(this, true)) {
            this.error(24);
        }
        if ((n3 = OS.SendMessage(n2 = this.parent.handle, 4362, 4, this.handle)) == 0) {
            return 0;
        }
        return this.parent.getItemCount(n3);
    }

    public TreeItem[] getItems() {
        int n2;
        int n3;
        this.checkWidget();
        if (!this.parent.checkData(this, true)) {
            this.error(24);
        }
        if ((n3 = OS.SendMessage(n2 = this.parent.handle, 4362, 4, this.handle)) == 0) {
            return new TreeItem[0];
        }
        return this.parent.getItems(n3);
    }

    public Image getImage() {
        this.checkWidget();
        if (!this.parent.checkData(this, true)) {
            this.error(24);
        }
        return super.getImage();
    }

    public Image getImage(int n2) {
        this.checkWidget();
        if (!this.parent.checkData(this, true)) {
            this.error(24);
        }
        if (n2 == 0) {
            return this.getImage();
        }
        if (this.images != null && n2 >= 0 && n2 < this.images.length) {
            return this.images[n2];
        }
        return null;
    }

    public Rectangle getImageBounds(int n2) {
        this.checkWidget();
        if (!this.parent.checkData(this, true)) {
            this.error(24);
        }
        RECT rECT = this.getBounds(n2, false, true, false);
        int n3 = rECT.right - rECT.left;
        int n4 = rECT.bottom - rECT.top;
        return new Rectangle(rECT.left, rECT.top, n3, n4);
    }

    public Tree getParent() {
        this.checkWidget();
        return this.parent;
    }

    public TreeItem getParentItem() {
        this.checkWidget();
        int n2 = this.parent.handle;
        int n3 = OS.SendMessage(n2, 4362, 3, this.handle);
        return n3 != 0 ? this.parent._getItem(n3) : null;
    }

    public String getText() {
        this.checkWidget();
        if (!this.parent.checkData(this, true)) {
            this.error(24);
        }
        return super.getText();
    }

    public String getText(int n2) {
        this.checkWidget();
        if (!this.parent.checkData(this, true)) {
            this.error(24);
        }
        if (n2 == 0) {
            return this.getText();
        }
        if (this.strings != null && n2 >= 0 && n2 < this.strings.length) {
            String string = this.strings[n2];
            return string != null ? string : "";
        }
        return "";
    }

    public Rectangle getTextBounds(int n2) {
        this.checkWidget();
        if (!this.parent.checkData(this, true)) {
            this.error(24);
        }
        RECT rECT = this.getBounds(n2, true, false, true);
        if (n2 == 0) {
            rECT.left += 2;
        }
        rECT.left = Math.min(rECT.left, rECT.right);
        rECT.right -= 3;
        int n3 = Math.max(0, rECT.right - rECT.left);
        int n4 = Math.max(0, rECT.bottom - rECT.top);
        return new Rectangle(rECT.left, rECT.top, n3, n4);
    }

    public int indexOf(TreeItem treeItem) {
        int n2;
        int n3;
        this.checkWidget();
        if (treeItem == null) {
            this.error(4);
        }
        if (treeItem.isDisposed()) {
            this.error(5);
        }
        return (n3 = OS.SendMessage(n2 = this.parent.handle, 4362, 4, this.handle)) == 0 ? -1 : this.parent.findIndex(n3, treeItem.handle);
    }

    void redraw() {
        boolean bl2;
        if (this.parent.currentItem == this || this.parent.drawCount != 0) {
            return;
        }
        int n2 = this.parent.handle;
        if (!OS.IsWindowVisible(n2)) {
            return;
        }
        RECT rECT = new RECT();
        rECT.left = this.handle;
        boolean bl3 = bl2 = (this.parent.style & 0x10010000) != 0;
        if (!bl2) {
            int n3 = this.parent.hwndHeader;
            if (n3 != 0) {
                boolean bl4 = bl2 = OS.SendMessage(n3, 4608, 0, 0) != 0;
            }
            if (!bl2 && (this.parent.hooks(40) || this.parent.hooks(42))) {
                bl2 = true;
            }
        }
        if (OS.SendMessage(n2, 4356, bl2 ? 0 : 1, rECT) != 0) {
            OS.InvalidateRect(n2, rECT, true);
        }
    }

    void redraw(int n2, boolean bl2, boolean bl3) {
        if (this.parent.currentItem == this || this.parent.drawCount != 0) {
            return;
        }
        int n3 = this.parent.handle;
        if (!OS.IsWindowVisible(n3)) {
            return;
        }
        boolean bl4 = n2 == 0 && bl2 && bl3;
        RECT rECT = this.getBounds(n2, bl2, bl3, true, bl4, true, 0);
        OS.InvalidateRect(n3, rECT, true);
    }

    void releaseChildren(boolean bl2) {
        if (bl2) {
            TVITEM tVITEM = new TVITEM();
            tVITEM.mask = 20;
            this.parent.releaseItems(this.handle, tVITEM);
        }
        super.releaseChildren(bl2);
    }

    void releaseHandle() {
        super.releaseHandle();
        this.handle = 0;
        this.parent = null;
    }

    void releaseWidget() {
        super.releaseWidget();
        this.strings = null;
        this.images = null;
        this.cellFont = null;
        this.cellForeground = null;
        this.cellBackground = null;
    }

    public void removeAll() {
        this.checkWidget();
        int n2 = this.parent.handle;
        TVITEM tVITEM = new TVITEM();
        tVITEM.mask = 20;
        tVITEM.hItem = OS.SendMessage(n2, 4362, 4, this.handle);
        while (tVITEM.hItem != 0) {
            TreeItem treeItem;
            OS.SendMessage(n2, OS.TVM_GETITEM, 0, tVITEM);
            TreeItem treeItem2 = treeItem = tVITEM.lParam != -1 ? this.parent.items[tVITEM.lParam] : null;
            if (treeItem != null && !treeItem.isDisposed()) {
                treeItem.dispose();
            } else {
                this.parent.releaseItem(tVITEM.hItem, tVITEM, false);
                this.parent.destroyItem(null, tVITEM.hItem);
            }
            tVITEM.hItem = OS.SendMessage(n2, 4362, 4, this.handle);
        }
    }

    public void setBackground(Color color) {
        this.checkWidget();
        if (color != null && color.isDisposed()) {
            SWT.error(5);
        }
        int n2 = -1;
        if (color != null) {
            this.parent.customDraw = true;
            n2 = color.handle;
        }
        if (this.background == n2) {
            return;
        }
        this.background = n2;
        if ((this.parent.style & 0x10000000) != 0) {
            this.cached = true;
        }
        this.redraw();
    }

    public void setBackground(int n2, Color color) {
        this.checkWidget();
        if (color != null && color.isDisposed()) {
            SWT.error(5);
        }
        int n3 = Math.max(1, this.parent.getColumnCount());
        if (n2 < 0 || n2 > n3 - 1) {
            return;
        }
        int n4 = -1;
        if (color != null) {
            this.parent.customDraw = true;
            n4 = color.handle;
        }
        if (this.cellBackground == null) {
            this.cellBackground = new int[n3];
            int n5 = 0;
            while (n5 < n3) {
                this.cellBackground[n5] = -1;
                ++n5;
            }
        }
        if (this.cellBackground[n2] == n4) {
            return;
        }
        this.cellBackground[n2] = n4;
        if ((this.parent.style & 0x10000000) != 0) {
            this.cached = true;
        }
        this.redraw(n2, true, true);
    }

    public void setChecked(boolean bl2) {
        this.checkWidget();
        if ((this.parent.style & 0x20) == 0) {
            return;
        }
        int n2 = this.parent.handle;
        TVITEM tVITEM = new TVITEM();
        tVITEM.mask = 24;
        tVITEM.stateMask = 61440;
        tVITEM.hItem = this.handle;
        OS.SendMessage(n2, OS.TVM_GETITEM, 0, tVITEM);
        int n3 = tVITEM.state >> 12;
        if (bl2) {
            if ((n3 & 1) != 0) {
                ++n3;
            }
        } else if ((n3 & 1) == 0) {
            --n3;
        }
        if (tVITEM.state == (n3 <<= 12)) {
            return;
        }
        if ((this.parent.style & 0x10000000) != 0) {
            this.cached = true;
        }
        tVITEM.state = n3;
        OS.SendMessage(n2, OS.TVM_SETITEM, 0, tVITEM);
        if ((this.parent.style & 0x10000000) != 0 && this.parent.currentItem == this && OS.IsWindowVisible(n2)) {
            RECT rECT = new RECT();
            rECT.left = this.handle;
            if (OS.SendMessage(n2, 4356, 0, rECT) != 0) {
                OS.InvalidateRect(n2, rECT, true);
            }
        }
    }

    public void setExpanded(boolean bl2) {
        Object object;
        int n2;
        int n3;
        int n4;
        Object object2;
        this.checkWidget();
        int n5 = this.parent.handle;
        if (OS.SendMessage(n5, 4362, 4, this.handle) == 0) {
            return;
        }
        int n6 = 0;
        if (OS.IsWinCE) {
            object2 = new TVITEM();
            ((TVITEM)object2).hItem = this.handle;
            ((TVITEM)object2).mask = 8;
            OS.SendMessage(n5, OS.TVM_GETITEM, 0, (TVITEM)object2);
            n6 = ((TVITEM)object2).state;
        } else {
            n6 = OS.SendMessage(n5, 4391, this.handle, 32);
        }
        if ((n6 & 0x20) != 0 == bl2) {
            return;
        }
        object2 = null;
        RECT[] rECTArray = null;
        SCROLLINFO sCROLLINFO = null;
        int n7 = 0;
        int n8 = 0;
        boolean bl3 = false;
        boolean bl4 = true;
        int n9 = OS.SendMessage(n5, 4362, 5, 0);
        if (bl4 && n9 != 0) {
            sCROLLINFO = new SCROLLINFO();
            sCROLLINFO.cbSize = SCROLLINFO.sizeof;
            sCROLLINFO.fMask = 23;
            if (!OS.GetScrollInfo(n5, 0, sCROLLINFO)) {
                sCROLLINFO = null;
            }
            if (this.parent.drawCount == 0 && OS.IsWindowVisible(n5)) {
                n4 = 1;
                n7 = OS.SendMessage(n5, 4368, 0, 0);
                rECTArray = new RECT[n7 + 1];
                n3 = n9;
                n2 = 0;
                while (n3 != 0 && (n4 != 0 || n3 != this.handle) && n2 < n7) {
                    object = new RECT();
                    ((RECT)object).left = n3;
                    if (OS.SendMessage(n5, 4356, 1, (RECT)object) != 0) {
                        rECTArray[n2++] = object;
                    }
                    n3 = OS.SendMessage(n5, 4362, 6, n3);
                }
                if (n4 != 0 || n3 != this.handle) {
                    bl3 = true;
                    n7 = n2;
                    n8 = n3;
                    object2 = new RECT();
                    OS.GetClientRect(n5, (RECT)object2);
                    int n10 = this.parent.topHandle();
                    OS.UpdateWindow(n10);
                    OS.DefWindowProc(n10, 11, 0, 0);
                    if (n5 != n10) {
                        OS.UpdateWindow(n5);
                        OS.DefWindowProc(n5, 11, 0, 0);
                    }
                }
            }
        }
        n4 = OS.SendMessage(n5, 4362, 9, 0);
        this.parent.ignoreExpand = true;
        OS.SendMessage(n5, 4354, bl2 ? 2 : 1, this.handle);
        this.parent.ignoreExpand = false;
        if (bl4 && n9 != 0) {
            int n11;
            n3 = 0;
            if (!bl2) {
                RECT rECT = new RECT();
                rECT.left = n9;
                while (n9 != 0 && OS.SendMessage(n5, 4356, 0, rECT) == 0) {
                    n9 = rECT.left = OS.SendMessage(n5, 4362, 3, n9);
                    n3 = 1;
                }
            }
            n2 = 1;
            if (n9 != 0) {
                OS.SendMessage(n5, 4363, 5, n9);
                int n12 = n2 = n9 != OS.SendMessage(n5, 4362, 5, 0) ? 1 : 0;
            }
            if (n3 == 0 && n2 == 0 && sCROLLINFO != null) {
                object = new SCROLLINFO();
                ((SCROLLINFO)object).cbSize = SCROLLINFO.sizeof;
                ((SCROLLINFO)object).fMask = 23;
                if (OS.GetScrollInfo(n5, 0, (SCROLLINFO)object) && sCROLLINFO.nPos != ((SCROLLINFO)object).nPos) {
                    n11 = 4 | sCROLLINFO.nPos << 16 & 0xFFFF0000;
                    OS.SendMessage(n5, 276, n11, 0);
                }
            }
            if (bl3) {
                int n13;
                boolean bl5 = false;
                if (n3 == 0 && n2 == 0) {
                    RECT rECT = new RECT();
                    OS.GetClientRect(n5, rECT);
                    if (OS.EqualRect((RECT)object2, rECT)) {
                        n13 = n9;
                        int n14 = 0;
                        while (n13 != 0 && n14 < n7) {
                            RECT rECT2 = new RECT();
                            rECT2.left = n13;
                            if (OS.SendMessage(n5, 4356, 1, rECT2) != 0 && !OS.EqualRect(rECT2, rECTArray[n14])) break;
                            n13 = OS.SendMessage(n5, 4362, 6, n13);
                            ++n14;
                        }
                        bl5 = n14 == n7 && n13 == n8;
                    }
                }
                n11 = this.parent.topHandle();
                OS.DefWindowProc(n11, 11, 1, 0);
                if (n5 != n11) {
                    OS.DefWindowProc(n5, 11, 1, 0);
                }
                if (bl5) {
                    this.parent.updateScrollBar();
                    SCROLLINFO sCROLLINFO2 = new SCROLLINFO();
                    sCROLLINFO2.cbSize = SCROLLINFO.sizeof;
                    sCROLLINFO2.fMask = 23;
                    if (OS.GetScrollInfo(n5, 1, sCROLLINFO2)) {
                        OS.SetScrollInfo(n5, 1, sCROLLINFO2, true);
                    }
                    if (this.handle == n8) {
                        RECT rECT = new RECT();
                        rECT.left = n8;
                        if (OS.SendMessage(n5, 4356, 0, rECT) != 0) {
                            OS.InvalidateRect(n5, rECT, true);
                        }
                    }
                } else if (OS.IsWinCE) {
                    OS.InvalidateRect(n11, null, true);
                    if (n5 != n11) {
                        OS.InvalidateRect(n5, null, true);
                    }
                } else {
                    n13 = 1157;
                    OS.RedrawWindow(n11, null, 0, n13);
                }
            }
        }
        if ((n3 = OS.SendMessage(n5, 4362, 9, 0)) != n4) {
            Event event = new Event();
            if (n3 != 0) {
                event.item = this.parent._getItem(n3);
                this.parent.hAnchor = n3;
            }
            this.parent.sendEvent(13, event);
        }
    }

    public void setFont(Font font) {
        this.checkWidget();
        if (font != null && font.isDisposed()) {
            SWT.error(5);
        }
        int n2 = -1;
        if (font != null) {
            this.parent.customDraw = true;
            n2 = font.handle;
        }
        if (this.font == n2) {
            return;
        }
        this.font = n2;
        if ((this.parent.style & 0x10000000) != 0) {
            this.cached = true;
        }
        if ((this.parent.style & 0x10000000) == 0 && !this.cached && !this.parent.painted) {
            return;
        }
        int n3 = this.parent.handle;
        TVITEM tVITEM = new TVITEM();
        tVITEM.mask = 17;
        tVITEM.hItem = this.handle;
        tVITEM.pszText = -1;
        OS.SendMessage(n3, OS.TVM_SETITEM, 0, tVITEM);
    }

    public void setFont(int n2, Font font) {
        int n3;
        this.checkWidget();
        if (font != null && font.isDisposed()) {
            SWT.error(5);
        }
        int n4 = Math.max(1, this.parent.getColumnCount());
        if (n2 < 0 || n2 > n4 - 1) {
            return;
        }
        int n5 = -1;
        if (font != null) {
            this.parent.customDraw = true;
            n5 = font.handle;
        }
        if (this.cellFont == null) {
            this.cellFont = new int[n4];
            n3 = 0;
            while (n3 < n4) {
                this.cellFont[n3] = -1;
                ++n3;
            }
        }
        if (this.cellFont[n2] == n5) {
            return;
        }
        this.cellFont[n2] = n5;
        if ((this.parent.style & 0x10000000) != 0) {
            this.cached = true;
        }
        if (n2 == 0) {
            if ((this.parent.style & 0x10000000) == 0 && !this.cached && !this.parent.painted) {
                return;
            }
            n3 = this.parent.handle;
            TVITEM tVITEM = new TVITEM();
            tVITEM.mask = 17;
            tVITEM.hItem = this.handle;
            tVITEM.pszText = -1;
            OS.SendMessage(n3, OS.TVM_SETITEM, 0, tVITEM);
        } else {
            this.redraw(n2, true, false);
        }
    }

    public void setForeground(Color color) {
        this.checkWidget();
        if (color != null && color.isDisposed()) {
            SWT.error(5);
        }
        int n2 = -1;
        if (color != null) {
            this.parent.customDraw = true;
            n2 = color.handle;
        }
        if (this.foreground == n2) {
            return;
        }
        this.foreground = n2;
        if ((this.parent.style & 0x10000000) != 0) {
            this.cached = true;
        }
        this.redraw();
    }

    public void setForeground(int n2, Color color) {
        this.checkWidget();
        if (color != null && color.isDisposed()) {
            SWT.error(5);
        }
        int n3 = Math.max(1, this.parent.getColumnCount());
        if (n2 < 0 || n2 > n3 - 1) {
            return;
        }
        int n4 = -1;
        if (color != null) {
            this.parent.customDraw = true;
            n4 = color.handle;
        }
        if (this.cellForeground == null) {
            this.cellForeground = new int[n3];
            int n5 = 0;
            while (n5 < n3) {
                this.cellForeground[n5] = -1;
                ++n5;
            }
        }
        if (this.cellForeground[n2] == n4) {
            return;
        }
        this.cellForeground[n2] = n4;
        if ((this.parent.style & 0x10000000) != 0) {
            this.cached = true;
        }
        this.redraw(n2, true, false);
    }

    public void setGrayed(boolean bl2) {
        this.checkWidget();
        if ((this.parent.style & 0x20) == 0) {
            return;
        }
        int n2 = this.parent.handle;
        TVITEM tVITEM = new TVITEM();
        tVITEM.mask = 24;
        tVITEM.stateMask = 61440;
        tVITEM.hItem = this.handle;
        OS.SendMessage(n2, OS.TVM_GETITEM, 0, tVITEM);
        int n3 = tVITEM.state >> 12;
        if (bl2) {
            if (n3 <= 2) {
                n3 += 2;
            }
        } else if (n3 > 2) {
            n3 -= 2;
        }
        if (tVITEM.state == (n3 <<= 12)) {
            return;
        }
        if ((this.parent.style & 0x10000000) != 0) {
            this.cached = true;
        }
        tVITEM.state = n3;
        OS.SendMessage(n2, OS.TVM_SETITEM, 0, tVITEM);
        if ((this.parent.style & 0x10000000) != 0 && this.parent.currentItem == this && OS.IsWindowVisible(n2)) {
            RECT rECT = new RECT();
            rECT.left = this.handle;
            if (OS.SendMessage(n2, 4356, 0, rECT) != 0) {
                OS.InvalidateRect(n2, rECT, true);
            }
        }
    }

    public void setImage(Image[] imageArray) {
        this.checkWidget();
        if (imageArray == null) {
            this.error(4);
        }
        int n2 = 0;
        while (n2 < imageArray.length) {
            this.setImage(n2, imageArray[n2]);
            ++n2;
        }
    }

    public void setImage(int n2, Image image) {
        this.checkWidget();
        if (image != null && image.isDisposed()) {
            this.error(5);
        }
        Image image2 = null;
        if (n2 == 0) {
            if (image != null && image.type == 1 && image.equals(this.image)) {
                return;
            }
            image2 = this.image;
            super.setImage(image);
        }
        int n3 = Math.max(1, this.parent.getColumnCount());
        if (n2 < 0 || n2 > n3 - 1) {
            return;
        }
        if (this.images == null && n2 != 0) {
            this.images = new Image[n3];
            this.images[0] = image;
        }
        if (this.images != null) {
            if (image != null && image.type == 1 && image.equals(this.images[n2])) {
                return;
            }
            image2 = this.images[n2];
            this.images[n2] = image;
        }
        if ((this.parent.style & 0x10000000) != 0) {
            this.cached = true;
        }
        this.parent.imageIndex(image, n2);
        if (n2 == 0) {
            if ((this.parent.style & 0x10000000) == 0 && !this.cached && !this.parent.painted) {
                return;
            }
            int n4 = this.parent.handle;
            TVITEM tVITEM = new TVITEM();
            tVITEM.mask = 50;
            tVITEM.hItem = this.handle;
            tVITEM.iSelectedImage = -1;
            tVITEM.iImage = -1;
            tVITEM.mask |= 1;
            tVITEM.pszText = -1;
            OS.SendMessage(n4, OS.TVM_SETITEM, 0, tVITEM);
        } else {
            boolean bl2 = image == null && image2 != null || image != null && image2 == null;
            this.redraw(n2, bl2, true);
        }
    }

    public void setImage(Image image) {
        this.checkWidget();
        this.setImage(0, image);
    }

    public void setItemCount(int n2) {
        this.checkWidget();
        n2 = Math.max(0, n2);
        int n3 = this.parent.handle;
        int n4 = OS.SendMessage(n3, 4362, 4, this.handle);
        this.parent.setItemCount(n2, this.handle, n4);
    }

    public void setText(String[] stringArray) {
        this.checkWidget();
        if (stringArray == null) {
            this.error(4);
        }
        int n2 = 0;
        while (n2 < stringArray.length) {
            String string = stringArray[n2];
            if (string != null) {
                this.setText(n2, string);
            }
            ++n2;
        }
    }

    public void setText(int n2, String string) {
        this.checkWidget();
        if (string == null) {
            this.error(4);
        }
        if (n2 == 0) {
            if (string.equals(this.text)) {
                return;
            }
            super.setText(string);
        }
        int n3 = Math.max(1, this.parent.getColumnCount());
        if (n2 < 0 || n2 > n3 - 1) {
            return;
        }
        if (this.strings == null && n2 != 0) {
            this.strings = new String[n3];
            this.strings[0] = this.text;
        }
        if (this.strings != null) {
            if (string.equals(this.strings[n2])) {
                return;
            }
            this.strings[n2] = string;
        }
        if ((this.parent.style & 0x10000000) != 0) {
            this.cached = true;
        }
        if (n2 == 0) {
            if ((this.parent.style & 0x10000000) == 0 && !this.cached && !this.parent.painted) {
                return;
            }
            int n4 = this.parent.handle;
            TVITEM tVITEM = new TVITEM();
            tVITEM.mask = 17;
            tVITEM.hItem = this.handle;
            tVITEM.pszText = -1;
            OS.SendMessage(n4, OS.TVM_SETITEM, 0, tVITEM);
        } else {
            this.redraw(n2, true, false);
        }
    }

    public void setText(String string) {
        this.checkWidget();
        this.setText(0, string);
    }

    void sort() {
        this.checkWidget();
        if ((this.parent.style & 0x10000000) != 0) {
            return;
        }
        this.parent.sort(this.handle, false);
    }
}

