/*
 * Decompiled with CFR 0.152.
 */
package javax.microedition.m3g;

import emulator.i;
import java.util.Hashtable;
import javax.microedition.lcdui.Graphics;
import javax.microedition.m3g.Appearance;
import javax.microedition.m3g.Background;
import javax.microedition.m3g.Camera;
import javax.microedition.m3g.Engine;
import javax.microedition.m3g.Helpers;
import javax.microedition.m3g.Image2D;
import javax.microedition.m3g.IndexBuffer;
import javax.microedition.m3g.Light;
import javax.microedition.m3g.Node;
import javax.microedition.m3g.Transform;
import javax.microedition.m3g.VertexBuffer;
import javax.microedition.m3g.World;

public class Graphics3D {
    int swerveHandle;
    public static final int ANTIALIAS = 2;
    public static final int DITHER = 4;
    public static final int TRUE_COLOR = 8;
    public static final int OVERWRITE = 16;
    static final int SUPPORTANTIALIASING = 0;
    static final int SUPPORTTRUECOLOR = 1;
    static final int SUPPORTDITHERING = 2;
    static final int SUPPORTMIPMAP = 3;
    static final int SUPPORTPERSPECTIVECORRECTION = 4;
    static final int SUPPORTLOCALCAMERALIGHTING = 5;
    static final int MAXLIGHTS = 6;
    static final int MAXVIEWPORTDIMENSION = 7;
    static final int MAXTEXTUREDIMENSION = 8;
    static final int MAXSPRITECROPDIMENSION = 9;
    static final int NUMTEXTUREUNITS = 10;
    static final int MAXTRANSFORMSPERVERTEX = 11;
    static final int MAXVIEWPORTWIDTH = 12;
    static final int MAXVIEWPORTHEIGHT = 13;
    static final int SUPPORTROTATE90 = 14;
    static final int SUPPORTROTATE180 = 15;
    static final int SUPPORTROTATE270 = 16;
    private static Graphics3D instance;
    Object bbPixels = null;
    private Object boundTarget = null;
    private boolean isGraphics = true;
    private boolean preload = false;
    private boolean unload = false;
    private boolean overwrite = false;
    private int clipX = 0;
    private int clipY = 0;
    private int clipWidth = 0;
    private int clipHeight = 0;
    private int viewportX = 0;
    private int viewportY = 0;
    private int viewportWidth = 0;
    private int viewportHeight = 0;
    private static int maxViewportWidth;
    private static int maxViewportHeight;
    static Class class$javax$microedition$m3g$Graphics3D;

    protected native void finalize();

    Graphics3D() {
    }

    Graphics3D(int n2) {
        this.swerveHandle = n2;
    }

    public native float getDepthRangeNear();

    public native float getDepthRangeFar();

    public native boolean isDepthBufferEnabled();

    public native int getHints();

    public native int getLightCount();

    private static native int createImpl();

    public static final Graphics3D getInstance() {
        if (instance == null) {
            instance = (Graphics3D)Engine.instantiateJavaPeer(Graphics3D.createImpl());
        }
        return instance;
    }

    private native void setBackBufferImage2D(Image2D var1);

    private native void setHints(boolean var1, int var2);

    public Object getTarget() {
        return this.boundTarget;
    }

    public synchronized void bindTarget(Object object, boolean bl2, int n2) {
        if (this.boundTarget != null) {
            throw new IllegalStateException();
        }
        if (object == null) {
            throw new NullPointerException();
        }
        if ((n2 & 0xFFFFFFE1) != 0) {
            throw new IllegalArgumentException();
        }
        if (object instanceof Graphics) {
            this.isGraphics = true;
            this.overwrite = (n2 & 0x10) != 0;
            this.unload = false;
            this.bindTarget((Graphics)object);
        } else if (object instanceof Image2D) {
            this.isGraphics = false;
            this.setBackBufferImage2D((Image2D)object);
            this.boundTarget = object;
        } else {
            throw new IllegalArgumentException();
        }
        this.setHints(bl2, n2);
    }

    public synchronized void bindTarget(Object object) {
        if (this.boundTarget != null) {
            throw new IllegalStateException();
        }
        if (object == null) {
            throw new NullPointerException();
        }
        if (object instanceof Graphics) {
            this.isGraphics = true;
            this.overwrite = false;
            this.unload = false;
            this.bindTarget((Graphics)object);
            return;
        }
        if (object instanceof Image2D) {
            this.isGraphics = false;
            this.setBackBufferImage2D((Image2D)object);
            this.boundTarget = object;
            return;
        }
        throw new IllegalArgumentException();
    }

    private void bindTarget(Graphics graphics) {
        this.clipX = Helpers.getTranslateX(graphics) + Helpers.getClipX(graphics);
        this.clipY = Helpers.getTranslateY(graphics) + Helpers.getClipY(graphics);
        this.clipWidth = Helpers.getClipWidth(graphics);
        this.clipHeight = Helpers.getClipHeight(graphics);
        if (this.clipWidth > maxViewportWidth || this.clipHeight > maxViewportHeight) {
            throw new IllegalArgumentException();
        }
        this.boundTarget = graphics;
        Helpers.bindTarget(this, graphics, this.clipX, this.clipY, this.clipWidth, this.clipHeight);
    }

    public synchronized void releaseTarget() {
        if (this.boundTarget == null) {
            return;
        }
        this.preload = false;
        if (this.isGraphics) {
            Helpers.releaseTarget(this, (Graphics)this.boundTarget);
        } else {
            this.setBackBufferImage2D(null);
        }
        this.boundTarget = null;
    }

    public synchronized void setViewport(int n2, int n3, int n4, int n5) {
        if (n4 <= 0 || n4 > maxViewportWidth || n5 <= 0 || n5 > maxViewportHeight) {
            throw new IllegalArgumentException();
        }
        this.viewportX = n2;
        this.viewportY = n3;
        this.viewportWidth = n4;
        this.viewportHeight = n5;
        if (this.boundTarget != null) {
            if (this.boundTarget instanceof Graphics) {
                Graphics graphics = (Graphics)this.boundTarget;
                this.preload = !this.unload && (!this.overwrite || (n2 += Helpers.getTranslateX(graphics)) > this.clipX || n2 + n4 < this.clipX + this.clipWidth || (n3 += Helpers.getTranslateY(graphics)) > this.clipY || n3 + n5 < this.clipY + this.clipHeight);
                this.setViewportImpl(n2, n3, n4, n5);
                this.unload = this.unload || this.preload;
                return;
            }
            this.setViewportImpl(n2, n3, n4, n5);
        }
    }

    private native void setViewportImpl(int var1, int var2, int var3, int var4);

    public int getViewportX() {
        return this.viewportX;
    }

    public int getViewportY() {
        return this.viewportY;
    }

    public int getViewportWidth() {
        return this.viewportWidth;
    }

    public int getViewportHeight() {
        return this.viewportHeight;
    }

    public native void setDepthRange(float var1, float var2);

    private native void clearImpl(Background var1);

    public synchronized void clear(Background background) {
        if (this.boundTarget == null) {
            throw new IllegalStateException();
        }
        this.preload = !this.unload && !this.overwrite && background != null && !background.isColorClearEnabled();
        this.clearImpl(background);
        this.unload = true;
    }

    public void render(VertexBuffer vertexBuffer, IndexBuffer indexBuffer, Appearance appearance, Transform transform) {
        this.render(vertexBuffer, indexBuffer, appearance, transform, -1);
    }

    private native void renderPrimitive(VertexBuffer var1, IndexBuffer var2, Appearance var3, Transform var4, int var5);

    public synchronized void render(VertexBuffer vertexBuffer, IndexBuffer indexBuffer, Appearance appearance, Transform transform, int n2) {
        if (this.boundTarget == null) {
            throw new IllegalStateException();
        }
        this.preload = !this.unload && !this.overwrite;
        this.renderPrimitive(vertexBuffer, indexBuffer, appearance, transform, n2);
        this.unload = true;
    }

    private native void renderNode(Node var1, Transform var2);

    public synchronized void render(Node node, Transform transform) {
        if (this.boundTarget == null) {
            throw new IllegalStateException();
        }
        this.preload = !this.unload && !this.overwrite;
        this.renderNode(node, transform);
        this.unload = true;
    }

    private native void renderWorld(World var1);

    public synchronized void render(World world) {
        if (this.boundTarget == null) {
            throw new IllegalStateException();
        }
        Background background = world.getBackground();
        this.preload = !this.unload && !this.overwrite && background != null && !background.isColorClearEnabled();
        this.renderWorld(world);
        this.unload = true;
    }

    public Camera getCamera(Transform transform) {
        Camera camera = (Camera)Engine.instantiateJavaPeer(this.getCameraImpl(transform));
        return camera;
    }

    private native int getCameraImpl(Transform var1);

    public void setCamera(Camera camera, Transform transform) {
        this.setCameraImpl(camera, transform);
        Engine.addXOT(camera);
    }

    private native void setCameraImpl(Camera var1, Transform var2);

    public void setLight(int n2, Light light, Transform transform) {
        this.setLightImpl(n2, light, transform);
        Engine.addXOT(light);
    }

    private native void setLightImpl(int var1, Light var2, Transform var3);

    public Light getLight(int n2, Transform transform) {
        Light light = (Light)Engine.instantiateJavaPeer(this.getLightImpl(n2, transform));
        return light;
    }

    private native int getLightImpl(int var1, Transform var2);

    public int addLight(Light light, Transform transform) {
        int n2 = this.addLightImpl(light, transform);
        Engine.addXOT(light);
        return n2;
    }

    private native int addLightImpl(Light var1, Transform var2);

    public native void resetLights();

    public static final synchronized Hashtable getProperties() {
        Hashtable<String, Object> hashtable = new Hashtable<String, Object>();
        hashtable.put(new String("supportAntialiasing"), new Boolean(Graphics3D.getCapability(0) == 1));
        hashtable.put(new String("supportTrueColor"), new Boolean(Graphics3D.getCapability(1) == 1));
        hashtable.put(new String("supportDithering"), new Boolean(Graphics3D.getCapability(2) == 1));
        hashtable.put(new String("supportMipmapping"), new Boolean(Graphics3D.getCapability(3) == 1));
        hashtable.put(new String("supportPerspectiveCorrection"), new Boolean(Graphics3D.getCapability(4) == 1));
        hashtable.put(new String("supportLocalCameraLighting"), new Boolean(Graphics3D.getCapability(5) == 1));
        hashtable.put(new String("maxLights"), new Integer(Graphics3D.getCapability(6)));
        hashtable.put(new String("maxViewportDimension"), new Integer(Graphics3D.getCapability(7)));
        hashtable.put(new String("maxTextureDimension"), new Integer(Graphics3D.getCapability(8)));
        hashtable.put(new String("maxSpriteCropDimension"), new Integer(Graphics3D.getCapability(9)));
        hashtable.put(new String("numTextureUnits"), new Integer(Graphics3D.getCapability(10)));
        hashtable.put(new String("maxTransformsPerVertex"), new Integer(Graphics3D.getCapability(11)));
        hashtable.put(new String("maxViewportWidth"), new Integer(maxViewportWidth));
        hashtable.put(new String("maxViewportHeight"), new Integer(maxViewportHeight));
        hashtable.put(new String("C3A458D3-2015-41f5-8338-66A2D3014335"), Engine.getVersionMajor() + "." + Engine.getVersionMinor() + "." + Engine.getRevisionMajor() + "." + Engine.getRevisionMinor() + ":" + Engine.getBranchNumber());
        try {
            hashtable.put(new String("com.superscape.m3gx.DebugUtils"), Class.forName("javax.microedition.m3g.DebugUtils").newInstance());
        }
        catch (Exception exception) {}
        try {
            hashtable.put(new String("com.superscape.m3gx.Image2DUtils"), Class.forName("javax.microedition.m3g.Image2DUtils").newInstance());
        }
        catch (Exception exception) {}
        try {
            hashtable.put(new String("com.superscape.m3gx.SerializeOut"), Class.forName("javax.microedition.m3g.SerializeOut").newInstance());
        }
        catch (Exception exception) {}
        return hashtable;
    }

    private static native int getCapability(int var0);

    static Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    static {
        i.a("jsr184client");
        Engine.cacheFID(class$javax$microedition$m3g$Graphics3D == null ? (class$javax$microedition$m3g$Graphics3D = Graphics3D.class$("javax.microedition.m3g.Graphics3D")) : class$javax$microedition$m3g$Graphics3D, 1);
        instance = null;
        maxViewportWidth = Graphics3D.getCapability(12);
        maxViewportHeight = Graphics3D.getCapability(13);
    }
}

