/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.swt.dnd;

import org.eclipse.swt.dnd.DND;
import org.eclipse.swt.dnd.DNDEvent;
import org.eclipse.swt.dnd.DNDListener;
import org.eclipse.swt.dnd.DragSourceEffect;
import org.eclipse.swt.dnd.DragSourceListener;
import org.eclipse.swt.dnd.OleEnumFORMATETC;
import org.eclipse.swt.dnd.TableDragSourceEffect;
import org.eclipse.swt.dnd.Transfer;
import org.eclipse.swt.dnd.TransferData;
import org.eclipse.swt.dnd.TreeDragSourceEffect;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.internal.ImageList;
import org.eclipse.swt.internal.ole.win32.COM;
import org.eclipse.swt.internal.ole.win32.COMObject;
import org.eclipse.swt.internal.ole.win32.FORMATETC;
import org.eclipse.swt.internal.ole.win32.GUID;
import org.eclipse.swt.internal.ole.win32.STGMEDIUM;
import org.eclipse.swt.internal.win32.OS;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.Tree;
import org.eclipse.swt.widgets.Widget;

public class DragSource
extends Widget {
    Control control;
    Listener controlListener;
    Transfer[] transferAgents = new Transfer[0];
    DragSourceEffect dragEffect;
    Composite topControl;
    COMObject iDropSource;
    COMObject iDataObject;
    int refCount;
    int dataEffect = 0;
    static final String DEFAULT_DRAG_SOURCE_EFFECT = "DEFAULT_DRAG_SOURCE_EFFECT";
    static final String DRAGSOURCEID = "DragSource";
    static final int CFSTR_PERFORMEDDROPEFFECT = Transfer.registerType("Performed DropEffect");
    static /* synthetic */ Class class$0;

    public DragSource(Control control, int n2) {
        super(control, DragSource.checkStyle(n2));
        this.control = control;
        if (control.getData(DRAGSOURCEID) != null) {
            DND.error(2000);
        }
        control.setData(DRAGSOURCEID, this);
        this.createCOMInterfaces();
        this.AddRef();
        this.controlListener = new Listener(){

            public void handleEvent(Event event) {
                if (event.type == 12 && !DragSource.this.isDisposed()) {
                    DragSource.this.dispose();
                }
                if (event.type == 29 && !DragSource.this.isDisposed()) {
                    DragSource.this.drag(event);
                }
            }
        };
        control.addListener(12, this.controlListener);
        control.addListener(29, this.controlListener);
        this.addListener(12, new Listener(){

            public void handleEvent(Event event) {
                DragSource.this.onDispose();
            }
        });
        Object object = control.getData(DEFAULT_DRAG_SOURCE_EFFECT);
        if (object instanceof DragSourceEffect) {
            this.dragEffect = (DragSourceEffect)object;
        } else if (control instanceof Tree) {
            this.dragEffect = new TreeDragSourceEffect((Tree)control);
        } else if (control instanceof Table) {
            this.dragEffect = new TableDragSourceEffect((Table)control);
        }
    }

    static int checkStyle(int n2) {
        if (n2 == 0) {
            return 2;
        }
        return n2;
    }

    public void addDragListener(DragSourceListener dragSourceListener) {
        if (dragSourceListener == null) {
            DND.error(4);
        }
        DNDListener dNDListener = new DNDListener(dragSourceListener);
        dNDListener.dndWidget = this;
        this.addListener(2008, dNDListener);
        this.addListener(2001, dNDListener);
        this.addListener(2000, dNDListener);
    }

    private int AddRef() {
        ++this.refCount;
        return this.refCount;
    }

    private void createCOMInterfaces() {
        int[] nArray = new int[5];
        nArray[0] = 2;
        nArray[3] = 2;
        nArray[4] = 1;
        this.iDropSource = new COMObject(nArray){

            public int method0(int[] nArray) {
                return DragSource.this.QueryInterface(nArray[0], nArray[1]);
            }

            public int method1(int[] nArray) {
                return DragSource.this.AddRef();
            }

            public int method2(int[] nArray) {
                return DragSource.this.Release();
            }

            public int method3(int[] nArray) {
                return DragSource.this.QueryContinueDrag(nArray[0], nArray[1]);
            }

            public int method4(int[] nArray) {
                return DragSource.this.GiveFeedback(nArray[0]);
            }
        };
        int[] nArray2 = new int[12];
        nArray2[0] = 2;
        nArray2[3] = 2;
        nArray2[4] = 2;
        nArray2[5] = 1;
        nArray2[6] = 2;
        nArray2[7] = 3;
        nArray2[8] = 2;
        nArray2[9] = 4;
        nArray2[10] = 1;
        nArray2[11] = 1;
        this.iDataObject = new COMObject(nArray2){

            public int method0(int[] nArray) {
                return DragSource.this.QueryInterface(nArray[0], nArray[1]);
            }

            public int method1(int[] nArray) {
                return DragSource.this.AddRef();
            }

            public int method2(int[] nArray) {
                return DragSource.this.Release();
            }

            public int method3(int[] nArray) {
                return DragSource.this.GetData(nArray[0], nArray[1]);
            }

            public int method5(int[] nArray) {
                return DragSource.this.QueryGetData(nArray[0]);
            }

            public int method7(int[] nArray) {
                return DragSource.this.SetData(nArray[0], nArray[1], nArray[2]);
            }

            public int method8(int[] nArray) {
                return DragSource.this.EnumFormatEtc(nArray[0], nArray[1]);
            }
        };
    }

    protected void checkSubclass() {
        String string;
        String string2 = this.getClass().getName();
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.eclipse.swt.dnd.DragSource");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        if (!(string = clazz.getName()).equals(string2)) {
            DND.error(43);
        }
    }

    private void disposeCOMInterfaces() {
        if (this.iDropSource != null) {
            this.iDropSource.dispose();
        }
        this.iDropSource = null;
        if (this.iDataObject != null) {
            this.iDataObject.dispose();
        }
        this.iDataObject = null;
    }

    private void drag(Event event) {
        int n2;
        DNDEvent dNDEvent = new DNDEvent();
        dNDEvent.widget = this;
        dNDEvent.x = event.x;
        dNDEvent.y = event.y;
        dNDEvent.time = OS.GetMessageTime();
        dNDEvent.doit = true;
        this.notifyListeners(2008, dNDEvent);
        if (!dNDEvent.doit || this.transferAgents == null || this.transferAgents.length == 0) {
            return;
        }
        int[] nArray = new int[1];
        int n3 = this.opToOs(this.getStyle());
        Display display = this.control.getDisplay();
        String string = "org.eclipse.swt.internal.win32.runMessagesInIdle";
        Object object = display.getData(string);
        display.setData(string, new Boolean(true));
        ImageList imageList = null;
        Image image = dNDEvent.image;
        if (image != null) {
            imageList = new ImageList(0);
            imageList.add(image);
            this.topControl = this.control.getShell();
            OS.ImageList_BeginDrag(imageList.getHandle(), 0, 0, 0);
            Point point = this.topControl.getLocation();
            if (OS.IsWinCE) {
                OS.UpdateWindow(this.topControl.handle);
            } else {
                n2 = 384;
                OS.RedrawWindow(this.topControl.handle, null, 0, n2);
            }
            OS.ImageList_DragEnter(this.topControl.handle, event.x - point.x, event.y - point.y);
        }
        int n4 = COM.DoDragDrop(this.iDataObject.getAddress(), this.iDropSource.getAddress(), n3, nArray);
        if (imageList != null) {
            OS.ImageList_DragLeave(this.topControl.handle);
            OS.ImageList_EndDrag();
            imageList.dispose();
            this.topControl = null;
        }
        display.setData(string, object);
        n2 = this.osToOp(nArray[0]);
        if (this.dataEffect == 2) {
            n2 = n2 == 0 || n2 == 1 ? 8 : 2;
        } else if (this.dataEffect != 0) {
            n2 = this.dataEffect;
        }
        dNDEvent = new DNDEvent();
        dNDEvent.widget = this;
        dNDEvent.time = OS.GetMessageTime();
        dNDEvent.doit = n4 == 262400;
        dNDEvent.detail = n2;
        this.notifyListeners(2000, dNDEvent);
        this.dataEffect = 0;
    }

    private int EnumFormatEtc(int n2, int n3) {
        FORMATETC[] fORMATETCArray;
        if (n2 == 2) {
            return -2147467263;
        }
        TransferData[] transferDataArray = new TransferData[]{};
        int n4 = 0;
        while (n4 < this.transferAgents.length) {
            fORMATETCArray = this.transferAgents[n4];
            if (fORMATETCArray != null) {
                TransferData[] transferDataArray2 = fORMATETCArray.getSupportedTypes();
                TransferData[] transferDataArray3 = new TransferData[transferDataArray.length + transferDataArray2.length];
                System.arraycopy(transferDataArray, 0, transferDataArray3, 0, transferDataArray.length);
                System.arraycopy(transferDataArray2, 0, transferDataArray3, transferDataArray.length, transferDataArray2.length);
                transferDataArray = transferDataArray3;
            }
            ++n4;
        }
        OleEnumFORMATETC oleEnumFORMATETC = new OleEnumFORMATETC();
        oleEnumFORMATETC.AddRef();
        fORMATETCArray = new FORMATETC[transferDataArray.length];
        int n5 = 0;
        while (n5 < fORMATETCArray.length) {
            fORMATETCArray[n5] = transferDataArray[n5].formatetc;
            ++n5;
        }
        oleEnumFORMATETC.setFormats(fORMATETCArray);
        OS.MoveMemory(n3, new int[]{oleEnumFORMATETC.getAddress()}, 4);
        return 0;
    }

    public Control getControl() {
        return this.control;
    }

    private int GetData(int n2, int n3) {
        if (n2 == 0 || n3 == 0) {
            return -2147024809;
        }
        if (this.QueryGetData(n2) != 0) {
            return -2147221404;
        }
        TransferData transferData = new TransferData();
        transferData.formatetc = new FORMATETC();
        COM.MoveMemory(transferData.formatetc, n2, FORMATETC.sizeof);
        transferData.type = transferData.formatetc.cfFormat;
        transferData.stgmedium = new STGMEDIUM();
        transferData.result = -2147467259;
        DNDEvent dNDEvent = new DNDEvent();
        dNDEvent.widget = this;
        dNDEvent.time = OS.GetMessageTime();
        dNDEvent.dataType = transferData;
        this.notifyListeners(2001, dNDEvent);
        Transfer transfer = null;
        int n4 = 0;
        while (n4 < this.transferAgents.length) {
            Transfer transfer2 = this.transferAgents[n4];
            if (transfer2 != null && transfer2.isSupportedType(transferData)) {
                transfer = transfer2;
                break;
            }
            ++n4;
        }
        if (transfer == null) {
            return -2147221404;
        }
        transfer.javaToNative(dNDEvent.data, transferData);
        if (transferData.result != 0) {
            return transferData.result;
        }
        COM.MoveMemory(n3, transferData.stgmedium, STGMEDIUM.sizeof);
        return transferData.result;
    }

    public DragSourceEffect getDragSourceEffect() {
        return this.dragEffect;
    }

    public Transfer[] getTransfer() {
        return this.transferAgents;
    }

    private int GiveFeedback(int n2) {
        return 262402;
    }

    private int QueryContinueDrag(int n2, int n3) {
        if (n2 != 0) {
            if (this.topControl != null) {
                OS.ImageList_DragLeave(this.topControl.handle);
            }
            return 262401;
        }
        int n4 = 19;
        if ((n3 & n4) == 0) {
            if (this.topControl != null) {
                OS.ImageList_DragLeave(this.topControl.handle);
            }
            return 262400;
        }
        if (this.topControl != null) {
            Display display = this.getDisplay();
            Point point = display.getCursorLocation();
            Point point2 = this.topControl.getLocation();
            OS.ImageList_DragMove(point.x - point2.x, point.y - point2.y);
        }
        return 0;
    }

    private void onDispose() {
        if (this.control == null) {
            return;
        }
        this.Release();
        if (this.controlListener != null) {
            this.control.removeListener(12, this.controlListener);
            this.control.removeListener(29, this.controlListener);
        }
        this.controlListener = null;
        this.control.setData(DRAGSOURCEID, null);
        this.control = null;
        this.transferAgents = null;
    }

    private int opToOs(int n2) {
        int n3 = 0;
        if ((n2 & 1) != 0) {
            n3 |= 1;
        }
        if ((n2 & 4) != 0) {
            n3 |= 4;
        }
        if ((n2 & 2) != 0) {
            n3 |= 2;
        }
        return n3;
    }

    private int osToOp(int n2) {
        int n3 = 0;
        if ((n2 & 1) != 0) {
            n3 |= 1;
        }
        if ((n2 & 4) != 0) {
            n3 |= 4;
        }
        if ((n2 & 2) != 0) {
            n3 |= 2;
        }
        return n3;
    }

    private int QueryGetData(int n2) {
        if (this.transferAgents == null) {
            return -2147467259;
        }
        TransferData transferData = new TransferData();
        transferData.formatetc = new FORMATETC();
        COM.MoveMemory(transferData.formatetc, n2, FORMATETC.sizeof);
        transferData.type = transferData.formatetc.cfFormat;
        int n3 = 0;
        while (n3 < this.transferAgents.length) {
            Transfer transfer = this.transferAgents[n3];
            if (transfer != null && transfer.isSupportedType(transferData)) {
                return 0;
            }
            ++n3;
        }
        return -2147221404;
    }

    private int QueryInterface(int n2, int n3) {
        if (n2 == 0 || n3 == 0) {
            return -2147024809;
        }
        GUID gUID = new GUID();
        COM.MoveMemory(gUID, n2, GUID.sizeof);
        if (COM.IsEqualGUID(gUID, COM.IIDIUnknown) || COM.IsEqualGUID(gUID, COM.IIDIDropSource)) {
            OS.MoveMemory(n3, new int[]{this.iDropSource.getAddress()}, 4);
            this.AddRef();
            return 0;
        }
        if (COM.IsEqualGUID(gUID, COM.IIDIDataObject)) {
            OS.MoveMemory(n3, new int[]{this.iDataObject.getAddress()}, 4);
            this.AddRef();
            return 0;
        }
        OS.MoveMemory(n3, new int[1], 4);
        return -2147467262;
    }

    private int Release() {
        --this.refCount;
        if (this.refCount == 0) {
            this.disposeCOMInterfaces();
            COM.CoFreeUnusedLibraries();
        }
        return this.refCount;
    }

    public void removeDragListener(DragSourceListener dragSourceListener) {
        if (dragSourceListener == null) {
            DND.error(4);
        }
        this.removeListener(2008, dragSourceListener);
        this.removeListener(2001, dragSourceListener);
        this.removeListener(2000, dragSourceListener);
    }

    private int SetData(int n2, int n3, int n4) {
        if (n2 == 0 || n3 == 0) {
            return -2147024809;
        }
        FORMATETC fORMATETC = new FORMATETC();
        COM.MoveMemory(fORMATETC, n2, FORMATETC.sizeof);
        if (fORMATETC.cfFormat == CFSTR_PERFORMEDDROPEFFECT && fORMATETC.tymed == 1) {
            STGMEDIUM sTGMEDIUM = new STGMEDIUM();
            COM.MoveMemory(sTGMEDIUM, n3, STGMEDIUM.sizeof);
            int[] nArray = new int[1];
            OS.MoveMemory(nArray, sTGMEDIUM.unionField, 4);
            int[] nArray2 = new int[1];
            OS.MoveMemory(nArray2, nArray[0], 4);
            this.dataEffect = this.osToOp(nArray2[0]);
        }
        if (n4 == 1) {
            COM.ReleaseStgMedium(n3);
        }
        return 0;
    }

    public void setDragSourceEffect(DragSourceEffect dragSourceEffect) {
        this.dragEffect = dragSourceEffect;
    }

    public void setTransfer(Transfer[] transferArray) {
        this.transferAgents = transferArray;
    }
}

