/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.swt.internal.image;

import java.io.IOException;
import org.eclipse.swt.SWT;
import org.eclipse.swt.graphics.ImageData;
import org.eclipse.swt.graphics.ImageLoader;
import org.eclipse.swt.graphics.ImageLoaderEvent;
import org.eclipse.swt.graphics.PaletteData;
import org.eclipse.swt.graphics.RGB;
import org.eclipse.swt.internal.image.FileFormat;
import org.eclipse.swt.internal.image.JPEGAppn;
import org.eclipse.swt.internal.image.JPEGArithmeticConditioningTable;
import org.eclipse.swt.internal.image.JPEGComment;
import org.eclipse.swt.internal.image.JPEGDecoder;
import org.eclipse.swt.internal.image.JPEGEndOfImage;
import org.eclipse.swt.internal.image.JPEGFrameHeader;
import org.eclipse.swt.internal.image.JPEGHuffmanTable;
import org.eclipse.swt.internal.image.JPEGQuantizationTable;
import org.eclipse.swt.internal.image.JPEGRestartInterval;
import org.eclipse.swt.internal.image.JPEGScanHeader;
import org.eclipse.swt.internal.image.JPEGSegment;
import org.eclipse.swt.internal.image.JPEGStartOfImage;
import org.eclipse.swt.internal.image.LEDataInputStream;

final class JPEGFileFormat
extends FileFormat {
    int restartInterval;
    JPEGFrameHeader frameHeader;
    int imageWidth;
    int imageHeight;
    int interleavedMcuCols;
    int interleavedMcuRows;
    int maxV;
    int maxH;
    boolean progressive;
    int samplePrecision;
    int nComponents;
    int[][] frameComponents;
    int[] componentIds;
    byte[][] imageComponents;
    int[] dataUnit;
    int[][][] dataUnits;
    int[] precedingDCs;
    JPEGScanHeader scanHeader;
    byte[] dataBuffer;
    int currentBitCount;
    int bufferCurrentPosition;
    int restartsToGo;
    int nextRestartNumber;
    JPEGHuffmanTable[] acHuffmanTables;
    JPEGHuffmanTable[] dcHuffmanTables;
    int[][] quantizationTables;
    int currentByte;
    int encoderQFactor = 75;
    int eobrun = 0;
    public static final int DCTSIZE = 8;
    public static final int DCTSIZESQR = 64;
    public static final int FIX_0_899976223 = 7373;
    public static final int FIX_1_961570560 = 16069;
    public static final int FIX_2_053119869 = 16819;
    public static final int FIX_0_298631336 = 2446;
    public static final int FIX_1_847759065 = 15137;
    public static final int FIX_1_175875602 = 9633;
    public static final int FIX_3_072711026 = 25172;
    public static final int FIX_0_765366865 = 6270;
    public static final int FIX_2_562915447 = 20995;
    public static final int FIX_0_541196100 = 4433;
    public static final int FIX_0_390180644 = 3196;
    public static final int FIX_1_501321110 = 12299;
    public static final int APP0 = 65504;
    public static final int APP15 = 65519;
    public static final int COM = 65534;
    public static final int DAC = 65484;
    public static final int DHP = 65502;
    public static final int DHT = 65476;
    public static final int DNL = 65500;
    public static final int DRI = 65501;
    public static final int DQT = 65499;
    public static final int EOI = 65497;
    public static final int EXP = 65503;
    public static final int JPG = 65480;
    public static final int JPG0 = 65520;
    public static final int JPG13 = 65533;
    public static final int RST0 = 65488;
    public static final int RST1 = 65489;
    public static final int RST2 = 65490;
    public static final int RST3 = 65491;
    public static final int RST4 = 65492;
    public static final int RST5 = 65493;
    public static final int RST6 = 65494;
    public static final int RST7 = 65495;
    public static final int SOF0 = 65472;
    public static final int SOF1 = 65473;
    public static final int SOF2 = 65474;
    public static final int SOF3 = 65475;
    public static final int SOF5 = 65477;
    public static final int SOF6 = 65478;
    public static final int SOF7 = 65479;
    public static final int SOF9 = 65481;
    public static final int SOF10 = 65482;
    public static final int SOF11 = 65483;
    public static final int SOF13 = 65485;
    public static final int SOF14 = 65486;
    public static final int SOF15 = 65487;
    public static final int SOI = 65496;
    public static final int SOS = 65498;
    public static final int TEM = 65281;
    public static final int TQI = 0;
    public static final int HI = 1;
    public static final int VI = 2;
    public static final int CW = 3;
    public static final int CH = 4;
    public static final int DC = 0;
    public static final int AC = 1;
    public static final int ID_Y = 0;
    public static final int ID_CB = 1;
    public static final int ID_CR = 2;
    public static final RGB[] RGB16 = new RGB[]{new RGB(0, 0, 0), new RGB(128, 0, 0), new RGB(0, 128, 0), new RGB(128, 128, 0), new RGB(0, 0, 128), new RGB(128, 0, 128), new RGB(0, 128, 128), new RGB(192, 192, 192), new RGB(128, 128, 128), new RGB(255, 0, 0), new RGB(0, 255, 0), new RGB(255, 255, 0), new RGB(0, 0, 255), new RGB(255, 0, 255), new RGB(0, 255, 255), new RGB(255, 255, 255)};
    public static final int[] ExtendTest;
    public static final int[] ExtendOffset;
    public static final int[] ZigZag8x8;
    public static int[] CrRTable;
    public static int[] CbBTable;
    public static int[] CrGTable;
    public static int[] CbGTable;
    public static int[] RYTable;
    public static int[] GYTable;
    public static int[] BYTable;
    public static int[] RCbTable;
    public static int[] GCbTable;
    public static int[] BCbTable;
    public static int[] RCrTable;
    public static int[] GCrTable;
    public static int[] BCrTable;
    public static int[] NBitsTable;

    static {
        int[] nArray = new int[20];
        nArray[1] = 1;
        nArray[2] = 2;
        nArray[3] = 4;
        nArray[4] = 8;
        nArray[5] = 16;
        nArray[6] = 32;
        nArray[7] = 64;
        nArray[8] = 128;
        nArray[9] = 256;
        nArray[10] = 512;
        nArray[11] = 1024;
        nArray[12] = 2048;
        nArray[13] = 4096;
        nArray[14] = 8192;
        nArray[15] = 16384;
        nArray[16] = 32768;
        nArray[17] = 65536;
        nArray[18] = 131072;
        nArray[19] = 262144;
        ExtendTest = nArray;
        int[] nArray2 = new int[19];
        nArray2[1] = -1;
        nArray2[2] = -3;
        nArray2[3] = -7;
        nArray2[4] = -15;
        nArray2[5] = -31;
        nArray2[6] = -63;
        nArray2[7] = -127;
        nArray2[8] = -255;
        nArray2[9] = -511;
        nArray2[10] = -1023;
        nArray2[11] = -2047;
        nArray2[12] = -4095;
        nArray2[13] = -8191;
        nArray2[14] = -16383;
        nArray2[15] = -32767;
        nArray2[16] = -65535;
        nArray2[17] = -131071;
        nArray2[18] = -262143;
        ExtendOffset = nArray2;
        int[] nArray3 = new int[64];
        nArray3[1] = 1;
        nArray3[2] = 8;
        nArray3[3] = 16;
        nArray3[4] = 9;
        nArray3[5] = 2;
        nArray3[6] = 3;
        nArray3[7] = 10;
        nArray3[8] = 17;
        nArray3[9] = 24;
        nArray3[10] = 32;
        nArray3[11] = 25;
        nArray3[12] = 18;
        nArray3[13] = 11;
        nArray3[14] = 4;
        nArray3[15] = 5;
        nArray3[16] = 12;
        nArray3[17] = 19;
        nArray3[18] = 26;
        nArray3[19] = 33;
        nArray3[20] = 40;
        nArray3[21] = 48;
        nArray3[22] = 41;
        nArray3[23] = 34;
        nArray3[24] = 27;
        nArray3[25] = 20;
        nArray3[26] = 13;
        nArray3[27] = 6;
        nArray3[28] = 7;
        nArray3[29] = 14;
        nArray3[30] = 21;
        nArray3[31] = 28;
        nArray3[32] = 35;
        nArray3[33] = 42;
        nArray3[34] = 49;
        nArray3[35] = 56;
        nArray3[36] = 57;
        nArray3[37] = 50;
        nArray3[38] = 43;
        nArray3[39] = 36;
        nArray3[40] = 29;
        nArray3[41] = 22;
        nArray3[42] = 15;
        nArray3[43] = 23;
        nArray3[44] = 30;
        nArray3[45] = 37;
        nArray3[46] = 44;
        nArray3[47] = 51;
        nArray3[48] = 58;
        nArray3[49] = 59;
        nArray3[50] = 52;
        nArray3[51] = 45;
        nArray3[52] = 38;
        nArray3[53] = 31;
        nArray3[54] = 39;
        nArray3[55] = 46;
        nArray3[56] = 53;
        nArray3[57] = 60;
        nArray3[58] = 61;
        nArray3[59] = 54;
        nArray3[60] = 47;
        nArray3[61] = 55;
        nArray3[62] = 62;
        nArray3[63] = 63;
        ZigZag8x8 = nArray3;
        JPEGFileFormat.initialize();
    }

    JPEGFileFormat() {
    }

    void compress(ImageData imageData, byte[] byArray, byte[] byArray2, byte[] byArray3) {
        int n2;
        int n3;
        int n4;
        int n5;
        int n6;
        int n7;
        int[] nArray;
        int n8 = imageData.width;
        int n9 = imageData.height;
        int n10 = this.maxV * this.maxH;
        this.imageComponents = new byte[this.nComponents][];
        int n11 = 0;
        while (n11 < this.nComponents) {
            nArray = this.frameComponents[this.componentIds[n11]];
            this.imageComponents[n11] = new byte[nArray[3] * nArray[4]];
            ++n11;
        }
        nArray = this.frameComponents[this.componentIds[0]];
        n11 = 0;
        while (n11 < n9) {
            n7 = n11 * n8;
            n6 = n11 * nArray[3];
            System.arraycopy(byArray, n7, this.imageComponents[0], n6, n8);
            ++n11;
        }
        nArray = this.frameComponents[this.componentIds[1]];
        n11 = 0;
        while (n11 < n9 / this.maxV) {
            n7 = n11 * nArray[3];
            n6 = 0;
            while (n6 < n8 / this.maxH) {
                n5 = 0;
                n4 = 0;
                while (n4 < this.maxV) {
                    n3 = (n11 * this.maxV + n4) * n8 + n6 * this.maxH;
                    n2 = 0;
                    while (n2 < this.maxH) {
                        n5 += byArray2[n3 + n2] & 0xFF;
                        ++n2;
                    }
                    ++n4;
                }
                this.imageComponents[1][n7 + n6] = (byte)(n5 / n10);
                ++n6;
            }
            ++n11;
        }
        nArray = this.frameComponents[this.componentIds[2]];
        n11 = 0;
        while (n11 < n9 / this.maxV) {
            n7 = n11 * nArray[3];
            n6 = 0;
            while (n6 < n8 / this.maxH) {
                n5 = 0;
                n4 = 0;
                while (n4 < this.maxV) {
                    n3 = (n11 * this.maxV + n4) * n8 + n6 * this.maxH;
                    n2 = 0;
                    while (n2 < this.maxH) {
                        n5 += byArray3[n3 + n2] & 0xFF;
                        ++n2;
                    }
                    ++n4;
                }
                this.imageComponents[2][n7 + n6] = (byte)(n5 / n10);
                ++n6;
            }
            ++n11;
        }
        n11 = 0;
        while (n11 < this.nComponents) {
            int n12;
            int n13;
            int n14;
            byte[] byArray4 = this.imageComponents[n11];
            nArray = this.frameComponents[this.componentIds[n11]];
            n6 = nArray[1];
            n5 = nArray[2];
            n4 = nArray[3];
            n3 = nArray[4];
            n2 = n8 / (this.maxH / n6);
            int n15 = n9 / (this.maxV / n5);
            if (n2 < n4) {
                n14 = n4 - n2;
                n13 = 0;
                while (n13 < n15) {
                    n12 = (n13 + 1) * n4 - n14;
                    int n16 = byArray4[n12 - 1] & 0xFF;
                    int n17 = 0;
                    while (n17 < n14) {
                        byArray4[n12 + n17] = (byte)n16;
                        ++n17;
                    }
                    ++n13;
                }
            }
            if (n15 < n3) {
                n14 = (n15 - 1) * n4;
                n13 = n15;
                while (n13 <= n3) {
                    n12 = (n13 - 1) * n4;
                    System.arraycopy(byArray4, n14, byArray4, n12, n4);
                    ++n13;
                }
            }
            ++n11;
        }
    }

    void convert4BitRGBToYCbCr(ImageData imageData) {
        int n2;
        Object object;
        RGB[] rGBArray = imageData.getRGBs();
        int n3 = rGBArray.length;
        byte[] byArray = new byte[n3];
        byte[] byArray2 = new byte[n3];
        byte[] byArray3 = new byte[n3];
        int n4 = imageData.width;
        int n5 = imageData.height;
        int n6 = 0;
        while (n6 < n3) {
            object = rGBArray[n6];
            int n7 = ((RGB)object).red;
            int n8 = ((RGB)object).green;
            int n9 = ((RGB)object).blue;
            n2 = RYTable[n7] + GYTable[n8] + BYTable[n9];
            byArray[n6] = (byte)(n2 >> 16);
            if (n2 < 0 && (n2 & 0xFFFF) != 0) {
                int n10 = n6;
                byArray[n10] = (byte)(byArray[n10] - 1);
            }
            n2 = RCbTable[n7] + GCbTable[n8] + BCbTable[n9];
            byArray2[n6] = (byte)(n2 >> 16);
            if (n2 < 0 && (n2 & 0xFFFF) != 0) {
                int n11 = n6;
                byArray2[n11] = (byte)(byArray2[n11] - 1);
            }
            n2 = RCrTable[n7] + GCrTable[n8] + BCrTable[n9];
            byArray3[n6] = (byte)(n2 >> 16);
            if (n2 < 0 && (n2 & 0xFFFF) != 0) {
                int n12 = n6;
                byArray3[n12] = (byte)(byArray3[n12] - 1);
            }
            ++n6;
        }
        n6 = n4 * n5;
        object = new byte[n6];
        byte[] byArray4 = new byte[n6];
        byte[] byArray5 = new byte[n6];
        byte[] byArray6 = imageData.data;
        n2 = imageData.bytesPerLine;
        int n13 = n4 >> 1;
        int n14 = 0;
        while (n14 < n5) {
            int n15 = 0;
            while (n15 < n13) {
                int n16 = n14 * n2 + n15;
                int n17 = n14 * n4 + n15 * 2;
                int n18 = byArray6[n16] & 0xFF;
                int n19 = n18 >> 4;
                object[n17] = byArray[n19];
                byArray4[n17] = byArray2[n19];
                byArray5[n17] = byArray3[n19];
                object[n17 + 1] = byArray[n18 &= 0xF];
                byArray4[n17 + 1] = byArray2[n18];
                byArray5[n17 + 1] = byArray3[n18];
                ++n15;
            }
            ++n14;
        }
        this.compress(imageData, (byte[])object, byArray4, byArray5);
    }

    void convert8BitRGBToYCbCr(ImageData imageData) {
        int n2;
        int n3;
        RGB[] rGBArray = imageData.getRGBs();
        int n4 = rGBArray.length;
        byte[] byArray = new byte[n4];
        byte[] byArray2 = new byte[n4];
        byte[] byArray3 = new byte[n4];
        int n5 = imageData.width;
        int n6 = imageData.height;
        int n7 = 0;
        while (n7 < n4) {
            RGB rGB = rGBArray[n7];
            n3 = rGB.red;
            n2 = rGB.green;
            int n8 = rGB.blue;
            int n9 = RYTable[n3] + GYTable[n2] + BYTable[n8];
            byArray[n7] = (byte)(n9 >> 16);
            if (n9 < 0 && (n9 & 0xFFFF) != 0) {
                int n10 = n7;
                byArray[n10] = (byte)(byArray[n10] - 1);
            }
            n9 = RCbTable[n3] + GCbTable[n2] + BCbTable[n8];
            byArray2[n7] = (byte)(n9 >> 16);
            if (n9 < 0 && (n9 & 0xFFFF) != 0) {
                int n11 = n7;
                byArray2[n11] = (byte)(byArray2[n11] - 1);
            }
            n9 = RCrTable[n3] + GCrTable[n2] + BCrTable[n8];
            byArray3[n7] = (byte)(n9 >> 16);
            if (n9 < 0 && (n9 & 0xFFFF) != 0) {
                int n12 = n7;
                byArray3[n12] = (byte)(byArray3[n12] - 1);
            }
            ++n7;
        }
        n7 = imageData.width;
        int n13 = n6;
        n3 = n5 + 3 >> 2 << 2;
        n2 = n7 * n13;
        byte[] byArray4 = new byte[n2];
        byte[] byArray5 = new byte[n2];
        byte[] byArray6 = new byte[n2];
        byte[] byArray7 = imageData.data;
        int n14 = 0;
        while (n14 < n6) {
            int n15 = n14 * n3;
            int n16 = n14 * n7;
            int n17 = 0;
            while (n17 < n5) {
                int n18 = byArray7[n15 + n17] & 0xFF;
                int n19 = n16 + n17;
                byArray4[n19] = byArray[n18];
                byArray5[n19] = byArray2[n18];
                byArray6[n19] = byArray3[n18];
                ++n17;
            }
            ++n14;
        }
        this.compress(imageData, byArray4, byArray5, byArray6);
    }

    byte[] convertCMYKToRGB() {
        return new byte[0];
    }

    void convertImageToYCbCr(ImageData imageData) {
        switch (imageData.depth) {
            case 4: {
                this.convert4BitRGBToYCbCr(imageData);
                return;
            }
            case 8: {
                this.convert8BitRGBToYCbCr(imageData);
                return;
            }
            case 16: 
            case 24: 
            case 32: {
                this.convertMultiRGBToYCbCr(imageData);
                return;
            }
        }
        SWT.error(38);
    }

    void convertMultiRGBToYCbCr(ImageData imageData) {
        int n2 = imageData.width;
        int n3 = imageData.height;
        int n4 = n2 * n3;
        byte[] byArray = new byte[n4];
        byte[] byArray2 = new byte[n4];
        byte[] byArray3 = new byte[n4];
        PaletteData paletteData = imageData.palette;
        int[] nArray = new int[n2];
        if (paletteData.isDirect) {
            int n5 = paletteData.redMask;
            int n6 = paletteData.greenMask;
            int n7 = paletteData.blueMask;
            int n8 = paletteData.redShift;
            int n9 = paletteData.greenShift;
            int n10 = paletteData.blueShift;
            int n11 = 0;
            while (n11 < n3) {
                imageData.getPixels(0, n11, n2, nArray, 0);
                int n12 = n11 * n2;
                int n13 = 0;
                while (n13 < n2) {
                    int n14 = nArray[n13];
                    int n15 = n12 + n13;
                    int n16 = n14 & n5;
                    n16 = n8 < 0 ? n16 >>> -n8 : n16 << n8;
                    int n17 = n14 & n6;
                    n17 = n9 < 0 ? n17 >>> -n9 : n17 << n9;
                    int n18 = n14 & n7;
                    n18 = n10 < 0 ? n18 >>> -n10 : n18 << n10;
                    byArray[n15] = (byte)(RYTable[n16] + GYTable[n17] + BYTable[n18] >> 16);
                    byArray2[n15] = (byte)(RCbTable[n16] + GCbTable[n17] + BCbTable[n18] >> 16);
                    byArray3[n15] = (byte)(RCrTable[n16] + GCrTable[n17] + BCrTable[n18] >> 16);
                    ++n13;
                }
                ++n11;
            }
        } else {
            int n19 = 0;
            while (n19 < n3) {
                imageData.getPixels(0, n19, n2, nArray, 0);
                int n20 = n19 * n2;
                int n21 = 0;
                while (n21 < n2) {
                    int n22 = nArray[n21];
                    int n23 = n20 + n21;
                    RGB rGB = paletteData.getRGB(n22);
                    int n24 = rGB.red;
                    int n25 = rGB.green;
                    int n26 = rGB.blue;
                    byArray[n23] = (byte)(RYTable[n24] + GYTable[n25] + BYTable[n26] >> 16);
                    byArray2[n23] = (byte)(RCbTable[n24] + GCbTable[n25] + BCbTable[n26] >> 16);
                    byArray3[n23] = (byte)(RCrTable[n24] + GCrTable[n25] + BCrTable[n26] >> 16);
                    ++n21;
                }
                ++n19;
            }
        }
        this.compress(imageData, byArray, byArray2, byArray3);
    }

    byte[] convertYToRGB() {
        int n2 = this.frameComponents[this.componentIds[0]][3];
        int n3 = ((this.imageWidth * 8 + 7) / 8 + 3) / 4 * 4;
        byte[] byArray = new byte[n3 * this.imageHeight];
        byte[] byArray2 = this.imageComponents[0];
        int n4 = 0;
        int n5 = 0;
        while (n5 < this.imageHeight) {
            int n6 = n5 * n2;
            int n7 = 0;
            while (n7 < n3) {
                int n8 = byArray2[n6] & 0xFF;
                if (n8 < 0) {
                    n8 = 0;
                } else if (n8 > 255) {
                    n8 = 255;
                }
                if (n7 >= this.imageWidth) {
                    n8 = 0;
                }
                byArray[n4] = (byte)n8;
                ++n6;
                ++n4;
                ++n7;
            }
            ++n5;
        }
        return byArray;
    }

    byte[] convertYCbCrToRGB() {
        int n2 = this.imageWidth * this.imageHeight * this.nComponents;
        byte[] byArray = new byte[n2];
        int n3 = 0;
        this.expandImageComponents();
        byte[] byArray2 = this.imageComponents[0];
        byte[] byArray3 = this.imageComponents[1];
        byte[] byArray4 = this.imageComponents[2];
        int n4 = this.frameComponents[this.componentIds[0]][3];
        int n5 = 0;
        while (n5 < this.imageHeight) {
            int n6 = n5 * n4;
            int n7 = 0;
            while (n7 < this.imageWidth) {
                int n8 = byArray2[n6] & 0xFF;
                int n9 = byArray3[n6] & 0xFF;
                int n10 = byArray4[n6] & 0xFF;
                int n11 = n8 + CrRTable[n10];
                int n12 = n8 + (CbGTable[n9] + CrGTable[n10] >> 16);
                int n13 = n8 + CbBTable[n9];
                if (n11 < 0) {
                    n11 = 0;
                } else if (n11 > 255) {
                    n11 = 255;
                }
                if (n12 < 0) {
                    n12 = 0;
                } else if (n12 > 255) {
                    n12 = 255;
                }
                if (n13 < 0) {
                    n13 = 0;
                } else if (n13 > 255) {
                    n13 = 255;
                }
                byArray[n3] = (byte)n13;
                byArray[n3 + 1] = (byte)n12;
                byArray[n3 + 2] = (byte)n11;
                n3 += 3;
                ++n6;
                ++n7;
            }
            ++n5;
        }
        return byArray;
    }

    void decodeACCoefficients(int[] nArray, int n2) {
        int[] nArray2 = this.scanHeader.componentParameters[this.componentIds[n2]];
        JPEGHuffmanTable jPEGHuffmanTable = this.acHuffmanTables[nArray2[1]];
        int n3 = 1;
        while (n3 < 64) {
            int n4 = this.decodeUsingTable(jPEGHuffmanTable);
            int n5 = n4 >> 4;
            int n6 = n4 & 0xF;
            if (n6 == 0) {
                if (n5 != 15) break;
                n3 += 16;
                continue;
            }
            int n7 = this.receive(n6);
            nArray[JPEGFileFormat.ZigZag8x8[n3 += n5]] = this.extendBy(n7, n6);
            ++n3;
        }
    }

    void decodeACFirstCoefficients(int[] nArray, int n2, int n3, int n4, int n5) {
        if (this.eobrun > 0) {
            --this.eobrun;
            return;
        }
        int[] nArray2 = this.scanHeader.componentParameters[this.componentIds[n2]];
        JPEGHuffmanTable jPEGHuffmanTable = this.acHuffmanTables[nArray2[1]];
        int n6 = n3;
        while (n6 <= n4) {
            int n7 = this.decodeUsingTable(jPEGHuffmanTable);
            int n8 = n7 >> 4;
            int n9 = n7 & 0xF;
            if (n9 == 0) {
                if (n8 == 15) {
                    n6 += 16;
                    continue;
                }
                this.eobrun = (1 << n8) + this.receive(n8) - 1;
                break;
            }
            int n10 = this.receive(n9);
            nArray[JPEGFileFormat.ZigZag8x8[n6 += n8]] = this.extendBy(n10, n9) << n5;
            ++n6;
        }
    }

    void decodeACRefineCoefficients(int[] nArray, int n2, int n3, int n4, int n5) {
        int[] nArray2 = this.scanHeader.componentParameters[this.componentIds[n2]];
        JPEGHuffmanTable jPEGHuffmanTable = this.acHuffmanTables[nArray2[1]];
        int n6 = n3;
        while (n6 <= n4) {
            int n7;
            int n8;
            int n9;
            if (this.eobrun > 0) {
                while (n6 <= n4) {
                    n9 = ZigZag8x8[n6];
                    if (nArray[n9] != 0) {
                        nArray[n9] = this.refineAC(nArray[n9], n5);
                    }
                    ++n6;
                }
                --this.eobrun;
                continue;
            }
            n9 = this.decodeUsingTable(jPEGHuffmanTable);
            int n10 = n9 >> 4;
            int n11 = n9 & 0xF;
            if (n11 == 0) {
                if (n10 == 15) {
                    n8 = 0;
                    while (n8 < 16 && n6 <= n4) {
                        n7 = ZigZag8x8[n6];
                        if (nArray[n7] != 0) {
                            nArray[n7] = this.refineAC(nArray[n7], n5);
                        } else {
                            ++n8;
                        }
                        ++n6;
                    }
                    continue;
                }
                this.eobrun = (1 << n10) + this.receive(n10);
                continue;
            }
            n8 = this.receive(n11);
            n7 = 0;
            int n12 = ZigZag8x8[n6];
            while ((n7 < n10 || nArray[n12] != 0) && n6 <= n4) {
                if (nArray[n12] != 0) {
                    nArray[n12] = this.refineAC(nArray[n12], n5);
                } else {
                    ++n7;
                }
                n12 = ZigZag8x8[++n6];
            }
            nArray[n12] = n8 != 0 ? 1 << n5 : -1 << n5;
            ++n6;
        }
    }

    int refineAC(int n2, int n3) {
        int n4;
        if (n2 > 0) {
            int n5 = this.nextBit();
            if (n5 != 0) {
                n2 += 1 << n3;
            }
        } else if (n2 < 0 && (n4 = this.nextBit()) != 0) {
            n2 += -1 << n3;
        }
        return n2;
    }

    void decodeDCCoefficient(int[] nArray, int n2, boolean bl2, int n3) {
        int[] nArray2 = this.scanHeader.componentParameters[this.componentIds[n2]];
        JPEGHuffmanTable jPEGHuffmanTable = this.dcHuffmanTables[nArray2[0]];
        int n4 = 0;
        if (this.progressive && !bl2) {
            int n5 = this.nextBit();
            n4 = nArray[0] + (n5 << n3);
        } else {
            n4 = this.precedingDCs[n2];
            int n6 = this.decodeUsingTable(jPEGHuffmanTable);
            if (n6 != 0) {
                int n7 = this.receive(n6);
                int n8 = this.extendBy(n7, n6);
                this.precedingDCs[n2] = n4 += n8;
            }
            if (this.progressive) {
                n4 <<= n3;
            }
        }
        nArray[0] = n4;
    }

    void dequantize(int[] nArray, int n2) {
        int[] nArray2 = this.quantizationTables[this.frameComponents[this.componentIds[n2]][0]];
        int n3 = 0;
        while (n3 < nArray.length) {
            int n4 = ZigZag8x8[n3];
            nArray[n4] = nArray[n4] * nArray2[n3];
            ++n3;
        }
    }

    byte[] decodeImageComponents() {
        if (this.nComponents == 3) {
            return this.convertYCbCrToRGB();
        }
        if (this.nComponents == 4) {
            return this.convertCMYKToRGB();
        }
        return this.convertYToRGB();
    }

    void decodeMCUAtXAndY(int n2, int n3, int n4, boolean bl2, int n5, int n6, int n7) {
        int n8 = 0;
        while (n8 < n4) {
            int n9 = n8;
            while (this.scanHeader.componentParameters[this.componentIds[n9]] == null) {
                ++n9;
            }
            int[] nArray = this.frameComponents[this.componentIds[n9]];
            int n10 = nArray[1];
            int n11 = nArray[2];
            if (n4 == 1) {
                n10 = 1;
                n11 = 1;
            }
            int n12 = nArray[3];
            int n13 = 0;
            while (n13 < n11) {
                int n14 = 0;
                while (n14 < n10) {
                    int n15;
                    if (this.progressive) {
                        n15 = (n3 * n11 + n13) * n12 + n2 * n10 + n14;
                        this.dataUnit = this.dataUnits[n9][n15];
                        if (this.dataUnit == null) {
                            this.dataUnit = new int[64];
                            this.dataUnits[n9][n15] = this.dataUnit;
                        }
                    } else {
                        n15 = 0;
                        while (n15 < this.dataUnit.length) {
                            this.dataUnit[n15] = 0;
                            ++n15;
                        }
                    }
                    if (!this.progressive || this.scanHeader.isDCProgressiveScan()) {
                        this.decodeDCCoefficient(this.dataUnit, n9, bl2, n7);
                    }
                    if (!this.progressive) {
                        this.decodeACCoefficients(this.dataUnit, n9);
                    } else {
                        if (this.scanHeader.isACProgressiveScan()) {
                            if (bl2) {
                                this.decodeACFirstCoefficients(this.dataUnit, n9, n5, n6, n7);
                            } else {
                                this.decodeACRefineCoefficients(this.dataUnit, n9, n5, n6, n7);
                            }
                        }
                        if (this.loader.hasListeners()) {
                            int[] nArray2 = this.dataUnit;
                            this.dataUnit = new int[64];
                            System.arraycopy(nArray2, 0, this.dataUnit, 0, 64);
                        }
                    }
                    if (!this.progressive || this.progressive && this.loader.hasListeners()) {
                        this.dequantize(this.dataUnit, n9);
                        this.inverseDCT(this.dataUnit);
                        this.storeData(this.dataUnit, n9, n2, n3, n10, n14, n11, n13);
                    }
                    ++n14;
                }
                ++n13;
            }
            ++n8;
        }
    }

    void decodeScan() {
        int n2;
        int n3;
        int n4;
        int n5;
        boolean bl2;
        if (this.progressive && !this.scanHeader.verifyProgressiveScan()) {
            SWT.error(40);
        }
        int n6 = this.scanHeader.getNumberOfImageComponents();
        int n7 = this.interleavedMcuRows;
        int n8 = this.interleavedMcuCols;
        if (n6 == 1) {
            bl2 = false;
            while (this.scanHeader.componentParameters[this.componentIds[bl2]] == null) {
                bl2 += 1;
            }
            int[] nArray = this.frameComponents[this.componentIds[bl2]];
            n5 = nArray[1];
            n4 = nArray[2];
            n3 = 8 * this.maxH / n5;
            n2 = 8 * this.maxV / n4;
            n8 = (this.imageWidth + n3 - 1) / n3;
            n7 = (this.imageHeight + n2 - 1) / n2;
        }
        bl2 = this.scanHeader.isFirstScan();
        int n9 = this.scanHeader.getStartOfSpectralSelection();
        n5 = this.scanHeader.getEndOfSpectralSelection();
        n4 = this.scanHeader.getApproxBitPositionLow();
        this.restartsToGo = this.restartInterval;
        this.nextRestartNumber = 0;
        n3 = 0;
        while (n3 < n7) {
            n2 = 0;
            while (n2 < n8) {
                if (this.restartInterval != 0) {
                    if (this.restartsToGo == 0) {
                        this.processRestartInterval();
                    }
                    --this.restartsToGo;
                }
                this.decodeMCUAtXAndY(n2, n3, n6, bl2, n9, n5, n4);
                ++n2;
            }
            ++n3;
        }
    }

    int decodeUsingTable(JPEGHuffmanTable jPEGHuffmanTable) {
        int n2 = 0;
        int[] nArray = jPEGHuffmanTable.getDhMaxCodes();
        int[] nArray2 = jPEGHuffmanTable.getDhMinCodes();
        int[] nArray3 = jPEGHuffmanTable.getDhValPtrs();
        int[] nArray4 = jPEGHuffmanTable.getDhValues();
        int n3 = this.nextBit();
        while (n3 > nArray[n2]) {
            n3 = n3 * 2 + this.nextBit();
            ++n2;
        }
        int n4 = nArray3[n2] + n3 - nArray2[n2];
        return nArray4[n4];
    }

    void emit(int n2, int n3) {
        if (n3 == 0) {
            SWT.error(40);
        }
        int[] nArray = new int[]{1, 3, 7, 15, 31, 63, 127, 255, 511, 1023, 2047, 4095, 8191, 16383, Short.MAX_VALUE, 65535, 131125};
        int n4 = (n2 & nArray[n3 - 1]) << 24 - n3 - this.currentBitCount;
        byte[] byArray = new byte[]{(byte)(n4 & 0xFF), (byte)(n4 >> 8 & 0xFF), (byte)(n4 >> 16 & 0xFF), (byte)(n4 >> 24 & 0xFF)};
        int n5 = n3 - (8 - this.currentBitCount);
        if (n5 < 0) {
            n5 = -n5;
        }
        if (n5 >> 3 > 0) {
            this.currentByte += byArray[2];
            this.emitByte((byte)this.currentByte);
            this.emitByte(byArray[1]);
            this.currentByte = byArray[0];
            this.currentBitCount += n3 - 16;
        } else {
            this.currentBitCount += n3;
            if (this.currentBitCount >= 8) {
                this.currentByte += byArray[2];
                this.emitByte((byte)this.currentByte);
                this.currentByte = byArray[1];
                this.currentBitCount -= 8;
            } else {
                this.currentByte += byArray[2];
            }
        }
    }

    void emitByte(byte by2) {
        if (this.bufferCurrentPosition >= 512) {
            this.resetOutputBuffer();
        }
        this.dataBuffer[this.bufferCurrentPosition] = by2;
        ++this.bufferCurrentPosition;
        if (by2 == -1) {
            this.emitByte((byte)0);
        }
    }

    /*
     * Unable to fully structure code
     */
    void encodeACCoefficients(int[] var1_1, int var2_2) {
        var3_3 = this.scanHeader.componentParameters[var2_2];
        var4_4 = this.acHuffmanTables[var3_3[1]];
        var5_5 = var4_4.ehCodes;
        var6_6 = var4_4.ehCodeLengths;
        var7_7 = 0;
        var8_8 = 1;
        while (var8_8 < 64) {
            if ((var9_9 = var1_1[JPEGFileFormat.ZigZag8x8[++var8_8 - 1]]) != 0) ** GOTO lbl16
            if (var8_8 == 64) {
                this.emit(var5_5[0], var6_6[0] & 255);
                continue;
            }
            ++var7_7;
            continue;
lbl-1000:
            // 1 sources

            {
                this.emit(var5_5[240], var6_6[240] & 255);
                var7_7 -= 16;
lbl16:
                // 2 sources

                ** while (var7_7 > 15)
            }
lbl17:
            // 1 sources

            if (var9_9 < 0) {
                var10_10 = var9_9;
                if (var10_10 < 0) {
                    var10_10 = -var10_10;
                }
                var11_11 = JPEGFileFormat.NBitsTable[var10_10];
                var12_12 = var7_7 * 16 + var11_11;
                this.emit(var5_5[var12_12], var6_6[var12_12] & 255);
                this.emit(0xFFFFFF - var10_10, var11_11);
            } else {
                var10_10 = JPEGFileFormat.NBitsTable[var9_9];
                var11_11 = var7_7 * 16 + var10_10;
                this.emit(var5_5[var11_11], var6_6[var11_11] & 255);
                this.emit(var9_9, var10_10);
            }
            var7_7 = 0;
        }
    }

    void encodeDCCoefficients(int[] nArray, int n2) {
        int[] nArray2 = this.scanHeader.componentParameters[n2];
        JPEGHuffmanTable jPEGHuffmanTable = this.dcHuffmanTables[nArray2[0]];
        int n3 = this.precedingDCs[n2];
        int n4 = nArray[0];
        int n5 = n4 - n3;
        this.precedingDCs[n2] = n4;
        if (n5 < 0) {
            int n6 = 0 - n5;
            int n7 = NBitsTable[n6];
            this.emit(jPEGHuffmanTable.ehCodes[n7], jPEGHuffmanTable.ehCodeLengths[n7]);
            this.emit(0xFFFFFF - n6, n7);
        } else {
            int n8 = NBitsTable[n5];
            this.emit(jPEGHuffmanTable.ehCodes[n8], jPEGHuffmanTable.ehCodeLengths[n8]);
            if (n8 != 0) {
                this.emit(n5, n8);
            }
        }
    }

    void encodeMCUAtXAndY(int n2, int n3) {
        int n4 = this.scanHeader.getNumberOfImageComponents();
        this.dataUnit = new int[64];
        int n5 = 0;
        while (n5 < n4) {
            int[] nArray = this.frameComponents[this.componentIds[n5]];
            int n6 = nArray[1];
            int n7 = nArray[2];
            int n8 = 0;
            while (n8 < n7) {
                int n9 = 0;
                while (n9 < n6) {
                    this.extractData(this.dataUnit, n5, n2, n3, n9, n8);
                    this.forwardDCT(this.dataUnit);
                    this.quantizeData(this.dataUnit, n5);
                    this.encodeDCCoefficients(this.dataUnit, n5);
                    this.encodeACCoefficients(this.dataUnit, n5);
                    ++n9;
                }
                ++n8;
            }
            ++n5;
        }
    }

    void encodeScan() {
        int n2 = 0;
        while (n2 < this.interleavedMcuRows) {
            int n3 = 0;
            while (n3 < this.interleavedMcuCols) {
                this.encodeMCUAtXAndY(n3, n2);
                ++n3;
            }
            ++n2;
        }
        if (this.currentBitCount != 0) {
            this.emitByte((byte)this.currentByte);
        }
        this.resetOutputBuffer();
    }

    void expandImageComponents() {
        int n2 = 0;
        while (n2 < this.nComponents) {
            int[] nArray = this.frameComponents[this.componentIds[n2]];
            int n3 = nArray[1];
            int n4 = this.maxH / n3;
            int n5 = nArray[2];
            int n6 = this.maxV / n5;
            if (n4 * n6 > 1) {
                byte[] byArray = this.imageComponents[n2];
                int n7 = nArray[3];
                int n8 = nArray[4];
                int n9 = n7 * n4;
                int n10 = n8 * n6;
                ImageData imageData = new ImageData(n7, n8, 8, new PaletteData(RGB16), 4, byArray);
                ImageData imageData2 = imageData.scaledTo(n9, n10);
                this.imageComponents[n2] = imageData2.data;
            }
            ++n2;
        }
    }

    int extendBy(int n2, int n3) {
        if (n2 < ExtendTest[n3]) {
            return n2 + ExtendOffset[n3];
        }
        return n2;
    }

    void extractData(int[] nArray, int n2, int n3, int n4, int n5, int n6) {
        byte[] byArray = this.imageComponents[n2];
        int[] nArray2 = this.frameComponents[this.componentIds[n2]];
        int n7 = nArray2[1];
        int n8 = nArray2[2];
        int n9 = nArray2[3];
        int n10 = (n4 * n8 + n6) * n9 * 8 + (n3 * n7 + n5) * 8;
        int n11 = 0;
        int n12 = 0;
        while (n12 < 8) {
            int n13 = 0;
            while (n13 < 8) {
                nArray[n11] = (byArray[n10 + n13] & 0xFF) - 128;
                ++n11;
                ++n13;
            }
            n10 += n9;
            ++n12;
        }
    }

    void forwardDCT(int[] nArray) {
        int n2;
        int n3;
        int n4;
        int n5;
        int n6;
        int n7;
        int n8;
        int n9;
        int n10;
        int n11;
        int n12;
        int n13;
        int n14;
        int n15;
        int n16;
        int n17;
        int n18;
        int n19;
        int n20;
        int n21 = 0;
        while (n21 < 8) {
            n20 = n21 * 8;
            n19 = nArray[n20] + nArray[n20 + 7];
            n18 = nArray[n20] - nArray[n20 + 7];
            n17 = nArray[n20 + 1] + nArray[n20 + 6];
            n16 = nArray[n20 + 1] - nArray[n20 + 6];
            n15 = nArray[n20 + 2] + nArray[n20 + 5];
            n14 = nArray[n20 + 2] - nArray[n20 + 5];
            n13 = nArray[n20 + 3] + nArray[n20 + 4];
            n12 = nArray[n20 + 3] - nArray[n20 + 4];
            n11 = n19 + n13;
            n10 = n19 - n13;
            n9 = n17 + n15;
            n8 = n17 - n15;
            nArray[n20] = (n11 + n9) * 4;
            nArray[n20 + 4] = (n11 - n9) * 4;
            n7 = (n8 + n10) * 4433;
            n6 = n7 + n10 * 6270 + 1024;
            nArray[n20 + 2] = n6 >> 11;
            if (n6 < 0 && (n6 & 0x7FF) != 0) {
                int n22 = n20 + 2;
                nArray[n22] = nArray[n22] - 1;
            }
            n6 = n7 + n8 * -15137 + 1024;
            nArray[n20 + 6] = n6 >> 11;
            if (n6 < 0 && (n6 & 0x7FF) != 0) {
                int n23 = n20 + 6;
                nArray[n23] = nArray[n23] - 1;
            }
            n7 = n12 + n18;
            n5 = n14 + n16;
            n4 = n12 + n16;
            n3 = n14 + n18;
            n2 = (n4 + n3) * 9633;
            n12 *= 2446;
            n14 *= 16819;
            n16 *= 25172;
            n18 *= 12299;
            n5 *= -20995;
            n4 *= -16069;
            n3 *= -3196;
            n3 += n2;
            n6 = n12 + (n7 *= -7373) + (n4 += n2) + 1024;
            nArray[n20 + 7] = n6 >> 11;
            if (n6 < 0 && (n6 & 0x7FF) != 0) {
                int n24 = n20 + 7;
                nArray[n24] = nArray[n24] - 1;
            }
            n6 = n14 + n5 + n3 + 1024;
            nArray[n20 + 5] = n6 >> 11;
            if (n6 < 0 && (n6 & 0x7FF) != 0) {
                int n25 = n20 + 5;
                nArray[n25] = nArray[n25] - 1;
            }
            n6 = n16 + n5 + n4 + 1024;
            nArray[n20 + 3] = n6 >> 11;
            if (n6 < 0 && (n6 & 0x7FF) != 0) {
                int n26 = n20 + 3;
                nArray[n26] = nArray[n26] - 1;
            }
            n6 = n18 + n7 + n3 + 1024;
            nArray[n20 + 1] = n6 >> 11;
            if (n6 < 0 && (n6 & 0x7FF) != 0) {
                int n27 = n20 + 1;
                nArray[n27] = nArray[n27] - 1;
            }
            ++n21;
        }
        n21 = 0;
        while (n21 < 8) {
            n20 = n21;
            n19 = n21 + 8;
            n18 = n21 + 16;
            n17 = n21 + 24;
            n16 = n21 + 32;
            n15 = n21 + 40;
            n14 = n21 + 48;
            n13 = n21 + 56;
            n12 = nArray[n20] + nArray[n13];
            n11 = nArray[n20] - nArray[n13];
            n10 = nArray[n19] + nArray[n14];
            n9 = nArray[n19] - nArray[n14];
            n8 = nArray[n18] + nArray[n15];
            n7 = nArray[n18] - nArray[n15];
            n6 = nArray[n17] + nArray[n16];
            n5 = nArray[n17] - nArray[n16];
            n4 = n12 + n6;
            n3 = n12 - n6;
            n2 = n10 + n8;
            int n28 = n10 - n8;
            int n29 = n4 + n2 + 16;
            nArray[n20] = n29 >> 5;
            if (n29 < 0 && (n29 & 0x1F) != 0) {
                int n30 = n20;
                nArray[n30] = nArray[n30] - 1;
            }
            n29 = n4 - n2 + 16;
            nArray[n16] = n29 >> 5;
            if (n29 < 0 && (n29 & 0x1F) != 0) {
                int n31 = n16;
                nArray[n31] = nArray[n31] - 1;
            }
            int n32 = (n28 + n3) * 4433;
            n29 = n32 + n3 * 6270 + 131072;
            nArray[n18] = n29 >> 18;
            if (n29 < 0 && (n29 & 0x3FFFF) != 0) {
                int n33 = n18;
                nArray[n33] = nArray[n33] - 1;
            }
            n29 = n32 + n28 * -15137 + 131072;
            nArray[n14] = n29 >> 18;
            if (n29 < 0 && (n29 & 0x3FFFF) != 0) {
                int n34 = n14;
                nArray[n34] = nArray[n34] - 1;
            }
            n32 = n5 + n11;
            int n35 = n7 + n9;
            int n36 = n5 + n9;
            int n37 = n7 + n11;
            int n38 = (n36 + n37) * 9633;
            n5 *= 2446;
            n7 *= 16819;
            n9 *= 25172;
            n11 *= 12299;
            n35 *= -20995;
            n36 *= -16069;
            n37 *= -3196;
            n37 += n38;
            n29 = n5 + (n32 *= -7373) + (n36 += n38) + 131072;
            nArray[n13] = n29 >> 18;
            if (n29 < 0 && (n29 & 0x3FFFF) != 0) {
                int n39 = n13;
                nArray[n39] = nArray[n39] - 1;
            }
            n29 = n7 + n35 + n37 + 131072;
            nArray[n15] = n29 >> 18;
            if (n29 < 0 && (n29 & 0x3FFFF) != 0) {
                int n40 = n15;
                nArray[n40] = nArray[n40] - 1;
            }
            n29 = n9 + n35 + n36 + 131072;
            nArray[n17] = n29 >> 18;
            if (n29 < 0 && (n29 & 0x3FFFF) != 0) {
                int n41 = n17;
                nArray[n41] = nArray[n41] - 1;
            }
            n29 = n11 + n32 + n37 + 131072;
            nArray[n19] = n29 >> 18;
            if (n29 < 0 && (n29 & 0x3FFFF) != 0) {
                int n42 = n19;
                nArray[n42] = nArray[n42] - 1;
            }
            ++n21;
        }
    }

    void getAPP0() {
        JPEGAppn jPEGAppn = new JPEGAppn(this.inputStream);
        if (!jPEGAppn.verify()) {
            SWT.error(40);
        }
    }

    void getCOM() {
        new JPEGComment(this.inputStream);
    }

    void getDAC() {
        new JPEGArithmeticConditioningTable(this.inputStream);
    }

    void getDHT() {
        JPEGHuffmanTable jPEGHuffmanTable = new JPEGHuffmanTable(this.inputStream);
        if (!jPEGHuffmanTable.verify()) {
            SWT.error(40);
        }
        if (this.acHuffmanTables == null) {
            this.acHuffmanTables = new JPEGHuffmanTable[4];
        }
        if (this.dcHuffmanTables == null) {
            this.dcHuffmanTables = new JPEGHuffmanTable[4];
        }
        JPEGHuffmanTable[] jPEGHuffmanTableArray = jPEGHuffmanTable.getAllTables();
        int n2 = 0;
        while (n2 < jPEGHuffmanTableArray.length) {
            JPEGHuffmanTable jPEGHuffmanTable2 = jPEGHuffmanTableArray[n2];
            if (jPEGHuffmanTable2.getTableClass() == 0) {
                this.dcHuffmanTables[jPEGHuffmanTable2.getTableIdentifier()] = jPEGHuffmanTable2;
            } else {
                this.acHuffmanTables[jPEGHuffmanTable2.getTableIdentifier()] = jPEGHuffmanTable2;
            }
            ++n2;
        }
    }

    void getDNL() {
        new JPEGRestartInterval(this.inputStream);
    }

    void getDQT() {
        JPEGQuantizationTable jPEGQuantizationTable = new JPEGQuantizationTable(this.inputStream);
        Object object = this.quantizationTables;
        if (object == null) {
            object = new int[4][];
        }
        int[] nArray = jPEGQuantizationTable.getQuantizationTablesKeys();
        int[][] nArray2 = jPEGQuantizationTable.getQuantizationTablesValues();
        int n2 = 0;
        while (n2 < nArray.length) {
            int n3 = nArray[n2];
            object[n3] = nArray2[n2];
            ++n2;
        }
        this.quantizationTables = object;
    }

    void getDRI() {
        JPEGRestartInterval jPEGRestartInterval = new JPEGRestartInterval(this.inputStream);
        if (!jPEGRestartInterval.verify()) {
            SWT.error(40);
        }
        this.restartInterval = jPEGRestartInterval.getRestartInterval();
    }

    static void initialize() {
        JPEGFileFormat.initializeRGBYCbCrTables();
        JPEGFileFormat.initializeYCbCrRGBTables();
        JPEGFileFormat.initializeBitCountTable();
    }

    static void initializeBitCountTable() {
        int n2 = 1;
        int n3 = 2;
        NBitsTable = new int[2048];
        JPEGFileFormat.NBitsTable[0] = 0;
        int n4 = 1;
        while (n4 < NBitsTable.length) {
            if (n4 >= n3) {
                n3 *= 2;
            }
            JPEGFileFormat.NBitsTable[n4] = ++n2;
            ++n4;
        }
    }

    static void initializeRGBYCbCrTables() {
        RYTable = new int[256];
        GYTable = new int[256];
        BYTable = new int[256];
        RCbTable = new int[256];
        GCbTable = new int[256];
        BCbTable = new int[256];
        RCrTable = BCbTable;
        GCrTable = new int[256];
        BCrTable = new int[256];
        int n2 = 0;
        while (n2 < 256) {
            JPEGFileFormat.RYTable[n2] = n2 * 19595;
            JPEGFileFormat.GYTable[n2] = n2 * 38470;
            JPEGFileFormat.BYTable[n2] = n2 * 7471 + 32768;
            JPEGFileFormat.RCbTable[n2] = n2 * -11059;
            JPEGFileFormat.GCbTable[n2] = n2 * -21709;
            JPEGFileFormat.BCbTable[n2] = n2 * 32768 + 0x800000;
            JPEGFileFormat.GCrTable[n2] = n2 * -27439;
            JPEGFileFormat.BCrTable[n2] = n2 * -5329;
            ++n2;
        }
    }

    static void initializeYCbCrRGBTables() {
        CrRTable = new int[256];
        CbBTable = new int[256];
        CrGTable = new int[256];
        CbGTable = new int[256];
        int n2 = 0;
        while (n2 < 256) {
            int n3 = 2 * n2 - 255;
            JPEGFileFormat.CrRTable[n2] = 45941 * n3 + 32768 >> 16;
            JPEGFileFormat.CbBTable[n2] = 58065 * n3 + 32768 >> 16;
            JPEGFileFormat.CrGTable[n2] = -23401 * n3;
            JPEGFileFormat.CbGTable[n2] = -11277 * n3 + 32768;
            ++n2;
        }
    }

    void inverseDCT(int[] nArray) {
        int n2;
        int n3;
        int n4;
        int n5;
        int n6;
        int n7;
        int n8;
        int n9;
        int n10;
        int n11;
        int n12;
        int n13;
        int n14;
        int n15;
        int n16 = 0;
        while (n16 < 8) {
            n15 = n16 * 8;
            if (this.isZeroInRow(nArray, n15)) {
                n14 = nArray[n15] << 2;
                n13 = n15 + 7;
                while (n13 >= n15) {
                    nArray[n13] = n14;
                    --n13;
                }
            } else {
                n14 = nArray[n15 + 2];
                n13 = nArray[n15 + 6];
                n12 = (n14 + n13) * 4433;
                n11 = n12 + n13 * -15137;
                n10 = n12 + n14 * 6270;
                n9 = nArray[n15] + nArray[n15 + 4] << 13;
                n8 = nArray[n15] - nArray[n15 + 4] << 13;
                n7 = n9 + n10;
                n6 = n9 - n10;
                n5 = n8 + n11;
                n4 = n8 - n11;
                n9 = nArray[n15 + 7];
                n8 = nArray[n15 + 5];
                n11 = nArray[n15 + 3];
                n10 = nArray[n15 + 1];
                n12 = n9 + n10;
                n14 = n8 + n11;
                n13 = n9 + n11;
                n3 = n8 + n10;
                n2 = (n13 + n3) * 9633;
                n9 *= 2446;
                n8 *= 16819;
                n11 *= 25172;
                n10 *= 12299;
                n13 *= -16069;
                n3 *= -3196;
                n9 += (n12 *= -7373) + (n13 += n2);
                nArray[n15] = n7 + (n10 += n12 + n3) + 1024 >> 11;
                nArray[n15 + 7] = n7 - n10 + 1024 >> 11;
                nArray[n15 + 1] = n5 + (n11 += n14 + n13) + 1024 >> 11;
                nArray[n15 + 6] = n5 - n11 + 1024 >> 11;
                nArray[n15 + 2] = n4 + (n8 += (n14 *= -20995) + (n3 += n2)) + 1024 >> 11;
                nArray[n15 + 5] = n4 - n8 + 1024 >> 11;
                nArray[n15 + 3] = n6 + n9 + 1024 >> 11;
                nArray[n15 + 4] = n6 - n9 + 1024 >> 11;
            }
            ++n16;
        }
        n16 = 0;
        while (n16 < 8) {
            n15 = n16;
            n14 = n16 + 8;
            n13 = n16 + 16;
            n12 = n16 + 24;
            n11 = n16 + 32;
            n10 = n16 + 40;
            n9 = n16 + 48;
            n8 = n16 + 56;
            if (this.isZeroInColumn(nArray, n16)) {
                nArray[n15] = n7 = nArray[n15] + 16 >> 5;
                nArray[n14] = n7;
                nArray[n13] = n7;
                nArray[n12] = n7;
                nArray[n11] = n7;
                nArray[n10] = n7;
                nArray[n9] = n7;
                nArray[n8] = n7;
            } else {
                n7 = nArray[n15];
                n6 = nArray[n13];
                n5 = nArray[n9];
                n4 = nArray[n11];
                n3 = (n6 + n5) * 4433;
                n2 = n3 + n5 * -15137;
                int n17 = n3 + n6 * 6270;
                int n18 = n7 + n4 << 13;
                int n19 = n7 - n4 << 13;
                int n20 = n18 + n17;
                int n21 = n18 - n17;
                int n22 = n19 + n2;
                int n23 = n19 - n2;
                n18 = nArray[n8];
                n19 = nArray[n10];
                n2 = nArray[n12];
                n17 = nArray[n14];
                n3 = n18 + n17;
                n6 = n19 + n2;
                n5 = n18 + n2;
                n4 = n19 + n17;
                n7 = (n5 + n4) * 9633;
                n18 *= 2446;
                n19 *= 16819;
                n2 *= 25172;
                n17 *= 12299;
                n5 *= -16069;
                n4 *= -3196;
                n18 += (n3 *= -7373) + (n5 += n7);
                nArray[n15] = n20 + (n17 += n3 + n4) + 131072 >> 18;
                nArray[n8] = n20 - n17 + 131072 >> 18;
                nArray[n14] = n22 + (n2 += n6 + n5) + 131072 >> 18;
                nArray[n9] = n22 - n2 + 131072 >> 18;
                nArray[n13] = n23 + (n19 += (n6 *= -20995) + (n4 += n7)) + 131072 >> 18;
                nArray[n10] = n23 - n19 + 131072 >> 18;
                nArray[n12] = n21 + n18 + 131072 >> 18;
                nArray[n11] = n21 - n18 + 131072 >> 18;
            }
            ++n16;
        }
    }

    boolean isFileFormat(LEDataInputStream lEDataInputStream) {
        try {
            JPEGStartOfImage jPEGStartOfImage = new JPEGStartOfImage(lEDataInputStream);
            lEDataInputStream.unread(jPEGStartOfImage.reference);
            return jPEGStartOfImage.verify();
        }
        catch (Exception exception) {
            return false;
        }
    }

    boolean isZeroInColumn(int[] nArray, int n2) {
        return nArray[n2 + 8] == 0 && nArray[n2 + 16] == 0 && nArray[n2 + 24] == 0 && nArray[n2 + 32] == 0 && nArray[n2 + 40] == 0 && nArray[n2 + 48] == 0 && nArray[n2 + 56] == 0;
    }

    boolean isZeroInRow(int[] nArray, int n2) {
        return nArray[n2 + 1] == 0 && nArray[n2 + 2] == 0 && nArray[n2 + 3] == 0 && nArray[n2 + 4] == 0 && nArray[n2 + 5] == 0 && nArray[n2 + 6] == 0 && nArray[n2 + 7] == 0;
    }

    ImageData[] loadFromByteStream() {
        int n2;
        if (System.getProperty("org.eclipse.swt.internal.image.JPEGFileFormat_3.2") == null) {
            return JPEGDecoder.loadFromByteStream(this.inputStream, this.loader);
        }
        JPEGStartOfImage jPEGStartOfImage = new JPEGStartOfImage(this.inputStream);
        if (!jPEGStartOfImage.verify()) {
            SWT.error(40);
        }
        this.restartInterval = 0;
        this.processTables();
        this.frameHeader = new JPEGFrameHeader(this.inputStream);
        if (!this.frameHeader.verify()) {
            SWT.error(40);
        }
        this.imageWidth = this.frameHeader.getSamplesPerLine();
        this.imageHeight = this.frameHeader.getNumberOfLines();
        this.maxH = this.frameHeader.getMaxHFactor();
        this.maxV = this.frameHeader.getMaxVFactor();
        int n3 = this.maxH * 8;
        int n4 = this.maxV * 8;
        this.interleavedMcuCols = (this.imageWidth + n3 - 1) / n3;
        this.interleavedMcuRows = (this.imageHeight + n4 - 1) / n4;
        this.progressive = this.frameHeader.isProgressive();
        this.samplePrecision = this.frameHeader.getSamplePrecision();
        this.nComponents = this.frameHeader.getNumberOfImageComponents();
        this.frameComponents = this.frameHeader.componentParameters;
        this.componentIds = this.frameHeader.componentIdentifiers;
        this.imageComponents = new byte[this.nComponents][];
        if (this.progressive) {
            this.dataUnits = new int[this.nComponents][][];
        } else {
            this.dataUnit = new int[64];
        }
        int n5 = 0;
        while (n5 < this.nComponents) {
            int[] nArray = this.frameComponents[this.componentIds[n5]];
            n2 = nArray[3] * nArray[4];
            this.imageComponents[n5] = new byte[n2];
            if (this.progressive) {
                this.dataUnits[n5] = new int[n2][];
            }
            ++n5;
        }
        this.processTables();
        this.scanHeader = new JPEGScanHeader(this.inputStream);
        if (!this.scanHeader.verify()) {
            SWT.error(40);
        }
        n5 = 0;
        boolean bl2 = false;
        while (!bl2) {
            Object object;
            this.resetInputBuffer();
            this.precedingDCs = new int[4];
            this.decodeScan();
            if (this.progressive && this.loader.hasListeners()) {
                ImageData imageData = this.createImageData();
                this.loader.notifyListeners(new ImageLoaderEvent(this.loader, imageData, n5, false));
                ++n5;
            }
            if ((n2 = 512 - this.bufferCurrentPosition - 1) > 0) {
                object = new byte[n2];
                System.arraycopy(this.dataBuffer, this.bufferCurrentPosition + 1, object, 0, n2);
                try {
                    this.inputStream.unread((byte[])object);
                }
                catch (IOException iOException) {
                    SWT.error(39, iOException);
                }
            }
            if ((object = (Object)this.processTables()) == null || ((JPEGSegment)object).getSegmentMarker() == 65497) {
                bl2 = true;
                continue;
            }
            this.scanHeader = new JPEGScanHeader(this.inputStream);
            if (this.scanHeader.verify()) continue;
            SWT.error(40);
        }
        if (this.progressive) {
            n2 = 0;
            while (n2 < this.interleavedMcuRows) {
                int n6 = 0;
                while (n6 < this.interleavedMcuCols) {
                    int n7 = 0;
                    while (n7 < this.nComponents) {
                        int[] nArray = this.frameComponents[this.componentIds[n7]];
                        int n8 = nArray[1];
                        int n9 = nArray[2];
                        int n10 = nArray[3];
                        int n11 = 0;
                        while (n11 < n9) {
                            int n12 = 0;
                            while (n12 < n8) {
                                int n13 = (n2 * n9 + n11) * n10 + n6 * n8 + n12;
                                this.dataUnit = this.dataUnits[n7][n13];
                                this.dequantize(this.dataUnit, n7);
                                this.inverseDCT(this.dataUnit);
                                this.storeData(this.dataUnit, n7, n6, n2, n8, n12, n9, n11);
                                ++n12;
                            }
                            ++n11;
                        }
                        ++n7;
                    }
                    ++n6;
                }
                ++n2;
            }
            this.dataUnits = null;
        }
        ImageData imageData = this.createImageData();
        if (this.progressive && this.loader.hasListeners()) {
            this.loader.notifyListeners(new ImageLoaderEvent(this.loader, imageData, n5, true));
        }
        return new ImageData[]{imageData};
    }

    ImageData createImageData() {
        return ImageData.internal_new(this.imageWidth, this.imageHeight, this.nComponents * this.samplePrecision, this.setUpPalette(), this.nComponents == 1 ? 4 : 1, this.decodeImageComponents(), 0, null, null, -1, -1, 4, 0, 0, 0, 0);
    }

    int nextBit() {
        byte by2;
        if (this.currentBitCount != 0) {
            --this.currentBitCount;
            this.currentByte *= 2;
            if (this.currentByte > 255) {
                this.currentByte -= 256;
                return 1;
            }
            return 0;
        }
        ++this.bufferCurrentPosition;
        if (this.bufferCurrentPosition >= 512) {
            this.resetInputBuffer();
            this.bufferCurrentPosition = 0;
        }
        this.currentByte = this.dataBuffer[this.bufferCurrentPosition] & 0xFF;
        this.currentBitCount = 8;
        if (this.bufferCurrentPosition == 511) {
            this.resetInputBuffer();
            this.currentBitCount = 8;
            by2 = this.dataBuffer[0];
        } else {
            by2 = this.dataBuffer[this.bufferCurrentPosition + 1];
        }
        if (this.currentByte == 255) {
            if (by2 == 0) {
                ++this.bufferCurrentPosition;
                --this.currentBitCount;
                this.currentByte *= 2;
                if (this.currentByte > 255) {
                    this.currentByte -= 256;
                    return 1;
                }
                return 0;
            }
            if ((by2 & 0xFF) + 65280 == 65500) {
                this.getDNL();
                return 0;
            }
            SWT.error(40);
            return 0;
        }
        --this.currentBitCount;
        this.currentByte *= 2;
        if (this.currentByte > 255) {
            this.currentByte -= 256;
            return 1;
        }
        return 0;
    }

    void processRestartInterval() {
        do {
            ++this.bufferCurrentPosition;
            if (this.bufferCurrentPosition > 511) {
                this.resetInputBuffer();
                this.bufferCurrentPosition = 0;
            }
            this.currentByte = this.dataBuffer[this.bufferCurrentPosition] & 0xFF;
        } while (this.currentByte != 255);
        while (this.currentByte == 255) {
            ++this.bufferCurrentPosition;
            if (this.bufferCurrentPosition > 511) {
                this.resetInputBuffer();
                this.bufferCurrentPosition = 0;
            }
            this.currentByte = this.dataBuffer[this.bufferCurrentPosition] & 0xFF;
        }
        if (this.currentByte != (65488 + this.nextRestartNumber & 0xFF)) {
            SWT.error(40);
        }
        ++this.bufferCurrentPosition;
        if (this.bufferCurrentPosition > 511) {
            this.resetInputBuffer();
            this.bufferCurrentPosition = 0;
        }
        this.currentByte = this.dataBuffer[this.bufferCurrentPosition] & 0xFF;
        this.currentBitCount = 8;
        this.restartsToGo = this.restartInterval;
        this.nextRestartNumber = this.nextRestartNumber + 1 & 7;
        this.precedingDCs = new int[4];
        this.eobrun = 0;
    }

    JPEGSegment processTables() {
        JPEGSegment jPEGSegment;
        block10: while ((jPEGSegment = JPEGFileFormat.seekUnspecifiedMarker(this.inputStream)) != null) {
            JPEGFrameHeader jPEGFrameHeader = new JPEGFrameHeader(jPEGSegment.reference);
            if (jPEGFrameHeader.verify()) {
                return jPEGSegment;
            }
            int n2 = jPEGSegment.getSegmentMarker();
            switch (n2) {
                case 65496: {
                    SWT.error(40);
                }
                case 65497: 
                case 65498: {
                    return jPEGSegment;
                }
                case 65499: {
                    this.getDQT();
                    continue block10;
                }
                case 65476: {
                    this.getDHT();
                    continue block10;
                }
                case 65484: {
                    this.getDAC();
                    continue block10;
                }
                case 65501: {
                    this.getDRI();
                    continue block10;
                }
                case 65504: {
                    this.getAPP0();
                    continue block10;
                }
                case 65534: {
                    this.getCOM();
                    continue block10;
                }
            }
            JPEGFileFormat.skipSegmentFrom(this.inputStream);
        }
        return null;
    }

    void quantizeData(int[] nArray, int n2) {
        int[] nArray2 = this.quantizationTables[this.frameComponents[this.componentIds[n2]][0]];
        int n3 = 0;
        while (n3 < nArray.length) {
            int n4 = ZigZag8x8[n3];
            int n5 = nArray[n4];
            int n6 = n5 < 0 ? 0 - n5 : n5;
            int n7 = nArray2[n3];
            int n8 = n7 >> 1;
            if ((n6 += n8) < n7) {
                nArray[n4] = 0;
            } else {
                n6 /= n7;
                nArray[n4] = n5 >= 0 ? n6 : 0 - n6;
            }
            ++n3;
        }
    }

    int receive(int n2) {
        int n3 = 0;
        int n4 = 0;
        while (n4 < n2) {
            n3 = n3 * 2 + this.nextBit();
            ++n4;
        }
        return n3;
    }

    void resetInputBuffer() {
        if (this.dataBuffer == null) {
            this.dataBuffer = new byte[512];
        }
        try {
            this.inputStream.read(this.dataBuffer);
        }
        catch (IOException iOException) {
            SWT.error(39, iOException);
        }
        this.currentBitCount = 0;
        this.bufferCurrentPosition = -1;
    }

    void resetOutputBuffer() {
        if (this.dataBuffer == null) {
            this.dataBuffer = new byte[512];
        } else {
            try {
                this.outputStream.write(this.dataBuffer, 0, this.bufferCurrentPosition);
            }
            catch (IOException iOException) {
                SWT.error(39, iOException);
            }
        }
        this.bufferCurrentPosition = 0;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    static JPEGSegment seekUnspecifiedMarker(LEDataInputStream lEDataInputStream) {
        byte[] byArray = new byte[2];
        try {
            while (true) {
                if (lEDataInputStream.read(byArray, 0, 1) != 1) {
                    return null;
                }
                if (byArray[0] != -1) continue;
                if (lEDataInputStream.read(byArray, 1, 1) != 1) {
                    return null;
                }
                if (byArray[1] != -1 && byArray[1] != 0) break;
            }
            lEDataInputStream.unread(byArray);
            return new JPEGSegment(byArray);
        }
        catch (IOException iOException) {
            SWT.error(39, iOException);
            return null;
        }
    }

    PaletteData setUpPalette() {
        if (this.nComponents == 1) {
            RGB[] rGBArray = new RGB[256];
            int n2 = 0;
            while (n2 < 256) {
                rGBArray[n2] = new RGB(n2, n2, n2);
                ++n2;
            }
            return new PaletteData(rGBArray);
        }
        return new PaletteData(255, 65280, 0xFF0000);
    }

    static void skipSegmentFrom(LEDataInputStream lEDataInputStream) {
        try {
            byte[] byArray = new byte[4];
            JPEGSegment jPEGSegment = new JPEGSegment(byArray);
            if (lEDataInputStream.read(byArray) != byArray.length) {
                SWT.error(40);
            }
            if (byArray[0] != -1 || byArray[1] == 0 || byArray[1] == -1) {
                SWT.error(40);
            }
            int n2 = jPEGSegment.getSegmentLength() - 2;
            lEDataInputStream.skip(n2);
        }
        catch (Exception exception) {
            SWT.error(39, exception);
        }
    }

    void storeData(int[] nArray, int n2, int n3, int n4, int n5, int n6, int n7, int n8) {
        byte[] byArray = this.imageComponents[n2];
        int[] nArray2 = this.frameComponents[this.componentIds[n2]];
        int n9 = nArray2[3];
        int n10 = (n4 * n7 + n8) * n9 * 8 + (n3 * n5 + n6) * 8;
        int n11 = 0;
        int n12 = 0;
        while (n12 < 8) {
            int n13 = 0;
            while (n13 < 8) {
                int n14 = nArray[n11] + 128;
                if (n14 < 0) {
                    n14 = 0;
                } else if (n14 > 255) {
                    n14 = 255;
                }
                byArray[n10 + n13] = (byte)n14;
                ++n11;
                ++n13;
            }
            n10 += n9;
            ++n12;
        }
    }

    void unloadIntoByteStream(ImageLoader imageLoader) {
        int n2;
        int n3;
        int[][] nArrayArray;
        int[][] nArrayArray2;
        ImageData imageData = imageLoader.data[0];
        if (!new JPEGStartOfImage().writeToStream(this.outputStream)) {
            SWT.error(39);
        }
        byte[] byArray = new byte[18];
        byArray[0] = -1;
        byArray[1] = -32;
        byArray[3] = 16;
        byArray[4] = 74;
        byArray[5] = 70;
        byArray[6] = 73;
        byArray[7] = 70;
        byArray[9] = 1;
        byArray[10] = 1;
        byArray[13] = 1;
        byArray[15] = 1;
        JPEGAppn jPEGAppn = new JPEGAppn(byArray);
        if (!jPEGAppn.writeToStream(this.outputStream)) {
            SWT.error(39);
        }
        this.quantizationTables = new int[4][];
        JPEGQuantizationTable jPEGQuantizationTable = JPEGQuantizationTable.defaultChrominanceTable();
        jPEGQuantizationTable.scaleBy(this.encoderQFactor);
        int[] nArray = jPEGQuantizationTable.getQuantizationTablesKeys();
        int[][] nArray2 = jPEGQuantizationTable.getQuantizationTablesValues();
        int n4 = 0;
        while (n4 < nArray.length) {
            this.quantizationTables[nArray[n4]] = nArray2[n4];
            ++n4;
        }
        JPEGQuantizationTable jPEGQuantizationTable2 = JPEGQuantizationTable.defaultLuminanceTable();
        jPEGQuantizationTable2.scaleBy(this.encoderQFactor);
        nArray = jPEGQuantizationTable2.getQuantizationTablesKeys();
        nArray2 = jPEGQuantizationTable2.getQuantizationTablesValues();
        int n5 = 0;
        while (n5 < nArray.length) {
            this.quantizationTables[nArray[n5]] = nArray2[n5];
            ++n5;
        }
        if (!jPEGQuantizationTable2.writeToStream(this.outputStream)) {
            SWT.error(39);
        }
        if (!jPEGQuantizationTable.writeToStream(this.outputStream)) {
            SWT.error(39);
        }
        if (imageData.depth == 1) {
            n5 = 11;
            nArrayArray2 = new int[1][];
            int[] nArray3 = new int[5];
            nArray3[0] = 1;
            nArray3[1] = 1;
            nArray3[2] = 1;
            nArrayArray2[0] = nArray3;
            nArrayArray = new int[][]{new int[2]};
            n3 = 8;
            this.nComponents = 1;
            n2 = 1;
        } else {
            n5 = 17;
            nArrayArray2 = new int[3][];
            int[] nArray4 = new int[5];
            nArray4[1] = 2;
            nArray4[2] = 2;
            nArrayArray2[0] = nArray4;
            int[] nArray5 = new int[5];
            nArray5[0] = 1;
            nArray5[1] = 1;
            nArray5[2] = 1;
            nArrayArray2[1] = nArray5;
            int[] nArray6 = new int[5];
            nArray6[0] = 1;
            nArray6[1] = 1;
            nArray6[2] = 1;
            nArrayArray2[2] = nArray6;
            nArrayArray = new int[][]{new int[2], {1, 1}, {1, 1}};
            n3 = 12;
            this.nComponents = 3;
            n2 = 8;
        }
        this.imageWidth = imageData.width;
        this.imageHeight = imageData.height;
        this.frameHeader = new JPEGFrameHeader(new byte[19]);
        this.frameHeader.setSegmentMarker(65472);
        this.frameHeader.setSegmentLength(n5);
        this.frameHeader.setSamplePrecision(n2);
        this.frameHeader.setSamplesPerLine(this.imageWidth);
        this.frameHeader.setNumberOfLines(this.imageHeight);
        this.frameHeader.setNumberOfImageComponents(this.nComponents);
        this.frameHeader.componentParameters = nArrayArray2;
        int[] nArray7 = new int[3];
        nArray7[1] = 1;
        nArray7[2] = 2;
        this.frameHeader.componentIdentifiers = nArray7;
        this.frameHeader.initializeContents();
        if (!this.frameHeader.writeToStream(this.outputStream)) {
            SWT.error(39);
        }
        this.frameComponents = nArrayArray2;
        this.componentIds = this.frameHeader.componentIdentifiers;
        this.maxH = this.frameHeader.getMaxHFactor();
        this.maxV = this.frameHeader.getMaxVFactor();
        int n6 = this.maxH * 8;
        int n7 = this.maxV * 8;
        this.interleavedMcuCols = (this.imageWidth + n6 - 1) / n6;
        this.interleavedMcuRows = (this.imageHeight + n7 - 1) / n7;
        this.acHuffmanTables = new JPEGHuffmanTable[4];
        this.dcHuffmanTables = new JPEGHuffmanTable[4];
        JPEGHuffmanTable[] jPEGHuffmanTableArray = new JPEGHuffmanTable[]{JPEGHuffmanTable.getDefaultDCLuminanceTable(), JPEGHuffmanTable.getDefaultDCChrominanceTable(), JPEGHuffmanTable.getDefaultACLuminanceTable(), JPEGHuffmanTable.getDefaultACChrominanceTable()};
        int n8 = 0;
        while (n8 < jPEGHuffmanTableArray.length) {
            JPEGHuffmanTable jPEGHuffmanTable = jPEGHuffmanTableArray[n8];
            if (!jPEGHuffmanTable.writeToStream(this.outputStream)) {
                SWT.error(39);
            }
            JPEGHuffmanTable[] jPEGHuffmanTableArray2 = jPEGHuffmanTable.getAllTables();
            int n9 = 0;
            while (n9 < jPEGHuffmanTableArray2.length) {
                JPEGHuffmanTable jPEGHuffmanTable2 = jPEGHuffmanTableArray2[n9];
                if (jPEGHuffmanTable2.getTableClass() == 0) {
                    this.dcHuffmanTables[jPEGHuffmanTable2.getTableIdentifier()] = jPEGHuffmanTable2;
                } else {
                    this.acHuffmanTables[jPEGHuffmanTable2.getTableIdentifier()] = jPEGHuffmanTable2;
                }
                ++n9;
            }
            ++n8;
        }
        this.precedingDCs = new int[4];
        this.scanHeader = new JPEGScanHeader(new byte[14]);
        this.scanHeader.setSegmentMarker(65498);
        this.scanHeader.setSegmentLength(n3);
        this.scanHeader.setNumberOfImageComponents(this.nComponents);
        this.scanHeader.setStartOfSpectralSelection(0);
        this.scanHeader.setEndOfSpectralSelection(63);
        this.scanHeader.componentParameters = nArrayArray;
        this.scanHeader.initializeContents();
        if (!this.scanHeader.writeToStream(this.outputStream)) {
            SWT.error(39);
        }
        this.convertImageToYCbCr(imageData);
        this.resetOutputBuffer();
        this.currentByte = 0;
        this.currentBitCount = 0;
        this.encodeScan();
        if (!new JPEGEndOfImage().writeToStream(this.outputStream)) {
            SWT.error(39);
        }
    }
}

