/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.swt.internal.image;

import java.io.IOException;
import org.eclipse.swt.SWT;
import org.eclipse.swt.graphics.ImageData;
import org.eclipse.swt.graphics.ImageLoader;
import org.eclipse.swt.graphics.ImageLoaderEvent;
import org.eclipse.swt.graphics.PaletteData;
import org.eclipse.swt.graphics.RGB;
import org.eclipse.swt.internal.image.LEDataOutputStream;
import org.eclipse.swt.internal.image.TIFFModifiedHuffmanCodec;
import org.eclipse.swt.internal.image.TIFFRandomFileAccess;

final class TIFFDirectory {
    TIFFRandomFileAccess file;
    boolean isLittleEndian;
    ImageLoader loader;
    int depth;
    int imageWidth;
    int imageLength;
    int[] bitsPerSample;
    int compression;
    int photometricInterpretation;
    int[] stripOffsets;
    int samplesPerPixel;
    int rowsPerStrip;
    int[] stripByteCounts;
    int t4Options;
    int colorMapOffset;
    ImageData image;
    LEDataOutputStream out;
    static final int NO_VALUE = -1;
    static final short TAG_ImageWidth = 256;
    static final short TAG_ImageLength = 257;
    static final short TAG_BitsPerSample = 258;
    static final short TAG_Compression = 259;
    static final short TAG_PhotometricInterpretation = 262;
    static final short TAG_StripOffsets = 273;
    static final short TAG_SamplesPerPixel = 277;
    static final short TAG_RowsPerStrip = 278;
    static final short TAG_StripByteCounts = 279;
    static final short TAG_XResolution = 282;
    static final short TAG_YResolution = 283;
    static final short TAG_T4Options = 292;
    static final short TAG_ResolutionUnit = 296;
    static final short TAG_ColorMap = 320;
    static final int TYPE_BYTE = 1;
    static final int TYPE_ASCII = 2;
    static final int TYPE_SHORT = 3;
    static final int TYPE_LONG = 4;
    static final int TYPE_RATIONAL = 5;
    static final int COMPRESSION_NONE = 1;
    static final int COMPRESSION_CCITT_3_1 = 2;
    static final int COMPRESSION_PACKBITS = 32773;
    static final int IFD_ENTRY_SIZE = 12;

    public TIFFDirectory(TIFFRandomFileAccess tIFFRandomFileAccess, boolean bl2, ImageLoader imageLoader) {
        this.file = tIFFRandomFileAccess;
        this.isLittleEndian = bl2;
        this.loader = imageLoader;
    }

    public TIFFDirectory(ImageData imageData) {
        this.image = imageData;
    }

    int decodePackBits(byte[] byArray, byte[] byArray2, int n2) {
        int n3 = n2;
        int n4 = 0;
        while (n4 < byArray.length) {
            byte by2 = byArray[n4];
            if (by2 >= 0 && by2 <= 127) {
                System.arraycopy(byArray, ++n4, byArray2, n3, by2 + 1);
                n4 += by2 + 1;
                n3 += by2 + 1;
                continue;
            }
            if (-127 <= by2 && by2 <= -1) {
                byte by3 = byArray[++n4];
                int n5 = 0;
                while (n5 < -by2 + 1) {
                    byArray2[n3++] = by3;
                    ++n5;
                }
                ++n4;
                continue;
            }
            ++n4;
        }
        return n3 - n2;
    }

    int getEntryValue(int n2, byte[] byArray, int n3) {
        return this.toInt(byArray, n3 + 8, n2);
    }

    void getEntryValue(int n2, byte[] byArray, int n3, int[] nArray) throws IOException {
        int n4;
        int n5 = n3 + 8;
        int n6 = this.toInt(byArray, n5, 4);
        switch (n2) {
            case 3: {
                n4 = 2;
                break;
            }
            case 4: {
                n4 = 4;
                break;
            }
            case 5: {
                n4 = 8;
                break;
            }
            case 1: 
            case 2: {
                n4 = 1;
                break;
            }
            default: {
                SWT.error(42);
                return;
            }
        }
        if (nArray.length * n4 > 4) {
            byArray = new byte[nArray.length * n4];
            this.file.seek(n6);
            this.file.read(byArray);
            n5 = 0;
        }
        int n7 = 0;
        while (n7 < nArray.length) {
            nArray[n7] = this.toInt(byArray, n5 + n7 * n4, n2);
            ++n7;
        }
    }

    void decodePixels(ImageData imageData) throws IOException {
        byte[] byArray = new byte[(this.imageWidth * this.depth + 7) / 8 * this.imageLength];
        imageData.data = byArray;
        int n2 = 0;
        int n3 = this.stripOffsets.length;
        int n4 = 0;
        while (n4 < n3) {
            byte[] byArray2 = new byte[this.stripByteCounts[n4]];
            this.file.seek(this.stripOffsets[n4]);
            this.file.read(byArray2);
            if (this.compression == 1) {
                System.arraycopy(byArray2, 0, byArray, n2, byArray2.length);
                n2 += byArray2.length;
            } else if (this.compression == 32773) {
                n2 += this.decodePackBits(byArray2, byArray, n2);
            } else if (this.compression == 2 || this.compression == 3) {
                int n5;
                TIFFModifiedHuffmanCodec tIFFModifiedHuffmanCodec = new TIFFModifiedHuffmanCodec();
                int n6 = this.rowsPerStrip;
                if (n4 == n3 - 1 && (n5 = this.imageLength % this.rowsPerStrip) != 0) {
                    n6 = n5;
                }
                n2 += tIFFModifiedHuffmanCodec.decode(byArray2, byArray, n2, this.imageWidth, n6);
            }
            if (this.loader.hasListeners()) {
                this.loader.notifyListeners(new ImageLoaderEvent(this.loader, imageData, n4, n4 == n3 - 1));
            }
            ++n4;
        }
    }

    PaletteData getColorMap() throws IOException {
        int n2 = 1 << this.bitsPerSample[0];
        int n3 = 6 * n2;
        byte[] byArray = new byte[n3];
        this.file.seek(this.colorMapOffset);
        this.file.read(byArray);
        RGB[] rGBArray = new RGB[n2];
        int n4 = this.isLittleEndian ? 1 : 0;
        int n5 = 2 * n2;
        int n6 = n5 + 2 * n2;
        int n7 = 0;
        while (n7 < n2) {
            int n8 = byArray[n4] & 0xFF;
            int n9 = byArray[n5 + n4] & 0xFF;
            int n10 = byArray[n6 + n4] & 0xFF;
            rGBArray[n7] = new RGB(n8, n9, n10);
            n4 += 2;
            ++n7;
        }
        return new PaletteData(rGBArray);
    }

    PaletteData getGrayPalette() {
        int n2 = 1 << this.bitsPerSample[0];
        RGB[] rGBArray = new RGB[n2];
        int n3 = 0;
        while (n3 < n2) {
            int n4 = n3 * 255 / (n2 - 1);
            if (this.photometricInterpretation == 0) {
                n4 = 255 - n4;
            }
            rGBArray[n3] = new RGB(n4, n4, n4);
            ++n3;
        }
        return new PaletteData(rGBArray);
    }

    PaletteData getRGBPalette(int n2, int n3, int n4) {
        int n5 = 0;
        int n6 = 0;
        while (n6 < n4) {
            n5 |= 1 << n6;
            ++n6;
        }
        n6 = 0;
        int n7 = n4;
        while (n7 < n4 + n3) {
            n6 |= 1 << n7;
            ++n7;
        }
        n7 = 0;
        int n8 = n4 + n3;
        while (n8 < n4 + n3 + n2) {
            n7 |= 1 << n8;
            ++n8;
        }
        return new PaletteData(n7, n6, n5);
    }

    int formatStrips(int n2, int n3, byte[] byArray, int n4, int n5, int n6, int[][] nArray) {
        int n7;
        int n8;
        int n9;
        int n10;
        if (n2 > n4) {
            n10 = byArray.length / n2;
            n9 = 1;
        } else {
            n8 = (byArray.length + n4 - 1) / n4;
            n9 = n3 / n8;
            n10 = (n3 + n9 - 1) / n9;
        }
        n8 = n2 * n9;
        int[] nArray2 = new int[n10];
        int[] nArray3 = new int[n10];
        int n11 = n10 == 1 ? 0 : n10 * 2 * 4;
        int n12 = n7 = n5 + n6 + n11;
        int n13 = 0;
        while (n13 < n10) {
            nArray2[n13] = n12;
            nArray3[n13] = n8;
            n12 += n8;
            ++n13;
        }
        n13 = byArray.length % n8;
        if (n13 != 0) {
            nArray3[nArray3.length - 1] = n13;
        }
        nArray[0] = nArray2;
        nArray[1] = nArray3;
        return n9;
    }

    int[] formatColorMap(RGB[] rGBArray) {
        int[] nArray = new int[rGBArray.length * 3];
        int n2 = rGBArray.length;
        int n3 = rGBArray.length * 2;
        int n4 = 0;
        while (n4 < rGBArray.length) {
            nArray[n4] = rGBArray[n4].red << 8 | rGBArray[n4].red;
            nArray[n4 + n2] = rGBArray[n4].green << 8 | rGBArray[n4].green;
            nArray[n4 + n3] = rGBArray[n4].blue << 8 | rGBArray[n4].blue;
            ++n4;
        }
        return nArray;
    }

    void parseEntries(byte[] byArray) throws IOException {
        int n2 = 0;
        while (n2 < byArray.length) {
            int n3 = this.toInt(byArray, n2, 3);
            int n4 = this.toInt(byArray, n2 + 2, 3);
            int n5 = this.toInt(byArray, n2 + 4, 4);
            switch (n3) {
                case 256: {
                    this.imageWidth = this.getEntryValue(n4, byArray, n2);
                    break;
                }
                case 257: {
                    this.imageLength = this.getEntryValue(n4, byArray, n2);
                    break;
                }
                case 258: {
                    if (n4 != 3) {
                        SWT.error(40);
                    }
                    this.bitsPerSample = new int[n5];
                    this.getEntryValue(n4, byArray, n2, this.bitsPerSample);
                    break;
                }
                case 259: {
                    this.compression = this.getEntryValue(n4, byArray, n2);
                    break;
                }
                case 262: {
                    this.photometricInterpretation = this.getEntryValue(n4, byArray, n2);
                    break;
                }
                case 273: {
                    if (n4 != 4 && n4 != 3) {
                        SWT.error(40);
                    }
                    this.stripOffsets = new int[n5];
                    this.getEntryValue(n4, byArray, n2, this.stripOffsets);
                    break;
                }
                case 277: {
                    if (n4 != 3) {
                        SWT.error(40);
                    }
                    this.samplesPerPixel = this.getEntryValue(n4, byArray, n2);
                    if (this.samplesPerPixel == 1 || this.samplesPerPixel == 3) break;
                    SWT.error(38);
                    break;
                }
                case 278: {
                    this.rowsPerStrip = this.getEntryValue(n4, byArray, n2);
                    break;
                }
                case 279: {
                    this.stripByteCounts = new int[n5];
                    this.getEntryValue(n4, byArray, n2, this.stripByteCounts);
                    break;
                }
                case 282: {
                    break;
                }
                case 283: {
                    break;
                }
                case 292: {
                    if (n4 != 4) {
                        SWT.error(40);
                    }
                    this.t4Options = this.getEntryValue(n4, byArray, n2);
                    if ((this.t4Options & 1) != 1) break;
                    SWT.error(42);
                    break;
                }
                case 296: {
                    break;
                }
                case 320: {
                    if (n4 != 3) {
                        SWT.error(40);
                    }
                    this.colorMapOffset = this.getEntryValue(4, byArray, n2);
                }
            }
            n2 += 12;
        }
    }

    public ImageData read() throws IOException {
        this.bitsPerSample = new int[]{1};
        this.colorMapOffset = -1;
        this.compression = 1;
        this.imageLength = -1;
        this.imageWidth = -1;
        this.photometricInterpretation = -1;
        this.rowsPerStrip = Integer.MAX_VALUE;
        this.samplesPerPixel = 1;
        this.stripByteCounts = null;
        this.stripOffsets = null;
        byte[] byArray = new byte[2];
        this.file.read(byArray);
        int n2 = this.toInt(byArray, 0, 3);
        byArray = new byte[12 * n2];
        this.file.read(byArray);
        this.parseEntries(byArray);
        PaletteData paletteData = null;
        this.depth = 0;
        switch (this.photometricInterpretation) {
            case 0: 
            case 1: {
                paletteData = this.getGrayPalette();
                this.depth = this.bitsPerSample[0];
                break;
            }
            case 2: {
                if (this.colorMapOffset != -1) {
                    SWT.error(40);
                }
                paletteData = this.getRGBPalette(this.bitsPerSample[0], this.bitsPerSample[1], this.bitsPerSample[2]);
                this.depth = this.bitsPerSample[0] + this.bitsPerSample[1] + this.bitsPerSample[2];
                break;
            }
            case 3: {
                if (this.colorMapOffset == -1) {
                    SWT.error(40);
                }
                paletteData = this.getColorMap();
                this.depth = this.bitsPerSample[0];
                break;
            }
            default: {
                SWT.error(40);
            }
        }
        ImageData imageData = ImageData.internal_new(this.imageWidth, this.imageLength, this.depth, paletteData, 1, null, 0, null, null, -1, -1, 6, 0, 0, 0, 0);
        this.decodePixels(imageData);
        return imageData;
    }

    int toInt(byte[] byArray, int n2, int n3) {
        if (n3 == 4) {
            return this.isLittleEndian ? byArray[n2] & 0xFF | (byArray[n2 + 1] & 0xFF) << 8 | (byArray[n2 + 2] & 0xFF) << 16 | (byArray[n2 + 3] & 0xFF) << 24 : byArray[n2 + 3] & 0xFF | (byArray[n2 + 2] & 0xFF) << 8 | (byArray[n2 + 1] & 0xFF) << 16 | (byArray[n2] & 0xFF) << 24;
        }
        if (n3 == 3) {
            return this.isLittleEndian ? byArray[n2] & 0xFF | (byArray[n2 + 1] & 0xFF) << 8 : byArray[n2 + 1] & 0xFF | (byArray[n2] & 0xFF) << 8;
        }
        SWT.error(40);
        return -1;
    }

    void write(int n2) throws IOException {
        int n3;
        Object object;
        Object object2;
        boolean bl2 = n2 == 2;
        boolean bl3 = n2 == 3;
        boolean bl4 = n2 == 0 || n2 == 1;
        int n4 = this.image.width;
        int n5 = this.image.height;
        int n6 = this.image.bytesPerLine;
        int n7 = bl4 ? 9 : 11;
        int n8 = 2 + 12 * n7 + 4;
        int n9 = 8 + n8;
        int n10 = 16;
        int[] nArray = null;
        if (bl3) {
            object2 = this.image.palette;
            object = ((PaletteData)object2).getRGBs();
            nArray = this.formatColorMap((RGB[])object);
            if (nArray.length != 3 << this.image.depth) {
                SWT.error(42);
            }
            n10 += nArray.length * 2;
        }
        if (bl2) {
            n10 += 6;
        }
        object2 = this.image.data;
        object = new int[2][];
        int n11 = this.formatStrips(n6, n5, (byte[])object2, 8192, n9, n10, (int[][])object);
        RGB rGB = object[0];
        RGB rGB2 = object[1];
        int n12 = -1;
        if (bl2) {
            n12 = n9;
            n9 += 6;
        }
        int n13 = -1;
        int n14 = -1;
        int n15 = -1;
        int n16 = ((RGB)rGB).length;
        if (n16 > 1) {
            n13 = n9;
            n14 = n9 += 4 * n16;
            n9 += 4 * n16;
        }
        int n17 = n9;
        int n18 = n9 += 8;
        n9 += 8;
        if (bl3) {
            n15 = n9;
            n9 += nArray.length * 2;
        }
        this.writeHeader();
        this.out.writeShort(n7);
        this.writeEntry((short)256, 4, 1, n4);
        this.writeEntry((short)257, 4, 1, n5);
        if (bl3) {
            this.writeEntry((short)258, 3, 1, this.image.depth);
        }
        if (bl2) {
            this.writeEntry((short)258, 3, 3, n12);
        }
        this.writeEntry((short)259, 3, 1, 1);
        this.writeEntry((short)262, 3, 1, n2);
        this.writeEntry((short)273, 4, n16, n16 > 1 ? n13 : (int)rGB[0]);
        if (bl2) {
            this.writeEntry((short)277, 3, 1, 3);
        }
        this.writeEntry((short)278, 4, 1, n11);
        this.writeEntry((short)279, 4, n16, n16 > 1 ? n14 : (int)rGB2[0]);
        this.writeEntry((short)282, 5, 1, n17);
        this.writeEntry((short)283, 5, 1, n18);
        if (bl3) {
            this.writeEntry((short)320, 3, nArray.length, n15);
        }
        this.out.writeInt(0);
        if (bl2) {
            n3 = 0;
            while (n3 < 3) {
                this.out.writeShort(8);
                ++n3;
            }
        }
        if (n16 > 1) {
            n3 = 0;
            while (n3 < n16) {
                this.out.writeInt((int)rGB[n3]);
                ++n3;
            }
            n3 = 0;
            while (n3 < n16) {
                this.out.writeInt((int)rGB2[n3]);
                ++n3;
            }
        }
        n3 = 0;
        while (n3 < 2) {
            this.out.writeInt(300);
            this.out.writeInt(1);
            ++n3;
        }
        if (bl3) {
            n3 = 0;
            while (n3 < nArray.length) {
                this.out.writeShort(nArray[n3]);
                ++n3;
            }
        }
        this.out.write((byte[])object2);
    }

    void writeEntry(short s2, int n2, int n3, int n4) throws IOException {
        this.out.writeShort(s2);
        this.out.writeShort(n2);
        this.out.writeInt(n3);
        this.out.writeInt(n4);
    }

    void writeHeader() throws IOException {
        this.out.write(73);
        this.out.write(73);
        this.out.writeShort(42);
        this.out.writeInt(8);
    }

    void writeToStream(LEDataOutputStream lEDataOutputStream) throws IOException {
        this.out = lEDataOutputStream;
        int n2 = -1;
        if (this.image.scanlinePad != 1) {
            SWT.error(42);
        }
        switch (this.image.depth) {
            case 1: {
                PaletteData paletteData = this.image.palette;
                RGB[] rGBArray = paletteData.colors;
                if (paletteData.isDirect || rGBArray == null || rGBArray.length != 2) {
                    SWT.error(42);
                }
                RGB rGB = rGBArray[0];
                RGB rGB2 = rGBArray[1];
                if (rGB.red != rGB.green || rGB.green != rGB.blue || rGB2.red != rGB2.green || rGB2.green != rGB2.blue || (rGB.red != 0 || rGB2.red != 255) && (rGB.red != 255 || rGB2.red != 0)) {
                    SWT.error(42);
                }
                n2 = this.image.palette.colors[0].red == 255 ? 0 : 1;
                break;
            }
            case 4: 
            case 8: {
                n2 = 3;
                break;
            }
            case 24: {
                n2 = 2;
                break;
            }
            default: {
                SWT.error(42);
            }
        }
        this.write(n2);
    }
}

