/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.swt.widgets;

import org.eclipse.swt.SWT;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Cursor;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.DeviceData;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.GCData;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.ImageData;
import org.eclipse.swt.graphics.PaletteData;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.RGB;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.graphics.Resource;
import org.eclipse.swt.internal.Callback;
import org.eclipse.swt.internal.ImageList;
import org.eclipse.swt.internal.win32.BITMAP;
import org.eclipse.swt.internal.win32.BITMAPINFOHEADER;
import org.eclipse.swt.internal.win32.HIGHCONTRAST;
import org.eclipse.swt.internal.win32.ICONINFO;
import org.eclipse.swt.internal.win32.INPUT;
import org.eclipse.swt.internal.win32.KEYBDINPUT;
import org.eclipse.swt.internal.win32.LOGFONT;
import org.eclipse.swt.internal.win32.LOGFONTA;
import org.eclipse.swt.internal.win32.LOGFONTW;
import org.eclipse.swt.internal.win32.MONITORINFO;
import org.eclipse.swt.internal.win32.MOUSEINPUT;
import org.eclipse.swt.internal.win32.MSG;
import org.eclipse.swt.internal.win32.NONCLIENTMETRICS;
import org.eclipse.swt.internal.win32.NONCLIENTMETRICSA;
import org.eclipse.swt.internal.win32.NONCLIENTMETRICSW;
import org.eclipse.swt.internal.win32.OS;
import org.eclipse.swt.internal.win32.POINT;
import org.eclipse.swt.internal.win32.RECT;
import org.eclipse.swt.internal.win32.STARTUPINFO;
import org.eclipse.swt.internal.win32.TCHAR;
import org.eclipse.swt.internal.win32.WNDCLASS;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.EventTable;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.MenuItem;
import org.eclipse.swt.widgets.Monitor;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Synchronizer;
import org.eclipse.swt.widgets.Tray;
import org.eclipse.swt.widgets.TrayItem;
import org.eclipse.swt.widgets.Widget;

public class Display
extends Device {
    public MSG msg = new MSG();
    Event[] eventQueue;
    Callback windowCallback;
    int windowProc;
    int threadId;
    TCHAR windowClass;
    TCHAR windowShadowClass;
    static int WindowClassCount;
    static final String WindowName = "SWT_Window";
    static final String WindowShadowName = "SWT_WindowShadow";
    EventTable eventTable;
    EventTable filterTable;
    int[] indexTable;
    Control lastControl;
    Control lastGetControl;
    int freeSlot;
    int lastHwnd;
    int lastGetHwnd;
    Control[] controlTable;
    static final int GROW_SIZE = 1024;
    static final int SWT_OBJECT_INDEX;
    static final boolean USE_PROPERTY;
    static STARTUPINFO lpStartupInfo;
    int hButtonTheme;
    int hEditTheme;
    int hExplorerBarTheme;
    int hScrollBarTheme;
    int hTabTheme;
    static final char[] BUTTON;
    static final char[] EDIT;
    static final char[] EXPLORER;
    static final char[] EXPLORERBAR;
    static final char[] SCROLLBAR;
    static final char[] LISTVIEW;
    static final char[] TAB;
    static final char[] TREEVIEW;
    int focusEvent;
    Control focusControl;
    Menu[] bars;
    Menu[] popups;
    MenuItem[] items;
    static final int ID_START = 108;
    Callback msgFilterCallback;
    int msgFilterProc;
    int filterHook;
    MSG hookMsg = new MSG();
    boolean runDragDrop = true;
    Callback foregroundIdleCallback;
    int foregroundIdleProc;
    int idleHook;
    boolean ignoreNextKey;
    Callback getMsgCallback;
    Callback embeddedCallback;
    int getMsgProc;
    int msgHook;
    int embeddedHwnd;
    int embeddedProc;
    static final String AWT_WINDOW_CLASS = "SunAwtWindow";
    static final short[] ACCENTS;
    Synchronizer synchronizer = new Synchronizer(this);
    boolean runMessages = true;
    boolean runMessagesInIdle = false;
    static final String RUN_MESSAGES_IN_IDLE_KEY = "org.eclipse.swt.internal.win32.runMessagesInIdle";
    Thread thread;
    Runnable[] disposeList;
    Tray tray;
    int nextTrayId;
    int[] timerIds;
    Runnable[] timerList;
    int nextTimerId = 101;
    static final int SETTINGS_ID = 100;
    static final int SETTINGS_DELAY = 2000;
    RECT clickRect;
    int clickCount;
    int lastTime;
    int lastButton;
    int lastClickHwnd;
    int lastKey;
    int lastAscii;
    int lastMouse;
    boolean lastVirtual;
    boolean lastNull;
    boolean lastDead;
    byte[] keyboard = new byte[256];
    boolean accelKeyHit;
    boolean mnemonicKeyHit;
    boolean lockActiveWindow;
    boolean captureChanged;
    boolean xMouse;
    int nextToolTipId;
    boolean ignoreRestoreFocus;
    Control lastHittestControl;
    int lastHittest;
    Callback messageCallback;
    int hwndMessage;
    int messageProc;
    LOGFONT lfSystemFont;
    Font systemFont;
    Image errorImage;
    Image infoImage;
    Image questionImage;
    Image warningIcon;
    Cursor[] cursors = new Cursor[22];
    Resource[] resources;
    static final int RESOURCE_SIZE = 27;
    ImageList[] imageList;
    ImageList[] toolImageList;
    ImageList[] toolHotImageList;
    ImageList[] toolDisabledImageList;
    int lpCustColors;
    Image upArrow;
    Image downArrow;
    char[] tableBuffer;
    Object data;
    String[] keys;
    Object[] values;
    static final int[][] KeyTable;
    static Display Default;
    static Display[] Displays;
    Monitor[] monitors = null;
    int monitorCount = 0;
    Shell[] modalShells;
    Shell modalDialogShell;
    static boolean TrimEnabled;
    static final int SWT_GETACCELCOUNT = 32768;
    static final int SWT_GETACCEL = 32769;
    static final int SWT_KEYMSG = 32770;
    static final int SWT_DESTROY = 32771;
    static final int SWT_TRAYICONMSG = 32772;
    static final int SWT_NULL = 32773;
    static final int SWT_RUNASYNC = 32774;
    static int SWT_TASKBARCREATED;
    static int SWT_RESTORECARET;
    int hitCount;
    static final String PACKAGE_PREFIX = "org.eclipse.swt.widgets.";

    static {
        USE_PROPERTY = !OS.IsWinCE;
        SWT_OBJECT_INDEX = USE_PROPERTY ? OS.GlobalAddAtom(new TCHAR(0, "SWT_OBJECT_INDEX", true)) : 0;
        if (!OS.IsWinCE) {
            lpStartupInfo = new STARTUPINFO();
            Display.lpStartupInfo.cb = STARTUPINFO.sizeof;
            OS.GetStartupInfo(lpStartupInfo);
        }
        char[] cArray = new char[7];
        cArray[0] = 66;
        cArray[1] = 85;
        cArray[2] = 84;
        cArray[3] = 84;
        cArray[4] = 79;
        cArray[5] = 78;
        BUTTON = cArray;
        char[] cArray2 = new char[5];
        cArray2[0] = 69;
        cArray2[1] = 68;
        cArray2[2] = 73;
        cArray2[3] = 84;
        EDIT = cArray2;
        char[] cArray3 = new char[9];
        cArray3[0] = 69;
        cArray3[1] = 88;
        cArray3[2] = 80;
        cArray3[3] = 76;
        cArray3[4] = 79;
        cArray3[5] = 82;
        cArray3[6] = 69;
        cArray3[7] = 82;
        EXPLORER = cArray3;
        char[] cArray4 = new char[12];
        cArray4[0] = 69;
        cArray4[1] = 88;
        cArray4[2] = 80;
        cArray4[3] = 76;
        cArray4[4] = 79;
        cArray4[5] = 82;
        cArray4[6] = 69;
        cArray4[7] = 82;
        cArray4[8] = 66;
        cArray4[9] = 65;
        cArray4[10] = 82;
        EXPLORERBAR = cArray4;
        char[] cArray5 = new char[10];
        cArray5[0] = 83;
        cArray5[1] = 67;
        cArray5[2] = 82;
        cArray5[3] = 79;
        cArray5[4] = 76;
        cArray5[5] = 76;
        cArray5[6] = 66;
        cArray5[7] = 65;
        cArray5[8] = 82;
        SCROLLBAR = cArray5;
        char[] cArray6 = new char[9];
        cArray6[0] = 76;
        cArray6[1] = 73;
        cArray6[2] = 83;
        cArray6[3] = 84;
        cArray6[4] = 86;
        cArray6[5] = 73;
        cArray6[6] = 69;
        cArray6[7] = 87;
        LISTVIEW = cArray6;
        char[] cArray7 = new char[4];
        cArray7[0] = 84;
        cArray7[1] = 65;
        cArray7[2] = 66;
        TAB = cArray7;
        char[] cArray8 = new char[9];
        cArray8[0] = 84;
        cArray8[1] = 82;
        cArray8[2] = 69;
        cArray8[3] = 69;
        cArray8[4] = 86;
        cArray8[5] = 73;
        cArray8[6] = 69;
        cArray8[7] = 87;
        TREEVIEW = cArray8;
        ACCENTS = new short[]{126, 96, 39, 94, 34};
        KeyTable = new int[][]{{18, 65536}, {16, 131072}, {17, 262144}, {38, 0x1000001}, {40, 0x1000002}, {37, 0x1000003}, {39, 0x1000004}, {33, 0x1000005}, {34, 0x1000006}, {36, 0x1000007}, {35, 0x1000008}, {45, 0x1000009}, {8, 8}, {13, 13}, {46, 127}, {27, 27}, {13, 10}, {9, 9}, {112, 0x100000A}, {113, 0x100000B}, {114, 0x100000C}, {115, 0x100000D}, {116, 0x100000E}, {117, 0x100000F}, {118, 0x1000010}, {119, 0x1000011}, {120, 0x1000012}, {121, 0x1000013}, {122, 0x1000014}, {123, 0x1000015}, {124, 0x1000016}, {125, 0x1000017}, {126, 0x1000018}, {106, 16777258}, {107, 16777259}, {13, 0x1000050}, {109, 16777261}, {110, 16777262}, {111, 16777263}, {96, 0x1000030}, {97, 0x1000031}, {98, 16777266}, {99, 0x1000033}, {100, 16777268}, {101, 16777269}, {102, 16777270}, {103, 16777271}, {104, 16777272}, {105, 16777273}, {20, 16777298}, {144, 16777299}, {145, 16777300}, {19, 0x1000055}, {3, 16777302}, {44, 16777303}};
        Displays = new Display[4];
        TrimEnabled = false;
        DeviceFinder = new Runnable(){

            public void run() {
                Display display = Display.getCurrent();
                if (display == null) {
                    display = Display.getDefault();
                }
                Display.setDevice(display);
            }
        };
    }

    static void setDevice(Device device) {
        CurrentDevice = device;
    }

    public Display() {
        this(null);
    }

    public Display(DeviceData deviceData) {
        super(deviceData);
    }

    Control _getFocusControl() {
        return this.findControl(OS.GetFocus());
    }

    void addBar(Menu menu) {
        if (this.bars == null) {
            this.bars = new Menu[4];
        }
        int n2 = this.bars.length;
        int n3 = 0;
        while (n3 < n2) {
            if (this.bars[n3] == menu) {
                return;
            }
            ++n3;
        }
        n3 = 0;
        while (n3 < n2) {
            if (this.bars[n3] == null) break;
            ++n3;
        }
        if (n3 == n2) {
            Menu[] menuArray = new Menu[n2 + 4];
            System.arraycopy(this.bars, 0, menuArray, 0, n2);
            this.bars = menuArray;
        }
        this.bars[n3] = menu;
    }

    void addControl(int n2, Control control) {
        int n3;
        if (n2 == 0) {
            return;
        }
        if (this.freeSlot == -1) {
            this.freeSlot = this.indexTable.length;
            n3 = this.freeSlot + 1024;
            int[] nArray = new int[n3];
            Control[] controlArray = new Control[n3];
            System.arraycopy(this.indexTable, 0, nArray, 0, this.freeSlot);
            System.arraycopy(this.controlTable, 0, controlArray, 0, this.freeSlot);
            int n4 = this.freeSlot;
            while (n4 < n3 - 1) {
                nArray[n4] = n4 + 1;
                ++n4;
            }
            nArray[n3 - 1] = -1;
            this.indexTable = nArray;
            this.controlTable = controlArray;
        }
        if (USE_PROPERTY) {
            OS.SetProp(n2, SWT_OBJECT_INDEX, this.freeSlot + 1);
        } else {
            OS.SetWindowLong(n2, -21, this.freeSlot + 1);
        }
        n3 = this.freeSlot;
        this.freeSlot = this.indexTable[n3];
        this.indexTable[n3] = -2;
        this.controlTable[n3] = control;
    }

    public void addFilter(int n2, Listener listener) {
        this.checkDevice();
        if (listener == null) {
            this.error(4);
        }
        if (this.filterTable == null) {
            this.filterTable = new EventTable();
        }
        this.filterTable.hook(n2, listener);
    }

    public void addListener(int n2, Listener listener) {
        this.checkDevice();
        if (listener == null) {
            this.error(4);
        }
        if (this.eventTable == null) {
            this.eventTable = new EventTable();
        }
        this.eventTable.hook(n2, listener);
    }

    void addMenuItem(MenuItem menuItem) {
        if (this.items == null) {
            this.items = new MenuItem[64];
        }
        int n2 = 0;
        while (n2 < this.items.length) {
            if (this.items[n2] == null) {
                menuItem.id = n2 + 108;
                this.items[n2] = menuItem;
                return;
            }
            ++n2;
        }
        menuItem.id = this.items.length + 108;
        MenuItem[] menuItemArray = new MenuItem[this.items.length + 64];
        menuItemArray[this.items.length] = menuItem;
        System.arraycopy(this.items, 0, menuItemArray, 0, this.items.length);
        this.items = menuItemArray;
    }

    void addPopup(Menu menu) {
        if (this.popups == null) {
            this.popups = new Menu[4];
        }
        int n2 = this.popups.length;
        int n3 = 0;
        while (n3 < n2) {
            if (this.popups[n3] == menu) {
                return;
            }
            ++n3;
        }
        n3 = 0;
        while (n3 < n2) {
            if (this.popups[n3] == null) break;
            ++n3;
        }
        if (n3 == n2) {
            Menu[] menuArray = new Menu[n2 + 4];
            System.arraycopy(this.popups, 0, menuArray, 0, n2);
            this.popups = menuArray;
        }
        this.popups[n3] = menu;
    }

    int asciiKey(int n2) {
        if (OS.IsWinCE) {
            return 0;
        }
        int n3 = 0;
        while (n3 < this.keyboard.length) {
            this.keyboard[n3] = 0;
            ++n3;
        }
        if (!OS.GetKeyboardState(this.keyboard)) {
            return 0;
        }
        if (OS.IsUnicode) {
            char[] cArray = new char[1];
            if (OS.ToUnicode(n2, n2, this.keyboard, cArray, 1, 0) == 1) {
                return cArray[0];
            }
        } else {
            short[] sArray = new short[1];
            if (OS.ToAscii(n2, n2, this.keyboard, sArray, 0) == 1) {
                return sArray[0];
            }
        }
        return 0;
    }

    public void asyncExec(Runnable runnable) {
        if (this.isDisposed()) {
            this.error(45);
        }
        this.synchronizer.asyncExec(runnable);
    }

    public void beep() {
        this.checkDevice();
        OS.MessageBeep(0);
    }

    protected void checkSubclass() {
        if (!Display.isValidClass(this.getClass())) {
            this.error(43);
        }
    }

    protected void checkDevice() {
        if (this.thread == null) {
            this.error(24);
        }
        if (this.thread != Thread.currentThread()) {
            this.error(22);
        }
        if (this.isDisposed()) {
            this.error(45);
        }
    }

    static synchronized void checkDisplay(Thread thread, boolean bl2) {
        int n2 = 0;
        while (n2 < Displays.length) {
            if (Displays[n2] != null) {
                if (!bl2) {
                    SWT.error(20, null, " [multiple displays]");
                }
                if (Display.Displays[n2].thread == thread) {
                    SWT.error(22);
                }
            }
            ++n2;
        }
    }

    void clearModal(Shell shell) {
        if (this.modalShells == null) {
            return;
        }
        int n2 = 0;
        int n3 = this.modalShells.length;
        while (n2 < n3) {
            if (this.modalShells[n2] == shell) break;
            if (this.modalShells[n2] == null) {
                return;
            }
            ++n2;
        }
        if (n2 == n3) {
            return;
        }
        System.arraycopy(this.modalShells, n2 + 1, this.modalShells, n2, --n3 - n2);
        this.modalShells[n3] = null;
        if (n2 == 0 && this.modalShells[0] == null) {
            this.modalShells = null;
        }
        Shell[] shellArray = this.getShells();
        int n4 = 0;
        while (n4 < shellArray.length) {
            shellArray[n4].updateModal();
            ++n4;
        }
    }

    int controlKey(int n2) {
        short s2 = OS.CharUpper((short)n2);
        if (64 <= s2 && s2 <= 95) {
            return s2 & 0xBF;
        }
        return n2;
    }

    public void close() {
        this.checkDevice();
        Event event = new Event();
        this.sendEvent(21, event);
        if (event.doit) {
            this.dispose();
        }
    }

    protected void create(DeviceData deviceData) {
        this.checkSubclass();
        this.thread = Thread.currentThread();
        Display.checkDisplay(this.thread, true);
        this.createDisplay(deviceData);
        Display.register(this);
        if (Default == null) {
            Default = this;
        }
    }

    void createDisplay(DeviceData deviceData) {
    }

    static int create32bitDIB(Image image) {
        byte[] byArray;
        Object object;
        int n2 = -1;
        int n3 = -1;
        int n4 = 0;
        int n5 = 0;
        byte[] byArray2 = null;
        switch (image.type) {
            case 1: {
                object = new ICONINFO();
                OS.GetIconInfo(image.handle, (ICONINFO)object);
                n5 = ((ICONINFO)object).hbmColor;
                n4 = ((ICONINFO)object).hbmMask;
                break;
            }
            case 0: {
                ImageData imageData = image.getImageData();
                n5 = image.handle;
                n3 = imageData.alpha;
                byArray2 = imageData.alphaData;
                n2 = imageData.transparentPixel;
            }
        }
        object = new BITMAP();
        OS.GetObject(n5, BITMAP.sizeof, (BITMAP)object);
        int n6 = ((BITMAP)object).bmWidth;
        int n7 = ((BITMAP)object).bmHeight;
        int n8 = OS.GetDC(0);
        int n9 = OS.CreateCompatibleDC(n8);
        int n10 = OS.SelectObject(n9, n5);
        int n11 = OS.CreateCompatibleDC(n8);
        BITMAPINFOHEADER bITMAPINFOHEADER = new BITMAPINFOHEADER();
        bITMAPINFOHEADER.biSize = BITMAPINFOHEADER.sizeof;
        bITMAPINFOHEADER.biWidth = n6;
        bITMAPINFOHEADER.biHeight = -n7;
        bITMAPINFOHEADER.biPlanes = 1;
        bITMAPINFOHEADER.biBitCount = (short)32;
        bITMAPINFOHEADER.biCompression = 0;
        byte[] byArray3 = new byte[BITMAPINFOHEADER.sizeof];
        OS.MoveMemory(byArray3, bITMAPINFOHEADER, BITMAPINFOHEADER.sizeof);
        int[] nArray = new int[1];
        int n12 = OS.CreateDIBSection(0, byArray3, 0, nArray, 0, 0);
        if (n12 == 0) {
            SWT.error(2);
        }
        int n13 = OS.SelectObject(n11, n12);
        BITMAP bITMAP = new BITMAP();
        OS.GetObject(n12, BITMAP.sizeof, bITMAP);
        int n14 = bITMAP.bmWidthBytes * bITMAP.bmHeight;
        OS.BitBlt(n11, 0, 0, n6, n7, n9, 0, 0, 0xCC0020);
        byte by2 = 0;
        byte by3 = 0;
        byte by4 = 0;
        if (n2 != -1) {
            if (((BITMAP)object).bmBitsPixel <= 8) {
                byArray = new byte[4];
                OS.GetDIBColorTable(n9, n2, 1, byArray);
                by4 = byArray[0];
                by3 = byArray[1];
                by2 = byArray[2];
            } else {
                switch (((BITMAP)object).bmBitsPixel) {
                    case 16: {
                        by4 = (byte)((n2 & 0x1F) << 3);
                        by3 = (byte)((n2 & 0x3E0) >> 2);
                        by2 = (byte)((n2 & 0x7C00) >> 7);
                        break;
                    }
                    case 24: {
                        by4 = (byte)((n2 & 0xFF0000) >> 16);
                        by3 = (byte)((n2 & 0xFF00) >> 8);
                        by2 = (byte)(n2 & 0xFF);
                        break;
                    }
                    case 32: {
                        by4 = (byte)((n2 & 0xFF000000) >>> 24);
                        by3 = (byte)((n2 & 0xFF0000) >> 16);
                        by2 = (byte)((n2 & 0xFF00) >> 8);
                    }
                }
            }
        }
        byArray = new byte[n14];
        OS.MoveMemory(byArray, nArray[0], n14);
        if (n4 != 0) {
            OS.SelectObject(n9, n4);
            int n15 = 0;
            int n16 = 0;
            while (n15 < n7) {
                int n17 = 0;
                while (n17 < n6) {
                    if (OS.GetPixel(n9, n17, n15) != 0) {
                        byArray[n16 + 3] = 0;
                        byArray[n16 + 2] = 0;
                        byArray[n16 + 1] = 0;
                        byArray[n16 + 0] = 0;
                    } else {
                        byArray[n16 + 3] = -1;
                    }
                    n16 += 4;
                    ++n17;
                }
                ++n15;
            }
        } else if (n3 != -1) {
            int n18 = 0;
            int n19 = 0;
            while (n18 < n7) {
                int n20 = 0;
                while (n20 < n6) {
                    byArray[n19 + 3] = (byte)n3;
                    if (byArray[n19 + 3] == 0) {
                        byArray[n19 + 2] = 0;
                        byArray[n19 + 1] = 0;
                        byArray[n19 + 0] = 0;
                    }
                    n19 += 4;
                    ++n20;
                }
                ++n18;
            }
        } else if (byArray2 != null) {
            int n21 = 0;
            int n22 = 0;
            int n23 = 0;
            while (n21 < n7) {
                int n24 = 0;
                while (n24 < n6) {
                    byArray[n22 + 3] = byArray2[n23++];
                    if (byArray[n22 + 3] == 0) {
                        byArray[n22 + 2] = 0;
                        byArray[n22 + 1] = 0;
                        byArray[n22 + 0] = 0;
                    }
                    n22 += 4;
                    ++n24;
                }
                ++n21;
            }
        } else if (n2 != -1) {
            int n25 = 0;
            int n26 = 0;
            while (n25 < n7) {
                int n27 = 0;
                while (n27 < n6) {
                    if (byArray[n26] == by4 && byArray[n26 + 1] == by3 && byArray[n26 + 2] == by2) {
                        byArray[n26 + 3] = 0;
                        byArray[n26 + 2] = 0;
                        byArray[n26 + 1] = 0;
                        byArray[n26 + 0] = 0;
                    } else {
                        byArray[n26 + 3] = -1;
                    }
                    n26 += 4;
                    ++n27;
                }
                ++n25;
            }
        } else {
            int n28 = 0;
            int n29 = 0;
            while (n28 < n7) {
                int n30 = 0;
                while (n30 < n6) {
                    byArray[n29 + 3] = -1;
                    n29 += 4;
                    ++n30;
                }
                ++n28;
            }
        }
        OS.MoveMemory(nArray[0], byArray, n14);
        OS.SelectObject(n9, n10);
        OS.SelectObject(n11, n13);
        OS.DeleteObject(n9);
        OS.DeleteObject(n11);
        OS.ReleaseDC(0, n8);
        if (n5 != image.handle && n5 != 0) {
            OS.DeleteObject(n5);
        }
        if (n4 != 0) {
            OS.DeleteObject(n4);
        }
        return n12;
    }

    static int create32bitDIB(int n2, int n3, byte[] byArray, int n4) {
        byte[] byArray2;
        BITMAP bITMAP = new BITMAP();
        OS.GetObject(n2, BITMAP.sizeof, bITMAP);
        int n5 = bITMAP.bmWidth;
        int n6 = bITMAP.bmHeight;
        int n7 = OS.GetDC(0);
        int n8 = OS.CreateCompatibleDC(n7);
        int n9 = OS.SelectObject(n8, n2);
        int n10 = OS.CreateCompatibleDC(n7);
        BITMAPINFOHEADER bITMAPINFOHEADER = new BITMAPINFOHEADER();
        bITMAPINFOHEADER.biSize = BITMAPINFOHEADER.sizeof;
        bITMAPINFOHEADER.biWidth = n5;
        bITMAPINFOHEADER.biHeight = -n6;
        bITMAPINFOHEADER.biPlanes = 1;
        bITMAPINFOHEADER.biBitCount = (short)32;
        bITMAPINFOHEADER.biCompression = 0;
        byte[] byArray3 = new byte[BITMAPINFOHEADER.sizeof];
        OS.MoveMemory(byArray3, bITMAPINFOHEADER, BITMAPINFOHEADER.sizeof);
        int[] nArray = new int[1];
        int n11 = OS.CreateDIBSection(0, byArray3, 0, nArray, 0, 0);
        if (n11 == 0) {
            SWT.error(2);
        }
        int n12 = OS.SelectObject(n10, n11);
        BITMAP bITMAP2 = new BITMAP();
        OS.GetObject(n11, BITMAP.sizeof, bITMAP2);
        int n13 = bITMAP2.bmWidthBytes * bITMAP2.bmHeight;
        OS.BitBlt(n10, 0, 0, n5, n6, n8, 0, 0, 0xCC0020);
        byte by2 = 0;
        byte by3 = 0;
        byte by4 = 0;
        if (n4 != -1) {
            if (bITMAP.bmBitsPixel <= 8) {
                byArray2 = new byte[4];
                OS.GetDIBColorTable(n8, n4, 1, byArray2);
                by4 = byArray2[0];
                by3 = byArray2[1];
                by2 = byArray2[2];
            } else {
                switch (bITMAP.bmBitsPixel) {
                    case 16: {
                        by4 = (byte)((n4 & 0x1F) << 3);
                        by3 = (byte)((n4 & 0x3E0) >> 2);
                        by2 = (byte)((n4 & 0x7C00) >> 7);
                        break;
                    }
                    case 24: {
                        by4 = (byte)((n4 & 0xFF0000) >> 16);
                        by3 = (byte)((n4 & 0xFF00) >> 8);
                        by2 = (byte)(n4 & 0xFF);
                        break;
                    }
                    case 32: {
                        by4 = (byte)((n4 & 0xFF000000) >>> 24);
                        by3 = (byte)((n4 & 0xFF0000) >> 16);
                        by2 = (byte)((n4 & 0xFF00) >> 8);
                    }
                }
            }
        }
        OS.SelectObject(n8, n9);
        OS.SelectObject(n10, n12);
        OS.DeleteObject(n8);
        OS.DeleteObject(n10);
        OS.ReleaseDC(0, n7);
        byArray2 = new byte[n13];
        OS.MoveMemory(byArray2, nArray[0], n13);
        if (n3 != -1) {
            int n14 = 0;
            int n15 = 0;
            while (n14 < n6) {
                int n16 = 0;
                while (n16 < n5) {
                    byArray2[n15 + 3] = (byte)n3;
                    n15 += 4;
                    ++n16;
                }
                ++n14;
            }
        } else if (byArray != null) {
            int n17 = 0;
            int n18 = 0;
            int n19 = 0;
            while (n17 < n6) {
                int n20 = 0;
                while (n20 < n5) {
                    byArray2[n18 + 3] = byArray[n19++];
                    n18 += 4;
                    ++n20;
                }
                ++n17;
            }
        } else if (n4 != -1) {
            int n21 = 0;
            int n22 = 0;
            while (n21 < n6) {
                int n23 = 0;
                while (n23 < n5) {
                    byArray2[n22 + 3] = byArray2[n22] == by4 && byArray2[n22 + 1] == by3 && byArray2[n22 + 2] == by2 ? 0 : -1;
                    n22 += 4;
                    ++n23;
                }
                ++n21;
            }
        }
        OS.MoveMemory(nArray[0], byArray2, n13);
        return n11;
    }

    static Image createIcon(Image image) {
        int n2;
        int n3;
        int n4;
        int n5;
        Device device = image.getDevice();
        ImageData imageData = image.getImageData();
        if (imageData.alpha == -1 && imageData.alphaData == null) {
            ImageData imageData2 = imageData.getTransparencyMask();
            return new Image(device, imageData, imageData2);
        }
        int n6 = imageData.width;
        int n7 = imageData.height;
        int n8 = device.internal_new_GC(null);
        int n9 = OS.CreateCompatibleDC(n8);
        if (!OS.IsWinCE && OS.WIN32_VERSION >= OS.VERSION(5, 1)) {
            n5 = Display.create32bitDIB(image.handle, imageData.alpha, imageData.alphaData, imageData.transparentPixel);
            n4 = OS.CreateBitmap(n6, n7, 1, 1, null);
            n3 = OS.SelectObject(n9, n4);
            OS.PatBlt(n9, 0, 0, n6, n7, 66);
        } else {
            n4 = Display.createMaskFromAlpha(imageData, n6, n7);
            n5 = OS.CreateCompatibleBitmap(n8, n6, n7);
            n3 = OS.SelectObject(n9, n5);
            int n10 = OS.CreateCompatibleDC(n8);
            n2 = OS.SelectObject(n10, image.handle);
            OS.PatBlt(n9, 0, 0, n6, n7, 66);
            OS.BitBlt(n9, 0, 0, n6, n7, n10, 0, 0, 0x660046);
            OS.SelectObject(n10, n4);
            OS.BitBlt(n9, 0, 0, n6, n7, n10, 0, 0, 8913094);
            OS.SelectObject(n10, image.handle);
            OS.BitBlt(n9, 0, 0, n6, n7, n10, 0, 0, 0x660046);
            OS.SelectObject(n10, n2);
            OS.DeleteDC(n10);
        }
        OS.SelectObject(n9, n3);
        OS.DeleteDC(n9);
        device.internal_dispose_GC(n8, null);
        ICONINFO iCONINFO = new ICONINFO();
        iCONINFO.fIcon = true;
        iCONINFO.hbmColor = n5;
        iCONINFO.hbmMask = n4;
        n2 = OS.CreateIconIndirect(iCONINFO);
        if (n2 == 0) {
            SWT.error(2);
        }
        OS.DeleteObject(n5);
        OS.DeleteObject(n4);
        return Image.win32_new(device, 1, n2);
    }

    static int createMaskFromAlpha(ImageData imageData, int n2, int n3) {
        int n4;
        int n5 = imageData.width;
        int n6 = imageData.height;
        ImageData imageData2 = ImageData.internal_new(n5, n6, 1, new PaletteData(new RGB[]{new RGB(0, 0, 0), new RGB(255, 255, 255)}), 2, null, 1, null, null, -1, -1, -1, 0, 0, 0, 0);
        int n7 = 0;
        int n8 = 0;
        while (n8 < imageData2.height) {
            n4 = 0;
            while (n4 < imageData2.width) {
                imageData2.setPixel(n4, n8, (imageData.alphaData[n7++] & 0xFF) <= 127 ? 1 : 0);
                ++n4;
            }
            ++n8;
        }
        n8 = OS.CreateBitmap(n5, n6, 1, 1, imageData2.data);
        if (n5 != n2 || n6 != n3) {
            n4 = OS.GetDC(0);
            int n9 = OS.CreateCompatibleDC(n4);
            OS.SelectObject(n9, n8);
            int n10 = OS.CreateCompatibleDC(n4);
            int n11 = OS.CreateBitmap(n2, n3, 1, 1, null);
            OS.SelectObject(n10, n11);
            if (!OS.IsWinCE) {
                OS.SetStretchBltMode(n10, 3);
            }
            OS.StretchBlt(n10, 0, 0, n2, n3, n9, 0, 0, n5, n6, 0xCC0020);
            OS.DeleteDC(n9);
            OS.DeleteDC(n10);
            OS.ReleaseDC(0, n4);
            OS.DeleteObject(n8);
            n8 = n11;
        }
        return n8;
    }

    static synchronized void deregister(Display display) {
        int n2 = 0;
        while (n2 < Displays.length) {
            if (display == Displays[n2]) {
                Display.Displays[n2] = null;
            }
            ++n2;
        }
    }

    protected void destroy() {
        if (this == Default) {
            Default = null;
        }
        Display.deregister(this);
        this.destroyDisplay();
    }

    void destroyDisplay() {
    }

    public void disposeExec(Runnable runnable) {
        this.checkDevice();
        if (this.disposeList == null) {
            this.disposeList = new Runnable[4];
        }
        int n2 = 0;
        while (n2 < this.disposeList.length) {
            if (this.disposeList[n2] == null) {
                this.disposeList[n2] = runnable;
                return;
            }
            ++n2;
        }
        Runnable[] runnableArray = new Runnable[this.disposeList.length + 4];
        System.arraycopy(this.disposeList, 0, runnableArray, 0, this.disposeList.length);
        runnableArray[this.disposeList.length] = runnable;
        this.disposeList = runnableArray;
    }

    void drawMenuBars() {
        if (this.bars == null) {
            return;
        }
        int n2 = 0;
        while (n2 < this.bars.length) {
            Menu menu = this.bars[n2];
            if (menu != null && !menu.isDisposed()) {
                menu.update();
            }
            ++n2;
        }
        this.bars = null;
    }

    int embeddedProc(int n2, int n3, int n4, int n5) {
        switch (n3) {
            case 32770: {
                MSG mSG = new MSG();
                OS.MoveMemory(mSG, n5, MSG.sizeof);
                OS.TranslateMessage(mSG);
                OS.DispatchMessage(mSG);
                int n6 = OS.GetProcessHeap();
                OS.HeapFree(n6, 0, n5);
                break;
            }
            case 32771: {
                OS.DestroyWindow(n2);
                if (this.embeddedCallback != null) {
                    this.embeddedCallback.dispose();
                }
                if (this.getMsgCallback != null) {
                    this.getMsgCallback.dispose();
                }
                this.getMsgCallback = null;
                this.embeddedCallback = null;
                this.getMsgProc = 0;
                this.embeddedProc = 0;
            }
        }
        return OS.DefWindowProc(n2, n3, n4, n5);
    }

    void error(int n2) {
        SWT.error(n2);
    }

    boolean filterEvent(Event event) {
        if (this.filterTable != null) {
            this.filterTable.sendEvent(event);
        }
        return false;
    }

    boolean filters(int n2) {
        if (this.filterTable == null) {
            return false;
        }
        return this.filterTable.hooks(n2);
    }

    boolean filterMessage(MSG mSG) {
        Control control;
        int n2 = mSG.message;
        if (256 <= n2 && n2 <= 264 && (control = this.findControl(mSG.hwnd)) != null && (this.translateAccelerator(mSG, control) || this.translateMnemonic(mSG, control) || this.translateTraversal(mSG, control))) {
            this.lastKey = 0;
            this.lastAscii = 0;
            this.lastDead = false;
            this.lastNull = false;
            this.lastVirtual = false;
            return true;
        }
        return false;
    }

    Control findControl(int n2) {
        if (n2 == 0) {
            return null;
        }
        int n3 = 0;
        do {
            Control control;
            if ((control = this.getControl(n2)) != null) {
                return control;
            }
            n3 = OS.GetWindow(n2, 4);
        } while ((n2 = OS.GetParent(n2)) != 0 && n2 != n3);
        return null;
    }

    public Widget findWidget(int n2) {
        this.checkDevice();
        return this.getControl(n2);
    }

    public Widget findWidget(int n2, int n3) {
        this.checkDevice();
        Control control = this.getControl(n2);
        return control != null ? control.findItem(n3) : null;
    }

    public Widget findWidget(Widget widget, int n2) {
        this.checkDevice();
        if (widget instanceof Control) {
            return this.findWidget(((Control)widget).handle, n2);
        }
        return null;
    }

    int foregroundIdleProc(int n2, int n3, int n4) {
        if (this.runMessages && n2 >= 0 && this.getMessageCount() != 0) {
            if (this.runMessagesInIdle) {
                OS.PostMessage(this.hwndMessage, 32774, 0, 0);
            }
            this.wakeThread();
        }
        return OS.CallNextHookEx(this.idleHook, n2, n3, n4);
    }

    public static synchronized Display findDisplay(Thread thread) {
        int n2 = 0;
        while (n2 < Displays.length) {
            Display display = Displays[n2];
            if (display != null && display.thread == thread) {
                return display;
            }
            ++n2;
        }
        return null;
    }

    public Shell getActiveShell() {
        this.checkDevice();
        Control control = this.findControl(OS.GetActiveWindow());
        return control != null ? control.getShell() : null;
    }

    public Rectangle getBounds() {
        this.checkDevice();
        if (OS.GetSystemMetrics(80) < 2) {
            int n2 = OS.GetSystemMetrics(0);
            int n3 = OS.GetSystemMetrics(1);
            return new Rectangle(0, 0, n2, n3);
        }
        int n4 = OS.GetSystemMetrics(76);
        int n5 = OS.GetSystemMetrics(77);
        int n6 = OS.GetSystemMetrics(78);
        int n7 = OS.GetSystemMetrics(79);
        return new Rectangle(n4, n5, n6, n7);
    }

    public static synchronized Display getCurrent() {
        return Display.findDisplay(Thread.currentThread());
    }

    int getClickCount(int n2, int n3, int n4, int n5) {
        switch (n2) {
            case 3: {
                int n6 = OS.GetDoubleClickTime();
                if (this.clickRect == null) {
                    this.clickRect = new RECT();
                }
                int n7 = Math.abs(this.lastTime - this.getLastEventTime());
                POINT pOINT = new POINT();
                pOINT.x = (short)(n5 & 0xFFFF);
                pOINT.y = (short)(n5 >> 16);
                this.clickCount = this.lastClickHwnd == n4 && this.lastButton == n3 && n7 <= n6 && OS.PtInRect(this.clickRect, pOINT) ? ++this.clickCount : 1;
            }
            case 8: {
                this.lastButton = n3;
                this.lastClickHwnd = n4;
                this.lastTime = this.getLastEventTime();
                int n8 = OS.GetSystemMetrics(36) / 2;
                int n9 = OS.GetSystemMetrics(37) / 2;
                short s2 = (short)(n5 & 0xFFFF);
                short s3 = (short)(n5 >> 16);
                OS.SetRect(this.clickRect, s2 - n8, s3 - n9, s2 + n8, s3 + n9);
            }
            case 4: {
                return this.clickCount;
            }
        }
        return 0;
    }

    public Rectangle getClientArea() {
        this.checkDevice();
        if (OS.GetSystemMetrics(80) < 2) {
            RECT rECT = new RECT();
            OS.SystemParametersInfo(48, 0, rECT, 0);
            int n2 = rECT.right - rECT.left;
            int n3 = rECT.bottom - rECT.top;
            return new Rectangle(rECT.left, rECT.top, n2, n3);
        }
        int n4 = OS.GetSystemMetrics(76);
        int n5 = OS.GetSystemMetrics(77);
        int n6 = OS.GetSystemMetrics(78);
        int n7 = OS.GetSystemMetrics(79);
        return new Rectangle(n4, n5, n6, n7);
    }

    Control getControl(int n2) {
        Control control;
        if (n2 == 0) {
            return null;
        }
        if (this.lastControl != null && this.lastHwnd == n2) {
            return this.lastControl;
        }
        if (this.lastGetControl != null && this.lastGetHwnd == n2) {
            return this.lastGetControl;
        }
        int n3 = USE_PROPERTY ? OS.GetProp(n2, SWT_OBJECT_INDEX) - 1 : OS.GetWindowLong(n2, -21) - 1;
        if (n3 >= 0 && n3 < this.controlTable.length && (control = this.controlTable[n3]) != null && control.checkHandle(n2)) {
            this.lastGetHwnd = n2;
            this.lastGetControl = control;
            return control;
        }
        return null;
    }

    public Control getCursorControl() {
        this.checkDevice();
        POINT pOINT = new POINT();
        if (!OS.GetCursorPos(pOINT)) {
            return null;
        }
        return this.findControl(OS.WindowFromPoint(pOINT));
    }

    public Point getCursorLocation() {
        this.checkDevice();
        POINT pOINT = new POINT();
        OS.GetCursorPos(pOINT);
        return new Point(pOINT.x, pOINT.y);
    }

    public Point[] getCursorSizes() {
        this.checkDevice();
        return new Point[]{new Point(OS.GetSystemMetrics(13), OS.GetSystemMetrics(14))};
    }

    public static synchronized Display getDefault() {
        if (Default == null) {
            Default = new Display();
        }
        return Default;
    }

    static boolean isValidClass(Class clazz) {
        String string = clazz.getName();
        int n2 = string.lastIndexOf(46);
        return string.substring(0, n2 + 1).equals(PACKAGE_PREFIX);
    }

    public Object getData(String string) {
        this.checkDevice();
        if (string == null) {
            this.error(4);
        }
        if (string.equals(RUN_MESSAGES_IN_IDLE_KEY)) {
            return new Boolean(this.runMessagesInIdle);
        }
        if (this.keys == null) {
            return null;
        }
        int n2 = 0;
        while (n2 < this.keys.length) {
            if (this.keys[n2].equals(string)) {
                return this.values[n2];
            }
            ++n2;
        }
        return null;
    }

    public Object getData() {
        this.checkDevice();
        return this.data;
    }

    public int getDismissalAlignment() {
        this.checkDevice();
        return 16384;
    }

    public int getDoubleClickTime() {
        this.checkDevice();
        return OS.GetDoubleClickTime();
    }

    public Control getFocusControl() {
        this.checkDevice();
        if (this.focusControl != null && !this.focusControl.isDisposed()) {
            return this.focusControl;
        }
        return this._getFocusControl();
    }

    String getFontName(LOGFONT lOGFONT) {
        char[] cArray;
        if (OS.IsUnicode) {
            cArray = ((LOGFONTW)lOGFONT).lfFaceName;
        } else {
            cArray = new char[32];
            byte[] byArray = ((LOGFONTA)lOGFONT).lfFaceName;
            OS.MultiByteToWideChar(0, 1, byArray, byArray.length, cArray, cArray.length);
        }
        int n2 = 0;
        while (n2 < cArray.length) {
            if (cArray[n2] == '\u0000') break;
            ++n2;
        }
        return new String(cArray, 0, n2);
    }

    public boolean getHighContrast() {
        this.checkDevice();
        if (OS.IsWinCE) {
            return false;
        }
        HIGHCONTRAST hIGHCONTRAST = new HIGHCONTRAST();
        hIGHCONTRAST.cbSize = HIGHCONTRAST.sizeof;
        OS.SystemParametersInfo(66, 0, hIGHCONTRAST, 0);
        return (hIGHCONTRAST.dwFlags & 1) != 0;
    }

    public int getIconDepth() {
        TCHAR tCHAR;
        this.checkDevice();
        if (!OS.IsWinCE && OS.WIN32_VERSION >= OS.VERSION(5, 1) && this.getDepth() >= 24) {
            return 32;
        }
        TCHAR tCHAR2 = new TCHAR(0, "Control Panel\\Desktop\\WindowMetrics", true);
        int[] nArray = new int[1];
        int n2 = OS.RegOpenKeyEx(-2147483647, tCHAR2, 0, 131097, nArray);
        if (n2 != 0) {
            return 4;
        }
        int n3 = 4;
        TCHAR tCHAR3 = new TCHAR(0, "Shell Icon BPP", true);
        int[] nArray2 = new int[1];
        n2 = OS.RegQueryValueEx(nArray[0], tCHAR3, 0, null, null, nArray2);
        if (n2 == 0 && (n2 = OS.RegQueryValueEx(nArray[0], tCHAR3, 0, null, tCHAR = new TCHAR(0, nArray2[0] / TCHAR.sizeof), nArray2)) == 0) {
            try {
                n3 = Integer.parseInt(tCHAR.toString(0, tCHAR.strlen()));
            }
            catch (NumberFormatException numberFormatException) {}
        }
        OS.RegCloseKey(nArray[0]);
        return n3;
    }

    public Point[] getIconSizes() {
        this.checkDevice();
        return new Point[]{new Point(OS.GetSystemMetrics(49), OS.GetSystemMetrics(50)), new Point(OS.GetSystemMetrics(11), OS.GetSystemMetrics(12))};
    }

    ImageList getImageList(int n2, int n3, int n4) {
        Object object;
        if (this.imageList == null) {
            this.imageList = new ImageList[4];
        }
        int n5 = 0;
        int n6 = this.imageList.length;
        while (n5 < n6) {
            object = this.imageList[n5];
            if (object == null) break;
            Point point = ((ImageList)object).getImageSize();
            if (point.x == n3 && point.y == n4 && ((ImageList)object).getStyle() == n2) {
                ((ImageList)object).addRef();
                return object;
            }
            ++n5;
        }
        if (n5 == n6) {
            object = new ImageList[n6 + 4];
            System.arraycopy(this.imageList, 0, object, 0, n6);
            this.imageList = object;
        }
        this.imageList[n5] = object = new ImageList(n2);
        ((ImageList)object).addRef();
        return object;
    }

    ImageList getImageListToolBar(int n2, int n3, int n4) {
        Object object;
        if (this.toolImageList == null) {
            this.toolImageList = new ImageList[4];
        }
        int n5 = 0;
        int n6 = this.toolImageList.length;
        while (n5 < n6) {
            object = this.toolImageList[n5];
            if (object == null) break;
            Point point = ((ImageList)object).getImageSize();
            if (point.x == n3 && point.y == n4 && ((ImageList)object).getStyle() == n2) {
                ((ImageList)object).addRef();
                return object;
            }
            ++n5;
        }
        if (n5 == n6) {
            object = new ImageList[n6 + 4];
            System.arraycopy(this.toolImageList, 0, object, 0, n6);
            this.toolImageList = object;
        }
        this.toolImageList[n5] = object = new ImageList(n2);
        ((ImageList)object).addRef();
        return object;
    }

    ImageList getImageListToolBarDisabled(int n2, int n3, int n4) {
        Object object;
        if (this.toolDisabledImageList == null) {
            this.toolDisabledImageList = new ImageList[4];
        }
        int n5 = 0;
        int n6 = this.toolDisabledImageList.length;
        while (n5 < n6) {
            object = this.toolDisabledImageList[n5];
            if (object == null) break;
            Point point = ((ImageList)object).getImageSize();
            if (point.x == n3 && point.y == n4 && ((ImageList)object).getStyle() == n2) {
                ((ImageList)object).addRef();
                return object;
            }
            ++n5;
        }
        if (n5 == n6) {
            object = new ImageList[n6 + 4];
            System.arraycopy(this.toolDisabledImageList, 0, object, 0, n6);
            this.toolDisabledImageList = object;
        }
        this.toolDisabledImageList[n5] = object = new ImageList(n2);
        ((ImageList)object).addRef();
        return object;
    }

    ImageList getImageListToolBarHot(int n2, int n3, int n4) {
        Object object;
        if (this.toolHotImageList == null) {
            this.toolHotImageList = new ImageList[4];
        }
        int n5 = 0;
        int n6 = this.toolHotImageList.length;
        while (n5 < n6) {
            object = this.toolHotImageList[n5];
            if (object == null) break;
            Point point = ((ImageList)object).getImageSize();
            if (point.x == n3 && point.y == n4 && ((ImageList)object).getStyle() == n2) {
                ((ImageList)object).addRef();
                return object;
            }
            ++n5;
        }
        if (n5 == n6) {
            object = new ImageList[n6 + 4];
            System.arraycopy(this.toolHotImageList, 0, object, 0, n6);
            this.toolHotImageList = object;
        }
        this.toolHotImageList[n5] = object = new ImageList(n2);
        ((ImageList)object).addRef();
        return object;
    }

    int getLastEventTime() {
        return OS.IsWinCE ? OS.GetTickCount() : OS.GetMessageTime();
    }

    MenuItem getMenuItem(int n2) {
        if (this.items == null) {
            return null;
        }
        if ((n2 -= 108) >= 0 && n2 < this.items.length) {
            return this.items[n2];
        }
        return null;
    }

    int getMessageCount() {
        return this.synchronizer.getMessageCount();
    }

    Shell getModalShell() {
        if (this.modalShells == null) {
            return null;
        }
        int n2 = this.modalShells.length;
        while (--n2 >= 0) {
            Shell shell = this.modalShells[n2];
            if (shell == null) continue;
            return shell;
        }
        return null;
    }

    Shell getModalDialogShell() {
        if (this.modalDialogShell != null && this.modalDialogShell.isDisposed()) {
            this.modalDialogShell = null;
        }
        return this.modalDialogShell;
    }

    public Monitor[] getMonitors() {
        this.checkDevice();
        if (OS.IsWinCE || OS.WIN32_VERSION < OS.VERSION(4, 10)) {
            return new Monitor[]{this.getPrimaryMonitor()};
        }
        this.monitors = new Monitor[4];
        Callback callback = new Callback(this, "monitorEnumProc", 4);
        int n2 = callback.getAddress();
        if (n2 == 0) {
            SWT.error(3);
        }
        OS.EnumDisplayMonitors(0, null, n2, 0);
        callback.dispose();
        Monitor[] monitorArray = new Monitor[this.monitorCount];
        System.arraycopy(this.monitors, 0, monitorArray, 0, this.monitorCount);
        this.monitors = null;
        this.monitorCount = 0;
        return monitorArray;
    }

    int getMsgProc(int n2, int n3, int n4) {
        if (this.embeddedHwnd == 0) {
            int n5 = OS.GetModuleHandle(null);
            this.embeddedHwnd = OS.CreateWindowEx(0, this.windowClass, null, OS.WS_OVERLAPPED, 0, 0, 0, 0, 0, 0, n5, null);
            this.embeddedCallback = new Callback(this, "embeddedProc", 4);
            this.embeddedProc = this.embeddedCallback.getAddress();
            if (this.embeddedProc == 0) {
                this.error(3);
            }
            OS.SetWindowLong(this.embeddedHwnd, -4, this.embeddedProc);
        }
        if (n2 >= 0 && n3 != 0) {
            MSG mSG = new MSG();
            OS.MoveMemory(mSG, n4, MSG.sizeof);
            switch (mSG.message) {
                case 256: 
                case 257: 
                case 260: 
                case 261: {
                    Control control = this.findControl(mSG.hwnd);
                    if (control == null) break;
                    int n6 = OS.GetProcessHeap();
                    int n7 = OS.HeapAlloc(n6, 8, MSG.sizeof);
                    OS.MoveMemory(n7, mSG, MSG.sizeof);
                    OS.PostMessage(this.hwndMessage, 32770, n3, n7);
                    mSG.message = 0;
                    OS.MoveMemory(n4, mSG, MSG.sizeof);
                }
            }
        }
        return OS.CallNextHookEx(this.msgHook, n2, n3, n4);
    }

    public Monitor getPrimaryMonitor() {
        this.checkDevice();
        if (OS.IsWinCE || OS.WIN32_VERSION < OS.VERSION(4, 10)) {
            Monitor monitor = new Monitor();
            int n2 = OS.GetSystemMetrics(0);
            int n3 = OS.GetSystemMetrics(1);
            monitor.width = n2;
            monitor.height = n3;
            RECT rECT = new RECT();
            OS.SystemParametersInfo(48, 0, rECT, 0);
            monitor.clientX = rECT.left;
            monitor.clientY = rECT.top;
            monitor.clientWidth = rECT.right - rECT.left;
            monitor.clientHeight = rECT.bottom - rECT.top;
            return monitor;
        }
        this.monitors = new Monitor[4];
        Callback callback = new Callback(this, "monitorEnumProc", 4);
        int n4 = callback.getAddress();
        if (n4 == 0) {
            SWT.error(3);
        }
        OS.EnumDisplayMonitors(0, null, n4, 0);
        callback.dispose();
        Monitor monitor = null;
        MONITORINFO mONITORINFO = new MONITORINFO();
        mONITORINFO.cbSize = MONITORINFO.sizeof;
        int n5 = 0;
        while (n5 < this.monitorCount) {
            Monitor monitor2 = this.monitors[n5];
            OS.GetMonitorInfo(this.monitors[n5].handle, mONITORINFO);
            if ((mONITORINFO.dwFlags & 1) != 0) {
                monitor = monitor2;
                break;
            }
            ++n5;
        }
        this.monitors = null;
        this.monitorCount = 0;
        return monitor;
    }

    public Shell[] getShells() {
        this.checkDevice();
        int n2 = 0;
        Shell[] shellArray = new Shell[16];
        int n3 = 0;
        while (n3 < this.controlTable.length) {
            Control control = this.controlTable[n3];
            if (control != null && control instanceof Shell) {
                int n4 = 0;
                while (n4 < n2) {
                    if (shellArray[n4] == control) break;
                    ++n4;
                }
                if (n4 == n2) {
                    if (n2 == shellArray.length) {
                        Shell[] shellArray2 = new Shell[n2 + 16];
                        System.arraycopy(shellArray, 0, shellArray2, 0, n2);
                        shellArray = shellArray2;
                    }
                    shellArray[n2++] = (Shell)control;
                }
            }
            ++n3;
        }
        if (n2 == shellArray.length) {
            return shellArray;
        }
        Shell[] shellArray3 = new Shell[n2];
        System.arraycopy(shellArray, 0, shellArray3, 0, n2);
        return shellArray3;
    }

    Image getSortImage(int n2) {
        switch (n2) {
            case 128: {
                if (this.upArrow != null) {
                    return this.upArrow;
                }
                Color color = this.getSystemColor(18);
                Color color2 = this.getSystemColor(20);
                Color color3 = this.getSystemColor(22);
                PaletteData paletteData = new PaletteData(new RGB[]{color.getRGB(), color2.getRGB(), color3.getRGB()});
                ImageData imageData = new ImageData(8, 8, 4, paletteData);
                imageData.transparentPixel = 2;
                this.upArrow = new Image((Device)this, imageData);
                GC gC = new GC(this.upArrow);
                gC.setBackground(color3);
                gC.fillRectangle(0, 0, 8, 8);
                gC.setForeground(color);
                int[] nArray = new int[14];
                nArray[1] = 6;
                nArray[2] = 1;
                nArray[3] = 6;
                nArray[4] = 1;
                nArray[5] = 4;
                nArray[6] = 2;
                nArray[7] = 4;
                nArray[8] = 2;
                nArray[9] = 2;
                nArray[10] = 3;
                nArray[11] = 2;
                nArray[12] = 3;
                nArray[13] = 1;
                int[] nArray2 = nArray;
                gC.drawPolyline(nArray2);
                gC.setForeground(color2);
                int[] nArray3 = new int[18];
                nArray3[1] = 7;
                nArray3[2] = 7;
                nArray3[3] = 7;
                nArray3[4] = 7;
                nArray3[5] = 6;
                nArray3[6] = 6;
                nArray3[7] = 6;
                nArray3[8] = 6;
                nArray3[9] = 4;
                nArray3[10] = 5;
                nArray3[11] = 4;
                nArray3[12] = 5;
                nArray3[13] = 2;
                nArray3[14] = 4;
                nArray3[15] = 2;
                nArray3[16] = 4;
                nArray3[17] = 1;
                int[] nArray4 = nArray3;
                gC.drawPolyline(nArray4);
                gC.dispose();
                return this.upArrow;
            }
            case 1024: {
                if (this.downArrow != null) {
                    return this.downArrow;
                }
                Color color = this.getSystemColor(18);
                Color color4 = this.getSystemColor(20);
                Color color5 = this.getSystemColor(22);
                PaletteData paletteData = new PaletteData(new RGB[]{color.getRGB(), color4.getRGB(), color5.getRGB()});
                ImageData imageData = new ImageData(8, 8, 4, paletteData);
                imageData.transparentPixel = 2;
                this.downArrow = new Image((Device)this, imageData);
                GC gC = new GC(this.downArrow);
                gC.setBackground(color5);
                gC.fillRectangle(0, 0, 8, 8);
                gC.setForeground(color);
                int[] nArray = new int[18];
                nArray[0] = 7;
                nArray[5] = 1;
                nArray[6] = 1;
                nArray[7] = 1;
                nArray[8] = 1;
                nArray[9] = 3;
                nArray[10] = 2;
                nArray[11] = 3;
                nArray[12] = 2;
                nArray[13] = 5;
                nArray[14] = 3;
                nArray[15] = 5;
                nArray[16] = 3;
                nArray[17] = 6;
                int[] nArray5 = nArray;
                gC.drawPolyline(nArray5);
                gC.setForeground(color4);
                int[] nArray6 = new int[]{4, 6, 4, 5, 5, 5, 5, 3, 6, 3, 6, 1, 7, 1};
                gC.drawPolyline(nArray6);
                gC.dispose();
                return this.downArrow;
            }
        }
        return null;
    }

    public Thread getSyncThread() {
        if (this.isDisposed()) {
            this.error(45);
        }
        return this.synchronizer.syncThread;
    }

    public Color getSystemColor(int n2) {
        this.checkDevice();
        int n3 = 0;
        switch (n2) {
            case 17: {
                n3 = OS.GetSysColor(OS.COLOR_3DDKSHADOW);
                break;
            }
            case 18: {
                n3 = OS.GetSysColor(OS.COLOR_3DSHADOW);
                break;
            }
            case 19: {
                n3 = OS.GetSysColor(OS.COLOR_3DLIGHT);
                break;
            }
            case 20: {
                n3 = OS.GetSysColor(OS.COLOR_3DHIGHLIGHT);
                break;
            }
            case 22: {
                n3 = OS.GetSysColor(OS.COLOR_3DFACE);
                break;
            }
            case 23: {
                n3 = OS.GetSysColor(OS.COLOR_WINDOWFRAME);
                break;
            }
            case 21: 
            case 24: {
                n3 = OS.GetSysColor(OS.COLOR_WINDOWTEXT);
                break;
            }
            case 25: {
                n3 = OS.GetSysColor(OS.COLOR_WINDOW);
                break;
            }
            case 26: {
                n3 = OS.GetSysColor(OS.COLOR_HIGHLIGHT);
                break;
            }
            case 27: {
                n3 = OS.GetSysColor(OS.COLOR_HIGHLIGHTTEXT);
                break;
            }
            case 28: {
                n3 = OS.GetSysColor(OS.COLOR_INFOTEXT);
                break;
            }
            case 29: {
                n3 = OS.GetSysColor(OS.COLOR_INFOBK);
                break;
            }
            case 30: {
                n3 = OS.GetSysColor(OS.COLOR_CAPTIONTEXT);
                break;
            }
            case 31: {
                n3 = OS.GetSysColor(OS.COLOR_ACTIVECAPTION);
                break;
            }
            case 32: {
                n3 = OS.GetSysColor(OS.COLOR_GRADIENTACTIVECAPTION);
                if (n3 != 0) break;
                n3 = OS.GetSysColor(OS.COLOR_ACTIVECAPTION);
                break;
            }
            case 33: {
                n3 = OS.GetSysColor(OS.COLOR_INACTIVECAPTIONTEXT);
                break;
            }
            case 34: {
                n3 = OS.GetSysColor(OS.COLOR_INACTIVECAPTION);
                break;
            }
            case 35: {
                n3 = OS.GetSysColor(OS.COLOR_GRADIENTINACTIVECAPTION);
                if (n3 != 0) break;
                n3 = OS.GetSysColor(OS.COLOR_INACTIVECAPTION);
                break;
            }
            default: {
                return super.getSystemColor(n2);
            }
        }
        return Color.win32_new(this, n3);
    }

    public Cursor getSystemCursor(int n2) {
        this.checkDevice();
        if (n2 < 0 || n2 >= this.cursors.length) {
            return null;
        }
        if (this.cursors[n2] == null) {
            this.cursors[n2] = new Cursor(this, n2);
        }
        return this.cursors[n2];
    }

    public Font getSystemFont() {
        this.checkDevice();
        if (this.systemFont != null) {
            return this.systemFont;
        }
        int n2 = 0;
        if (!OS.IsWinCE) {
            NONCLIENTMETRICS nONCLIENTMETRICS = OS.IsUnicode ? new NONCLIENTMETRICSW() : new NONCLIENTMETRICSA();
            nONCLIENTMETRICS.cbSize = NONCLIENTMETRICS.sizeof;
            if (OS.SystemParametersInfo(41, 0, nONCLIENTMETRICS, 0)) {
                LOGFONT lOGFONT = OS.IsUnicode ? nONCLIENTMETRICS.lfMessageFont : ((NONCLIENTMETRICSA)nONCLIENTMETRICS).lfMessageFont;
                n2 = OS.CreateFontIndirect(lOGFONT);
                LOGFONT lOGFONT2 = this.lfSystemFont = n2 != 0 ? lOGFONT : null;
            }
        }
        if (n2 == 0) {
            n2 = OS.GetStockObject(17);
        }
        if (n2 == 0) {
            n2 = OS.GetStockObject(13);
        }
        this.systemFont = Font.win32_new(this, n2);
        return this.systemFont;
    }

    public Image getSystemImage(int n2) {
        this.checkDevice();
        switch (n2) {
            case 1: {
                if (this.errorImage != null) {
                    return this.errorImage;
                }
                int n3 = OS.LoadImage(0, 32513, 1, 0, 0, 32768);
                this.errorImage = Image.win32_new(this, 1, n3);
                return this.errorImage;
            }
            case 2: 
            case 16: {
                if (this.infoImage != null) {
                    return this.infoImage;
                }
                int n4 = OS.LoadImage(0, 32516, 1, 0, 0, 32768);
                this.infoImage = Image.win32_new(this, 1, n4);
                return this.infoImage;
            }
            case 4: {
                if (this.questionImage != null) {
                    return this.questionImage;
                }
                int n5 = OS.LoadImage(0, 32514, 1, 0, 0, 32768);
                this.questionImage = Image.win32_new(this, 1, n5);
                return this.questionImage;
            }
            case 8: {
                if (this.warningIcon != null) {
                    return this.warningIcon;
                }
                int n6 = OS.LoadImage(0, 32515, 1, 0, 0, 32768);
                this.warningIcon = Image.win32_new(this, 1, n6);
                return this.warningIcon;
            }
        }
        return null;
    }

    public Tray getSystemTray() {
        this.checkDevice();
        if (this.tray != null) {
            return this.tray;
        }
        if (!OS.IsWinCE) {
            this.tray = new Tray(this, 0);
        }
        return this.tray;
    }

    public Thread getThread() {
        if (this.isDisposed()) {
            this.error(45);
        }
        return this.thread;
    }

    int hButtonTheme() {
        if (this.hButtonTheme != 0) {
            return this.hButtonTheme;
        }
        this.hButtonTheme = OS.OpenThemeData(this.hwndMessage, BUTTON);
        return this.hButtonTheme;
    }

    int hEditTheme() {
        if (this.hEditTheme != 0) {
            return this.hEditTheme;
        }
        this.hEditTheme = OS.OpenThemeData(this.hwndMessage, EDIT);
        return this.hEditTheme;
    }

    int hExplorerBarTheme() {
        if (this.hExplorerBarTheme != 0) {
            return this.hExplorerBarTheme;
        }
        this.hExplorerBarTheme = OS.OpenThemeData(this.hwndMessage, EXPLORERBAR);
        return this.hExplorerBarTheme;
    }

    int hScrollBarTheme() {
        if (this.hScrollBarTheme != 0) {
            return this.hScrollBarTheme;
        }
        this.hScrollBarTheme = OS.OpenThemeData(this.hwndMessage, SCROLLBAR);
        return this.hScrollBarTheme;
    }

    int hTabTheme() {
        if (this.hTabTheme != 0) {
            return this.hTabTheme;
        }
        this.hTabTheme = OS.OpenThemeData(this.hwndMessage, TAB);
        return this.hTabTheme;
    }

    public int internal_new_GC(GCData gCData) {
        int n2;
        if (this.isDisposed()) {
            SWT.error(45);
        }
        if ((n2 = OS.GetDC(0)) == 0) {
            SWT.error(2);
        }
        if (gCData != null) {
            int n3 = 0x6000000;
            if ((gCData.style & n3) != 0) {
                gCData.layout = (gCData.style & 0x4000000) != 0 ? 1 : 0;
            } else {
                gCData.style |= 0x2000000;
            }
            gCData.device = this;
            gCData.hFont = this.getSystemFont().handle;
        }
        return n2;
    }

    protected void init() {
        super.init();
        this.windowCallback = new Callback(this, "windowProc", 4);
        this.windowProc = this.windowCallback.getAddress();
        if (this.windowProc == 0) {
            this.error(3);
        }
        this.threadId = OS.GetCurrentThreadId();
        this.windowClass = new TCHAR(0, WindowName + WindowClassCount, true);
        this.windowShadowClass = new TCHAR(0, WindowShadowName + WindowClassCount, true);
        ++WindowClassCount;
        int n2 = OS.GetProcessHeap();
        int n3 = OS.GetModuleHandle(null);
        WNDCLASS wNDCLASS = new WNDCLASS();
        wNDCLASS.hInstance = n3;
        wNDCLASS.lpfnWndProc = this.windowProc;
        wNDCLASS.style = 8200;
        wNDCLASS.hCursor = OS.LoadCursor(0, 32512);
        int n4 = this.windowClass.length() * TCHAR.sizeof;
        wNDCLASS.lpszClassName = OS.HeapAlloc(n2, 8, n4);
        OS.MoveMemory(wNDCLASS.lpszClassName, this.windowClass, n4);
        OS.RegisterClass(wNDCLASS);
        OS.HeapFree(n2, 0, wNDCLASS.lpszClassName);
        if (!OS.IsWinCE && OS.WIN32_VERSION >= OS.VERSION(5, 1)) {
            wNDCLASS.style |= 0x20000;
        }
        n4 = this.windowShadowClass.length() * TCHAR.sizeof;
        wNDCLASS.lpszClassName = OS.HeapAlloc(n2, 8, n4);
        OS.MoveMemory(wNDCLASS.lpszClassName, this.windowShadowClass, n4);
        OS.RegisterClass(wNDCLASS);
        OS.HeapFree(n2, 0, wNDCLASS.lpszClassName);
        this.hwndMessage = OS.CreateWindowEx(0, this.windowClass, null, OS.WS_OVERLAPPED, 0, 0, 0, 0, 0, 0, n3, null);
        this.messageCallback = new Callback(this, "messageProc", 4);
        this.messageProc = this.messageCallback.getAddress();
        if (this.messageProc == 0) {
            this.error(3);
        }
        OS.SetWindowLong(this.hwndMessage, -4, this.messageProc);
        if (!OS.IsWinCE) {
            this.msgFilterCallback = new Callback(this, "msgFilterProc", 3);
            this.msgFilterProc = this.msgFilterCallback.getAddress();
            if (this.msgFilterProc == 0) {
                this.error(3);
            }
            this.filterHook = OS.SetWindowsHookEx(-1, this.msgFilterProc, 0, this.threadId);
        }
        if (!OS.IsWinCE) {
            this.foregroundIdleCallback = new Callback(this, "foregroundIdleProc", 3);
            this.foregroundIdleProc = this.foregroundIdleCallback.getAddress();
            if (this.foregroundIdleProc == 0) {
                this.error(3);
            }
            this.idleHook = OS.SetWindowsHookEx(11, this.foregroundIdleProc, 0, this.threadId);
        }
        SWT_TASKBARCREATED = OS.RegisterWindowMessage(new TCHAR(0, "TaskbarCreated", true));
        SWT_RESTORECARET = OS.RegisterWindowMessage(new TCHAR(0, "SWT_RESTORECARET", true));
        if (!OS.IsWinCE) {
            OS.OleInitialize(0);
        }
        if (!OS.IsWinCE && OS.WIN32_VERSION >= OS.VERSION(6, 0)) {
            OS.BufferedPaintInit();
        }
        this.indexTable = new int[1024];
        this.controlTable = new Control[1024];
        int n5 = 0;
        while (n5 < 1023) {
            this.indexTable[n5] = n5 + 1;
            ++n5;
        }
        this.indexTable[1023] = -1;
    }

    public void internal_dispose_GC(int n2, GCData gCData) {
        OS.ReleaseDC(0, n2);
    }

    boolean isXMouseActive() {
        boolean bl2 = false;
        TCHAR tCHAR = new TCHAR(0, "Control Panel\\Desktop", true);
        int[] nArray = new int[1];
        int n2 = OS.RegOpenKeyEx(-2147483647, tCHAR, 0, 131097, nArray);
        if (n2 == 0) {
            TCHAR tCHAR2 = new TCHAR(0, "UserPreferencesMask", true);
            int[] nArray2 = new int[1];
            int[] nArray3 = new int[]{4};
            n2 = OS.RegQueryValueEx(nArray[0], tCHAR2, 0, null, nArray2, nArray3);
            if (n2 == 0) {
                bl2 = (nArray2[0] & 1) != 0;
            }
            OS.RegCloseKey(nArray[0]);
        }
        return bl2;
    }

    boolean isValidThread() {
        return this.thread == Thread.currentThread();
    }

    public Point map(Control control, Control control2, Point point) {
        this.checkDevice();
        if (point == null) {
            this.error(4);
        }
        return this.map(control, control2, point.x, point.y);
    }

    public Point map(Control control, Control control2, int n2, int n3) {
        this.checkDevice();
        if (control != null && control.isDisposed()) {
            this.error(5);
        }
        if (control2 != null && control2.isDisposed()) {
            this.error(5);
        }
        if (control == control2) {
            return new Point(n2, n3);
        }
        int n4 = control != null ? control.handle : 0;
        int n5 = control2 != null ? control2.handle : 0;
        POINT pOINT = new POINT();
        pOINT.x = n2;
        pOINT.y = n3;
        OS.MapWindowPoints(n4, n5, pOINT, 1);
        return new Point(pOINT.x, pOINT.y);
    }

    public Rectangle map(Control control, Control control2, Rectangle rectangle) {
        this.checkDevice();
        if (rectangle == null) {
            this.error(4);
        }
        return this.map(control, control2, rectangle.x, rectangle.y, rectangle.width, rectangle.height);
    }

    public Rectangle map(Control control, Control control2, int n2, int n3, int n4, int n5) {
        this.checkDevice();
        if (control != null && control.isDisposed()) {
            this.error(5);
        }
        if (control2 != null && control2.isDisposed()) {
            this.error(5);
        }
        if (control == control2) {
            return new Rectangle(n2, n3, n4, n5);
        }
        int n6 = control != null ? control.handle : 0;
        int n7 = control2 != null ? control2.handle : 0;
        RECT rECT = new RECT();
        rECT.left = n2;
        rECT.top = n3;
        rECT.right = n2 + n4;
        rECT.bottom = n3 + n5;
        OS.MapWindowPoints(n6, n7, rECT, 2);
        return new Rectangle(rECT.left, rECT.top, rECT.right - rECT.left, rECT.bottom - rECT.top);
    }

    static char mbcsToWcs(int n2) {
        return Display.mbcsToWcs(n2, 0);
    }

    static char mbcsToWcs(int n2, int n3) {
        char[] cArray;
        byte[] byArray;
        if (OS.IsUnicode) {
            return (char)n2;
        }
        int n4 = n2 & 0xFFFF;
        if (n4 <= 127) {
            return (char)n2;
        }
        int n5 = n3 != 0 ? n3 : 0;
        int n6 = OS.MultiByteToWideChar(n5, 1, byArray = n4 <= 255 ? new byte[]{(byte)n4} : new byte[]{(byte)(n4 >> 8 & 0xFF), (byte)(n4 & 0xFF)}, byArray.length, cArray = new char[1], 1);
        if (n6 == 0) {
            return '\u0000';
        }
        return cArray[0];
    }

    int messageProc(int n2, int n3, int n4, int n5) {
        switch (n3) {
            case 32774: {
                if (!this.runMessagesInIdle) break;
                this.runAsyncMessages(false);
                break;
            }
            case 32770: {
                int n6;
                boolean bl2 = false;
                MSG mSG = new MSG();
                OS.MoveMemory(mSG, n5, MSG.sizeof);
                Control control = this.findControl(mSG.hwnd);
                if (control != null) {
                    int n7;
                    n6 = 0;
                    block11 : switch (mSG.message) {
                        case 256: 
                        case 260: {
                            if (OS.IsWinCE) break;
                            switch (mSG.wParam) {
                                case 16: 
                                case 17: 
                                case 18: 
                                case 20: 
                                case 144: 
                                case 145: {
                                    break block11;
                                }
                            }
                            n7 = OS.MapVirtualKey(mSG.wParam, 2);
                            if (n7 == 0) break;
                            int n8 = n6 = (n7 & (OS.IsWinNT ? Integer.MIN_VALUE : 32768)) != 0 ? 1 : 0;
                            if (n6 != 0) break;
                            int n9 = 0;
                            while (n9 < ACCENTS.length) {
                                short s2 = OS.VkKeyScan(ACCENTS[n9]);
                                if (s2 != -1 && (s2 & 0xFF) == mSG.wParam) {
                                    int n10 = s2 >> 8;
                                    if (OS.GetKeyState(16) < 0 == ((n10 & 1) != 0) && OS.GetKeyState(17) < 0 == ((n10 & 2) != 0) && OS.GetKeyState(18) < 0 == ((n10 & 4) != 0)) {
                                        if ((n10 & 7) == 0) break block11;
                                        n6 = 1;
                                        break block11;
                                    }
                                }
                                ++n9;
                            }
                            break;
                        }
                    }
                    if (n6 == 0 && !this.ignoreNextKey) {
                        mSG.hwnd = control.handle;
                        n7 = 10420227;
                        do {
                            if (bl2 |= this.filterMessage(mSG)) continue;
                            OS.TranslateMessage(mSG);
                            bl2 |= OS.DispatchMessage(mSG) == 1;
                        } while (OS.PeekMessage(mSG, mSG.hwnd, 256, 264, n7));
                    }
                    block17 : switch (mSG.message) {
                        case 256: 
                        case 260: {
                            switch (mSG.wParam) {
                                case 16: 
                                case 17: 
                                case 18: 
                                case 20: 
                                case 144: 
                                case 145: {
                                    break block17;
                                }
                            }
                            this.ignoreNextKey = n6;
                        }
                    }
                }
                if (bl2) {
                    n6 = OS.GetProcessHeap();
                    OS.HeapFree(n6, 0, n5);
                } else {
                    OS.PostMessage(this.embeddedHwnd, 32770, n4, n5);
                }
                return 0;
            }
            case 32772: {
                if (this.tray != null) {
                    TrayItem[] trayItemArray = this.tray.items;
                    int n11 = 0;
                    while (n11 < trayItemArray.length) {
                        TrayItem trayItem = trayItemArray[n11];
                        if (trayItem != null && trayItem.id == n4) {
                            return trayItem.messageProc(n2, n3, n4, n5);
                        }
                        ++n11;
                    }
                }
                return 0;
            }
            case 28: {
                int n12;
                Shell shell;
                if (n4 == 0 || this.isXMouseActive()) break;
                if (this.modalDialogShell != null && this.modalDialogShell.isDisposed()) {
                    this.modalDialogShell = null;
                }
                Shell shell2 = shell = this.modalDialogShell != null ? this.modalDialogShell : this.getModalShell();
                if (shell == null) break;
                int n13 = shell.handle;
                if (OS.IsWindowEnabled(n13)) {
                    shell.bringToTop();
                    if (shell.isDisposed()) break;
                }
                if ((n12 = OS.GetLastActivePopup(n13)) == 0 || n12 == shell.handle || this.getControl(n12) != null || !OS.IsWindowEnabled(n12)) break;
                OS.SetActiveWindow(n12);
                break;
            }
            case 22: {
                if (n4 == 0) break;
                this.dispose();
                System.exit(0);
                break;
            }
            case 17: {
                Event event = new Event();
                this.sendEvent(21, event);
                if (event.doit) break;
                return 0;
            }
            case 26: {
                switch (n4) {
                    case 0: 
                    case 1: 
                    case 67: {
                        OS.SetTimer(this.hwndMessage, 100, 2000, 0);
                    }
                }
                break;
            }
            case 794: {
                if (OS.COMCTL32_MAJOR < 6) break;
                if (this.hButtonTheme != 0) {
                    OS.CloseThemeData(this.hButtonTheme);
                }
                if (this.hEditTheme != 0) {
                    OS.CloseThemeData(this.hEditTheme);
                }
                if (this.hExplorerBarTheme != 0) {
                    OS.CloseThemeData(this.hExplorerBarTheme);
                }
                if (this.hScrollBarTheme != 0) {
                    OS.CloseThemeData(this.hScrollBarTheme);
                }
                if (this.hTabTheme != 0) {
                    OS.CloseThemeData(this.hTabTheme);
                }
                this.hTabTheme = 0;
                this.hScrollBarTheme = 0;
                this.hExplorerBarTheme = 0;
                this.hEditTheme = 0;
                this.hButtonTheme = 0;
                break;
            }
            case 275: {
                if (n4 == 100) {
                    OS.KillTimer(this.hwndMessage, 100);
                    this.runSettings();
                    break;
                }
                this.runTimer(n4);
                break;
            }
            default: {
                if (n3 != SWT_TASKBARCREATED || this.tray == null) break;
                TrayItem[] trayItemArray = this.tray.items;
                int n14 = 0;
                while (n14 < trayItemArray.length) {
                    TrayItem trayItem = trayItemArray[n14];
                    if (trayItem != null) {
                        trayItem.recreate();
                    }
                    ++n14;
                }
                break block0;
            }
        }
        return OS.DefWindowProc(n2, n3, n4, n5);
    }

    int monitorEnumProc(int n2, int n3, int n4, int n5) {
        Monitor[] monitorArray;
        if (this.monitorCount >= this.monitors.length) {
            monitorArray = new Monitor[this.monitors.length + 4];
            System.arraycopy(this.monitors, 0, monitorArray, 0, this.monitors.length);
            this.monitors = monitorArray;
        }
        monitorArray = new MONITORINFO();
        monitorArray.cbSize = MONITORINFO.sizeof;
        OS.GetMonitorInfo(n2, (MONITORINFO)monitorArray);
        Monitor monitor = new Monitor();
        monitor.handle = n2;
        monitor.x = monitorArray.rcMonitor_left;
        monitor.y = monitorArray.rcMonitor_top;
        monitor.width = monitorArray.rcMonitor_right - monitorArray.rcMonitor_left;
        monitor.height = monitorArray.rcMonitor_bottom - monitorArray.rcMonitor_top;
        monitor.clientX = monitorArray.rcWork_left;
        monitor.clientY = monitorArray.rcWork_top;
        monitor.clientWidth = monitorArray.rcWork_right - monitorArray.rcWork_left;
        monitor.clientHeight = monitorArray.rcWork_bottom - monitorArray.rcWork_top;
        this.monitors[this.monitorCount++] = monitor;
        return 1;
    }

    int msgFilterProc(int n2, int n3, int n4) {
        switch (n2) {
            case 16896: {
                if (this.runDragDrop) break;
                OS.MoveMemory(this.hookMsg, n4, MSG.sizeof);
                if (this.hookMsg.message != 512) break;
                OS.SendMessage(this.hookMsg.hwnd, 31, 0, 0);
                break;
            }
            case 0: 
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 8: {
                int n5;
                MSG mSG;
                if (!this.runMessages) break;
                OS.MoveMemory(this.hookMsg, n4, MSG.sizeof);
                if (this.hookMsg.message != 0 || OS.PeekMessage(mSG = new MSG(), 0, 0, 0, n5 = 10420226) || !this.runAsyncMessages(false)) break;
                this.wakeThread();
            }
        }
        return OS.CallNextHookEx(this.filterHook, n2, n3, n4);
    }

    int numpadKey(int n2) {
        switch (n2) {
            case 96: {
                return 48;
            }
            case 97: {
                return 49;
            }
            case 98: {
                return 50;
            }
            case 99: {
                return 51;
            }
            case 100: {
                return 52;
            }
            case 101: {
                return 53;
            }
            case 102: {
                return 54;
            }
            case 103: {
                return 55;
            }
            case 104: {
                return 56;
            }
            case 105: {
                return 57;
            }
            case 106: {
                return 42;
            }
            case 107: {
                return 43;
            }
            case 108: {
                return 0;
            }
            case 109: {
                return 45;
            }
            case 110: {
                return 46;
            }
            case 111: {
                return 47;
            }
        }
        return 0;
    }

    /*
     * Unable to fully structure code
     * Could not resolve type clashes
     */
    public boolean post(Event var1_1) {
        if (this.isDisposed()) {
            this.error(45);
        }
        if (var1_1 == null) {
            this.error(4);
        }
        var2_2 = var1_1.type;
        switch (var2_2) {
            case 1: 
            case 2: {
                var3_3 = new KEYBDINPUT();
                var3_3.wVk = (short)Display.untranslateKey(var1_1.keyCode);
                if (var3_3.wVk == 0) {
                    var4_5 = var1_1.character;
                    switch (var4_5) {
                        case '\b': {
                            var3_3.wVk = (short)8;
                            break;
                        }
                        case '\r': {
                            var3_3.wVk = (short)13;
                            break;
                        }
                        case '\u007f': {
                            var3_3.wVk = (short)46;
                            break;
                        }
                        case '\u001b': {
                            var3_3.wVk = (short)27;
                            break;
                        }
                        case '\t': {
                            var3_3.wVk = (short)9;
                            break;
                        }
                        case '\n': {
                            return false;
                        }
                        default: {
                            if (OS.IsWinCE) {
                                var3_3.wVk = OS.CharUpper((short)var4_5);
                                break;
                            }
                            var3_3.wVk = OS.VkKeyScan((short)Display.wcsToMbcs(var4_5, 0));
                            if (var3_3.wVk == -1) {
                                return false;
                            }
                            var3_3.wVk = (short)(var3_3.wVk & 255);
                        }
                    }
                }
                var3_3.dwFlags = var2_2 == 2 ? 2 : 0;
                var4_5 = OS.GetProcessHeap();
                var5_9 = OS.HeapAlloc(var4_5, 8, INPUT.sizeof);
                OS.MoveMemory(var5_9, new int[]{1}, 4);
                OS.MoveMemory(var5_9 + 4, var3_3, KEYBDINPUT.sizeof);
                var6_11 = OS.SendInput(1, var5_9, INPUT.sizeof) != 0;
                OS.HeapFree(var4_5, 0, var5_9);
                return var6_11;
            }
            case 3: 
            case 4: 
            case 5: 
            case 37: {
                var3_4 = new MOUSEINPUT();
                if (var2_2 != 5) ** GOTO lbl67
                var3_4.dwFlags = 32769;
                var4_6 = 0;
                var5_10 = 0;
                var6_12 = 0;
                var7_13 = 0;
                if (OS.WIN32_VERSION >= OS.VERSION(5, 0)) {
                    var3_4.dwFlags |= 16384;
                    var4_6 = OS.GetSystemMetrics(76);
                    var5_10 = OS.GetSystemMetrics(77);
                    var6_12 = OS.GetSystemMetrics(78);
                    var7_13 = OS.GetSystemMetrics(79);
                } else {
                    var6_12 = OS.GetSystemMetrics(0);
                    var7_13 = OS.GetSystemMetrics(1);
                }
                var3_4.dx = ((var1_1.x - var4_6) * 65535 + var6_12 - 2) / (var6_12 - 1);
                var3_4.dy = ((var1_1.y - var5_10) * 65535 + var7_13 - 2) / (var7_13 - 1);
                ** GOTO lbl107
lbl67:
                // 1 sources

                if (var2_2 != 37) ** GOTO lbl83
                if (OS.WIN32_VERSION < OS.VERSION(5, 0)) {
                    return false;
                }
                var3_4.dwFlags = 2048;
                switch (var1_1.detail) {
                    case 2: {
                        var3_4.mouseData = var1_1.count * 120;
                        ** GOTO lbl107
                    }
                    case 1: {
                        var4_7 = new int[1];
                        OS.SystemParametersInfo(104, 0, var4_7, 0);
                        var3_4.mouseData = var1_1.count * 120 / var4_7[0];
                        ** GOTO lbl107
                    }
                    default: {
                        return false;
                    }
                }
lbl83:
                // 1 sources

                switch (var1_1.button) {
                    case 1: {
                        var3_4.dwFlags = var2_2 == 3 ? 2 : 4;
                        break;
                    }
                    case 2: {
                        var3_4.dwFlags = var2_2 == 3 ? 32 : 64;
                        break;
                    }
                    case 3: {
                        var3_4.dwFlags = var2_2 == 3 ? 8 : 16;
                        break;
                    }
                    case 4: {
                        if (OS.WIN32_VERSION < OS.VERSION(5, 0)) {
                            return false;
                        }
                        var3_4.dwFlags = var2_2 == 3 ? 128 : 256;
                        var3_4.mouseData = 1;
                        break;
                    }
                    case 5: {
                        if (OS.WIN32_VERSION < OS.VERSION(5, 0)) {
                            return false;
                        }
                        var3_4.dwFlags = var2_2 == 3 ? 128 : 256;
                        var3_4.mouseData = 2;
                        break;
                    }
                    default: {
                        return false;
                    }
                }
lbl107:
                // 8 sources

                var4_8 = OS.GetProcessHeap();
                var5_10 = OS.HeapAlloc(var4_8, 8, INPUT.sizeof);
                OS.MoveMemory(var5_10, new int[1], 4);
                OS.MoveMemory(var5_10 + 4, var3_4, MOUSEINPUT.sizeof);
                var6_12 = OS.SendInput(1, var5_10, INPUT.sizeof) != 0 ? 1 : 0;
                OS.HeapFree(var4_8, 0, var5_10);
                return (boolean)var6_12;
            }
        }
        return false;
    }

    void postEvent(Event event) {
        if (this.eventQueue == null) {
            this.eventQueue = new Event[4];
        }
        int n2 = 0;
        int n3 = this.eventQueue.length;
        while (n2 < n3) {
            if (this.eventQueue[n2] == null) break;
            ++n2;
        }
        if (n2 == n3) {
            Event[] eventArray = new Event[n3 + 4];
            System.arraycopy(this.eventQueue, 0, eventArray, 0, n3);
            this.eventQueue = eventArray;
        }
        this.eventQueue[n2] = event;
    }

    public boolean readAndDispatch() {
        this.checkDevice();
        lpStartupInfo = null;
        this.drawMenuBars();
        this.runPopups();
        if (OS.PeekMessage(this.msg, 0, 0, 0, 1)) {
            if (!this.filterMessage(this.msg)) {
                OS.TranslateMessage(this.msg);
                OS.DispatchMessage(this.msg);
            }
            this.runDeferredEvents();
            return true;
        }
        return this.runMessages && this.runAsyncMessages(false);
    }

    static synchronized void register(Display display) {
        int n2 = 0;
        while (n2 < Displays.length) {
            if (Displays[n2] == null) {
                Display.Displays[n2] = display;
                return;
            }
            ++n2;
        }
        Display[] displayArray = new Display[Displays.length + 4];
        System.arraycopy(Displays, 0, displayArray, 0, Displays.length);
        displayArray[Display.Displays.length] = display;
        Displays = displayArray;
    }

    protected void release() {
        this.sendEvent(12, new Event());
        Shell[] shellArray = this.getShells();
        int n2 = 0;
        while (n2 < shellArray.length) {
            Shell shell = shellArray[n2];
            if (!shell.isDisposed()) {
                shell.dispose();
            }
            ++n2;
        }
        if (this.tray != null) {
            this.tray.dispose();
        }
        this.tray = null;
        while (this.readAndDispatch()) {
        }
        if (this.disposeList != null) {
            n2 = 0;
            while (n2 < this.disposeList.length) {
                if (this.disposeList[n2] != null) {
                    this.disposeList[n2].run();
                }
                ++n2;
            }
        }
        this.disposeList = null;
        this.synchronizer.releaseSynchronizer();
        this.synchronizer = null;
        this.releaseDisplay();
        super.release();
    }

    void releaseDisplay() {
        if (this.embeddedHwnd != 0) {
            OS.PostMessage(this.embeddedHwnd, 32771, 0, 0);
        }
        if (OS.COMCTL32_MAJOR >= 6) {
            if (this.hButtonTheme != 0) {
                OS.CloseThemeData(this.hButtonTheme);
            }
            if (this.hEditTheme != 0) {
                OS.CloseThemeData(this.hEditTheme);
            }
            if (this.hExplorerBarTheme != 0) {
                OS.CloseThemeData(this.hExplorerBarTheme);
            }
            if (this.hScrollBarTheme != 0) {
                OS.CloseThemeData(this.hScrollBarTheme);
            }
            if (this.hTabTheme != 0) {
                OS.CloseThemeData(this.hTabTheme);
            }
            this.hTabTheme = 0;
            this.hScrollBarTheme = 0;
            this.hExplorerBarTheme = 0;
            this.hEditTheme = 0;
            this.hButtonTheme = 0;
        }
        if (!OS.IsWinCE) {
            if (this.msgHook != 0) {
                OS.UnhookWindowsHookEx(this.msgHook);
            }
            this.msgHook = 0;
        }
        if (!OS.IsWinCE) {
            if (this.filterHook != 0) {
                OS.UnhookWindowsHookEx(this.filterHook);
            }
            this.filterHook = 0;
            this.msgFilterCallback.dispose();
            this.msgFilterCallback = null;
            this.msgFilterProc = 0;
        }
        if (!OS.IsWinCE) {
            if (this.idleHook != 0) {
                OS.UnhookWindowsHookEx(this.idleHook);
            }
            this.idleHook = 0;
            this.foregroundIdleCallback.dispose();
            this.foregroundIdleCallback = null;
            this.foregroundIdleProc = 0;
        }
        if (this.hwndMessage != 0) {
            OS.DestroyWindow(this.hwndMessage);
        }
        this.hwndMessage = 0;
        this.messageCallback.dispose();
        this.messageCallback = null;
        this.messageProc = 0;
        int n2 = OS.GetProcessHeap();
        int n3 = OS.GetModuleHandle(null);
        OS.UnregisterClass(this.windowClass, n3);
        OS.UnregisterClass(this.windowShadowClass, n3);
        this.windowShadowClass = null;
        this.windowClass = null;
        this.windowCallback.dispose();
        this.windowCallback = null;
        this.windowProc = 0;
        if (this.systemFont != null) {
            this.systemFont.dispose();
        }
        this.systemFont = null;
        this.lfSystemFont = null;
        if (this.errorImage != null) {
            this.errorImage.dispose();
        }
        if (this.infoImage != null) {
            this.infoImage.dispose();
        }
        if (this.questionImage != null) {
            this.questionImage.dispose();
        }
        if (this.warningIcon != null) {
            this.warningIcon.dispose();
        }
        this.warningIcon = null;
        this.questionImage = null;
        this.infoImage = null;
        this.errorImage = null;
        if (this.upArrow != null) {
            this.upArrow.dispose();
        }
        if (this.downArrow != null) {
            this.downArrow.dispose();
        }
        this.downArrow = null;
        this.upArrow = null;
        int n4 = 0;
        while (n4 < this.cursors.length) {
            if (this.cursors[n4] != null) {
                this.cursors[n4].dispose();
            }
            ++n4;
        }
        this.cursors = null;
        if (this.resources != null) {
            n4 = 0;
            while (n4 < this.resources.length) {
                if (this.resources[n4] != null) {
                    this.resources[n4].dispose();
                }
                ++n4;
            }
            this.resources = null;
        }
        if (this.lpCustColors != 0) {
            OS.HeapFree(n2, 0, this.lpCustColors);
        }
        this.lpCustColors = 0;
        if (!OS.IsWinCE) {
            OS.OleUninitialize();
        }
        if (!OS.IsWinCE && OS.WIN32_VERSION >= OS.VERSION(6, 0)) {
            OS.BufferedPaintUnInit();
        }
        this.thread = null;
        this.msg = null;
        this.keyboard = null;
        this.modalDialogShell = null;
        this.modalShells = null;
        this.data = null;
        this.keys = null;
        this.values = null;
        this.popups = null;
        this.bars = null;
        this.indexTable = null;
        this.controlTable = null;
        this.lastHittestControl = null;
        this.lastGetControl = null;
        this.lastControl = null;
        this.toolDisabledImageList = null;
        this.toolHotImageList = null;
        this.toolImageList = null;
        this.imageList = null;
    }

    void releaseImageList(ImageList imageList) {
        int n2 = 0;
        int n3 = this.imageList.length;
        while (n2 < n3) {
            if (this.imageList[n2] == imageList) {
                if (imageList.removeRef() > 0) {
                    return;
                }
                imageList.dispose();
                System.arraycopy(this.imageList, n2 + 1, this.imageList, n2, --n3 - n2);
                this.imageList[n3] = null;
                int n4 = 0;
                while (n4 < n3) {
                    if (this.imageList[n4] != null) {
                        return;
                    }
                    ++n4;
                }
                this.imageList = null;
                return;
            }
            ++n2;
        }
    }

    void releaseToolImageList(ImageList imageList) {
        int n2 = 0;
        int n3 = this.toolImageList.length;
        while (n2 < n3) {
            if (this.toolImageList[n2] == imageList) {
                if (imageList.removeRef() > 0) {
                    return;
                }
                imageList.dispose();
                System.arraycopy(this.toolImageList, n2 + 1, this.toolImageList, n2, --n3 - n2);
                this.toolImageList[n3] = null;
                int n4 = 0;
                while (n4 < n3) {
                    if (this.toolImageList[n4] != null) {
                        return;
                    }
                    ++n4;
                }
                this.toolImageList = null;
                return;
            }
            ++n2;
        }
    }

    void releaseToolHotImageList(ImageList imageList) {
        int n2 = 0;
        int n3 = this.toolHotImageList.length;
        while (n2 < n3) {
            if (this.toolHotImageList[n2] == imageList) {
                if (imageList.removeRef() > 0) {
                    return;
                }
                imageList.dispose();
                System.arraycopy(this.toolHotImageList, n2 + 1, this.toolHotImageList, n2, --n3 - n2);
                this.toolHotImageList[n3] = null;
                int n4 = 0;
                while (n4 < n3) {
                    if (this.toolHotImageList[n4] != null) {
                        return;
                    }
                    ++n4;
                }
                this.toolHotImageList = null;
                return;
            }
            ++n2;
        }
    }

    void releaseToolDisabledImageList(ImageList imageList) {
        int n2 = 0;
        int n3 = this.toolDisabledImageList.length;
        while (n2 < n3) {
            if (this.toolDisabledImageList[n2] == imageList) {
                if (imageList.removeRef() > 0) {
                    return;
                }
                imageList.dispose();
                System.arraycopy(this.toolDisabledImageList, n2 + 1, this.toolDisabledImageList, n2, --n3 - n2);
                this.toolDisabledImageList[n3] = null;
                int n4 = 0;
                while (n4 < n3) {
                    if (this.toolDisabledImageList[n4] != null) {
                        return;
                    }
                    ++n4;
                }
                this.toolDisabledImageList = null;
                return;
            }
            ++n2;
        }
    }

    public void removeFilter(int n2, Listener listener) {
        this.checkDevice();
        if (listener == null) {
            this.error(4);
        }
        if (this.filterTable == null) {
            return;
        }
        this.filterTable.unhook(n2, listener);
        if (this.filterTable.size() == 0) {
            this.filterTable = null;
        }
    }

    public void removeListener(int n2, Listener listener) {
        this.checkDevice();
        if (listener == null) {
            this.error(4);
        }
        if (this.eventTable == null) {
            return;
        }
        this.eventTable.unhook(n2, listener);
    }

    void removeBar(Menu menu) {
        if (this.bars == null) {
            return;
        }
        int n2 = 0;
        while (n2 < this.bars.length) {
            if (this.bars[n2] == menu) {
                this.bars[n2] = null;
                return;
            }
            ++n2;
        }
    }

    Control removeControl(int n2) {
        if (n2 == 0) {
            return null;
        }
        this.lastGetControl = null;
        this.lastControl = null;
        Control control = null;
        int n3 = USE_PROPERTY ? OS.RemoveProp(n2, SWT_OBJECT_INDEX) - 1 : OS.GetWindowLong(n2, -21) - 1;
        if (n3 >= 0 && n3 < this.controlTable.length) {
            control = this.controlTable[n3];
            this.controlTable[n3] = null;
            this.indexTable[n3] = this.freeSlot;
            this.freeSlot = n3;
            if (!USE_PROPERTY) {
                OS.SetWindowLong(n2, -21, 0);
            }
        }
        return control;
    }

    void removeMenuItem(MenuItem menuItem) {
        if (this.items == null) {
            return;
        }
        this.items[menuItem.id - 108] = null;
    }

    void removePopup(Menu menu) {
        if (this.popups == null) {
            return;
        }
        int n2 = 0;
        while (n2 < this.popups.length) {
            if (this.popups[n2] == menu) {
                this.popups[n2] = null;
                return;
            }
            ++n2;
        }
    }

    boolean runAsyncMessages(boolean bl2) {
        return this.synchronizer.runAsyncMessages(bl2);
    }

    boolean runDeferredEvents() {
        while (this.eventQueue != null) {
            Widget widget;
            Event event = this.eventQueue[0];
            if (event == null) break;
            int n2 = this.eventQueue.length;
            System.arraycopy(this.eventQueue, 1, this.eventQueue, 0, --n2);
            this.eventQueue[n2] = null;
            Widget widget2 = event.widget;
            if (widget2 == null || widget2.isDisposed() || (widget = event.item) != null && widget.isDisposed()) continue;
            widget2.sendEvent(event);
        }
        this.eventQueue = null;
        return true;
    }

    boolean runPopups() {
        if (this.popups == null) {
            return false;
        }
        boolean bl2 = false;
        while (this.popups != null) {
            Menu menu = this.popups[0];
            if (menu == null) break;
            int n2 = this.popups.length;
            System.arraycopy(this.popups, 1, this.popups, 0, --n2);
            this.popups[n2] = null;
            this.runDeferredEvents();
            if (!menu.isDisposed()) {
                menu._setVisible(true);
            }
            bl2 = true;
        }
        this.popups = null;
        return bl2;
    }

    void runSettings() {
        Font font = this.getSystemFont();
        this.saveResources();
        this.updateImages();
        this.sendEvent(39, null);
        Font font2 = this.getSystemFont();
        boolean bl2 = font.equals(font2);
        Shell[] shellArray = this.getShells();
        int n2 = 0;
        while (n2 < shellArray.length) {
            Shell shell = shellArray[n2];
            if (!shell.isDisposed()) {
                if (!bl2) {
                    shell.updateFont(font, font2);
                }
                shell.layout(true, true);
            }
            ++n2;
        }
    }

    boolean runTimer(int n2) {
        if (this.timerList != null && this.timerIds != null) {
            int n3 = 0;
            while (n3 < this.timerIds.length) {
                if (this.timerIds[n3] == n2) {
                    OS.KillTimer(this.hwndMessage, this.timerIds[n3]);
                    this.timerIds[n3] = 0;
                    Runnable runnable = this.timerList[n3];
                    this.timerList[n3] = null;
                    if (runnable != null) {
                        runnable.run();
                    }
                    return true;
                }
                ++n3;
            }
        }
        return false;
    }

    void saveResources() {
        Object object;
        int n2 = 0;
        if (this.resources == null) {
            this.resources = new Resource[27];
        } else {
            n2 = this.resources.length;
            object = new Resource[n2 + 27];
            System.arraycopy(this.resources, 0, object, 0, n2);
            this.resources = object;
        }
        if (this.systemFont != null && !OS.IsWinCE) {
            object = OS.IsUnicode ? new NONCLIENTMETRICSW() : new NONCLIENTMETRICSA();
            object.cbSize = NONCLIENTMETRICS.sizeof;
            if (OS.SystemParametersInfo(41, 0, (NONCLIENTMETRICS)object, 0)) {
                LOGFONT lOGFONT;
                LOGFONT lOGFONT2 = lOGFONT = OS.IsUnicode ? ((NONCLIENTMETRICSW)object).lfMessageFont : ((NONCLIENTMETRICSA)object).lfMessageFont;
                if (this.lfSystemFont == null || lOGFONT.lfCharSet != this.lfSystemFont.lfCharSet || lOGFONT.lfHeight != this.lfSystemFont.lfHeight || lOGFONT.lfWidth != this.lfSystemFont.lfWidth || lOGFONT.lfEscapement != this.lfSystemFont.lfEscapement || lOGFONT.lfOrientation != this.lfSystemFont.lfOrientation || lOGFONT.lfWeight != this.lfSystemFont.lfWeight || lOGFONT.lfItalic != this.lfSystemFont.lfItalic || lOGFONT.lfUnderline != this.lfSystemFont.lfUnderline || lOGFONT.lfStrikeOut != this.lfSystemFont.lfStrikeOut || lOGFONT.lfCharSet != this.lfSystemFont.lfCharSet || lOGFONT.lfOutPrecision != this.lfSystemFont.lfOutPrecision || lOGFONT.lfClipPrecision != this.lfSystemFont.lfClipPrecision || lOGFONT.lfQuality != this.lfSystemFont.lfQuality || lOGFONT.lfPitchAndFamily != this.lfSystemFont.lfPitchAndFamily || !this.getFontName(lOGFONT).equals(this.getFontName(this.lfSystemFont))) {
                    this.resources[n2++] = this.systemFont;
                    this.lfSystemFont = lOGFONT;
                    this.systemFont = null;
                }
            }
        }
        if (this.errorImage != null) {
            this.resources[n2++] = this.errorImage;
        }
        if (this.infoImage != null) {
            this.resources[n2++] = this.infoImage;
        }
        if (this.questionImage != null) {
            this.resources[n2++] = this.questionImage;
        }
        if (this.warningIcon != null) {
            this.resources[n2++] = this.warningIcon;
        }
        this.warningIcon = null;
        this.questionImage = null;
        this.infoImage = null;
        this.errorImage = null;
        int n3 = 0;
        while (n3 < this.cursors.length) {
            if (this.cursors[n3] != null) {
                this.resources[n2++] = this.cursors[n3];
            }
            this.cursors[n3] = null;
            ++n3;
        }
        if (n2 < 27) {
            Resource[] resourceArray = new Resource[n2];
            System.arraycopy(this.resources, 0, resourceArray, 0, n2);
            this.resources = resourceArray;
        }
    }

    void sendEvent(int n2, Event event) {
        if (this.eventTable == null && this.filterTable == null) {
            return;
        }
        if (event == null) {
            event = new Event();
        }
        event.display = this;
        event.type = n2;
        if (event.time == 0) {
            event.time = this.getLastEventTime();
        }
        if (!this.filterEvent(event) && this.eventTable != null) {
            this.eventTable.sendEvent(event);
        }
    }

    public void setCursorLocation(int n2, int n3) {
        this.checkDevice();
        OS.SetCursorPos(n2, n3);
    }

    public void setCursorLocation(Point point) {
        this.checkDevice();
        if (point == null) {
            this.error(4);
        }
        this.setCursorLocation(point.x, point.y);
    }

    public void setData(String string, Object object) {
        this.checkDevice();
        if (string == null) {
            this.error(4);
        }
        if (string.equals(RUN_MESSAGES_IN_IDLE_KEY)) {
            Boolean bl2 = (Boolean)object;
            this.runMessagesInIdle = bl2 != null && bl2 != false;
            return;
        }
        if (object == null) {
            if (this.keys == null) {
                return;
            }
            int n2 = 0;
            while (n2 < this.keys.length && !this.keys[n2].equals(string)) {
                ++n2;
            }
            if (n2 == this.keys.length) {
                return;
            }
            if (this.keys.length == 1) {
                this.keys = null;
                this.values = null;
            } else {
                String[] stringArray = new String[this.keys.length - 1];
                Object[] objectArray = new Object[this.values.length - 1];
                System.arraycopy(this.keys, 0, stringArray, 0, n2);
                System.arraycopy(this.keys, n2 + 1, stringArray, n2, stringArray.length - n2);
                System.arraycopy(this.values, 0, objectArray, 0, n2);
                System.arraycopy(this.values, n2 + 1, objectArray, n2, objectArray.length - n2);
                this.keys = stringArray;
                this.values = objectArray;
            }
            return;
        }
        if (this.keys == null) {
            this.keys = new String[]{string};
            this.values = new Object[]{object};
            return;
        }
        int n3 = 0;
        while (n3 < this.keys.length) {
            if (this.keys[n3].equals(string)) {
                this.values[n3] = object;
                return;
            }
            ++n3;
        }
        String[] stringArray = new String[this.keys.length + 1];
        Object[] objectArray = new Object[this.values.length + 1];
        System.arraycopy(this.keys, 0, stringArray, 0, this.keys.length);
        System.arraycopy(this.values, 0, objectArray, 0, this.values.length);
        stringArray[this.keys.length] = string;
        objectArray[this.values.length] = object;
        this.keys = stringArray;
        this.values = objectArray;
    }

    public void setData(Object object) {
        this.checkDevice();
        this.data = object;
    }

    public static void setAppName(String string) {
    }

    void setModalDialogShell(Shell shell) {
        if (this.modalDialogShell != null && this.modalDialogShell.isDisposed()) {
            this.modalDialogShell = null;
        }
        this.modalDialogShell = shell;
        Shell[] shellArray = this.getShells();
        int n2 = 0;
        while (n2 < shellArray.length) {
            shellArray[n2].updateModal();
            ++n2;
        }
    }

    void setModalShell(Shell shell) {
        Shell[] shellArray;
        if (this.modalShells == null) {
            this.modalShells = new Shell[4];
        }
        int n2 = 0;
        int n3 = this.modalShells.length;
        while (n2 < n3) {
            if (this.modalShells[n2] == shell) {
                return;
            }
            if (this.modalShells[n2] == null) break;
            ++n2;
        }
        if (n2 == n3) {
            shellArray = new Shell[n3 + 4];
            System.arraycopy(this.modalShells, 0, shellArray, 0, n3);
            this.modalShells = shellArray;
        }
        this.modalShells[n2] = shell;
        shellArray = this.getShells();
        int n4 = 0;
        while (n4 < shellArray.length) {
            shellArray[n4].updateModal();
            ++n4;
        }
    }

    public void setSynchronizer(Synchronizer synchronizer) {
        this.checkDevice();
        if (synchronizer == null) {
            this.error(4);
        }
        if (this.synchronizer != null) {
            this.synchronizer.runAsyncMessages(true);
        }
        this.synchronizer = synchronizer;
    }

    int shiftedKey(int n2) {
        if (OS.IsWinCE) {
            return 0;
        }
        int n3 = 0;
        while (n3 < this.keyboard.length) {
            this.keyboard[n3] = 0;
            ++n3;
        }
        this.keyboard[16] = (byte)(this.keyboard[16] | 0x80);
        if (OS.IsUnicode) {
            char[] cArray = new char[1];
            if (OS.ToUnicode(n2, n2, this.keyboard, cArray, 1, 0) == 1) {
                return cArray[0];
            }
        } else {
            short[] sArray = new short[1];
            if (OS.ToAscii(n2, n2, this.keyboard, sArray, 0) == 1) {
                return sArray[0];
            }
        }
        return 0;
    }

    public boolean sleep() {
        this.checkDevice();
        if (this.runMessages && this.getMessageCount() != 0) {
            return true;
        }
        if (OS.IsWinCE) {
            OS.MsgWaitForMultipleObjectsEx(0, 0, -1, 127, 4);
            return true;
        }
        return OS.WaitMessage();
    }

    public void syncExec(Runnable runnable) {
        if (this.isDisposed()) {
            this.error(45);
        }
        this.synchronizer.syncExec(runnable);
    }

    public void timerExec(int n2, Runnable runnable) {
        int n3;
        this.checkDevice();
        if (runnable == null) {
            this.error(4);
        }
        if (this.timerList == null) {
            this.timerList = new Runnable[4];
        }
        if (this.timerIds == null) {
            this.timerIds = new int[4];
        }
        int n4 = 0;
        while (n4 < this.timerList.length) {
            if (this.timerList[n4] == runnable) break;
            ++n4;
        }
        int n5 = 0;
        if (n4 != this.timerList.length) {
            n5 = this.timerIds[n4];
            if (n2 < 0) {
                OS.KillTimer(this.hwndMessage, n5);
                this.timerList[n4] = null;
                this.timerIds[n4] = 0;
                return;
            }
        } else {
            if (n2 < 0) {
                return;
            }
            n4 = 0;
            while (n4 < this.timerList.length) {
                if (this.timerList[n4] == null) break;
                ++n4;
            }
            n5 = this.nextTimerId++;
            if (n4 == this.timerList.length) {
                Runnable[] runnableArray = new Runnable[this.timerList.length + 4];
                System.arraycopy(this.timerList, 0, runnableArray, 0, this.timerList.length);
                this.timerList = runnableArray;
                int[] nArray = new int[this.timerIds.length + 4];
                System.arraycopy(this.timerIds, 0, nArray, 0, this.timerIds.length);
                this.timerIds = nArray;
            }
        }
        if ((n3 = OS.SetTimer(this.hwndMessage, n5, n2, 0)) != 0) {
            this.timerList[n4] = runnable;
            this.timerIds[n4] = n3;
        }
    }

    boolean translateAccelerator(MSG mSG, Control control) {
        this.accelKeyHit = true;
        boolean bl2 = control.translateAccelerator(mSG);
        this.accelKeyHit = false;
        return bl2;
    }

    static int translateKey(int n2) {
        int n3 = 0;
        while (n3 < KeyTable.length) {
            if (KeyTable[n3][0] == n2) {
                return KeyTable[n3][1];
            }
            ++n3;
        }
        return 0;
    }

    boolean translateMnemonic(MSG mSG, Control control) {
        switch (mSG.message) {
            case 258: 
            case 262: {
                return control.translateMnemonic(mSG);
            }
        }
        return false;
    }

    boolean translateTraversal(MSG mSG, Control control) {
        switch (mSG.message) {
            case 256: {
                switch (mSG.wParam) {
                    case 9: 
                    case 13: 
                    case 27: 
                    case 33: 
                    case 34: 
                    case 37: 
                    case 38: 
                    case 39: 
                    case 40: {
                        return control.translateTraversal(mSG);
                    }
                }
                break;
            }
            case 260: {
                switch (mSG.wParam) {
                    case 18: {
                        return control.translateTraversal(mSG);
                    }
                }
            }
        }
        return false;
    }

    static int untranslateKey(int n2) {
        int n3 = 0;
        while (n3 < KeyTable.length) {
            if (KeyTable[n3][1] == n2) {
                return KeyTable[n3][0];
            }
            ++n3;
        }
        return 0;
    }

    public void update() {
        int n2;
        Object object;
        this.checkDevice();
        if (!OS.IsWinCE && OS.WIN32_VERSION >= OS.VERSION(4, 10) && OS.IsHungAppWindow(this.hwndMessage)) {
            object = new MSG();
            n2 = 3;
            OS.PeekMessage((MSG)object, this.hwndMessage, 32773, 32773, n2);
        }
        object = this.getShells();
        n2 = 0;
        while (n2 < ((Shell[])object).length) {
            Shell shell = object[n2];
            if (!shell.isDisposed()) {
                shell.update(true);
            }
            ++n2;
        }
    }

    void updateImages() {
        if (this.upArrow != null) {
            this.upArrow.dispose();
        }
        if (this.downArrow != null) {
            this.downArrow.dispose();
        }
        this.downArrow = null;
        this.upArrow = null;
        int n2 = 0;
        while (n2 < this.controlTable.length) {
            Control control = this.controlTable[n2];
            if (control != null) {
                control.updateImages();
            }
            ++n2;
        }
    }

    public void wake() {
        if (this.isDisposed()) {
            this.error(45);
        }
        if (this.thread == Thread.currentThread()) {
            return;
        }
        this.wakeThread();
    }

    void wakeThread() {
        if (OS.IsWinCE) {
            OS.PostMessage(this.hwndMessage, 0, 0, 0);
        } else {
            OS.PostThreadMessage(this.threadId, 0, 0, 0);
        }
    }

    static int wcsToMbcs(char c2, int n2) {
        if (OS.IsUnicode) {
            return c2;
        }
        if (c2 <= '\u007f') {
            return c2;
        }
        TCHAR tCHAR = new TCHAR(n2, c2, false);
        return tCHAR.tcharAt(0);
    }

    static int wcsToMbcs(char c2) {
        return Display.wcsToMbcs(c2, 0);
    }

    int windowProc(int n2, int n3, int n4, int n5) {
        Control control;
        if (n3 == 132) {
            if (this.hitCount++ >= 1024) {
                try {
                    Thread.sleep(1L);
                }
                catch (Throwable throwable) {}
            }
        } else {
            this.hitCount = 0;
        }
        if (this.lastControl != null && this.lastHwnd == n2) {
            return this.lastControl.windowProc(n2, n3, n4, n5);
        }
        int n6 = USE_PROPERTY ? OS.GetProp(n2, SWT_OBJECT_INDEX) - 1 : OS.GetWindowLong(n2, -21) - 1;
        if (n6 >= 0 && n6 < this.controlTable.length && (control = this.controlTable[n6]) != null) {
            this.lastHwnd = n2;
            this.lastControl = control;
            return control.windowProc(n2, n3, n4, n5);
        }
        return OS.DefWindowProc(n2, n3, n4, n5);
    }

    static String withCrLf(String string) {
        int n2 = string.length();
        if (n2 == 0) {
            return string;
        }
        int n3 = string.indexOf(10, 0);
        if (n3 == -1) {
            return string;
        }
        if (n3 > 0 && string.charAt(n3 - 1) == '\r') {
            return string;
        }
        ++n3;
        int n4 = 1;
        while (n3 < n2) {
            if ((n3 = string.indexOf(10, n3)) == -1) break;
            ++n4;
            ++n3;
        }
        n3 = 0;
        StringBuffer stringBuffer = new StringBuffer(n4 += n2);
        while (n3 < n2) {
            int n5 = string.indexOf(10, n3);
            if (n5 == -1) {
                n5 = n2;
            }
            stringBuffer.append(string.substring(n3, n5));
            n3 = n5;
            if (n3 >= n2) continue;
            stringBuffer.append("\r\n");
            ++n3;
        }
        return stringBuffer.toString();
    }
}

