/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.opengl;

import java.nio.Buffer;
import java.nio.ByteBuffer;
import java.nio.DoubleBuffer;
import java.nio.FloatBuffer;
import java.nio.IntBuffer;
import java.nio.ShortBuffer;
import org.lwjgl.BufferChecks;
import org.lwjgl.NondirectBufferWrapper;
import org.lwjgl.opengl.ContextCapabilities;
import org.lwjgl.opengl.GLContext;

public final class ATIVertexArrayObject {
    public static final int GL_STATIC_ATI = 34656;
    public static final int GL_DYNAMIC_ATI = 34657;
    public static final int GL_PRESERVE_ATI = 34658;
    public static final int GL_DISCARD_ATI = 34659;
    public static final int GL_OBJECT_BUFFER_SIZE_ATI = 34660;
    public static final int GL_OBJECT_BUFFER_USAGE_ATI = 34661;
    public static final int GL_ARRAY_OBJECT_BUFFER_ATI = 34662;
    public static final int GL_ARRAY_OBJECT_OFFSET_ATI = 34663;

    private ATIVertexArrayObject() {
    }

    public static int glNewObjectBufferATI(int n2, int n3) {
        ContextCapabilities contextCapabilities = GLContext.getCapabilities();
        long l2 = contextCapabilities.ATI_vertex_array_object_glNewObjectBufferATI_pointer;
        BufferChecks.checkFunctionAddress(l2);
        int n4 = ATIVertexArrayObject.nglNewObjectBufferATI(n2, null, 0, n3, l2);
        return n4;
    }

    public static int glNewObjectBufferATI(ByteBuffer byteBuffer, int n2) {
        ContextCapabilities contextCapabilities = GLContext.getCapabilities();
        long l2 = contextCapabilities.ATI_vertex_array_object_glNewObjectBufferATI_pointer;
        BufferChecks.checkFunctionAddress(l2);
        byteBuffer = NondirectBufferWrapper.wrapDirect(byteBuffer);
        int n3 = ATIVertexArrayObject.nglNewObjectBufferATI(byteBuffer.remaining(), byteBuffer, byteBuffer.position(), n2, l2);
        return n3;
    }

    public static int glNewObjectBufferATI(DoubleBuffer doubleBuffer, int n2) {
        ContextCapabilities contextCapabilities = GLContext.getCapabilities();
        long l2 = contextCapabilities.ATI_vertex_array_object_glNewObjectBufferATI_pointer;
        BufferChecks.checkFunctionAddress(l2);
        doubleBuffer = NondirectBufferWrapper.wrapDirect(doubleBuffer);
        int n3 = ATIVertexArrayObject.nglNewObjectBufferATI(doubleBuffer.remaining() << 3, doubleBuffer, doubleBuffer.position() << 3, n2, l2);
        return n3;
    }

    public static int glNewObjectBufferATI(FloatBuffer floatBuffer, int n2) {
        ContextCapabilities contextCapabilities = GLContext.getCapabilities();
        long l2 = contextCapabilities.ATI_vertex_array_object_glNewObjectBufferATI_pointer;
        BufferChecks.checkFunctionAddress(l2);
        floatBuffer = NondirectBufferWrapper.wrapDirect(floatBuffer);
        int n3 = ATIVertexArrayObject.nglNewObjectBufferATI(floatBuffer.remaining() << 2, floatBuffer, floatBuffer.position() << 2, n2, l2);
        return n3;
    }

    public static int glNewObjectBufferATI(IntBuffer intBuffer, int n2) {
        ContextCapabilities contextCapabilities = GLContext.getCapabilities();
        long l2 = contextCapabilities.ATI_vertex_array_object_glNewObjectBufferATI_pointer;
        BufferChecks.checkFunctionAddress(l2);
        intBuffer = NondirectBufferWrapper.wrapDirect(intBuffer);
        int n3 = ATIVertexArrayObject.nglNewObjectBufferATI(intBuffer.remaining() << 2, intBuffer, intBuffer.position() << 2, n2, l2);
        return n3;
    }

    public static int glNewObjectBufferATI(ShortBuffer shortBuffer, int n2) {
        ContextCapabilities contextCapabilities = GLContext.getCapabilities();
        long l2 = contextCapabilities.ATI_vertex_array_object_glNewObjectBufferATI_pointer;
        BufferChecks.checkFunctionAddress(l2);
        shortBuffer = NondirectBufferWrapper.wrapDirect(shortBuffer);
        int n3 = ATIVertexArrayObject.nglNewObjectBufferATI(shortBuffer.remaining() << 1, shortBuffer, shortBuffer.position() << 1, n2, l2);
        return n3;
    }

    private static native int nglNewObjectBufferATI(int var0, Buffer var1, int var2, int var3, long var4);

    public static boolean glIsObjectBufferATI(int n2) {
        ContextCapabilities contextCapabilities = GLContext.getCapabilities();
        long l2 = contextCapabilities.ATI_vertex_array_object_glIsObjectBufferATI_pointer;
        BufferChecks.checkFunctionAddress(l2);
        boolean bl2 = ATIVertexArrayObject.nglIsObjectBufferATI(n2, l2);
        return bl2;
    }

    private static native boolean nglIsObjectBufferATI(int var0, long var1);

    public static void glUpdateObjectBufferATI(int n2, int n3, ByteBuffer byteBuffer, int n4) {
        ContextCapabilities contextCapabilities = GLContext.getCapabilities();
        long l2 = contextCapabilities.ATI_vertex_array_object_glUpdateObjectBufferATI_pointer;
        BufferChecks.checkFunctionAddress(l2);
        byteBuffer = NondirectBufferWrapper.wrapDirect(byteBuffer);
        ATIVertexArrayObject.nglUpdateObjectBufferATI(n2, n3, byteBuffer.remaining(), byteBuffer, byteBuffer.position(), n4, l2);
    }

    public static void glUpdateObjectBufferATI(int n2, int n3, DoubleBuffer doubleBuffer, int n4) {
        ContextCapabilities contextCapabilities = GLContext.getCapabilities();
        long l2 = contextCapabilities.ATI_vertex_array_object_glUpdateObjectBufferATI_pointer;
        BufferChecks.checkFunctionAddress(l2);
        doubleBuffer = NondirectBufferWrapper.wrapDirect(doubleBuffer);
        ATIVertexArrayObject.nglUpdateObjectBufferATI(n2, n3, doubleBuffer.remaining() << 3, doubleBuffer, doubleBuffer.position() << 3, n4, l2);
    }

    public static void glUpdateObjectBufferATI(int n2, int n3, FloatBuffer floatBuffer, int n4) {
        ContextCapabilities contextCapabilities = GLContext.getCapabilities();
        long l2 = contextCapabilities.ATI_vertex_array_object_glUpdateObjectBufferATI_pointer;
        BufferChecks.checkFunctionAddress(l2);
        floatBuffer = NondirectBufferWrapper.wrapDirect(floatBuffer);
        ATIVertexArrayObject.nglUpdateObjectBufferATI(n2, n3, floatBuffer.remaining() << 2, floatBuffer, floatBuffer.position() << 2, n4, l2);
    }

    public static void glUpdateObjectBufferATI(int n2, int n3, IntBuffer intBuffer, int n4) {
        ContextCapabilities contextCapabilities = GLContext.getCapabilities();
        long l2 = contextCapabilities.ATI_vertex_array_object_glUpdateObjectBufferATI_pointer;
        BufferChecks.checkFunctionAddress(l2);
        intBuffer = NondirectBufferWrapper.wrapDirect(intBuffer);
        ATIVertexArrayObject.nglUpdateObjectBufferATI(n2, n3, intBuffer.remaining() << 2, intBuffer, intBuffer.position() << 2, n4, l2);
    }

    public static void glUpdateObjectBufferATI(int n2, int n3, ShortBuffer shortBuffer, int n4) {
        ContextCapabilities contextCapabilities = GLContext.getCapabilities();
        long l2 = contextCapabilities.ATI_vertex_array_object_glUpdateObjectBufferATI_pointer;
        BufferChecks.checkFunctionAddress(l2);
        shortBuffer = NondirectBufferWrapper.wrapDirect(shortBuffer);
        ATIVertexArrayObject.nglUpdateObjectBufferATI(n2, n3, shortBuffer.remaining() << 1, shortBuffer, shortBuffer.position() << 1, n4, l2);
    }

    private static native void nglUpdateObjectBufferATI(int var0, int var1, int var2, Buffer var3, int var4, int var5, long var6);

    public static void glGetObjectBufferATI(int n2, int n3, FloatBuffer floatBuffer) {
        ContextCapabilities contextCapabilities = GLContext.getCapabilities();
        long l2 = contextCapabilities.ATI_vertex_array_object_glGetObjectBufferfvATI_pointer;
        BufferChecks.checkFunctionAddress(l2);
        FloatBuffer floatBuffer2 = floatBuffer;
        floatBuffer = NondirectBufferWrapper.wrapNoCopyDirect(floatBuffer);
        ATIVertexArrayObject.nglGetObjectBufferfvATI(n2, n3, floatBuffer, floatBuffer.position(), l2);
        NondirectBufferWrapper.copy(floatBuffer, floatBuffer2);
    }

    private static native void nglGetObjectBufferfvATI(int var0, int var1, FloatBuffer var2, int var3, long var4);

    public static void glGetObjectBufferATI(int n2, int n3, IntBuffer intBuffer) {
        ContextCapabilities contextCapabilities = GLContext.getCapabilities();
        long l2 = contextCapabilities.ATI_vertex_array_object_glGetObjectBufferivATI_pointer;
        BufferChecks.checkFunctionAddress(l2);
        IntBuffer intBuffer2 = intBuffer;
        intBuffer = NondirectBufferWrapper.wrapNoCopyDirect(intBuffer);
        ATIVertexArrayObject.nglGetObjectBufferivATI(n2, n3, intBuffer, intBuffer.position(), l2);
        NondirectBufferWrapper.copy(intBuffer, intBuffer2);
    }

    private static native void nglGetObjectBufferivATI(int var0, int var1, IntBuffer var2, int var3, long var4);

    public static void glFreeObjectBufferATI(int n2) {
        ContextCapabilities contextCapabilities = GLContext.getCapabilities();
        long l2 = contextCapabilities.ATI_vertex_array_object_glFreeObjectBufferATI_pointer;
        BufferChecks.checkFunctionAddress(l2);
        ATIVertexArrayObject.nglFreeObjectBufferATI(n2, l2);
    }

    private static native void nglFreeObjectBufferATI(int var0, long var1);

    public static void glArrayObjectATI(int n2, int n3, int n4, int n5, int n6, int n7) {
        ContextCapabilities contextCapabilities = GLContext.getCapabilities();
        long l2 = contextCapabilities.ATI_vertex_array_object_glArrayObjectATI_pointer;
        BufferChecks.checkFunctionAddress(l2);
        ATIVertexArrayObject.nglArrayObjectATI(n2, n3, n4, n5, n6, n7, l2);
    }

    private static native void nglArrayObjectATI(int var0, int var1, int var2, int var3, int var4, int var5, long var6);

    public static void glGetArrayObjectATI(int n2, int n3, FloatBuffer floatBuffer) {
        ContextCapabilities contextCapabilities = GLContext.getCapabilities();
        long l2 = contextCapabilities.ATI_vertex_array_object_glGetArrayObjectfvATI_pointer;
        BufferChecks.checkFunctionAddress(l2);
        FloatBuffer floatBuffer2 = floatBuffer;
        floatBuffer = NondirectBufferWrapper.wrapNoCopyBuffer(floatBuffer, 4);
        ATIVertexArrayObject.nglGetArrayObjectfvATI(n2, n3, floatBuffer, floatBuffer.position(), l2);
        NondirectBufferWrapper.copy(floatBuffer, floatBuffer2);
    }

    private static native void nglGetArrayObjectfvATI(int var0, int var1, FloatBuffer var2, int var3, long var4);

    public static void glGetArrayObjectATI(int n2, int n3, IntBuffer intBuffer) {
        ContextCapabilities contextCapabilities = GLContext.getCapabilities();
        long l2 = contextCapabilities.ATI_vertex_array_object_glGetArrayObjectivATI_pointer;
        BufferChecks.checkFunctionAddress(l2);
        IntBuffer intBuffer2 = intBuffer;
        intBuffer = NondirectBufferWrapper.wrapNoCopyBuffer(intBuffer, 4);
        ATIVertexArrayObject.nglGetArrayObjectivATI(n2, n3, intBuffer, intBuffer.position(), l2);
        NondirectBufferWrapper.copy(intBuffer, intBuffer2);
    }

    private static native void nglGetArrayObjectivATI(int var0, int var1, IntBuffer var2, int var3, long var4);

    public static void glVariantArrayObjectATI(int n2, int n3, int n4, int n5, int n6) {
        ContextCapabilities contextCapabilities = GLContext.getCapabilities();
        long l2 = contextCapabilities.ATI_vertex_array_object_glVariantArrayObjectATI_pointer;
        BufferChecks.checkFunctionAddress(l2);
        ATIVertexArrayObject.nglVariantArrayObjectATI(n2, n3, n4, n5, n6, l2);
    }

    private static native void nglVariantArrayObjectATI(int var0, int var1, int var2, int var3, int var4, long var5);

    public static void glGetVariantArrayObjectATI(int n2, int n3, FloatBuffer floatBuffer) {
        ContextCapabilities contextCapabilities = GLContext.getCapabilities();
        long l2 = contextCapabilities.ATI_vertex_array_object_glGetVariantArrayObjectfvATI_pointer;
        BufferChecks.checkFunctionAddress(l2);
        FloatBuffer floatBuffer2 = floatBuffer;
        floatBuffer = NondirectBufferWrapper.wrapNoCopyBuffer(floatBuffer, 4);
        ATIVertexArrayObject.nglGetVariantArrayObjectfvATI(n2, n3, floatBuffer, floatBuffer.position(), l2);
        NondirectBufferWrapper.copy(floatBuffer, floatBuffer2);
    }

    private static native void nglGetVariantArrayObjectfvATI(int var0, int var1, FloatBuffer var2, int var3, long var4);

    public static void glGetVariantArrayObjectATI(int n2, int n3, IntBuffer intBuffer) {
        ContextCapabilities contextCapabilities = GLContext.getCapabilities();
        long l2 = contextCapabilities.ATI_vertex_array_object_glGetVariantArrayObjectivATI_pointer;
        BufferChecks.checkFunctionAddress(l2);
        IntBuffer intBuffer2 = intBuffer;
        intBuffer = NondirectBufferWrapper.wrapNoCopyBuffer(intBuffer, 4);
        ATIVertexArrayObject.nglGetVariantArrayObjectivATI(n2, n3, intBuffer, intBuffer.position(), l2);
        NondirectBufferWrapper.copy(intBuffer, intBuffer2);
    }

    private static native void nglGetVariantArrayObjectivATI(int var0, int var1, IntBuffer var2, int var3, long var4);
}

