/*
 * Decompiled with CFR 0.152.
 */
package com.sun.corba.se.internal.iiop;

import com.sun.corba.se.internal.core.CodeSetComponentInfo;
import com.sun.corba.se.internal.core.CodeSetConversion;
import com.sun.corba.se.internal.core.GIOPVersion;
import com.sun.corba.se.internal.core.OSFCodeSetRegistry;
import com.sun.corba.se.internal.iiop.CDRInputStream;
import com.sun.corba.se.internal.iiop.Connection;
import com.sun.corba.se.internal.iiop.ORB;
import com.sun.corba.se.internal.iiop.messages.Message;
import com.sun.corba.se.internal.orbutil.ORBUtility;
import com.sun.org.omg.SendingContext.CodeBase;
import java.io.IOException;
import org.omg.CORBA.BAD_PARAM;
import org.omg.CORBA.CompletionStatus;
import org.omg.CORBA.INV_OBJREF;
import org.omg.CORBA.MARSHAL;

public class IIOPInputStream
extends CDRInputStream {
    protected Connection conn;
    protected Message msg = null;
    private boolean unmarshaledHeader;

    public IIOPInputStream() {
    }

    public void unmarshalHeader() {
        if (!this.unmarshaledHeader) {
            this.msg.read(this);
            this.unmarshaledHeader = true;
        }
    }

    public final boolean unmarshaledHeader() {
        return this.unmarshaledHeader;
    }

    protected void grow(int n2, int n3) {
        throw new MARSHAL(1398079694, CompletionStatus.COMPLETED_MAYBE);
    }

    private CodeSetComponentInfo.CodeSetContext getCodeSets() {
        if (this.conn == null) {
            return CodeSetComponentInfo.LOCAL_CODE_SETS;
        }
        return this.conn.getCodeSetContext();
    }

    protected CodeSetConversion.BTCConverter createCharBTCConverter() {
        CodeSetComponentInfo.CodeSetContext codeSetContext = this.getCodeSets();
        if (codeSetContext == null) {
            return super.createCharBTCConverter();
        }
        OSFCodeSetRegistry.Entry entry = OSFCodeSetRegistry.lookupEntry(codeSetContext.getCharCodeSet());
        if (entry == null) {
            throw new MARSHAL("Unknown char set: " + entry, 1398079704, CompletionStatus.COMPLETED_NO);
        }
        return CodeSetConversion.impl().getBTCConverter(entry, this.isLittleEndian());
    }

    protected CodeSetConversion.BTCConverter createWCharBTCConverter() {
        CodeSetComponentInfo.CodeSetContext codeSetContext = this.getCodeSets();
        if (codeSetContext == null) {
            if (this.conn.isServer()) {
                throw new BAD_PARAM(1330446359, CompletionStatus.COMPLETED_MAYBE);
            }
            throw new INV_OBJREF(1330446337, CompletionStatus.COMPLETED_NO);
        }
        OSFCodeSetRegistry.Entry entry = OSFCodeSetRegistry.lookupEntry(codeSetContext.getWCharCodeSet());
        if (entry == null) {
            throw new MARSHAL("Unknown wchar set: " + entry, 1398079704, CompletionStatus.COMPLETED_NO);
        }
        if (entry == OSFCodeSetRegistry.UTF_16 && this.getGIOPVersion().equals(GIOPVersion.V1_2)) {
            return CodeSetConversion.impl().getBTCConverter(entry, false);
        }
        return CodeSetConversion.impl().getBTCConverter(entry, this.isLittleEndian());
    }

    public CDRInputStream dup() {
        return new IIOPInputStream(this);
    }

    public final Connection getConnection() {
        return this.conn;
    }

    private IIOPInputStream(IIOPInputStream iIOPInputStream) {
        super(iIOPInputStream);
        this.conn = iIOPInputStream.conn;
        this.msg = iIOPInputStream.msg;
        this.unmarshaledHeader = iIOPInputStream.unmarshaledHeader;
    }

    public final Message getMessage() {
        return this.msg;
    }

    public CodeBase getCodeBase() {
        if (this.conn == null) {
            return null;
        }
        return this.conn.getCodeBase();
    }

    private void dprint(String string) {
        ORBUtility.dprint(this, string);
    }

    public IIOPInputStream(Connection connection, byte[] byArray, Message message) throws IOException {
        super(connection.getORB(), byArray, message.getSize(), message.isLittleEndian(), message.getGIOPVersion());
        this.getBufferManager().init(message);
        this.conn = connection;
        ORB oRB = connection.getORB();
        if (oRB.transportDebugFlag) {
            this.dprint("Constructing IIOPInputStream object");
        }
        this.msg = message;
        this.unmarshaledHeader = false;
        this.setIndex(12);
        this.setBufferLength(this.msg.getSize());
        if (oRB.transportDebugFlag) {
            this.dprint("Setting the time stamp");
        }
        connection.stampTime();
    }

    public IIOPInputStream(ORB oRB, byte[] byArray, int n2, boolean bl2, Message message, Connection connection) {
        super(oRB, byArray, n2, bl2, message.getGIOPVersion(), false);
        this.getBufferManager().init(message);
        this.unmarshaledHeader = true;
        this.msg = message;
        this.conn = connection;
    }
}

