/*
 * Decompiled with CFR 0.152.
 */
package com.sun.java.swing;

import java.awt.AWTEvent;
import java.awt.EventQueue;
import java.awt.Font;
import java.awt.GraphicsEnvironment;
import java.awt.Rectangle;
import java.awt.event.InputEvent;
import java.awt.event.KeyEvent;
import java.awt.font.FontRenderContext;
import java.awt.font.GlyphVector;
import java.lang.reflect.Field;
import java.security.AccessController;
import java.security.PrivilegedAction;
import sun.awt.AppContext;

public class SwingUtilities2 {
    private static final FontRenderContext DEFAULT_FRC = new FontRenderContext(null, false, false);
    private static final byte UNSET = 127;
    private static final int MIN_CHAR_INDEX = 87;
    private static final int MAX_CHAR_INDEX = 88;
    private static final int CACHE_SIZE = 6;
    private static int nextIndex;
    private static byte[][] lsbCache;
    private static Font[] fontCache;
    private static final char[] oneChar;
    private static Field inputEvent_CanAccessSystemClipboard_Field;
    private static final String UntrustedClipboardAccess = "UNTRUSTED_CLIPBOARD_ACCESS_KEY";
    static /* synthetic */ Class class$java$awt$event$InputEvent;

    static {
        oneChar = new char[1];
        inputEvent_CanAccessSystemClipboard_Field = null;
        fontCache = new Font[6];
        lsbCache = new byte[6][];
        for (int i2 = 0; i2 < 6; ++i2) {
            SwingUtilities2.lsbCache[i2] = new byte[1];
            SwingUtilities2.reset(lsbCache[i2]);
        }
    }

    public static boolean canAccessSystemClipboard() {
        boolean bl2 = false;
        if (!GraphicsEnvironment.isHeadless()) {
            SecurityManager securityManager = System.getSecurityManager();
            if (securityManager == null) {
                bl2 = true;
            } else {
                try {
                    securityManager.checkSystemClipboardAccess();
                    bl2 = true;
                }
                catch (SecurityException securityException) {
                    // empty catch block
                }
                if (bl2 && !SwingUtilities2.isTrustedContext()) {
                    bl2 = SwingUtilities2.canCurrentEventAccessSystemClipboard(true);
                }
            }
        }
        return bl2;
    }

    public static boolean canCurrentEventAccessSystemClipboard() {
        return SwingUtilities2.isTrustedContext() || SwingUtilities2.canCurrentEventAccessSystemClipboard(false);
    }

    private static boolean isTrustedContext() {
        return System.getSecurityManager() == null || AppContext.getAppContext().get(UntrustedClipboardAccess) == null;
    }

    private static boolean canCurrentEventAccessSystemClipboard(boolean bl2) {
        AWTEvent aWTEvent = EventQueue.getCurrentEvent();
        return SwingUtilities2.canEventAccessSystemClipboard(aWTEvent, bl2);
    }

    private static void reset(byte[] byArray) {
        for (int i2 = byArray.length - 1; i2 >= 0; --i2) {
            byArray[i2] = 127;
        }
    }

    public static boolean canEventAccessSystemClipboard(AWTEvent aWTEvent) {
        return SwingUtilities2.isTrustedContext() || SwingUtilities2.canEventAccessSystemClipboard(aWTEvent, false);
    }

    private static boolean canEventAccessSystemClipboard(AWTEvent aWTEvent, boolean bl2) {
        if (EventQueue.isDispatchThread()) {
            if (aWTEvent instanceof InputEvent && (!bl2 || SwingUtilities2.isAccessClipboardGesture((InputEvent)aWTEvent))) {
                return SwingUtilities2.inputEvent_canAccessSystemClipboard((InputEvent)aWTEvent);
            }
            return false;
        }
        return true;
    }

    private static int _getLeftSideBearing(Font font, char c2) {
        SwingUtilities2.oneChar[0] = c2;
        GlyphVector glyphVector = font.createGlyphVector(DEFAULT_FRC, oneChar);
        Rectangle rectangle = glyphVector.getGlyphPixelBounds(0, DEFAULT_FRC, 0.0f, 0.0f);
        return rectangle.x;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static int getLeftSideBearing(Font font, char n2) {
        int n3 = n2;
        if (n3 < 88 && n3 >= 87) {
            byte[] byArray = null;
            n3 -= 87;
            Class clazz = SwingUtilities2.class;
            synchronized (clazz) {
                for (int i2 = 5; i2 >= 0; --i2) {
                    if (fontCache[i2] == null) {
                        SwingUtilities2.fontCache[i2] = font;
                        byArray = lsbCache[i2];
                        break;
                    }
                    if (!fontCache[i2].equals(font)) continue;
                    byArray = lsbCache[i2];
                    break;
                }
                if (byArray == null) {
                    byArray = lsbCache[nextIndex];
                    SwingUtilities2.reset(byArray);
                    SwingUtilities2.fontCache[SwingUtilities2.nextIndex] = font;
                    nextIndex = (nextIndex + 1) % 6;
                }
                if (byArray[n3] == 127) {
                    byArray[n3] = (byte)SwingUtilities2._getLeftSideBearing(font, (char)n2);
                }
                return byArray[n3];
            }
        }
        return 0;
    }

    private static synchronized boolean inputEvent_canAccessSystemClipboard(InputEvent inputEvent) {
        if (inputEvent_CanAccessSystemClipboard_Field == null) {
            inputEvent_CanAccessSystemClipboard_Field = (Field)AccessController.doPrivileged(new PrivilegedAction(){

                public Object run() {
                    Field field = null;
                    try {
                        field = (class$java$awt$event$InputEvent == null ? (class$java$awt$event$InputEvent = SwingUtilities2.class$("java.awt.event.InputEvent")) : class$java$awt$event$InputEvent).getDeclaredField("canAccessSystemClipboard");
                        field.setAccessible(true);
                        return field;
                    }
                    catch (SecurityException securityException) {
                    }
                    catch (NoSuchFieldException noSuchFieldException) {
                        // empty catch block
                    }
                    return null;
                }
            });
        }
        if (inputEvent_CanAccessSystemClipboard_Field == null) {
            return false;
        }
        boolean bl2 = false;
        try {
            bl2 = inputEvent_CanAccessSystemClipboard_Field.getBoolean(inputEvent);
        }
        catch (IllegalAccessException illegalAccessException) {
            // empty catch block
        }
        return bl2;
    }

    private static boolean isAccessClipboardGesture(InputEvent inputEvent) {
        boolean bl2 = false;
        if (inputEvent instanceof KeyEvent) {
            KeyEvent keyEvent = (KeyEvent)inputEvent;
            int n2 = keyEvent.getKeyCode();
            int n3 = keyEvent.getModifiers();
            switch (n2) {
                case 67: 
                case 86: 
                case 88: {
                    bl2 = n3 == 2;
                    break;
                }
                case 155: {
                    bl2 = n3 == 2 || n3 == 1;
                    break;
                }
                case 65485: 
                case 65487: 
                case 65489: {
                    bl2 = true;
                    break;
                }
                case 127: {
                    bl2 = n3 == 1;
                }
            }
        }
        return bl2;
    }

    public static int getLeftSideBearing(Font font, String string) {
        char c2 = string.charAt(0);
        return SwingUtilities2.getLeftSideBearing(font, string.charAt(0));
    }
}

