/*
 * Decompiled with CFR 0.152.
 */
package java.awt;

import java.awt.FontFormatException;
import java.awt.GraphicsEnvironment;
import java.awt.Toolkit;
import java.awt.font.FontRenderContext;
import java.awt.font.GlyphVector;
import java.awt.font.LineMetrics;
import java.awt.font.TextAttribute;
import java.awt.font.TextLayout;
import java.awt.font.TransformAttribute;
import java.awt.geom.AffineTransform;
import java.awt.geom.Rectangle2D;
import java.awt.peer.FontPeer;
import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.lang.ref.SoftReference;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.text.AttributedCharacterIterator;
import java.text.CharacterIterator;
import java.text.StringCharacterIterator;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Locale;
import java.util.Map;
import sun.awt.font.NativeFontWrapper;
import sun.awt.font.StandardGlyphVector;
import sun.java2d.FontSupport;
import sun.java2d.SunGraphicsEnvironment;

public class Font
implements Serializable {
    private Hashtable fRequestedAttributes;
    private static final Map EMPTY_MAP;
    private static final TransformAttribute IDENT_TX_ATTRIBUTE;
    public static final int PLAIN = 0;
    public static final int BOLD = 1;
    public static final int ITALIC = 2;
    public static final int ROMAN_BASELINE = 0;
    public static final int CENTER_BASELINE = 1;
    public static final int HANGING_BASELINE = 2;
    public static final int TRUETYPE_FONT = 0;
    protected String name;
    protected int style;
    protected int size;
    protected float pointSize;
    private transient FontPeer peer;
    private transient long pData;
    private transient long pNativeFont;
    private transient boolean createdFont = false;
    private transient int numGlyphs = -1;
    private transient int missingGlyph = -1;
    private transient int canRotate = -1;
    private transient double[] matrix;
    private transient boolean nonIdentityTx;
    private static final long serialVersionUID = -4206021311591459213L;
    private static SoftReference cacheRef;
    private int fontSerializedDataVersion = 1;
    private static double[] cachedMat;
    public static final int LAYOUT_LEFT_TO_RIGHT = 0;
    public static final int LAYOUT_RIGHT_TO_LEFT = 1;
    public static final int LAYOUT_NO_START_CONTEXT = 2;
    public static final int LAYOUT_NO_LIMIT_CONTEXT = 4;

    public float getItalicAngle() {
        double[] dArray = this.getMatrix();
        return NativeFontWrapper.getItalicAngle(this, dArray, false, false);
    }

    public float getSize2D() {
        return this.pointSize;
    }

    public int getMissingGlyphCode() {
        if (this.missingGlyph == -1) {
            this.missingGlyph = NativeFontWrapper.getMissingGlyphCode(this);
        }
        return this.missingGlyph;
    }

    public int getNumGlyphs() {
        if (this.numGlyphs == -1) {
            this.numGlyphs = NativeFontWrapper.getNumGlyphs(this);
        }
        return this.numGlyphs;
    }

    public int getSize() {
        return this.size;
    }

    public int getStyle() {
        return this.style;
    }

    public int hashCode() {
        return this.name.hashCode() ^ this.style ^ this.size;
    }

    static {
        Toolkit.loadLibraries();
        Font.initIDs();
        EMPTY_MAP = new Hashtable(5, 0.9f);
        IDENT_TX_ATTRIBUTE = new TransformAttribute(new AffineTransform());
        cacheRef = new SoftReference(new HashMap());
    }

    protected void finalize() throws Throwable {
        if (this.peer != null) {
            this.pDispose();
        }
        super.finalize();
    }

    private static native void initIDs();

    private native void pDispose();

    public boolean hasUniformLineMetrics() {
        return false;
    }

    public boolean isBold() {
        return (this.style & 1) != 0;
    }

    public boolean isItalic() {
        return (this.style & 2) != 0;
    }

    public boolean isPlain() {
        return this.style == 0;
    }

    public boolean isTransformed() {
        return this.nonIdentityTx;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private double[] getMatrix() {
        if (this.matrix == null) {
            double d2 = this.getSize2D();
            if (this.nonIdentityTx) {
                AffineTransform affineTransform = this.getTransform();
                affineTransform.scale(d2, d2);
                this.matrix = new double[]{affineTransform.getScaleX(), affineTransform.getShearY(), affineTransform.getShearX(), affineTransform.getScaleY()};
            } else {
                Class clazz = Font.class;
                synchronized (clazz) {
                    double[] dArray = cachedMat;
                    if (dArray == null || dArray[0] != d2) {
                        dArray = new double[]{d2, 0.0, 0.0, d2};
                        cachedMat = dArray;
                    }
                    this.matrix = dArray;
                }
            }
        }
        return this.matrix;
    }

    public byte getBaselineFor(char c2) {
        return NativeFontWrapper.getBaselineFor(this, c2);
    }

    public boolean canDisplay(char c2) {
        return NativeFontWrapper.canDisplay(this, c2);
    }

    public int canDisplayUpTo(char[] cArray, int n2, int n3) {
        while (n2 < n3 && this.canDisplay(cArray[n2])) {
            ++n2;
        }
        return n2 == n3 ? -1 : n2;
    }

    public Font deriveFont(float f2) {
        Hashtable hashtable = (Hashtable)this.fRequestedAttributes.clone();
        Font.applySize(f2, hashtable);
        return new Font(hashtable, this.createdFont);
    }

    public Font deriveFont(int n2) {
        Hashtable hashtable = (Hashtable)this.fRequestedAttributes.clone();
        Font.applyStyle(n2, hashtable);
        return new Font(hashtable, this.createdFont);
    }

    public Font deriveFont(int n2, float f2) {
        Hashtable hashtable = (Hashtable)this.fRequestedAttributes.clone();
        Font.applyStyle(n2, hashtable);
        Font.applySize(f2, hashtable);
        return new Font(hashtable, this.createdFont);
    }

    public AffineTransform getTransform() {
        Object object = this.fRequestedAttributes.get(TextAttribute.TRANSFORM);
        if (object != null) {
            if (object instanceof TransformAttribute) {
                return ((TransformAttribute)object).getTransform();
            }
            if (object instanceof AffineTransform) {
                return new AffineTransform((AffineTransform)object);
            }
        } else {
            object = new AffineTransform();
        }
        return (AffineTransform)object;
    }

    public FontPeer getPeer() {
        return this.getPeer_NoClientCode();
    }

    final FontPeer getPeer_NoClientCode() {
        if (this.peer == null) {
            Toolkit toolkit = Toolkit.getDefaultToolkit();
            this.peer = toolkit.getFontPeer(this.name, this.style);
        }
        return this.peer;
    }

    private void readObject(ObjectInputStream objectInputStream) throws ClassNotFoundException, IOException {
        objectInputStream.defaultReadObject();
        if (this.pointSize == 0.0f) {
            this.pointSize = this.size;
        }
        this.initializeFont(this.fRequestedAttributes);
    }

    private void writeObject(ObjectOutputStream objectOutputStream) throws ClassNotFoundException, IOException {
        objectOutputStream.defaultWriteObject();
    }

    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (object != null) {
            try {
                Font font = (Font)object;
                double[] dArray = this.getMatrix();
                double[] dArray2 = font.getMatrix();
                return this.size == font.size && this.pointSize == font.pointSize && this.style == font.style && this.pNativeFont == font.pNativeFont && this.name.equals(font.name) && dArray[0] == dArray2[0] && dArray[1] == dArray2[1] && dArray[2] == dArray2[2] && dArray[3] == dArray2[3];
            }
            catch (ClassCastException classCastException) {
                // empty catch block
            }
        }
        return false;
    }

    public String getFamily() {
        return this.getFamily_NoClientCode();
    }

    final String getFamily_NoClientCode() {
        return this.getFamily(Locale.getDefault());
    }

    public String getFontName() {
        return this.getFontName(Locale.getDefault());
    }

    public String getName() {
        return new String(this.name);
    }

    public String getPSName() {
        String string = NativeFontWrapper.getPostscriptName(this);
        return string == null ? this.getFontName() : string;
    }

    public String toString() {
        String string = this.isBold() ? (this.isItalic() ? "bolditalic" : "bold") : (this.isItalic() ? "italic" : "plain");
        return this.getClass().getName() + "[family=" + this.getFamily() + ",name=" + this.name + ",style=" + string + ",size=" + this.size + "]";
    }

    public int canDisplayUpTo(String string) {
        return this.canDisplayUpTo(new StringCharacterIterator(string), 0, string.length());
    }

    private Font(String string, int n2, float f2, boolean bl2) {
        this.createdFont = bl2;
        this.name = string;
        this.style = (n2 & 0xFFFFFFFC) == 0 ? n2 : 0;
        this.size = (int)((double)f2 + 0.5);
        this.pointSize = f2;
        this.initializeFont(null);
    }

    public Font(String string, int n2, int n3) {
        this.name = string;
        this.style = (n2 & 0xFFFFFFFC) == 0 ? n2 : 0;
        this.size = n3;
        this.pointSize = n3;
        this.initializeFont(null);
    }

    private Font(String string, int n2, int n3, boolean bl2) {
        this.createdFont = bl2;
        this.name = string;
        this.style = (n2 & 0xFFFFFFFC) == 0 ? n2 : 0;
        this.size = n3;
        this.pointSize = n3;
        this.initializeFont(null);
    }

    public AttributedCharacterIterator.Attribute[] getAvailableAttributes() {
        AttributedCharacterIterator.Attribute[] attributeArray = new AttributedCharacterIterator.Attribute[]{TextAttribute.FAMILY, TextAttribute.WEIGHT, TextAttribute.POSTURE, TextAttribute.SIZE, TextAttribute.TRANSFORM};
        return attributeArray;
    }

    public int canDisplayUpTo(CharacterIterator characterIterator, int n2, int n3) {
        int n4 = characterIterator.setIndex(n2);
        while (characterIterator.getIndex() < n3 && this.canDisplay((char)n4)) {
            n4 = characterIterator.next();
        }
        n4 = characterIterator.getIndex();
        return n4 == n3 ? -1 : n4;
    }

    private void initializeFont(Hashtable hashtable) {
        Object object;
        if (this.name == null) {
            this.name = "Default";
        }
        if (hashtable == null) {
            this.fRequestedAttributes = new Hashtable(5, 0.9f);
            this.fRequestedAttributes.put(TextAttribute.TRANSFORM, IDENT_TX_ATTRIBUTE);
            this.fRequestedAttributes.put(TextAttribute.FAMILY, this.name);
            this.fRequestedAttributes.put(TextAttribute.SIZE, new Float(this.size));
            this.fRequestedAttributes.put(TextAttribute.WEIGHT, (this.style & 1) != 0 ? TextAttribute.WEIGHT_BOLD : TextAttribute.WEIGHT_REGULAR);
            this.fRequestedAttributes.put(TextAttribute.POSTURE, (this.style & 2) != 0 ? TextAttribute.POSTURE_OBLIQUE : TextAttribute.POSTURE_REGULAR);
        } else {
            object = this.fRequestedAttributes.get(TextAttribute.TRANSFORM);
            if (object instanceof TransformAttribute) {
                this.nonIdentityTx = !((TransformAttribute)object).isIdentity();
            } else if (object instanceof AffineTransform) {
                this.nonIdentityTx = !((AffineTransform)object).isIdentity();
            }
        }
        object = GraphicsEnvironment.getLocalGraphicsEnvironment();
        String string = this.name;
        if (object instanceof FontSupport && !this.createdFont) {
            string = ((FontSupport)object).mapFontName(this.name, this.style);
        }
        NativeFontWrapper.initializeFont(this, string, this.style);
    }

    public Map getAttributes() {
        return (Map)this.fRequestedAttributes.clone();
    }

    private static void applySize(float f2, Map map) {
        map.put(TextAttribute.SIZE, new Float(f2));
    }

    private static void applyStyle(int n2, Map map) {
        if ((n2 & 1) != 0) {
            map.put(TextAttribute.WEIGHT, TextAttribute.WEIGHT_BOLD);
        } else {
            map.remove(TextAttribute.WEIGHT);
        }
        if ((n2 & 2) != 0) {
            map.put(TextAttribute.POSTURE, TextAttribute.POSTURE_OBLIQUE);
        } else {
            map.remove(TextAttribute.POSTURE);
        }
    }

    public Font(Map map) {
        this.initFromMap(map);
    }

    private void initFromMap(Map map) {
        this.name = "Dialog";
        this.pointSize = 12.0f;
        this.size = 12;
        if (map != null && !((Object)map).equals(EMPTY_MAP)) {
            this.fRequestedAttributes = new Hashtable(map);
            Object object = map.get(TextAttribute.FAMILY);
            if (object != null) {
                this.name = (String)object;
            }
            if ((object = map.get(TextAttribute.WEIGHT)) != null && object.equals(TextAttribute.WEIGHT_BOLD)) {
                this.style |= 1;
            }
            if ((object = map.get(TextAttribute.POSTURE)) != null && object.equals(TextAttribute.POSTURE_OBLIQUE)) {
                this.style |= 2;
            }
            if ((object = map.get(TextAttribute.SIZE)) != null) {
                this.pointSize = ((Float)object).floatValue();
                this.size = (int)((double)this.pointSize + 0.5);
            }
        }
        this.initializeFont(this.fRequestedAttributes);
    }

    private Font(Map map, boolean bl2) {
        this.createdFont = bl2;
        this.initFromMap(map);
    }

    private static Font get(Key key) {
        Font font = null;
        Map map = (Map)cacheRef.get();
        if (map == null) {
            map = new HashMap();
            cacheRef = new SoftReference(map);
        } else {
            font = (Font)map.get(key);
        }
        if (font == null) {
            font = new Font(key.attrs);
            map.put(key, font);
        }
        return font;
    }

    public Font deriveFont(int n2, AffineTransform affineTransform) {
        Hashtable hashtable = (Hashtable)this.fRequestedAttributes.clone();
        Font.applyStyle(n2, hashtable);
        Font.applyTransform(affineTransform, hashtable);
        return new Font(hashtable, this.createdFont);
    }

    public Font deriveFont(AffineTransform affineTransform) {
        Hashtable hashtable = (Hashtable)this.fRequestedAttributes.clone();
        Font.applyTransform(affineTransform, hashtable);
        return new Font(hashtable, this.createdFont);
    }

    public static Font createFont(int n2, InputStream inputStream) throws FontFormatException, IOException {
        if (n2 != 0) {
            throw new IllegalArgumentException("font format not recognized");
        }
        final File file = (File)AccessController.doPrivileged(new PrivilegedAction(){

            public Object run() {
                File file = null;
                try {
                    file = File.createTempFile("+~JF", ".tmp", null);
                    file.deleteOnExit();
                }
                catch (IOException iOException) {
                    // empty catch block
                }
                return file;
            }
        });
        BufferedInputStream bufferedInputStream = null;
        bufferedInputStream = new BufferedInputStream(inputStream);
        FileOutputStream fileOutputStream = (FileOutputStream)AccessController.doPrivileged(new PrivilegedAction(){

            public Object run() {
                FileOutputStream fileOutputStream = null;
                try {
                    fileOutputStream = new FileOutputStream(file);
                }
                catch (IOException iOException) {
                    // empty catch block
                }
                return fileOutputStream;
            }
        });
        int n3 = 0;
        int n4 = 8192;
        byte[] byArray = new byte[n4];
        while (n3 != -1) {
            n3 = bufferedInputStream.read(byArray, 0, n4);
            if (n3 == -1) continue;
            fileOutputStream.write(byArray, 0, n3);
        }
        bufferedInputStream.close();
        fileOutputStream.close();
        String string = SunGraphicsEnvironment.createFont(file);
        if (string == null) {
            throw new FontFormatException("Unable to create font - bad font data");
        }
        Font font = new Font(string, 0, 1, true);
        return font;
    }

    public static Font decode(String string) {
        String string2 = string;
        int n2 = 12;
        int n3 = 0;
        if (string == null) {
            return new Font("dialog", n3, n2);
        }
        int n4 = string.indexOf(45);
        if (n4 >= 0) {
            string2 = string.substring(0, n4);
            string = string.substring(n4 + 1);
            int n5 = (string = string.toLowerCase()).indexOf("bold-italic");
            if (n5 != -1) {
                n3 = 3;
            }
            if (n5 == -1 && (n5 = string.indexOf("bolditalic")) != -1) {
                n3 = 3;
            }
            if (n5 == -1 && (n5 = string.indexOf("bold")) != -1) {
                n3 = 1;
            }
            if (n5 == -1 && (n5 = string.indexOf("italic")) != -1) {
                n3 = 2;
            }
            if ((n5 = string.lastIndexOf("-")) != -1) {
                string = string.substring(n5 + 1);
            }
            try {
                n2 = Integer.valueOf(string);
            }
            catch (NumberFormatException numberFormatException) {}
        } else if (n4 == -1) {
            n3 = 0;
            n2 = 12;
            int n6 = (string = string.toLowerCase()).indexOf("bolditalic");
            if (n6 != -1) {
                n3 = 3;
            }
            if (n6 == -1 && (n6 = string.indexOf("bold italic")) != -1) {
                n3 = 3;
            }
            if (n6 == -1 && (n6 = string.indexOf("bold")) != -1) {
                n3 = 1;
            }
            if (n6 == -1 && (n6 = string.indexOf("italic")) != -1) {
                n3 = 2;
            }
            if (n6 != -1) {
                string2 = string2.substring(0, n6);
                string2 = string2.trim();
            }
            if ((n6 = string.lastIndexOf(" ")) != -1) {
                String string3 = string.substring(n6);
                string3 = string3.trim();
                try {
                    n2 = Integer.valueOf(string3);
                }
                catch (NumberFormatException numberFormatException) {
                    // empty catch block
                }
            }
        }
        return new Font(string2, n3, n2);
    }

    public static Font getFont(String string) {
        return Font.getFont(string, null);
    }

    public Font deriveFont(Map map) {
        if (map == null || map.size() == 0) {
            return this;
        }
        Hashtable hashtable = new Hashtable(this.getAttributes());
        AttributedCharacterIterator.Attribute[] attributeArray = this.getAvailableAttributes();
        for (int i2 = 0; i2 < attributeArray.length; ++i2) {
            Object object = map.get(attributeArray[i2]);
            if (object == null) continue;
            hashtable.put(attributeArray[i2], object);
        }
        return new Font(hashtable, this.createdFont);
    }

    public static Font getFont(Map map) {
        Font font = (Font)map.get(TextAttribute.FONT);
        if (font != null) {
            return font;
        }
        return Font.get(new Key(map));
    }

    private FontLineMetrics defaultLineMetrics(FontRenderContext fontRenderContext) {
        FontLineMetrics fontLineMetrics = new FontLineMetrics();
        double[] dArray = this.getMatrix();
        float[] fArray = new float[4];
        NativeFontWrapper.getFontMetrics(this, dArray, fontRenderContext.isAntiAliased(), fontRenderContext.usesFractionalMetrics(), fArray);
        fontLineMetrics.ascent = fArray[0];
        fontLineMetrics.descent = fArray[1];
        fontLineMetrics.leading = fArray[2];
        fontLineMetrics.height = fArray[0] + fArray[1] + fArray[2];
        fontLineMetrics.baselineIndex = 0;
        fontLineMetrics.baselineOffsets = new float[3];
        fontLineMetrics.baselineOffsets[0] = 0.0f;
        fontLineMetrics.strikethroughOffset = -(fontLineMetrics.ascent / 3.0f);
        fontLineMetrics.strikethroughThickness = this.pointSize / 12.0f;
        fontLineMetrics.underlineOffset = 0.0f;
        fontLineMetrics.underlineThickness = this.pointSize / 12.0f;
        return fontLineMetrics;
    }

    public GlyphVector createGlyphVector(FontRenderContext fontRenderContext, char[] cArray) {
        return new StandardGlyphVector(this, cArray, fontRenderContext);
    }

    public GlyphVector layoutGlyphVector(FontRenderContext fontRenderContext, char[] cArray, int n2, int n3, int n4) {
        return new StandardGlyphVector(this, cArray, n2, n3 - n2, n4, fontRenderContext);
    }

    public GlyphVector createGlyphVector(FontRenderContext fontRenderContext, int[] nArray) {
        return new StandardGlyphVector(this, nArray, fontRenderContext);
    }

    public LineMetrics getLineMetrics(char[] cArray, int n2, int n3, FontRenderContext fontRenderContext) {
        FontLineMetrics fontLineMetrics = this.defaultLineMetrics(fontRenderContext);
        int n4 = n3 - n2;
        fontLineMetrics.numchars = n4 < 0 ? 0 : n4;
        return fontLineMetrics;
    }

    public Rectangle2D getMaxCharBounds(FontRenderContext fontRenderContext) {
        double[] dArray = this.getMatrix();
        float[] fArray = new float[4];
        NativeFontWrapper.getFontMetrics(this, dArray, fontRenderContext.isAntiAliased(), fontRenderContext.usesFractionalMetrics(), fArray);
        return new Rectangle2D.Float(0.0f, -fArray[0], fArray[3], fArray[0] + fArray[1] + fArray[2]);
    }

    public Rectangle2D getStringBounds(char[] cArray, int n2, int n3, FontRenderContext fontRenderContext) {
        if (n2 < 0) {
            throw new IndexOutOfBoundsException("beginIndex: " + n2);
        }
        if (n3 > cArray.length) {
            throw new IndexOutOfBoundsException("limit: " + n3);
        }
        if (n2 > n3) {
            throw new IndexOutOfBoundsException("range length: " + (n3 - n2));
        }
        boolean bl2 = true;
        for (int i2 = n2; i2 < n3; ++i2) {
            char c2 = cArray[i2];
            if (c2 < '\u0590' || c2 > '\u206f') continue;
            bl2 = false;
            break;
        }
        if (bl2) {
            StandardGlyphVector standardGlyphVector = new StandardGlyphVector(this, cArray, n2, n3 - n2, fontRenderContext);
            return ((GlyphVector)standardGlyphVector).getLogicalBounds();
        }
        String string = new String(cArray, n2, n3 - n2);
        TextLayout textLayout = new TextLayout(string, this, fontRenderContext);
        return new Rectangle2D.Float(0.0f, -textLayout.getAscent(), textLayout.getAdvance(), textLayout.getDescent() + textLayout.getLeading());
    }

    public String getFamily(Locale locale) {
        if (SunGraphicsEnvironment.isLogicalFont(this.name)) {
            return this.name;
        }
        short s2 = NativeFontWrapper.getLCIDFromLocale(locale);
        return NativeFontWrapper.getFamilyName(this, s2);
    }

    public String getFontName(Locale locale) {
        if (SunGraphicsEnvironment.isLogicalFont(this.name)) {
            return this.name + "." + SunGraphicsEnvironment.styleStr(this.style);
        }
        short s2 = NativeFontWrapper.getLCIDFromLocale(locale);
        return NativeFontWrapper.getFullName(this, s2);
    }

    private static void applyTransform(AffineTransform affineTransform, Map map) {
        if (affineTransform == null) {
            throw new IllegalArgumentException("transform must not be null");
        }
        if (affineTransform.isIdentity()) {
            map.remove(TextAttribute.TRANSFORM);
        } else {
            map.put(TextAttribute.TRANSFORM, new TransformAttribute(affineTransform));
        }
    }

    public static Font getFont(String string, Font font) {
        String string2 = null;
        try {
            string2 = System.getProperty(string);
        }
        catch (SecurityException securityException) {
            // empty catch block
        }
        if (string2 == null) {
            return font;
        }
        return Font.decode(string2);
    }

    public GlyphVector createGlyphVector(FontRenderContext fontRenderContext, String string) {
        return new StandardGlyphVector(this, string, fontRenderContext);
    }

    public GlyphVector createGlyphVector(FontRenderContext fontRenderContext, CharacterIterator characterIterator) {
        return new StandardGlyphVector(this, characterIterator, fontRenderContext);
    }

    public LineMetrics getLineMetrics(String string, int n2, int n3, FontRenderContext fontRenderContext) {
        FontLineMetrics fontLineMetrics = this.defaultLineMetrics(fontRenderContext);
        int n4 = n3 - n2;
        fontLineMetrics.numchars = n4 < 0 ? 0 : n4;
        return fontLineMetrics;
    }

    public LineMetrics getLineMetrics(String string, FontRenderContext fontRenderContext) {
        FontLineMetrics fontLineMetrics = this.defaultLineMetrics(fontRenderContext);
        fontLineMetrics.numchars = string.length();
        return fontLineMetrics;
    }

    public LineMetrics getLineMetrics(CharacterIterator characterIterator, int n2, int n3, FontRenderContext fontRenderContext) {
        FontLineMetrics fontLineMetrics = this.defaultLineMetrics(fontRenderContext);
        int n4 = n3 - n2;
        fontLineMetrics.numchars = n4 < 0 ? 0 : n4;
        return fontLineMetrics;
    }

    public Rectangle2D getStringBounds(String string, int n2, int n3, FontRenderContext fontRenderContext) {
        String string2 = string.substring(n2, n3);
        return this.getStringBounds(string2, fontRenderContext);
    }

    public Rectangle2D getStringBounds(String string, FontRenderContext fontRenderContext) {
        char[] cArray = string.toCharArray();
        return this.getStringBounds(cArray, 0, cArray.length, fontRenderContext);
    }

    public Rectangle2D getStringBounds(CharacterIterator characterIterator, int n2, int n3, FontRenderContext fontRenderContext) {
        int n4 = characterIterator.getBeginIndex();
        int n5 = characterIterator.getEndIndex();
        if (n2 < n4) {
            throw new IndexOutOfBoundsException("beginIndex: " + n2);
        }
        if (n3 > n5) {
            throw new IndexOutOfBoundsException("limit: " + n3);
        }
        if (n2 > n3) {
            throw new IndexOutOfBoundsException("range length: " + (n3 - n2));
        }
        char[] cArray = new char[n3 - n2];
        characterIterator.setIndex(n2);
        for (int i2 = 0; i2 < cArray.length; ++i2) {
            cArray[i2] = characterIterator.current();
            characterIterator.next();
        }
        return this.getStringBounds(cArray, 0, cArray.length, fontRenderContext);
    }

    private final class FontLineMetrics
    extends LineMetrics {
        int numchars;
        float ascent;
        float descent;
        float leading;
        float height;
        int baselineIndex;
        float[] baselineOffsets;
        float strikethroughOffset;
        float strikethroughThickness;
        float underlineOffset;
        float underlineThickness;

        public final float getAscent() {
            return this.ascent;
        }

        public final float getDescent() {
            return this.descent;
        }

        public final float getHeight() {
            return this.height;
        }

        public final float getLeading() {
            return this.leading;
        }

        public final float getStrikethroughOffset() {
            return this.strikethroughOffset;
        }

        public final float getStrikethroughThickness() {
            return this.strikethroughThickness;
        }

        public final float getUnderlineOffset() {
            return this.underlineOffset;
        }

        public final float getUnderlineThickness() {
            return this.underlineThickness;
        }

        public final int getBaselineIndex() {
            return this.baselineIndex;
        }

        public final int getNumChars() {
            return this.numchars;
        }

        public final float[] getBaselineOffsets() {
            return this.baselineOffsets;
        }

        private FontLineMetrics() {
        }

        public final boolean equals(Object object) {
            if (object != null) {
                if (this == object) {
                    return true;
                }
                try {
                    FontLineMetrics fontLineMetrics = (FontLineMetrics)object;
                    return this.ascent == fontLineMetrics.ascent && this.descent == fontLineMetrics.descent && this.leading == fontLineMetrics.leading && this.baselineIndex == fontLineMetrics.baselineIndex && this.baselineOffsets[0] == fontLineMetrics.baselineOffsets[0] && this.baselineOffsets[1] == fontLineMetrics.baselineOffsets[1] && this.baselineOffsets[2] == fontLineMetrics.baselineOffsets[2] && this.strikethroughOffset == fontLineMetrics.strikethroughOffset && this.strikethroughThickness == fontLineMetrics.strikethroughThickness && this.underlineOffset == fontLineMetrics.underlineOffset && this.underlineThickness == fontLineMetrics.underlineThickness;
                }
                catch (ClassCastException classCastException) {
                    // empty catch block
                }
            }
            return false;
        }
    }

    private static class Key {
        String family = "Dialog";
        float weight = 1.0f;
        float posture = 0.0f;
        float size = 12.0f;
        double[] txdata = null;
        Map attrs;
        int hashCode = 0;

        public int hashCode() {
            return this.hashCode;
        }

        public boolean equals(Object object) {
            Key key = (Key)object;
            if (this.hashCode == key.hashCode && this.size == key.size && this.weight == key.weight && this.posture == key.posture && this.family.equals(key.family) && this.txdata == null == (key.txdata == null)) {
                if (this.txdata != null) {
                    for (int i2 = 0; i2 < this.txdata.length; ++i2) {
                        if (this.txdata[i2] == key.txdata[i2]) continue;
                        return false;
                    }
                }
                return true;
            }
            return false;
        }

        Key(Map map) {
            float f2;
            this.attrs = map;
            Object object = map.get(TextAttribute.FAMILY);
            if (object != null) {
                this.family = (String)object;
            }
            this.hashCode = this.family.hashCode();
            object = map.get(TextAttribute.WEIGHT);
            if (object != null && object != TextAttribute.WEIGHT_REGULAR && (f2 = ((Float)object).floatValue()) == TextAttribute.WEIGHT_BOLD.floatValue()) {
                this.weight = f2;
                this.hashCode = this.hashCode << 3 ^ Float.floatToIntBits(this.weight);
            }
            if ((object = map.get(TextAttribute.POSTURE)) != null && object != TextAttribute.POSTURE_REGULAR && (f2 = ((Float)object).floatValue()) == TextAttribute.POSTURE_OBLIQUE.floatValue()) {
                this.posture = f2;
                this.hashCode = this.hashCode << 3 ^ Float.floatToIntBits(this.posture);
            }
            if ((object = map.get(TextAttribute.SIZE)) != null) {
                this.size = ((Float)object).floatValue();
                if (this.size != 12.0f) {
                    this.hashCode = this.hashCode << 3 ^ Float.floatToIntBits(this.size);
                }
            }
            if ((object = map.get(TextAttribute.TRANSFORM)) != null) {
                AffineTransform affineTransform;
                AffineTransform affineTransform2 = null;
                if (object instanceof TransformAttribute) {
                    TransformAttribute transformAttribute = (TransformAttribute)object;
                    if (!transformAttribute.isIdentity()) {
                        affineTransform2 = transformAttribute.getTransform();
                    }
                } else if (object instanceof AffineTransform && !(affineTransform = (AffineTransform)object).isIdentity()) {
                    affineTransform2 = affineTransform;
                }
                if (affineTransform2 != null) {
                    this.txdata = new double[6];
                    affineTransform2.getMatrix(this.txdata);
                    this.hashCode = this.hashCode << 3 ^ new Double(this.txdata[0]).hashCode();
                }
            }
        }
    }
}

