/*
 * Decompiled with CFR 0.152.
 */
package java.io;

import java.io.IOException;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;
import java.io.Writer;
import java.nio.charset.Charset;
import java.nio.charset.CharsetEncoder;
import sun.nio.cs.StreamEncoder;

public class OutputStreamWriter
extends Writer {
    private final StreamEncoder se;

    public void close() throws IOException {
        this.se.close();
    }

    public void flush() throws IOException {
        this.se.flush();
    }

    void flushBuffer() throws IOException {
        this.se.flushBuffer();
    }

    public void write(int n2) throws IOException {
        this.se.write(n2);
    }

    public void write(char[] cArray, int n2, int n3) throws IOException {
        this.se.write(cArray, n2, n3);
    }

    public OutputStreamWriter(OutputStream outputStream) {
        super(outputStream);
        try {
            this.se = StreamEncoder.forOutputStreamWriter(outputStream, (Object)this, (String)null);
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            throw new Error(unsupportedEncodingException);
        }
    }

    public String getEncoding() {
        return this.se.getEncoding();
    }

    public void write(String string, int n2, int n3) throws IOException {
        this.se.write(string, n2, n3);
    }

    public OutputStreamWriter(OutputStream outputStream, String string) throws UnsupportedEncodingException {
        super(outputStream);
        if (string == null) {
            throw new NullPointerException("charsetName");
        }
        this.se = StreamEncoder.forOutputStreamWriter(outputStream, (Object)this, string);
    }

    public OutputStreamWriter(OutputStream outputStream, Charset charset) {
        super(outputStream);
        if (charset == null) {
            throw new NullPointerException("charset");
        }
        this.se = StreamEncoder.forOutputStreamWriter(outputStream, (Object)this, charset);
    }

    public OutputStreamWriter(OutputStream outputStream, CharsetEncoder charsetEncoder) {
        super(outputStream);
        if (charsetEncoder == null) {
            throw new NullPointerException("charset encoder");
        }
        this.se = StreamEncoder.forOutputStreamWriter(outputStream, (Object)this, charsetEncoder);
    }
}

