/*
 * Decompiled with CFR 0.152.
 */
package javax.imageio.spi;

import java.lang.reflect.Method;
import javax.imageio.metadata.IIOMetadataFormat;
import javax.imageio.metadata.IIOMetadataFormatImpl;
import javax.imageio.spi.IIOServiceProvider;

public abstract class ImageReaderWriterSpi
extends IIOServiceProvider {
    protected String[] names = null;
    protected String[] suffixes = null;
    protected String[] MIMETypes = null;
    protected String pluginClassName = null;
    protected boolean supportsStandardStreamMetadataFormat = false;
    protected String nativeStreamMetadataFormatName = null;
    protected String nativeStreamMetadataFormatClassName = null;
    protected String[] extraStreamMetadataFormatNames = null;
    protected String[] extraStreamMetadataFormatClassNames = null;
    protected boolean supportsStandardImageMetadataFormat = false;
    protected String nativeImageMetadataFormatName = null;
    protected String nativeImageMetadataFormatClassName = null;
    protected String[] extraImageMetadataFormatNames = null;
    protected String[] extraImageMetadataFormatClassNames = null;

    public ImageReaderWriterSpi() {
    }

    public boolean isStandardImageMetadataFormatSupported() {
        return this.supportsStandardImageMetadataFormat;
    }

    public boolean isStandardStreamMetadataFormatSupported() {
        return this.supportsStandardStreamMetadataFormat;
    }

    public String getNativeImageMetadataFormatName() {
        return this.nativeImageMetadataFormatName;
    }

    public String getNativeStreamMetadataFormatName() {
        return this.nativeStreamMetadataFormatName;
    }

    public String getPluginClassName() {
        return this.pluginClassName;
    }

    public String[] getExtraImageMetadataFormatNames() {
        return this.extraImageMetadataFormatNames == null ? null : (String[])this.extraImageMetadataFormatNames.clone();
    }

    public String[] getExtraStreamMetadataFormatNames() {
        return this.extraStreamMetadataFormatNames == null ? null : (String[])this.extraStreamMetadataFormatNames.clone();
    }

    public String[] getFileSuffixes() {
        return this.suffixes == null ? null : (String[])this.suffixes.clone();
    }

    public String[] getFormatNames() {
        return (String[])this.names.clone();
    }

    public String[] getMIMETypes() {
        return this.MIMETypes == null ? null : (String[])this.MIMETypes.clone();
    }

    public IIOMetadataFormat getImageMetadataFormat(String string) {
        return this.getMetadataFormat(string, this.supportsStandardImageMetadataFormat, this.nativeImageMetadataFormatName, this.nativeImageMetadataFormatClassName, this.extraImageMetadataFormatNames, this.extraImageMetadataFormatClassNames);
    }

    public IIOMetadataFormat getStreamMetadataFormat(String string) {
        return this.getMetadataFormat(string, this.supportsStandardStreamMetadataFormat, this.nativeStreamMetadataFormatName, this.nativeStreamMetadataFormatClassName, this.extraStreamMetadataFormatNames, this.extraStreamMetadataFormatClassNames);
    }

    private IIOMetadataFormat getMetadataFormat(String string, boolean bl2, String string2, String string3, String[] stringArray, String[] stringArray2) {
        if (string == null) {
            throw new IllegalArgumentException("formatName == null!");
        }
        if (bl2 && string.equals("javax_imageio_1.0")) {
            return IIOMetadataFormatImpl.getStandardFormatInstance();
        }
        String string4 = null;
        if (string.equals(string2)) {
            string4 = string3;
        } else if (stringArray != null) {
            for (int i2 = 0; i2 < stringArray.length; ++i2) {
                if (!string.equals(stringArray[i2])) continue;
                string4 = stringArray2[i2];
                break;
            }
        }
        if (string4 == null) {
            throw new IllegalArgumentException("Unsupported format name");
        }
        try {
            Class clazz = Class.forName(string4, true, ClassLoader.getSystemClassLoader());
            Method method = clazz.getMethod("getInstance", null);
            return (IIOMetadataFormat)method.invoke(null, null);
        }
        catch (Exception exception) {
            IllegalStateException illegalStateException = new IllegalStateException("Can't obtain format");
            illegalStateException.initCause(exception);
            throw illegalStateException;
        }
    }

    public ImageReaderWriterSpi(String string, String string2, String[] stringArray, String[] stringArray2, String[] stringArray3, String string3, boolean bl2, String string4, String string5, String[] stringArray4, String[] stringArray5, boolean bl3, String string6, String string7, String[] stringArray6, String[] stringArray7) {
        super(string, string2);
        if (stringArray == null) {
            throw new IllegalArgumentException("names == null!");
        }
        if (stringArray.length == 0) {
            throw new IllegalArgumentException("names.length == 0!");
        }
        if (string3 == null) {
            throw new IllegalArgumentException("pluginClassName == null!");
        }
        this.names = (String[])stringArray.clone();
        if (stringArray2 != null && stringArray2.length > 0) {
            this.suffixes = (String[])stringArray2.clone();
        }
        if (stringArray3 != null && stringArray3.length > 0) {
            this.MIMETypes = (String[])stringArray3.clone();
        }
        this.pluginClassName = string3;
        this.supportsStandardStreamMetadataFormat = bl2;
        this.nativeStreamMetadataFormatName = string4;
        this.nativeStreamMetadataFormatClassName = string5;
        if (stringArray4 != null && stringArray4.length > 0) {
            this.extraStreamMetadataFormatNames = (String[])stringArray4.clone();
        }
        if (stringArray5 != null && stringArray5.length > 0) {
            this.extraStreamMetadataFormatClassNames = (String[])stringArray5.clone();
        }
        this.supportsStandardImageMetadataFormat = bl3;
        this.nativeImageMetadataFormatName = string6;
        this.nativeImageMetadataFormatClassName = string7;
        if (stringArray6 != null && stringArray6.length > 0) {
            this.extraImageMetadataFormatNames = (String[])stringArray6.clone();
        }
        if (stringArray7 != null && stringArray7.length > 0) {
            this.extraImageMetadataFormatClassNames = (String[])stringArray7.clone();
        }
    }
}

