/*
 * Decompiled with CFR 0.152.
 */
package javax.swing;

import java.awt.Component;
import java.awt.Container;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.swing.InternalFrameFocusTraversalPolicy;
import javax.swing.JComponent;
import javax.swing.SwingContainerOrderFocusTraversalPolicy;

public class SortingFocusTraversalPolicy
extends InternalFrameFocusTraversalPolicy {
    private Comparator comparator;
    private boolean implicitDownCycleTraversal = true;
    private Container cachedRoot;
    private List cachedCycle;
    private static final SwingContainerOrderFocusTraversalPolicy fitnessTestPolicy = new SwingContainerOrderFocusTraversalPolicy();

    protected SortingFocusTraversalPolicy() {
    }

    public boolean getImplicitDownCycleTraversal() {
        return this.implicitDownCycleTraversal;
    }

    public void setImplicitDownCycleTraversal(boolean bl2) {
        this.implicitDownCycleTraversal = bl2;
    }

    protected boolean accept(Component component) {
        return fitnessTestPolicy.accept(component);
    }

    protected Comparator getComparator() {
        return this.comparator;
    }

    public SortingFocusTraversalPolicy(Comparator comparator) {
        this.comparator = comparator;
    }

    protected void setComparator(Comparator comparator) {
        this.comparator = comparator;
    }

    public Component getDefaultComponent(Container container) {
        return this.getFirstComponent(container);
    }

    public Component getFirstComponent(Container container) {
        List list;
        if (container == null) {
            throw new IllegalArgumentException("focusCycleRoot cannot be null");
        }
        if (this.cachedRoot == container) {
            list = this.cachedCycle;
        } else {
            list = new ArrayList();
            this.enumerateAndSortCycle(container, list, null);
        }
        int n2 = list.size();
        if (n2 == 0) {
            return null;
        }
        return (Component)list.get(0);
    }

    public Component getLastComponent(Container container) {
        List list;
        if (container == null) {
            throw new IllegalArgumentException("focusCycleRoot cannot be null");
        }
        if (this.cachedRoot == container) {
            list = this.cachedCycle;
        } else {
            list = new ArrayList();
            this.enumerateAndSortCycle(container, list, null);
        }
        int n2 = list.size();
        if (n2 == 0) {
            return null;
        }
        return (Component)list.get(n2 - 1);
    }

    private void enumerateCycle(Container container, List list) {
        if (!container.isVisible() || !container.isDisplayable()) {
            return;
        }
        list.add(container);
        Component[] componentArray = container.getComponents();
        for (int i2 = 0; i2 < componentArray.length; ++i2) {
            Component component = componentArray[i2];
            if (!(!(component instanceof Container) || ((Container)component).isFocusCycleRoot() || component instanceof JComponent && ((JComponent)component).isManagingFocus())) {
                this.enumerateCycle((Container)component, list);
                continue;
            }
            list.add(component);
        }
    }

    public Component getComponentAfter(Container container, Component component) {
        Component component2;
        int n2;
        if (container == null || component == null) {
            throw new IllegalArgumentException("focusCycleRoot and aComponent cannot be null");
        }
        if (!component.isFocusCycleRoot(container)) {
            throw new IllegalArgumentException("focusCycleRoot is not a focus cyle root of aComponent");
        }
        ArrayList arrayList = new ArrayList();
        HashMap hashMap = new HashMap();
        this.enumerateAndSortCycle(container, arrayList, hashMap);
        try {
            n2 = Collections.binarySearch(arrayList, component, this.comparator);
        }
        catch (ClassCastException classCastException) {
            return this.getFirstComponent(container);
        }
        if (n2 < 0) {
            n2 = -n2 - 2;
        }
        if ((component2 = (Component)hashMap.get(new Integer(n2))) != null) {
            return component2;
        }
        if (++n2 >= arrayList.size()) {
            this.cachedRoot = container;
            this.cachedCycle = arrayList;
            Component component3 = this.getFirstComponent(container);
            this.cachedRoot = null;
            this.cachedCycle = null;
            return component3;
        }
        return (Component)arrayList.get(n2);
    }

    public Component getComponentBefore(Container container, Component component) {
        int n2;
        if (container == null || component == null) {
            throw new IllegalArgumentException("focusCycleRoot and aComponent cannot be null");
        }
        if (!component.isFocusCycleRoot(container)) {
            throw new IllegalArgumentException("focusCycleRoot is not a focus cyle root of aComponent");
        }
        ArrayList arrayList = new ArrayList();
        HashMap hashMap = new HashMap();
        this.enumerateAndSortCycle(container, arrayList, hashMap);
        try {
            n2 = Collections.binarySearch(arrayList, component, this.comparator);
        }
        catch (ClassCastException classCastException) {
            return this.getLastComponent(container);
        }
        n2 = n2 < 0 ? -n2 - 2 : --n2;
        if (n2 < 0) {
            this.cachedRoot = container;
            this.cachedCycle = arrayList;
            Component component2 = this.getLastComponent(container);
            this.cachedRoot = null;
            this.cachedCycle = null;
            return component2;
        }
        Component component3 = (Component)hashMap.get(new Integer(n2));
        if (component3 != null) {
            return component3;
        }
        return (Component)arrayList.get(n2);
    }

    private void enumerateAndSortCycle(Container container, List list, Map map) {
        Component component;
        Iterator iterator;
        boolean bl2;
        ArrayList arrayList = null;
        if (!container.isShowing()) {
            return;
        }
        this.enumerateCycle(container, list);
        boolean bl3 = bl2 = map != null && this.getImplicitDownCycleTraversal();
        if (bl2) {
            arrayList = new ArrayList();
            iterator = list.iterator();
            while (iterator.hasNext()) {
                component = (Component)iterator.next();
                if (!(component instanceof Container) || !((Container)component).isFocusCycleRoot()) continue;
                arrayList.add(component);
            }
            Collections.sort(arrayList, this.comparator);
        }
        iterator = list.iterator();
        while (iterator.hasNext()) {
            component = (Component)iterator.next();
            if (this.accept(component)) continue;
            iterator.remove();
        }
        Collections.sort(list, this.comparator);
        if (bl2) {
            iterator = arrayList.listIterator(arrayList.size());
            while (iterator.hasPrevious()) {
                component = (Container)iterator.previous();
                Component component2 = ((Container)component).getFocusTraversalPolicy().getDefaultComponent((Container)component);
                if (component2 == null || !component2.isShowing()) continue;
                int n2 = Collections.binarySearch(list, component, this.comparator);
                if (n2 < 0) {
                    n2 = -n2 - 2;
                }
                map.put(new Integer(n2), component2);
            }
        }
    }
}

