/*
 * Decompiled with CFR 0.152.
 */
package org.apache.xalan.templates;

import java.io.Serializable;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;
import javax.xml.transform.TransformerException;
import org.apache.xalan.templates.ElemTemplate;
import org.apache.xalan.templates.ElemTemplateElement;
import org.apache.xalan.templates.StylesheetRoot;
import org.apache.xalan.templates.TemplateSubPatternAssociation;
import org.apache.xml.dtm.DTM;
import org.apache.xml.utils.QName;
import org.apache.xpath.Expression;
import org.apache.xpath.XPath;
import org.apache.xpath.XPathContext;
import org.apache.xpath.patterns.NodeTest;
import org.apache.xpath.patterns.StepPattern;
import org.apache.xpath.patterns.UnionPattern;

public class TemplateList
implements Serializable {
    static boolean DEBUG = false;
    private Hashtable m_namedTemplates = new Hashtable(89);
    private Hashtable m_patternTable = new Hashtable(89);
    private TemplateSubPatternAssociation m_wildCardPatterns = null;
    private TemplateSubPatternAssociation m_textPatterns = null;
    private TemplateSubPatternAssociation m_docPatterns = null;
    private TemplateSubPatternAssociation m_commentPatterns = null;

    void dumpAssociationTables() {
        TemplateSubPatternAssociation templateSubPatternAssociation;
        Enumeration enumeration = this.m_patternTable.elements();
        while (enumeration.hasMoreElements()) {
            for (templateSubPatternAssociation = (TemplateSubPatternAssociation)enumeration.nextElement(); null != templateSubPatternAssociation; templateSubPatternAssociation = templateSubPatternAssociation.getNext()) {
                System.out.print("(" + templateSubPatternAssociation.getTargetString() + ", " + templateSubPatternAssociation.getPattern() + ")");
            }
            System.out.println("\n.....");
        }
        System.out.print("wild card list: ");
        for (templateSubPatternAssociation = this.m_wildCardPatterns; null != templateSubPatternAssociation; templateSubPatternAssociation = templateSubPatternAssociation.getNext()) {
            System.out.print("(" + templateSubPatternAssociation.getTargetString() + ", " + templateSubPatternAssociation.getPattern() + ")");
        }
        System.out.println("\n.....");
    }

    private Hashtable getNamedTemplates() {
        return this.m_namedTemplates;
    }

    private void setNamedTemplates(Hashtable hashtable) {
        this.m_namedTemplates = hashtable;
    }

    public void setTemplate(ElemTemplate elemTemplate) {
        Serializable serializable;
        if (null != elemTemplate.getName()) {
            serializable = (ElemTemplate)this.m_namedTemplates.get(elemTemplate.getName());
            if (null == serializable) {
                this.m_namedTemplates.put(elemTemplate.getName(), elemTemplate);
            } else {
                int n2 = ((ElemTemplate)serializable).getStylesheetComposed().getImportCountComposed();
                int n3 = elemTemplate.getStylesheetComposed().getImportCountComposed();
                if (n3 > n2) {
                    this.m_namedTemplates.put(elemTemplate.getName(), elemTemplate);
                } else if (n3 == n2) {
                    elemTemplate.error("ER_DUPLICATE_NAMED_TEMPLATE", new Object[]{elemTemplate.getName()});
                }
            }
        }
        if (null != (serializable = elemTemplate.getMatch())) {
            Expression expression = ((XPath)serializable).getExpression();
            if (expression instanceof StepPattern) {
                this.insertPatternInTable((StepPattern)expression, elemTemplate);
            } else if (expression instanceof UnionPattern) {
                UnionPattern unionPattern = (UnionPattern)expression;
                StepPattern[] stepPatternArray = unionPattern.getPatterns();
                int n4 = stepPatternArray.length;
                for (int i2 = 0; i2 < n4; ++i2) {
                    this.insertPatternInTable(stepPatternArray[i2], elemTemplate);
                }
            }
        }
    }

    public void compose(StylesheetRoot stylesheetRoot) {
        if (DEBUG) {
            System.out.println("Before wildcard insert...");
            this.dumpAssociationTables();
        }
        if (null != this.m_wildCardPatterns) {
            Enumeration enumeration = this.m_patternTable.elements();
            while (enumeration.hasMoreElements()) {
                TemplateSubPatternAssociation templateSubPatternAssociation = (TemplateSubPatternAssociation)enumeration.nextElement();
                for (TemplateSubPatternAssociation templateSubPatternAssociation2 = this.m_wildCardPatterns; null != templateSubPatternAssociation2; templateSubPatternAssociation2 = templateSubPatternAssociation2.getNext()) {
                    try {
                        templateSubPatternAssociation = this.insertAssociationIntoList(templateSubPatternAssociation, (TemplateSubPatternAssociation)templateSubPatternAssociation2.clone(), true);
                        continue;
                    }
                    catch (CloneNotSupportedException cloneNotSupportedException) {
                        // empty catch block
                    }
                }
            }
        }
        if (DEBUG) {
            System.out.println("After wildcard insert...");
            this.dumpAssociationTables();
        }
    }

    public TemplateWalker getWalker() {
        return new TemplateWalker();
    }

    private double getPriorityOrScore(TemplateSubPatternAssociation templateSubPatternAssociation) {
        StepPattern stepPattern;
        double d2 = templateSubPatternAssociation.getTemplate().getPriority();
        if (d2 == Double.NEGATIVE_INFINITY && (stepPattern = templateSubPatternAssociation.getStepPattern()) instanceof NodeTest) {
            return ((NodeTest)stepPattern).getDefaultScore();
        }
        return d2;
    }

    private void addObjectIfNotFound(Object object, Vector vector) {
        int n2 = vector.size();
        boolean bl2 = true;
        for (int i2 = 0; i2 < n2; ++i2) {
            if (vector.elementAt(i2) != object) continue;
            bl2 = false;
            break;
        }
        if (bl2) {
            vector.addElement(object);
        }
    }

    public ElemTemplate getTemplate(QName qName) {
        return (ElemTemplate)this.m_namedTemplates.get(qName);
    }

    private void insertPatternInTable(StepPattern stepPattern, ElemTemplate elemTemplate) {
        String string = stepPattern.getTargetString();
        if (null != string) {
            TemplateSubPatternAssociation templateSubPatternAssociation;
            String string2 = elemTemplate.getMatch().getPatternString();
            TemplateSubPatternAssociation templateSubPatternAssociation2 = new TemplateSubPatternAssociation(elemTemplate, stepPattern, string2);
            boolean bl2 = templateSubPatternAssociation2.isWild();
            TemplateSubPatternAssociation templateSubPatternAssociation3 = templateSubPatternAssociation = bl2 ? this.m_wildCardPatterns : this.getHead(string);
            if (null == templateSubPatternAssociation) {
                if (bl2) {
                    this.m_wildCardPatterns = templateSubPatternAssociation2;
                } else {
                    this.putHead(string, templateSubPatternAssociation2);
                }
            } else {
                this.insertAssociationIntoList(templateSubPatternAssociation, templateSubPatternAssociation2, false);
            }
        }
    }

    private TemplateSubPatternAssociation getHead(String string) {
        return (TemplateSubPatternAssociation)this.m_patternTable.get(string);
    }

    private void putHead(String string, TemplateSubPatternAssociation templateSubPatternAssociation) {
        if (string.equals("#text")) {
            this.m_textPatterns = templateSubPatternAssociation;
        } else if (string.equals("/")) {
            this.m_docPatterns = templateSubPatternAssociation;
        } else if (string.equals("#comment")) {
            this.m_commentPatterns = templateSubPatternAssociation;
        }
        this.m_patternTable.put(string, templateSubPatternAssociation);
    }

    private TemplateSubPatternAssociation insertAssociationIntoList(TemplateSubPatternAssociation templateSubPatternAssociation, TemplateSubPatternAssociation templateSubPatternAssociation2, boolean bl2) {
        boolean bl3;
        double d2;
        TemplateSubPatternAssociation templateSubPatternAssociation3;
        double d3 = this.getPriorityOrScore(templateSubPatternAssociation2);
        int n2 = templateSubPatternAssociation2.getImportLevel();
        int n3 = templateSubPatternAssociation2.getDocOrderPos();
        TemplateSubPatternAssociation templateSubPatternAssociation4 = templateSubPatternAssociation;
        while (null != (templateSubPatternAssociation3 = templateSubPatternAssociation4.getNext())) {
            d2 = this.getPriorityOrScore(templateSubPatternAssociation3);
            if (n2 > templateSubPatternAssociation3.getImportLevel()) break;
            if (n2 < templateSubPatternAssociation3.getImportLevel()) {
                templateSubPatternAssociation4 = templateSubPatternAssociation3;
                continue;
            }
            if (d3 > d2) break;
            if (d3 < d2) {
                templateSubPatternAssociation4 = templateSubPatternAssociation3;
                continue;
            }
            if (n3 >= templateSubPatternAssociation3.getDocOrderPos()) break;
            templateSubPatternAssociation4 = templateSubPatternAssociation3;
        }
        if (null == templateSubPatternAssociation3 || templateSubPatternAssociation4 == templateSubPatternAssociation) {
            d2 = this.getPriorityOrScore(templateSubPatternAssociation4);
            bl3 = n2 > templateSubPatternAssociation4.getImportLevel() ? true : (n2 < templateSubPatternAssociation4.getImportLevel() ? false : (d3 > d2 ? true : (d3 < d2 ? false : n3 >= templateSubPatternAssociation4.getDocOrderPos())));
        } else {
            bl3 = false;
        }
        if (bl2) {
            if (bl3) {
                templateSubPatternAssociation2.setNext(templateSubPatternAssociation4);
                String string = templateSubPatternAssociation4.getTargetString();
                templateSubPatternAssociation2.setTargetString(string);
                this.putHead(string, templateSubPatternAssociation2);
                return templateSubPatternAssociation2;
            }
            templateSubPatternAssociation2.setNext(templateSubPatternAssociation3);
            templateSubPatternAssociation4.setNext(templateSubPatternAssociation2);
            return templateSubPatternAssociation;
        }
        if (bl3) {
            templateSubPatternAssociation2.setNext(templateSubPatternAssociation4);
            if (templateSubPatternAssociation4.isWild() || templateSubPatternAssociation2.isWild()) {
                this.m_wildCardPatterns = templateSubPatternAssociation2;
            } else {
                this.putHead(templateSubPatternAssociation2.getTargetString(), templateSubPatternAssociation2);
            }
            return templateSubPatternAssociation2;
        }
        templateSubPatternAssociation2.setNext(templateSubPatternAssociation3);
        templateSubPatternAssociation4.setNext(templateSubPatternAssociation2);
        return templateSubPatternAssociation;
    }

    public TemplateSubPatternAssociation getHead(XPathContext xPathContext, int n2, DTM dTM) {
        TemplateSubPatternAssociation templateSubPatternAssociation;
        short s2 = dTM.getNodeType(n2);
        switch (s2) {
            case 1: 
            case 2: {
                templateSubPatternAssociation = (TemplateSubPatternAssociation)this.m_patternTable.get(dTM.getLocalName(n2));
                break;
            }
            case 3: 
            case 4: {
                templateSubPatternAssociation = this.m_textPatterns;
                break;
            }
            case 5: 
            case 6: {
                templateSubPatternAssociation = (TemplateSubPatternAssociation)this.m_patternTable.get(dTM.getNodeName(n2));
                break;
            }
            case 7: {
                templateSubPatternAssociation = (TemplateSubPatternAssociation)this.m_patternTable.get(dTM.getLocalName(n2));
                break;
            }
            case 8: {
                templateSubPatternAssociation = this.m_commentPatterns;
                break;
            }
            case 9: 
            case 11: {
                templateSubPatternAssociation = this.m_docPatterns;
                break;
            }
            default: {
                templateSubPatternAssociation = (TemplateSubPatternAssociation)this.m_patternTable.get(dTM.getNodeName(n2));
            }
        }
        return null == templateSubPatternAssociation ? this.m_wildCardPatterns : templateSubPatternAssociation;
    }

    private void checkConflicts(TemplateSubPatternAssociation templateSubPatternAssociation, XPathContext xPathContext, int n2, QName qName) {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ElemTemplate getTemplateFast(XPathContext xPathContext, int n2, int n3, QName qName, int n4, boolean bl2, DTM dTM) throws TransformerException {
        TemplateSubPatternAssociation templateSubPatternAssociation;
        switch (dTM.getNodeType(n2)) {
            case 1: 
            case 2: {
                templateSubPatternAssociation = (TemplateSubPatternAssociation)this.m_patternTable.get(dTM.getLocalNameFromExpandedNameID(n3));
                break;
            }
            case 3: 
            case 4: {
                templateSubPatternAssociation = this.m_textPatterns;
                break;
            }
            case 5: 
            case 6: {
                templateSubPatternAssociation = (TemplateSubPatternAssociation)this.m_patternTable.get(dTM.getNodeName(n2));
                break;
            }
            case 7: {
                templateSubPatternAssociation = (TemplateSubPatternAssociation)this.m_patternTable.get(dTM.getLocalName(n2));
                break;
            }
            case 8: {
                templateSubPatternAssociation = this.m_commentPatterns;
                break;
            }
            case 9: 
            case 11: {
                templateSubPatternAssociation = this.m_docPatterns;
                break;
            }
            default: {
                templateSubPatternAssociation = (TemplateSubPatternAssociation)this.m_patternTable.get(dTM.getNodeName(n2));
            }
        }
        if (null == templateSubPatternAssociation && null == (templateSubPatternAssociation = this.m_wildCardPatterns)) {
            return null;
        }
        xPathContext.pushNamespaceContextNull();
        try {
            do {
                if (n4 > -1 && templateSubPatternAssociation.getImportLevel() > n4) continue;
                ElemTemplate elemTemplate = templateSubPatternAssociation.getTemplate();
                xPathContext.setNamespaceContext(elemTemplate);
                if (templateSubPatternAssociation.m_stepPattern.execute(xPathContext, n2, dTM, n3) == NodeTest.SCORE_NONE || !templateSubPatternAssociation.matchMode(qName)) continue;
                if (bl2) {
                    this.checkConflicts(templateSubPatternAssociation, xPathContext, n2, qName);
                }
                ElemTemplate elemTemplate2 = elemTemplate;
                return elemTemplate2;
            } while (null != (templateSubPatternAssociation = templateSubPatternAssociation.getNext()));
        }
        finally {
            xPathContext.popNamespaceContext();
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ElemTemplate getTemplate(XPathContext xPathContext, int n2, QName qName, int n3, int n4, boolean bl2, DTM dTM) throws TransformerException {
        TemplateSubPatternAssociation templateSubPatternAssociation = this.getHead(xPathContext, n2, dTM);
        if (null != templateSubPatternAssociation) {
            xPathContext.pushNamespaceContextNull();
            xPathContext.pushCurrentNodeAndExpression(n2, n2);
            try {
                do {
                    ElemTemplate elemTemplate;
                    if (n3 > -1 && templateSubPatternAssociation.getImportLevel() > n3) continue;
                    if (templateSubPatternAssociation.getImportLevel() <= n3 - n4) {
                        elemTemplate = null;
                        return elemTemplate;
                    }
                    elemTemplate = templateSubPatternAssociation.getTemplate();
                    xPathContext.setNamespaceContext(elemTemplate);
                    if (templateSubPatternAssociation.m_stepPattern.execute(xPathContext, n2) == NodeTest.SCORE_NONE || !templateSubPatternAssociation.matchMode(qName)) continue;
                    if (bl2) {
                        this.checkConflicts(templateSubPatternAssociation, xPathContext, n2, qName);
                    }
                    ElemTemplate elemTemplate2 = elemTemplate;
                    return elemTemplate2;
                } while (null != (templateSubPatternAssociation = templateSubPatternAssociation.getNext()));
            }
            finally {
                xPathContext.popCurrentNodeAndExpression();
                xPathContext.popNamespaceContext();
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ElemTemplate getTemplate(XPathContext xPathContext, int n2, QName qName, boolean bl2, DTM dTM) throws TransformerException {
        TemplateSubPatternAssociation templateSubPatternAssociation = this.getHead(xPathContext, n2, dTM);
        if (null != templateSubPatternAssociation) {
            xPathContext.pushNamespaceContextNull();
            xPathContext.pushCurrentNodeAndExpression(n2, n2);
            try {
                do {
                    ElemTemplate elemTemplate = templateSubPatternAssociation.getTemplate();
                    xPathContext.setNamespaceContext(elemTemplate);
                    if (templateSubPatternAssociation.m_stepPattern.execute(xPathContext, n2) == NodeTest.SCORE_NONE || !templateSubPatternAssociation.matchMode(qName)) continue;
                    if (bl2) {
                        this.checkConflicts(templateSubPatternAssociation, xPathContext, n2, qName);
                    }
                    ElemTemplate elemTemplate2 = elemTemplate;
                    return elemTemplate2;
                } while (null != (templateSubPatternAssociation = templateSubPatternAssociation.getNext()));
            }
            finally {
                xPathContext.popCurrentNodeAndExpression();
                xPathContext.popNamespaceContext();
            }
        }
        return null;
    }

    public class TemplateWalker {
        private Enumeration hashIterator;
        private boolean inPatterns;
        private TemplateSubPatternAssociation curPattern;
        private Hashtable m_compilerCache = new Hashtable();

        public ElemTemplate next() {
            ElemTemplate elemTemplate;
            ElemTemplateElement elemTemplateElement = null;
            do {
                if (this.inPatterns) {
                    if (null != this.curPattern) {
                        this.curPattern = this.curPattern.getNext();
                    }
                    if (null != this.curPattern) {
                        elemTemplateElement = this.curPattern.getTemplate();
                    } else if (this.hashIterator.hasMoreElements()) {
                        this.curPattern = (TemplateSubPatternAssociation)this.hashIterator.nextElement();
                        elemTemplateElement = this.curPattern.getTemplate();
                    } else {
                        this.inPatterns = false;
                        this.hashIterator = TemplateList.this.m_namedTemplates.elements();
                    }
                }
                if (this.inPatterns) continue;
                if (this.hashIterator.hasMoreElements()) {
                    elemTemplateElement = (ElemTemplate)this.hashIterator.nextElement();
                    continue;
                }
                return null;
            } while (null != (elemTemplate = (ElemTemplate)this.m_compilerCache.get(new Integer(elemTemplateElement.getUid()))));
            this.m_compilerCache.put(new Integer(elemTemplateElement.getUid()), elemTemplateElement);
            return elemTemplateElement;
        }

        private TemplateWalker() {
            this.hashIterator = TemplateList.this.m_patternTable.elements();
            this.inPatterns = true;
            this.curPattern = null;
        }
    }
}

