/*
 * Decompiled with CFR 0.152.
 */
package sun.awt.windows;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.MenuBar;
import java.awt.Rectangle;
import java.awt.image.BufferedImage;
import java.awt.image.ColorModel;
import java.awt.image.DataBuffer;
import java.awt.image.DataBufferInt;
import java.awt.image.Raster;
import java.awt.peer.FramePeer;
import sun.awt.im.InputMethodManager;
import sun.awt.image.ImageRepresentation;
import sun.awt.image.IntegerComponentRaster;
import sun.awt.windows.WComponentPeer;
import sun.awt.windows.WImage;
import sun.awt.windows.WMenuBarPeer;
import sun.awt.windows.WToolkit;
import sun.awt.windows.WWindowPeer;

class WFramePeer
extends WWindowPeer
implements FramePeer {
    public native int getState();

    private static native int getSysIconHeight();

    private static native int getSysIconWidth();

    private static native int getSysMenuHeight();

    private native void clearMaximizedBounds();

    void initialize() {
        super.initialize();
        Frame frame = (Frame)this.target;
        if (frame.getTitle() != null) {
            this.setTitle(frame.getTitle());
        }
        this.setResizable(frame.isResizable());
        this.setState(frame.getExtendedState());
        Image image = frame.getIconImage();
        if (image != null) {
            this.setIconImage(image);
        }
    }

    void notifyIMMOptionChange() {
        InputMethodManager.getInstance().notifyChangeRequest((Component)this.target);
    }

    boolean isTargetUndecorated() {
        return ((Frame)this.target).isUndecorated();
    }

    public native void setState(int var1);

    public void reshape(int n2, int n3, int n4, int n5) {
        Rectangle rectangle = this.constrainBounds(n2, n3, n4, n5);
        if (((Frame)this.target).isUndecorated()) {
            super.reshape(rectangle.x, rectangle.y, rectangle.width, rectangle.height);
        } else {
            this.reshapeFrame(rectangle.x, rectangle.y, rectangle.width, rectangle.height);
        }
    }

    private native void setMaximizedBounds(int var1, int var2, int var3, int var4);

    private native void setIconImageFromIntRasterData(int[] var1, byte[] var2, int var3, int var4, int var5);

    public Dimension getMinimumSize() {
        Dimension dimension = new Dimension();
        if (!((Frame)this.target).isUndecorated()) {
            dimension.setSize(WFramePeer.getSysMinWidth(), WFramePeer.getSysMinHeight());
        }
        if (((Frame)this.target).getMenuBar() != null) {
            dimension.height += WFramePeer.getSysMenuHeight();
        }
        return dimension;
    }

    WFramePeer(Frame frame) {
        super(frame);
        InputMethodManager inputMethodManager = InputMethodManager.getInstance();
        String string = inputMethodManager.getTriggerMenuString();
        if (string != null) {
            this.pSetIMMOption(string);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setIconImage(Image image) {
        if (image == null) {
            this.setIconImageFromIntRasterData(null, null, 0, 0, 0);
        } else {
            int n2;
            Object object;
            int n3 = WFramePeer.getSysIconWidth();
            int n4 = WFramePeer.getSysIconHeight();
            BufferedImage bufferedImage = new BufferedImage(n3, n4, 2);
            Graphics graphics = bufferedImage.getGraphics();
            try {
                if (image instanceof WImage) {
                    object = ((WImage)image).getImageRep();
                    ((ImageRepresentation)object).reconstruct(32);
                }
                graphics.drawImage(image, 0, 0, n3, n4, null);
            }
            finally {
                graphics.dispose();
            }
            object = bufferedImage.getRaster();
            DataBuffer dataBuffer = ((Raster)object).getDataBuffer();
            ColorModel colorModel = bufferedImage.getColorModel();
            byte[] byArray = new byte[n3 * n4 + 0];
            int n5 = 0;
            int n6 = 0;
            boolean bl2 = false;
            n5 = 0;
            for (n6 = 0; n5 < dataBuffer.getSize() && n6 < byArray.length; ++n6) {
                byte by = 0;
                for (n2 = 0; n2 < 8 && n5 < dataBuffer.getSize(); ++n2) {
                    if (colorModel.getAlpha(dataBuffer.getElem(n5++)) == 0) {
                        bl2 = true;
                        by = (byte)(by | 1);
                    } else {
                        by = (byte)(by & 0xFFFFFFFE);
                    }
                    if (n2 >= 7) continue;
                    by = (byte)(by << 1);
                }
                byArray[n6] = by;
            }
            if (!bl2) {
                byArray = null;
            }
            n2 = ((Raster)object).getWidth();
            if (object instanceof IntegerComponentRaster) {
                n2 = ((IntegerComponentRaster)object).getScanlineStride();
            }
            this.setIconImageFromIntRasterData(((DataBufferInt)dataBuffer).getData(), byArray, n2, ((Raster)object).getWidth(), ((Raster)object).getHeight());
        }
    }

    public void setMenuBar(MenuBar menuBar) {
        WMenuBarPeer wMenuBarPeer = (WMenuBarPeer)WToolkit.targetToPeer(menuBar);
        this.setMenuBar0(wMenuBarPeer);
        this.updateInsets(this.insets_);
    }

    public void setMaximizedBounds(Rectangle rectangle) {
        if (rectangle == null) {
            this.clearMaximizedBounds();
        } else {
            this.setMaximizedBounds(rectangle.x, rectangle.y, rectangle.width, rectangle.height);
        }
    }

    native void pSetIMMOption(String var1);

    void create(WComponentPeer wComponentPeer) {
        this.createAwtFrame(wComponentPeer);
    }

    native void createAwtFrame(WComponentPeer var1);

    private native void setMenuBar0(WMenuBarPeer var1);
}

