/*
 * Decompiled with CFR 0.152.
 */
package sun.java2d;

import java.util.Collections;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import java.util.Vector;

public class Spans {
    private static final int kMaxAddsSinceSort = 256;
    private List mSpans = new Vector(256);
    private int mAddsSinceSort = 0;

    public void addInfinite() {
        this.mSpans = null;
    }

    private void sortAndCollapse() {
        Collections.sort(this.mSpans);
        this.mAddsSinceSort = 0;
        Iterator iterator = this.mSpans.iterator();
        Span span = null;
        if (iterator.hasNext()) {
            span = (Span)iterator.next();
        }
        while (iterator.hasNext()) {
            Span span2 = (Span)iterator.next();
            if (span.subsume(span2)) {
                iterator.remove();
                continue;
            }
            span = span2;
        }
    }

    public void add(float f2, float f3) {
        if (this.mSpans != null) {
            this.mSpans.add(new Span(f2, f3));
            if (++this.mAddsSinceSort >= 256) {
                this.sortAndCollapse();
            }
        }
    }

    public boolean intersects(float f2, float f3) {
        boolean bl2;
        if (this.mSpans != null) {
            int n2;
            if (this.mAddsSinceSort > 0) {
                this.sortAndCollapse();
            }
            bl2 = (n2 = Collections.binarySearch(this.mSpans, new Span(f2, f3), SpanIntersection.instance)) >= 0;
        } else {
            bl2 = true;
        }
        return bl2;
    }

    static class Span
    implements Comparable {
        private float mStart;
        private float mEnd;

        final float getEnd() {
            return this.mEnd;
        }

        final float getStart() {
            return this.mStart;
        }

        final void setEnd(float f2) {
            this.mEnd = f2;
        }

        final void setStart(float f2) {
            this.mStart = f2;
        }

        boolean contains(float f2) {
            return this.mStart <= f2 && f2 < this.mEnd;
        }

        Span(float f2, float f3) {
            this.mStart = f2;
            this.mEnd = f3;
        }

        public int compareTo(Object object) {
            Span span = (Span)object;
            float f2 = span.getStart();
            int n2 = this.mStart < f2 ? -1 : (this.mStart > f2 ? 1 : 0);
            return n2;
        }

        public String toString() {
            return "Span: " + this.mStart + " to " + this.mEnd;
        }

        boolean subsume(Span span) {
            boolean bl2 = this.contains(span.mStart);
            if (bl2 && span.mEnd > this.mEnd) {
                this.mEnd = span.mEnd;
            }
            return bl2;
        }
    }

    static class SpanIntersection
    implements Comparator {
        static final SpanIntersection instance = new SpanIntersection();

        private SpanIntersection() {
        }

        public int compare(Object object, Object object2) {
            Span span = (Span)object;
            Span span2 = (Span)object2;
            int n2 = span.getEnd() <= span2.getStart() ? -1 : (span.getStart() >= span2.getEnd() ? 1 : 0);
            return n2;
        }
    }
}

