/*
 * Decompiled with CFR 0.152.
 */
package sun.reflect;

import sun.reflect.ByteVector;

class ByteVectorImpl
implements ByteVector {
    private byte[] data;
    private int pos;

    public int getLength() {
        return this.pos + 1;
    }

    public ByteVectorImpl() {
        this(100);
    }

    public void trim() {
        if (this.pos != this.data.length - 1) {
            byte[] byArray = new byte[this.pos + 1];
            System.arraycopy(this.data, 0, byArray, 0, this.pos + 1);
            this.data = byArray;
        }
    }

    public byte[] getData() {
        return this.data;
    }

    public void add(byte by) {
        if (++this.pos >= this.data.length) {
            this.resize(this.pos);
        }
        this.data[this.pos] = by;
    }

    public byte get(int n2) {
        if (n2 >= this.data.length) {
            this.resize(n2);
            this.pos = n2;
        }
        return this.data[n2];
    }

    public ByteVectorImpl(int n2) {
        this.data = new byte[n2];
        this.pos = -1;
    }

    private void resize(int n2) {
        if (n2 <= 2 * this.data.length) {
            n2 = 2 * this.data.length;
        }
        byte[] byArray = new byte[n2];
        System.arraycopy(this.data, 0, byArray, 0, this.data.length);
        this.data = byArray;
    }

    public void put(int n2, byte by) {
        if (n2 >= this.data.length) {
            this.resize(n2);
            this.pos = n2;
        }
        this.data[n2] = by;
    }
}

