/*
 * Decompiled with CFR 0.152.
 */
package sun.security.pkcs;

import java.io.IOException;
import java.io.OutputStream;
import java.util.Hashtable;
import sun.security.pkcs.PKCS9Attribute;
import sun.security.pkcs.ParsingException;
import sun.security.util.DerEncoder;
import sun.security.util.DerInputStream;
import sun.security.util.DerOutputStream;
import sun.security.util.DerValue;
import sun.security.util.ObjectIdentifier;

public class PKCS9Attributes {
    private final Hashtable attributes = new Hashtable(3);
    private final Hashtable permittedAttributes;
    private final byte[] derEncoding;
    private boolean ignoreUnsupportedAttributes = false;

    private byte[] generateDerEncoding() throws IOException {
        DerOutputStream derOutputStream = new DerOutputStream();
        Object[] objectArray = this.attributes.values().toArray();
        derOutputStream.putOrderedSetOf((byte)49, PKCS9Attributes.castToDerEncoder(objectArray));
        return derOutputStream.toByteArray();
    }

    public byte[] getDerEncoding() throws IOException {
        return (byte[])this.derEncoding.clone();
    }

    public void encode(byte by, OutputStream outputStream) throws IOException {
        outputStream.write(by);
        outputStream.write(this.derEncoding, 1, this.derEncoding.length - 1);
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer(200);
        stringBuffer.append("PKCS9 Attributes: [\n\t");
        boolean bl2 = true;
        for (int i2 = 1; i2 < PKCS9Attribute.PKCS9_OIDS.length; ++i2) {
            PKCS9Attribute pKCS9Attribute = this.getAttribute(PKCS9Attribute.PKCS9_OIDS[i2]);
            if (pKCS9Attribute == null) continue;
            if (bl2) {
                bl2 = false;
            } else {
                stringBuffer.append(";\n\t");
            }
            stringBuffer.append(pKCS9Attribute.toString());
        }
        stringBuffer.append("\n\t] (end PKCS9 Attributes)");
        return stringBuffer.toString();
    }

    public PKCS9Attribute[] getAttributes() {
        PKCS9Attribute[] pKCS9AttributeArray = new PKCS9Attribute[this.attributes.size()];
        int n2 = 0;
        for (int i2 = 1; i2 < PKCS9Attribute.PKCS9_OIDS.length && n2 < pKCS9AttributeArray.length; ++i2) {
            pKCS9AttributeArray[n2] = this.getAttribute(PKCS9Attribute.PKCS9_OIDS[i2]);
            if (pKCS9AttributeArray[n2] == null) continue;
            ++n2;
        }
        return pKCS9AttributeArray;
    }

    public PKCS9Attributes(PKCS9Attribute[] pKCS9AttributeArray) throws IllegalArgumentException, IOException {
        for (int i2 = 0; i2 < pKCS9AttributeArray.length; ++i2) {
            ObjectIdentifier objectIdentifier = pKCS9AttributeArray[i2].getOID();
            if (this.attributes.containsKey(objectIdentifier)) {
                throw new IllegalArgumentException("PKCSAttribute " + pKCS9AttributeArray[i2].getOID() + " duplicated while constructing " + "PKCS9Attributes.");
            }
            this.attributes.put(objectIdentifier, pKCS9AttributeArray[i2]);
        }
        this.derEncoding = this.generateDerEncoding();
        this.permittedAttributes = null;
    }

    public PKCS9Attributes(DerInputStream derInputStream) throws IOException {
        this(derInputStream, false);
    }

    private byte[] decode(DerInputStream derInputStream) throws IOException {
        DerValue derValue = derInputStream.getDerValue();
        byte[] byArray = derValue.toByteArray();
        byArray[0] = 49;
        DerInputStream derInputStream2 = new DerInputStream(byArray);
        DerValue[] derValueArray = derInputStream2.getSet(3, true);
        boolean bl2 = true;
        for (int i2 = 0; i2 < derValueArray.length; ++i2) {
            PKCS9Attribute pKCS9Attribute;
            try {
                pKCS9Attribute = new PKCS9Attribute(derValueArray[i2]);
            }
            catch (ParsingException parsingException) {
                if (this.ignoreUnsupportedAttributes) {
                    bl2 = false;
                    continue;
                }
                throw parsingException;
            }
            ObjectIdentifier objectIdentifier = pKCS9Attribute.getOID();
            if (this.attributes.get(objectIdentifier) != null) {
                throw new IOException("Duplicate PKCS9 attribute: " + objectIdentifier);
            }
            if (this.permittedAttributes != null && !this.permittedAttributes.containsKey(objectIdentifier)) {
                throw new IOException("Attribute " + objectIdentifier + " not permitted in this attribute set");
            }
            this.attributes.put(objectIdentifier, pKCS9Attribute);
        }
        return bl2 ? byArray : this.generateDerEncoding();
    }

    public PKCS9Attributes(DerInputStream derInputStream, boolean bl2) throws IOException {
        this.ignoreUnsupportedAttributes = bl2;
        this.derEncoding = this.decode(derInputStream);
        this.permittedAttributes = null;
    }

    public Object getAttributeValue(String string) throws IOException {
        ObjectIdentifier objectIdentifier = PKCS9Attribute.getOID(string);
        if (objectIdentifier == null) {
            throw new IOException("Attribute name " + string + " not recognized or not supported.");
        }
        return this.getAttributeValue(objectIdentifier);
    }

    public Object getAttributeValue(ObjectIdentifier objectIdentifier) throws IOException {
        try {
            Object object = this.getAttribute(objectIdentifier).getValue();
            return object;
        }
        catch (NullPointerException nullPointerException) {
            throw new IOException("No value found for attribute " + objectIdentifier);
        }
    }

    public PKCS9Attribute getAttribute(String string) {
        return (PKCS9Attribute)this.attributes.get(PKCS9Attribute.getOID(string));
    }

    public PKCS9Attribute getAttribute(ObjectIdentifier objectIdentifier) {
        return (PKCS9Attribute)this.attributes.get(objectIdentifier);
    }

    static DerEncoder[] castToDerEncoder(Object[] objectArray) {
        DerEncoder[] derEncoderArray = new DerEncoder[objectArray.length];
        for (int i2 = 0; i2 < derEncoderArray.length; ++i2) {
            derEncoderArray[i2] = (DerEncoder)objectArray[i2];
        }
        return derEncoderArray;
    }

    public PKCS9Attributes(ObjectIdentifier[] objectIdentifierArray, DerInputStream derInputStream) throws IOException {
        if (objectIdentifierArray != null) {
            this.permittedAttributes = new Hashtable(objectIdentifierArray.length);
            for (int i2 = 0; i2 < objectIdentifierArray.length; ++i2) {
                this.permittedAttributes.put(objectIdentifierArray[i2], objectIdentifierArray[i2]);
            }
        } else {
            this.permittedAttributes = null;
        }
        this.derEncoding = this.decode(derInputStream);
    }
}

