/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.swt.graphics;

import java.io.InputStream;
import org.eclipse.swt.SWT;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.ImageDataLoader;
import org.eclipse.swt.graphics.PaletteData;
import org.eclipse.swt.graphics.RGB;
import org.eclipse.swt.internal.CloneableCompatibility;

public final class ImageData
implements CloneableCompatibility {
    public int width;
    public int height;
    public int depth;
    public int scanlinePad;
    public int bytesPerLine;
    public byte[] data;
    public PaletteData palette;
    public int transparentPixel;
    public byte[] maskData;
    public int maskPad;
    public byte[] alphaData;
    public int alpha;
    public int type;
    public int x;
    public int y;
    public int disposalMethod;
    public int delayTime;
    static final byte[][] ANY_TO_EIGHT = new byte[9][];
    static final byte[] ONE_TO_ONE_MAPPING;
    static final int[][] DITHER_MATRIX;
    static final int BLIT_SRC = 1;
    static final int BLIT_ALPHA = 2;
    static final int BLIT_DITHER = 4;
    static final int ALPHA_OPAQUE = 255;
    static final int ALPHA_TRANSPARENT = 0;
    static final int ALPHA_CHANNEL_SEPARATE = -1;
    static final int ALPHA_CHANNEL_SOURCE = -2;
    static final int ALPHA_MASK_UNPACKED = -3;
    static final int ALPHA_MASK_PACKED = -4;
    static final int ALPHA_MASK_INDEX = -5;
    static final int ALPHA_MASK_RGB = -6;
    static final int LSB_FIRST = 0;
    static final int MSB_FIRST = 1;
    private static final int TYPE_GENERIC_8 = 0;
    private static final int TYPE_GENERIC_16_MSB = 1;
    private static final int TYPE_GENERIC_16_LSB = 2;
    private static final int TYPE_GENERIC_24 = 3;
    private static final int TYPE_GENERIC_32_MSB = 4;
    private static final int TYPE_GENERIC_32_LSB = 5;
    private static final int TYPE_INDEX_8 = 6;
    private static final int TYPE_INDEX_4 = 7;
    private static final int TYPE_INDEX_2 = 8;
    private static final int TYPE_INDEX_1_MSB = 9;
    private static final int TYPE_INDEX_1_LSB = 10;

    static {
        int n2 = 0;
        while (n2 < 9) {
            ImageData.ANY_TO_EIGHT[n2] = new byte[1 << n2];
            byte[] byArray = ImageData.ANY_TO_EIGHT[n2];
            if (n2 != 0) {
                int n3 = 0;
                int n4 = 65536;
                while ((n4 >>= n2) != 0) {
                    n3 |= n4;
                }
                n4 = 0;
                int n5 = 0;
                while (n4 < 65536) {
                    byArray[n5++] = (byte)(n4 >> 8);
                    n4 += n3;
                }
            }
            ++n2;
        }
        ONE_TO_ONE_MAPPING = ANY_TO_EIGHT[8];
        int[][] nArrayArray = new int[8][];
        nArrayArray[0] = new int[]{0xFC0000, 0x7C0000, 0xDC0000, 0x5C0000, 0xF40000, 0x740000, 0xD40000, 0x540000};
        nArrayArray[1] = new int[]{0x3C0000, 0xBC0000, 0x1C0000, 0x9C0000, 0x340000, 0xB40000, 0x140000, 0x940000};
        nArrayArray[2] = new int[]{0xCC0000, 0x4C0000, 0xEC0000, 0x6C0000, 0xC40000, 0x440000, 0xE40000, 0x640000};
        nArrayArray[3] = new int[]{786432, 0x8C0000, 0x2C0000, 0xAC0000, 262144, 0x840000, 0x240000, 0xA40000};
        nArrayArray[4] = new int[]{0xF00000, 0x700000, 0xD00000, 0x500000, 0xF80000, 0x780000, 0xD80000, 0x580000};
        nArrayArray[5] = new int[]{0x300000, 0xB00000, 0x100000, 0x900000, 0x380000, 0xB80000, 0x180000, 0x980000};
        nArrayArray[6] = new int[]{0xC00000, 0x400000, 0xE00000, 0x600000, 0xC80000, 0x480000, 0xE80000, 0x680000};
        int[] nArray = new int[8];
        nArray[1] = 0x800000;
        nArray[2] = 0x200000;
        nArray[3] = 0xA00000;
        nArray[4] = 524288;
        nArray[5] = 0x880000;
        nArray[6] = 0x280000;
        nArray[7] = 0xA80000;
        nArrayArray[7] = nArray;
        DITHER_MATRIX = nArrayArray;
    }

    public ImageData(int n2, int n3, int n4, PaletteData paletteData) {
        this(n2, n3, n4, paletteData, 4, null, 0, null, null, -1, -1, -1, 0, 0, 0, 0);
    }

    public ImageData(int n2, int n3, int n4, PaletteData paletteData, int n5, byte[] byArray) {
        this(n2, n3, n4, paletteData, n5, ImageData.checkData(byArray), 0, null, null, -1, -1, -1, 0, 0, 0, 0);
    }

    public ImageData(InputStream inputStream) {
        ImageData[] imageDataArray = ImageDataLoader.load(inputStream);
        if (imageDataArray.length < 1) {
            SWT.error(40);
        }
        ImageData imageData = imageDataArray[0];
        this.setAllFields(imageData.width, imageData.height, imageData.depth, imageData.scanlinePad, imageData.bytesPerLine, imageData.data, imageData.palette, imageData.transparentPixel, imageData.maskData, imageData.maskPad, imageData.alphaData, imageData.alpha, imageData.type, imageData.x, imageData.y, imageData.disposalMethod, imageData.delayTime);
    }

    public ImageData(String string) {
        ImageData[] imageDataArray = ImageDataLoader.load(string);
        if (imageDataArray.length < 1) {
            SWT.error(40);
        }
        ImageData imageData = imageDataArray[0];
        this.setAllFields(imageData.width, imageData.height, imageData.depth, imageData.scanlinePad, imageData.bytesPerLine, imageData.data, imageData.palette, imageData.transparentPixel, imageData.maskData, imageData.maskPad, imageData.alphaData, imageData.alpha, imageData.type, imageData.x, imageData.y, imageData.disposalMethod, imageData.delayTime);
    }

    ImageData() {
    }

    ImageData(int n2, int n3, int n4, PaletteData paletteData, int n5, byte[] byArray, int n6, byte[] byArray2, byte[] byArray3, int n7, int n8, int n9, int n10, int n11, int n12, int n13) {
        if (paletteData == null) {
            SWT.error(4);
        }
        if (n4 != 1 && n4 != 2 && n4 != 4 && n4 != 8 && n4 != 16 && n4 != 24 && n4 != 32) {
            SWT.error(5);
        }
        if (n2 <= 0 || n3 <= 0) {
            SWT.error(5);
        }
        if (n5 == 0) {
            SWT.error(7);
        }
        int n14 = ((n2 * n4 + 7) / 8 + (n5 - 1)) / n5 * n5;
        this.setAllFields(n2, n3, n4, n5, n14, byArray != null ? byArray : new byte[n14 * n3], paletteData, n8, byArray2, n6, byArray3, n7, n9, n10, n11, n12, n13);
    }

    void setAllFields(int n2, int n3, int n4, int n5, int n6, byte[] byArray, PaletteData paletteData, int n7, byte[] byArray2, int n8, byte[] byArray3, int n9, int n10, int n11, int n12, int n13, int n14) {
        this.width = n2;
        this.height = n3;
        this.depth = n4;
        this.scanlinePad = n5;
        this.bytesPerLine = n6;
        this.data = byArray;
        this.palette = paletteData;
        this.transparentPixel = n7;
        this.maskData = byArray2;
        this.maskPad = n8;
        this.alphaData = byArray3;
        this.alpha = n9;
        this.type = n10;
        this.x = n11;
        this.y = n12;
        this.disposalMethod = n13;
        this.delayTime = n14;
    }

    public static ImageData internal_new(int n2, int n3, int n4, PaletteData paletteData, int n5, byte[] byArray, int n6, byte[] byArray2, byte[] byArray3, int n7, int n8, int n9, int n10, int n11, int n12, int n13) {
        return new ImageData(n2, n3, n4, paletteData, n5, byArray, n6, byArray2, byArray3, n7, n8, n9, n10, n11, n12, n13);
    }

    ImageData colorMaskImage(int n2) {
        ImageData imageData = new ImageData(this.width, this.height, 1, ImageData.bwPalette(), 2, null, 0, null, null, -1, -1, -1, 0, 0, 0, 0);
        int[] nArray = new int[this.width];
        int n3 = 0;
        while (n3 < this.height) {
            this.getPixels(0, n3, this.width, nArray, 0);
            int n4 = 0;
            while (n4 < this.width) {
                nArray[n4] = n2 != -1 && nArray[n4] == n2 ? 0 : 1;
                ++n4;
            }
            imageData.setPixels(0, n3, this.width, nArray, 0);
            ++n3;
        }
        return imageData;
    }

    static byte[] checkData(byte[] byArray) {
        if (byArray == null) {
            SWT.error(4);
        }
        return byArray;
    }

    public Object clone() {
        byte[] byArray = new byte[this.data.length];
        System.arraycopy(this.data, 0, byArray, 0, this.data.length);
        byte[] byArray2 = null;
        if (this.maskData != null) {
            byArray2 = new byte[this.maskData.length];
            System.arraycopy(this.maskData, 0, byArray2, 0, this.maskData.length);
        }
        byte[] byArray3 = null;
        if (this.alphaData != null) {
            byArray3 = new byte[this.alphaData.length];
            System.arraycopy(this.alphaData, 0, byArray3, 0, this.alphaData.length);
        }
        return new ImageData(this.width, this.height, this.depth, this.palette, this.scanlinePad, byArray, this.maskPad, byArray2, byArray3, this.alpha, this.transparentPixel, this.type, this.x, this.y, this.disposalMethod, this.delayTime);
    }

    public int getAlpha(int n2, int n3) {
        if (n2 >= this.width || n3 >= this.height || n2 < 0 || n3 < 0) {
            SWT.error(5);
        }
        if (this.alphaData == null) {
            return 255;
        }
        return this.alphaData[n3 * this.width + n2] & 0xFF;
    }

    public void getAlphas(int n2, int n3, int n4, byte[] byArray, int n5) {
        if (byArray == null) {
            SWT.error(4);
        }
        if (n4 < 0 || n2 >= this.width || n3 >= this.height || n2 < 0 || n3 < 0) {
            SWT.error(5);
        }
        if (n4 == 0) {
            return;
        }
        if (this.alphaData == null) {
            int n6 = n5 + n4;
            int n7 = n5;
            while (n7 < n6) {
                byArray[n7] = -1;
                ++n7;
            }
            return;
        }
        System.arraycopy(this.alphaData, n3 * this.width + n2, byArray, n5, n4);
    }

    public int getPixel(int n2, int n3) {
        if (n2 >= this.width || n3 >= this.height || n2 < 0 || n3 < 0) {
            SWT.error(5);
        }
        switch (this.depth) {
            case 32: {
                int n4 = n3 * this.bytesPerLine + n2 * 4;
                return ((this.data[n4] & 0xFF) << 24) + ((this.data[n4 + 1] & 0xFF) << 16) + ((this.data[n4 + 2] & 0xFF) << 8) + (this.data[n4 + 3] & 0xFF);
            }
            case 24: {
                int n5 = n3 * this.bytesPerLine + n2 * 3;
                return ((this.data[n5] & 0xFF) << 16) + ((this.data[n5 + 1] & 0xFF) << 8) + (this.data[n5 + 2] & 0xFF);
            }
            case 16: {
                int n6 = n3 * this.bytesPerLine + n2 * 2;
                return ((this.data[n6 + 1] & 0xFF) << 8) + (this.data[n6] & 0xFF);
            }
            case 8: {
                int n7 = n3 * this.bytesPerLine + n2;
                return this.data[n7] & 0xFF;
            }
            case 4: {
                int n8 = n3 * this.bytesPerLine + (n2 >> 1);
                int n9 = this.data[n8] & 0xFF;
                if ((n2 & 1) == 0) {
                    return n9 >> 4;
                }
                return n9 & 0xF;
            }
            case 2: {
                int n10 = n3 * this.bytesPerLine + (n2 >> 2);
                int n11 = this.data[n10] & 0xFF;
                int n12 = 3 - n2 % 4;
                int n13 = 3 << n12 * 2;
                return (n11 & n13) >> n12 * 2;
            }
            case 1: {
                int n14 = n3 * this.bytesPerLine + (n2 >> 3);
                int n15 = this.data[n14] & 0xFF;
                int n16 = 1 << 7 - (n2 & 7);
                if ((n15 & n16) == 0) {
                    return 0;
                }
                return 1;
            }
        }
        SWT.error(38);
        return 0;
    }

    public void getPixels(int n2, int n3, int n4, byte[] byArray, int n5) {
        if (byArray == null) {
            SWT.error(4);
        }
        if (n4 < 0 || n2 >= this.width || n3 >= this.height || n2 < 0 || n3 < 0) {
            SWT.error(5);
        }
        if (n4 == 0) {
            return;
        }
        int n6 = 0;
        int n7 = n4;
        int n8 = n5;
        int n9 = n2;
        int n10 = n3;
        switch (this.depth) {
            case 8: {
                int n11 = n3 * this.bytesPerLine + n2;
                int n12 = 0;
                while (n12 < n4) {
                    byArray[n8] = this.data[n11];
                    ++n8;
                    if (++n9 >= this.width) {
                        n11 = ++n10 * this.bytesPerLine;
                        n9 = 0;
                    } else {
                        ++n11;
                    }
                    ++n12;
                }
                return;
            }
            case 4: {
                int n13;
                int n14 = n3 * this.bytesPerLine + (n2 >> 1);
                if ((n2 & 1) == 1) {
                    n13 = this.data[n14] & 0xFF;
                    byArray[n8] = (byte)(n13 & 0xF);
                    ++n8;
                    --n7;
                    if (++n9 >= this.width) {
                        n14 = ++n10 * this.bytesPerLine;
                        n9 = 0;
                    } else {
                        ++n14;
                    }
                }
                while (n7 > 1) {
                    n13 = this.data[n14] & 0xFF;
                    byArray[n8] = (byte)(n13 >> 4);
                    ++n8;
                    --n7;
                    if (++n9 >= this.width) {
                        n14 = ++n10 * this.bytesPerLine;
                        n9 = 0;
                        continue;
                    }
                    byArray[n8] = (byte)(n13 & 0xF);
                    ++n8;
                    --n7;
                    if (++n9 >= this.width) {
                        n14 = ++n10 * this.bytesPerLine;
                        n9 = 0;
                        continue;
                    }
                    ++n14;
                }
                if (n7 > 0) {
                    n13 = this.data[n14] & 0xFF;
                    byArray[n8] = (byte)(n13 >> 4);
                }
                return;
            }
            case 2: {
                int n15 = n3 * this.bytesPerLine + (n2 >> 2);
                int n16 = this.data[n15] & 0xFF;
                while (n7 > 0) {
                    int n17 = 3 - n9 % 4;
                    n6 = 3 << n17 * 2;
                    byArray[n8] = (byte)((n16 & n6) >> n17 * 2);
                    ++n8;
                    --n7;
                    if (++n9 >= this.width) {
                        n15 = ++n10 * this.bytesPerLine;
                        if (n7 > 0) {
                            n16 = this.data[n15] & 0xFF;
                        }
                        n9 = 0;
                        continue;
                    }
                    if (n17 != 0) continue;
                    n16 = this.data[++n15] & 0xFF;
                }
                return;
            }
            case 1: {
                int n18 = n3 * this.bytesPerLine + (n2 >> 3);
                int n19 = this.data[n18] & 0xFF;
                while (n7 > 0) {
                    n6 = 1 << 7 - (n9 & 7);
                    byArray[n8] = (n19 & n6) == 0 ? (byte)0 : 1;
                    ++n8;
                    --n7;
                    if (++n9 >= this.width) {
                        n18 = ++n10 * this.bytesPerLine;
                        if (n7 > 0) {
                            n19 = this.data[n18] & 0xFF;
                        }
                        n9 = 0;
                        continue;
                    }
                    if (n6 != 1) continue;
                    ++n18;
                    if (n7 <= 0) continue;
                    n19 = this.data[n18] & 0xFF;
                }
                return;
            }
        }
        SWT.error(38);
    }

    public void getPixels(int n2, int n3, int n4, int[] nArray, int n5) {
        if (nArray == null) {
            SWT.error(4);
        }
        if (n4 < 0 || n2 >= this.width || n3 >= this.height || n2 < 0 || n3 < 0) {
            SWT.error(5);
        }
        if (n4 == 0) {
            return;
        }
        int n6 = n4;
        int n7 = n5;
        int n8 = n2;
        int n9 = n3;
        switch (this.depth) {
            case 32: {
                int n10 = n3 * this.bytesPerLine + n2 * 4;
                n7 = n5;
                int n11 = 0;
                while (n11 < n4) {
                    nArray[n7] = (this.data[n10] & 0xFF) << 24 | (this.data[n10 + 1] & 0xFF) << 16 | (this.data[n10 + 2] & 0xFF) << 8 | this.data[n10 + 3] & 0xFF;
                    ++n7;
                    if (++n8 >= this.width) {
                        n10 = ++n9 * this.bytesPerLine;
                        n8 = 0;
                    } else {
                        n10 += 4;
                    }
                    ++n11;
                }
                return;
            }
            case 24: {
                int n12 = n3 * this.bytesPerLine + n2 * 3;
                int n13 = 0;
                while (n13 < n4) {
                    nArray[n7] = (this.data[n12] & 0xFF) << 16 | (this.data[n12 + 1] & 0xFF) << 8 | this.data[n12 + 2] & 0xFF;
                    ++n7;
                    if (++n8 >= this.width) {
                        n12 = ++n9 * this.bytesPerLine;
                        n8 = 0;
                    } else {
                        n12 += 3;
                    }
                    ++n13;
                }
                return;
            }
            case 16: {
                int n14 = n3 * this.bytesPerLine + n2 * 2;
                int n15 = 0;
                while (n15 < n4) {
                    nArray[n7] = ((this.data[n14 + 1] & 0xFF) << 8) + (this.data[n14] & 0xFF);
                    ++n7;
                    if (++n8 >= this.width) {
                        n14 = ++n9 * this.bytesPerLine;
                        n8 = 0;
                    } else {
                        n14 += 2;
                    }
                    ++n15;
                }
                return;
            }
            case 8: {
                int n16 = n3 * this.bytesPerLine + n2;
                int n17 = 0;
                while (n17 < n4) {
                    nArray[n7] = this.data[n16] & 0xFF;
                    ++n7;
                    if (++n8 >= this.width) {
                        n16 = ++n9 * this.bytesPerLine;
                        n8 = 0;
                    } else {
                        ++n16;
                    }
                    ++n17;
                }
                return;
            }
            case 4: {
                int n18;
                int n19 = n3 * this.bytesPerLine + (n2 >> 1);
                if ((n2 & 1) == 1) {
                    n18 = this.data[n19] & 0xFF;
                    nArray[n7] = n18 & 0xF;
                    ++n7;
                    --n6;
                    if (++n8 >= this.width) {
                        n19 = ++n9 * this.bytesPerLine;
                        n8 = 0;
                    } else {
                        ++n19;
                    }
                }
                while (n6 > 1) {
                    n18 = this.data[n19] & 0xFF;
                    nArray[n7] = n18 >> 4;
                    ++n7;
                    --n6;
                    if (++n8 >= this.width) {
                        n19 = ++n9 * this.bytesPerLine;
                        n8 = 0;
                        continue;
                    }
                    nArray[n7] = n18 & 0xF;
                    ++n7;
                    --n6;
                    if (++n8 >= this.width) {
                        n19 = ++n9 * this.bytesPerLine;
                        n8 = 0;
                        continue;
                    }
                    ++n19;
                }
                if (n6 > 0) {
                    n18 = this.data[n19] & 0xFF;
                    nArray[n7] = n18 >> 4;
                }
                return;
            }
            case 2: {
                int n20 = n3 * this.bytesPerLine + (n2 >> 2);
                int n21 = this.data[n20] & 0xFF;
                while (n6 > 0) {
                    int n22 = 3 - n8 % 4;
                    int n23 = 3 << n22 * 2;
                    nArray[n7] = (byte)((n21 & n23) >> n22 * 2);
                    ++n7;
                    --n6;
                    if (++n8 >= this.width) {
                        n20 = ++n9 * this.bytesPerLine;
                        if (n6 > 0) {
                            n21 = this.data[n20] & 0xFF;
                        }
                        n8 = 0;
                        continue;
                    }
                    if (n22 != 0) continue;
                    n21 = this.data[++n20] & 0xFF;
                }
                return;
            }
            case 1: {
                int n24 = n3 * this.bytesPerLine + (n2 >> 3);
                int n25 = this.data[n24] & 0xFF;
                while (n6 > 0) {
                    int n26 = 1 << 7 - (n8 & 7);
                    nArray[n7] = (n25 & n26) == 0 ? 0 : 1;
                    ++n7;
                    --n6;
                    if (++n8 >= this.width) {
                        n24 = ++n9 * this.bytesPerLine;
                        if (n6 > 0) {
                            n25 = this.data[n24] & 0xFF;
                        }
                        n8 = 0;
                        continue;
                    }
                    if (n26 != 1) continue;
                    ++n24;
                    if (n6 <= 0) continue;
                    n25 = this.data[n24] & 0xFF;
                }
                return;
            }
        }
        SWT.error(38);
    }

    public RGB[] getRGBs() {
        return this.palette.getRGBs();
    }

    public ImageData getTransparencyMask() {
        if (this.getTransparencyType() == 2) {
            return new ImageData(this.width, this.height, 1, ImageData.bwPalette(), this.maskPad, this.maskData);
        }
        return this.colorMaskImage(this.transparentPixel);
    }

    public int getTransparencyType() {
        if (this.maskData != null) {
            return 2;
        }
        if (this.transparentPixel != -1) {
            return 4;
        }
        if (this.alphaData != null) {
            return 1;
        }
        return 0;
    }

    int getByteOrder() {
        return this.depth != 16 ? 1 : 0;
    }

    public ImageData scaledTo(int n2, int n3) {
        boolean bl2;
        boolean bl3;
        boolean bl4 = bl3 = n2 < 0;
        if (bl3) {
            n2 = -n2;
        }
        boolean bl5 = bl2 = n3 < 0;
        if (bl2) {
            n3 = -n3;
        }
        ImageData imageData = new ImageData(n2, n3, this.depth, this.palette, this.scanlinePad, null, 0, null, null, -1, this.transparentPixel, this.type, this.x, this.y, this.disposalMethod, this.delayTime);
        if (this.palette.isDirect) {
            ImageData.blit(1, this.data, this.depth, this.bytesPerLine, this.getByteOrder(), 0, 0, this.width, this.height, 0, 0, 0, 255, null, 0, 0, 0, imageData.data, imageData.depth, imageData.bytesPerLine, imageData.getByteOrder(), 0, 0, imageData.width, imageData.height, 0, 0, 0, bl3, bl2);
        } else {
            ImageData.blit(1, this.data, this.depth, this.bytesPerLine, this.getByteOrder(), 0, 0, this.width, this.height, null, null, null, 255, null, 0, 0, 0, imageData.data, imageData.depth, imageData.bytesPerLine, imageData.getByteOrder(), 0, 0, imageData.width, imageData.height, null, null, null, bl3, bl2);
        }
        if (this.maskData != null) {
            imageData.maskPad = this.maskPad;
            int n4 = (imageData.width + 7) / 8;
            n4 = (n4 + (imageData.maskPad - 1)) / imageData.maskPad * imageData.maskPad;
            imageData.maskData = new byte[n4 * imageData.height];
            int n5 = (this.width + 7) / 8;
            n5 = (n5 + (this.maskPad - 1)) / this.maskPad * this.maskPad;
            ImageData.blit(1, this.maskData, 1, n5, 1, 0, 0, this.width, this.height, null, null, null, 255, null, 0, 0, 0, imageData.maskData, 1, n4, 1, 0, 0, imageData.width, imageData.height, null, null, null, bl3, bl2);
        } else if (this.alpha != -1) {
            imageData.alpha = this.alpha;
        } else if (this.alphaData != null) {
            imageData.alphaData = new byte[imageData.width * imageData.height];
            ImageData.blit(1, this.alphaData, 8, this.width, 1, 0, 0, this.width, this.height, null, null, null, 255, null, 0, 0, 0, imageData.alphaData, 8, imageData.width, 1, 0, 0, imageData.width, imageData.height, null, null, null, bl3, bl2);
        }
        return imageData;
    }

    public void setAlpha(int n2, int n3, int n4) {
        if (n2 >= this.width || n3 >= this.height || n2 < 0 || n3 < 0 || n4 < 0 || n4 > 255) {
            SWT.error(5);
        }
        if (this.alphaData == null) {
            this.alphaData = new byte[this.width * this.height];
        }
        this.alphaData[n3 * this.width + n2] = (byte)n4;
    }

    public void setAlphas(int n2, int n3, int n4, byte[] byArray, int n5) {
        if (byArray == null) {
            SWT.error(4);
        }
        if (n4 < 0 || n2 >= this.width || n3 >= this.height || n2 < 0 || n3 < 0) {
            SWT.error(5);
        }
        if (n4 == 0) {
            return;
        }
        if (this.alphaData == null) {
            this.alphaData = new byte[this.width * this.height];
        }
        System.arraycopy(byArray, n5, this.alphaData, n3 * this.width + n2, n4);
    }

    public void setPixel(int n2, int n3, int n4) {
        if (n2 >= this.width || n3 >= this.height || n2 < 0 || n3 < 0) {
            SWT.error(5);
        }
        switch (this.depth) {
            case 32: {
                int n5 = n3 * this.bytesPerLine + n2 * 4;
                this.data[n5] = (byte)(n4 >> 24 & 0xFF);
                this.data[n5 + 1] = (byte)(n4 >> 16 & 0xFF);
                this.data[n5 + 2] = (byte)(n4 >> 8 & 0xFF);
                this.data[n5 + 3] = (byte)(n4 & 0xFF);
                return;
            }
            case 24: {
                int n6 = n3 * this.bytesPerLine + n2 * 3;
                this.data[n6] = (byte)(n4 >> 16 & 0xFF);
                this.data[n6 + 1] = (byte)(n4 >> 8 & 0xFF);
                this.data[n6 + 2] = (byte)(n4 & 0xFF);
                return;
            }
            case 16: {
                int n7 = n3 * this.bytesPerLine + n2 * 2;
                this.data[n7 + 1] = (byte)(n4 >> 8 & 0xFF);
                this.data[n7] = (byte)(n4 & 0xFF);
                return;
            }
            case 8: {
                int n8 = n3 * this.bytesPerLine + n2;
                this.data[n8] = (byte)(n4 & 0xFF);
                return;
            }
            case 4: {
                int n9 = n3 * this.bytesPerLine + (n2 >> 1);
                this.data[n9] = (n2 & 1) == 0 ? (byte)(this.data[n9] & 0xF | (n4 & 0xF) << 4) : (byte)(this.data[n9] & 0xF0 | n4 & 0xF);
                return;
            }
            case 2: {
                int n10 = n3 * this.bytesPerLine + (n2 >> 2);
                byte by2 = this.data[n10];
                int n11 = 3 - n2 % 4;
                int n12 = 0xFF ^ 3 << n11 * 2;
                this.data[n10] = (byte)(this.data[n10] & n12 | n4 << n11 * 2);
                return;
            }
            case 1: {
                int n13 = n3 * this.bytesPerLine + (n2 >> 3);
                byte by3 = this.data[n13];
                int n14 = 1 << 7 - (n2 & 7);
                this.data[n13] = (n4 & 1) == 1 ? (byte)(by3 | n14) : (byte)(by3 & ~n14);
                return;
            }
        }
        SWT.error(38);
    }

    public void setPixels(int n2, int n3, int n4, byte[] byArray, int n5) {
        if (byArray == null) {
            SWT.error(4);
        }
        if (n4 < 0 || n2 >= this.width || n3 >= this.height || n2 < 0 || n3 < 0) {
            SWT.error(5);
        }
        if (n4 == 0) {
            return;
        }
        int n6 = n4;
        int n7 = n5;
        int n8 = n2;
        int n9 = n3;
        switch (this.depth) {
            case 8: {
                int n10 = n3 * this.bytesPerLine + n2;
                int n11 = 0;
                while (n11 < n4) {
                    this.data[n10] = (byte)(byArray[n7] & 0xFF);
                    ++n7;
                    if (++n8 >= this.width) {
                        n10 = ++n9 * this.bytesPerLine;
                        n8 = 0;
                    } else {
                        ++n10;
                    }
                    ++n11;
                }
                return;
            }
            case 4: {
                int n12 = n3 * this.bytesPerLine + (n2 >> 1);
                boolean bl2 = (n2 & 1) == 0;
                while (n6 > 0) {
                    int n13 = byArray[n7] & 0xF;
                    this.data[n12] = bl2 ? (byte)(this.data[n12] & 0xF | n13 << 4) : (byte)(this.data[n12] & 0xF0 | n13);
                    ++n7;
                    --n6;
                    if (++n8 >= this.width) {
                        n12 = ++n9 * this.bytesPerLine;
                        bl2 = true;
                        n8 = 0;
                        continue;
                    }
                    if (!bl2) {
                        ++n12;
                    }
                    boolean bl3 = bl2 = !bl2;
                }
                return;
            }
            case 2: {
                byte[] byArray2 = new byte[]{-4, -13, -49, 63};
                int n14 = n3 * this.bytesPerLine + (n2 >> 2);
                int n15 = 3 - n2 % 4;
                while (n6 > 0) {
                    int n16 = byArray[n7] & 3;
                    this.data[n14] = (byte)(this.data[n14] & byArray2[n15] | n16 << n15 * 2);
                    ++n7;
                    --n6;
                    if (++n8 >= this.width) {
                        n14 = ++n9 * this.bytesPerLine;
                        n15 = 0;
                        n8 = 0;
                        continue;
                    }
                    if (n15 == 0) {
                        ++n14;
                        n15 = 3;
                        continue;
                    }
                    --n15;
                }
                return;
            }
            case 1: {
                int n17 = n3 * this.bytesPerLine + (n2 >> 3);
                while (n6 > 0) {
                    int n18 = 1 << 7 - (n8 & 7);
                    this.data[n17] = (byArray[n7] & 1) == 1 ? (byte)(this.data[n17] & 0xFF | n18) : (byte)(this.data[n17] & 0xFF & ~n18);
                    ++n7;
                    --n6;
                    if (++n8 >= this.width) {
                        n17 = ++n9 * this.bytesPerLine;
                        n8 = 0;
                        continue;
                    }
                    if (n18 != 1) continue;
                    ++n17;
                }
                return;
            }
        }
        SWT.error(38);
    }

    public void setPixels(int n2, int n3, int n4, int[] nArray, int n5) {
        if (nArray == null) {
            SWT.error(4);
        }
        if (n4 < 0 || n2 >= this.width || n3 >= this.height || n2 < 0 || n3 < 0) {
            SWT.error(5);
        }
        if (n4 == 0) {
            return;
        }
        int n6 = n4;
        int n7 = n5;
        int n8 = n2;
        int n9 = n3;
        switch (this.depth) {
            case 32: {
                int n10 = n3 * this.bytesPerLine + n2 * 4;
                int n11 = 0;
                while (n11 < n4) {
                    int n12 = nArray[n7];
                    this.data[n10] = (byte)(n12 >> 24 & 0xFF);
                    this.data[n10 + 1] = (byte)(n12 >> 16 & 0xFF);
                    this.data[n10 + 2] = (byte)(n12 >> 8 & 0xFF);
                    this.data[n10 + 3] = (byte)(n12 & 0xFF);
                    ++n7;
                    if (++n8 >= this.width) {
                        n10 = ++n9 * this.bytesPerLine;
                        n8 = 0;
                    } else {
                        n10 += 4;
                    }
                    ++n11;
                }
                return;
            }
            case 24: {
                int n13 = n3 * this.bytesPerLine + n2 * 3;
                int n14 = 0;
                while (n14 < n4) {
                    int n15 = nArray[n7];
                    this.data[n13] = (byte)(n15 >> 16 & 0xFF);
                    this.data[n13 + 1] = (byte)(n15 >> 8 & 0xFF);
                    this.data[n13 + 2] = (byte)(n15 & 0xFF);
                    ++n7;
                    if (++n8 >= this.width) {
                        n13 = ++n9 * this.bytesPerLine;
                        n8 = 0;
                    } else {
                        n13 += 3;
                    }
                    ++n14;
                }
                return;
            }
            case 16: {
                int n16 = n3 * this.bytesPerLine + n2 * 2;
                int n17 = 0;
                while (n17 < n4) {
                    int n18 = nArray[n7];
                    this.data[n16] = (byte)(n18 & 0xFF);
                    this.data[n16 + 1] = (byte)(n18 >> 8 & 0xFF);
                    ++n7;
                    if (++n8 >= this.width) {
                        n16 = ++n9 * this.bytesPerLine;
                        n8 = 0;
                    } else {
                        n16 += 2;
                    }
                    ++n17;
                }
                return;
            }
            case 8: {
                int n19 = n3 * this.bytesPerLine + n2;
                int n20 = 0;
                while (n20 < n4) {
                    this.data[n19] = (byte)(nArray[n7] & 0xFF);
                    ++n7;
                    if (++n8 >= this.width) {
                        n19 = ++n9 * this.bytesPerLine;
                        n8 = 0;
                    } else {
                        ++n19;
                    }
                    ++n20;
                }
                return;
            }
            case 4: {
                int n21 = n3 * this.bytesPerLine + (n2 >> 1);
                boolean bl2 = (n2 & 1) == 0;
                while (n6 > 0) {
                    int n22 = nArray[n7] & 0xF;
                    this.data[n21] = bl2 ? (byte)(this.data[n21] & 0xF | n22 << 4) : (byte)(this.data[n21] & 0xF0 | n22);
                    ++n7;
                    --n6;
                    if (++n8 >= this.width) {
                        n21 = ++n9 * this.bytesPerLine;
                        bl2 = true;
                        n8 = 0;
                        continue;
                    }
                    if (!bl2) {
                        ++n21;
                    }
                    boolean bl3 = bl2 = !bl2;
                }
                return;
            }
            case 2: {
                byte[] byArray = new byte[]{-4, -13, -49, 63};
                int n23 = n3 * this.bytesPerLine + (n2 >> 2);
                int n24 = 3 - n2 % 4;
                while (n6 > 0) {
                    int n25 = nArray[n7] & 3;
                    this.data[n23] = (byte)(this.data[n23] & byArray[n24] | n25 << n24 * 2);
                    ++n7;
                    --n6;
                    if (++n8 >= this.width) {
                        n23 = ++n9 * this.bytesPerLine;
                        n24 = 3;
                        n8 = 0;
                        continue;
                    }
                    if (n24 == 0) {
                        ++n23;
                        n24 = 3;
                        continue;
                    }
                    --n24;
                }
                return;
            }
            case 1: {
                int n26 = n3 * this.bytesPerLine + (n2 >> 3);
                while (n6 > 0) {
                    int n27 = 1 << 7 - (n8 & 7);
                    this.data[n26] = (nArray[n7] & 1) == 1 ? (byte)(this.data[n26] & 0xFF | n27) : (byte)(this.data[n26] & 0xFF & ~n27);
                    ++n7;
                    --n6;
                    if (++n8 >= this.width) {
                        n26 = ++n9 * this.bytesPerLine;
                        n8 = 0;
                        continue;
                    }
                    if (n27 != 1) continue;
                    ++n26;
                }
                return;
            }
        }
        SWT.error(38);
    }

    static PaletteData bwPalette() {
        return new PaletteData(new RGB[]{new RGB(0, 0, 0), new RGB(255, 255, 255)});
    }

    static int getMSBOffset(int n2) {
        int n3 = 31;
        while (n3 >= 0) {
            if ((n2 >> n3 & 1) != 0) {
                return n3 + 1;
            }
            --n3;
        }
        return 0;
    }

    static int closestMatch(int n2, byte by2, byte by3, byte by4, int n3, int n4, int n5, byte[] byArray, byte[] byArray2, byte[] byArray3) {
        if (n2 > 8) {
            int n6 = 32 - ImageData.getMSBOffset(n3);
            int n7 = 32 - ImageData.getMSBOffset(n4);
            int n8 = 32 - ImageData.getMSBOffset(n5);
            return by2 << 24 >>> n6 & n3 | by3 << 24 >>> n7 & n4 | by4 << 24 >>> n8 & n5;
        }
        int n9 = Integer.MAX_VALUE;
        int n10 = 0;
        int n11 = byArray.length;
        int n12 = 0;
        while (n12 < n11) {
            int n13 = (byArray[n12] & 0xFF) - (by2 & 0xFF);
            int n14 = (byArray2[n12] & 0xFF) - (by3 & 0xFF);
            int n15 = (byArray3[n12] & 0xFF) - (by4 & 0xFF);
            int n16 = n13 * n13 + n14 * n14 + n15 * n15;
            if (n16 < n9) {
                n10 = n12;
                if (n16 == 0) break;
                n9 = n16;
            }
            ++n12;
        }
        return n10;
    }

    static final ImageData convertMask(ImageData imageData) {
        if (imageData.depth == 1) {
            return imageData;
        }
        PaletteData paletteData = new PaletteData(new RGB[]{new RGB(0, 0, 0), new RGB(255, 255, 255)});
        ImageData imageData2 = new ImageData(imageData.width, imageData.height, 1, paletteData);
        int n2 = 0;
        RGB[] rGBArray = imageData.getRGBs();
        if (rGBArray != null) {
            while (n2 < rGBArray.length) {
                if (rGBArray[n2].equals(paletteData.colors[0])) break;
                ++n2;
            }
        }
        int[] nArray = new int[imageData.width];
        int n3 = 0;
        while (n3 < imageData.height) {
            imageData.getPixels(0, n3, imageData.width, nArray, 0);
            int n4 = 0;
            while (n4 < nArray.length) {
                nArray[n4] = nArray[n4] == n2 ? 0 : 1;
                ++n4;
            }
            imageData2.setPixels(0, n3, imageData.width, nArray, 0);
            ++n3;
        }
        return imageData2;
    }

    static final byte[] convertPad(byte[] byArray, int n2, int n3, int n4, int n5, int n6) {
        if (n5 == n6) {
            return byArray;
        }
        int n7 = (n2 * n4 + 7) / 8;
        int n8 = (n7 + (n5 - 1)) / n5 * n5;
        int n9 = (n7 + (n6 - 1)) / n6 * n6;
        byte[] byArray2 = new byte[n3 * n9];
        int n10 = 0;
        int n11 = 0;
        int n12 = 0;
        while (n12 < n3) {
            System.arraycopy(byArray, n10, byArray2, n11, n7);
            n10 += n8;
            n11 += n9;
            ++n12;
        }
        return byArray2;
    }

    static void blit(int n2, byte[] byArray, int n3, int n4, int n5, int n6, int n7, int n8, int n9, int n10, int n11, int n12, int n13, byte[] byArray2, int n14, int n15, int n16, byte[] byArray3, int n17, int n18, int n19, int n20, int n21, int n22, int n23, int n24, int n25, int n26, boolean bl2, boolean bl3) {
        int n27;
        int n28;
        int n29;
        int n30;
        int n31;
        int n32;
        if (n22 <= 0 || n23 <= 0 || n13 == 0) {
            return;
        }
        int n33 = n22 - 1;
        int n34 = n33 != 0 ? (int)((((long)n8 << 16) - 1L) / (long)n33) : 0;
        int n35 = n23 - 1;
        int n36 = n35 != 0 ? (int)((((long)n9 << 16) - 1L) / (long)n35) : 0;
        switch (n3) {
            case 8: {
                n32 = 1;
                n31 = 0;
                break;
            }
            case 16: {
                n32 = 2;
                n31 = n5 == 1 ? 1 : 2;
                break;
            }
            case 24: {
                n32 = 3;
                n31 = 3;
                break;
            }
            case 32: {
                n32 = 4;
                n31 = n5 == 1 ? 4 : 5;
                break;
            }
            default: {
                return;
            }
        }
        int n37 = n7 * n4 + n6 * n32;
        switch (n17) {
            case 8: {
                n30 = 1;
                n29 = 0;
                break;
            }
            case 16: {
                n30 = 2;
                n29 = n19 == 1 ? 1 : 2;
                break;
            }
            case 24: {
                n30 = 3;
                n29 = 3;
                break;
            }
            case 32: {
                n30 = 4;
                n29 = n19 == 1 ? 4 : 5;
                break;
            }
            default: {
                return;
            }
        }
        int n38 = (bl3 ? n21 + n35 : n21) * n18 + (bl2 ? n20 + n33 : n20) * n30;
        int n39 = bl2 ? -n30 : n30;
        int n40 = n28 = bl3 ? -n18 : n18;
        if ((n2 & 2) != 0) {
            switch (n13) {
                case -3: 
                case -1: {
                    if (byArray2 == null) {
                        n13 = 65536;
                    }
                    n27 = n16 * n14 + n15;
                    break;
                }
                case -4: {
                    if (byArray2 == null) {
                        n13 = 65536;
                    }
                    n27 = n16 * (n14 <<= 3) + n15;
                    break;
                }
                case -5: {
                    return;
                }
                case -6: {
                    if (byArray2 == null) {
                        n13 = 65536;
                    }
                    n27 = 0;
                    break;
                }
                default: {
                    n13 = (n13 << 16) / 255;
                }
                case -2: {
                    n27 = 0;
                    break;
                }
            }
        } else {
            n13 = 65536;
            n27 = 0;
        }
        int n41 = n38;
        int n42 = n37;
        if (n13 == 65536 && n31 == n29 && n10 == n24 && n11 == n25 && n12 == n26) {
            switch (n32) {
                case 1: {
                    int n43 = n23;
                    int n44 = n36;
                    while (n43 > 0) {
                        int n45 = n22;
                        int n46 = n34;
                        while (n45 > 0) {
                            byArray3[n41] = byArray[n42];
                            n42 += n46 >>> 16;
                            --n45;
                            n41 += n39;
                            n46 = (n46 & 0xFFFF) + n34;
                        }
                        --n43;
                        n42 = n37 += (n44 >>> 16) * n4;
                        n44 = (n44 & 0xFFFF) + n36;
                        n41 = n38 += n28;
                    }
                    break;
                }
                case 2: {
                    int n47 = n23;
                    int n48 = n36;
                    while (n47 > 0) {
                        int n49 = n22;
                        int n50 = n34;
                        while (n49 > 0) {
                            byArray3[n41] = byArray[n42];
                            byArray3[n41 + 1] = byArray[n42 + 1];
                            n42 += (n50 >>> 16) * 2;
                            --n49;
                            n41 += n39;
                            n50 = (n50 & 0xFFFF) + n34;
                        }
                        --n47;
                        n42 = n37 += (n48 >>> 16) * n4;
                        n48 = (n48 & 0xFFFF) + n36;
                        n41 = n38 += n28;
                    }
                    break;
                }
                case 3: {
                    int n51 = n23;
                    int n52 = n36;
                    while (n51 > 0) {
                        int n53 = n22;
                        int n54 = n34;
                        while (n53 > 0) {
                            byArray3[n41] = byArray[n42];
                            byArray3[n41 + 1] = byArray[n42 + 1];
                            byArray3[n41 + 2] = byArray[n42 + 2];
                            n42 += (n54 >>> 16) * 3;
                            --n53;
                            n41 += n39;
                            n54 = (n54 & 0xFFFF) + n34;
                        }
                        --n51;
                        n42 = n37 += (n52 >>> 16) * n4;
                        n52 = (n52 & 0xFFFF) + n36;
                        n41 = n38 += n28;
                    }
                    break;
                }
                case 4: {
                    int n55 = n23;
                    int n56 = n36;
                    while (n55 > 0) {
                        int n57 = n22;
                        int n58 = n34;
                        while (n57 > 0) {
                            byArray3[n41] = byArray[n42];
                            byArray3[n41 + 1] = byArray[n42 + 1];
                            byArray3[n41 + 2] = byArray[n42 + 2];
                            byArray3[n41 + 3] = byArray[n42 + 3];
                            n42 += (n58 >>> 16) * 4;
                            --n57;
                            n41 += n39;
                            n58 = (n58 & 0xFFFF) + n34;
                        }
                        --n55;
                        n42 = n37 += (n56 >>> 16) * n4;
                        n56 = (n56 & 0xFFFF) + n36;
                        n41 = n38 += n28;
                    }
                    break;
                }
            }
            return;
        }
        int n59 = ImageData.getChannelShift(n10);
        byte[] byArray4 = ANY_TO_EIGHT[ImageData.getChannelWidth(n10, n59)];
        int n60 = ImageData.getChannelShift(n11);
        byte[] byArray5 = ANY_TO_EIGHT[ImageData.getChannelWidth(n11, n60)];
        int n61 = ImageData.getChannelShift(n12);
        byte[] byArray6 = ANY_TO_EIGHT[ImageData.getChannelWidth(n12, n61)];
        int n62 = ImageData.getChannelShift(0);
        byte[] byArray7 = ANY_TO_EIGHT[ImageData.getChannelWidth(0, n62)];
        int n63 = ImageData.getChannelShift(n24);
        int n64 = ImageData.getChannelWidth(n24, n63);
        byte[] byArray8 = ANY_TO_EIGHT[n64];
        int n65 = 8 - n64;
        int n66 = ImageData.getChannelShift(n25);
        int n67 = ImageData.getChannelWidth(n25, n66);
        byte[] byArray9 = ANY_TO_EIGHT[n67];
        int n68 = 8 - n67;
        int n69 = ImageData.getChannelShift(n26);
        int n70 = ImageData.getChannelWidth(n26, n69);
        byte[] byArray10 = ANY_TO_EIGHT[n70];
        int n71 = 8 - n70;
        int n72 = ImageData.getChannelShift(0);
        int n73 = ImageData.getChannelWidth(0, n72);
        byte[] byArray11 = ANY_TO_EIGHT[n73];
        int n74 = 8 - n73;
        int n75 = n27;
        int n76 = n13;
        int n77 = 0;
        int n78 = 0;
        int n79 = 0;
        int n80 = 0;
        int n81 = 0;
        int n82 = 0;
        int n83 = 0;
        int n84 = 0;
        int n85 = n23;
        int n86 = n36;
        while (n85 > 0) {
            int n87 = n22;
            int n88 = n34;
            while (n87 > 0) {
                block79: {
                    int n89;
                    block78: {
                        switch (n31) {
                            case 0: {
                                n89 = byArray[n42] & 0xFF;
                                n42 += n88 >>> 16;
                                n77 = byArray4[(n89 & n10) >>> n59] & 0xFF;
                                n78 = byArray5[(n89 & n11) >>> n60] & 0xFF;
                                n79 = byArray6[(n89 & n12) >>> n61] & 0xFF;
                                n80 = byArray7[0 >>> n62] & 0xFF;
                                break;
                            }
                            case 1: {
                                n89 = (byArray[n42] & 0xFF) << 8 | byArray[n42 + 1] & 0xFF;
                                n42 += (n88 >>> 16) * 2;
                                n77 = byArray4[(n89 & n10) >>> n59] & 0xFF;
                                n78 = byArray5[(n89 & n11) >>> n60] & 0xFF;
                                n79 = byArray6[(n89 & n12) >>> n61] & 0xFF;
                                n80 = byArray7[0 >>> n62] & 0xFF;
                                break;
                            }
                            case 2: {
                                n89 = (byArray[n42 + 1] & 0xFF) << 8 | byArray[n42] & 0xFF;
                                n42 += (n88 >>> 16) * 2;
                                n77 = byArray4[(n89 & n10) >>> n59] & 0xFF;
                                n78 = byArray5[(n89 & n11) >>> n60] & 0xFF;
                                n79 = byArray6[(n89 & n12) >>> n61] & 0xFF;
                                n80 = byArray7[0 >>> n62] & 0xFF;
                                break;
                            }
                            case 3: {
                                n89 = ((byArray[n42] & 0xFF) << 8 | byArray[n42 + 1] & 0xFF) << 8 | byArray[n42 + 2] & 0xFF;
                                n42 += (n88 >>> 16) * 3;
                                n77 = byArray4[(n89 & n10) >>> n59] & 0xFF;
                                n78 = byArray5[(n89 & n11) >>> n60] & 0xFF;
                                n79 = byArray6[(n89 & n12) >>> n61] & 0xFF;
                                n80 = byArray7[0 >>> n62] & 0xFF;
                                break;
                            }
                            case 4: {
                                n89 = (((byArray[n42] & 0xFF) << 8 | byArray[n42 + 1] & 0xFF) << 8 | byArray[n42 + 2] & 0xFF) << 8 | byArray[n42 + 3] & 0xFF;
                                n42 += (n88 >>> 16) * 4;
                                n77 = byArray4[(n89 & n10) >>> n59] & 0xFF;
                                n78 = byArray5[(n89 & n11) >>> n60] & 0xFF;
                                n79 = byArray6[(n89 & n12) >>> n61] & 0xFF;
                                n80 = byArray7[0 >>> n62] & 0xFF;
                                break;
                            }
                            case 5: {
                                n89 = (((byArray[n42 + 3] & 0xFF) << 8 | byArray[n42 + 2] & 0xFF) << 8 | byArray[n42 + 1] & 0xFF) << 8 | byArray[n42] & 0xFF;
                                n42 += (n88 >>> 16) * 4;
                                n77 = byArray4[(n89 & n10) >>> n59] & 0xFF;
                                n78 = byArray5[(n89 & n11) >>> n60] & 0xFF;
                                n79 = byArray6[(n89 & n12) >>> n61] & 0xFF;
                                n80 = byArray7[0 >>> n62] & 0xFF;
                            }
                        }
                        block33 : switch (n13) {
                            case -1: {
                                n76 = ((byArray2[n75] & 0xFF) << 16) / 255;
                                n75 += n88 >> 16;
                                break;
                            }
                            case -2: {
                                n76 = (n80 << 16) / 255;
                                break;
                            }
                            case -3: {
                                n76 = byArray2[n75] != 0 ? 65536 : 0;
                                n75 += n88 >> 16;
                                break;
                            }
                            case -4: {
                                n76 = byArray2[n75 >> 3] << (n75 & 7) + 9 & 0x10000;
                                n75 += n88 >> 16;
                                break;
                            }
                            case -6: {
                                n76 = 65536;
                                n89 = 0;
                                while (n89 < byArray2.length) {
                                    if (n77 == byArray2[n89] && n78 == byArray2[n89 + 1] && n79 == byArray2[n89 + 2]) {
                                        n76 = 0;
                                        break block33;
                                    }
                                    n89 += 3;
                                }
                                break;
                            }
                        }
                        if (n76 == 65536) break block78;
                        if (n76 == 0) break block79;
                        switch (n29) {
                            case 0: {
                                n89 = byArray3[n41] & 0xFF;
                                n81 = byArray8[(n89 & n24) >>> n63] & 0xFF;
                                n82 = byArray9[(n89 & n25) >>> n66] & 0xFF;
                                n83 = byArray10[(n89 & n26) >>> n69] & 0xFF;
                                n84 = byArray11[0 >>> n72] & 0xFF;
                                break;
                            }
                            case 1: {
                                n89 = (byArray3[n41] & 0xFF) << 8 | byArray3[n41 + 1] & 0xFF;
                                n81 = byArray8[(n89 & n24) >>> n63] & 0xFF;
                                n82 = byArray9[(n89 & n25) >>> n66] & 0xFF;
                                n83 = byArray10[(n89 & n26) >>> n69] & 0xFF;
                                n84 = byArray11[0 >>> n72] & 0xFF;
                                break;
                            }
                            case 2: {
                                n89 = (byArray3[n41 + 1] & 0xFF) << 8 | byArray3[n41] & 0xFF;
                                n81 = byArray8[(n89 & n24) >>> n63] & 0xFF;
                                n82 = byArray9[(n89 & n25) >>> n66] & 0xFF;
                                n83 = byArray10[(n89 & n26) >>> n69] & 0xFF;
                                n84 = byArray11[0 >>> n72] & 0xFF;
                                break;
                            }
                            case 3: {
                                n89 = ((byArray3[n41] & 0xFF) << 8 | byArray3[n41 + 1] & 0xFF) << 8 | byArray3[n41 + 2] & 0xFF;
                                n81 = byArray8[(n89 & n24) >>> n63] & 0xFF;
                                n82 = byArray9[(n89 & n25) >>> n66] & 0xFF;
                                n83 = byArray10[(n89 & n26) >>> n69] & 0xFF;
                                n84 = byArray11[0 >>> n72] & 0xFF;
                                break;
                            }
                            case 4: {
                                n89 = (((byArray3[n41] & 0xFF) << 8 | byArray3[n41 + 1] & 0xFF) << 8 | byArray3[n41 + 2] & 0xFF) << 8 | byArray3[n41 + 3] & 0xFF;
                                n81 = byArray8[(n89 & n24) >>> n63] & 0xFF;
                                n82 = byArray9[(n89 & n25) >>> n66] & 0xFF;
                                n83 = byArray10[(n89 & n26) >>> n69] & 0xFF;
                                n84 = byArray11[0 >>> n72] & 0xFF;
                                break;
                            }
                            case 5: {
                                n89 = (((byArray3[n41 + 3] & 0xFF) << 8 | byArray3[n41 + 2] & 0xFF) << 8 | byArray3[n41 + 1] & 0xFF) << 8 | byArray3[n41] & 0xFF;
                                n81 = byArray8[(n89 & n24) >>> n63] & 0xFF;
                                n82 = byArray9[(n89 & n25) >>> n66] & 0xFF;
                                n83 = byArray10[(n89 & n26) >>> n69] & 0xFF;
                                n84 = byArray11[0 >>> n72] & 0xFF;
                            }
                        }
                        n80 = n84 + ((n80 - n84) * n76 >> 16);
                        n77 = n81 + ((n77 - n81) * n76 >> 16);
                        n78 = n82 + ((n78 - n82) * n76 >> 16);
                        n79 = n83 + ((n79 - n83) * n76 >> 16);
                    }
                    n89 = n77 >>> n65 << n63 | n78 >>> n68 << n66 | n79 >>> n71 << n69 | n80 >>> n74 << n72;
                    switch (n29) {
                        case 0: {
                            byArray3[n41] = (byte)n89;
                            break;
                        }
                        case 1: {
                            byArray3[n41] = (byte)(n89 >>> 8);
                            byArray3[n41 + 1] = (byte)(n89 & 0xFF);
                            break;
                        }
                        case 2: {
                            byArray3[n41] = (byte)(n89 & 0xFF);
                            byArray3[n41 + 1] = (byte)(n89 >>> 8);
                            break;
                        }
                        case 3: {
                            byArray3[n41] = (byte)(n89 >>> 16);
                            byArray3[n41 + 1] = (byte)(n89 >>> 8);
                            byArray3[n41 + 2] = (byte)(n89 & 0xFF);
                            break;
                        }
                        case 4: {
                            byArray3[n41] = (byte)(n89 >>> 24);
                            byArray3[n41 + 1] = (byte)(n89 >>> 16);
                            byArray3[n41 + 2] = (byte)(n89 >>> 8);
                            byArray3[n41 + 3] = (byte)(n89 & 0xFF);
                            break;
                        }
                        case 5: {
                            byArray3[n41] = (byte)(n89 & 0xFF);
                            byArray3[n41 + 1] = (byte)(n89 >>> 8);
                            byArray3[n41 + 2] = (byte)(n89 >>> 16);
                            byArray3[n41 + 3] = (byte)(n89 >>> 24);
                        }
                    }
                }
                --n87;
                n41 += n39;
                n88 = (n88 & 0xFFFF) + n34;
            }
            --n85;
            n42 = n37 += (n86 >>> 16) * n4;
            n75 = n27 += (n86 >>> 16) * n14;
            n86 = (n86 & 0xFFFF) + n36;
            n41 = n38 += n28;
        }
    }

    /*
     * Unable to fully structure code
     */
    static void blit(int var0, byte[] var1_1, int var2_2, int var3_3, int var4_4, int var5_5, int var6_6, int var7_7, int var8_8, byte[] var9_9, byte[] var10_10, byte[] var11_11, int var12_12, byte[] var13_13, int var14_14, int var15_15, int var16_16, byte[] var17_17, int var18_18, int var19_19, int var20_20, int var21_21, int var22_22, int var23_23, int var24_24, byte[] var25_25, byte[] var26_26, byte[] var27_27, boolean var28_28, boolean var29_29) {
        block135: {
            block137: {
                block136: {
                    if (var23_23 <= 0 || var24_24 <= 0 || var12_12 == 0) {
                        return;
                    }
                    var30_30 = var23_23 - 1;
                    var31_31 = var30_30 != 0 ? (int)((((long)var7_7 << 16) - 1L) / (long)var30_30) : 0;
                    var32_32 = var24_24 - 1;
                    var33_33 = var32_32 != 0 ? (int)((((long)var8_8 << 16) - 1L) / (long)var32_32) : 0;
                    switch (var2_2) {
                        case 8: {
                            var34_34 = 6;
                            break;
                        }
                        case 4: {
                            var3_3 <<= 1;
                            var34_34 = 7;
                            break;
                        }
                        case 2: {
                            var3_3 <<= 2;
                            var34_34 = 8;
                            break;
                        }
                        case 1: {
                            var3_3 <<= 3;
                            var34_34 = var4_4 == 1 ? 9 : 10;
                            break;
                        }
                        default: {
                            return;
                        }
                    }
                    var35_35 = var6_6 * var3_3 + var5_5;
                    switch (var18_18) {
                        case 8: {
                            var36_36 = 6;
                            break;
                        }
                        case 4: {
                            var19_19 <<= 1;
                            var36_36 = 7;
                            break;
                        }
                        case 2: {
                            var19_19 <<= 2;
                            var36_36 = 8;
                            break;
                        }
                        case 1: {
                            var19_19 <<= 3;
                            var36_36 = var20_20 == 1 ? 9 : 10;
                            break;
                        }
                        default: {
                            return;
                        }
                    }
                    var37_37 = (var29_29 != false ? var22_22 + var32_32 : var22_22) * var19_19 + (var28_28 != false ? var21_21 + var30_30 : var21_21);
                    var38_38 = var28_28 != false ? -1 : 1;
                    v0 = var39_39 = var29_29 != false ? -var19_19 : var19_19;
                    if ((var0 & 2) != 0) {
                        switch (var12_12) {
                            case -3: 
                            case -1: {
                                if (var13_13 == null) {
                                    var12_12 = 65536;
                                }
                                var40_40 = var16_16 * var14_14 + var15_15;
                                break;
                            }
                            case -4: {
                                if (var13_13 == null) {
                                    var12_12 = 65536;
                                }
                                var40_40 = var16_16 * (var14_14 <<= 3) + var15_15;
                                break;
                            }
                            case -6: 
                            case -5: {
                                if (var13_13 == null) {
                                    var12_12 = 65536;
                                }
                                var40_40 = 0;
                                break;
                            }
                            default: {
                                var12_12 = (var12_12 << 16) / 255;
                            }
                            case -2: {
                                var40_40 = 0;
                                break;
                            }
                        }
                    } else {
                        var12_12 = 65536;
                        var40_40 = 0;
                    }
                    var41_41 = (var0 & 4) != 0;
                    var42_42 = var37_37;
                    var43_43 = var35_35;
                    var44_44 = var40_40;
                    var45_45 = 1 << var18_18;
                    if (var25_25 != null && var25_25.length < var45_45) {
                        var45_45 = var25_25.length;
                    }
                    var46_46 = null;
                    var47_47 = true;
                    switch (var12_12) {
                        case 65536: {
                            if (var34_34 == var36_36 && var9_9 == var25_25 && var10_10 == var26_26 && var11_11 == var27_27) {
                                var46_46 = ImageData.ONE_TO_ONE_MAPPING;
                                break;
                            }
                            if (var9_9 == null || var25_25 == null) {
                                if (var2_2 <= var18_18) {
                                    var46_46 = ImageData.ONE_TO_ONE_MAPPING;
                                    break;
                                }
                                var46_46 = new byte[1 << var2_2];
                                var48_48 = 255 << var18_18 >>> 8;
                                var49_49 = 0;
                                while (var49_49 < var46_46.length) {
                                    var46_46[var49_49] = (byte)(var49_49 & var48_48);
                                    ++var49_49;
                                }
                                break;
                            }
                        }
                        case -6: 
                        case -5: 
                        case -4: 
                        case -3: {
                            var48_48 = 1 << var2_2;
                            var46_46 = new byte[var48_48];
                            if (var9_9 != null && var9_9.length < var48_48) {
                                var48_48 = var9_9.length;
                            }
                            var49_49 = 0;
                            while (var49_49 < var48_48) {
                                var50_50 = var9_9[var49_49] & 255;
                                var51_51 = var10_10[var49_49] & 255;
                                var52_52 = var11_11[var49_49] & 255;
                                var53_53 = 0;
                                var54_54 = 0x7FFFFFFF;
                                var55_55 = 0;
                                while (var55_55 < var45_45) {
                                    var56_57 = (var25_25[var55_55] & 255) - var50_50;
                                    var57_59 = (var26_26[var55_55] & 255) - var51_51;
                                    var58_61 = (var27_27[var55_55] & 255) - var52_52;
                                    var59_62 = var56_57 * var56_57 + var57_59 * var57_59 + var58_61 * var58_61;
                                    if (var59_62 < var54_54) {
                                        var53_53 = var55_55;
                                        if (var59_62 == 0) break;
                                        var54_54 = var59_62;
                                    }
                                    ++var55_55;
                                }
                                var46_46[var49_49] = (byte)var53_53;
                                if (var54_54 != 0) {
                                    var47_47 = false;
                                }
                                ++var49_49;
                            }
                            break;
                        }
                    }
                    if (var46_46 == null || !var47_47 && var41_41) break block135;
                    if (var34_34 != var36_36 || var12_12 != 65536) break block136;
                    switch (var34_34) {
                        case 6: {
                            var48_48 = var24_24;
                            var49_49 = var33_33;
                            while (var48_48 > 0) {
                                var50_50 = var23_23;
                                var51_51 = var31_31;
                                while (var50_50 > 0) {
                                    var17_17[var42_42] = var46_46[var1_1[var43_43] & 255];
                                    var43_43 += var51_51 >>> 16;
                                    --var50_50;
                                    var42_42 += var38_38;
                                    var51_51 = (var51_51 & 65535) + var31_31;
                                }
                                --var48_48;
                                var43_43 = var35_35 += (var49_49 >>> 16) * var3_3;
                                var49_49 = (var49_49 & 65535) + var33_33;
                                var42_42 = var37_37 += var39_39;
                            }
                            break block137;
                        }
                        case 7: {
                            var48_48 = var24_24;
                            var49_49 = var33_33;
                            while (var48_48 > 0) {
                                var50_50 = var23_23;
                                var51_51 = var31_31;
                                while (var50_50 > 0) {
                                    var52_52 = (var43_43 & 1) != 0 ? var46_46[var1_1[var43_43 >> 1] & 15] : var1_1[var43_43 >> 1] >>> 4 & 15;
                                    var43_43 += var51_51 >>> 16;
                                    var17_17[var42_42 >> 1] = (var42_42 & 1) != 0 ? (byte)(var17_17[var42_42 >> 1] & 240 | var52_52) : (byte)(var17_17[var42_42 >> 1] & 15 | var52_52 << 4);
                                    --var50_50;
                                    var42_42 += var38_38;
                                    var51_51 = (var51_51 & 65535) + var31_31;
                                }
                                --var48_48;
                                var43_43 = var35_35 += (var49_49 >>> 16) * var3_3;
                                var49_49 = (var49_49 & 65535) + var33_33;
                                var42_42 = var37_37 += var39_39;
                            }
                            break block137;
                        }
                        case 8: {
                            var48_48 = var24_24;
                            var49_49 = var33_33;
                            while (var48_48 > 0) {
                                var50_50 = var23_23;
                                var51_51 = var31_31;
                                while (var50_50 > 0) {
                                    var52_52 = var46_46[var1_1[var43_43 >> 2] >>> 6 - (var43_43 & 3) * 2 & 3];
                                    var43_43 += var51_51 >>> 16;
                                    var53_53 = 6 - (var42_42 & 3) * 2;
                                    var17_17[var42_42 >> 2] = (byte)(var17_17[var42_42 >> 2] & ~(3 << var53_53) | var52_52 << var53_53);
                                    --var50_50;
                                    var42_42 += var38_38;
                                    var51_51 = (var51_51 & 65535) + var31_31;
                                }
                                --var48_48;
                                var43_43 = var35_35 += (var49_49 >>> 16) * var3_3;
                                var49_49 = (var49_49 & 65535) + var33_33;
                                var42_42 = var37_37 += var39_39;
                            }
                            break block137;
                        }
                        case 9: {
                            var48_48 = var24_24;
                            var49_49 = var33_33;
                            while (var48_48 > 0) {
                                var50_50 = var23_23;
                                var51_51 = var31_31;
                                while (var50_50 > 0) {
                                    var52_52 = var46_46[var1_1[var43_43 >> 3] >>> 7 - (var43_43 & 7) & 1];
                                    var43_43 += var51_51 >>> 16;
                                    var53_53 = 7 - (var42_42 & 7);
                                    var17_17[var42_42 >> 3] = (byte)(var17_17[var42_42 >> 3] & ~(1 << var53_53) | var52_52 << var53_53);
                                    --var50_50;
                                    var42_42 += var38_38;
                                    var51_51 = (var51_51 & 65535) + var31_31;
                                }
                                --var48_48;
                                var43_43 = var35_35 += (var49_49 >>> 16) * var3_3;
                                var49_49 = (var49_49 & 65535) + var33_33;
                                var42_42 = var37_37 += var39_39;
                            }
                            break block137;
                        }
                        case 10: {
                            var48_48 = var24_24;
                            var49_49 = var33_33;
                            while (var48_48 > 0) {
                                var50_50 = var23_23;
                                var51_51 = var31_31;
                                while (var50_50 > 0) {
                                    var52_52 = var46_46[var1_1[var43_43 >> 3] >>> (var43_43 & 7) & 1];
                                    var43_43 += var51_51 >>> 16;
                                    var53_53 = var42_42 & 7;
                                    var17_17[var42_42 >> 3] = (byte)(var17_17[var42_42 >> 3] & ~(1 << var53_53) | var52_52 << var53_53);
                                    --var50_50;
                                    var42_42 += var38_38;
                                    var51_51 = (var51_51 & 65535) + var31_31;
                                }
                                --var48_48;
                                var43_43 = var35_35 += (var49_49 >>> 16) * var3_3;
                                var49_49 = (var49_49 & 65535) + var33_33;
                                var42_42 = var37_37 += var39_39;
                            }
                            break block22;
                        }
                    }
                    break block137;
                }
                var48_48 = var24_24;
                var49_49 = var33_33;
                while (var48_48 > 0) {
                    var50_50 = var23_23;
                    var51_51 = var31_31;
                    while (var50_50 > 0) {
                        switch (var34_34) {
                            case 6: {
                                var52_52 = var1_1[var43_43] & 255;
                                var43_43 += var51_51 >>> 16;
                                break;
                            }
                            case 7: {
                                var52_52 = (var43_43 & 1) != 0 ? var1_1[var43_43 >> 1] & 15 : var1_1[var43_43 >> 1] >>> 4 & 15;
                                var43_43 += var51_51 >>> 16;
                                break;
                            }
                            case 8: {
                                var52_52 = var1_1[var43_43 >> 2] >>> 6 - (var43_43 & 3) * 2 & 3;
                                var43_43 += var51_51 >>> 16;
                                break;
                            }
                            case 9: {
                                var52_52 = var1_1[var43_43 >> 3] >>> 7 - (var43_43 & 7) & 1;
                                var43_43 += var51_51 >>> 16;
                                break;
                            }
                            case 10: {
                                var52_52 = var1_1[var43_43 >> 3] >>> (var43_43 & 7) & 1;
                                var43_43 += var51_51 >>> 16;
                                break;
                            }
                            default: {
                                return;
                            }
                        }
                        block36 : switch (var12_12) {
                            case -3: {
                                var53_53 = var13_13[var44_44];
                                var44_44 += var51_51 >> 16;
                                if (var53_53 == 0) {
                                    break;
                                }
                                ** GOTO lbl294
                            }
                            case -4: {
                                var53_53 = var13_13[var44_44 >> 3] & 1 << (var44_44 & 7);
                                var44_44 += var51_51 >> 16;
                                if (var53_53 == 0) {
                                    break;
                                }
                                ** GOTO lbl294
                            }
                            case -5: {
                                var53_53 = 0;
                                while (var53_53 < var13_13.length) {
                                    if (var52_52 == (var13_13[var53_53] & 255)) break;
                                }
                                if (var53_53 < var13_13.length) {
                                    break;
                                }
                                ** GOTO lbl294
                            }
                            case -6: {
                                var53_53 = var9_9[var52_52];
                                var54_54 = var10_10[var52_52];
                                var55_55 = var11_11[var52_52];
                                var56_57 = 0;
                                while (var56_57 < var13_13.length) {
                                    if (var53_53 == var13_13[var56_57] && var54_54 == var13_13[var56_57 + 1] && var55_55 == var13_13[var56_57 + 2]) break;
                                    var56_57 += 3;
                                }
                                if (var56_57 < var13_13.length) break;
                            }
lbl294:
                            // 5 sources

                            default: {
                                var52_52 = var46_46[var52_52] & 255;
                                switch (var36_36) {
                                    case 6: {
                                        var17_17[var42_42] = (byte)var52_52;
                                        break block36;
                                    }
                                    case 7: {
                                        if ((var42_42 & 1) != 0) {
                                            var17_17[var42_42 >> 1] = (byte)(var17_17[var42_42 >> 1] & 240 | var52_52);
                                            break block36;
                                        }
                                        var17_17[var42_42 >> 1] = (byte)(var17_17[var42_42 >> 1] & 15 | var52_52 << 4);
                                        break block36;
                                    }
                                    case 8: {
                                        var53_53 = 6 - (var42_42 & 3) * 2;
                                        var17_17[var42_42 >> 2] = (byte)(var17_17[var42_42 >> 2] & ~(3 << var53_53) | var52_52 << var53_53);
                                        break block36;
                                    }
                                    case 9: {
                                        var53_53 = 7 - (var42_42 & 7);
                                        var17_17[var42_42 >> 3] = (byte)(var17_17[var42_42 >> 3] & ~(1 << var53_53) | var52_52 << var53_53);
                                        break block36;
                                    }
                                    case 10: {
                                        var53_53 = var42_42 & 7;
                                        var17_17[var42_42 >> 3] = (byte)(var17_17[var42_42 >> 3] & ~(1 << var53_53) | var52_52 << var53_53);
                                    }
                                }
                            }
                        }
                        --var50_50;
                        var42_42 += var38_38;
                        var51_51 = (var51_51 & 65535) + var31_31;
                    }
                    --var48_48;
                    var43_43 = var35_35 += (var49_49 >>> 16) * var3_3;
                    var49_49 = (var49_49 & 65535) + var33_33;
                    var42_42 = var37_37 += var39_39;
                }
            }
            return;
        }
        var48_48 = var12_12;
        var49_49 = 0;
        var50_50 = 0;
        var51_51 = 0;
        var52_52 = -1;
        var53_53 = -1;
        var54_54 = -1;
        if (var41_41) {
            var55_56 = new int[var23_23 + 2];
            var56_58 = new int[var23_23 + 2];
            var57_60 = new int[var23_23 + 2];
        } else {
            var55_56 = null;
            var56_58 = null;
            var57_60 = null;
        }
        var58_61 = var24_24;
        var59_62 = var33_33;
        while (var58_61 > 0) {
            var60_63 = 0;
            var61_64 = 0;
            var62_65 = 0;
            var63_66 = var23_23;
            var64_67 = var31_31;
            while (var63_66 > 0) {
                switch (var34_34) {
                    case 6: {
                        var49_49 = var1_1[var43_43] & 255;
                        var43_43 += var64_67 >>> 16;
                        break;
                    }
                    case 7: {
                        var49_49 = (var43_43 & 1) != 0 ? var1_1[var43_43 >> 1] & 15 : var1_1[var43_43 >> 1] >>> 4 & 15;
                        var43_43 += var64_67 >>> 16;
                        break;
                    }
                    case 8: {
                        var49_49 = var1_1[var43_43 >> 2] >>> 6 - (var43_43 & 3) * 2 & 3;
                        var43_43 += var64_67 >>> 16;
                        break;
                    }
                    case 9: {
                        var49_49 = var1_1[var43_43 >> 3] >>> 7 - (var43_43 & 7) & 1;
                        var43_43 += var64_67 >>> 16;
                        break;
                    }
                    case 10: {
                        var49_49 = var1_1[var43_43 >> 3] >>> (var43_43 & 7) & 1;
                        var43_43 += var64_67 >>> 16;
                    }
                }
                var65_68 = var9_9[var49_49] & 255;
                var66_69 = var10_10[var49_49] & 255;
                var67_70 = var11_11[var49_49] & 255;
                block56 : switch (var12_12) {
                    case -1: {
                        var48_48 = ((var13_13[var44_44] & 255) << 16) / 255;
                        var44_44 += var64_67 >> 16;
                        ** GOTO lbl404
                    }
                    case -3: {
                        var48_48 = var13_13[var44_44] != 0 ? 65536 : 0;
                        var44_44 += var64_67 >> 16;
                        ** GOTO lbl404
                    }
                    case -4: {
                        var48_48 = var13_13[var44_44 >> 3] << (var44_44 & 7) + 9 & 65536;
                        var44_44 += var64_67 >> 16;
                        ** GOTO lbl404
                    }
                    case -5: {
                        var68_71 = 0;
                        while (var68_71 < var13_13.length) {
                            if (var49_49 == (var13_13[var68_71] & 255)) break;
                        }
                        if (var68_71 < var13_13.length) {
                            break;
                        }
                        ** GOTO lbl404
                    }
                    case -6: {
                        var68_71 = 0;
                        while (var68_71 < var13_13.length) {
                            if (var65_68 == (var13_13[var68_71] & 255) && var66_69 == (var13_13[var68_71 + 1] & 255) && var67_70 == (var13_13[var68_71 + 2] & 255)) break;
                            var68_71 += 3;
                        }
                        if (var68_71 < var13_13.length) break;
                    }
lbl404:
                    // 6 sources

                    default: {
                        if (var48_48 != 65536) {
                            if (var48_48 == 0) break;
                            switch (var36_36) {
                                case 6: {
                                    var50_50 = var17_17[var42_42] & 255;
                                    break;
                                }
                                case 7: {
                                    if ((var42_42 & 1) != 0) {
                                        var50_50 = var17_17[var42_42 >> 1] & 15;
                                        break;
                                    }
                                    var50_50 = var17_17[var42_42 >> 1] >>> 4 & 15;
                                    break;
                                }
                                case 8: {
                                    var50_50 = var17_17[var42_42 >> 2] >>> 6 - (var42_42 & 3) * 2 & 3;
                                    break;
                                }
                                case 9: {
                                    var50_50 = var17_17[var42_42 >> 3] >>> 7 - (var42_42 & 7) & 1;
                                    break;
                                }
                                case 10: {
                                    var50_50 = var17_17[var42_42 >> 3] >>> (var42_42 & 7) & 1;
                                }
                            }
                            var68_71 = var25_25[var50_50] & 255;
                            var69_72 = var26_26[var50_50] & 255;
                            var70_73 = var27_27[var50_50] & 255;
                            var65_68 = var68_71 + ((var65_68 - var68_71) * var48_48 >> 16);
                            var66_69 = var69_72 + ((var66_69 - var69_72) * var48_48 >> 16);
                            var67_70 = var70_73 + ((var67_70 - var70_73) * var48_48 >> 16);
                        }
                        if (var41_41) {
                            if ((var65_68 += var55_56[var63_66] >> 4) < 0) {
                                var65_68 = 0;
                            } else if (var65_68 > 255) {
                                var65_68 = 255;
                            }
                            if ((var66_69 += var56_58[var63_66] >> 4) < 0) {
                                var66_69 = 0;
                            } else if (var66_69 > 255) {
                                var66_69 = 255;
                            }
                            if ((var67_70 += var57_60[var63_66] >> 4) < 0) {
                                var67_70 = 0;
                            } else if (var67_70 > 255) {
                                var67_70 = 255;
                            }
                            var55_56[var63_66] = var60_63;
                            var56_58[var63_66] = var61_64;
                            var57_60[var63_66] = var62_65;
                        }
                        if (var65_68 != var52_52 || var66_69 != var53_53 || var67_70 != var54_54) {
                            var68_71 = 0;
                            var73_76 = 0x7FFFFFFF;
                            while (var68_71 < var45_45) {
                                var69_72 = (var25_25[var68_71] & 255) - var65_68;
                                var70_73 = (var26_26[var68_71] & 255) - var66_69;
                                var71_74 = (var27_27[var68_71] & 255) - var67_70;
                                var72_75 = var69_72 * var69_72 + var70_73 * var70_73 + var71_74 * var71_74;
                                if (var72_75 < var73_76) {
                                    var51_51 = var68_71;
                                    if (var72_75 == 0) break;
                                    var73_76 = var72_75;
                                }
                                ++var68_71;
                            }
                            var52_52 = var65_68;
                            var53_53 = var66_69;
                            var54_54 = var67_70;
                        }
                        if (var41_41) {
                            var68_71 = var63_66 - 1;
                            v1 = var69_72 = var63_66 + 1;
                            var60_63 = var65_68 - (var25_25[var51_51] & 255);
                            var70_73 = var60_63 + var60_63 + var60_63;
                            var55_56[v1] = var55_56[v1] + var70_73;
                            v2 = var63_66;
                            var55_56[v2] = var55_56[v2] + (var70_73 += var60_63 + var60_63);
                            v3 = var68_71;
                            var55_56[v3] = var55_56[v3] + (var70_73 + var60_63 + var60_63);
                            v4 = var69_72;
                            var61_64 = var66_69 - (var26_26[var51_51] & 255);
                            var70_73 = var61_64 + var61_64 + var61_64;
                            var56_58[v4] = var56_58[v4] + var70_73;
                            v5 = var63_66;
                            var56_58[v5] = var56_58[v5] + (var70_73 += var61_64 + var61_64);
                            v6 = var68_71;
                            var56_58[v6] = var56_58[v6] + (var70_73 + var61_64 + var61_64);
                            v7 = var69_72;
                            var62_65 = var67_70 - (var27_27[var51_51] & 255);
                            var70_73 = var62_65 + var62_65 + var62_65;
                            var57_60[v7] = var57_60[v7] + var70_73;
                            v8 = var63_66;
                            var57_60[v8] = var57_60[v8] + (var70_73 += var62_65 + var62_65);
                            v9 = var68_71;
                            var57_60[v9] = var57_60[v9] + (var70_73 + var62_65 + var62_65);
                        }
                        switch (var36_36) {
                            case 6: {
                                var17_17[var42_42] = (byte)var51_51;
                                break block56;
                            }
                            case 7: {
                                if ((var42_42 & 1) != 0) {
                                    var17_17[var42_42 >> 1] = (byte)(var17_17[var42_42 >> 1] & 240 | var51_51);
                                    break block56;
                                }
                                var17_17[var42_42 >> 1] = (byte)(var17_17[var42_42 >> 1] & 15 | var51_51 << 4);
                                break block56;
                            }
                            case 8: {
                                var68_71 = 6 - (var42_42 & 3) * 2;
                                var17_17[var42_42 >> 2] = (byte)(var17_17[var42_42 >> 2] & ~(3 << var68_71) | var51_51 << var68_71);
                                break block56;
                            }
                            case 9: {
                                var68_71 = 7 - (var42_42 & 7);
                                var17_17[var42_42 >> 3] = (byte)(var17_17[var42_42 >> 3] & ~(1 << var68_71) | var51_51 << var68_71);
                                break block56;
                            }
                            case 10: {
                                var68_71 = var42_42 & 7;
                                var17_17[var42_42 >> 3] = (byte)(var17_17[var42_42 >> 3] & ~(1 << var68_71) | var51_51 << var68_71);
                            }
                        }
                    }
                }
                --var63_66;
                var42_42 += var38_38;
                var64_67 = (var64_67 & 65535) + var31_31;
            }
            --var58_61;
            var43_43 = var35_35 += (var59_62 >>> 16) * var3_3;
            var44_44 = var40_40 += (var59_62 >>> 16) * var14_14;
            var59_62 = (var59_62 & 65535) + var33_33;
            var42_42 = var37_37 += var39_39;
        }
    }

    /*
     * Enabled aggressive block sorting
     */
    static void blit(int n2, byte[] byArray, int n3, int n4, int n5, int n6, int n7, int n8, int n9, byte[] byArray2, byte[] byArray3, byte[] byArray4, int n10, byte[] byArray5, int n11, int n12, int n13, byte[] byArray6, int n14, int n15, int n16, int n17, int n18, int n19, int n20, int n21, int n22, int n23, boolean bl2, boolean bl3) {
        int n24;
        int n25;
        int n26;
        int n27;
        int n28;
        if (n19 <= 0 || n20 <= 0 || n10 == 0) {
            return;
        }
        int n29 = n19 - 1;
        int n30 = n29 != 0 ? (int)((((long)n8 << 16) - 1L) / (long)n29) : 0;
        int n31 = n20 - 1;
        int n32 = n31 != 0 ? (int)((((long)n9 << 16) - 1L) / (long)n31) : 0;
        switch (n3) {
            case 8: {
                n28 = 6;
                break;
            }
            case 4: {
                n4 <<= 1;
                n28 = 7;
                break;
            }
            case 2: {
                n4 <<= 2;
                n28 = 8;
                break;
            }
            case 1: {
                n4 <<= 3;
                n28 = n5 == 1 ? 9 : 10;
                break;
            }
            default: {
                return;
            }
        }
        int n33 = n7 * n4 + n6;
        switch (n14) {
            case 8: {
                n27 = 1;
                n26 = 0;
                break;
            }
            case 16: {
                n27 = 2;
                n26 = n16 == 1 ? 1 : 2;
                break;
            }
            case 24: {
                n27 = 3;
                n26 = 3;
                break;
            }
            case 32: {
                n27 = 4;
                n26 = n16 == 1 ? 4 : 5;
                break;
            }
            default: {
                return;
            }
        }
        int n34 = (bl3 ? n18 + n31 : n18) * n15 + (bl2 ? n17 + n29 : n17) * n27;
        int n35 = bl2 ? -n27 : n27;
        int n36 = n25 = bl3 ? -n15 : n15;
        if ((n2 & 2) != 0) {
            switch (n10) {
                case -3: 
                case -1: {
                    if (byArray5 == null) {
                        n10 = 65536;
                    }
                    n24 = n13 * n11 + n12;
                    break;
                }
                case -4: {
                    if (byArray5 == null) {
                        n10 = 65536;
                    }
                    n24 = n13 * (n11 <<= 3) + n12;
                    break;
                }
                case -6: 
                case -5: {
                    if (byArray5 == null) {
                        n10 = 65536;
                    }
                    n24 = 0;
                    break;
                }
                default: {
                    n10 = (n10 << 16) / 255;
                }
                case -2: {
                    n24 = 0;
                    break;
                }
            }
        } else {
            n10 = 65536;
            n24 = 0;
        }
        int n37 = ImageData.getChannelShift(n21);
        int n38 = ImageData.getChannelWidth(n21, n37);
        byte[] byArray7 = ANY_TO_EIGHT[n38];
        int n39 = 8 - n38;
        int n40 = ImageData.getChannelShift(n22);
        int n41 = ImageData.getChannelWidth(n22, n40);
        byte[] byArray8 = ANY_TO_EIGHT[n41];
        int n42 = 8 - n41;
        int n43 = ImageData.getChannelShift(n23);
        int n44 = ImageData.getChannelWidth(n23, n43);
        byte[] byArray9 = ANY_TO_EIGHT[n44];
        int n45 = 8 - n44;
        int n46 = ImageData.getChannelShift(0);
        int n47 = ImageData.getChannelWidth(0, n46);
        byte[] byArray10 = ANY_TO_EIGHT[n47];
        int n48 = 8 - n47;
        int n49 = n34;
        int n50 = n33;
        int n51 = n24;
        int n52 = n10;
        int n53 = 0;
        int n54 = 0;
        int n55 = 0;
        int n56 = 0;
        int n57 = 0;
        int n58 = 0;
        int n59 = 0;
        int n60 = 0;
        int n61 = 0;
        int n62 = n20;
        int n63 = n32;
        while (n62 > 0) {
            int n64 = n19;
            int n65 = n30;
            while (n64 > 0) {
                block61: {
                    int n66;
                    block62: {
                        switch (n28) {
                            case 6: {
                                n57 = byArray[n50] & 0xFF;
                                n50 += n65 >>> 16;
                                break;
                            }
                            case 7: {
                                n57 = (n50 & 1) != 0 ? byArray[n50 >> 1] & 0xF : byArray[n50 >> 1] >>> 4 & 0xF;
                                n50 += n65 >>> 16;
                                break;
                            }
                            case 8: {
                                n57 = byArray[n50 >> 2] >>> 6 - (n50 & 3) * 2 & 3;
                                n50 += n65 >>> 16;
                                break;
                            }
                            case 9: {
                                n57 = byArray[n50 >> 3] >>> 7 - (n50 & 7) & 1;
                                n50 += n65 >>> 16;
                                break;
                            }
                            case 10: {
                                n57 = byArray[n50 >> 3] >>> (n50 & 7) & 1;
                                n50 += n65 >>> 16;
                                break;
                            }
                        }
                        n53 = byArray2[n57] & 0xFF;
                        n54 = byArray3[n57] & 0xFF;
                        n55 = byArray4[n57] & 0xFF;
                        switch (n10) {
                            case -1: {
                                n52 = ((byArray5[n51] & 0xFF) << 16) / 255;
                                n51 += n65 >> 16;
                                break;
                            }
                            case -3: {
                                n52 = byArray5[n51] != 0 ? 65536 : 0;
                                n51 += n65 >> 16;
                                break;
                            }
                            case -4: {
                                n52 = byArray5[n51 >> 3] << (n51 & 7) + 9 & 0x10000;
                                n51 += n65 >> 16;
                                break;
                            }
                            case -5: {
                                n66 = 0;
                                while (n66 < byArray5.length && n57 != (byArray5[n66] & 0xFF)) {
                                }
                                if (n66 >= byArray5.length) break;
                                break block61;
                            }
                            case -6: {
                                n66 = 0;
                                while (n66 < byArray5.length) {
                                    if (n53 == (byArray5[n66] & 0xFF) && n54 == (byArray5[n66 + 1] & 0xFF) && n55 == (byArray5[n66 + 2] & 0xFF)) break;
                                    n66 += 3;
                                }
                                if (n66 < byArray5.length) break block61;
                            }
                        }
                        if (n52 == 65536) break block62;
                        if (n52 == 0) break block61;
                        switch (n26) {
                            case 0: {
                                n66 = byArray6[n49] & 0xFF;
                                n58 = byArray7[(n66 & n21) >>> n37] & 0xFF;
                                n59 = byArray8[(n66 & n22) >>> n40] & 0xFF;
                                n60 = byArray9[(n66 & n23) >>> n43] & 0xFF;
                                n61 = byArray10[0 >>> n46] & 0xFF;
                                break;
                            }
                            case 1: {
                                n66 = (byArray6[n49] & 0xFF) << 8 | byArray6[n49 + 1] & 0xFF;
                                n58 = byArray7[(n66 & n21) >>> n37] & 0xFF;
                                n59 = byArray8[(n66 & n22) >>> n40] & 0xFF;
                                n60 = byArray9[(n66 & n23) >>> n43] & 0xFF;
                                n61 = byArray10[0 >>> n46] & 0xFF;
                                break;
                            }
                            case 2: {
                                n66 = (byArray6[n49 + 1] & 0xFF) << 8 | byArray6[n49] & 0xFF;
                                n58 = byArray7[(n66 & n21) >>> n37] & 0xFF;
                                n59 = byArray8[(n66 & n22) >>> n40] & 0xFF;
                                n60 = byArray9[(n66 & n23) >>> n43] & 0xFF;
                                n61 = byArray10[0 >>> n46] & 0xFF;
                                break;
                            }
                            case 3: {
                                n66 = ((byArray6[n49] & 0xFF) << 8 | byArray6[n49 + 1] & 0xFF) << 8 | byArray6[n49 + 2] & 0xFF;
                                n58 = byArray7[(n66 & n21) >>> n37] & 0xFF;
                                n59 = byArray8[(n66 & n22) >>> n40] & 0xFF;
                                n60 = byArray9[(n66 & n23) >>> n43] & 0xFF;
                                n61 = byArray10[0 >>> n46] & 0xFF;
                                break;
                            }
                            case 4: {
                                n66 = (((byArray6[n49] & 0xFF) << 8 | byArray6[n49 + 1] & 0xFF) << 8 | byArray6[n49 + 2] & 0xFF) << 8 | byArray6[n49 + 3] & 0xFF;
                                n58 = byArray7[(n66 & n21) >>> n37] & 0xFF;
                                n59 = byArray8[(n66 & n22) >>> n40] & 0xFF;
                                n60 = byArray9[(n66 & n23) >>> n43] & 0xFF;
                                n61 = byArray10[0 >>> n46] & 0xFF;
                                break;
                            }
                            case 5: {
                                n66 = (((byArray6[n49 + 3] & 0xFF) << 8 | byArray6[n49 + 2] & 0xFF) << 8 | byArray6[n49 + 1] & 0xFF) << 8 | byArray6[n49] & 0xFF;
                                n58 = byArray7[(n66 & n21) >>> n37] & 0xFF;
                                n59 = byArray8[(n66 & n22) >>> n40] & 0xFF;
                                n60 = byArray9[(n66 & n23) >>> n43] & 0xFF;
                                n61 = byArray10[0 >>> n46] & 0xFF;
                                break;
                            }
                        }
                        n56 = n61 + ((n56 - n61) * n52 >> 16);
                        n53 = n58 + ((n53 - n58) * n52 >> 16);
                        n54 = n59 + ((n54 - n59) * n52 >> 16);
                        n55 = n60 + ((n55 - n60) * n52 >> 16);
                    }
                    n66 = n53 >>> n39 << n37 | n54 >>> n42 << n40 | n55 >>> n45 << n43 | n56 >>> n48 << n46;
                    switch (n26) {
                        case 0: {
                            byArray6[n49] = (byte)n66;
                            break;
                        }
                        case 1: {
                            byArray6[n49] = (byte)(n66 >>> 8);
                            byArray6[n49 + 1] = (byte)(n66 & 0xFF);
                            break;
                        }
                        case 2: {
                            byArray6[n49] = (byte)(n66 & 0xFF);
                            byArray6[n49 + 1] = (byte)(n66 >>> 8);
                            break;
                        }
                        case 3: {
                            byArray6[n49] = (byte)(n66 >>> 16);
                            byArray6[n49 + 1] = (byte)(n66 >>> 8);
                            byArray6[n49 + 2] = (byte)(n66 & 0xFF);
                            break;
                        }
                        case 4: {
                            byArray6[n49] = (byte)(n66 >>> 24);
                            byArray6[n49 + 1] = (byte)(n66 >>> 16);
                            byArray6[n49 + 2] = (byte)(n66 >>> 8);
                            byArray6[n49 + 3] = (byte)(n66 & 0xFF);
                            break;
                        }
                        case 5: {
                            byArray6[n49] = (byte)(n66 & 0xFF);
                            byArray6[n49 + 1] = (byte)(n66 >>> 8);
                            byArray6[n49 + 2] = (byte)(n66 >>> 16);
                            byArray6[n49 + 3] = (byte)(n66 >>> 24);
                            break;
                        }
                    }
                }
                --n64;
                n49 += n35;
                n65 = (n65 & 0xFFFF) + n30;
            }
            --n62;
            n50 = n33 += (n63 >>> 16) * n4;
            n51 = n24 += (n63 >>> 16) * n11;
            n63 = (n63 & 0xFFFF) + n32;
            n49 = n34 += n25;
        }
    }

    static void blit(int n2, byte[] byArray, int n3, int n4, int n5, int n6, int n7, int n8, int n9, int n10, int n11, int n12, int n13, byte[] byArray2, int n14, int n15, int n16, byte[] byArray3, int n17, int n18, int n19, int n20, int n21, int n22, int n23, byte[] byArray4, byte[] byArray5, byte[] byArray6, boolean bl2, boolean bl3) {
        int[] nArray;
        int[] nArray2;
        int[] nArray3;
        int n24;
        int n25;
        int n26;
        int n27;
        int n28;
        if (n22 <= 0 || n23 <= 0 || n13 == 0) {
            return;
        }
        int n29 = n22 - 1;
        int n30 = n29 != 0 ? (int)((((long)n8 << 16) - 1L) / (long)n29) : 0;
        int n31 = n23 - 1;
        int n32 = n31 != 0 ? (int)((((long)n9 << 16) - 1L) / (long)n31) : 0;
        switch (n3) {
            case 8: {
                n28 = 1;
                n27 = 0;
                break;
            }
            case 16: {
                n28 = 2;
                n27 = n5 == 1 ? 1 : 2;
                break;
            }
            case 24: {
                n28 = 3;
                n27 = 3;
                break;
            }
            case 32: {
                n28 = 4;
                n27 = n5 == 1 ? 4 : 5;
                break;
            }
            default: {
                return;
            }
        }
        int n33 = n7 * n4 + n6 * n28;
        switch (n17) {
            case 8: {
                n26 = 6;
                break;
            }
            case 4: {
                n18 <<= 1;
                n26 = 7;
                break;
            }
            case 2: {
                n18 <<= 2;
                n26 = 8;
                break;
            }
            case 1: {
                n18 <<= 3;
                n26 = n19 == 1 ? 9 : 10;
                break;
            }
            default: {
                return;
            }
        }
        int n34 = (bl3 ? n21 + n31 : n21) * n18 + (bl2 ? n20 + n29 : n20);
        int n35 = bl2 ? -1 : 1;
        int n36 = n25 = bl3 ? -n18 : n18;
        if ((n2 & 2) != 0) {
            switch (n13) {
                case -3: 
                case -1: {
                    if (byArray2 == null) {
                        n13 = 65536;
                    }
                    n24 = n16 * n14 + n15;
                    break;
                }
                case -4: {
                    if (byArray2 == null) {
                        n13 = 65536;
                    }
                    n24 = n16 * (n14 <<= 3) + n15;
                    break;
                }
                case -5: {
                    return;
                }
                case -6: {
                    if (byArray2 == null) {
                        n13 = 65536;
                    }
                    n24 = 0;
                    break;
                }
                default: {
                    n13 = (n13 << 16) / 255;
                }
                case -2: {
                    n24 = 0;
                    break;
                }
            }
        } else {
            n13 = 65536;
            n24 = 0;
        }
        boolean bl4 = (n2 & 4) != 0;
        int n37 = ImageData.getChannelShift(n10);
        byte[] byArray7 = ANY_TO_EIGHT[ImageData.getChannelWidth(n10, n37)];
        int n38 = ImageData.getChannelShift(n11);
        byte[] byArray8 = ANY_TO_EIGHT[ImageData.getChannelWidth(n11, n38)];
        int n39 = ImageData.getChannelShift(n12);
        byte[] byArray9 = ANY_TO_EIGHT[ImageData.getChannelWidth(n12, n39)];
        int n40 = ImageData.getChannelShift(0);
        byte[] byArray10 = ANY_TO_EIGHT[ImageData.getChannelWidth(0, n40)];
        int n41 = n34;
        int n42 = n33;
        int n43 = n24;
        int n44 = n13;
        int n45 = 0;
        int n46 = 0;
        int n47 = 0;
        int n48 = 0;
        int n49 = 0;
        int n50 = 0;
        int n51 = -1;
        int n52 = -1;
        int n53 = -1;
        int n54 = 1 << n17;
        if (byArray4 != null && byArray4.length < n54) {
            n54 = byArray4.length;
        }
        if (bl4) {
            nArray3 = new int[n22 + 2];
            nArray2 = new int[n22 + 2];
            nArray = new int[n22 + 2];
        } else {
            nArray3 = null;
            nArray2 = null;
            nArray = null;
        }
        int n55 = n23;
        int n56 = n32;
        while (n55 > 0) {
            int n57 = 0;
            int n58 = 0;
            int n59 = 0;
            int n60 = n22;
            int n61 = n30;
            while (n60 > 0) {
                block81: {
                    int n62;
                    int n63;
                    int n64;
                    block80: {
                        switch (n27) {
                            case 0: {
                                n64 = byArray[n42] & 0xFF;
                                n42 += n61 >>> 16;
                                n45 = byArray7[(n64 & n10) >>> n37] & 0xFF;
                                n46 = byArray8[(n64 & n11) >>> n38] & 0xFF;
                                n47 = byArray9[(n64 & n12) >>> n39] & 0xFF;
                                n48 = byArray10[0 >>> n40] & 0xFF;
                                break;
                            }
                            case 1: {
                                n64 = (byArray[n42] & 0xFF) << 8 | byArray[n42 + 1] & 0xFF;
                                n42 += (n61 >>> 16) * 2;
                                n45 = byArray7[(n64 & n10) >>> n37] & 0xFF;
                                n46 = byArray8[(n64 & n11) >>> n38] & 0xFF;
                                n47 = byArray9[(n64 & n12) >>> n39] & 0xFF;
                                n48 = byArray10[0 >>> n40] & 0xFF;
                                break;
                            }
                            case 2: {
                                n64 = (byArray[n42 + 1] & 0xFF) << 8 | byArray[n42] & 0xFF;
                                n42 += (n61 >>> 16) * 2;
                                n45 = byArray7[(n64 & n10) >>> n37] & 0xFF;
                                n46 = byArray8[(n64 & n11) >>> n38] & 0xFF;
                                n47 = byArray9[(n64 & n12) >>> n39] & 0xFF;
                                n48 = byArray10[0 >>> n40] & 0xFF;
                                break;
                            }
                            case 3: {
                                n64 = ((byArray[n42] & 0xFF) << 8 | byArray[n42 + 1] & 0xFF) << 8 | byArray[n42 + 2] & 0xFF;
                                n42 += (n61 >>> 16) * 3;
                                n45 = byArray7[(n64 & n10) >>> n37] & 0xFF;
                                n46 = byArray8[(n64 & n11) >>> n38] & 0xFF;
                                n47 = byArray9[(n64 & n12) >>> n39] & 0xFF;
                                n48 = byArray10[0 >>> n40] & 0xFF;
                                break;
                            }
                            case 4: {
                                n64 = (((byArray[n42] & 0xFF) << 8 | byArray[n42 + 1] & 0xFF) << 8 | byArray[n42 + 2] & 0xFF) << 8 | byArray[n42 + 3] & 0xFF;
                                n42 += (n61 >>> 16) * 4;
                                n45 = byArray7[(n64 & n10) >>> n37] & 0xFF;
                                n46 = byArray8[(n64 & n11) >>> n38] & 0xFF;
                                n47 = byArray9[(n64 & n12) >>> n39] & 0xFF;
                                n48 = byArray10[0 >>> n40] & 0xFF;
                                break;
                            }
                            case 5: {
                                n64 = (((byArray[n42 + 3] & 0xFF) << 8 | byArray[n42 + 2] & 0xFF) << 8 | byArray[n42 + 1] & 0xFF) << 8 | byArray[n42] & 0xFF;
                                n42 += (n61 >>> 16) * 4;
                                n45 = byArray7[(n64 & n10) >>> n37] & 0xFF;
                                n46 = byArray8[(n64 & n11) >>> n38] & 0xFF;
                                n47 = byArray9[(n64 & n12) >>> n39] & 0xFF;
                                n48 = byArray10[0 >>> n40] & 0xFF;
                            }
                        }
                        block27 : switch (n13) {
                            case -1: {
                                n44 = ((byArray2[n43] & 0xFF) << 16) / 255;
                                n43 += n61 >> 16;
                                break;
                            }
                            case -2: {
                                n44 = (n48 << 16) / 255;
                                break;
                            }
                            case -3: {
                                n44 = byArray2[n43] != 0 ? 65536 : 0;
                                n43 += n61 >> 16;
                                break;
                            }
                            case -4: {
                                n44 = byArray2[n43 >> 3] << (n43 & 7) + 9 & 0x10000;
                                n43 += n61 >> 16;
                                break;
                            }
                            case -6: {
                                n44 = 65536;
                                n64 = 0;
                                while (n64 < byArray2.length) {
                                    if (n45 == byArray2[n64] && n46 == byArray2[n64 + 1] && n47 == byArray2[n64 + 2]) {
                                        n44 = 0;
                                        break block27;
                                    }
                                    n64 += 3;
                                }
                                break;
                            }
                        }
                        if (n44 == 65536) break block80;
                        if (n44 == 0) break block81;
                        switch (n26) {
                            case 6: {
                                n49 = byArray3[n41] & 0xFF;
                                break;
                            }
                            case 7: {
                                if ((n41 & 1) != 0) {
                                    n49 = byArray3[n41 >> 1] & 0xF;
                                    break;
                                }
                                n49 = byArray3[n41 >> 1] >>> 4 & 0xF;
                                break;
                            }
                            case 8: {
                                n49 = byArray3[n41 >> 2] >>> 6 - (n41 & 3) * 2 & 3;
                                break;
                            }
                            case 9: {
                                n49 = byArray3[n41 >> 3] >>> 7 - (n41 & 7) & 1;
                                break;
                            }
                            case 10: {
                                n49 = byArray3[n41 >> 3] >>> (n41 & 7) & 1;
                            }
                        }
                        n64 = byArray4[n49] & 0xFF;
                        n63 = byArray5[n49] & 0xFF;
                        n62 = byArray6[n49] & 0xFF;
                        n45 = n64 + ((n45 - n64) * n44 >> 16);
                        n46 = n63 + ((n46 - n63) * n44 >> 16);
                        n47 = n62 + ((n47 - n62) * n44 >> 16);
                    }
                    if (bl4) {
                        if ((n45 += nArray3[n60] >> 4) < 0) {
                            n45 = 0;
                        } else if (n45 > 255) {
                            n45 = 255;
                        }
                        if ((n46 += nArray2[n60] >> 4) < 0) {
                            n46 = 0;
                        } else if (n46 > 255) {
                            n46 = 255;
                        }
                        if ((n47 += nArray[n60] >> 4) < 0) {
                            n47 = 0;
                        } else if (n47 > 255) {
                            n47 = 255;
                        }
                        nArray3[n60] = n57;
                        nArray2[n60] = n58;
                        nArray[n60] = n59;
                    }
                    if (n45 != n51 || n46 != n52 || n47 != n53) {
                        n64 = 0;
                        int n65 = Integer.MAX_VALUE;
                        while (n64 < n54) {
                            n63 = (byArray4[n64] & 0xFF) - n45;
                            n62 = (byArray5[n64] & 0xFF) - n46;
                            int n66 = (byArray6[n64] & 0xFF) - n47;
                            int n67 = n63 * n63 + n62 * n62 + n66 * n66;
                            if (n67 < n65) {
                                n50 = n64;
                                if (n67 == 0) break;
                                n65 = n67;
                            }
                            ++n64;
                        }
                        n51 = n45;
                        n52 = n46;
                        n53 = n47;
                    }
                    if (bl4) {
                        n64 = n60 - 1;
                        int n68 = n63 = n60 + 1;
                        n57 = n45 - (byArray4[n50] & 0xFF);
                        n62 = n57 + n57 + n57;
                        nArray3[n68] = nArray3[n68] + n62;
                        int n69 = n60;
                        nArray3[n69] = nArray3[n69] + (n62 += n57 + n57);
                        int n70 = n64;
                        nArray3[n70] = nArray3[n70] + (n62 + n57 + n57);
                        int n71 = n63;
                        n58 = n46 - (byArray5[n50] & 0xFF);
                        n62 = n58 + n58 + n58;
                        nArray2[n71] = nArray2[n71] + n62;
                        int n72 = n60;
                        nArray2[n72] = nArray2[n72] + (n62 += n58 + n58);
                        int n73 = n64;
                        nArray2[n73] = nArray2[n73] + (n62 + n58 + n58);
                        int n74 = n63;
                        n59 = n47 - (byArray6[n50] & 0xFF);
                        n62 = n59 + n59 + n59;
                        nArray[n74] = nArray[n74] + n62;
                        int n75 = n60;
                        nArray[n75] = nArray[n75] + (n62 += n59 + n59);
                        int n76 = n64;
                        nArray[n76] = nArray[n76] + (n62 + n59 + n59);
                    }
                    switch (n26) {
                        case 6: {
                            byArray3[n41] = (byte)n50;
                            break;
                        }
                        case 7: {
                            if ((n41 & 1) != 0) {
                                byArray3[n41 >> 1] = (byte)(byArray3[n41 >> 1] & 0xF0 | n50);
                                break;
                            }
                            byArray3[n41 >> 1] = (byte)(byArray3[n41 >> 1] & 0xF | n50 << 4);
                            break;
                        }
                        case 8: {
                            n64 = 6 - (n41 & 3) * 2;
                            byArray3[n41 >> 2] = (byte)(byArray3[n41 >> 2] & ~(3 << n64) | n50 << n64);
                            break;
                        }
                        case 9: {
                            n64 = 7 - (n41 & 7);
                            byArray3[n41 >> 3] = (byte)(byArray3[n41 >> 3] & ~(1 << n64) | n50 << n64);
                            break;
                        }
                        case 10: {
                            n64 = n41 & 7;
                            byArray3[n41 >> 3] = (byte)(byArray3[n41 >> 3] & ~(1 << n64) | n50 << n64);
                        }
                    }
                }
                --n60;
                n41 += n35;
                n61 = (n61 & 0xFFFF) + n30;
            }
            --n55;
            n42 = n33 += (n56 >>> 16) * n4;
            n43 = n24 += (n56 >>> 16) * n14;
            n56 = (n56 & 0xFFFF) + n32;
            n41 = n34 += n25;
        }
    }

    static int getChannelShift(int n2) {
        if (n2 == 0) {
            return 0;
        }
        int n3 = 0;
        while ((n2 & 1) == 0 && n3 < 32) {
            n2 >>>= 1;
            ++n3;
        }
        return n3;
    }

    static int getChannelWidth(int n2, int n3) {
        if (n2 == 0) {
            return 0;
        }
        n2 >>>= n3;
        int n4 = n3;
        while ((n2 & 1) != 0 && n4 < 32) {
            n2 >>>= 1;
            ++n4;
        }
        return n4 - n3;
    }

    static byte getChannelField(int n2, int n3) {
        int n4 = ImageData.getChannelShift(n3);
        return ANY_TO_EIGHT[ImageData.getChannelWidth(n3, n4)][(n2 & n3) >>> n4];
    }

    static ImageData createGradientBand(int n2, int n3, boolean bl2, RGB rGB, RGB rGB2, int n4, int n5, int n6) {
        byte[] byArray;
        int n7;
        int n8;
        int n9;
        PaletteData paletteData;
        if (n4 != 0 && n5 != 0 && n6 != 0) {
            paletteData = new PaletteData(65280, 0xFF0000, -16777216);
            n9 = 32;
            if (n4 >= 8 && n5 >= 8 && n6 >= 8) {
                int n10;
                if (bl2) {
                    n8 = 1;
                    n7 = n3;
                    n10 = n7 > 1 ? n7 - 1 : 1;
                } else {
                    n8 = n2;
                    n7 = 1;
                    n10 = n8 > 1 ? n8 - 1 : 1;
                }
                int n11 = n8 * 4;
                byArray = new byte[n7 * n11];
                ImageData.buildPreciseGradientChannel(rGB.blue, rGB2.blue, n10, n8, n7, bl2, byArray, 0, n11);
                ImageData.buildPreciseGradientChannel(rGB.green, rGB2.green, n10, n8, n7, bl2, byArray, 1, n11);
                ImageData.buildPreciseGradientChannel(rGB.red, rGB2.red, n10, n8, n7, bl2, byArray, 2, n11);
            } else {
                int n12;
                if (bl2) {
                    n8 = n2 < 8 ? n2 : 8;
                    n7 = n3;
                    n12 = n7 > 1 ? n7 - 1 : 1;
                } else {
                    n8 = n2;
                    n7 = n3 < 8 ? n3 : 8;
                    n12 = n8 > 1 ? n8 - 1 : 1;
                }
                int n13 = n8 * 4;
                byArray = new byte[n7 * n13];
                ImageData.buildDitheredGradientChannel(rGB.blue, rGB2.blue, n12, n8, n7, bl2, byArray, 0, n13, n6);
                ImageData.buildDitheredGradientChannel(rGB.green, rGB2.green, n12, n8, n7, bl2, byArray, 1, n13, n5);
                ImageData.buildDitheredGradientChannel(rGB.red, rGB2.red, n12, n8, n7, bl2, byArray, 2, n13, n4);
            }
        } else {
            int n14;
            paletteData = new PaletteData(new RGB[]{rGB, rGB2});
            n9 = 8;
            if (bl2) {
                n8 = n2 < 8 ? n2 : 8;
                n7 = n3;
                n14 = n7 > 1 ? 0x1040000 / (n7 - 1) + 1 : 1;
            } else {
                n8 = n2;
                n7 = n3 < 8 ? n3 : 8;
                n14 = n8 > 1 ? 0x1040000 / (n8 - 1) + 1 : 1;
            }
            int n15 = n8 + 3 & 0xFFFFFFFC;
            byArray = new byte[n7 * n15];
            if (bl2) {
                int n16 = 0;
                int n17 = 0;
                int n18 = 0;
                while (n16 < n7) {
                    int n19 = 0;
                    while (n19 < n8) {
                        byArray[n18 + n19] = n17 + DITHER_MATRIX[n16 & 7][n19] < 0x1000000 ? (byte)0 : 1;
                        ++n19;
                    }
                    ++n16;
                    n17 += n14;
                    n18 += n15;
                }
            } else {
                int n20 = 0;
                int n21 = 0;
                while (n20 < n8) {
                    int n22 = 0;
                    int n23 = n20;
                    while (n22 < n7) {
                        byArray[n23] = n21 + DITHER_MATRIX[n22][n20 & 7] < 0x1000000 ? (byte)0 : 1;
                        ++n22;
                        n23 += n15;
                    }
                    ++n20;
                    n21 += n14;
                }
            }
        }
        return new ImageData(n8, n7, n9, paletteData, 4, byArray);
    }

    static final void buildPreciseGradientChannel(int n2, int n3, int n4, int n5, int n6, boolean bl2, byte[] byArray, int n7, int n8) {
        int n9 = n2 << 16;
        int n10 = ((n3 << 16) - n9) / n4 + 1;
        if (bl2) {
            int n11 = 0;
            while (n11 < n6) {
                byArray[n7] = (byte)(n9 >>> 16);
                n9 += n10;
                ++n11;
                n7 += n8;
            }
        } else {
            int n12 = 0;
            while (n12 < n5) {
                byArray[n7] = (byte)(n9 >>> 16);
                n9 += n10;
                ++n12;
                n7 += 4;
            }
        }
    }

    static final void buildDitheredGradientChannel(int n2, int n3, int n4, int n5, int n6, boolean bl2, byte[] byArray, int n7, int n8, int n9) {
        int n10 = 65280 >>> n9;
        int n11 = n2 << 16;
        int n12 = ((n3 << 16) - n11) / n4 + 1;
        if (bl2) {
            int n13 = 0;
            while (n13 < n6) {
                int n14 = 0;
                int n15 = n7;
                while (n14 < n5) {
                    int n16 = DITHER_MATRIX[n13 & 7][n14] >>> n9;
                    int n17 = n11 + n16;
                    byArray[n15] = n17 > 0xFFFFFF ? -1 : (byte)(n17 >>> 16 & n10);
                    ++n14;
                    n15 += 4;
                }
                n11 += n12;
                ++n13;
                n7 += n8;
            }
        } else {
            int n18 = 0;
            while (n18 < n5) {
                int n19 = 0;
                int n20 = n7;
                while (n19 < n6) {
                    int n21 = DITHER_MATRIX[n19][n18 & 7] >>> n9;
                    int n22 = n11 + n21;
                    byArray[n20] = n22 > 0xFFFFFF ? -1 : (byte)(n22 >>> 16 & n10);
                    ++n19;
                    n20 += n8;
                }
                n11 += n12;
                ++n18;
                n7 += 4;
            }
        }
    }

    static void fillGradientRectangle(GC gC, Device device, int n2, int n3, int n4, int n5, boolean bl2, RGB rGB, RGB rGB2, int n6, int n7, int n8) {
        ImageData imageData = ImageData.createGradientBand(n4, n5, bl2, rGB, rGB2, n6, n7, n8);
        Image image = new Image(device, imageData);
        if (imageData.width == 1 || imageData.height == 1) {
            gC.drawImage(image, 0, 0, imageData.width, imageData.height, n2, n3, n4, n5);
        } else if (bl2) {
            int n9 = 0;
            while (n9 < n4) {
                int n10 = n4 - n9;
                if (n10 > imageData.width) {
                    n10 = imageData.width;
                }
                gC.drawImage(image, 0, 0, n10, imageData.height, n9 + n2, n3, n10, imageData.height);
                n9 += imageData.width;
            }
        } else {
            int n11 = 0;
            while (n11 < n5) {
                int n12 = n5 - n11;
                if (n12 > imageData.height) {
                    n12 = imageData.height;
                }
                gC.drawImage(image, 0, 0, imageData.width, n12, n2, n11 + n3, imageData.width, n12);
                n11 += imageData.height;
            }
        }
        image.dispose();
    }
}

