/*
 * Decompiled with CFR 0.152.
 */
package org.objectweb.asm.util;

import org.objectweb.asm.AnnotationVisitor;
import org.objectweb.asm.Type;
import org.objectweb.asm.util.AbstractVisitor;
import org.objectweb.asm.util.TraceAbstractVisitor;

public class TraceAnnotationVisitor
extends TraceAbstractVisitor
implements AnnotationVisitor {
    protected AnnotationVisitor av;
    private int valueNumber = 0;

    public void visit(String string, Object object) {
        this.buf.setLength(0);
        this.appendComa(this.valueNumber++);
        if (string != null) {
            this.buf.append(string).append('=');
        }
        if (object instanceof String) {
            this.visitString((String)object);
        } else if (object instanceof Type) {
            this.visitType((Type)object);
        } else if (object instanceof Byte) {
            this.visitByte((Byte)object);
        } else if (object instanceof Boolean) {
            this.visitBoolean((Boolean)object);
        } else if (object instanceof Short) {
            this.visitShort((Short)object);
        } else if (object instanceof Character) {
            this.visitChar(((Character)object).charValue());
        } else if (object instanceof Integer) {
            this.visitInt((Integer)object);
        } else if (object instanceof Float) {
            this.visitFloat(((Float)object).floatValue());
        } else if (object instanceof Long) {
            this.visitLong((Long)object);
        } else if (object instanceof Double) {
            this.visitDouble((Double)object);
        } else if (object.getClass().isArray()) {
            this.buf.append('{');
            if (object instanceof byte[]) {
                byte[] byArray = (byte[])object;
                for (int i2 = 0; i2 < byArray.length; ++i2) {
                    this.appendComa(i2);
                    this.visitByte(byArray[i2]);
                }
            } else if (object instanceof boolean[]) {
                boolean[] blArray = (boolean[])object;
                for (int i3 = 0; i3 < blArray.length; ++i3) {
                    this.appendComa(i3);
                    this.visitBoolean(blArray[i3]);
                }
            } else if (object instanceof short[]) {
                short[] sArray = (short[])object;
                for (int i4 = 0; i4 < sArray.length; ++i4) {
                    this.appendComa(i4);
                    this.visitShort(sArray[i4]);
                }
            } else if (object instanceof char[]) {
                char[] cArray = (char[])object;
                for (int i5 = 0; i5 < cArray.length; ++i5) {
                    this.appendComa(i5);
                    this.visitChar(cArray[i5]);
                }
            } else if (object instanceof int[]) {
                int[] nArray = (int[])object;
                for (int i6 = 0; i6 < nArray.length; ++i6) {
                    this.appendComa(i6);
                    this.visitInt(nArray[i6]);
                }
            } else if (object instanceof long[]) {
                long[] lArray = (long[])object;
                for (int i7 = 0; i7 < lArray.length; ++i7) {
                    this.appendComa(i7);
                    this.visitLong(lArray[i7]);
                }
            } else if (object instanceof float[]) {
                float[] fArray = (float[])object;
                for (int i8 = 0; i8 < fArray.length; ++i8) {
                    this.appendComa(i8);
                    this.visitFloat(fArray[i8]);
                }
            } else if (object instanceof double[]) {
                double[] dArray = (double[])object;
                for (int i9 = 0; i9 < dArray.length; ++i9) {
                    this.appendComa(i9);
                    this.visitDouble(dArray[i9]);
                }
            }
            this.buf.append('}');
        }
        this.text.add(this.buf.toString());
        if (this.av != null) {
            this.av.visit(string, object);
        }
    }

    private void visitInt(int n2) {
        this.buf.append(n2);
    }

    private void visitLong(long l2) {
        this.buf.append(l2).append('L');
    }

    private void visitFloat(float f2) {
        this.buf.append(f2).append('F');
    }

    private void visitDouble(double d2) {
        this.buf.append(d2).append('D');
    }

    private void visitChar(char c2) {
        this.buf.append("(char)").append((int)c2);
    }

    private void visitShort(short s2) {
        this.buf.append("(short)").append(s2);
    }

    private void visitByte(byte by2) {
        this.buf.append("(byte)").append(by2);
    }

    private void visitBoolean(boolean bl2) {
        this.buf.append(bl2);
    }

    private void visitString(String string) {
        AbstractVisitor.appendString(this.buf, string);
    }

    private void visitType(Type type) {
        this.buf.append(type.getClassName()).append(".class");
    }

    public void visitEnum(String string, String string2, String string3) {
        this.buf.setLength(0);
        this.appendComa(this.valueNumber++);
        if (string != null) {
            this.buf.append(string).append('=');
        }
        this.appendDescriptor(1, string2);
        this.buf.append('.').append(string3);
        this.text.add(this.buf.toString());
        if (this.av != null) {
            this.av.visitEnum(string, string2, string3);
        }
    }

    public AnnotationVisitor visitAnnotation(String string, String string2) {
        this.buf.setLength(0);
        this.appendComa(this.valueNumber++);
        if (string != null) {
            this.buf.append(string).append('=');
        }
        this.buf.append('@');
        this.appendDescriptor(1, string2);
        this.buf.append('(');
        this.text.add(this.buf.toString());
        TraceAnnotationVisitor traceAnnotationVisitor = this.createTraceAnnotationVisitor();
        this.text.add(traceAnnotationVisitor.getText());
        this.text.add(")");
        if (this.av != null) {
            traceAnnotationVisitor.av = this.av.visitAnnotation(string, string2);
        }
        return traceAnnotationVisitor;
    }

    public AnnotationVisitor visitArray(String string) {
        this.buf.setLength(0);
        this.appendComa(this.valueNumber++);
        if (string != null) {
            this.buf.append(string).append('=');
        }
        this.buf.append('{');
        this.text.add(this.buf.toString());
        TraceAnnotationVisitor traceAnnotationVisitor = this.createTraceAnnotationVisitor();
        this.text.add(traceAnnotationVisitor.getText());
        this.text.add("}");
        if (this.av != null) {
            traceAnnotationVisitor.av = this.av.visitArray(string);
        }
        return traceAnnotationVisitor;
    }

    public void visitEnd() {
        if (this.av != null) {
            this.av.visitEnd();
        }
    }

    private void appendComa(int n2) {
        if (n2 != 0) {
            this.buf.append(", ");
        }
    }
}

