/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.swt.graphics;

import org.eclipse.swt.SWT;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.FontMetrics;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.GCData;
import org.eclipse.swt.graphics.GlyphMetrics;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.graphics.Resource;
import org.eclipse.swt.graphics.TextStyle;
import org.eclipse.swt.internal.Compatibility;
import org.eclipse.swt.internal.gdip.Gdip;
import org.eclipse.swt.internal.gdip.Rect;
import org.eclipse.swt.internal.win32.LOGFONT;
import org.eclipse.swt.internal.win32.LOGFONTA;
import org.eclipse.swt.internal.win32.LOGFONTW;
import org.eclipse.swt.internal.win32.OS;
import org.eclipse.swt.internal.win32.RECT;
import org.eclipse.swt.internal.win32.SCRIPT_ANALYSIS;
import org.eclipse.swt.internal.win32.SCRIPT_CONTROL;
import org.eclipse.swt.internal.win32.SCRIPT_DIGITSUBSTITUTE;
import org.eclipse.swt.internal.win32.SCRIPT_FONTPROPERTIES;
import org.eclipse.swt.internal.win32.SCRIPT_ITEM;
import org.eclipse.swt.internal.win32.SCRIPT_LOGATTR;
import org.eclipse.swt.internal.win32.SCRIPT_PROPERTIES;
import org.eclipse.swt.internal.win32.SCRIPT_STATE;
import org.eclipse.swt.internal.win32.TEXTMETRIC;
import org.eclipse.swt.internal.win32.TEXTMETRICA;
import org.eclipse.swt.internal.win32.TEXTMETRICW;

public final class TextLayout
extends Resource {
    Font font;
    String text;
    String segmentsText;
    int lineSpacing;
    int ascent;
    int descent;
    int alignment;
    int wrapWidth;
    int orientation;
    int indent;
    boolean justify;
    int[] tabs;
    int[] segments;
    StyleItem[] styles;
    StyleItem[] allRuns;
    StyleItem[][] runs;
    int[] lineOffset;
    int[] lineY;
    int[] lineWidth;
    int mLangFontLink2;
    static final char LTR_MARK = '\u200e';
    static final char RTL_MARK = '\u200f';
    static final int SCRIPT_VISATTR_SIZEOF = 2;
    static final int GOFFSET_SIZEOF = 8;
    static final byte[] CLSID_CMultiLanguage = new byte[16];
    static final byte[] IID_IMLangFontLink2 = new byte[16];

    static {
        OS.IIDFromString("{275c23e2-3747-11d0-9fea-00aa003f8646}\u0000".toCharArray(), CLSID_CMultiLanguage);
        OS.IIDFromString("{DCCFC162-2B38-11d2-B7EC-00C04F8F5D9A}\u0000".toCharArray(), IID_IMLangFontLink2);
    }

    public TextLayout(Device device) {
        if (device == null) {
            device = Device.getDevice();
        }
        if (device == null) {
            SWT.error(4);
        }
        this.device = device;
        this.descent = -1;
        this.ascent = -1;
        this.wrapWidth = -1;
        this.lineSpacing = 0;
        this.orientation = 0x2000000;
        this.styles = new StyleItem[2];
        this.styles[0] = new StyleItem();
        this.styles[1] = new StyleItem();
        this.text = "";
        int[] nArray = new int[1];
        OS.OleInitialize(0);
        if (OS.CoCreateInstance(CLSID_CMultiLanguage, 0, 1, IID_IMLangFontLink2, nArray) == 0) {
            this.mLangFontLink2 = nArray[0];
        }
        if (device.tracking) {
            device.new_Object(this);
        }
    }

    void breakRun(StyleItem styleItem) {
        if (styleItem.psla != 0) {
            return;
        }
        char[] cArray = new char[styleItem.length];
        this.segmentsText.getChars(styleItem.start, styleItem.start + styleItem.length, cArray, 0);
        int n2 = OS.GetProcessHeap();
        styleItem.psla = OS.HeapAlloc(n2, 8, SCRIPT_LOGATTR.sizeof * cArray.length);
        if (styleItem.psla == 0) {
            SWT.error(2);
        }
        OS.ScriptBreak(cArray, cArray.length, styleItem.analysis, styleItem.psla);
    }

    void checkItem(int n2, StyleItem styleItem) {
        if (styleItem.fallbackFont != 0) {
            LOGFONT lOGFONT;
            LOGFONT lOGFONT2 = lOGFONT = OS.IsUnicode ? new LOGFONTW() : new LOGFONTA();
            if (OS.GetObject(styleItem.fallbackFont, LOGFONT.sizeof, lOGFONT) == 0) {
                styleItem.free();
                OS.SelectObject(n2, this.getItemFont(styleItem));
                this.shape(n2, styleItem);
            }
        }
    }

    void checkLayout() {
        if (this.isDisposed()) {
            SWT.error(44);
        }
    }

    void computeRuns(GC gC) {
        int n2;
        int n3;
        int n4;
        int n5;
        Object object;
        if (this.runs != null) {
            return;
        }
        int n6 = gC != null ? gC.handle : this.device.internal_new_GC(null);
        int n7 = OS.CreateCompatibleDC(n6);
        this.allRuns = this.itemize();
        int n8 = 0;
        while (n8 < this.allRuns.length - 1) {
            object = this.allRuns[n8];
            OS.SelectObject(n7, this.getItemFont((StyleItem)object));
            this.shape(n7, (StyleItem)object);
            ++n8;
        }
        SCRIPT_LOGATTR sCRIPT_LOGATTR = new SCRIPT_LOGATTR();
        object = new SCRIPT_PROPERTIES();
        int n9 = this.indent;
        int n10 = 0;
        int n11 = 1;
        int n12 = 0;
        while (n12 < this.allRuns.length - 1) {
            int n13;
            int n14;
            StyleItem styleItem = this.allRuns[n12];
            if (styleItem.length == 1) {
                n5 = this.segmentsText.charAt(styleItem.start);
                switch (n5) {
                    case 9: {
                        styleItem.tab = true;
                        if (this.tabs == null) break;
                        n4 = this.tabs.length;
                        n14 = 0;
                        while (n14 < n4) {
                            if (this.tabs[n14] > n9) {
                                styleItem.width = this.tabs[n14] - n9;
                                break;
                            }
                            ++n14;
                        }
                        if (n14 != n4) break;
                        n3 = this.tabs[n4 - 1];
                        int n15 = n13 = n4 > 1 ? this.tabs[n4 - 1] - this.tabs[n4 - 2] : this.tabs[0];
                        if (n13 <= 0) break;
                        while (n3 <= n9) {
                            n3 += n13;
                        }
                        styleItem.width = n3 - n9;
                        break;
                    }
                    case 10: {
                        styleItem.lineBreak = true;
                        break;
                    }
                    case 13: {
                        styleItem.lineBreak = true;
                        StyleItem styleItem2 = this.allRuns[n12 + 1];
                        if (styleItem2.length == 0 || this.segmentsText.charAt(styleItem2.start) != '\n') break;
                        ++styleItem.length;
                        styleItem2.free();
                        ++n12;
                    }
                }
            }
            if (this.wrapWidth != -1 && n9 + styleItem.width > this.wrapWidth && !styleItem.tab) {
                StyleItem[] styleItemArray;
                n5 = 0;
                int[] nArray = new int[styleItem.length];
                if (styleItem.style != null && styleItem.style.metrics != null) {
                    nArray[0] = styleItem.width;
                } else {
                    OS.ScriptGetLogicalWidths(styleItem.analysis, styleItem.length, styleItem.glyphCount, styleItem.advances, styleItem.clusters, styleItem.visAttrs, nArray);
                }
                n14 = 0;
                n3 = this.wrapWidth - n9;
                while (n14 + nArray[n5] < n3) {
                    n14 += nArray[n5++];
                }
                n13 = n5;
                int n16 = n12;
                while (n12 >= n10) {
                    this.breakRun(styleItem);
                    while (n5 >= 0) {
                        OS.MoveMemory(sCRIPT_LOGATTR, styleItem.psla + n5 * SCRIPT_LOGATTR.sizeof, SCRIPT_LOGATTR.sizeof);
                        if (sCRIPT_LOGATTR.fSoftBreak || sCRIPT_LOGATTR.fWhiteSpace) break;
                        --n5;
                    }
                    if (n5 == 0 && n12 != n10 && !styleItem.tab && sCRIPT_LOGATTR.fSoftBreak && !sCRIPT_LOGATTR.fWhiteSpace) {
                        OS.MoveMemory((SCRIPT_PROPERTIES)object, this.device.scripts[styleItem.analysis.eScript], SCRIPT_PROPERTIES.sizeof);
                        n2 = ((SCRIPT_PROPERTIES)object).langid;
                        styleItemArray = this.allRuns[n12 - 1];
                        OS.MoveMemory((SCRIPT_PROPERTIES)object, this.device.scripts[styleItemArray.analysis.eScript], SCRIPT_PROPERTIES.sizeof);
                        if (((SCRIPT_PROPERTIES)object).langid == n2 || n2 == 0 || ((SCRIPT_PROPERTIES)object).langid == 0) {
                            this.breakRun((StyleItem)styleItemArray);
                            OS.MoveMemory(sCRIPT_LOGATTR, styleItemArray.psla + (styleItemArray.length - 1) * SCRIPT_LOGATTR.sizeof, SCRIPT_LOGATTR.sizeof);
                            if (!sCRIPT_LOGATTR.fWhiteSpace) {
                                n5 = -1;
                            }
                        }
                    }
                    if (n5 >= 0 || n12 == n10) break;
                    styleItem = this.allRuns[--n12];
                    n5 = styleItem.length - 1;
                }
                if (n5 == 0 && n12 != n10 && !styleItem.tab) {
                    styleItem = this.allRuns[--n12];
                } else if (n5 <= 0 && n12 == n10) {
                    n12 = n16;
                    styleItem = this.allRuns[n12];
                    n5 = Math.max(1, n13);
                }
                this.breakRun(styleItem);
                while (n5 < styleItem.length) {
                    OS.MoveMemory(sCRIPT_LOGATTR, styleItem.psla + n5 * SCRIPT_LOGATTR.sizeof, SCRIPT_LOGATTR.sizeof);
                    if (!sCRIPT_LOGATTR.fWhiteSpace) break;
                    ++n5;
                }
                if (n5 > 0 && n5 < styleItem.length) {
                    StyleItem styleItem3 = new StyleItem();
                    styleItem3.start = styleItem.start + n5;
                    styleItem3.length = styleItem.length - n5;
                    styleItem3.style = styleItem.style;
                    styleItem3.analysis = styleItem.analysis;
                    styleItem.free();
                    styleItem.length = n5;
                    OS.SelectObject(n7, this.getItemFont(styleItem));
                    this.shape(n7, styleItem);
                    OS.SelectObject(n7, this.getItemFont(styleItem3));
                    this.shape(n7, styleItem3);
                    styleItemArray = new StyleItem[this.allRuns.length + 1];
                    System.arraycopy(this.allRuns, 0, styleItemArray, 0, n12 + 1);
                    System.arraycopy(this.allRuns, n12 + 1, styleItemArray, n12 + 2, this.allRuns.length - n12 - 1);
                    this.allRuns = styleItemArray;
                    this.allRuns[n12 + 1] = styleItem3;
                }
                if (n12 != this.allRuns.length - 2) {
                    styleItem.lineBreak = true;
                    styleItem.softBreak = true;
                }
            }
            n9 += styleItem.width;
            if (styleItem.lineBreak) {
                n10 = n12 + 1;
                n9 = styleItem.softBreak ? 0 : this.indent;
                ++n11;
            }
            ++n12;
        }
        n9 = 0;
        this.runs = new StyleItem[n11][];
        this.lineOffset = new int[n11 + 1];
        this.lineY = new int[n11 + 1];
        this.lineWidth = new int[n11];
        n12 = 0;
        int n17 = 0;
        n5 = Math.max(0, this.ascent);
        n4 = Math.max(0, this.descent);
        StyleItem[] styleItemArray = new StyleItem[this.allRuns.length];
        n3 = 0;
        while (n3 < this.allRuns.length) {
            StyleItem styleItem = this.allRuns[n3];
            styleItemArray[n12++] = styleItem;
            n9 += styleItem.width;
            n5 = Math.max(n5, styleItem.ascent);
            n4 = Math.max(n4, styleItem.descent);
            if (styleItem.lineBreak || n3 == this.allRuns.length - 1) {
                if (n12 == 1 && n3 == this.allRuns.length - 1) {
                    TEXTMETRIC tEXTMETRIC = OS.IsUnicode ? new TEXTMETRICW() : new TEXTMETRICA();
                    OS.SelectObject(n7, this.getItemFont(styleItem));
                    OS.GetTextMetrics(n7, tEXTMETRIC);
                    styleItem.ascent = tEXTMETRIC.tmAscent;
                    styleItem.descent = tEXTMETRIC.tmDescent;
                    n5 = Math.max(n5, styleItem.ascent);
                    n4 = Math.max(n4, styleItem.descent);
                }
                this.runs[n17] = new StyleItem[n12];
                System.arraycopy(styleItemArray, 0, this.runs[n17], 0, n12);
                if (this.justify && this.wrapWidth != -1 && styleItem.softBreak && n9 > 0) {
                    if (n17 == 0) {
                        n9 += this.indent;
                    } else {
                        StyleItem[] styleItemArray2 = this.runs[n17 - 1];
                        StyleItem styleItem4 = styleItemArray2[styleItemArray2.length - 1];
                        if (styleItem4.lineBreak && !styleItem4.softBreak) {
                            n9 += this.indent;
                        }
                    }
                    int n18 = OS.GetProcessHeap();
                    n2 = 0;
                    int n19 = 0;
                    while (n19 < this.runs[n17].length) {
                        StyleItem styleItem5 = this.runs[n17][n19];
                        int n20 = styleItem5.width * this.wrapWidth / n9;
                        if (n20 != styleItem5.width) {
                            styleItem5.justify = OS.HeapAlloc(n18, 8, styleItem5.glyphCount * 4);
                            if (styleItem5.justify == 0) {
                                SWT.error(2);
                            }
                            OS.ScriptJustify(styleItem5.visAttrs, styleItem5.advances, styleItem5.glyphCount, n20 - styleItem5.width, 2, styleItem5.justify);
                            styleItem5.width = n20;
                        }
                        n2 += styleItem5.width;
                        ++n19;
                    }
                    n9 = n2;
                }
                this.lineWidth[n17] = n9;
                StyleItem styleItem6 = this.runs[n17][n12 - 1];
                n2 = styleItem6.start + styleItem6.length;
                this.runs[n17] = this.reorder(this.runs[n17], n3 == this.allRuns.length - 1);
                styleItem6 = this.runs[n17][n12 - 1];
                if (styleItem.softBreak && styleItem != styleItem6) {
                    styleItem.lineBreak = false;
                    styleItem.softBreak = false;
                    styleItem6.lineBreak = true;
                    styleItem6.softBreak = true;
                }
                n9 = this.getLineIndent(n17);
                int n21 = 0;
                while (n21 < this.runs[n17].length) {
                    this.runs[n17][n21].x = n9;
                    n9 += this.runs[n17][n21].width;
                    ++n21;
                }
                this.lineY[++n17] = this.lineY[n17 - 1] + n5 + n4 + this.lineSpacing;
                this.lineOffset[n17] = n2;
                n9 = 0;
                n12 = 0;
                n5 = Math.max(0, this.ascent);
                n4 = Math.max(0, this.descent);
            }
            ++n3;
        }
        if (n7 != 0) {
            OS.DeleteDC(n7);
        }
        if (gC == null) {
            this.device.internal_dispose_GC(n6, null);
        }
    }

    public void dispose() {
        if (this.device == null) {
            return;
        }
        this.freeRuns();
        this.font = null;
        this.text = null;
        this.segmentsText = null;
        this.tabs = null;
        this.styles = null;
        this.runs = null;
        this.lineOffset = null;
        this.lineY = null;
        this.lineWidth = null;
        if (this.mLangFontLink2 != 0) {
            OS.VtblCall(2, this.mLangFontLink2);
            this.mLangFontLink2 = 0;
        }
        OS.OleUninitialize();
        if (this.device.tracking) {
            this.device.dispose_Object(this);
        }
        this.device = null;
    }

    public void draw(GC gC, int n2, int n3) {
        this.draw(gC, n2, n3, -1, -1, null, null);
    }

    public void draw(GC gC, int n2, int n3, int n4, int n5, Color color, Color color2) {
        this.draw(gC, n2, n3, n4, n5, color, color2, 0);
    }

    public void draw(GC gC, int n2, int n3, int n4, int n5, Color color, Color color2, int n6) {
        int n7;
        int n8;
        int n9;
        int n10;
        int n11;
        int n12;
        int n13;
        int n14;
        this.checkLayout();
        this.computeRuns(gC);
        if (gC == null) {
            SWT.error(4);
        }
        if (gC.isDisposed()) {
            SWT.error(5);
        }
        if (color != null && color.isDisposed()) {
            SWT.error(5);
        }
        if (color2 != null && color2.isDisposed()) {
            SWT.error(5);
        }
        if ((n14 = this.text.length()) == 0 && n6 == 0) {
            return;
        }
        int n15 = gC.handle;
        Rectangle rectangle = gC.getClipping();
        GCData gCData = gC.data;
        int n16 = gCData.gdipGraphics;
        int n17 = gCData.foreground;
        int n18 = gCData.alpha;
        boolean bl2 = n16 != 0 && (n18 != 255 || gCData.foregroundPattern != null);
        int n19 = 0;
        float[] fArray = null;
        Rect rect = new Rect();
        if (n16 != 0 && !bl2) {
            n13 = Gdip.Matrix_new(1.0f, 0.0f, 0.0f, 1.0f, 0.0f, 0.0f);
            if (n13 == 0) {
                SWT.error(2);
            }
            Gdip.Graphics_GetTransform(n16, n13);
            n12 = gC.identity();
            Gdip.Matrix_Invert(n12);
            Gdip.Matrix_Multiply(n13, n12, 1);
            Gdip.Matrix_delete(n12);
            if (!Gdip.Matrix_IsIdentity(n13)) {
                fArray = new float[6];
                Gdip.Matrix_GetElements(n13, fArray);
            }
            Gdip.Matrix_delete(n13);
            if ((gCData.style & 0x8000000) != 0 && fArray != null) {
                bl2 = true;
                fArray = null;
            } else {
                Gdip.Graphics_SetPixelOffsetMode(n16, 3);
                n11 = Gdip.Region_new();
                Gdip.Graphics_GetClip(n16, n11);
                if (!Gdip.Region_IsInfinite(n11, n16)) {
                    n19 = Gdip.Region_GetHRGN(n11, n16);
                }
                Gdip.Region_delete(n11);
                Gdip.Graphics_SetPixelOffsetMode(n16, 4);
                n15 = Gdip.Graphics_GetHDC(n16);
            }
        }
        n13 = 0;
        n12 = 0;
        if (bl2) {
            gC.checkGC(1);
            n13 = gC.getFgBrush();
        } else {
            n12 = OS.SaveDC(n15);
            if ((gCData.style & 0x8000000) != 0) {
                OS.SetLayout(n15, OS.GetLayout(n15) | 1);
            }
            if (fArray != null) {
                OS.SetGraphicsMode(n15, 2);
                OS.SetWorldTransform(n15, fArray);
            }
            if (n19 != 0) {
                OS.SelectClipRgn(n15, n19);
                OS.DeleteObject(n19);
            }
        }
        int n20 = n11 = n4 <= n5 && n4 != -1 && n5 != -1 ? 1 : 0;
        if (n11 != 0 || (n6 & 0x100000) != 0) {
            n4 = Math.min(Math.max(0, n4), n14 - 1);
            n5 = Math.min(Math.max(0, n5), n14 - 1);
            if (color == null) {
                color = this.device.getSystemColor(27);
            }
            if (color2 == null) {
                color2 = this.device.getSystemColor(26);
            }
            n4 = this.translateOffset(n4);
            n5 = this.translateOffset(n5);
        }
        RECT rECT = new RECT();
        int n21 = 0;
        int n22 = 0;
        int n23 = 0;
        if (n11 != 0 || (n6 & 0x100000) != 0) {
            if (bl2) {
                n10 = color2.handle;
                n9 = (n18 & 0xFF) << 24 | n10 >> 16 & 0xFF | n10 & 0xFF00 | (n10 & 0xFF) << 16;
                n8 = Gdip.Color_new(n9);
                n21 = Gdip.SolidBrush_new(n8);
                Gdip.Color_delete(n8);
                n7 = color.handle;
                n9 = (n18 & 0xFF) << 24 | n7 >> 16 & 0xFF | n7 & 0xFF00 | (n7 & 0xFF) << 16;
                n8 = Gdip.Color_new(n9);
                n23 = Gdip.SolidBrush_new(n8);
                n22 = Gdip.Pen_new(n23, 1.0f);
                Gdip.Color_delete(n8);
            } else {
                n21 = OS.CreateSolidBrush(color2.handle);
                n22 = OS.CreatePen(0, 1, color.handle);
            }
        }
        n10 = (this.orientation & 0x4000000) != 0 ? -1 : 0;
        OS.SetBkMode(n15, 1);
        n9 = 0;
        while (n9 < this.runs.length) {
            int n24;
            int n25;
            n8 = n2 + this.getLineIndent(n9);
            n7 = n3 + this.lineY[n9];
            StyleItem[] styleItemArray = this.runs[n9];
            int n26 = this.lineY[n9 + 1] - this.lineY[n9];
            if (n6 != 0 && (n11 != 0 || (n6 & 0x100000) != 0)) {
                n25 = 0;
                if (n9 == this.runs.length - 1 && (n6 & 0x100000) != 0) {
                    n25 = 1;
                } else {
                    StyleItem styleItem = styleItemArray[styleItemArray.length - 1];
                    if (styleItem.lineBreak && !styleItem.softBreak) {
                        if (n4 <= styleItem.start && styleItem.start <= n5) {
                            n25 = 1;
                        }
                    } else {
                        n24 = styleItem.start + styleItem.length - 1;
                        if (n4 <= n24 && n24 < n5 && (n6 & 0x10000) != 0) {
                            n25 = 1;
                        }
                    }
                }
                if (n25 != 0) {
                    int n27 = (n6 & 0x10000) != 0 ? (OS.IsWin95 ? Short.MAX_VALUE : 0x6FFFFFF) : (n26 - this.lineSpacing) / 3;
                    if (bl2) {
                        Gdip.Graphics_FillRectangle(n16, n21, n8 + this.lineWidth[n9], n7, n27, n26 - this.lineSpacing);
                    } else {
                        OS.SelectObject(n15, n21);
                        OS.PatBlt(n15, n8 + this.lineWidth[n9], n7, n27, n26 - this.lineSpacing, 15728673);
                    }
                }
            }
            if (n8 <= rectangle.x + rectangle.width && n8 + this.lineWidth[n9] >= rectangle.x) {
                int n28;
                int n29;
                int n30;
                int n31;
                boolean bl3;
                int n32;
                StyleItem styleItem;
                n25 = Math.max(0, this.ascent);
                int n33 = 0;
                while (n33 < styleItemArray.length) {
                    n25 = Math.max(n25, styleItemArray[n33].ascent);
                    ++n33;
                }
                n33 = n8;
                n24 = 0;
                while (n24 < styleItemArray.length) {
                    styleItem = styleItemArray[n24];
                    if (styleItem.length != 0) {
                        if (n8 > rectangle.x + rectangle.width) break;
                        if (n8 + styleItem.width >= rectangle.x && (!styleItem.lineBreak || styleItem.softBreak)) {
                            n32 = styleItem.start + styleItem.length - 1;
                            boolean bl4 = bl3 = n11 != 0 && n4 <= styleItem.start && n5 >= n32;
                            if (bl3) {
                                if (bl2) {
                                    Gdip.Graphics_FillRectangle(n16, n21, n8, n7, styleItem.width, n26 - this.lineSpacing);
                                } else {
                                    OS.SelectObject(n15, n21);
                                    OS.PatBlt(n15, n8, n7, styleItem.width, n26 - this.lineSpacing, 15728673);
                                }
                            } else {
                                int n34;
                                int n35;
                                if (styleItem.style != null && styleItem.style.background != null) {
                                    n31 = styleItem.style.background.handle;
                                    n30 = n7 + (n25 - styleItem.ascent);
                                    if (bl2) {
                                        n29 = (n18 & 0xFF) << 24 | n31 >> 16 & 0xFF | n31 & 0xFF00 | (n31 & 0xFF) << 16;
                                        n35 = Gdip.Color_new(n29);
                                        n34 = Gdip.SolidBrush_new(n35);
                                        Gdip.Graphics_FillRectangle(n16, n34, n8, n30, styleItem.width, styleItem.ascent + styleItem.descent);
                                        Gdip.Color_delete(n35);
                                        Gdip.SolidBrush_delete(n34);
                                    } else {
                                        n29 = OS.CreateSolidBrush(n31);
                                        n35 = OS.SelectObject(n15, n29);
                                        OS.PatBlt(n15, n8, n30, styleItem.width, styleItem.ascent + styleItem.descent, 15728673);
                                        OS.SelectObject(n15, n35);
                                        OS.DeleteObject(n29);
                                    }
                                }
                                int n36 = n31 = n11 != 0 && n4 <= n32 && styleItem.start <= n5 ? 1 : 0;
                                if (n31 != 0) {
                                    n30 = Math.max(n4, styleItem.start) - styleItem.start;
                                    n29 = Math.min(n5, n32) - styleItem.start;
                                    n35 = styleItem.length;
                                    n34 = styleItem.glyphCount;
                                    int[] nArray = new int[1];
                                    int n37 = styleItem.justify != 0 ? styleItem.justify : styleItem.advances;
                                    OS.ScriptCPtoX(n30, false, n35, n34, styleItem.clusters, styleItem.visAttrs, n37, styleItem.analysis, nArray);
                                    n28 = (this.orientation & 0x4000000) != 0 ? styleItem.width - nArray[0] : nArray[0];
                                    rECT.left = n8 + n28;
                                    rECT.top = n7;
                                    OS.ScriptCPtoX(n29, true, n35, n34, styleItem.clusters, styleItem.visAttrs, n37, styleItem.analysis, nArray);
                                    n28 = (this.orientation & 0x4000000) != 0 ? styleItem.width - nArray[0] : nArray[0];
                                    rECT.right = n8 + n28;
                                    rECT.bottom = n7 + n26 - this.lineSpacing;
                                    if (bl2) {
                                        Gdip.Graphics_FillRectangle(n16, n21, rECT.left, rECT.top, rECT.right - rECT.left, rECT.bottom - rECT.top);
                                    } else {
                                        OS.SelectObject(n15, n21);
                                        OS.PatBlt(n15, rECT.left, rECT.top, rECT.right - rECT.left, rECT.bottom - rECT.top, 15728673);
                                    }
                                }
                            }
                        }
                        n8 += styleItem.width;
                    }
                    ++n24;
                }
                n8 = n33;
                n24 = 0;
                while (n24 < styleItemArray.length) {
                    styleItem = styleItemArray[n24];
                    if (styleItem.length != 0) {
                        if (n8 > rectangle.x + rectangle.width) break;
                        if (!(n8 + styleItem.width < rectangle.x || styleItem.tab || styleItem.lineBreak && !styleItem.softBreak || styleItem.style != null && styleItem.style.metrics != null)) {
                            int n38;
                            n32 = styleItem.start + styleItem.length - 1;
                            bl3 = n11 != 0 && n4 <= styleItem.start && n5 >= n32;
                            n31 = n11 != 0 && !bl3 && n4 <= n32 && styleItem.start <= n5 ? 1 : 0;
                            this.checkItem(n15, styleItem);
                            OS.SelectObject(n15, this.getItemFont(styleItem));
                            n30 = n7 + (n25 - styleItem.ascent);
                            if (n31 != 0) {
                                n29 = Math.max(n4, styleItem.start) - styleItem.start;
                                int n39 = Math.min(n5, n32) - styleItem.start;
                                int n40 = styleItem.length;
                                int n41 = styleItem.glyphCount;
                                int[] nArray = new int[1];
                                n28 = styleItem.justify != 0 ? styleItem.justify : styleItem.advances;
                                OS.ScriptCPtoX(n29, false, n40, n41, styleItem.clusters, styleItem.visAttrs, n28, styleItem.analysis, nArray);
                                n38 = (this.orientation & 0x4000000) != 0 ? styleItem.width - nArray[0] : nArray[0];
                                rECT.left = n8 + n38;
                                rECT.top = n7;
                                OS.ScriptCPtoX(n39, true, n40, n41, styleItem.clusters, styleItem.visAttrs, n28, styleItem.analysis, nArray);
                                n38 = (this.orientation & 0x4000000) != 0 ? styleItem.width - nArray[0] : nArray[0];
                                rECT.right = n8 + n38;
                                rECT.bottom = n7 + n26;
                            }
                            if (bl2) {
                                int n42;
                                int n43;
                                OS.BeginPath(n15);
                                OS.ScriptTextOut(n15, styleItem.psc, n8, n30, 0, null, styleItem.analysis, 0, 0, styleItem.glyphs, styleItem.glyphCount, styleItem.advances, styleItem.justify, styleItem.goffsets);
                                OS.EndPath(n15);
                                n29 = OS.GetPath(n15, null, null, 0);
                                int[] nArray = new int[n29 * 2];
                                byte[] byArray = new byte[n29];
                                OS.GetPath(n15, nArray, byArray, n29);
                                int n44 = 0;
                                while (n44 < byArray.length) {
                                    int n45 = 0;
                                    n28 = byArray[n44] & 0xFF;
                                    switch (n28 & 0xFFFFFFFE) {
                                        case 6: {
                                            n45 = 0;
                                            break;
                                        }
                                        case 2: {
                                            n45 = 1;
                                            break;
                                        }
                                        case 4: {
                                            n45 = 3;
                                        }
                                    }
                                    if ((n28 & 1) != 0) {
                                        n45 |= 0x80;
                                    }
                                    byArray[n44] = (byte)n45;
                                    ++n44;
                                }
                                n44 = Gdip.GraphicsPath_new(nArray, byArray, n29, 0);
                                if (n44 == 0) {
                                    SWT.error(2);
                                }
                                int n46 = n13;
                                if (bl3) {
                                    n46 = n23;
                                } else if (styleItem.style != null && styleItem.style.foreground != null) {
                                    n28 = styleItem.style.foreground.handle;
                                    n38 = (n18 & 0xFF) << 24 | n28 >> 16 & 0xFF | n28 & 0xFF00 | (n28 & 0xFF) << 16;
                                    n43 = Gdip.Color_new(n38);
                                    n46 = Gdip.SolidBrush_new(n43);
                                    Gdip.Color_delete(n43);
                                }
                                n28 = 0;
                                if (n31 != 0) {
                                    rect.X = rECT.left;
                                    rect.Y = rECT.top;
                                    rect.Width = rECT.right - rECT.left;
                                    rect.Height = rECT.bottom - rECT.top;
                                    n28 = Gdip.Graphics_Save(n16);
                                    Gdip.Graphics_SetClip(n16, rect, 4);
                                }
                                n38 = Gdip.Graphics_GetSmoothingMode(n16);
                                n43 = 0;
                                int n47 = Gdip.Graphics_GetTextRenderingHint(gCData.gdipGraphics);
                                switch (n47) {
                                    case 0: {
                                        n43 = 4;
                                        break;
                                    }
                                    case 1: 
                                    case 2: {
                                        n43 = 3;
                                        break;
                                    }
                                    case 3: 
                                    case 4: 
                                    case 5: {
                                        n43 = 4;
                                    }
                                }
                                Gdip.Graphics_SetSmoothingMode(n16, n43);
                                int n48 = 0;
                                if ((gCData.style & 0x8000000) != 0) {
                                    n48 = Gdip.Graphics_Save(n16);
                                    Gdip.Graphics_ScaleTransform(n16, -1.0f, 1.0f, 0);
                                    Gdip.Graphics_TranslateTransform(n16, -2 * n8 - styleItem.width, 0.0f, 0);
                                }
                                Gdip.Graphics_FillPath(n16, n46, n44);
                                if ((gCData.style & 0x8000000) != 0) {
                                    Gdip.Graphics_Restore(n16, n48);
                                }
                                Gdip.Graphics_SetSmoothingMode(n16, n38);
                                if (styleItem.style != null && (styleItem.style.underline || styleItem.style.strikeout)) {
                                    int n49;
                                    n42 = n11 != 0 ? n22 : Gdip.Pen_new(n46, 1.0f);
                                    Gdip.Graphics_SetPixelOffsetMode(n16, 3);
                                    if (styleItem.style.underline) {
                                        n49 = n7 + n25 + 1 - styleItem.style.rise;
                                        Gdip.Graphics_DrawLine(n16, n42, n8, n49, n8 + styleItem.width, n49);
                                    }
                                    if (styleItem.style.strikeout) {
                                        n49 = n30 + styleItem.leading + (styleItem.ascent - styleItem.style.rise) / 2;
                                        Gdip.Graphics_DrawLine(n16, n42, n8, n49, n8 + styleItem.width, n49);
                                    }
                                    if (n42 != n22) {
                                        Gdip.Pen_delete(n42);
                                    }
                                    Gdip.Graphics_SetPixelOffsetMode(n16, 4);
                                }
                                if (n31 != 0) {
                                    Gdip.Graphics_Restore(n16, n28);
                                    n28 = Gdip.Graphics_Save(n16);
                                    Gdip.Graphics_SetClip(n16, rect, 1);
                                    Gdip.Graphics_SetSmoothingMode(n16, n43);
                                    Gdip.Graphics_FillPath(n16, n23, n44);
                                    Gdip.Graphics_SetSmoothingMode(n16, n38);
                                    if (styleItem.style != null && (styleItem.style.underline || styleItem.style.strikeout)) {
                                        Gdip.Graphics_SetPixelOffsetMode(n16, 3);
                                        if (styleItem.style.underline) {
                                            n42 = n7 + n25 + 1 - styleItem.style.rise;
                                            Gdip.Graphics_DrawLine(n16, n22, rECT.left, n42, rECT.right, n42);
                                        }
                                        if (styleItem.style.strikeout) {
                                            n42 = n30 + styleItem.leading + (styleItem.ascent - styleItem.style.rise) / 2;
                                            Gdip.Graphics_DrawLine(n16, n22, rECT.left, n42, rECT.right, n42);
                                        }
                                        Gdip.Graphics_SetPixelOffsetMode(n16, 4);
                                    }
                                    Gdip.Graphics_Restore(n16, n28);
                                }
                                Gdip.GraphicsPath_delete(n44);
                                if (n46 != n23 && n46 != n13) {
                                    Gdip.SolidBrush_delete(n46);
                                }
                            } else {
                                n29 = n17;
                                if (bl3) {
                                    n29 = color.handle;
                                } else if (styleItem.style != null && styleItem.style.foreground != null) {
                                    n29 = styleItem.style.foreground.handle;
                                }
                                OS.SetTextColor(n15, n29);
                                OS.ScriptTextOut(n15, styleItem.psc, n8 + n10, n30, 0, null, styleItem.analysis, 0, 0, styleItem.glyphs, styleItem.glyphCount, styleItem.advances, styleItem.justify, styleItem.goffsets);
                                if (styleItem.style != null && (styleItem.style.underline || styleItem.style.strikeout)) {
                                    int n50 = n11 != 0 && n29 == color.handle ? n22 : OS.CreatePen(0, 1, n29);
                                    int n51 = OS.SelectObject(n15, n50);
                                    if (styleItem.style.underline) {
                                        int n52 = n7 + n25 + 1 - styleItem.style.rise;
                                        OS.MoveToEx(n15, n8, n52, 0);
                                        OS.LineTo(n15, n8 + styleItem.width, n52);
                                    }
                                    if (styleItem.style.strikeout) {
                                        int n53 = n30 + styleItem.leading + (styleItem.ascent - styleItem.style.rise) / 2;
                                        OS.MoveToEx(n15, n8, n53, 0);
                                        OS.LineTo(n15, n8 + styleItem.width, n53);
                                    }
                                    OS.SelectObject(n15, n51);
                                    if (n11 == 0 || n29 != color.handle) {
                                        OS.DeleteObject(n50);
                                    }
                                }
                                if (n31 != 0 && n29 != color.handle) {
                                    OS.SetTextColor(n15, color.handle);
                                    OS.ScriptTextOut(n15, styleItem.psc, n8 + n10, n30, 4, rECT, styleItem.analysis, 0, 0, styleItem.glyphs, styleItem.glyphCount, styleItem.advances, styleItem.justify, styleItem.goffsets);
                                    if (styleItem.style != null && (styleItem.style.underline || styleItem.style.strikeout)) {
                                        int n54 = OS.SelectObject(n15, n22);
                                        if (styleItem.style.underline) {
                                            int n55 = n7 + n25 + 1 - styleItem.style.rise;
                                            OS.MoveToEx(n15, rECT.left, n55, 0);
                                            OS.LineTo(n15, rECT.right, n55);
                                        }
                                        if (styleItem.style.strikeout) {
                                            int n56 = n30 + styleItem.leading + (styleItem.ascent - styleItem.style.rise) / 2;
                                            OS.MoveToEx(n15, rECT.left, n56, 0);
                                            OS.LineTo(n15, rECT.right, n56);
                                        }
                                        OS.SelectObject(n15, n54);
                                    }
                                }
                            }
                        }
                        n8 += styleItem.width;
                    }
                    ++n24;
                }
            }
            ++n9;
        }
        if (bl2) {
            if (n21 != 0) {
                Gdip.SolidBrush_delete(n21);
            }
            if (n23 != 0) {
                Gdip.SolidBrush_delete(n23);
            }
            if (n22 != 0) {
                Gdip.Pen_delete(n22);
            }
        } else {
            OS.RestoreDC(n15, n12);
            if (n16 != 0) {
                Gdip.Graphics_ReleaseHDC(n16, n15);
            }
            if (n21 != 0) {
                OS.DeleteObject(n21);
            }
            if (n22 != 0) {
                OS.DeleteObject(n22);
            }
        }
    }

    void freeRuns() {
        if (this.allRuns == null) {
            return;
        }
        int n2 = 0;
        while (n2 < this.allRuns.length) {
            StyleItem styleItem = this.allRuns[n2];
            styleItem.free();
            ++n2;
        }
        this.allRuns = null;
        this.runs = null;
        this.segmentsText = null;
    }

    public int getAlignment() {
        this.checkLayout();
        return this.alignment;
    }

    public int getAscent() {
        this.checkLayout();
        return this.ascent;
    }

    public Rectangle getBounds() {
        this.checkLayout();
        this.computeRuns(null);
        int n2 = 0;
        if (this.wrapWidth != -1) {
            n2 = this.wrapWidth;
        } else {
            int n3 = 0;
            while (n3 < this.runs.length) {
                n2 = Math.max(n2, this.lineWidth[n3] + this.getLineIndent(n3));
                ++n3;
            }
        }
        return new Rectangle(0, 0, n2, this.lineY[this.lineY.length - 1]);
    }

    public Rectangle getBounds(int n2, int n3) {
        this.checkLayout();
        this.computeRuns(null);
        int n4 = this.text.length();
        if (n4 == 0) {
            return new Rectangle(0, 0, 0, 0);
        }
        if (n2 > n3) {
            return new Rectangle(0, 0, 0, 0);
        }
        n2 = Math.min(Math.max(0, n2), n4 - 1);
        n3 = Math.min(Math.max(0, n3), n4 - 1);
        n2 = this.translateOffset(n2);
        n3 = this.translateOffset(n3);
        int n5 = Integer.MAX_VALUE;
        int n6 = 0;
        int n7 = Integer.MAX_VALUE;
        int n8 = 0;
        boolean bl2 = (this.orientation & 0x4000000) != 0;
        int n9 = 0;
        while (n9 < this.allRuns.length - 1) {
            StyleItem styleItem = this.allRuns[n9];
            int n10 = styleItem.start + styleItem.length;
            if (n10 > n2) {
                int n11;
                Object object;
                int n12;
                if (styleItem.start > n3) break;
                int n13 = styleItem.x;
                int n14 = styleItem.x + styleItem.width;
                if (styleItem.start <= n2 && n2 < n10) {
                    n12 = 0;
                    if (styleItem.style != null && styleItem.style.metrics != null) {
                        object = styleItem.style.metrics;
                        n12 = object.width * (n2 - styleItem.start);
                    } else if (!styleItem.tab) {
                        object = new int[1];
                        n11 = styleItem.justify != 0 ? styleItem.justify : styleItem.advances;
                        OS.ScriptCPtoX(n2 - styleItem.start, false, styleItem.length, styleItem.glyphCount, styleItem.clusters, styleItem.visAttrs, n11, styleItem.analysis, object);
                        int n15 = n12 = bl2 ? styleItem.width - object[0] : object[0];
                    }
                    if (styleItem.analysis.fRTL ^ bl2) {
                        n14 = styleItem.x + n12;
                    } else {
                        n13 = styleItem.x + n12;
                    }
                }
                if (styleItem.start <= n3 && n3 < n10) {
                    n12 = styleItem.width;
                    if (styleItem.style != null && styleItem.style.metrics != null) {
                        object = styleItem.style.metrics;
                        n12 = object.width * (n3 - styleItem.start + 1);
                    } else if (!styleItem.tab) {
                        object = new int[1];
                        n11 = styleItem.justify != 0 ? styleItem.justify : styleItem.advances;
                        OS.ScriptCPtoX(n3 - styleItem.start, true, styleItem.length, styleItem.glyphCount, styleItem.clusters, styleItem.visAttrs, n11, styleItem.analysis, object);
                        int n16 = n12 = bl2 ? styleItem.width - object[0] : object[0];
                    }
                    if (styleItem.analysis.fRTL ^ bl2) {
                        n13 = styleItem.x + n12;
                    } else {
                        n14 = styleItem.x + n12;
                    }
                }
                n12 = 0;
                while (n12 < this.runs.length && this.lineOffset[n12 + 1] <= styleItem.start) {
                    ++n12;
                }
                n5 = Math.min(n5, n13);
                n6 = Math.max(n6, n14);
                n7 = Math.min(n7, this.lineY[n12]);
                n8 = Math.max(n8, this.lineY[n12 + 1] - this.lineSpacing);
            }
            ++n9;
        }
        return new Rectangle(n5, n7, n6 - n5, n8 - n7);
    }

    public int getDescent() {
        this.checkLayout();
        return this.descent;
    }

    public Font getFont() {
        this.checkLayout();
        return this.font;
    }

    public int getIndent() {
        this.checkLayout();
        return this.indent;
    }

    public boolean getJustify() {
        this.checkLayout();
        return this.justify;
    }

    int getItemFont(StyleItem styleItem) {
        if (styleItem.fallbackFont != 0) {
            return styleItem.fallbackFont;
        }
        if (styleItem.style != null && styleItem.style.font != null) {
            return styleItem.style.font.handle;
        }
        if (this.font != null) {
            return this.font.handle;
        }
        return this.device.systemFont;
    }

    public int getLevel(int n2) {
        this.checkLayout();
        this.computeRuns(null);
        int n3 = this.text.length();
        if (n2 < 0 || n2 > n3) {
            SWT.error(6);
        }
        n2 = this.translateOffset(n2);
        int n4 = 1;
        while (n4 < this.allRuns.length) {
            if (this.allRuns[n4].start > n2) {
                return this.allRuns[n4 - 1].analysis.s.uBidiLevel;
            }
            ++n4;
        }
        return (this.orientation & 0x4000000) != 0 ? 1 : 0;
    }

    public Rectangle getLineBounds(int n2) {
        this.checkLayout();
        this.computeRuns(null);
        if (n2 < 0 || n2 >= this.runs.length) {
            SWT.error(6);
        }
        int n3 = this.getLineIndent(n2);
        int n4 = this.lineY[n2];
        int n5 = this.lineWidth[n2];
        int n6 = this.lineY[n2 + 1] - n4 - this.lineSpacing;
        return new Rectangle(n3, n4, n5, n6);
    }

    public int getLineCount() {
        this.checkLayout();
        this.computeRuns(null);
        return this.runs.length;
    }

    int getLineIndent(int n2) {
        StyleItem[] styleItemArray;
        int n3 = 0;
        if (n2 == 0) {
            n3 = this.indent;
        } else {
            StyleItem[] styleItemArray2 = this.runs[n2 - 1];
            styleItemArray = styleItemArray2[styleItemArray2.length - 1];
            if (styleItemArray.lineBreak && !styleItemArray.softBreak) {
                n3 = this.indent;
            }
        }
        if (this.wrapWidth != -1) {
            boolean bl2 = true;
            if (this.justify) {
                styleItemArray = this.runs[n2];
                if (styleItemArray[styleItemArray.length - 1].softBreak) {
                    bl2 = false;
                }
            }
            if (bl2) {
                int n4 = this.lineWidth[n2] + n3;
                switch (this.alignment) {
                    case 0x1000000: {
                        n3 += (this.wrapWidth - n4) / 2;
                        break;
                    }
                    case 131072: {
                        n3 += this.wrapWidth - n4;
                    }
                }
            }
        }
        return n3;
    }

    public int getLineIndex(int n2) {
        this.checkLayout();
        this.computeRuns(null);
        int n3 = this.text.length();
        if (n2 < 0 || n2 > n3) {
            SWT.error(6);
        }
        n2 = this.translateOffset(n2);
        int n4 = 0;
        while (n4 < this.runs.length) {
            if (this.lineOffset[n4 + 1] > n2) {
                return n4;
            }
            ++n4;
        }
        return this.runs.length - 1;
    }

    public FontMetrics getLineMetrics(int n2) {
        this.checkLayout();
        this.computeRuns(null);
        if (n2 < 0 || n2 >= this.runs.length) {
            SWT.error(6);
        }
        int n3 = this.device.internal_new_GC(null);
        int n4 = OS.CreateCompatibleDC(n3);
        TEXTMETRIC tEXTMETRIC = OS.IsUnicode ? new TEXTMETRICW() : new TEXTMETRICA();
        OS.SelectObject(n4, this.font != null ? this.font.handle : this.device.systemFont);
        OS.GetTextMetrics(n4, tEXTMETRIC);
        OS.DeleteDC(n4);
        this.device.internal_dispose_GC(n3, null);
        int n5 = Math.max(tEXTMETRIC.tmAscent, this.ascent);
        int n6 = Math.max(tEXTMETRIC.tmDescent, this.descent);
        int n7 = tEXTMETRIC.tmInternalLeading;
        if (this.text.length() != 0) {
            StyleItem[] styleItemArray = this.runs[n2];
            int n8 = 0;
            while (n8 < styleItemArray.length) {
                StyleItem styleItem = styleItemArray[n8];
                if (styleItem.ascent > n5) {
                    n5 = styleItem.ascent;
                    n7 = styleItem.leading;
                }
                n6 = Math.max(n6, styleItem.descent);
                ++n8;
            }
        }
        tEXTMETRIC.tmAscent = n5;
        tEXTMETRIC.tmDescent = n6;
        tEXTMETRIC.tmHeight = n5 + n6;
        tEXTMETRIC.tmInternalLeading = n7;
        tEXTMETRIC.tmAveCharWidth = 0;
        return FontMetrics.win32_new(tEXTMETRIC);
    }

    public int[] getLineOffsets() {
        this.checkLayout();
        this.computeRuns(null);
        int[] nArray = new int[this.lineOffset.length];
        int n2 = 0;
        while (n2 < nArray.length) {
            nArray[n2] = this.untranslateOffset(this.lineOffset[n2]);
            ++n2;
        }
        return nArray;
    }

    public Point getLocation(int n2, boolean bl2) {
        this.checkLayout();
        this.computeRuns(null);
        int n3 = this.text.length();
        if (n2 < 0 || n2 > n3) {
            SWT.error(6);
        }
        n3 = this.segmentsText.length();
        n2 = this.translateOffset(n2);
        int n4 = 0;
        while (n4 < this.runs.length) {
            if (this.lineOffset[n4 + 1] > n2) break;
            ++n4;
        }
        n4 = Math.min(n4, this.runs.length - 1);
        StyleItem[] styleItemArray = this.runs[n4];
        Point point = null;
        if (n2 == n3) {
            point = new Point(this.lineWidth[n4], this.lineY[n4]);
        } else {
            int n5 = 0;
            int n6 = 0;
            while (n6 < styleItemArray.length) {
                StyleItem styleItem = styleItemArray[n6];
                int n7 = styleItem.start + styleItem.length;
                if (styleItem.start <= n2 && n2 < n7) {
                    if (styleItem.style != null && styleItem.style.metrics != null) {
                        GlyphMetrics glyphMetrics = styleItem.style.metrics;
                        point = new Point(n5 += glyphMetrics.width * (n2 - styleItem.start + (bl2 ? 1 : 0)), this.lineY[n4]);
                        break;
                    }
                    if (styleItem.tab) {
                        if (bl2 || n2 == n3) {
                            n5 += styleItem.width;
                        }
                        point = new Point(n5, this.lineY[n4]);
                        break;
                    }
                    int n8 = n2 - styleItem.start;
                    int n9 = styleItem.length;
                    int n10 = styleItem.glyphCount;
                    int[] nArray = new int[1];
                    int n11 = styleItem.justify != 0 ? styleItem.justify : styleItem.advances;
                    OS.ScriptCPtoX(n8, bl2, n9, n10, styleItem.clusters, styleItem.visAttrs, n11, styleItem.analysis, nArray);
                    if ((this.orientation & 0x4000000) != 0) {
                        point = new Point(n5 + (styleItem.width - nArray[0]), this.lineY[n4]);
                        break;
                    }
                    point = new Point(n5 + nArray[0], this.lineY[n4]);
                    break;
                }
                n5 += styleItem.width;
                ++n6;
            }
        }
        if (point == null) {
            point = new Point(0, 0);
        }
        point.x += this.getLineIndent(n4);
        return point;
    }

    public int getNextOffset(int n2, int n3) {
        this.checkLayout();
        return this._getOffset(n2, n3, true);
    }

    int _getOffset(int n2, int n3, boolean bl2) {
        int n4;
        this.computeRuns(null);
        int n5 = this.text.length();
        if (n2 < 0 || n2 > n5) {
            SWT.error(6);
        }
        if (bl2 && n2 == n5) {
            return n5;
        }
        if (!bl2 && n2 == 0) {
            return 0;
        }
        int n6 = n4 = bl2 ? 1 : -1;
        if ((n3 & 1) != 0) {
            return n2 + n4;
        }
        n5 = this.segmentsText.length();
        n2 = this.translateOffset(n2);
        SCRIPT_LOGATTR sCRIPT_LOGATTR = new SCRIPT_LOGATTR();
        SCRIPT_PROPERTIES sCRIPT_PROPERTIES = new SCRIPT_PROPERTIES();
        int n7 = bl2 ? 0 : this.allRuns.length - 1;
        n2 = this.validadeOffset(n2, n4);
        do {
            boolean bl3;
            StyleItem styleItem = this.allRuns[n7];
            if (styleItem.start > n2 || n2 >= styleItem.start + styleItem.length) continue;
            if (styleItem.lineBreak && !styleItem.softBreak) {
                return this.untranslateOffset(styleItem.start);
            }
            if (styleItem.tab) {
                return this.untranslateOffset(styleItem.start);
            }
            OS.MoveMemory(sCRIPT_PROPERTIES, this.device.scripts[styleItem.analysis.eScript], SCRIPT_PROPERTIES.sizeof);
            boolean bl4 = bl3 = sCRIPT_PROPERTIES.fNeedsCaretInfo || sCRIPT_PROPERTIES.fNeedsWordBreaking;
            if (bl3) {
                this.breakRun(styleItem);
            }
            while (styleItem.start <= n2 && n2 < styleItem.start + styleItem.length) {
                if (bl3) {
                    OS.MoveMemory(sCRIPT_LOGATTR, styleItem.psla + (n2 - styleItem.start) * SCRIPT_LOGATTR.sizeof, SCRIPT_LOGATTR.sizeof);
                }
                switch (n3) {
                    case 2: {
                        if (sCRIPT_PROPERTIES.fNeedsCaretInfo) {
                            if (sCRIPT_LOGATTR.fInvalid || !sCRIPT_LOGATTR.fCharStop) break;
                            return this.untranslateOffset(n2);
                        }
                        return this.untranslateOffset(n2);
                    }
                    case 4: 
                    case 16: {
                        boolean bl5;
                        boolean bl6;
                        if (!(sCRIPT_PROPERTIES.fNeedsWordBreaking ? !sCRIPT_LOGATTR.fInvalid && sCRIPT_LOGATTR.fWordStop : n2 > 0 && ((bl6 = Compatibility.isLetterOrDigit(this.segmentsText.charAt(n2))) != (bl5 = Compatibility.isLetterOrDigit(this.segmentsText.charAt(n2 - 1))) || !bl6) && !Compatibility.isWhitespace(this.segmentsText.charAt(n2)))) break;
                        return this.untranslateOffset(n2);
                    }
                    case 8: {
                        if (n2 <= 0) break;
                        boolean bl6 = Compatibility.isLetterOrDigit(this.segmentsText.charAt(n2));
                        boolean bl5 = Compatibility.isLetterOrDigit(this.segmentsText.charAt(n2 - 1));
                        if (bl6 || !bl5) break;
                        return this.untranslateOffset(n2);
                    }
                }
                n2 = this.validadeOffset(n2, n4);
            }
        } while ((n7 += n4) >= 0 && n7 < this.allRuns.length - 1 && n2 >= 0 && n2 < n5);
        return bl2 ? this.text.length() : 0;
    }

    public int getOffset(Point point, int[] nArray) {
        this.checkLayout();
        if (point == null) {
            SWT.error(4);
        }
        return this.getOffset(point.x, point.y, nArray);
    }

    public int getOffset(int n2, int n3, int[] nArray) {
        this.checkLayout();
        this.computeRuns(null);
        if (nArray != null && nArray.length < 1) {
            SWT.error(5);
        }
        int n4 = this.runs.length;
        int n5 = 0;
        while (n5 < n4) {
            if (this.lineY[n5 + 1] > n3) break;
            ++n5;
        }
        n5 = Math.min(n5, this.runs.length - 1);
        StyleItem[] styleItemArray = this.runs[n5];
        if ((n2 -= this.getLineIndent(n5)) >= this.lineWidth[n5]) {
            n2 = this.lineWidth[n5] - 1;
        }
        if (n2 < 0) {
            n2 = 0;
        }
        int n6 = 0;
        int n7 = 0;
        while (n7 < styleItemArray.length) {
            StyleItem styleItem = styleItemArray[n7];
            if (styleItem.lineBreak && !styleItem.softBreak) {
                return this.untranslateOffset(styleItem.start);
            }
            if (n6 + styleItem.width > n2) {
                int n8 = n2 - n6;
                if (styleItem.style != null && styleItem.style.metrics != null) {
                    GlyphMetrics glyphMetrics = styleItem.style.metrics;
                    if (glyphMetrics.width > 0) {
                        if (nArray != null) {
                            nArray[0] = n8 % glyphMetrics.width < glyphMetrics.width / 2 ? 0 : 1;
                        }
                        return this.untranslateOffset(styleItem.start + n8 / glyphMetrics.width);
                    }
                }
                if (styleItem.tab) {
                    if (nArray != null) {
                        nArray[0] = n2 < n6 + styleItem.width / 2 ? 0 : 1;
                    }
                    return this.untranslateOffset(styleItem.start);
                }
                int n9 = styleItem.length;
                int n10 = styleItem.glyphCount;
                int[] nArray2 = new int[1];
                int[] nArray3 = new int[1];
                if ((this.orientation & 0x4000000) != 0) {
                    n8 = styleItem.width - n8;
                }
                int n11 = styleItem.justify != 0 ? styleItem.justify : styleItem.advances;
                OS.ScriptXtoCP(n8, n9, n10, styleItem.clusters, styleItem.visAttrs, n11, styleItem.analysis, nArray2, nArray3);
                if (nArray != null) {
                    nArray[0] = nArray3[0];
                }
                return this.untranslateOffset(styleItem.start + nArray2[0]);
            }
            n6 += styleItem.width;
            ++n7;
        }
        if (nArray != null) {
            nArray[0] = 0;
        }
        return this.untranslateOffset(this.lineOffset[n5 + 1]);
    }

    public int getOrientation() {
        this.checkLayout();
        return this.orientation;
    }

    public int getPreviousOffset(int n2, int n3) {
        this.checkLayout();
        return this._getOffset(n2, n3, false);
    }

    public int[] getRanges() {
        this.checkLayout();
        int[] nArray = new int[this.styles.length * 2];
        int n2 = 0;
        int n3 = 0;
        while (n3 < this.styles.length - 1) {
            if (this.styles[n3].style != null) {
                nArray[n2++] = this.styles[n3].start;
                nArray[n2++] = this.styles[n3 + 1].start - 1;
            }
            ++n3;
        }
        if (n2 != nArray.length) {
            int[] nArray2 = new int[n2];
            System.arraycopy(nArray, 0, nArray2, 0, n2);
            nArray = nArray2;
        }
        return nArray;
    }

    public int[] getSegments() {
        this.checkLayout();
        return this.segments;
    }

    String getSegmentsText() {
        if (this.segments == null) {
            return this.text;
        }
        int n2 = this.segments.length;
        if (n2 <= 1) {
            return this.text;
        }
        int n3 = this.text.length();
        if (n3 == 0) {
            return this.text;
        }
        if (n2 == 2 && this.segments[0] == 0 && this.segments[1] == n3) {
            return this.text;
        }
        char[] cArray = new char[n3];
        this.text.getChars(0, n3, cArray, 0);
        char[] cArray2 = new char[n3 + n2];
        int n4 = 0;
        int n5 = 0;
        int n6 = this.orientation == 0x4000000 ? 8207 : 8206;
        while (n4 < n3) {
            if (n5 < n2 && n4 == this.segments[n5]) {
                cArray2[n4 + n5++] = n6;
                continue;
            }
            cArray2[n4 + n5] = cArray[n4++];
        }
        if (n5 < n2) {
            this.segments[n5] = n4;
            cArray2[n4 + n5++] = n6;
        }
        return new String(cArray2, 0, Math.min(n4 + n5, cArray2.length));
    }

    public int getSpacing() {
        this.checkLayout();
        return this.lineSpacing;
    }

    public TextStyle getStyle(int n2) {
        this.checkLayout();
        int n3 = this.text.length();
        if (n2 < 0 || n2 >= n3) {
            SWT.error(6);
        }
        int n4 = 1;
        while (n4 < this.styles.length) {
            if (this.styles[n4].start > n2) {
                return this.styles[n4 - 1].style;
            }
            ++n4;
        }
        return null;
    }

    public TextStyle[] getStyles() {
        this.checkLayout();
        TextStyle[] textStyleArray = new TextStyle[this.styles.length];
        int n2 = 0;
        int n3 = 0;
        while (n3 < this.styles.length) {
            if (this.styles[n3].style != null) {
                textStyleArray[n2++] = this.styles[n3].style;
            }
            ++n3;
        }
        if (n2 != textStyleArray.length) {
            TextStyle[] textStyleArray2 = new TextStyle[n2];
            System.arraycopy(textStyleArray, 0, textStyleArray2, 0, n2);
            textStyleArray = textStyleArray2;
        }
        return textStyleArray;
    }

    public int[] getTabs() {
        this.checkLayout();
        return this.tabs;
    }

    public String getText() {
        this.checkLayout();
        return this.text;
    }

    public int getWidth() {
        this.checkLayout();
        return this.wrapWidth;
    }

    public boolean isDisposed() {
        return this.device == null;
    }

    StyleItem[] itemize() {
        int n2;
        int n3;
        this.segmentsText = this.getSegmentsText();
        int n4 = this.segmentsText.length();
        SCRIPT_CONTROL sCRIPT_CONTROL = new SCRIPT_CONTROL();
        SCRIPT_STATE sCRIPT_STATE = new SCRIPT_STATE();
        int n5 = n4 + 1;
        if ((this.orientation & 0x4000000) != 0) {
            sCRIPT_STATE.uBidiLevel = 1;
            sCRIPT_STATE.fArabicNumContext = true;
            SCRIPT_DIGITSUBSTITUTE sCRIPT_DIGITSUBSTITUTE = new SCRIPT_DIGITSUBSTITUTE();
            OS.ScriptRecordDigitSubstitution(1024, sCRIPT_DIGITSUBSTITUTE);
            OS.ScriptApplyDigitSubstitution(sCRIPT_DIGITSUBSTITUTE, sCRIPT_CONTROL, sCRIPT_STATE);
        }
        if ((n3 = OS.HeapAlloc(n2 = OS.GetProcessHeap(), 8, n5 * SCRIPT_ITEM.sizeof)) == 0) {
            SWT.error(2);
        }
        int[] nArray = new int[1];
        char[] cArray = new char[n4];
        this.segmentsText.getChars(0, n4, cArray, 0);
        OS.ScriptItemize(cArray, n4, n5, sCRIPT_CONTROL, sCRIPT_STATE, n3, nArray);
        StyleItem[] styleItemArray = this.merge(n3, nArray[0]);
        OS.HeapFree(n2, 0, n3);
        return styleItemArray;
    }

    StyleItem[] merge(int n2, int n3) {
        StyleItem styleItem;
        int n4 = 0;
        int n5 = 0;
        int n6 = this.segmentsText.length();
        int n7 = 0;
        int n8 = 0;
        StyleItem[] styleItemArray = new StyleItem[n3 + this.styles.length];
        SCRIPT_ITEM sCRIPT_ITEM = new SCRIPT_ITEM();
        boolean bl2 = false;
        while (n5 < n6) {
            styleItem = new StyleItem();
            styleItem.start = n5;
            styleItem.style = this.styles[n8].style;
            styleItemArray[n4++] = styleItem;
            OS.MoveMemory(sCRIPT_ITEM, n2 + n7 * SCRIPT_ITEM.sizeof, SCRIPT_ITEM.sizeof);
            styleItem.analysis = sCRIPT_ITEM.a;
            if (bl2) {
                styleItem.analysis.fLinkBefore = true;
                bl2 = false;
            }
            sCRIPT_ITEM.a = new SCRIPT_ANALYSIS();
            OS.MoveMemory(sCRIPT_ITEM, n2 + (n7 + 1) * SCRIPT_ITEM.sizeof, SCRIPT_ITEM.sizeof);
            int n9 = sCRIPT_ITEM.iCharPos;
            int n10 = this.translateOffset(this.styles[n8 + 1].start);
            if (n10 <= n9) {
                ++n8;
                n5 = n10;
                if (n5 < n9 && n5 > 0 && n5 < n6) {
                    char c2 = this.segmentsText.charAt(n5 - 1);
                    char c3 = this.segmentsText.charAt(n5);
                    if (!Compatibility.isWhitespace(c2) && !Compatibility.isWhitespace(c3)) {
                        styleItem.analysis.fLinkAfter = true;
                        bl2 = true;
                    }
                }
            }
            if (n9 <= n10) {
                ++n7;
                n5 = n9;
            }
            styleItem.length = n5 - styleItem.start;
        }
        styleItem = new StyleItem();
        styleItem.start = n6;
        OS.MoveMemory(sCRIPT_ITEM, n2 + n3 * SCRIPT_ITEM.sizeof, SCRIPT_ITEM.sizeof);
        styleItem.analysis = sCRIPT_ITEM.a;
        styleItemArray[n4++] = styleItem;
        if (styleItemArray.length != n4) {
            StyleItem[] styleItemArray2 = new StyleItem[n4];
            System.arraycopy(styleItemArray, 0, styleItemArray2, 0, n4);
            return styleItemArray2;
        }
        return styleItemArray;
    }

    StyleItem[] reorder(StyleItem[] styleItemArray, boolean bl2) {
        int n2 = styleItemArray.length;
        if (n2 <= 1) {
            return styleItemArray;
        }
        byte[] byArray = new byte[n2];
        int n3 = 0;
        while (n3 < n2) {
            byArray[n3] = (byte)(styleItemArray[n3].analysis.s.uBidiLevel & 0x1F);
            ++n3;
        }
        StyleItem styleItem = styleItemArray[n2 - 1];
        if (styleItem.lineBreak && !styleItem.softBreak) {
            byArray[n2 - 1] = 0;
        }
        int[] nArray = new int[n2];
        OS.ScriptLayout(n2, byArray, null, nArray);
        StyleItem[] styleItemArray2 = new StyleItem[n2];
        int n4 = 0;
        while (n4 < n2) {
            styleItemArray2[nArray[n4]] = styleItemArray[n4];
            ++n4;
        }
        if ((this.orientation & 0x4000000) != 0) {
            if (bl2) {
                --n2;
            }
            n4 = 0;
            while (n4 < n2 / 2) {
                StyleItem styleItem2 = styleItemArray2[n4];
                styleItemArray2[n4] = styleItemArray2[n2 - n4 - 1];
                styleItemArray2[n2 - n4 - 1] = styleItem2;
                ++n4;
            }
        }
        return styleItemArray2;
    }

    public void setAlignment(int n2) {
        this.checkLayout();
        int n3 = 16924672;
        if ((n2 &= n3) == 0) {
            return;
        }
        if ((n2 & 0x4000) != 0) {
            n2 = 16384;
        }
        if ((n2 & 0x20000) != 0) {
            n2 = 131072;
        }
        if (this.alignment == n2) {
            return;
        }
        this.freeRuns();
        this.alignment = n2;
    }

    public void setAscent(int n2) {
        this.checkLayout();
        if (n2 < -1) {
            SWT.error(5);
        }
        if (this.ascent == n2) {
            return;
        }
        this.freeRuns();
        this.ascent = n2;
    }

    public void setDescent(int n2) {
        this.checkLayout();
        if (n2 < -1) {
            SWT.error(5);
        }
        if (this.descent == n2) {
            return;
        }
        this.freeRuns();
        this.descent = n2;
    }

    public void setFont(Font font) {
        this.checkLayout();
        if (font != null && font.isDisposed()) {
            SWT.error(5);
        }
        if (this.font == font) {
            return;
        }
        if (font != null && font.equals(this.font)) {
            return;
        }
        this.freeRuns();
        this.font = font;
    }

    public void setIndent(int n2) {
        this.checkLayout();
        if (n2 < 0) {
            return;
        }
        if (this.indent == n2) {
            return;
        }
        this.freeRuns();
        this.indent = n2;
    }

    public void setJustify(boolean bl2) {
        this.checkLayout();
        if (this.justify == bl2) {
            return;
        }
        this.freeRuns();
        this.justify = bl2;
    }

    public void setOrientation(int n2) {
        this.checkLayout();
        int n3 = 0x6000000;
        if ((n2 &= n3) == 0) {
            return;
        }
        if ((n2 & 0x2000000) != 0) {
            n2 = 0x2000000;
        }
        if (this.orientation == n2) {
            return;
        }
        this.orientation = n2;
        this.freeRuns();
    }

    public void setSegments(int[] nArray) {
        this.checkLayout();
        if (this.segments == null && nArray == null) {
            return;
        }
        if (this.segments != null && nArray != null && this.segments.length == nArray.length) {
            int n2 = 0;
            while (n2 < nArray.length) {
                if (this.segments[n2] != nArray[n2]) break;
                ++n2;
            }
            if (n2 == nArray.length) {
                return;
            }
        }
        this.freeRuns();
        this.segments = nArray;
    }

    public void setSpacing(int n2) {
        this.checkLayout();
        if (n2 < 0) {
            SWT.error(5);
        }
        if (this.lineSpacing == n2) {
            return;
        }
        this.freeRuns();
        this.lineSpacing = n2;
    }

    public void setStyle(TextStyle textStyle, int n2, int n3) {
        int n4;
        int n5;
        this.checkLayout();
        int n6 = this.text.length();
        if (n6 == 0) {
            return;
        }
        if (n2 > n3) {
            return;
        }
        n2 = Math.min(Math.max(0, n2), n6 - 1);
        n3 = Math.min(Math.max(0, n3), n6 - 1);
        int n7 = -1;
        int n8 = this.styles.length;
        while (n8 - n7 > 1) {
            n5 = (n8 + n7) / 2;
            if (this.styles[n5 + 1].start > n2) {
                n8 = n5;
                continue;
            }
            n7 = n5;
        }
        if (n8 >= 0 && n8 < this.styles.length) {
            StyleItem styleItem = this.styles[n8];
            if (styleItem.start == n2 && this.styles[n8 + 1].start - 1 == n3 && (textStyle == null ? styleItem.style == null : textStyle.equals(styleItem.style))) {
                return;
            }
        }
        this.freeRuns();
        int n9 = n5 = n8;
        while (n9 < this.styles.length) {
            if (this.styles[n9 + 1].start > n3) break;
            ++n9;
        }
        if (n5 == n9) {
            n4 = this.styles[n5].start;
            int n10 = this.styles[n9 + 1].start - 1;
            if (n4 == n2 && n10 == n3) {
                this.styles[n5].style = textStyle;
                return;
            }
            if (n4 != n2 && n10 != n3) {
                StyleItem[] styleItemArray = new StyleItem[this.styles.length + 2];
                System.arraycopy(this.styles, 0, styleItemArray, 0, n5 + 1);
                StyleItem styleItem = new StyleItem();
                styleItem.start = n2;
                styleItem.style = textStyle;
                styleItemArray[n5 + 1] = styleItem;
                styleItem = new StyleItem();
                styleItem.start = n3 + 1;
                styleItem.style = this.styles[n5].style;
                styleItemArray[n5 + 2] = styleItem;
                System.arraycopy(this.styles, n9 + 1, styleItemArray, n9 + 3, this.styles.length - n9 - 1);
                this.styles = styleItemArray;
                return;
            }
        }
        if (n2 == this.styles[n5].start) {
            --n5;
        }
        if (n3 == this.styles[n9 + 1].start - 1) {
            ++n9;
        }
        n4 = this.styles.length + 1 - (n9 - n5 - 1);
        StyleItem[] styleItemArray = new StyleItem[n4];
        System.arraycopy(this.styles, 0, styleItemArray, 0, n5 + 1);
        StyleItem styleItem = new StyleItem();
        styleItem.start = n2;
        styleItem.style = textStyle;
        styleItemArray[n5 + 1] = styleItem;
        this.styles[n9].start = n3 + 1;
        System.arraycopy(this.styles, n9, styleItemArray, n5 + 2, this.styles.length - n9);
        this.styles = styleItemArray;
    }

    public void setTabs(int[] nArray) {
        this.checkLayout();
        if (this.tabs == null && nArray == null) {
            return;
        }
        if (this.tabs != null && nArray != null && this.tabs.length == nArray.length) {
            int n2 = 0;
            while (n2 < nArray.length) {
                if (this.tabs[n2] != nArray[n2]) break;
                ++n2;
            }
            if (n2 == nArray.length) {
                return;
            }
        }
        this.freeRuns();
        this.tabs = nArray;
    }

    public void setText(String string) {
        this.checkLayout();
        if (string == null) {
            SWT.error(4);
        }
        if (string.equals(this.text)) {
            return;
        }
        this.freeRuns();
        this.text = string;
        this.styles = new StyleItem[2];
        this.styles[0] = new StyleItem();
        this.styles[1] = new StyleItem();
        this.styles[1].start = string.length();
    }

    public void setWidth(int n2) {
        this.checkLayout();
        if (n2 < -1 || n2 == 0) {
            SWT.error(5);
        }
        if (this.wrapWidth == n2) {
            return;
        }
        this.freeRuns();
        this.wrapWidth = n2;
    }

    boolean shape(int n2, StyleItem styleItem, char[] cArray, int[] nArray, int n3) {
        int n4 = OS.ScriptShape(n2, styleItem.psc, cArray, cArray.length, n3, styleItem.analysis, styleItem.glyphs, styleItem.clusters, styleItem.visAttrs, nArray);
        styleItem.glyphCount = nArray[0];
        if (n4 != -2147220992) {
            SCRIPT_FONTPROPERTIES sCRIPT_FONTPROPERTIES = new SCRIPT_FONTPROPERTIES();
            sCRIPT_FONTPROPERTIES.cBytes = SCRIPT_FONTPROPERTIES.sizeof;
            OS.ScriptGetFontProperties(n2, styleItem.psc, sCRIPT_FONTPROPERTIES);
            short[] sArray = new short[nArray[0]];
            OS.MoveMemory(sArray, styleItem.glyphs, sArray.length * 2);
            int n5 = 0;
            while (n5 < sArray.length) {
                if (sArray[n5] == sCRIPT_FONTPROPERTIES.wgDefault) break;
                ++n5;
            }
            if (n5 == sArray.length) {
                return true;
            }
        }
        if (styleItem.psc != 0) {
            OS.ScriptFreeCache(styleItem.psc);
            nArray[0] = 0;
            OS.MoveMemory(styleItem.psc, nArray, 4);
        }
        styleItem.glyphCount = 0;
        return false;
    }

    void shape(int n2, StyleItem styleItem) {
        Object object;
        int[] nArray;
        int[] nArray2 = new int[1];
        char[] cArray = new char[styleItem.length];
        this.segmentsText.getChars(styleItem.start, styleItem.start + styleItem.length, cArray, 0);
        int n3 = cArray.length * 3 / 2 + 16;
        int n4 = OS.GetProcessHeap();
        styleItem.glyphs = OS.HeapAlloc(n4, 8, n3 * 2);
        if (styleItem.glyphs == 0) {
            SWT.error(2);
        }
        styleItem.clusters = OS.HeapAlloc(n4, 8, n3 * 2);
        if (styleItem.clusters == 0) {
            SWT.error(2);
        }
        styleItem.visAttrs = OS.HeapAlloc(n4, 8, n3 * 2);
        if (styleItem.visAttrs == 0) {
            SWT.error(2);
        }
        styleItem.psc = OS.HeapAlloc(n4, 8, 4);
        if (styleItem.psc == 0) {
            SWT.error(2);
        }
        if (!this.shape(n2, styleItem, cArray, nArray2, n3) && this.mLangFontLink2 != 0) {
            nArray = new int[1];
            object = new int[1];
            OS.VtblCall(4, this.mLangFontLink2, cArray, cArray.length, 0, nArray, object);
            int[] nArray3 = new int[1];
            if (OS.VtblCall(10, this.mLangFontLink2, n2, nArray[0], (int)cArray[0], nArray3) == 0) {
                int n5 = OS.SelectObject(n2, nArray3[0]);
                if (this.shape(n2, styleItem, cArray, nArray2, n3)) {
                    styleItem.fallbackFont = nArray3[0];
                } else {
                    OS.VtblCall(8, this.mLangFontLink2, nArray3[0]);
                    OS.SelectObject(n2, n5);
                    SCRIPT_PROPERTIES sCRIPT_PROPERTIES = new SCRIPT_PROPERTIES();
                    OS.MoveMemory(sCRIPT_PROPERTIES, this.device.scripts[styleItem.analysis.eScript], SCRIPT_PROPERTIES.sizeof);
                    if (sCRIPT_PROPERTIES.fPrivateUseArea) {
                        styleItem.analysis.fNoGlyphIndex = true;
                    }
                    OS.ScriptShape(n2, styleItem.psc, cArray, cArray.length, n3, styleItem.analysis, styleItem.glyphs, styleItem.clusters, styleItem.visAttrs, nArray2);
                    styleItem.glyphCount = nArray2[0];
                }
            }
        }
        nArray = new int[3];
        styleItem.advances = OS.HeapAlloc(n4, 8, styleItem.glyphCount * 4);
        if (styleItem.advances == 0) {
            SWT.error(2);
        }
        styleItem.goffsets = OS.HeapAlloc(n4, 8, styleItem.glyphCount * 8);
        if (styleItem.goffsets == 0) {
            SWT.error(2);
        }
        OS.ScriptPlace(n2, styleItem.psc, styleItem.glyphs, styleItem.glyphCount, styleItem.visAttrs, styleItem.analysis, styleItem.advances, styleItem.goffsets, nArray);
        if (styleItem.style != null && styleItem.style.metrics != null) {
            object = styleItem.style.metrics;
            styleItem.width = object.width * Math.max(1, styleItem.glyphCount);
            styleItem.ascent = object.ascent;
            styleItem.descent = object.descent;
            styleItem.leading = 0;
        } else {
            styleItem.width = nArray[0] + nArray[1] + nArray[2];
            object = OS.IsUnicode ? new TEXTMETRICW() : new TEXTMETRICA();
            OS.GetTextMetrics(n2, (TEXTMETRIC)object);
            styleItem.ascent = object.tmAscent;
            styleItem.descent = object.tmDescent;
            styleItem.leading = object.tmInternalLeading;
        }
        if (styleItem.style != null) {
            styleItem.ascent += styleItem.style.rise;
            styleItem.descent -= styleItem.style.rise;
        }
    }

    int validadeOffset(int n2, int n3) {
        n2 += n3;
        if (this.segments != null && this.segments.length > 2) {
            int n4 = 0;
            while (n4 < this.segments.length) {
                if (this.translateOffset(this.segments[n4]) - 1 == n2) {
                    n2 += n3;
                    break;
                }
                ++n4;
            }
        }
        return n2;
    }

    public String toString() {
        if (this.isDisposed()) {
            return "TextLayout {*DISPOSED*}";
        }
        return "TextLayout {}";
    }

    int translateOffset(int n2) {
        if (this.segments == null) {
            return n2;
        }
        int n3 = this.segments.length;
        if (n3 <= 1) {
            return n2;
        }
        int n4 = this.text.length();
        if (n4 == 0) {
            return n2;
        }
        if (n3 == 2 && this.segments[0] == 0 && this.segments[1] == n4) {
            return n2;
        }
        int n5 = 0;
        while (n5 < n3 && n2 - n5 >= this.segments[n5]) {
            ++n2;
            ++n5;
        }
        return n2;
    }

    int untranslateOffset(int n2) {
        if (this.segments == null) {
            return n2;
        }
        int n3 = this.segments.length;
        if (n3 <= 1) {
            return n2;
        }
        int n4 = this.text.length();
        if (n4 == 0) {
            return n2;
        }
        if (n3 == 2 && this.segments[0] == 0 && this.segments[1] == n4) {
            return n2;
        }
        int n5 = 0;
        while (n5 < n3 && n2 > this.segments[n5]) {
            --n2;
            ++n5;
        }
        return n2;
    }

    class StyleItem {
        TextStyle style;
        int start;
        int length;
        boolean lineBreak;
        boolean softBreak;
        boolean tab;
        SCRIPT_ANALYSIS analysis;
        int psc = 0;
        int glyphs;
        int glyphCount;
        int clusters;
        int visAttrs;
        int advances;
        int goffsets;
        int width;
        int ascent;
        int descent;
        int leading;
        int x;
        int justify;
        int psla;
        int fallbackFont;

        StyleItem() {
        }

        void free() {
            int n2 = OS.GetProcessHeap();
            if (this.psc != 0) {
                OS.ScriptFreeCache(this.psc);
                OS.HeapFree(n2, 0, this.psc);
                this.psc = 0;
            }
            if (this.glyphs != 0) {
                OS.HeapFree(n2, 0, this.glyphs);
                this.glyphs = 0;
                this.glyphCount = 0;
            }
            if (this.clusters != 0) {
                OS.HeapFree(n2, 0, this.clusters);
                this.clusters = 0;
            }
            if (this.visAttrs != 0) {
                OS.HeapFree(n2, 0, this.visAttrs);
                this.visAttrs = 0;
            }
            if (this.advances != 0) {
                OS.HeapFree(n2, 0, this.advances);
                this.advances = 0;
            }
            if (this.goffsets != 0) {
                OS.HeapFree(n2, 0, this.goffsets);
                this.goffsets = 0;
            }
            if (this.justify != 0) {
                OS.HeapFree(n2, 0, this.justify);
                this.justify = 0;
            }
            if (this.psla != 0) {
                OS.HeapFree(n2, 0, this.psla);
                this.psla = 0;
            }
            if (this.fallbackFont != 0) {
                if (TextLayout.this.mLangFontLink2 != 0) {
                    OS.VtblCall(8, TextLayout.this.mLangFontLink2, this.fallbackFont);
                }
                this.fallbackFont = 0;
            }
            this.x = 0;
            this.descent = 0;
            this.ascent = 0;
            this.width = 0;
            this.softBreak = false;
            this.lineBreak = false;
        }

        public String toString() {
            return "StyleItem {" + this.start + ", " + this.style + "}";
        }
    }
}

