/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.swt.internal.image;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import org.eclipse.swt.SWT;
import org.eclipse.swt.graphics.ImageData;
import org.eclipse.swt.graphics.ImageLoader;
import org.eclipse.swt.graphics.PaletteData;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.RGB;
import org.eclipse.swt.internal.image.FileFormat;
import org.eclipse.swt.internal.image.LEDataInputStream;

final class WinBMPFileFormat
extends FileFormat {
    static final int BMPFileHeaderSize = 14;
    static final int BMPHeaderFixedSize = 40;
    int importantColors;
    Point pelsPerMeter = new Point(0, 0);

    WinBMPFileFormat() {
    }

    int compress(int n2, byte[] byArray, int n3, int n4, byte[] byArray2, boolean bl2) {
        if (n2 == 1) {
            return this.compressRLE8Data(byArray, n3, n4, byArray2, bl2);
        }
        if (n2 == 2) {
            return this.compressRLE4Data(byArray, n3, n4, byArray2, bl2);
        }
        SWT.error(40);
        return 0;
    }

    int compressRLE4Data(byte[] byArray, int n2, int n3, byte[] byArray2, boolean bl2) {
        int n4 = n2;
        int n5 = n2 + n3;
        int n6 = 0;
        int n7 = 0;
        while (n4 < n5) {
            int n8 = n5 - n4 - 1;
            if (n8 > 127) {
                n8 = 127;
            }
            int n9 = 0;
            while (n9 < n8) {
                if (byArray[n4 + n9] == byArray[n4 + n9 + 1]) break;
                ++n9;
            }
            if (n9 < 127 && n9 == n8) {
                ++n9;
            }
            switch (n9) {
                case 0: {
                    break;
                }
                case 1: {
                    byArray2[n6] = 2;
                    byArray2[++n6] = byArray[n4];
                    ++n6;
                    ++n4;
                    n7 += 2;
                    break;
                }
                default: {
                    byArray2[n6] = 0;
                    byArray2[++n6] = (byte)(n9 + n9);
                    ++n6;
                    int n10 = n9;
                    while (n10 > 0) {
                        byArray2[n6] = byArray[n4];
                        ++n6;
                        ++n4;
                        --n10;
                    }
                    n7 += 2 + n9;
                    if ((n9 & 1) == 0) break;
                    byArray2[n6] = 0;
                    ++n6;
                    ++n7;
                }
            }
            n8 = n5 - n4;
            if (n8 <= 0) continue;
            if (n8 > 127) {
                n8 = 127;
            }
            byte by2 = byArray[n4];
            n9 = 1;
            while (n9 < n8) {
                if (byArray[n4 + n9] != by2) break;
                ++n9;
            }
            byArray2[n6] = (byte)(n9 + n9);
            byArray2[++n6] = by2;
            ++n6;
            n4 += n9;
            n7 += 2;
        }
        byArray2[n6] = 0;
        ++n6;
        if (bl2) {
            byArray2[n6] = 1;
            ++n6;
        } else {
            byArray2[n6] = 0;
            ++n6;
        }
        return n7 += 2;
    }

    int compressRLE8Data(byte[] byArray, int n2, int n3, byte[] byArray2, boolean bl2) {
        int n4 = n2;
        int n5 = n2 + n3;
        int n6 = 0;
        int n7 = 0;
        while (n4 < n5) {
            int n8 = n5 - n4 - 1;
            if (n8 > 254) {
                n8 = 254;
            }
            int n9 = 0;
            while (n9 < n8) {
                if (byArray[n4 + n9] == byArray[n4 + n9 + 1]) break;
                ++n9;
            }
            if (n9 == n8) {
                ++n9;
            }
            switch (n9) {
                case 0: {
                    break;
                }
                case 2: {
                    byArray2[n6] = 1;
                    byArray2[++n6] = byArray[n4];
                    ++n6;
                    ++n4;
                    n7 += 2;
                }
                case 1: {
                    byArray2[n6] = 1;
                    byArray2[++n6] = byArray[n4];
                    ++n6;
                    ++n4;
                    n7 += 2;
                    break;
                }
                default: {
                    byArray2[n6] = 0;
                    byArray2[++n6] = (byte)n9;
                    ++n6;
                    int n10 = n9;
                    while (n10 > 0) {
                        byArray2[n6] = byArray[n4];
                        ++n6;
                        ++n4;
                        --n10;
                    }
                    n7 += 2 + n9;
                    if ((n9 & 1) == 0) break;
                    byArray2[n6] = 0;
                    ++n6;
                    ++n7;
                }
            }
            n8 = n5 - n4;
            if (n8 <= 0) continue;
            if (n8 > 255) {
                n8 = 255;
            }
            byte by2 = byArray[n4];
            n9 = 1;
            while (n9 < n8) {
                if (byArray[n4 + n9] != by2) break;
                ++n9;
            }
            byArray2[n6] = (byte)n9;
            byArray2[++n6] = by2;
            ++n6;
            n4 += n9;
            n7 += 2;
        }
        byArray2[n6] = 0;
        ++n6;
        if (bl2) {
            byArray2[n6] = 1;
            ++n6;
        } else {
            byArray2[n6] = 0;
            ++n6;
        }
        return n7 += 2;
    }

    void decompressData(byte[] byArray, byte[] byArray2, int n2, int n3) {
        if (n3 == 1) {
            if (this.decompressRLE8Data(byArray, byArray.length, n2, byArray2, byArray2.length) <= 0) {
                SWT.error(40);
            }
            return;
        }
        if (n3 == 2) {
            if (this.decompressRLE4Data(byArray, byArray.length, n2, byArray2, byArray2.length) <= 0) {
                SWT.error(40);
            }
            return;
        }
        SWT.error(40);
    }

    int decompressRLE4Data(byte[] byArray, int n2, int n3, byte[] byArray2, int n4) {
        int n5 = 0;
        int n6 = n2;
        int n7 = 0;
        int n8 = n4;
        int n9 = 0;
        int n10 = 0;
        block5: while (n5 < n6) {
            int n11;
            int n12 = byArray[n5] & 0xFF;
            ++n5;
            if (n12 == 0) {
                n12 = byArray[n5] & 0xFF;
                ++n5;
                switch (n12) {
                    case 0: {
                        n9 = 0;
                        n7 = ++n10 * n3;
                        if (n7 <= n8) continue block5;
                        return -1;
                    }
                    case 1: {
                        return 1;
                    }
                    case 2: {
                        n9 += byArray[n5] & 0xFF;
                        n10 += byArray[++n5] & 0xFF;
                        ++n5;
                        n7 = n10 * n3 + n9 / 2;
                        if (n7 <= n8) continue block5;
                        return -1;
                    }
                    default: {
                        if ((n12 & 1) != 0) {
                            return -1;
                        }
                        n9 += n12;
                        if ((n12 /= 2) > n6 - n5) {
                            return -1;
                        }
                        if (n12 > n8 - n7) {
                            return -1;
                        }
                        n11 = 0;
                        while (n11 < n12) {
                            byArray2[n7] = byArray[n5];
                            ++n7;
                            ++n5;
                            ++n11;
                        }
                        if ((n5 & 1) == 0) continue block5;
                        ++n5;
                        break;
                    }
                }
                continue;
            }
            if ((n12 & 1) != 0) {
                return -1;
            }
            n9 += n12;
            n11 = byArray[n5];
            ++n5;
            if ((n12 /= 2) > n8 - n7) {
                return -1;
            }
            int n13 = 0;
            while (n13 < n12) {
                byArray2[n7] = n11;
                ++n7;
                ++n13;
            }
        }
        return 1;
    }

    int decompressRLE8Data(byte[] byArray, int n2, int n3, byte[] byArray2, int n4) {
        int n5 = 0;
        int n6 = n2;
        int n7 = 0;
        int n8 = n4;
        int n9 = 0;
        int n10 = 0;
        block5: while (n5 < n6) {
            int n11;
            int n12 = byArray[n5] & 0xFF;
            ++n5;
            if (n12 == 0) {
                n12 = byArray[n5] & 0xFF;
                ++n5;
                switch (n12) {
                    case 0: {
                        n9 = 0;
                        n7 = ++n10 * n3;
                        if (n7 <= n8) continue block5;
                        return -1;
                    }
                    case 1: {
                        return 1;
                    }
                    case 2: {
                        n9 += byArray[n5] & 0xFF;
                        n10 += byArray[++n5] & 0xFF;
                        ++n5;
                        n7 = n10 * n3 + n9;
                        if (n7 <= n8) continue block5;
                        return -1;
                    }
                    default: {
                        if (n12 > n6 - n5) {
                            return -1;
                        }
                        if (n12 > n8 - n7) {
                            return -1;
                        }
                        n11 = 0;
                        while (n11 < n12) {
                            byArray2[n7] = byArray[n5];
                            ++n7;
                            ++n5;
                            ++n11;
                        }
                        if ((n5 & 1) != 0) {
                            ++n5;
                        }
                        n9 += n12;
                        break;
                    }
                }
                continue;
            }
            n11 = byArray[n5];
            ++n5;
            if (n12 > n8 - n7) {
                return -1;
            }
            int n13 = 0;
            while (n13 < n12) {
                byArray2[n7] = n11;
                ++n7;
                ++n13;
            }
            n9 += n12;
        }
        return 1;
    }

    boolean isFileFormat(LEDataInputStream lEDataInputStream) {
        try {
            byte[] byArray = new byte[18];
            lEDataInputStream.read(byArray);
            lEDataInputStream.unread(byArray);
            int n2 = byArray[14] & 0xFF | (byArray[15] & 0xFF) << 8 | (byArray[16] & 0xFF) << 16 | (byArray[17] & 0xFF) << 24;
            return byArray[0] == 66 && byArray[1] == 77 && n2 >= 40;
        }
        catch (Exception exception) {
            return false;
        }
    }

    byte[] loadData(byte[] byArray) {
        int n2 = byArray[4] & 0xFF | (byArray[5] & 0xFF) << 8 | (byArray[6] & 0xFF) << 16 | (byArray[7] & 0xFF) << 24;
        int n3 = byArray[8] & 0xFF | (byArray[9] & 0xFF) << 8 | (byArray[10] & 0xFF) << 16 | (byArray[11] & 0xFF) << 24;
        int n4 = byArray[14] & 0xFF | (byArray[15] & 0xFF) << 8;
        int n5 = (n2 * n4 + 7) / 8;
        n5 = (n5 + 3) / 4 * 4;
        byte[] byArray2 = this.loadData(byArray, n5);
        this.flipScanLines(byArray2, n5, n3);
        return byArray2;
    }

    byte[] loadData(byte[] byArray, int n2) {
        int n3 = byArray[8] & 0xFF | (byArray[9] & 0xFF) << 8 | (byArray[10] & 0xFF) << 16 | (byArray[11] & 0xFF) << 24;
        if (n3 < 0) {
            n3 = -n3;
        }
        int n4 = n3 * n2;
        byte[] byArray2 = new byte[n4];
        int n5 = byArray[16] & 0xFF | (byArray[17] & 0xFF) << 8 | (byArray[18] & 0xFF) << 16 | (byArray[19] & 0xFF) << 24;
        if (n5 == 0 || n5 == 3) {
            try {
                if (this.inputStream.read(byArray2) != n4) {
                    SWT.error(40);
                }
            }
            catch (IOException iOException) {
                SWT.error(39, iOException);
            }
        } else {
            int n6 = byArray[20] & 0xFF | (byArray[21] & 0xFF) << 8 | (byArray[22] & 0xFF) << 16 | (byArray[23] & 0xFF) << 24;
            byte[] byArray3 = new byte[n6];
            try {
                if (this.inputStream.read(byArray3) != n6) {
                    SWT.error(40);
                }
            }
            catch (IOException iOException) {
                SWT.error(39, iOException);
            }
            this.decompressData(byArray3, byArray2, n2, n5);
        }
        return byArray2;
    }

    int[] loadFileHeader() {
        int[] nArray = new int[5];
        try {
            nArray[0] = this.inputStream.readShort();
            nArray[1] = this.inputStream.readInt();
            nArray[2] = this.inputStream.readShort();
            nArray[3] = this.inputStream.readShort();
            nArray[4] = this.inputStream.readInt();
        }
        catch (IOException iOException) {
            SWT.error(39, iOException);
        }
        if (nArray[0] != 19778) {
            SWT.error(40);
        }
        return nArray;
    }

    ImageData[] loadFromByteStream() {
        int[] nArray = this.loadFileHeader();
        byte[] byArray = new byte[40];
        try {
            this.inputStream.read(byArray);
        }
        catch (Exception exception) {
            SWT.error(39, exception);
        }
        int n2 = byArray[4] & 0xFF | (byArray[5] & 0xFF) << 8 | (byArray[6] & 0xFF) << 16 | (byArray[7] & 0xFF) << 24;
        int n3 = byArray[8] & 0xFF | (byArray[9] & 0xFF) << 8 | (byArray[10] & 0xFF) << 16 | (byArray[11] & 0xFF) << 24;
        if (n3 < 0) {
            n3 = -n3;
        }
        int n4 = byArray[14] & 0xFF | (byArray[15] & 0xFF) << 8;
        this.compression = byArray[16] & 0xFF | (byArray[17] & 0xFF) << 8 | (byArray[18] & 0xFF) << 16 | (byArray[19] & 0xFF) << 24;
        PaletteData paletteData = this.loadPalette(byArray);
        if (this.inputStream.getPosition() < nArray[4]) {
            try {
                this.inputStream.skip(nArray[4] - this.inputStream.getPosition());
            }
            catch (IOException iOException) {
                SWT.error(39, iOException);
            }
        }
        byte[] byArray2 = this.loadData(byArray);
        this.importantColors = byArray[36] & 0xFF | (byArray[37] & 0xFF) << 8 | (byArray[38] & 0xFF) << 16 | (byArray[39] & 0xFF) << 24;
        int n5 = byArray[24] & 0xFF | (byArray[25] & 0xFF) << 8 | (byArray[26] & 0xFF) << 16 | (byArray[27] & 0xFF) << 24;
        int n6 = byArray[28] & 0xFF | (byArray[29] & 0xFF) << 8 | (byArray[30] & 0xFF) << 16 | (byArray[31] & 0xFF) << 24;
        this.pelsPerMeter = new Point(n5, n6);
        int n7 = this.compression == 1 || this.compression == 2 ? 1 : 0;
        return new ImageData[]{ImageData.internal_new(n2, n3, n4, paletteData, 4, byArray2, 0, null, null, -1, -1, n7, 0, 0, 0, 0)};
    }

    PaletteData loadPalette(byte[] byArray) {
        int n2 = byArray[14] & 0xFF | (byArray[15] & 0xFF) << 8;
        if (n2 <= 8) {
            int n3 = byArray[32] & 0xFF | (byArray[33] & 0xFF) << 8 | (byArray[34] & 0xFF) << 16 | (byArray[35] & 0xFF) << 24;
            if (n3 == 0) {
                n3 = 1 << n2;
            } else if (n3 > 256) {
                n3 = 256;
            }
            byte[] byArray2 = new byte[n3 * 4];
            try {
                if (this.inputStream.read(byArray2) != byArray2.length) {
                    SWT.error(40);
                }
            }
            catch (IOException iOException) {
                SWT.error(39, iOException);
            }
            return this.paletteFromBytes(byArray2, n3);
        }
        if (n2 == 16) {
            if (this.compression == 3) {
                try {
                    return new PaletteData(this.inputStream.readInt(), this.inputStream.readInt(), this.inputStream.readInt());
                }
                catch (IOException iOException) {
                    SWT.error(39, iOException);
                }
            }
            return new PaletteData(31744, 992, 31);
        }
        if (n2 == 24) {
            return new PaletteData(255, 65280, 0xFF0000);
        }
        if (this.compression == 3) {
            try {
                return new PaletteData(this.inputStream.readInt(), this.inputStream.readInt(), this.inputStream.readInt());
            }
            catch (IOException iOException) {
                SWT.error(39, iOException);
            }
        }
        return new PaletteData(65280, 0xFF0000, -16777216);
    }

    PaletteData paletteFromBytes(byte[] byArray, int n2) {
        int n3 = 0;
        RGB[] rGBArray = new RGB[n2];
        int n4 = 0;
        while (n4 < n2) {
            rGBArray[n4] = new RGB(byArray[n3 + 2] & 0xFF, byArray[n3 + 1] & 0xFF, byArray[n3] & 0xFF);
            n3 += 4;
            ++n4;
        }
        return new PaletteData(rGBArray);
    }

    static byte[] paletteToBytes(PaletteData paletteData) {
        int n2 = paletteData.colors == null ? 0 : (paletteData.colors.length < 256 ? paletteData.colors.length : 256);
        byte[] byArray = new byte[n2 * 4];
        int n3 = 0;
        int n4 = 0;
        while (n4 < n2) {
            RGB rGB = paletteData.colors[n4];
            byArray[n3] = (byte)rGB.blue;
            byArray[n3 + 1] = (byte)rGB.green;
            byArray[n3 + 2] = (byte)rGB.red;
            n3 += 4;
            ++n4;
        }
        return byArray;
    }

    int unloadData(ImageData imageData, OutputStream outputStream, int n2) {
        int n3 = 0;
        try {
            if (n2 == 0) {
                return this.unloadDataNoCompression(imageData, outputStream);
            }
            int n4 = (imageData.width * imageData.depth + 7) / 8;
            int n5 = (n4 + 3) / 4 * 4;
            int n6 = imageData.bytesPerLine;
            byte[] byArray = new byte[n5 * 2];
            int n7 = n6 * (imageData.height - 1);
            byte[] byArray2 = imageData.data;
            n3 = 0;
            byte[] byArray3 = new byte[32768];
            int n8 = 0;
            int n9 = imageData.height - 1;
            while (n9 >= 0) {
                int n10 = this.compress(n2, byArray2, n7, n4, byArray, n9 == 0);
                if (n8 + n10 > byArray3.length) {
                    outputStream.write(byArray3, 0, n8);
                    n8 = 0;
                }
                System.arraycopy(byArray, 0, byArray3, n8, n10);
                n8 += n10;
                n3 += n10;
                n7 -= n6;
                --n9;
            }
            if (n8 > 0) {
                outputStream.write(byArray3, 0, n8);
            }
        }
        catch (IOException iOException) {
            SWT.error(39, iOException);
        }
        return n3;
    }

    int unloadDataNoCompression(ImageData imageData, OutputStream outputStream) {
        int n2 = 0;
        try {
            int n3 = (imageData.width * imageData.depth + 7) / 8;
            n2 = (n3 + 3) / 4 * 4;
            int n4 = 32678 / n2;
            byte[] byArray = new byte[n4 * n2];
            byte[] byArray2 = imageData.data;
            int n5 = imageData.bytesPerLine;
            int n6 = n5 * (imageData.height - 1);
            if (imageData.depth == 16) {
                int n7 = 0;
                while (n7 < imageData.height) {
                    int n8 = imageData.height - n7;
                    if (n4 < n8) {
                        n8 = n4;
                    }
                    int n9 = 0;
                    int n10 = 0;
                    while (n10 < n8) {
                        int n11 = 0;
                        while (n11 < n3) {
                            byArray[n9 + n11 + 1] = byArray2[n6 + n11 + 1];
                            byArray[n9 + n11] = byArray2[n6 + n11];
                            n11 += 2;
                        }
                        n9 += n2;
                        n6 -= n5;
                        ++n10;
                    }
                    outputStream.write(byArray, 0, n9);
                    n7 += n4;
                }
            } else {
                int n12 = 0;
                while (n12 < imageData.height) {
                    int n13 = imageData.height - n12;
                    int n14 = n13 < n4 ? n13 : n4;
                    int n15 = 0;
                    int n16 = 0;
                    while (n16 < n14) {
                        System.arraycopy(byArray2, n6, byArray, n15, n3);
                        n15 += n2;
                        n6 -= n5;
                        ++n16;
                    }
                    outputStream.write(byArray, 0, n15);
                    n12 += n4;
                }
            }
        }
        catch (IOException iOException) {
            SWT.error(39, iOException);
        }
        return n2 * imageData.height;
    }

    void unloadIntoByteStream(ImageLoader imageLoader) {
        byte[] byArray;
        int n2;
        int n3;
        ImageData imageData = imageLoader.data[0];
        if (imageData.depth != 1 && imageData.depth != 4 && imageData.depth != 8 && imageData.depth != 16 && imageData.depth != 24 && imageData.depth != 32) {
            SWT.error(38);
        }
        if (!((n3 = this.compression) == 0 || n3 == 1 && imageData.depth == 8 || n3 == 2 && imageData.depth == 4)) {
            SWT.error(40);
        }
        PaletteData paletteData = imageData.palette;
        if (imageData.depth == 16 || imageData.depth == 24 || imageData.depth == 32) {
            if (!paletteData.isDirect) {
                SWT.error(40);
            }
            n2 = 0;
            byArray = null;
        } else {
            if (paletteData.isDirect) {
                SWT.error(40);
            }
            n2 = paletteData.colors.length;
            byArray = WinBMPFileFormat.paletteToBytes(paletteData);
        }
        int n4 = 54;
        int[] nArray = new int[]{19778, 0, 0, 0, n4};
        if (byArray != null) {
            nArray[4] = nArray[4] + byArray.length;
        }
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        this.unloadData(imageData, byteArrayOutputStream, n3);
        byte[] byArray2 = byteArrayOutputStream.toByteArray();
        nArray[1] = nArray[4] + byArray2.length;
        try {
            this.outputStream.writeShort(nArray[0]);
            this.outputStream.writeInt(nArray[1]);
            this.outputStream.writeShort(nArray[2]);
            this.outputStream.writeShort(nArray[3]);
            this.outputStream.writeInt(nArray[4]);
        }
        catch (IOException iOException) {
            SWT.error(39, iOException);
        }
        try {
            this.outputStream.writeInt(40);
            this.outputStream.writeInt(imageData.width);
            this.outputStream.writeInt(imageData.height);
            this.outputStream.writeShort(1);
            this.outputStream.writeShort((short)imageData.depth);
            this.outputStream.writeInt(n3);
            this.outputStream.writeInt(byArray2.length);
            this.outputStream.writeInt(this.pelsPerMeter.x);
            this.outputStream.writeInt(this.pelsPerMeter.y);
            this.outputStream.writeInt(n2);
            this.outputStream.writeInt(this.importantColors);
        }
        catch (IOException iOException) {
            SWT.error(39, iOException);
        }
        if (n2 > 0) {
            try {
                this.outputStream.write(byArray);
            }
            catch (IOException iOException) {
                SWT.error(39, iOException);
            }
        }
        try {
            this.outputStream.write(byArray2);
        }
        catch (IOException iOException) {
            SWT.error(39, iOException);
        }
    }

    void flipScanLines(byte[] byArray, int n2, int n3) {
        int n4 = 0;
        int n5 = (n3 - 1) * n2;
        int n6 = 0;
        while (n6 < n3 / 2) {
            int n7 = 0;
            while (n7 < n2) {
                byte by2 = byArray[n7 + n4];
                byArray[n7 + n4] = byArray[n7 + n5];
                byArray[n7 + n5] = by2;
                ++n7;
            }
            n4 += n2;
            n5 -= n2;
            ++n6;
        }
    }
}

