/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl;

import java.nio.Buffer;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.nio.CharBuffer;
import java.nio.DoubleBuffer;
import java.nio.FloatBuffer;
import java.nio.IntBuffer;
import java.nio.LongBuffer;
import java.nio.ShortBuffer;

public final class BufferUtils {
    public static ByteBuffer createByteBuffer(int n2) {
        return ByteBuffer.allocateDirect(n2).order(ByteOrder.nativeOrder());
    }

    public static ShortBuffer createShortBuffer(int n2) {
        return BufferUtils.createByteBuffer(n2 << 1).asShortBuffer();
    }

    public static CharBuffer createCharBuffer(int n2) {
        return BufferUtils.createByteBuffer(n2 << 1).asCharBuffer();
    }

    public static IntBuffer createIntBuffer(int n2) {
        return BufferUtils.createByteBuffer(n2 << 2).asIntBuffer();
    }

    public static LongBuffer createLongBuffer(int n2) {
        return BufferUtils.createByteBuffer(n2 << 3).asLongBuffer();
    }

    public static FloatBuffer createFloatBuffer(int n2) {
        return BufferUtils.createByteBuffer(n2 << 2).asFloatBuffer();
    }

    public static DoubleBuffer createDoubleBuffer(int n2) {
        return BufferUtils.createByteBuffer(n2 << 3).asDoubleBuffer();
    }

    public static int getElementSizeExponent(Buffer buffer) {
        if (buffer instanceof ByteBuffer) {
            return 0;
        }
        if (buffer instanceof ShortBuffer || buffer instanceof CharBuffer) {
            return 1;
        }
        if (buffer instanceof FloatBuffer || buffer instanceof IntBuffer) {
            return 2;
        }
        if (buffer instanceof LongBuffer || buffer instanceof DoubleBuffer) {
            return 3;
        }
        throw new IllegalStateException("Unsupported buffer type: " + buffer);
    }

    public static int getOffset(Buffer buffer) {
        return buffer.position() << BufferUtils.getElementSizeExponent(buffer);
    }
}

