/*
 * Decompiled with CFR 0.152.
 */
package org.j4me.ui.components;

import javax.microedition.lcdui.Graphics;
import org.j4me.ui.Theme;
import org.j4me.ui.components.Component;

public class HorizontalRule
extends Component {
    private int height = 1;
    private double widthPercentage = 0.9;

    public HorizontalRule() {
        this.setHorizontalAlignment(1);
    }

    public void setWidthOfScreen(double percentageOfScreen) {
        if (percentageOfScreen < 0.0 || percentageOfScreen > 1.0) {
            throw new IllegalArgumentException(String.valueOf(percentageOfScreen));
        }
        this.widthPercentage = percentageOfScreen;
    }

    public double getWidthOfScreen() {
        return this.widthPercentage;
    }

    public void setHeight(int pixels) {
        if (pixels < 1) {
            throw new IllegalArgumentException(String.valueOf(pixels));
        }
        this.height = pixels;
        this.invalidate();
    }

    public int getHeight() {
        return this.height;
    }

    protected void paintComponent(Graphics g, Theme theme, int width, int height, boolean selected) {
        int lineX;
        int lineWidth = (int)((double)width * this.widthPercentage);
        switch (this.getHorizontalAlignment()) {
            case 4: {
                lineX = 0;
                break;
            }
            case 1: {
                lineX = (width - lineWidth) / 2;
                break;
            }
            default: {
                lineX = width - lineWidth;
            }
        }
        int color = theme.getBorderColor();
        g.setColor(color);
        g.drawLine(lineX, 0, lineX + lineWidth, height - 1);
    }

    protected int[] getPreferredComponentSize(Theme theme, int viewportWidth, int viewportHeight) {
        return new int[]{viewportWidth, this.height};
    }
}

