/*
 * Decompiled with CFR 0.152.
 */
package org.j4me.bluetoothgps;

import java.io.IOException;
import org.j4me.bluetoothgps.BluetoothDeviceDiscovery;
import org.j4me.bluetoothgps.BluetoothLocationProvider;
import org.j4me.bluetoothgps.Criteria;
import org.j4me.bluetoothgps.JSR179LocationProvider;
import org.j4me.bluetoothgps.Location;
import org.j4me.bluetoothgps.LocationException;
import org.j4me.bluetoothgps.LocationListener;
import org.j4me.logging.Log;

public abstract class LocationProvider {
    public static final int AVAILABLE = 1;
    public static final int TEMPORARILY_UNAVAILABLE = 2;
    public static final int OUT_OF_SERVICE = 3;
    private static LocationProvider instance;

    protected LocationProvider() {
    }

    public static String[][] discoverBluetoothDevices() throws IOException, SecurityException {
        String[][] devices = null;
        if (!LocationProvider.supportsBluetoothAPI()) {
            return null;
        }
        BluetoothDeviceDiscovery discoverer = null;
        try {
            discoverer = (BluetoothDeviceDiscovery)Class.forName("org.j4me.bluetoothgps.BluetoothDeviceDiscovery").newInstance();
        }
        catch (Exception e) {
            Log.warn("Cannot discover Bluetooth devices", e);
            return null;
        }
        devices = discoverer.discoverNearbyDeviceNamesAndAddresses();
        return devices;
    }

    public static LocationProvider getInstance(Criteria criteria) throws LocationException, IOException, SecurityException {
        LocationProvider provider = null;
        LocationException localProviderException = null;
        if (criteria.isLocalLBSAllowed() && LocationProvider.supportsLocationAPI()) {
            try {
                provider = JSR179LocationProvider.getInstance(criteria);
            }
            catch (LocationException e) {
                localProviderException = e;
            }
        }
        if (provider == null) {
            try {
                provider = BluetoothLocationProvider.getInstance(criteria);
            }
            catch (LocationException e) {
                if (localProviderException != null) {
                    throw localProviderException;
                }
                throw e;
            }
        }
        instance = provider;
        return provider;
    }

    public static boolean supportsLocationAPI() {
        try {
            Class.forName("javax.microedition.location.LocationProvider");
        }
        catch (Throwable e) {
            return false;
        }
        return true;
    }

    public static boolean supportsBluetoothAPI() {
        try {
            Class.forName("javax.bluetooth.LocalDevice");
        }
        catch (Throwable e) {
            return false;
        }
        return true;
    }

    public abstract int getState();

    public abstract Location getLocation(int var1) throws LocationException, InterruptedException;

    public abstract void setLocationListener(LocationListener var1, int var2, int var3, int var4);

    public abstract void close();

    public abstract void reset() throws IOException;

    public static Location getLastKnownLocation() {
        if (instance == null) {
            return null;
        }
        return instance.getLastKnownLocationToProvider();
    }

    protected abstract Location getLastKnownLocationToProvider();
}

