/*
 * Decompiled with CFR 0.152.
 */
package com.webwag.engine;

import com.webwag.engine.AdElem;
import com.webwag.engine.AnimElem;
import com.webwag.engine.AnimatorElem;
import com.webwag.engine.BufferFile;
import com.webwag.engine.BufferFileListener;
import com.webwag.engine.CompositeElem;
import com.webwag.engine.Element;
import com.webwag.engine.FormElem;
import com.webwag.engine.HtmlView;
import com.webwag.engine.ImageElem;
import com.webwag.engine.ItemElem;
import com.webwag.engine.Language;
import com.webwag.engine.PolyElem;
import com.webwag.engine.RssElem;
import com.webwag.engine.TableElem;
import com.webwag.engine.TextElem;
import com.webwag.engine.TimerElem;
import com.webwag.engine.ViewElem;
import com.webwag.engine.WidgetCanvas;
import com.webwag.engine.WidgetScript;
import com.webwag.engine.WidgetsScriptsStarter;
import com.webwag.engine.WorkerListener;
import com.webwag.jscript.JSException;
import com.webwag.parser.bjsonParser;
import com.webwag.utils.UtilMidp;
import java.io.ByteArrayInputStream;
import java.io.DataInputStream;
import java.io.EOFException;
import java.io.InputStream;
import java.util.Enumeration;
import java.util.Vector;
import javax.microedition.lcdui.Graphics;
import javax.microedition.lcdui.Image;
import net.mobidgets.MenuItem;
import org.kxml2.io.KXmlParser;

/*
 * Duplicate member names - consider using --renamedupmembers true
 */
public class Widget
extends CompositeElem
implements BufferFileListener {
    public static int MIRROR_HEIGHT = 15;
    public int nbListenedFiles = 0;
    public WidgetScript ws;
    public WidgetCanvas wc;
    public String documentBase = "";
    public ViewElem a;
    public boolean isAbsolute = false;
    public boolean isStatic = false;
    public boolean isRemovable = true;
    public boolean isSendable = true;
    public int id;
    public static int a = 0;
    private boolean a = false;
    private boolean b = false;
    public int hilightColor = 0xFF0000;
    public int hilightBgColor = -1;
    public Image imgMirror = null;
    public boolean useTidy = false;
    public boolean startImmediately = true;
    public int nbBlocks = 1;
    public int focusX = -1;
    public int focusY = -1;
    public int focusW = -1;
    public int focusH = -1;
    public boolean m_immediateLoading = false;
    public boolean openWidgetAfterLoading = false;
    public boolean openPrefsAfterLoading = false;
    public Image imgIcon = WidgetCanvas.imgIconBg;
    public boolean hasBeenloaded = false;
    public boolean widgetNeedRefresh = false;
    public boolean closedOnNetworkError = true;
    public boolean scriptStarted = false;
    public boolean onWidgetOpenDone = false;

    public Widget(WidgetCanvas widgetCanvas) {
        this.wc = widgetCanvas;
        this.C = -1;
        this.D = -1;
        this.ws = new WidgetScript(this);
        this.setValue("id", Integer.toString(--a));
    }

    public Widget(String string, WidgetCanvas widgetCanvas) {
        this.wc = widgetCanvas;
        this.ws = new WidgetScript(this);
        this.C = -1;
        this.D = -1;
        if (this.wc.a != null) {
            widgetCanvas.a.c.addElement(this);
            this.setValue("id", Integer.toString(--a));
            this.setValue("width", Integer.toString(WidgetCanvas.DASHBOARD_ICON_SIZE));
            this.setValue("height", Integer.toString(WidgetCanvas.DASHBOARD_ICON_SIZE));
        } else {
            a = 0;
            widgetCanvas.setWidget(this);
        }
        this.loadFile(string);
    }

    public void loadFile(String string) {
        if (string == null) {
            return;
        }
        int n = string.lastIndexOf(47);
        this.documentBase = n != -1 ? string.substring(0, n + 1) : "/";
        BufferFile bufferFile = null;
        if (string.endsWith("root.xml")) {
            bufferFile = BufferFile.getFile(string, null, WidgetCanvas.ROOT_CACHE, false, false);
        } else {
            if (!string.startsWith("http://")) {
                this.b(string);
            }
            bufferFile = BufferFile.getFile(string);
        }
        if (bufferFile.addFileListener(this)) {
            ++this.nbListenedFiles;
        }
    }

    public void startScript() {
        if (!this.hasBeenloaded || this.scriptStarted) {
            return;
        }
        try {
            this.ws.cont();
        }
        catch (JSException jSException) {
            // empty catch block
        }
        this.scriptStarted = true;
    }

    public synchronized void fileLoaded(BufferFile bufferFile) {
        try {
            if (bufferFile.removeFileListener(this)) {
                --this.nbListenedFiles;
            }
            if (bufferFile.buff == null) {
                return;
            }
            ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(bufferFile.buff);
            if (bufferFile.fileName.endsWith("languages.xml")) {
                Language.initLanguagesXML(byteArrayInputStream);
            } else {
                this.hasBeenloaded = true;
                this.initWidgetXML(bufferFile.name, byteArrayInputStream, false);
                if (!this.isRootWidget() && !this.wc.a.contains(this) && this.nbBlocks > 1) {
                    this.wc.setAutoPosition(true);
                }
                this.processAfterInit();
                if (bufferFile.name.startsWith("discovery/mob/discovery") || bufferFile.name.startsWith("time/mob/time") || bufferFile.name.startsWith("search/mob/search") || bufferFile.name.startsWith("ad/mob/ad")) {
                    this.startScript();
                } else if (bufferFile.name.indexOf("startup/mob") != -1) {
                    this.wc.setSelectedWidget(this);
                    this.wc.b.startScript();
                    this.wc.openWidget();
                    WidgetCanvas.fromStartup = true;
                }
                if (this.openPrefsAfterLoading) {
                    this.wc.showView("prefs");
                } else if (!this.m_immediateLoading && this.openWidgetAfterLoading) {
                    this.manageOpenClose(true);
                }
            }
        }
        catch (Exception exception) {
            UtilMidp.debugOutError(bufferFile.name + " " + exception);
        }
    }

    private void a() {
        String string = "#" + this.id + ".";
        Enumeration enumeration = this.wc.a.getProperties().keys();
        while (enumeration.hasMoreElements()) {
            String string2 = (String)enumeration.nextElement();
            if (string2.indexOf(string) == -1) continue;
            String string3 = this.wc.a.getStringProperty(string2, null);
            String string4 = string2.substring(string2.lastIndexOf(46) + 1);
            this.setValue(string4, string3);
        }
    }

    public int getFocusX() {
        return this.focusX != -1 ? this.A + this.focusX : this.A;
    }

    public int getFocusY() {
        return this.focusY != -1 ? this.B + this.focusY : this.B;
    }

    public int getFocusW() {
        return this.focusW != -1 ? this.focusW : this.width;
    }

    public int getFocusH() {
        return this.focusH != -1 ? this.focusH : this.height;
    }

    public void savePos() {
        this.wc.a.setStringProperty("#" + this.id + ".x", Integer.toString(this.A));
        this.wc.a.setStringProperty("#" + this.id + ".y", Integer.toString(this.B));
        this.wc.a.setStringProperty("#" + this.id + ".visible", "" + this.isVisible);
    }

    public boolean isRootWidget() {
        if (this.wc == null) {
            return false;
        }
        return this == this.wc.a;
    }

    public boolean isBackground() {
        return this == this.wc.backgroundWidget || "background".equals(this.name.toLowerCase());
    }

    public boolean isRss() {
        if ("rss".equals(this.name.toLowerCase())) {
            return true;
        }
        String string = (String)this.getValue("src");
        return string.indexOf("rss/mob") != -1 || string.indexOf("widgetCreator/mob") != -1;
    }

    public Element a(String string) {
        Element element = null;
        try {
            if (string.equals("image") || string.equals("img")) {
                element = new ImageElem();
            } else if (string.equals("elem")) {
                element = new Element();
            } else if (string.equals("anim")) {
                element = new AnimElem();
            } else if (string.equals("text")) {
                element = new TextElem();
            } else if (string.equals("poly")) {
                element = new PolyElem();
            } else if (string.equals("html")) {
                element = new HtmlView(WidgetCanvas.htmlBrowser);
            } else if (string.equals("rssReader")) {
                element = new RssElem(WidgetCanvas.htmlBrowser);
            } else if (string.equals("adElem")) {
                element = new AdElem();
            } else if (string.equals("view")) {
                element = new ViewElem();
            } else if (string.equals("style")) {
                element = new Element();
                this.wc.e.addElement(element);
            } else if (string.equals("form")) {
                element = new FormElem(0);
            } else if (string.equals("prefs")) {
                element = new FormElem(0);
            } else if (string.equals("textbox")) {
                element = new FormElem(1);
            } else if (string.equals("pref") || string.equals("input")) {
                element = new ItemElem();
            } else if (string.equals("timer")) {
                element = new TimerElem();
            } else if (string.equals("animator")) {
                element = new AnimatorElem();
            } else if (string.equals("table")) {
                element = new TableElem();
            } else if (string.equals("container")) {
                element = new CompositeElem();
            } else {
                try {
                    element = (Element)Class.forName("com.webwag.plugins." + string).newInstance();
                }
                catch (IllegalAccessException illegalAccessException) {
                    illegalAccessException.printStackTrace();
                }
                catch (InstantiationException instantiationException) {
                    instantiationException.printStackTrace();
                }
                catch (ClassNotFoundException classNotFoundException) {}
            }
        }
        catch (OutOfMemoryError outOfMemoryError) {
            UtilMidp.handleOutOfMemoryError();
        }
        catch (Throwable throwable) {
            if (throwable instanceof OutOfMemoryError) {
                UtilMidp.handleOutOfMemoryError();
            }
            UtilMidp.debugOutError(string + " Widget/Throwable : " + throwable);
        }
        if (element != null) {
            element.setScriptEnv(this.ws.parser);
        }
        return element;
    }

    public Element initWidgetXML(String string, ByteArrayInputStream byteArrayInputStream, boolean bl) {
        Object object;
        block95: {
            object = null;
            if (this.name == null) {
                this.name = string;
            }
            if (byteArrayInputStream == null) {
                UtilMidp.debugOutError("Can not open " + string);
                return null;
            }
            KXmlParser kXmlParser = string != null ? (string.indexOf(".xmb") != -1 ? new bjsonParser() : new KXmlParser()) : new KXmlParser();
            String string2 = null;
            try {
                kXmlParser.setInput(byteArrayInputStream, null);
                kXmlParser.setFeature("http://xmlpull.org/v1/doc/features.html#relaxed", true);
                boolean bl2 = false;
                boolean bl3 = bl;
                CompositeElem compositeElem = this;
                ViewElem viewElem = null;
                String string3 = null;
                int n = 0;
                CompositeElem compositeElem2 = this;
                block12: while (true) {
                    int n2 = kXmlParser.next();
                    switch (n2) {
                        case 2: {
                            Object object2;
                            String string4;
                            Object object3;
                            int n3;
                            Object object4;
                            Object object5;
                            string2 = kXmlParser.getName();
                            if (string2.equals("script")) {
                                try {
                                    if (kXmlParser instanceof bjsonParser) {
                                        object5 = (byte[])((bjsonParser)kXmlParser).getAttributeValue("#val");
                                        if (object5 != null) {
                                            object4 = new ByteArrayInputStream((byte[])object5);
                                            this.ws.getParser().loadProgram((InputStream)object4, bjsonParser.atom);
                                        }
                                    } else {
                                        this.ws.addLines(kXmlParser.nextText());
                                    }
                                }
                                catch (Exception exception) {
                                    exception.printStackTrace();
                                }
                                kXmlParser.nextTag();
                                break;
                            }
                            object5 = null;
                            if (string2.equals("widget")) {
                                bl2 = true;
                                if (bl3) {
                                    Object object6;
                                    object4 = kXmlParser.getAttributeValue(null, "id");
                                    n3 = "true".equals(kXmlParser.getAttributeValue(null, "forceDownload"));
                                    object3 = kXmlParser.getAttributeValue(null, "src");
                                    if (object4 != null && this.wc.widgetsPool != null) {
                                        int n4 = Widget.getInt(object4);
                                        int n5 = this.wc.a.c.size();
                                        for (int i = 0; i < n5; ++i) {
                                            boolean bl4;
                                            object6 = (Widget)this.wc.a.c.elementAt(i);
                                            if (object6 == null || n4 != ((Widget)object6).id) continue;
                                            this.wc.widgetsPool.removeElement(object6);
                                            string4 = (String)((CompositeElem)object6).getValue("src");
                                            boolean bl5 = bl4 = string4 != null && !string4.equals(object3);
                                            if (n3 != 0 || bl4) {
                                                object5 = null;
                                                ((Widget)object6).delete();
                                                this.wc.a.c.removeElementAt(i);
                                                break;
                                            }
                                            object5 = object6;
                                            object5.setValue("needsRefresh", "true");
                                            break;
                                        }
                                    }
                                    if (object5 == null) {
                                        object5 = new Widget(null, this.wc);
                                        if (object4 != null) {
                                            object5.setValue("id", object4);
                                        }
                                    }
                                    object = object5;
                                    object2 = kXmlParser.getAttributeValue(null, "name");
                                    String string5 = object2 == null ? string : object2.toString().toLowerCase();
                                    object5.setValue("name", string5);
                                    if (!bl) {
                                        object6 = null;
                                        object6 = kXmlParser.getAttributeValue(null, "immediate");
                                        object5.setValue("immediate", object6);
                                        if ("true".equals(kXmlParser.getAttributeValue(null, "icon_need_refresh"))) {
                                            object5.setValue("icon_need_refresh", "true");
                                        }
                                        if (!Widget.getBoolean(object6)) {
                                            object6 = kXmlParser.getAttributeValue(null, "nb_blocks");
                                            if (object6 != null && Widget.getInt(object6) > 1) {
                                                object5.setValue("nb_blocks", object6);
                                            }
                                            ((Widget)object5).loadIconDashboard(false, ((Widget)object5).widgetNeedRefresh);
                                        }
                                    }
                                } else {
                                    object5 = this;
                                }
                            } else if (string2.equals("widgets")) {
                                this.c.removeAllElements();
                                object5 = this;
                                bl3 = true;
                                this.width = WidgetCanvas.canvasWidth;
                                this.height = WidgetCanvas.canvasHeight;
                                WidgetCanvas.twitterList.removeAllElements();
                                this.wc.a.removeAllElements();
                            } else if (string2.equals("menu")) {
                                if (compositeElem instanceof ViewElem && !(compositeElem instanceof HtmlView) && !(compositeElem instanceof FormElem)) {
                                    viewElem = (ViewElem)compositeElem;
                                    string3 = kXmlParser.getAttributeValue(null, "label");
                                    if (string3 != null) {
                                        if (n == 0) {
                                            viewElem.q = string3;
                                        } else if (UtilMidp.isRIM()) {
                                            viewElem.b.addElement(new MenuItem("--- " + string3 + " ---", 8, 2, WidgetCanvas.GLOBAL_FONT_SIZE));
                                        } else {
                                            viewElem.b.addElement(new MenuItem(string3, 1, 2, WidgetCanvas.GLOBAL_FONT_SIZE));
                                        }
                                    }
                                    ++n;
                                }
                            } else if (string2.equals("item")) {
                                if (viewElem != null) {
                                    object4 = kXmlParser.getAttributeValue(null, "name");
                                    Object object7 = kXmlParser.getAttributeValue(null, "label");
                                    if (object7 == null) {
                                        object7 = object4;
                                    }
                                    if (object4 != null) {
                                        if (UtilMidp.isRIM()) {
                                            viewElem.b.addElement(new MenuItem((String)object7, 8, 2, WidgetCanvas.GLOBAL_FONT_SIZE));
                                        } else {
                                            viewElem.b.addElement(new MenuItem((String)object7, 8, object7 != null ? 2 : 1, WidgetCanvas.GLOBAL_FONT_SIZE));
                                        }
                                        viewElem.a.put(object7, object4);
                                    }
                                }
                            } else if (bl2) {
                                object5 = this.a(string2);
                            }
                            if (object5 == null) continue block12;
                            if (object5 instanceof ViewElem && !(object5 instanceof FormElem)) {
                                compositeElem2 = (ViewElem)object5;
                                if (this.a == null) {
                                    this.a = (ViewElem)object5;
                                }
                            }
                            if (!(object5 instanceof Widget) && !string2.equals("style")) {
                                compositeElem.c.addElement(object5);
                                object5.name = this.name + "_" + string2;
                                if (object5 instanceof ItemElem) {
                                    ((ItemElem)object5).a = compositeElem.name.equals("prefs");
                                }
                            }
                            object5.parent = compositeElem;
                            object5.topParent = compositeElem2;
                            object5.w = this;
                            if (object5 instanceof CompositeElem) {
                                compositeElem = (CompositeElem)object5;
                            }
                            object4 = null;
                            if (object5 instanceof Widget) {
                                ((Widget)object5).a();
                            }
                            for (n3 = 0; n3 < kXmlParser.getAttributeCount(); ++n3) {
                                Object object8;
                                object3 = kXmlParser.getAttributeName(n3);
                                object2 = kXmlParser.getAttributeValue(n3);
                                if ("version".equals(object3) && ((String)object2).indexOf(",") != -1) {
                                    object2 = ((String)object2).replace(',', '.');
                                }
                                boolean bl6 = false;
                                boolean bl7 = false;
                                if (object5 instanceof Widget) {
                                    Object object9;
                                    String string6 = "#" + ((Widget)object5).id + ".";
                                    string4 = string6 + (String)object3;
                                    FormElem formElem = (FormElem)((Widget)object5).findByName("prefs");
                                    if (formElem != null) {
                                        object9 = formElem.c.elements();
                                        while (object9.hasMoreElements()) {
                                            String string7;
                                            ItemElem itemElem = (ItemElem)object9.nextElement();
                                            if (!itemElem.a || !(string7 = itemElem.name).equals(object3)) continue;
                                            itemElem.setValue("value", object2);
                                            bl7 = true;
                                            break;
                                        }
                                    }
                                    if ((object9 = this.wc.a.getStringProperty(string4, null)) != null && !((String)object3).equals("x") && !((String)object3).equals("y")) {
                                        bl6 = true;
                                    }
                                } else if (object5 instanceof ItemElem && "value".equals(object3) && ((ItemElem)object5).a && (object8 = this.w.getValue(object5.name)) != null && object8 instanceof String) {
                                    object5.setValue("value", object8);
                                    this.w.setValue(object5.name, null);
                                    bl7 = true;
                                }
                                if (bl6 || bl7) continue;
                                if (((String)object3).equals("src")) {
                                    if (object5 instanceof Widget) {
                                        String string8 = (String)object5.getValue("src");
                                        if (string8 != null && string8.equals(object2)) continue;
                                        object4 = object2;
                                        if (object5.name != null && !"".equals(object5.name)) continue;
                                        int n6 = ((String)object4).lastIndexOf(47);
                                        if (n6 == -1) {
                                            object5.name = object4;
                                            continue;
                                        }
                                        if (((String)object4).startsWith("http://")) {
                                            object5.name = ((String)object4).substring(n6);
                                            object5.name = object5.name.substring(0, object5.name.length() - 4);
                                            continue;
                                        }
                                        object5.name = ((String)object4).substring(0, n6);
                                        continue;
                                    }
                                    object4 = object2;
                                    continue;
                                }
                                if (!bl3 && object5 instanceof Widget && ("x".equals(object3) || "y".equals(object3))) continue;
                                if (object5.parent == object5 && ("width".equals(object3) || "height".equals(object3))) {
                                    int n7 = WidgetCanvas.DASHBOARD_ICON_SIZE;
                                    if ("width".equals(object3)) {
                                        n7 = WidgetCanvas.DASHBOARD_ICON_SIZE * ((Widget)object5).nbBlocks + (WidgetCanvas.spaceWidthBetweenIcon + 2) * (((Widget)object5).nbBlocks - 1);
                                    }
                                    this.setValue((String)object3, new Integer(n7));
                                    continue;
                                }
                                object5.setValue((String)object3, object2);
                            }
                            if (object5 instanceof FormElem) {
                                if (object5.name.endsWith("prefs")) {
                                    object5.name = "prefs";
                                }
                            } else if (object5 instanceof ItemElem) {
                                ((ItemElem)object5).buildListLabel();
                            }
                            if (object4 != null) {
                                object5.setValue("src", object4);
                                if (object5 instanceof Widget && this.m_immediateLoading) {
                                    ((Widget)object5).loadSrc();
                                }
                            }
                            object5.p = true;
                            break;
                        }
                        case 4: {
                            break;
                        }
                        case 3: {
                            Object object2;
                            string2 = kXmlParser.getName();
                            if (string2.equals("script")) continue block12;
                            if (string2.equals("view") || string2.equals("html") || string2.equals("rssReader") || string2.equals("form") || string2.equals("prefs") || string2.equals("map") || string2.equals("textbox")) {
                                compositeElem = this.parent;
                                compositeElem2 = this;
                                break;
                            }
                            if (string2.equals("form") || string2.equals("prefs") || string2.equals("textbox")) {
                                compositeElem = this.parent;
                                break;
                            }
                            if (string2.equals("table")) {
                                compositeElem = compositeElem.parent;
                                break;
                            }
                            if (string2.equals("container")) {
                                compositeElem = compositeElem.parent;
                                break;
                            }
                            if (string2.equals("menu")) {
                                if (string3 != null) {
                                    string3 = null;
                                    if (viewElem != null) {
                                        if (UtilMidp.isRIM()) {
                                            viewElem.b.addElement(new MenuItem("--------------", 8, 2, WidgetCanvas.GLOBAL_FONT_SIZE));
                                        } else {
                                            viewElem.b.addElement(new MenuItem("", 6, 2, WidgetCanvas.GLOBAL_FONT_SIZE));
                                        }
                                    }
                                } else {
                                    viewElem = null;
                                }
                                --n;
                                break;
                            }
                            if (string2.equals("widget")) {
                                bl2 = false;
                                break;
                            }
                            if (!string2.equals("widgets")) break;
                            bl3 = false;
                            Object object5 = null;
                            Object object4 = null;
                            String string9 = null;
                            Object object3 = this.c.elements();
                            while (object3.hasMoreElements()) {
                                object5 = (Widget)object3.nextElement();
                                object4 = object5.name != null ? object5.name.toLowerCase() : null;
                                string9 = (String)object5.getValue("src");
                                if ("myFriends".equals(object4) || "myFriends/mob/myFriends.xml".equals(object4) || "myFriends/mob/myFriends.xml".equals(string9)) {
                                    this.wc.f = object5;
                                    continue;
                                }
                                if ("background".equals(object4) || "background/mob/background.xml".equals(object4) || "background/mob/background.xml".equals(string9)) {
                                    this.wc.createBackgroundWidget((Widget)object5);
                                    continue;
                                }
                                if (!"twitter".equals(object4) && !"twitter/mob/twitter.xml".equals(object4) && !"twitter/mob/twitter.xml".equals(string9)) continue;
                                object5.setValue("src", "twitter/mob/twitter.xml");
                                WidgetCanvas.twitterList.addElement(object5);
                                if (this.wc.twitterId != -1) {
                                    if (this.wc.twitterId != object5.id) continue;
                                    this.wc.j = object5;
                                    continue;
                                }
                                if (!Widget.getBoolean(object5.getValue("twitterUsed"))) continue;
                                this.wc.j = object5;
                            }
                            if (this.wc.j == null) {
                                int n8 = Integer.MAX_VALUE;
                                object2 = null;
                                for (int i = 0; i < WidgetCanvas.twitterList.size(); ++i) {
                                    object2 = (Widget)WidgetCanvas.twitterList.elementAt(i);
                                    if (((Widget)object2).id >= n8) continue;
                                    this.wc.j = object2;
                                    n8 = ((Widget)object2).id;
                                }
                            }
                            this.wc.twitterId = -1;
                            this.wc.a.setIntProperty("twitterID", this.wc.twitterId);
                            this.wc.a.save(false);
                            break;
                        }
                        case 1: {
                            for (int i = 0; i < this.wc.a.size(); ++i) {
                                this.c.removeElement(this.wc.a.elementAt(i));
                            }
                            if (!WidgetsScriptsStarter.delayStartOfScripts && string != null && !string.startsWith("background/mob/background")) {
                                this.startScript();
                            }
                            return object;
                        }
                    }
                }
            }
            catch (OutOfMemoryError outOfMemoryError) {
                UtilMidp.handleOutOfMemoryError();
            }
            catch (Exception exception) {
                UtilMidp.debugOutError("Exception for Widget : " + this.name + "\nMethod : initWidgetXML\nPath : " + string + "\nTag : " + string2 + "\nError : " + exception);
                exception.printStackTrace();
            }
            catch (Throwable throwable) {
                UtilMidp.debugOutError("Throwable for Widget : " + this.name + "\nMethod : initWidgetXML\nPath : " + string + "\nTag : " + string2 + "\nError : " + throwable);
                throwable.printStackTrace();
                if (!(throwable instanceof OutOfMemoryError)) break block95;
                UtilMidp.handleOutOfMemoryError();
            }
        }
        return object;
    }

    public void a(TimerElem timerElem) {
        try {
            if (this.parent.isVisible) {
                Vector vector = new Vector(1);
                Object object = timerElem.getValue("onTimer");
                if (object != null) {
                    this.ws.parser.parse((String)object);
                } else {
                    this.ws.callScriptFunctionNoThrow("onTimerFired", vector);
                }
                this.repaint();
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public String readLine(DataInputStream dataInputStream) {
        StringBuffer stringBuffer = new StringBuffer();
        try {
            byte by;
            do {
                if ((by = dataInputStream.readByte()) < 0) {
                    by = (byte)(by + 256);
                }
                stringBuffer.append((char)by);
            } while ((char)by != '\n');
        }
        catch (EOFException eOFException) {
            return null;
        }
        catch (Exception exception) {
            return null;
        }
        return stringBuffer.toString();
    }

    public StringBuffer buildDescriptionString(StringBuffer stringBuffer, boolean bl) {
        if (this == this.wc.a) {
            boolean bl2;
            stringBuffer.append("root=<widgets");
            if (bl && (bl2 = bl)) {
                stringBuffer.append(WidgetCanvas.m_midlet.getStatEngine());
            }
            stringBuffer.append(">\n");
            Vector<String> vector = new Vector<String>(1);
            Widget widget = null;
            for (int i = 0; i < this.wc.a.size(); ++i) {
                widget = (Widget)this.wc.a.elementAt(i);
                if (widget == null) continue;
                try {
                    widget.buildDescriptionString(stringBuffer, bl);
                    continue;
                }
                catch (Exception exception) {
                    vector.addElement("Sync error with " + widget.name + " id : " + widget.id + " cause : " + exception.toString());
                }
            }
            Enumeration enumeration = this.c.elements();
            while (enumeration.hasMoreElements()) {
                Widget widget2 = (Widget)enumeration.nextElement();
                try {
                    widget2.buildDescriptionString(stringBuffer, bl);
                }
                catch (Exception exception) {
                    vector.addElement("Sync error with " + widget2.name + " id : " + widget2.id + " cause : " + exception.toString());
                    exception.printStackTrace();
                }
            }
            if (bl) {
                stringBuffer.append("<errors>\n");
                enumeration = vector.elements();
                while (enumeration.hasMoreElements()) {
                    stringBuffer.append("<error>");
                    stringBuffer.append(enumeration.nextElement().toString());
                    stringBuffer.append("</error>\n");
                }
                stringBuffer.append("</errors>\n");
                vector.removeAllElements();
                vector = null;
            }
            stringBuffer.append("</widgets>");
            if (bl) {
                WidgetCanvas.m_midlet.resetStartTime();
            }
        } else if (this.name != null && !this.name.equals("sys")) {
            FormElem formElem;
            Object object;
            Object object2;
            StringBuffer stringBuffer2 = new StringBuffer();
            stringBuffer2.append("<widget name=\"" + this.name);
            Object object3 = this.getValue("src");
            if (object3 != null && !"".equals(object3)) {
                stringBuffer2.append("\" src=\"" + (String)object3);
                if (object3.equals("twitter/mob/twitter.xml")) {
                    stringBuffer2.append("\" twitterUsed=\"" + (this.wc.j != null && this.id == this.wc.j.id));
                }
            }
            if (!bl && this.m_immediateLoading) {
                stringBuffer2.append("\" immediate=\"" + this.m_immediateLoading);
            }
            stringBuffer2.append("\" nb_blocks=\"" + this.nbBlocks);
            if (this.wc.a.contains(this) || this.isBackground() || !bl) {
                stringBuffer2.append("\" x=\"" + this.A + "\"" + " y=\"" + this.B + "\"");
            } else {
                stringBuffer2.append("\" x=\"0\" y=\"" + ((this.B << 3) + this.A) + "\"");
            }
            Object object4 = this.getValue("id");
            if (object4 != null) {
                int n = Widget.getInt(object4);
                stringBuffer2.append(" id=\"" + n + "\"");
            }
            if ((object2 = this.wc.a.getStringProperty(String.valueOf(this.id), null)) == null) {
                object2 = this.getValue("version");
            }
            if (object2 != null) {
                stringBuffer2.append(" version=\"" + object2 + "\"");
            }
            if ((object = this.getValue("type")) != null) {
                stringBuffer2.append(" type=\"" + object + "\"");
            }
            if (this.w == null) {
                this.w = this;
            }
            if ((formElem = (FormElem)this.findByName("prefs")) != null) {
                Enumeration enumeration = formElem.c.elements();
                while (enumeration.hasMoreElements()) {
                    Object object5;
                    ItemElem itemElem = (ItemElem)enumeration.nextElement();
                    if (!itemElem.a || itemElem.b || (object5 = itemElem.getValue("value")) == null) continue;
                    if (object5 instanceof String) {
                        String string = (String)object5;
                        if (!string.startsWith("http://")) {
                            string = UtilMidp.encode_entities(string);
                        }
                        string = UtilMidp.urlEncode(string);
                        stringBuffer2.append(" " + itemElem.name + "=\"" + string + "\"");
                        continue;
                    }
                    stringBuffer2.append(" " + itemElem.name + "=\"" + object5 + "\"");
                }
            }
            if (bl) {
                stringBuffer2.append(WidgetCanvas.m_midlet.getStatWidget(Widget.getInt(object4)));
            }
            stringBuffer2.append(" />\n");
            stringBuffer.append((Object)stringBuffer2);
        }
        return stringBuffer;
    }

    public void loadIconDashboard(boolean bl, boolean bl2) {
        if (this.id > 0) {
            BufferFile bufferFile;
            if ("background".equals(this.name)) {
                return;
            }
            String string = this.a(WidgetCanvas.proxyIcon + this.id + "&size=" + WidgetCanvas.DASHBOARD_ICON_SIZE + "&nbBlocks=" + this.nbBlocks + "&config=mobile&interval=" + (WidgetCanvas.spaceWidthBetweenIcon + 2));
            if (bl2) {
                string = string + "&cacheTime=-1000";
                BufferFile.remove(string);
            }
            if ((bufferFile = BufferFile.loadImage(string, false)).addFileListener(new BufferFileListener(this, bl){
                private final boolean a;
                private final Widget a;
                {
                    this.a = widget;
                    this.a = bl;
                }

                public void fileLoaded(BufferFile bufferFile) {
                    if (bufferFile.removeFileListener(this)) {
                        --this.a.nbListenedFiles;
                    }
                    this.a.imgIcon = bufferFile.getImage() == null || bufferFile.getImage() == WidgetCanvas.imgUnavailable ? WidgetCanvas.imgIconBgError : bufferFile.getImage();
                    this.a.setValue("width", new Integer(this.a.imgIcon.getWidth()));
                    if (!WidgetCanvas.modifyingRoot) {
                        this.a.wc.resetPositions(this.a);
                    }
                }
            })) {
                ++this.nbListenedFiles;
            }
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean setValue(String string, Object object) {
        if (string.equals("mode")) {
            Vector vector = UtilMidp.explode((String)object, ",");
            Enumeration enumeration = vector.elements();
            while (enumeration.hasMoreElements()) {
                String string2 = (String)enumeration.nextElement();
                if (string2.equals("static")) {
                    this.isStatic = true;
                    continue;
                }
                if (!string2.equals("absolute")) continue;
                this.isAbsolute = true;
            }
            return true;
        }
        if (string.equals("nb_blocks")) {
            this.nbBlocks = Widget.getInt(object);
            if (this.nbBlocks > WidgetCanvas.gridNbCol) {
                this.nbBlocks = WidgetCanvas.gridNbCol;
                return true;
            } else {
                if (this.nbBlocks != 0) return true;
                this.nbBlocks = 1;
            }
            return true;
        }
        if (string.equals("removable")) {
            this.isRemovable = Widget.getBoolean(object);
            return true;
        }
        if (string.equals("sendable")) {
            this.isSendable = Widget.getBoolean(object);
            return true;
        }
        if (string.equals("id")) {
            this.id = Widget.getInt(object);
            return super.setValue(string, object);
        } else {
            if (string.equals("immediate")) {
                this.m_immediateLoading = Widget.getBoolean(object);
                return true;
            }
            if (string.equals("icon_need_refresh")) {
                this.widgetNeedRefresh = Widget.getBoolean(object);
                return true;
            }
            if (string.equals("closedOnNetworkError")) {
                this.closedOnNetworkError = Widget.getBoolean(object);
                return true;
            }
            if (string.equals("feed_name")) {
                return super.setValue("title", object);
            }
            if (string.equals("src")) {
                super.setValue("src", object);
                if (!this.m_immediateLoading || object == null) return super.setValue(string, object);
                this.loadSrc();
                return super.setValue(string, object);
            } else if (string.equals("forceDownload")) {
                this.a = Widget.getBoolean(object);
                return super.setValue(string, object);
            } else if (string.equals("noConvert")) {
                this.b = Widget.getBoolean(object);
                return super.setValue(string, object);
            } else if (string.equals("view")) {
                try {
                    this.a = (ViewElem)this.findByName((String)object);
                    return super.setValue(string, object);
                }
                catch (Exception exception) {}
                return super.setValue(string, object);
            } else {
                if (string.equals("hilightColor")) {
                    this.hilightColor = UtilMidp.parseColor((String)object);
                    return true;
                }
                if (string.equals("hilightBgColor")) {
                    this.hilightBgColor = UtilMidp.parseColor((String)object);
                    return true;
                }
                if (string.equals("counter")) {
                    return super.setValue("counter", object instanceof Integer ? ((Integer)object).toString() : (String)object);
                }
                if (string.equals("useTidy")) {
                    this.useTidy = Widget.getBoolean((String)object);
                    return true;
                }
                if (string.equals("version")) {
                    String string3 = this.wc.a.getStringProperty(String.valueOf(this.id), null);
                    if (string3 != null || "".equals(string3)) {
                        if (!UtilMidp.compareDouble(string3, object)) return true;
                        this.wc.a.setStringProperty(String.valueOf(this.id), String.valueOf(object));
                        this.wc.a.save(true);
                        return super.setValue(string, object);
                    } else {
                        this.wc.a.setStringProperty(String.valueOf(this.id), String.valueOf(object));
                        this.wc.a.save(true);
                    }
                    return super.setValue(string, object);
                } else {
                    if (string.equals("focusX")) {
                        this.focusX = Widget.getInt(object);
                        return true;
                    }
                    if (string.equals("focusY")) {
                        this.focusY = Widget.getInt(object);
                        return true;
                    }
                    if (string.equals("focusW")) {
                        this.focusW = Widget.getInt(object);
                        return true;
                    }
                    if (!string.equals("focusH")) return super.setValue(string, object);
                    this.focusH = Widget.getInt(object);
                    return true;
                }
            }
        }
    }

    private void b(String string) {
        int n = string.lastIndexOf(47);
        String string2 = n != -1 ? string.substring(0, n) : "";
        BufferFile bufferFile = BufferFile.getFile(string2 = string2 + "/languages.xml");
        if (bufferFile.addFileListener(this)) {
            ++this.nbListenedFiles;
        }
    }

    public void loadSrc() {
        if (this.hasBeenloaded) {
            return;
        }
        String string = (String)this.getValue("src");
        int n = string.lastIndexOf(47);
        String string2 = this.documentBase = n != -1 ? string.substring(0, n + 1) : "/";
        if (this.name == null) {
            this.name = string;
        }
        String string3 = null;
        if (this.a && !string.startsWith("http://") && !string.startsWith("https://")) {
            if (string.startsWith("/")) {
                string = string.substring(1);
            }
            string3 = string;
            string = WidgetCanvas.widgetServer + string;
        }
        this.a = false;
        if (!string.equals("root.xml")) {
            int n2 = string.indexOf("/mob/v");
            if (n2 != -1 && WidgetCanvas.widgetEmbedded.contains(string.substring(0, n2))) {
                int n3 = string.indexOf("/", n2 + "/mob/v".length());
                string = string.substring(0, n2 + "/mob".length()) + string.substring(n3, string.length());
            }
            if (string.startsWith("http://")) {
                if (string.indexOf(".xml") != -1) {
                    string = this.binarizeXML(string);
                }
            } else {
                this.b(string);
                InputStream inputStream = null;
                int n4 = string.indexOf(".xml");
                inputStream = this.getClass().getResourceAsStream("/" + string);
                if (inputStream == null) {
                    if (n4 == -1) {
                        n4 = string.indexOf(".xmb");
                    } else {
                        string = string.substring(0, n4) + ".xmb";
                    }
                    inputStream = this.getClass().getResourceAsStream("/" + string);
                    if (inputStream == null && n4 != -1) {
                        string = WidgetCanvas.widgetServer + string.substring(0, n4) + ".xml";
                        string = this.binarizeXML(string);
                    }
                }
            }
        }
        BufferFile bufferFile = BufferFile.getFile(string);
        if (string3 != null) {
            bufferFile.fileName = string3;
        }
        if (bufferFile.addFileListener(this)) {
            ++this.nbListenedFiles;
        } else {
            this.onWidgetOpenDone = true;
        }
    }

    public String binarizeXML(String string) {
        if (!this.b) {
            if (!"".equals(WidgetCanvas.proxyTranslation)) {
                string = WidgetCanvas.proxyTranslation + "?url=" + string + "&lang=" + Language.languageStr;
            }
            string = WidgetCanvas.proxyBinarize + UtilMidp.urlEncode(string) + "&type=.xmb";
        } else if (!"".equals(WidgetCanvas.proxyTranslation)) {
            string = WidgetCanvas.proxyTranslation + "?url=" + string + "&lang=" + Language.languageStr;
        }
        return string;
    }

    public boolean isIconDashboard(Element element) {
        if (!element.isOnDashboard()) {
            return false;
        }
        if (this.isBackground()) {
            return false;
        }
        if (!this.w.wc.a.c.contains(this)) {
            return false;
        }
        return element == this.c.elementAt(0);
    }

    private void a(Graphics graphics, int n, int n2) {
        for (int i = 0; i < this.c.size(); ++i) {
            try {
                Element element = (Element)this.c.elementAt(i);
                if (!element.isVisible || element instanceof ViewElem) continue;
                element.paint(graphics, n, n2);
                continue;
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    public void paint(Graphics graphics, int n, int n2) {
        int n3;
        Object object;
        if (!this.isVisible) {
            return;
        }
        if (this.isAbsolute) {
            n = 0;
            n2 = 0;
        }
        if (WidgetCanvas.modifyingRoot && this.wc.saveWidgetsPositions != null && (object = (int[])this.wc.saveWidgetsPositions.get(new Integer(this.id))) != null) {
            this.A = object[0];
            this.B = object[1];
        }
        n += this.A;
        n2 += this.B;
        if (this.wc.a.c.contains(this)) {
            if (this.nbBlocks > 1) {
                graphics.drawRegion(WidgetCanvas.imgIconBg, 0, 0, 4, WidgetCanvas.imgIconBg.getHeight(), 0, n - 1, n2 - 1, 20);
                graphics.drawRegion(WidgetCanvas.imgIconBg, WidgetCanvas.imgIconBg.getWidth() - 4, 0, 4, WidgetCanvas.imgIconBg.getHeight(), 0, n + this.width - 3, n2 - 1, 20);
                int n4 = 0;
                n3 = n + 3;
                for (int i = this.width - 6; i > 0; i -= n4) {
                    n4 = i > 42 ? 42 : i;
                    graphics.drawRegion(WidgetCanvas.imgIconBg, 4, 0, n4, WidgetCanvas.imgIconBg.getHeight(), 0, n3, n2 - 1, 20);
                    n3 += n4;
                }
            } else {
                graphics.drawImage(WidgetCanvas.imgIconBg, n - 1, n2 - 1, 20);
            }
            if (this.D != -1) {
                graphics.setColor(this.D);
                graphics.fillRect(n, n2, this.width, this.height);
            }
        }
        if (!this.hasBeenloaded) {
            graphics.drawImage(this.imgIcon, n, n2, 20);
        } else if (!this.m_immediateLoading && !this.isBackground()) {
            graphics.drawImage(this.imgIcon, n, n2, 20);
        } else {
            if (this.imgIcon != WidgetCanvas.imgIconBgError && this.imgIcon != WidgetCanvas.imgIconBg) {
                graphics.drawImage(this.imgIcon, n, n2, 20);
            }
            this.a(graphics, n, n2);
        }
        if (this.wc.a.c.contains(this)) {
            object = this.getValue("hasNewContent");
            this.wc.displayMaskIconAndCounter(graphics, n, n2, this.width, (String)this.getValue("counter"), object == null ? false : Widget.getBoolean(object));
        }
        if (this.nbListenedFiles > 0 && WidgetCanvas.displayWidgetArrows) {
            int n5 = n + (this.width - 12 >> 1);
            n3 = n2 + (this.height - 12 >> 1);
            UtilMidp.drawRegion(graphics, WidgetCanvas.widgetActivityImage, WidgetCanvas.widgetActivityIndicatorFrame * 12, 0, 12, 12, n5, n3, 20);
        }
    }

    public void updateMirror() {
        if (this.wc.f.indexOf(this) != -1) {
            this.imgMirror = null;
        }
    }

    public void paintMirror(Graphics graphics, int n, int n2, int n3) {
        if (this.imgMirror == null) {
            Image image = Image.createImage((int)this.width, (int)this.height);
            Graphics graphics2 = image.getGraphics();
            graphics2.setColor(n);
            graphics2.fillRect(0, 0, this.width, this.height);
            this.a(graphics2, 0, 0);
            int[] nArray = new int[image.getWidth() * MIRROR_HEIGHT];
            image.getRGB(nArray, 0, image.getWidth(), 0, image.getHeight() - MIRROR_HEIGHT, image.getWidth(), MIRROR_HEIGHT);
            UtilMidp.blend(nArray, 10, -1, -1, image.getWidth(), 8);
            this.imgMirror = Image.createRGBImage((int[])nArray, (int)image.getWidth(), (int)MIRROR_HEIGHT, (boolean)true);
            nArray = null;
        }
        graphics.drawRegion(this.imgMirror, 0, this.imgMirror.getHeight() - MIRROR_HEIGHT, this.imgMirror.getWidth(), MIRROR_HEIGHT, 1, n2 + this.A, n3 + this.B + WidgetCanvas.DASHBOARD_ROUNDED_ICON_SIZE, 20);
    }

    public void setSel(boolean bl) {
        this.isSel = bl;
    }

    public void refresh() {
        this.ws.callScriptFunctionNoThrow("onRefresh", new Vector(1));
    }

    public void onViewChange(boolean bl) {
        try {
            Object object;
            this.wc.a.isVisible = bl;
            if (bl) {
                this.wc.a.openView();
                this.wc.addMenuCommandView();
                this.pauseOrRestartTimer(this.wc.a, false);
                if (this.wc.a != WidgetCanvas.a) {
                    this.wc.a.a = System.currentTimeMillis();
                }
            } else {
                this.pauseOrRestartTimer(this.wc.a, true);
                this.wc.releaseMenuCommandView();
                this.wc.a.closeView();
                if (this.wc.a != WidgetCanvas.a) {
                    object = this.wc.b.id + "_" + this.wc.a.name + "_s";
                    WidgetCanvas.m_midlet.saveStat((String)object, WidgetCanvas.m_midlet.loadStat((String)object) + 1);
                    object = this.wc.b.id + "_" + this.wc.a.name + "_d";
                    int n = WidgetCanvas.m_midlet.loadStat((String)object);
                    n = (int)((long)n + (System.currentTimeMillis() - this.wc.a.a) / 1000L);
                    WidgetCanvas.m_midlet.saveStat((String)object, n);
                }
            }
            object = new Vector<Object>(2);
            ((Vector)object).addElement(this.wc.a.name);
            ((Vector)object).addElement(new Boolean(this.wc.a.isVisible));
            this.ws.callScriptFunctionNoThrow(this.ws.functionExists("onStateChange") ? "onStateChange" : "onViewStateChange", (Vector)object);
            if (bl && this.wc.a.a == null) {
                this.wc.a.nextFocusable(1, false);
            }
            if (this.wc.a.isVisible) {
                this.wc.a.loadAllImages();
            } else {
                this.wc.a.unloadAllImages();
            }
            this.wc.repaint();
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    public void manageOpenClose(boolean bl) {
        this.isSel = bl;
        this.onWidgetOpenDone = false;
        if (bl) {
            if (this.ws.functionExists("onSelected")) {
                Vector<String> vector = new Vector<String>(1);
                vector.addElement("true");
                this.ws.callScriptFunctionNoThrow("onSelected", vector);
            } else if (this.ws.functionExists("onWidgetOpen")) {
                Vector vector = new Vector(1);
                this.ws.callScriptFunctionNoThrow("onWidgetOpen", vector);
            } else if (this.a != null) {
                this.wc.a(this.a);
            }
            this.onWidgetOpenDone = true;
        } else if (this.ws.functionExists("onSelected")) {
            Vector<boolean> vector = new Vector<boolean>(1);
            vector.addElement(b);
            this.ws.callScriptFunctionNoThrow("onSelected", vector);
        } else if (this.ws.functionExists("onWidgetClose")) {
            Vector vector = new Vector(1);
            this.ws.callScriptFunctionNoThrow("onWidgetClose", vector);
        }
        this.wc.repaint();
    }

    private void b() {
        this.nbListenedFiles = 0;
        this.documentBase = "";
        this.a = null;
        this.isAbsolute = false;
        this.isStatic = false;
        this.isRemovable = true;
        this.isSendable = true;
        this.a = false;
        this.b = false;
        this.hilightColor = 0xFF0000;
        this.hilightBgColor = -1;
        this.imgMirror = null;
        this.useTidy = false;
        this.startImmediately = true;
        this.nbBlocks = 1;
        this.focusX = -1;
        this.focusY = -1;
        this.focusW = -1;
        this.focusH = -1;
        this.m_immediateLoading = false;
        this.openWidgetAfterLoading = false;
        this.openPrefsAfterLoading = false;
        this.hasBeenloaded = false;
        this.widgetNeedRefresh = false;
        this.scriptStarted = false;
    }

    public void clear() {
        this.b();
        this.a = null;
        super.delete();
    }

    public void delete() {
        this.b();
        super.delete();
        this.wc.deleteWidgetProperties(this.id);
        this.wc = null;
        this.ws.close();
        this.ws = null;
    }

    public void processAfterInit() {
        Enumeration enumeration = this.c.elements();
        while (enumeration.hasMoreElements()) {
            Element element = (Element)enumeration.nextElement();
            element.processAfterInit();
        }
    }

    public void pauseOrRestartTimer(CompositeElem compositeElem, boolean bl) {
        Enumeration enumeration = compositeElem.c.elements();
        while (enumeration.hasMoreElements()) {
            Element element = (Element)enumeration.nextElement();
            if (!(element instanceof WorkerListener)) continue;
            if (bl) {
                ((WorkerListener)((Object)element)).pause();
                continue;
            }
            ((WorkerListener)((Object)element)).restart();
        }
    }
}

